/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;

public class ClassAnalyzer {
    private static Logger log = Logger.getLogger((String)"classAnalyzer");

    public ParameterInfo[] getParameters(String methodName, Class<?> c) {
        ParameterInfo[] parameters = null;
        try {
            ClassReader cr = new ClassReader(c.getName().replace('.', '/'));
            Method[] methods = c.getDeclaredMethods();
            if (methods != null) {
                AnalyzerClassVisitor cn = null;
                for (int i = 0; i < methods.length; ++i) {
                    if (!methodName.equals(methods[i].getName())) continue;
                    cn = new AnalyzerClassVisitor(methods[i]);
                    break;
                }
                if (cn != null) {
                    cr.accept(cn, 0);
                    parameters = cn.getParameters();
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"Cannot read class", (Throwable)e);
        }
        return parameters;
    }

    private static class AnalyzerClassVisitor
    extends ClassNode {
        private ParameterInfo[] parameters = null;
        private String methodName;
        private Method method;

        public AnalyzerClassVisitor(Method method) {
            this.method = method;
            this.methodName = method.getName();
        }

        public ParameterInfo[] getParameters() {
            return this.parameters;
        }

        public void visitEnd() {
            for (MethodNode method : this.methods) {
                if (!this.methodName.equals(method.name)) continue;
                this.visitMethod(method);
            }
        }

        private void visitMethod(MethodNode methodNode) {
            int firstIndex = Modifier.isStatic(this.method.getModifiers()) ? 0 : 1;
            Class<?>[] parameterTypes = this.method.getParameterTypes();
            int numberParameters = Math.min(parameterTypes.length, methodNode.localVariables.size() - firstIndex);
            HashMap<Integer, Integer> parameterIndices = new HashMap<Integer, Integer>();
            int i = 0;
            int currentIndex = firstIndex;
            while (i < numberParameters) {
                parameterIndices.put(currentIndex, i);
                if (parameterTypes[i] == Long.TYPE || parameterTypes[i] == Double.TYPE) {
                    ++currentIndex;
                }
                ++i;
                ++currentIndex;
            }
            this.parameters = new ParameterInfo[numberParameters];
            for (i = 0; i < methodNode.localVariables.size(); ++i) {
                LocalVariableNode localVariableNode = (LocalVariableNode)methodNode.localVariables.get(i);
                if (!parameterIndices.containsKey(localVariableNode.index)) continue;
                int parameterIndex = (Integer)parameterIndices.get(localVariableNode.index);
                this.parameters[parameterIndex] = new ParameterInfo(localVariableNode.name, parameterTypes[parameterIndex]);
            }
        }
    }

    public static class ParameterInfo {
        public final String name;
        public final Class<?> type;

        public ParameterInfo(String name, Class<?> type) {
            this.name = name;
            this.type = type;
        }
    }
}

