/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.MemoryRange;

public class MemoryRanges {
    private List<MemoryRange> ranges = new LinkedList<MemoryRange>();

    public void addAddress(int rawAddress) {
        int length = 4;
        int address = rawAddress & 0x1FFFFFFF;
        for (MemoryRange memoryRange : this.ranges) {
            if (address == memoryRange.getAddress() + memoryRange.getLength()) {
                memoryRange.extendTop(4);
                return;
            }
            if (address == memoryRange.getAddress() - 4) {
                memoryRange.extendBottom(4);
                return;
            }
            if (!memoryRange.isOverlappingWithAddress(address)) continue;
            return;
        }
        MemoryRange memoryRange = new MemoryRange(rawAddress, 4);
        this.ranges.add(memoryRange);
    }

    public void updateValues() {
        for (MemoryRange memoryRange : this.ranges) {
            memoryRange.updateValues();
        }
    }

    public boolean areValuesChanged() {
        for (MemoryRange memoryRange : this.ranges) {
            if (!memoryRange.areValuesChanged()) continue;
            return true;
        }
        return false;
    }

    public boolean isOverlappingWithAddressRange(int address, int size) {
        for (MemoryRange memoryRange : this.ranges) {
            if (!memoryRange.isOverlappingWithAddressRange(address, size)) continue;
            return true;
        }
        return false;
    }

    public int getValue(int address) {
        for (MemoryRange memoryRange : this.ranges) {
            if (!memoryRange.isOverlappingWithAddress(address)) continue;
            return memoryRange.getValue(address);
        }
        return 0;
    }

    public void clear() {
        for (MemoryRange memoryRange : this.ranges) {
            memoryRange.free();
        }
        this.ranges.clear();
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (MemoryRange memoryRange : this.ranges) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(memoryRange.toString());
        }
        return s.toString();
    }
}

