/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import com.jidesoft.icons.JideIconsFactory;
import com.jidesoft.swing.JideButton;
import com.jidesoft.swing.SimpleScrollPaneLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractButton;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;

public class SimpleScrollPane
extends JScrollPane
implements ChangeListener,
MouseWheelListener {
    private AbstractButton _scrollUpButton;
    private AbstractButton _scrollDownButton;
    private AbstractButton _scrollLeftButton;
    private AbstractButton _scrollRightButton;
    private int _horizontalUnitIncrement = 10;
    private boolean _horizontalUnitIncrementSet = false;
    private int _verticalUnitIncrement = 10;
    private boolean _verticalUnitIncrementSet = false;
    private int _repeatDelay = 50;
    private boolean _scrollOnRollover = true;
    public static final String SCROLL_UP_BUTTON = "SCROLL_UP_BUTTON";
    public static final String SCROLL_DOWN_BUTTON = "SCROLL_DOWN_BUTTON";
    public static final String SCROLL_LEFT_BUTTON = "SCROLL_LEFT_BUTTON";
    public static final String SCROLL_RIGHT_BUTTON = "SCROLL_RIGHT_BUTTON";

    public SimpleScrollPane(Component component, int n, int n2) {
        this.setLayout(new SimpleScrollPaneLayout.UIResource());
        this.setVerticalScrollBarPolicy(n);
        this.setHorizontalScrollBarPolicy(n2);
        this.setViewport(this.createViewport());
        this.setScrollUpButton(this.createScrollButton(1));
        this.setScrollDownButton(this.createScrollButton(5));
        this.setScrollLeftButton(this.createScrollButton(7));
        this.setScrollRightButton(this.createScrollButton(3));
        if (null != component) {
            this.setViewportView(component);
        }
        this.updateButtonState();
        this.setOpaque(true);
        this.setFocusable(false);
        if (this.getHorizontalScrollBar() != null) {
            this.getHorizontalScrollBar().setVisible(false);
            this.getHorizontalScrollBar().setFocusable(false);
        }
        if (this.getVerticalScrollBar() != null) {
            this.getVerticalScrollBar().setVisible(false);
            this.getVerticalScrollBar().setFocusable(false);
        }
        this.updateUI();
        if (!this.getComponentOrientation().isLeftToRight()) {
            this.viewport.setViewPosition(new Point(Integer.MAX_VALUE, 0));
        }
        if (this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
    }

    public SimpleScrollPane(Component component) {
        this(component, 20, 30);
    }

    public SimpleScrollPane(int n, int n2) {
        this(null, n, n2);
    }

    public SimpleScrollPane() {
        this(null, 20, 30);
    }

    public void updateUI() {
        super.updateUI();
        this.setLayout(new SimpleScrollPaneLayout.UIResource());
        LookAndFeel.installBorder(this, "JideScrollPane.border");
        this.getViewport().addChangeListener(this);
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (changeEvent.getSource() == this.getViewport()) {
            this.updateButtonState();
        }
    }

    public AbstractButton getScrollUpButton() {
        return this._scrollUpButton;
    }

    public void setScrollUpButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollUpButton();
        this._scrollUpButton = abstractButton;
        this.add((Component)this._scrollUpButton, SCROLL_UP_BUTTON);
        this.firePropertyChange("scrollUpButton", abstractButton2, this._scrollUpButton);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollDownButton() {
        return this._scrollDownButton;
    }

    public void setScrollDownButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollDownButton();
        this._scrollDownButton = abstractButton;
        this.add((Component)this._scrollDownButton, SCROLL_DOWN_BUTTON);
        this.firePropertyChange("scrollDownButton", abstractButton2, this._scrollDownButton);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollLeftButton() {
        return this._scrollLeftButton;
    }

    public void setScrollLeftButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollLeftButton();
        this._scrollLeftButton = abstractButton;
        this.add((Component)this._scrollLeftButton, SCROLL_LEFT_BUTTON);
        this.firePropertyChange("scrollLeftButton", abstractButton2, this._scrollLeftButton);
        this.revalidate();
        this.repaint();
    }

    public AbstractButton getScrollRightButton() {
        return this._scrollRightButton;
    }

    public void setScrollRightButton(AbstractButton abstractButton) {
        AbstractButton abstractButton2 = this.getScrollRightButton();
        this._scrollRightButton = abstractButton;
        this.add((Component)this._scrollRightButton, SCROLL_RIGHT_BUTTON);
        this.firePropertyChange("scrollRightButton", abstractButton2, this._scrollRightButton);
        this.revalidate();
        this.repaint();
    }

    protected AbstractButton createScrollButton(int n) {
        return new ScrollButton(n);
    }

    protected void updateButtonState() {
        Point point = this.viewport.getViewPosition();
        this._scrollUpButton.setEnabled(point.y != 0);
        this._scrollDownButton.setEnabled(point.y != this.viewport.getViewSize().height - this.viewport.getViewRect().height);
        this._scrollLeftButton.setEnabled(point.x != 0);
        this._scrollRightButton.setEnabled(point.x != this.viewport.getViewSize().width - this.viewport.getViewRect().width);
        this.revalidate();
        this.repaint();
    }

    public void scroll(JViewport jViewport, int n) {
        Point point = jViewport.getViewPosition();
        JViewport jViewport2 = this.getViewport();
        switch (n) {
            case 1: {
                if (!this._verticalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y -= scrollable.getScrollableUnitIncrement(rectangle, 1, -1);
                } else {
                    point.y -= this.getVerticalUnitIncrement();
                }
                if (point.y >= 0) break;
                point.y = 0;
                break;
            }
            case 5: {
                if (!this._verticalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.y += scrollable.getScrollableUnitIncrement(rectangle, 1, 1);
                } else {
                    point.y += this.getVerticalUnitIncrement();
                }
                if (point.y + jViewport.getViewRect().height <= jViewport.getViewSize().height) break;
                point.y = jViewport.getViewSize().height - jViewport.getViewRect().height;
                break;
            }
            case 7: {
                if (!this._horizontalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x -= scrollable.getScrollableUnitIncrement(rectangle, 0, -1);
                } else {
                    point.x -= this.getHorizontalUnitIncrement();
                }
                if (point.x >= 0) break;
                point.x = 0;
                break;
            }
            case 3: {
                if (!this._horizontalUnitIncrementSet && jViewport2 != null && jViewport2.getView() instanceof Scrollable) {
                    Scrollable scrollable = (Scrollable)((Object)jViewport2.getView());
                    Rectangle rectangle = jViewport2.getViewRect();
                    point.x += scrollable.getScrollableUnitIncrement(rectangle, 0, 1);
                } else {
                    point.x += this.getHorizontalUnitIncrement();
                }
                if (point.x + jViewport.getViewRect().width <= jViewport.getViewSize().width) break;
                point.x = jViewport.getViewSize().width - jViewport.getViewRect().width;
            }
        }
        jViewport.setViewPosition(point);
    }

    public Rectangle getViewportBorderBounds() {
        Rectangle rectangle = new Rectangle(this.getSize());
        Insets insets = this.getInsets();
        rectangle.x = insets.left;
        rectangle.y = insets.top;
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
            rectangle.y += this._scrollUpButton.getHeight();
            rectangle.height -= this._scrollUpButton.getHeight();
        }
        if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
            rectangle.x += this._scrollLeftButton.getWidth();
            rectangle.width -= this._scrollLeftButton.getWidth();
        }
        if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
            rectangle.height -= this._scrollDownButton.getHeight();
        }
        if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
            rectangle.width -= this._scrollRightButton.getWidth();
        }
        return rectangle;
    }

    public int getHorizontalUnitIncrement() {
        return this._horizontalUnitIncrement;
    }

    public void setHorizontalUnitIncrement(int n) {
        this._horizontalUnitIncrementSet = true;
        if (n != this._horizontalUnitIncrement) {
            int n2 = this._horizontalUnitIncrement;
            this._horizontalUnitIncrement = n;
            this.firePropertyChange("horizontalUnitIncrement", n2, this._horizontalUnitIncrement);
        }
    }

    public int getVerticalUnitIncrement() {
        return this._verticalUnitIncrement;
    }

    public void setVerticalUnitIncrement(int n) {
        this._verticalUnitIncrementSet = true;
        if (n != this._verticalUnitIncrement) {
            int n2 = this._verticalUnitIncrement;
            this._verticalUnitIncrement = n;
            this.firePropertyChange("verticalUnitIncrement", n2, this._verticalUnitIncrement);
        }
    }

    public boolean isScrollOnRollover() {
        return this._scrollOnRollover;
    }

    public void setScrollOnRollover(boolean bl) {
        if (this._scrollOnRollover != bl) {
            boolean bl2 = this._scrollOnRollover;
            this._scrollOnRollover = bl;
            this.firePropertyChange("scrollOnRollover", bl2, this._scrollOnRollover);
        }
    }

    public int getRepeatDelay() {
        return this._repeatDelay;
    }

    public void setRepeatDelay(int n) {
        if (n != this._repeatDelay) {
            int n2 = this._repeatDelay;
            this._repeatDelay = n;
            this.firePropertyChange("repeatDelay", n2, this._repeatDelay);
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.isWheelScrollingEnabled() && mouseWheelEvent.getScrollAmount() != 0) {
            boolean bl = mouseWheelEvent.getWheelRotation() >= 0;
            int n = 0;
            if (!this.isButtonVisible(bl)) {
                return;
            }
            n = this.getScrollDirection(bl);
            if (n != 0) {
                this.scroll(this.getViewport(), n);
            }
        }
    }

    private boolean isButtonVisible(boolean bl) {
        if (bl) {
            return this._scrollUpButton != null && this._scrollUpButton.isVisible() || this._scrollLeftButton != null && this._scrollLeftButton.isVisible();
        }
        return this._scrollDownButton != null && this._scrollDownButton.isVisible() || this._scrollRightButton != null && this._scrollRightButton.isVisible();
    }

    private int getScrollDirection(boolean bl) {
        if (bl) {
            if (this._scrollUpButton != null && this._scrollUpButton.isVisible()) {
                return 5;
            }
            if (this._scrollLeftButton != null && this._scrollLeftButton.isVisible()) {
                return 3;
            }
        } else {
            if (this._scrollDownButton != null && this._scrollDownButton.isVisible()) {
                return 1;
            }
            if (this._scrollRightButton != null && this._scrollRightButton.isVisible()) {
                return 7;
            }
        }
        return 0;
    }

    public void setWheelScrollingEnabled(boolean bl) {
        if (bl && !this.isWheelScrollingEnabled()) {
            this.addMouseWheelListener(this);
        }
        if (!bl && this.isWheelScrollingEnabled()) {
            this.removeMouseWheelListener(this);
        }
        super.setWheelScrollingEnabled(bl);
    }

    public class ScrollButton
    extends JideButton
    implements MouseListener,
    ActionListener,
    UIResource {
        private int _type;
        private Timer _timer;

        public ScrollButton(int n) {
            this._type = n;
            switch (n) {
                case 1: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_up.gif"));
                    break;
                }
                case 5: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_down.gif"));
                    break;
                }
                case 7: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_left.gif"));
                    break;
                }
                case 3: {
                    this.setIcon(JideIconsFactory.getImageIcon("jide/direction_right.gif"));
                }
            }
            this.addActionListener(this);
            this.addMouseListener(this);
            this.setPreferredSize(new Dimension(10, 10));
            this.setMinimumSize(new Dimension(10, 10));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SimpleScrollPane.this.scroll(SimpleScrollPane.this.getViewport(), this._type);
            SimpleScrollPane.this.updateButtonState();
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.startTimer(mouseEvent, 500);
            } else {
                this.updateTimer(mouseEvent);
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (!SimpleScrollPane.this.isScrollOnRollover()) {
                this.stopTimer();
            } else {
                this.updateTimer(mouseEvent);
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.startTimer(mouseEvent, 500);
            }
        }

        private void updateTimer(MouseEvent mouseEvent) {
            if (this._timer != null) {
                this._timer.setDelay(this.getDelay(mouseEvent));
            }
        }

        private void startTimer(MouseEvent mouseEvent, int n) {
            this.stopTimer();
            this._timer = new Timer(this.getDelay(mouseEvent), this);
            this._timer.setInitialDelay(n);
            this._timer.start();
        }

        private void stopTimer() {
            if (this._timer != null) {
                this._timer.stop();
                this._timer = null;
            }
        }

        private int getDelay(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                return SwingUtilities.isLeftMouseButton(mouseEvent) ? SimpleScrollPane.this.getRepeatDelay() : SimpleScrollPane.this.getRepeatDelay() * 2;
            }
            return SimpleScrollPane.this.getRepeatDelay();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (SimpleScrollPane.this.isScrollOnRollover()) {
                this.stopTimer();
            }
        }
    }
}

