/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import jpcsp.format.rco.vsmx.INativeFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXCallState;
import jpcsp.format.rco.vsmx.interpreter.VSMXFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;

public class VSMXNativeFunction
extends VSMXFunction {
    private INativeFunction nativeFunction;
    private VSMXBaseObject returnValue;
    private VSMXBaseObject[] arguments;

    public VSMXNativeFunction(VSMXInterpreter interpreter, INativeFunction nativeFunction) {
        super(interpreter, nativeFunction.getArgs(), 0, -1);
        this.nativeFunction = nativeFunction;
        this.arguments = new VSMXBaseObject[nativeFunction.getArgs() + 1];
    }

    @Override
    public void call(VSMXCallState callState) {
        this.arguments[0] = callState.getThisObject();
        for (int i = 1; i < this.arguments.length; ++i) {
            this.arguments[i] = callState.getLocalVar(i);
        }
        this.returnValue = this.nativeFunction.call(this.arguments);
    }

    @Override
    public VSMXBaseObject getReturnValue() {
        return this.returnValue;
    }

    @Override
    public String toString() {
        return String.format("VSMXNativeFunction[%s, returnValue=%s]", this.nativeFunction, this.returnValue);
    }
}

