/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.sceDdr;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerDdr
extends MMIOHandlerBase {
    public static Logger log = sceDdr.log;
    private static final int STATE_VERSION = 0;
    public static final int BASE_ADDRESS = -1124073472;
    private static MMIOHandlerDdr instance;
    private int unknown40;
    private final Set<IAction>[] flushActions = new HashSet[16];
    private final boolean[] flushDone = new boolean[16];

    public static MMIOHandlerDdr getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerDdr(-1124073472);
        }
        return instance;
    }

    private MMIOHandlerDdr(int baseAddress) {
        super(baseAddress);
        for (int i = 0; i < this.flushActions.length; ++i) {
            this.flushActions[i] = new HashSet<IAction>();
        }
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.unknown40 = stream.readInt();
        stream.readBooleans(this.flushDone);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.unknown40);
        stream.writeBooleans(this.flushDone);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.unknown40 = 0;
        for (int i = 0; i < this.flushActions.length; ++i) {
            this.flushActions[i].clear();
        }
        Arrays.fill(this.flushDone, false);
    }

    public synchronized boolean checkAndClearFlushDone(int value) {
        boolean check = this.flushDone[value];
        this.flushDone[value] = false;
        return check;
    }

    public synchronized void setFlushAction(int value, IAction action) {
        this.flushActions[value].add(action);
    }

    public synchronized void clearFlushAction(int value, IAction action) {
        if (!this.flushActions[value].remove(action)) {
            log.error((Object)String.format("clearFlushAction action not found %s", action));
        }
    }

    public synchronized void clearFlushDone(int value) {
        this.flushDone[value] = false;
    }

    public synchronized void doFlush(int value) {
        this.flushDone[value &= 0xF] = true;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("MMIOHandlerDdr.doFlush 0x%01X", value));
        }
        if (!this.flushActions[value].isEmpty()) {
            for (IAction action : this.flushActions[value]) {
                action.execute();
            }
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = 0;
                break;
            }
            case 4: {
                value = 0;
                break;
            }
            case 32: {
                value = 0;
                break;
            }
            case 44: {
                value = 0;
                break;
            }
            case 48: {
                value = 0;
                break;
            }
            case 64: {
                value = this.unknown40;
                this.unknown40 ^= 0x100;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 4: {
                this.doFlush(value);
                break;
            }
            case 32: {
                break;
            }
            case 36: {
                break;
            }
            case 44: {
                break;
            }
            case 48: {
                break;
            }
            case 52: {
                break;
            }
            case 56: {
                break;
            }
            case 64: {
                break;
            }
            case 68: {
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

