/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cmp;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cmp.CAKeyUpdAnnContent;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CRLAnnContent;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.GenMsgContent;
import org.bouncycastle.asn1.cmp.GenRepContent;
import org.bouncycastle.asn1.cmp.KeyRecRepContent;
import org.bouncycastle.asn1.cmp.PKIConfirmContent;
import org.bouncycastle.asn1.cmp.PKIMessages;
import org.bouncycastle.asn1.cmp.POPODecKeyChallContent;
import org.bouncycastle.asn1.cmp.POPODecKeyRespContent;
import org.bouncycastle.asn1.cmp.PollRepContent;
import org.bouncycastle.asn1.cmp.PollReqContent;
import org.bouncycastle.asn1.cmp.RevAnnContent;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cmp.RevReqContent;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.pkcs.CertificationRequest;

public class PKIBody
extends ASN1Encodable
implements ASN1Choice {
    private int tagNo;
    private ASN1Encodable body;

    public static PKIBody getInstance(Object object) {
        if (object instanceof PKIBody) {
            return (PKIBody)object;
        }
        if (object instanceof ASN1TaggedObject) {
            return new PKIBody((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("Invalid object: " + object.getClass().getName());
    }

    private PKIBody(ASN1TaggedObject aSN1TaggedObject) {
        this.tagNo = aSN1TaggedObject.getTagNo();
        switch (aSN1TaggedObject.getTagNo()) {
            case 0: {
                this.body = CertReqMessages.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 1: {
                this.body = CertRepMessage.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 2: {
                this.body = CertReqMessages.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 3: {
                this.body = CertRepMessage.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 4: {
                this.body = CertificationRequest.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 5: {
                this.body = POPODecKeyChallContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 6: {
                this.body = POPODecKeyRespContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 7: {
                this.body = CertReqMessages.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 8: {
                this.body = CertRepMessage.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 9: {
                this.body = CertReqMessages.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 10: {
                this.body = KeyRecRepContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 11: {
                this.body = RevReqContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 12: {
                this.body = RevRepContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 13: {
                this.body = CertReqMessages.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 14: {
                this.body = CertRepMessage.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 15: {
                this.body = CAKeyUpdAnnContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 16: {
                this.body = CMPCertificate.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 17: {
                this.body = RevAnnContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 18: {
                this.body = CRLAnnContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 19: {
                this.body = PKIConfirmContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 20: {
                this.body = PKIMessages.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 21: {
                this.body = GenMsgContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 22: {
                this.body = GenRepContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 23: {
                this.body = ErrorMsgContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 24: {
                this.body = CertConfirmContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 25: {
                this.body = PollReqContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            case 26: {
                this.body = PollRepContent.getInstance(aSN1TaggedObject.getObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown tag number: " + aSN1TaggedObject.getTagNo());
            }
        }
    }

    @Override
    public DERObject toASN1Object() {
        return new DERTaggedObject(true, this.tagNo, this.body);
    }
}

