/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.DataBufferInt;
import java.awt.image.Kernel;
import java.awt.image.WritableRaster;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;

public class ShadowFactory {
    public static final String KEY_BLUR_QUALITY = "blur_quality";
    public static final String VALUE_BLUR_QUALITY_FAST = "fast";
    public static final String VALUE_BLUR_QUALITY_HIGH = "high";
    public static final String SIZE_CHANGED_PROPERTY = "shadow_size";
    public static final String OPACITY_CHANGED_PROPERTY = "shadow_opacity";
    public static final String COLOR_CHANGED_PROPERTY = "shadow_color";
    private int size = 5;
    private float opacity = 0.5f;
    private Color color = Color.BLACK;
    private HashMap hints = new HashMap();
    private PropertyChangeSupport changeSupport;

    public ShadowFactory() {
        this(5, 0.5f, Color.BLACK);
    }

    public ShadowFactory(int n, float f, Color color) {
        this.hints.put(KEY_BLUR_QUALITY, VALUE_BLUR_QUALITY_FAST);
        this.changeSupport = new PropertyChangeSupport(this);
        this.setSize(n);
        this.setOpacity(f);
        this.setColor(color);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void setRenderingHint(Object object, Object object2) {
        this.hints.put(object, object2);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color != null) {
            Color color2 = this.color;
            this.color = color;
            this.changeSupport.firePropertyChange(COLOR_CHANGED_PROPERTY, color2, this.color);
        }
    }

    public float getOpacity() {
        return this.opacity;
    }

    public void setOpacity(float f) {
        float f2 = this.opacity;
        this.opacity = (double)f < 0.0 ? 0.0f : (f > 1.0f ? 1.0f : f);
        this.changeSupport.firePropertyChange(OPACITY_CHANGED_PROPERTY, Float.valueOf(f2), Float.valueOf(this.opacity));
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int n) {
        int n2 = this.size;
        this.size = n < 0 ? 0 : n;
        this.changeSupport.firePropertyChange(SIZE_CHANGED_PROPERTY, new Integer(n2), new Integer(this.size));
    }

    public BufferedImage createShadow(BufferedImage bufferedImage) {
        if (this.hints.get(KEY_BLUR_QUALITY) == VALUE_BLUR_QUALITY_HIGH) {
            BufferedImage bufferedImage2 = this.prepareImage(bufferedImage);
            BufferedImage bufferedImage3 = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), 2);
            BufferedImage bufferedImage4 = this.createShadowMask(bufferedImage2);
            this.getLinearBlurOp(this.size).filter(bufferedImage4, bufferedImage3);
            return bufferedImage3;
        }
        return this.createShadowFast(bufferedImage);
    }

    private BufferedImage prepareImage(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth() + this.size * 2, bufferedImage.getHeight() + this.size * 2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, null, this.size, this.size);
        graphics2D.dispose();
        return bufferedImage2;
    }

    private BufferedImage createShadowFast(BufferedImage bufferedImage) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.size;
        int n7 = bufferedImage.getWidth();
        int n8 = bufferedImage.getHeight();
        int n9 = n7 + this.size;
        int n10 = n8 + this.size;
        int n11 = n6 - 1 >> 1;
        int n12 = n6 - n11;
        int n13 = n10 - n12;
        BufferedImage bufferedImage2 = new BufferedImage(n9, n10, 2);
        int n14 = this.color.getRGB() & 0xFFFFFF;
        int[] nArray = new int[n6];
        ColorModel colorModel = bufferedImage.getColorModel();
        WritableRaster writableRaster = bufferedImage.getRaster();
        int[] nArray2 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
        int n15 = n12 * n9;
        float f = 1.0f / (float)this.size;
        float f2 = this.opacity / (float)this.size;
        int n16 = n11 * n9;
        for (n5 = 0; n5 < n8; ++n5) {
            n4 = 0;
            while (n4 < n6) {
                nArray[n4++] = 0;
            }
            n3 = 0;
            n4 = 0;
            for (n2 = 0; n2 < n7; ++n2) {
                n = (int)((float)n3 * f);
                nArray2[n16++] = n << 24;
                n3 -= nArray[n4];
                nArray[n4] = n = colorModel.getAlpha(writableRaster.getDataElements(n2, n5, null));
                n3 += n;
                if (++n4 < n6) continue;
                n4 -= n6;
            }
            for (n2 = 0; n2 < n6; ++n2) {
                n = (int)((float)n3 * f);
                nArray2[n16++] = n << 24;
                n3 -= nArray[n4];
                if (++n4 < n6) continue;
                n4 -= n6;
            }
        }
        n5 = 0;
        n16 = 0;
        while (n5 < n9) {
            n3 = 0;
            n4 = 0;
            while (n4 < n11) {
                nArray[n4++] = 0;
            }
            n2 = 0;
            while (n2 < n12) {
                n = nArray2[n16] >>> 24;
                nArray[n4++] = n;
                n3 += n;
                ++n2;
                n16 += n9;
            }
            n16 = n5;
            n4 = 0;
            n2 = 0;
            while (n2 < n13) {
                n = (int)((float)n3 * f2);
                nArray2[n16] = n << 24 | n14;
                n3 -= nArray[n4];
                nArray[n4] = n = nArray2[n16 + n15] >>> 24;
                n3 += n;
                if (++n4 >= n6) {
                    n4 -= n6;
                }
                ++n2;
                n16 += n9;
            }
            n2 = n13;
            while (n2 < n10) {
                n = (int)((float)n3 * f2);
                nArray2[n16] = n << 24 | n14;
                n3 -= nArray[n4];
                if (++n4 >= n6) {
                    n4 -= n6;
                }
                ++n2;
                n16 += n9;
            }
            n16 = ++n5;
        }
        return bufferedImage2;
    }

    private BufferedImage createShadowMask(BufferedImage bufferedImage) {
        BufferedImage bufferedImage2 = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        graphics2D.setComposite(AlphaComposite.getInstance(5, this.opacity));
        graphics2D.setColor(this.color);
        graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage2;
    }

    private ConvolveOp getLinearBlurOp(int n) {
        float[] fArray = new float[n * n];
        float f = 1.0f / (float)(n * n);
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = f;
        }
        return new ConvolveOp(new Kernel(n, n, fArray));
    }
}

