/*
 * Decompiled with CFR 0.152.
 */
package com.savarese.rocksaw.net;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.SocketException;

public class RawSocket {
    public static final int PF_INET;
    public static final int PF_INET6;
    protected static final int __UNDEFINED = -1;
    protected int __socket = -1;
    protected int __family = -1;
    protected TimeVal __stimeout = new TimeVal();
    protected TimeVal __rtimeout = new TimeVal();
    protected boolean __useSelectTimeout;

    protected static native int __PF_INET();

    protected static native int __PF_INET6();

    protected static native int __RockSawStartup();

    protected static native void __RockSawShutdown();

    public RawSocket() {
        String os = System.getProperty("os.name");
        if (os != null && os.startsWith("SunOS")) {
            this.setUseSelectTimeout(true);
        } else {
            this.setUseSelectTimeout(false);
        }
    }

    public boolean isOpen() {
        return this.__socket > 0;
    }

    protected static native void __getErrorMessage(StringBuffer var0);

    protected static String __getErrorMessage() {
        StringBuffer buf = new StringBuffer();
        RawSocket.__getErrorMessage(buf);
        return buf.toString();
    }

    protected static void __throwIOException() throws IOException {
        throw new IOException(RawSocket.__getErrorMessage());
    }

    protected static void __throwSocketException() throws SocketException {
        throw new SocketException(RawSocket.__getErrorMessage());
    }

    protected static void __throwInterruptedIOException() throws InterruptedIOException {
        throw new InterruptedIOException(RawSocket.__getErrorMessage());
    }

    protected static native int __socket(int var0, int var1);

    public static final native int getProtocolByName(String var0);

    protected static native int __query_routing_interface(int var0, int var1, byte[] var2, byte[] var3);

    public void getSourceAddressForDestination(InetAddress destination, byte[] source) throws IOException {
        if (RawSocket.__query_routing_interface(this.__socket, this.__family, destination.getAddress(), source) < 0) {
            RawSocket.__throwIOException();
        }
    }

    public void open(int protocolFamily, int protocol) throws IllegalStateException, IOException {
        if (this.isOpen()) {
            throw new IllegalStateException();
        }
        this.__socket = RawSocket.__socket(protocolFamily, protocol);
        if (this.__socket < 0) {
            this.__socket = -1;
            RawSocket.__throwIOException();
        }
        this.__family = protocolFamily;
    }

    protected static native int __bind(int var0, int var1, byte[] var2);

    public void bind(InetAddress address) throws IllegalStateException, IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        if (RawSocket.__bind(this.__socket, this.__family, address.getAddress()) != 0) {
            RawSocket.__throwIOException();
        }
    }

    protected static native int __bindDevice(int var0, String var1);

    public void bindDevice(String device) throws UnsupportedOperationException, IllegalStateException, IOException {
        if (!this.isOpen()) {
            throw new IllegalStateException();
        }
        int result = RawSocket.__bindDevice(this.__socket, device);
        if (result < 0) {
            RawSocket.__throwIOException();
        } else if (result > 0) {
            throw new UnsupportedOperationException();
        }
    }

    protected static native int __close(int var0);

    public void close() throws IOException {
        int result = RawSocket.__close(this.__socket);
        this.__socket = -1;
        this.__family = -1;
        if (result != 0) {
            RawSocket.__throwIOException();
        }
    }

    protected native boolean __isErrorEAGAIN();

    protected static native int __setIPHeaderInclude(int var0, boolean var1);

    protected static native int __getIPHeaderInclude(int var0);

    public void setIPHeaderInclude(boolean on) throws SocketException {
        int result = RawSocket.__setIPHeaderInclude(this.__socket, on);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
    }

    public boolean getIPHeaderInclude() throws SocketException {
        int result = RawSocket.__getIPHeaderInclude(this.__socket);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
        return result > 0;
    }

    protected static native int __setSendBufferSize(int var0, int var1);

    public void setSendBufferSize(int size) throws SocketException {
        int result = RawSocket.__setSendBufferSize(this.__socket, size);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
    }

    protected static native int __getSendBufferSize(int var0);

    public int getSendBufferSize() throws SocketException {
        int result = RawSocket.__getSendBufferSize(this.__socket);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
        return result;
    }

    protected static native int __setReceiveBufferSize(int var0, int var1);

    public void setReceiveBufferSize(int size) throws SocketException {
        int result = RawSocket.__setReceiveBufferSize(this.__socket, size);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
    }

    protected static native int __getReceiveBufferSize(int var0);

    public int getReceiveBufferSize() throws SocketException {
        int result = RawSocket.__getReceiveBufferSize(this.__socket);
        if (result < 0) {
            RawSocket.__throwSocketException();
        }
        return result;
    }

    protected static native int __select(int var0, boolean var1, int var2, int var3);

    public void setUseSelectTimeout(boolean useSelect) {
        this.__useSelectTimeout = useSelect;
    }

    public boolean getUseSelectTimeout() {
        return this.__useSelectTimeout;
    }

    protected static native int __setSendTimeout(int var0, int var1);

    public void setSendTimeout(int timeout) throws SocketException {
        int result;
        this.__stimeout.setInMilliseconds(timeout);
        if (!this.getUseSelectTimeout() && (result = RawSocket.__setSendTimeout(this.__socket, timeout)) < 0) {
            RawSocket.__throwSocketException();
        }
    }

    protected static native int __getSendTimeout(int var0);

    public int getSendTimeout() throws SocketException {
        int result;
        if (this.getUseSelectTimeout()) {
            result = this.__stimeout.getInMilliseconds();
        } else {
            result = RawSocket.__getSendTimeout(this.__socket);
            if (result < 0) {
                RawSocket.__throwSocketException();
            }
        }
        return result;
    }

    protected static native int __setReceiveTimeout(int var0, int var1);

    public void setReceiveTimeout(int timeout) throws SocketException {
        int result;
        this.__rtimeout.setInMilliseconds(timeout);
        if (!this.getUseSelectTimeout() && (result = RawSocket.__setReceiveTimeout(this.__socket, timeout)) < 0) {
            RawSocket.__throwSocketException();
        }
    }

    protected static native int __getReceiveTimeout(int var0);

    public int getReceiveTimeout() throws SocketException {
        int result;
        if (this.getUseSelectTimeout()) {
            result = this.__rtimeout.getInMilliseconds();
        } else {
            result = RawSocket.__getReceiveTimeout(this.__socket);
            if (result < 0) {
                RawSocket.__throwSocketException();
            }
        }
        return result;
    }

    protected static native int __recvfrom1(int var0, byte[] var1, int var2, int var3, int var4);

    protected static native int __recvfrom2(int var0, byte[] var1, int var2, int var3, int var4, byte[] var5);

    public int read(byte[] data, int offset, int length, byte[] address) throws IllegalArgumentException, IOException, InterruptedIOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        if (address != null && (this.__family == PF_INET && address.length != 4 || this.__family == PF_INET6 && address.length != 16)) {
            throw new IllegalArgumentException("Invalid address length.");
        }
        int result = 0;
        if (this.getUseSelectTimeout() && !this.__rtimeout.isZero()) {
            result = RawSocket.__select(this.__socket, true, this.__rtimeout.seconds, this.__rtimeout.microseconds);
        }
        if (result == 0) {
            int n = result = address == null ? RawSocket.__recvfrom1(this.__socket, data, offset, length, this.__family) : RawSocket.__recvfrom2(this.__socket, data, offset, length, this.__family, address);
        }
        if (result < 0) {
            if (this.__isErrorEAGAIN()) {
                RawSocket.__throwInterruptedIOException();
            } else {
                RawSocket.__throwIOException();
            }
        }
        return result;
    }

    public int read(byte[] data, int offset, int length) throws IllegalArgumentException, IOException, InterruptedIOException {
        return this.read(data, offset, length, null);
    }

    public int read(byte[] data, byte[] address) throws IOException, InterruptedIOException {
        return this.read(data, 0, data.length, address);
    }

    public int read(byte[] data) throws IOException, InterruptedIOException {
        return this.read(data, 0, data.length, null);
    }

    protected static native int __sendto(int var0, byte[] var1, int var2, int var3, int var4, byte[] var5);

    public int write(InetAddress address, byte[] data, int offset, int length) throws IllegalArgumentException, IOException, InterruptedIOException {
        if (offset < 0 || length < 0 || length > data.length - offset) {
            throw new IllegalArgumentException("Invalid offset or length.");
        }
        int result = 0;
        if (this.getUseSelectTimeout() && !this.__stimeout.isZero()) {
            result = RawSocket.__select(this.__socket, false, this.__stimeout.seconds, this.__stimeout.microseconds);
        }
        if (result == 0) {
            result = RawSocket.__sendto(this.__socket, data, offset, length, this.__family, address.getAddress());
        }
        if (result < 0) {
            if (this.__isErrorEAGAIN()) {
                RawSocket.__throwInterruptedIOException();
            } else {
                RawSocket.__throwIOException();
            }
        }
        return result;
    }

    public int write(InetAddress address, byte[] data) throws IOException, InterruptedIOException {
        return this.write(address, data, 0, data.length);
    }

    static {
        System.loadLibrary("rocksaw");
        RawSocket.__RockSawStartup();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                RawSocket.__RockSawShutdown();
            }
        });
        PF_INET = RawSocket.__PF_INET();
        PF_INET6 = RawSocket.__PF_INET6();
    }

    protected static final class TimeVal {
        int seconds = 0;
        int microseconds = 0;

        TimeVal() {
        }

        void setInMilliseconds(int milliseconds) {
            this.seconds = milliseconds / 1000;
            if (this.seconds > 0) {
                milliseconds -= this.seconds * 1000;
            }
            this.microseconds = milliseconds * 1000;
        }

        int getInMilliseconds() {
            return this.seconds * 1000 + this.microseconds / 1000;
        }

        boolean isZero() {
            return this.seconds == 0 && this.microseconds == 0;
        }
    }
}

