/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.memory.mmio.IMMIOHandler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerBase
implements IMMIOHandler {
    protected Logger log = Logger.getLogger((String)"mmio");
    private static final int STATE_VERSION = 0;
    protected final int baseAddress;

    public MMIOHandlerBase(int baseAddress) {
        this.baseAddress = baseAddress;
    }

    protected Memory getMemory() {
        return RuntimeContextLLE.getMMIO();
    }

    protected Processor getProcessor() {
        return RuntimeContextLLE.getProcessor();
    }

    protected int getPc() {
        return this.getProcessor().cpu.pc;
    }

    @Override
    public int read8(int address) {
        this.log.error((Object)String.format("0x%08X - Unimplemented read8(0x%08X)", this.getPc(), address));
        return 0;
    }

    @Override
    public int read16(int address) {
        this.log.error((Object)String.format("0x%08X - Unimplemented read16(0x%08X)", this.getPc(), address));
        return 0;
    }

    @Override
    public int read32(int address) {
        this.log.error((Object)String.format("0x%08X - Unimplemented read32(0x%08X)", this.getPc(), address));
        return 0;
    }

    @Override
    public int internalRead8(int address) {
        return this.read8(address);
    }

    @Override
    public int internalRead16(int address) {
        return this.read16(address);
    }

    @Override
    public int internalRead32(int address) {
        return this.read32(address);
    }

    @Override
    public void write8(int address, byte value) {
        this.log.error((Object)String.format("0x%08X - Unimplemented write8(0x%08X, 0x%02X)", this.getPc(), address, value));
    }

    @Override
    public void write16(int address, short value) {
        this.log.error((Object)String.format("0x%08X - Unimplemented write16(0x%08X, 0x%04X)", this.getPc(), address, value));
    }

    @Override
    public void write32(int address, int value) {
        this.log.error((Object)String.format("0x%08X - Unimplemented write32(0x%08X, 0x%08X)", this.getPc(), address, value));
    }

    public void setLogger(Logger log) {
        this.log = log;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
    }

    @Override
    public void reset() {
    }

    public String toString() {
        return String.format("%s at 0x%08X", this.getClass().getName(), this.baseAddress);
    }
}

