/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.eflash;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.modules.sceEFlash;
import jpcsp.Memory;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.memory.mmio.eflash.MMIOHandlerEFlashAta;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerEFlashDma
extends MMIOHandlerBase {
    public static Logger log = sceEFlash.log;
    private static final int STATE_VERSION = 0;
    private int control;
    private int interrupt;
    private int unknown28;
    private int dmaAddr;
    private int dmaSize;
    private int unknown40;

    public MMIOHandlerEFlashDma(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.control = stream.readInt();
        this.interrupt = stream.readInt();
        this.unknown28 = stream.readInt();
        this.dmaAddr = stream.readInt();
        this.dmaSize = stream.readInt();
        this.unknown40 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.control);
        stream.writeInt(this.interrupt);
        stream.writeInt(this.unknown28);
        stream.writeInt(this.dmaAddr);
        stream.writeInt(this.dmaSize);
        stream.writeInt(this.unknown40);
        super.write(stream);
    }

    @Override
    public void reset() {
        this.control = 0;
        this.interrupt = 0;
        this.unknown28 = 0;
        this.dmaAddr = 0;
        this.dmaSize = 0;
        this.unknown40 = 0;
        super.reset();
    }

    private void writeReset(int value) {
        if (value == 1) {
            this.reset();
            MMIOHandlerEFlashAta.getInstance().reset();
        }
    }

    private void checkInterrupt() {
        if (this.interrupt != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 28);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 28);
        }
    }

    private void clearInterruptFlag(int value) {
        this.interrupt = Utilities.clearFlag(this.interrupt, value);
        this.checkInterrupt();
    }

    private void setInterruptFlag(int value) {
        this.interrupt = Utilities.setFlag(this.interrupt, value);
        this.checkInterrupt();
    }

    private void clearUnknown28(int value) {
        this.unknown28 = Utilities.clearFlag(this.unknown28, value);
    }

    private void writeUnknown28(int value) {
        this.unknown28 = value;
    }

    private void writeControl(int value) {
        this.control = value;
        if (Utilities.hasBit(this.control, 0)) {
            if (Utilities.hasBit(this.control, 1)) {
                MMIOHandlerEFlashAta eflashAta = MMIOHandlerEFlashAta.getInstance();
                Memory mem = this.getMemory();
                int addr = this.dmaAddr;
                int j = 0;
                while (j < this.dmaSize) {
                    int data16 = eflashAta.read16(-1113587712);
                    mem.writeUnsigned16(addr, data16);
                    j += 2;
                    addr += 2;
                }
                this.setInterruptFlag(1);
            } else {
                MMIOHandlerEFlashAta eflashAta = MMIOHandlerEFlashAta.getInstance();
                Memory mem = this.getMemory();
                int addr = this.dmaAddr;
                int j = 0;
                while (j < this.dmaSize) {
                    int data16 = mem.read16(addr);
                    eflashAta.write16(-1113587712, (short)data16);
                    j += 2;
                    addr += 2;
                }
                this.setInterruptFlag(1);
            }
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 32: {
                value = this.interrupt;
                break;
            }
            case 40: {
                value = this.unknown28;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 8: {
                this.writeReset(value);
                break;
            }
            case 16: {
                this.writeControl(value);
                break;
            }
            case 36: {
                this.clearInterruptFlag(value);
                break;
            }
            case 40: {
                this.writeUnknown28(value);
                break;
            }
            case 44: {
                this.clearUnknown28(value);
                break;
            }
            case 48: {
                this.dmaAddr = value;
                break;
            }
            case 52: {
                this.dmaSize = value;
                break;
            }
            case 64: {
                this.unknown40 = value;
                break;
            }
            case 68: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

