/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.software.IRandomTextureAccess;

public class TextureClip {
    public static IRandomTextureAccess getTextureClip(GeContext context, int mipmapLevel, IRandomTextureAccess textureAccess, int width, int height) {
        boolean needClipWidth = false;
        boolean needClipHeight = false;
        if (context.tex_wrap_s != 0 || context.texture_width[mipmapLevel] > width) {
            needClipWidth = true;
        }
        if (context.tex_wrap_t != 0 || context.texture_height[mipmapLevel] > height) {
            needClipHeight = true;
        }
        if (needClipWidth) {
            textureAccess = needClipHeight ? new TextureClipWidthHeight(textureAccess, width, height) : new TextureClipWidth(textureAccess, width);
        } else if (needClipHeight) {
            textureAccess = new TextureClipHeight(textureAccess, height);
        }
        return textureAccess;
    }

    private static class TextureClipWidthHeight
    implements IRandomTextureAccess {
        private IRandomTextureAccess textureAccess;
        private int width;
        private int height;

        public TextureClipWidthHeight(IRandomTextureAccess textureAccess, int width, int height) {
            this.textureAccess = textureAccess;
            this.width = width;
            this.height = height;
        }

        @Override
        public int readPixel(int u, int v) {
            if (u < 0 || u >= this.width || v < 0 || v >= this.height) {
                return 0;
            }
            return this.textureAccess.readPixel(u, v);
        }

        @Override
        public int getWidth() {
            return this.textureAccess.getWidth();
        }

        @Override
        public int getHeight() {
            return this.textureAccess.getHeight();
        }
    }

    private static class TextureClipHeight
    implements IRandomTextureAccess {
        private IRandomTextureAccess textureAccess;
        private int height;

        public TextureClipHeight(IRandomTextureAccess textureAccess, int height) {
            this.textureAccess = textureAccess;
            this.height = height;
        }

        @Override
        public int readPixel(int u, int v) {
            if (v < 0 || v >= this.height) {
                return 0;
            }
            return this.textureAccess.readPixel(u, v);
        }

        @Override
        public int getWidth() {
            return this.textureAccess.getWidth();
        }

        @Override
        public int getHeight() {
            return this.textureAccess.getHeight();
        }
    }

    private static class TextureClipWidth
    implements IRandomTextureAccess {
        private IRandomTextureAccess textureAccess;
        private int width;

        public TextureClipWidth(IRandomTextureAccess textureAccess, int width) {
            this.textureAccess = textureAccess;
            this.width = width;
        }

        @Override
        public int readPixel(int u, int v) {
            if (u < 0 || u >= this.width) {
                return 0;
            }
            return this.textureAccess.readPixel(u, v);
        }

        @Override
        public int getWidth() {
            return this.textureAccess.getWidth();
        }

        @Override
        public int getHeight() {
            return this.textureAccess.getHeight();
        }
    }
}

