/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.iso;

import java.io.IOException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;

public class UmdIsoReaderVirtualFile
extends AbstractVirtualFile {
    private UmdIsoReader iso;
    private long position;
    private final byte[] buffer = new byte[2048];

    public UmdIsoReaderVirtualFile(String fileName) throws IOException {
        super(null);
        this.iso = new UmdIsoReader(fileName);
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    private int getSectorNumber() {
        return (int)(this.position / 2048L);
    }

    private int getSectorOffset() {
        return (int)(this.position % 2048L);
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int readLength = 0;
        int outputOffset = 0;
        while (outputLength > 0) {
            try {
                this.iso.readSector(this.getSectorNumber(), this.buffer);
            }
            catch (IOException e) {
                log.error((Object)"ioRead", (Throwable)e);
                return -2147352272;
            }
            int sectorOffset = this.getSectorOffset();
            int length = Math.min(2048 - sectorOffset, outputLength);
            outputPointer.setArray(outputOffset, this.buffer, sectorOffset, length);
            readLength += length;
            outputOffset += length;
            this.position += (long)length;
            outputLength -= length;
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = 0;
        while (outputLength > 0) {
            int length;
            int sectorOffset = this.getSectorOffset();
            if (sectorOffset == 0 && outputLength >= 2048) {
                try {
                    int numberSectors = outputLength / 2048;
                    this.iso.readSectors(this.getSectorNumber(), numberSectors, outputBuffer, outputOffset);
                    length = numberSectors * 2048;
                }
                catch (IOException e) {
                    log.error((Object)"ioRead", (Throwable)e);
                    return -2147352272;
                }
            }
            try {
                this.iso.readSector(this.getSectorNumber(), this.buffer);
                length = Math.min(2048 - sectorOffset, outputLength);
                System.arraycopy(this.buffer, sectorOffset, outputBuffer, outputOffset, length);
            }
            catch (IOException e) {
                log.error((Object)"ioRead", (Throwable)e);
                return -2147352272;
            }
            readLength += length;
            outputOffset += length;
            this.position += (long)length;
            outputLength -= length;
        }
        return readLength;
    }

    @Override
    public long ioLseek(long offset) {
        this.position = offset;
        return offset;
    }

    @Override
    public int ioClose() {
        try {
            this.iso.close();
        }
        catch (IOException e) {
            log.error((Object)"ioClose", (Throwable)e);
            return -1;
        }
        return 0;
    }

    @Override
    public long length() {
        return (long)this.iso.getNumSectors() * 2048L;
    }

    public boolean hasFile(String fileName) {
        return this.iso.hasFile(fileName);
    }

    @Override
    public String toString() {
        return String.format("%s, position=0x%X", this.iso, this.position);
    }
}

