/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspFileBuffer;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.sceAudiocodec;
import jpcsp.Memory;
import jpcsp.MemoryMap;
import jpcsp.media.codec.ICodec;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceAtrac3plus
extends HLEModule {
    public static Logger log = Modules.getLogger("sceAtrac3plus");
    public static final int AT3_MAGIC = 624;
    public static final int AT3_PLUS_MAGIC = 65534;
    public static final int RIFF_MAGIC = 1179011410;
    public static final int WAVE_MAGIC = 1163280727;
    public static final int FMT_CHUNK_MAGIC = 544501094;
    protected static final int FACT_CHUNK_MAGIC = 1952670054;
    protected static final int SMPL_CHUNK_MAGIC = 1819307379;
    public static final int DATA_CHUNK_MAGIC = 1635017060;
    private static final int ATRAC3_CONTEXT_READ_SIZE_OFFSET = 160;
    private static final int ATRAC3_CONTEXT_REQUIRED_SIZE_OFFSET = 164;
    private static final int ATRAC3_CONTEXT_DECODE_RESULT_OFFSET = 188;
    public static final int PSP_ATRAC_ALLDATA_IS_ON_MEMORY = -1;
    public static final int PSP_ATRAC_NONLOOP_STREAM_DATA_IS_ON_MEMORY = -2;
    public static final int PSP_ATRAC_LOOP_STREAM_DATA_IS_ON_MEMORY = -3;
    protected static final int PSP_ATRAC_STATUS_NONLOOP_STREAM_DATA = 0;
    protected static final int PSP_ATRAC_STATUS_LOOP_STREAM_DATA = 1;
    public static final int ATRAC_HEADER_HASH_LENGTH = 512;
    public static final int atracDecodeDelay = 2300;
    protected AtracID[] atracIDs = new AtracID[6];
    private static SysMemUserForUser.SysMemInfo temporaryDecodeArea;

    @Override
    public void start() {
        for (int i = 0; i < this.atracIDs.length; ++i) {
            this.atracIDs[i] = new AtracID(i);
        }
        this.hleAtracReinit(2, 2);
        super.start();
    }

    @Override
    public void stop() {
        if (temporaryDecodeArea != null) {
            Modules.SysMemUserForUserModule.free(temporaryDecodeArea);
            temporaryDecodeArea = null;
        }
        super.stop();
    }

    @Override
    public int getMemoryUsage() {
        if (Modules.ModuleMgrForKernelModule.isMemoryAllocatedForModule("flash0:/kd/libatrac3plus.prx")) {
            return 0;
        }
        return 32768;
    }

    protected static int read28(Memory mem, int address) {
        return (mem.read8(address + 0) & 0x7F) << 21 | (mem.read8(address + 1) & 0x7F) << 14 | (mem.read8(address + 2) & 0x7F) << 7 | (mem.read8(address + 3) & 0x7F) << 0;
    }

    protected static String getStringFromInt32(int n) {
        char c1 = (char)(n & 0xFF);
        char c2 = (char)(n >> 8 & 0xFF);
        char c3 = (char)(n >> 16 & 0xFF);
        char c4 = (char)(n >> 24 & 0xFF);
        return String.format("%c%c%c%c", Character.valueOf(c1), Character.valueOf(c2), Character.valueOf(c3), Character.valueOf(c4));
    }

    protected int hleAtracReinit(int numAT3IdCount, int numAT3plusIdCount) {
        int i;
        for (i = 0; i < this.atracIDs.length; ++i) {
            if (!this.atracIDs[i].isInUse()) continue;
            return -2147483615;
        }
        for (i = 0; i < numAT3plusIdCount && i < this.atracIDs.length; ++i) {
            this.atracIDs[i].setCodecType(4096);
        }
        for (int j = 0; j < numAT3IdCount && i < this.atracIDs.length; ++j, ++i) {
            this.atracIDs[i].setCodecType(4097);
        }
        while (i < this.atracIDs.length) {
            this.atracIDs[i].setCodecType(0);
            ++i;
        }
        return 0;
    }

    public int hleGetAtracID(int codecType) {
        for (int i = 0; i < this.atracIDs.length; ++i) {
            if (this.atracIDs[i].getCodecType() != codecType || this.atracIDs[i].isInUse()) continue;
            this.atracIDs[i].setInUse(true);
            return i;
        }
        return -2140995581;
    }

    public AtracID getAtracID(int atID) {
        return this.atracIDs[atID];
    }

    public static int analyzeRiffFile(Memory mem, int addr, int length, AtracFileInfo info) {
        int result = -2140995578;
        int currentAddr = addr;
        int bufferSize = length;
        info.atracEndSample = -1;
        info.numLoops = 0;
        info.inputFileDataOffset = 0;
        if (bufferSize < 12) {
            log.error((Object)String.format("Atrac buffer too small %d", bufferSize));
            return -2140995567;
        }
        int magic = Utilities.readUnaligned32(mem, currentAddr);
        int WAVEMagic = Utilities.readUnaligned32(mem, currentAddr + 8);
        if (magic != 1179011410 || WAVEMagic != 1163280727) {
            log.error((Object)String.format("Not a RIFF/WAVE format! %s", Utilities.getMemoryDump(currentAddr, 16)));
            return -2140995578;
        }
        info.inputDataSize = info.inputFileSize = Utilities.readUnaligned32(mem, currentAddr + 4) + 8;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("FileSize 0x%X", info.inputFileSize));
        }
        currentAddr += 12;
        bufferSize -= 12;
        boolean foundData = false;
        while (bufferSize >= 8 && !foundData) {
            int chunkMagic = Utilities.readUnaligned32(mem, currentAddr);
            int chunkSize = Utilities.readUnaligned32(mem, currentAddr + 4);
            currentAddr += 8;
            bufferSize -= 8;
            switch (chunkMagic) {
                case 1635017060: {
                    foundData = true;
                    info.inputFileDataOffset = currentAddr - addr;
                    info.inputDataSize = chunkSize;
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("DATA Chunk: data offset=0x%X, data size=0x%X", info.inputFileDataOffset, info.inputDataSize));
                    break;
                }
                case 544501094: {
                    if (chunkSize < 16) break;
                    int compressionCode = mem.read16(currentAddr);
                    info.atracChannels = mem.read16(currentAddr + 2);
                    info.atracSampleRate = Utilities.readUnaligned32(mem, currentAddr + 4);
                    info.atracBitrate = Utilities.readUnaligned32(mem, currentAddr + 8);
                    info.atracBytesPerFrame = mem.read16(currentAddr + 12);
                    int hiBytesPerSample = mem.read16(currentAddr + 14);
                    int extraDataSize = mem.read16(currentAddr + 16);
                    if (extraDataSize == 14) {
                        info.atracCodingMode = mem.read16(currentAddr + 18 + 6);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("WAVE format: magic=0x%08X('%s'), chunkSize=%d, compressionCode=0x%04X, channels=%d, sampleRate=%d, bitrate=%d, bytesPerFrame=0x%X, hiBytesPerSample=%d, codingMode=%d", chunkMagic, sceAtrac3plus.getStringFromInt32(chunkMagic), chunkSize, compressionCode, info.atracChannels, info.atracSampleRate, info.atracBitrate, info.atracBytesPerFrame, hiBytesPerSample, info.atracCodingMode));
                        StringBuilder restChunk = new StringBuilder();
                        for (int i = 16; i < chunkSize; ++i) {
                            int b = mem.read8(currentAddr + i);
                            restChunk.append(String.format(" %02X", b));
                        }
                        if (restChunk.length() > 0) {
                            log.debug((Object)String.format("Additional chunk data:%s", restChunk));
                        }
                    }
                    if (compressionCode == 624) {
                        result = 4097;
                        break;
                    }
                    if (compressionCode == 65534) {
                        result = 4096;
                        break;
                    }
                    return -2140995578;
                }
                case 1952670054: {
                    if (chunkSize < 8) break;
                    info.atracEndSample = Utilities.readUnaligned32(mem, currentAddr);
                    if (info.atracEndSample > 0) {
                        --info.atracEndSample;
                    }
                    info.atracSampleOffset = chunkSize >= 12 ? Utilities.readUnaligned32(mem, currentAddr + 8) : Utilities.readUnaligned32(mem, currentAddr + 4);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("FACT Chunk: chunkSize=%d, endSample=0x%X, sampleOffset=0x%X", chunkSize, info.atracEndSample, info.atracSampleOffset));
                    break;
                }
                case 1819307379: {
                    int checkNumLoops;
                    if (chunkSize < 36 || chunkSize < 36 + (checkNumLoops = Utilities.readUnaligned32(mem, currentAddr + 28)) * 24) break;
                    info.numLoops = checkNumLoops;
                    info.loops = new LoopInfo[info.numLoops];
                    int loopInfoAddr = currentAddr + 36;
                    for (int i = 0; i < info.numLoops; ++i) {
                        LoopInfo loop;
                        info.loops[i] = loop = new LoopInfo();
                        loop.cuePointID = Utilities.readUnaligned32(mem, loopInfoAddr);
                        loop.type = Utilities.readUnaligned32(mem, loopInfoAddr + 4);
                        loop.startSample = Utilities.readUnaligned32(mem, loopInfoAddr + 8) - info.atracSampleOffset;
                        loop.endSample = Utilities.readUnaligned32(mem, loopInfoAddr + 12) - info.atracSampleOffset;
                        loop.fraction = Utilities.readUnaligned32(mem, loopInfoAddr + 16);
                        loop.playCount = Utilities.readUnaligned32(mem, loopInfoAddr + 20);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Loop #%d: %s", i, loop.toString()));
                        }
                        loopInfoAddr += 24;
                    }
                    break;
                }
            }
            if (chunkSize > bufferSize) break;
            currentAddr += chunkSize;
            bufferSize -= chunkSize;
        }
        if (info.loops != null) {
            for (LoopInfo loop : info.loops) {
                if (loop.endSample <= info.atracEndSample) continue;
                loop.endSample = info.atracEndSample;
            }
        }
        return result;
    }

    protected int hleSetHalfwayBuffer(int atID, TPointer buffer, int readSize, int bufferSize, boolean isMonoOutput) {
        if (readSize > bufferSize) {
            return -2140995565;
        }
        if (readSize < 0) {
            readSize = MemoryMap.SIZE_RAM;
        }
        if (bufferSize < 0) {
            bufferSize = MemoryMap.SIZE_RAM;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleSetHalfwayBuffer buffer: %s", Utilities.getMemoryDump(buffer.getAddress(), readSize)));
        }
        AtracFileInfo info = new AtracFileInfo();
        int codecType = sceAtrac3plus.analyzeRiffFile(buffer.getMemory(), buffer.getAddress(), readSize, info);
        if (codecType < 0) {
            return codecType;
        }
        AtracID id = this.atracIDs[atID];
        if (codecType != id.getCodecType()) {
            return -2140995577;
        }
        int result = id.setHalfwayBuffer(buffer.getAddress(), readSize, bufferSize, isMonoOutput, info);
        if (result < 0) {
            return result;
        }
        Modules.ThreadManForUserModule.hleYieldCurrentThread();
        return result;
    }

    protected int hleSetHalfwayBufferAndGetID(TPointer buffer, int readSize, int bufferSize, boolean isMonoOutput) {
        if (readSize > bufferSize) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning 0x%X", -2140995565));
            }
            return -2140995565;
        }
        if (readSize < 0) {
            readSize = MemoryMap.SIZE_RAM;
        }
        if (bufferSize < 0) {
            bufferSize = MemoryMap.SIZE_RAM;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleSetHalfwayBufferAndGetID buffer=%s", Utilities.getMemoryDump(buffer, readSize)));
        }
        AtracFileInfo info = new AtracFileInfo();
        int codecType = sceAtrac3plus.analyzeRiffFile(buffer.getMemory(), buffer.getAddress(), readSize, info);
        if (codecType < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning 0x%X", codecType));
            }
            return codecType;
        }
        int atID = this.hleGetAtracID(codecType);
        if (atID < 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning 0x%X", atID));
            }
            return atID;
        }
        AtracID id = this.atracIDs[atID];
        int result = id.setHalfwayBuffer(buffer.getAddress(), readSize, bufferSize, isMonoOutput, info);
        if (result < 0) {
            this.hleReleaseAtracID(atID);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning 0x%X", result));
            }
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning atID=0x%X", atID));
        }
        Modules.ThreadManForUserModule.hleYieldCurrentThread();
        return atID;
    }

    protected void hleReleaseAtracID(int atracID) {
        this.atracIDs[atracID].release();
    }

    public int checkAtracID(int atID) {
        if (atID < 0 || atID >= this.atracIDs.length || !this.atracIDs[atID].isInUse()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("checkAtracID invalid atracID=0x%X", atID));
            }
            throw new SceKernelErrorException(-2140995579);
        }
        return atID;
    }

    private static int read24(Memory mem, int address) {
        return mem.read8(address + 0) << 16 | mem.read8(address + 1) << 8 | mem.read8(address + 2) << 0;
    }

    private static int read16(Memory mem, int address) {
        return mem.read8(address) << 8 | mem.read8(address + 1);
    }

    private static int analyzeAA3File(TPointer buffer, int fileSize, AtracFileInfo info) {
        int samplesPerFrame;
        int headerSize;
        Memory mem = buffer.getMemory();
        int address = buffer.getAddress();
        int codecType = 0;
        int magic = sceAtrac3plus.read24(mem, address);
        address += 3;
        if (magic != 6644019 && magic != 0x494433) {
            log.error((Object)String.format("Unknown AA3 magic 0x%06X", magic));
            return codecType;
        }
        if (mem.read8(address) != 3 || mem.read8(address + 1) != 0) {
            log.error((Object)String.format("Unknown AA3 bytes 0x%08X 0x%08X", mem.read8(address), mem.read8(address + 1)));
            return -2140991486;
        }
        address += 3;
        if (mem.read8(address += 4 + (headerSize = sceAtrac3plus.read28(mem, address))) == 0) {
            address += 16;
        }
        info.inputFileDataOffset = address - buffer.getAddress();
        magic = sceAtrac3plus.read24(mem, address);
        if (magic != 4538675) {
            log.error((Object)String.format("Unknown AA3 magic 0x%06X", magic));
            return -2140991485;
        }
        int dataOffset = sceAtrac3plus.read16(mem, address += 4);
        if (dataOffset == 65535) {
            return -2140991485;
        }
        int unknown2 = sceAtrac3plus.read16(mem, address += 2);
        if (unknown2 != 65535) {
            return -2140991485;
        }
        address += 2;
        int flags = sceAtrac3plus.read16(mem, (address += 24) + 2);
        switch (mem.read8(address)) {
            case 0: {
                if ((flags & 0xE000) != 8192) {
                    return -2140991483;
                }
                codecType = 4097;
                samplesPerFrame = 1024;
                info.atracChannels = 2;
                info.atracCodingMode = (mem.read8(address + 1) & 2) >> 1;
                info.atracBytesPerFrame = (flags & 0x3FF) << 3;
                break;
            }
            case 1: {
                if ((flags & 0x1C00) != 2048) {
                    return -2140991483;
                }
                if ((flags & 0xE000) != 8192) {
                    return -2140991483;
                }
                codecType = 4096;
                samplesPerFrame = 2048;
                info.atracChannels = 2;
                info.atracBytesPerFrame = ((flags & 0x3FF) << 3) + 8;
                break;
            }
            default: {
                return -2140991484;
            }
        }
        info.inputFileDataOffset += dataOffset;
        info.inputFileSize = fileSize;
        info.inputDataSize = fileSize - info.inputFileDataOffset;
        info.atracEndSample = info.inputDataSize / info.atracBytesPerFrame * samplesPerFrame;
        return codecType;
    }

    protected int hleSetAA3HalfwayBufferAndGetID(TPointer buffer, int readSize, int bufferSize, boolean isMonoOutput, int fileSize) {
        if (readSize > bufferSize) {
            return -2140995565;
        }
        AtracFileInfo info = new AtracFileInfo();
        int codecType = sceAtrac3plus.analyzeAA3File(buffer, fileSize, info);
        if (codecType < 0) {
            return codecType;
        }
        int atID = this.hleGetAtracID(codecType);
        if (atID < 0) {
            return atID;
        }
        AtracID id = this.atracIDs[atID];
        int result = id.setHalfwayBuffer(buffer.getAddress(), readSize, bufferSize, isMonoOutput, info);
        if (result < 0) {
            this.hleReleaseAtracID(atID);
            return result;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleSetHalfwayBufferAndGetID returning atID=0x%X", atID));
        }
        Modules.ThreadManForUserModule.hleYieldCurrentThread();
        return atID;
    }

    public AtracID getAtracIdFromContext(int atrac3Context) {
        for (int i = 0; i < this.atracIDs.length; ++i) {
            SysMemUserForUser.SysMemInfo context;
            AtracID id = this.atracIDs[i];
            if (!id.isInUse() || (context = id.getContext()) == null || context.addr != atrac3Context) continue;
            return id;
        }
        return null;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-772431909, version=150, checkInsideInterrupt=true)
    public int sceAtracStartEntry() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-708670272, version=150, checkInsideInterrupt=true)
    public int sceAtracEndEntry() {
        return 0;
    }

    @HLEFunction(nid=2014283985, version=150, checkInsideInterrupt=true)
    public int sceAtracGetAtracID(int codecType) {
        int atId = this.hleGetAtracID(codecType);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetAtracID: returning atID=0x%X", atId));
        }
        return atId;
    }

    @HLEFunction(nid=1642804213, version=150, checkInsideInterrupt=true)
    public int sceAtracReleaseAtracID(@CheckArgument(value="checkAtracID") int atID) {
        this.hleReleaseAtracID(atID);
        return 0;
    }

    @HLEFunction(nid=237663147, version=150, checkInsideInterrupt=true)
    public int sceAtracSetData(@CheckArgument(value="checkAtracID") int atID, TPointer buffer, int bufferSize) {
        return this.hleSetHalfwayBuffer(atID, buffer, bufferSize, bufferSize, false);
    }

    @HLEFunction(nid=1064183477, version=150, checkInsideInterrupt=true)
    public int sceAtracSetHalfwayBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer halfBuffer, int readSize, int halfBufferSize) {
        return this.hleSetHalfwayBuffer(atID, halfBuffer, readSize, halfBufferSize, false);
    }

    @HLEFunction(nid=2048976815, version=150, checkInsideInterrupt=true)
    public int sceAtracSetDataAndGetID(TPointer buffer, int bufferSize) {
        return this.hleSetHalfwayBufferAndGetID(buffer, bufferSize, bufferSize, false);
    }

    @HLEFunction(nid=263075598, version=150, checkInsideInterrupt=true)
    public int sceAtracSetHalfwayBufferAndGetID(TPointer halfBuffer, int readSize, int halfBufferSize) {
        return this.hleSetHalfwayBufferAndGetID(halfBuffer, readSize, halfBufferSize, false);
    }

    @HLEFunction(nid=1787575509, version=150, checkInsideInterrupt=true)
    public int sceAtracDecodeData(@CheckArgument(value="checkAtracID") int atID, @CanBeNull TPointer16 samplesAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 samplesNbrAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 outEndAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 remainFramesAddr) {
        AtracID id = this.atracIDs[atID];
        if (id.isSecondBufferNeeded() && !id.isSecondBufferSet()) {
            log.warn((Object)String.format("sceAtracDecodeData atracID=0x%X needs second buffer!", atID));
            return -2140995566;
        }
        int result = id.decodeData(samplesAddr.getAddress(), outEndAddr);
        if (result < 0) {
            samplesNbrAddr.setValue(0);
            return result;
        }
        samplesNbrAddr.setValue(id.getNumberOfSamples());
        remainFramesAddr.setValue(id.getRemainFrames());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracDecodeData returning 0x%08X, samples=0x%X, end=%d, remainFrames=%d, currentSample=0x%X/0x%X, %s", result, samplesNbrAddr.getValue(), outEndAddr.getValue(), remainFramesAddr.getValue(), id.getAtracCurrentSample(), id.getAtracEndSample(), id));
        }
        if (result == 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        }
        return result;
    }

    @HLEFunction(nid=-1696052825, version=150, checkInsideInterrupt=true)
    public int sceAtracGetRemainFrame(@CheckArgument(value="checkAtracID") int atID, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 remainFramesAddr) {
        AtracID id = this.atracIDs[atID];
        remainFramesAddr.setValue(id.getRemainFrames());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetRemainFrame returning %d, %s", remainFramesAddr.getValue(), id));
        }
        return 0;
    }

    @HLEFunction(nid=1562806023, version=150, checkInsideInterrupt=true)
    public int sceAtracGetStreamDataInfo(@CheckArgument(value="checkAtracID") int atID, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 writeAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 writableBytesAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 readOffsetAddr) {
        AtracID id = this.atracIDs[atID];
        id.getStreamDataInfo(writeAddr, writableBytesAddr, readOffsetAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetStreamDataInfo write=0x%08X, writableBytes=0x%X, readOffset=0x%X, %s", writeAddr.getValue(), writableBytesAddr.getValue(), readOffsetAddr.getValue(), id));
        }
        return 0;
    }

    @HLEFunction(nid=2108887633, version=150, checkInsideInterrupt=true)
    public int sceAtracAddStreamData(@CheckArgument(value="checkAtracID") int atID, int bytesToAdd) {
        AtracID id = this.atracIDs[atID];
        id.addStreamData(bytesToAdd);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracAddStreamData: %s", id));
        }
        return 0;
    }

    @HLEFunction(nid=-2081923424, version=150, checkInsideInterrupt=true)
    public int sceAtracGetSecondBufferInfo(@CheckArgument(value="checkAtracID") int atID, TPointer32 outPosition, TPointer32 outBytes) {
        AtracID id = this.atracIDs[atID];
        if (!id.isSecondBufferNeeded()) {
            outPosition.setValue(0);
            outBytes.setValue(0);
            return -2140995550;
        }
        outPosition.setValue(id.getSecondBufferReadPosition());
        outBytes.setValue(id.getSecondBufferSize());
        return 0;
    }

    @HLEFunction(nid=-2084603139, version=150, checkInsideInterrupt=true)
    public int sceAtracSetSecondBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer secondBuffer, int secondBufferSize) {
        AtracID id = this.atracIDs[atID];
        id.setSecondBuffer(secondBuffer.getAddress(), secondBufferSize);
        return 0;
    }

    @HLEFunction(nid=-499238347, version=150, checkInsideInterrupt=true)
    public int sceAtracGetNextDecodePosition(@CheckArgument(value="checkAtracID") int atID, TPointer32 posAddr) {
        AtracID id = this.atracIDs[atID];
        if (id.getAtracCurrentSample() >= id.getAtracEndSample()) {
            return -2140995548;
        }
        posAddr.setValue(id.getAtracCurrentSample());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextDecodePosition returning pos=%d", posAddr.getValue()));
        }
        return 0;
    }

    @HLEFunction(nid=-1564759874, version=150, checkInsideInterrupt=true)
    public int sceAtracGetSoundSample(@CheckArgument(value="checkAtracID") int atID, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 endSampleAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 loopStartSampleAddr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 loopEndSampleAddr) {
        AtracID id = this.atracIDs[atID];
        int endSample = id.getAtracEndSample();
        int loopStartSample = id.getLoopStartSample();
        int loopEndSample = id.getLoopEndSample();
        if (endSample < 0) {
            endSample = id.getAtracEndSample();
        }
        if (endSample < 0) {
            endSample = id.getInputFileSize();
        }
        endSampleAddr.setValue(endSample);
        loopStartSampleAddr.setValue(loopStartSample);
        loopEndSampleAddr.setValue(loopEndSample);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetSoundSample returning endSample=0x%X, loopStartSample=0x%X, loopEndSample=0x%X", endSample, loopStartSample, loopEndSample));
        }
        return 0;
    }

    @HLEFunction(nid=828804010, version=150, checkInsideInterrupt=true)
    public int sceAtracGetChannel(@CheckArgument(value="checkAtracID") int atID, TPointer32 channelAddr) {
        AtracID id = this.atracIDs[atID];
        channelAddr.setValue(id.getChannels());
        return 0;
    }

    @HLEFunction(nid=-693767433, version=150, checkInsideInterrupt=true)
    public int sceAtracGetMaxSample(@CheckArgument(value="checkAtracID") int atID, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 maxSamplesAddr) {
        AtracID id = this.atracIDs[atID];
        maxSamplesAddr.setValue(id.getMaxSamples());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetMaxSample returning maxSamples=0x%X", id.getMaxSamples()));
        }
        return 0;
    }

    @HLEFunction(nid=922397691, version=150, checkInsideInterrupt=true)
    public int sceAtracGetNextSample(@CheckArgument(value="checkAtracID") int atID, TPointer32 nbrSamplesAddr) {
        AtracID id = this.atracIDs[atID];
        int samples = id.getMaxSamples();
        if (id.getInputBuffer().isEmpty()) {
            samples = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetNextSample returning %d samples", samples));
        }
        nbrSamplesAddr.setValue(samples);
        return 0;
    }

    @HLEFunction(nid=-1521180328, version=150, checkInsideInterrupt=true)
    public int sceAtracGetBitrate(@CheckArgument(value="checkAtracID") int atID, TPointer32 bitrateAddr) {
        AtracID id = this.atracIDs[atID];
        int bitrate = id.getAtracBytesPerFrame() * 352800 / 1000;
        bitrate = id.getCodecType() == 4096 ? (bitrate >> 11) + 8 & 0xFFFFFFF0 : bitrate + 511 >> 10;
        bitrateAddr.setValue(bitrate);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracGetBitrate returning bitRate=0x%X", bitrate));
        }
        return 0;
    }

    @HLEFunction(nid=-89851749, version=150, checkInsideInterrupt=true)
    public int sceAtracGetLoopStatus(@CheckArgument(value="checkAtracID") int atID, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 loopNbr, @CanBeNull @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 statusAddr) {
        AtracID id = this.atracIDs[atID];
        loopNbr.setValue(id.getLoopNum());
        statusAddr.setValue(id.getLoopStatus());
        return 0;
    }

    @HLEFunction(nid=-2038357835, version=150, checkInsideInterrupt=true)
    public int sceAtracSetLoopNum(@CheckArgument(value="checkAtracID") int atID, int loopNbr) {
        AtracID id = this.atracIDs[atID];
        if (!id.hasLoop()) {
            return -2140995551;
        }
        id.setLoopNum(loopNbr);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-901995566, version=150, checkInsideInterrupt=true)
    public int sceAtracGetBufferInfoForReseting(@CheckArgument(value="checkAtracID") int atID, int sample, TPointer32 bufferInfoAddr) {
        AtracID id = this.atracIDs[atID];
        return id.getBufferInfoForResetting(sample, bufferInfoAddr);
    }

    @HLEFunction(nid=1682855431, version=150, checkInsideInterrupt=true)
    public int sceAtracResetPlayPosition(@CheckArgument(value="checkAtracID") int atID, int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
        AtracID id = this.atracIDs[atID];
        id.setPlayPosition(sample, bytesWrittenFirstBuf, bytesWrittenSecondBuf);
        return 0;
    }

    @HLEFunction(nid=-393251429, version=150, checkInsideInterrupt=true)
    public int sceAtracGetInternalErrorInfo(@CheckArgument(value="checkAtracID") int atID, TPointer32 errorAddr) {
        AtracID id = this.atracIDs[atID];
        errorAddr.setValue(id.getInternalErrorInfo());
        return 0;
    }

    @HLEFunction(nid=-1279930302, version=250, checkInsideInterrupt=true)
    public int sceAtracGetOutputChannel(@CheckArgument(value="checkAtracID") int atID, TPointer32 outputChannelAddr) {
        AtracID id = this.atracIDs[atID];
        outputChannelAddr.setValue(id.getOutputChannels());
        return 0;
    }

    @HLEFunction(nid=-324851047, version=250, checkInsideInterrupt=true)
    public boolean sceAtracIsSecondBufferNeeded(@CheckArgument(value="checkAtracID") int atID) {
        AtracID id = this.atracIDs[atID];
        return id.isSecondBufferNeeded();
    }

    @HLEFunction(nid=321855178, version=250, checkInsideInterrupt=true)
    public int sceAtracReinit(int at3IDNum, int at3plusIDNum) {
        int result = 0;
        if ((at3IDNum != 0 || at3plusIDNum != 0) && (result = this.hleAtracReinit(at3IDNum, at3plusIDNum)) >= 0) {
            Modules.ThreadManForUserModule.hleYieldCurrentThread();
        }
        return result;
    }

    @HLEFunction(nid=768860824, version=250, checkInsideInterrupt=true)
    public int sceAtracGetBufferInfoForResetting(@CheckArgument(value="checkAtracID") int atID, int sample, TPointer32 bufferInfoAddr) {
        AtracID id = this.atracIDs[atID];
        return id.getBufferInfoForResetting(sample, bufferInfoAddr);
    }

    @HLEFunction(nid=1559877714, version=250, checkInsideInterrupt=true)
    public int sceAtracSetMOutHalfwayBuffer(@CheckArgument(value="checkAtracID") int atID, TPointer MOutHalfBuffer, int readSize, int MOutHalfBufferSize) {
        return this.hleSetHalfwayBuffer(atID, MOutHalfBuffer, readSize, MOutHalfBufferSize, true);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-159155686, version=250, checkInsideInterrupt=true)
    public int sceAtracSetMOutData(@CheckArgument(value="checkAtracID") int atID, int unknown2, int unknown3, int unknown4, int unknown5, int unknown6) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1194211365, version=250, checkInsideInterrupt=true)
    public int sceAtracSetMOutDataAndGetID(int unknown1, int unknown2, int unknown3, int unknown4, int unknown5, int unknown6) {
        return 0;
    }

    @HLEFunction(nid=-1663574525, version=250, checkInsideInterrupt=true)
    public int sceAtracSetMOutHalfwayBufferAndGetID(TPointer MOutHalfBuffer, int readSize, int MOutHalfBufferSize) {
        return this.hleSetHalfwayBufferAndGetID(MOutHalfBuffer, readSize, MOutHalfBufferSize, true);
    }

    @HLEFunction(nid=1445115841, version=250, checkInsideInterrupt=true)
    public int sceAtracSetAA3DataAndGetID(TPointer buffer, int bufferSize, int fileSize, int unused) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetAA3DataAndGetID buffer:%s", Utilities.getMemoryDump(buffer.getAddress(), bufferSize)));
        }
        return this.hleSetAA3HalfwayBufferAndGetID(buffer, bufferSize, bufferSize, false, fileSize);
    }

    @HLEFunction(nid=1574331784, version=250)
    public int sceAtracSetAA3HalfwayBufferAndGetID(TPointer buffer, int readSize, int bufferSize, int fileSize, int unused) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracSetAA3HalfwayBufferAndGetID buffer:%s", Utilities.getMemoryDump(buffer.getAddress(), readSize)));
        }
        return this.hleSetAA3HalfwayBufferAndGetID(buffer, readSize, bufferSize, false, fileSize);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=589285047, version=600, checkInsideInterrupt=true)
    public int _sceAtracGetContextAddress(int atID) {
        if (atID < 0 || atID >= this.atracIDs.length || !this.atracIDs[atID].isInUse()) {
            return 0;
        }
        AtracID id = this.atracIDs[atID];
        id.createContext();
        SysMemUserForUser.SysMemInfo atracContext = id.getContext();
        if (atracContext == null) {
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("_sceAtracGetContextAddress returning 0x%08X", atracContext.addr));
        }
        return atracContext.addr;
    }

    @HLEFunction(nid=202468891, version=620)
    public int sceAtracLowLevelDecode(@CheckArgument(value="checkAtracID") int atID, TPointer sourceAddr, TPointer32 sourceBytesConsumedAddr, TPointer samplesAddr, TPointer32 sampleBytesAddr) {
        AtracID id = this.atracIDs[atID];
        ICodec codec = id.getCodec();
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceAtracLowLevelDecode input:%s", Utilities.getMemoryDump(sourceAddr.getAddress(), id.getSourceBufferLength())));
        }
        int sourceBytesConsumed = 0;
        int bytesPerSample = id.getOutputChannels() << 1;
        int result = codec.decode(sourceAddr.getMemory(), sourceAddr.getAddress(), id.getSourceBufferLength(), samplesAddr.getMemory(), samplesAddr.getAddress());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracLowLevelDecode codec returned 0x%08X", result));
        }
        if (result < 0) {
            log.info((Object)String.format("sceAtracLowLevelDecode codec returning 0x%08X", result));
            return result;
        }
        sourceBytesConsumed = result > 0 ? id.getSourceBufferLength() : 0;
        sampleBytesAddr.setValue(codec.getNumberOfSamples() * bytesPerSample);
        sourceBytesConsumedAddr.setValue(sourceBytesConsumed);
        Modules.ThreadManForUserModule.hleKernelDelayThread(2300, false);
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=360044107, version=620)
    public int sceAtracLowLevelInitDecoder(@CheckArgument(value="checkAtracID") int atID, TPointer32 paramsAddr) {
        int numberOfChannels = paramsAddr.getValue(0);
        int outputChannels = paramsAddr.getValue(4);
        int sourceBufferLength = paramsAddr.getValue(8);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceAtracLowLevelInitDecoder values at %s: numberOfChannels=%d, outputChannels=%d, sourceBufferLength=0x%08X", paramsAddr, numberOfChannels, outputChannels, sourceBufferLength));
        }
        AtracID id = this.atracIDs[atID];
        int result = 0;
        id.setChannels(numberOfChannels);
        id.setOutputChannels(outputChannels);
        id.setSourceBufferLength(sourceBufferLength);
        result = id.getCodec().init(sourceBufferLength, numberOfChannels, outputChannels, 0);
        id.setCodecInitialized();
        return result;
    }

    public static class AtracID
    extends sceAudiocodec.AudiocodecInfo {
        protected int codecType;
        protected boolean inUse;
        protected int currentReadPosition;
        protected SysMemUserForUser.SysMemInfo atracContext;
        protected SysMemUserForUser.SysMemInfo internalBuffer;
        protected AtracFileInfo info = new AtracFileInfo();
        protected int atracCurrentSample;
        protected int maxSamples;
        protected int skippedSamples;
        protected int skippedEndSamples;
        private int startSkippedSamples;
        protected int lastDecodedSamples;
        protected int channels;
        protected pspFileBuffer inputBuffer;
        protected boolean reloadingFromLoopStart;
        protected int secondBufferAddr = -1;
        protected int secondBufferSize;
        protected int secondInputFileSize;
        protected boolean isSecondBufferNeeded;
        protected boolean isSecondBufferSet;
        protected int internalErrorInfo;
        protected int currentLoopNum = -1;
        protected int sourceBufferLength;
        protected int getStreamDataInfoCurrentSample;

        public AtracID(int id) {
            super(id);
        }

        @Override
        public void release() {
            super.release();
            this.setInUse(false);
            this.releaseContext();
            this.releaseInternalBuffer();
        }

        public int setHalfwayBuffer(int addr, int readSize, int bufferSize, boolean isMonoOutput, AtracFileInfo info) {
            int maxSizeAligned;
            this.info = info;
            this.channels = info.atracChannels;
            int maxSizeBeforeFirstWrap = bufferSize;
            int maxSizeAfterFirstWrap = bufferSize;
            if (readSize < bufferSize && (maxSizeAligned = bufferSize - (bufferSize - info.inputFileDataOffset) % info.atracBytesPerFrame) >= readSize) {
                maxSizeBeforeFirstWrap = maxSizeAligned;
                maxSizeAfterFirstWrap = bufferSize - bufferSize % info.atracBytesPerFrame;
            }
            this.inputBuffer = new pspFileBuffer(addr, maxSizeBeforeFirstWrap, maxSizeAfterFirstWrap, readSize, readSize);
            this.inputBuffer.notifyRead(info.inputFileDataOffset);
            this.inputBuffer.setFileMaxSize(info.inputFileSize);
            this.currentReadPosition = info.inputFileDataOffset;
            this.atracCurrentSample = 0;
            this.currentLoopNum = -1;
            this.lastDecodedSamples = 0;
            this.setOutputChannels(isMonoOutput ? 1 : 2);
            int result = this.codec.init(info.atracBytesPerFrame, this.channels, this.outputChannels, info.atracCodingMode);
            if (result < 0) {
                return result;
            }
            this.setCodecInitialized();
            return 0;
        }

        public int decodeData(int samplesAddr, TPointer32 outEndAddr) {
            int result;
            int currentSample;
            this.skippedEndSamples = 0;
            Memory mem = Memory.getInstance();
            if (this.currentReadPosition + this.info.atracBytesPerFrame > this.info.inputFileSize || this.getAtracCurrentSample() - this.info.atracSampleOffset > this.info.atracEndSample) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("decodeData returning ERROR_ATRAC_ALL_DATA_DECODED", new Object[0]));
                }
                outEndAddr.setValue(true);
                return -2140995548;
            }
            if (this.inputBuffer.getCurrentSize() < this.info.atracBytesPerFrame) {
                if (this.getSecondBufferAddr() > 0 && this.getSecondBufferSize() >= this.info.atracBytesPerFrame) {
                    this.addSecondBufferStreamData();
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("decodeData returning ERROR_ATRAC_BUFFER_IS_EMPTY", new Object[0]));
                    }
                    outEndAddr.setValue(false);
                    return -2140995549;
                }
            }
            int nextCurrentSample = currentSample = this.getAtracCurrentSample();
            this.skippedSamples = currentSample == 0 ? this.startSkippedSamples + this.info.atracSampleOffset : (currentSample + this.startSkippedSamples + this.info.atracSampleOffset) % this.maxSamples;
            while (this.skippedSamples >= this.maxSamples) {
                this.inputBuffer.notifyRead(this.info.atracBytesPerFrame);
                this.currentReadPosition += this.info.atracBytesPerFrame;
                this.skippedSamples -= this.maxSamples;
                nextCurrentSample += this.maxSamples;
            }
            int readAddr = this.inputBuffer.getReadAddr();
            if (this.inputBuffer.getReadSize() < this.info.atracBytesPerFrame) {
                if (temporaryDecodeArea == null || temporaryDecodeArea.allocatedSize < this.info.atracBytesPerFrame) {
                    if (temporaryDecodeArea != null) {
                        Modules.SysMemUserForUserModule.free(temporaryDecodeArea);
                    }
                    temporaryDecodeArea = Modules.SysMemUserForUserModule.malloc(1, "Temporary-sceAtrac3plus-DecodeData", 0, this.info.atracBytesPerFrame, 0);
                }
                if (temporaryDecodeArea != null) {
                    readAddr = temporaryDecodeArea.addr;
                    int wrapLength = this.inputBuffer.getReadSize();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("decodeData from temporary buffer: 0x%08X/0x%X (from 0x%08X), 0x%08X/0x%X (from 0x%08X)", readAddr, wrapLength, this.inputBuffer.getReadAddr(), readAddr + wrapLength, this.info.atracBytesPerFrame - wrapLength, this.inputBuffer.getAddr()));
                    }
                    mem.memcpy(readAddr, this.inputBuffer.getReadAddr(), wrapLength);
                    mem.memcpy(readAddr + wrapLength, this.inputBuffer.getAddr(), this.info.atracBytesPerFrame - wrapLength);
                }
            }
            SysMemUserForUser.SysMemInfo tempBuffer = null;
            int decodedSamplesAddr = samplesAddr;
            int bytesPerSample = 2 * this.getOutputChannels();
            if (this.skippedSamples > 0) {
                int tempBufferSize = this.getMaxSamples() * bytesPerSample;
                tempBuffer = Modules.SysMemUserForUserModule.malloc(1, "sceAtrac3plus-temp-decode-buffer", 0, tempBufferSize, 0);
                if (tempBuffer == null) {
                    log.warn((Object)String.format("decodeData cannot allocate required temporary buffer of size=0x%X", tempBufferSize));
                } else {
                    decodedSamplesAddr = tempBuffer.addr;
                }
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("decodeData from 0x%08X(0x%X) to 0x%08X(0x%X), skippedSamples=0x%X, currentSample=0x%X, outputChannels=%d", readAddr, this.info.atracBytesPerFrame, decodedSamplesAddr, this.maxSamples, this.skippedSamples, currentSample, this.outputChannels));
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("decodeData from:%s", Utilities.getMemoryDump(readAddr, this.info.atracBytesPerFrame)));
                }
            }
            if ((result = this.codec.decode(mem, readAddr, this.info.atracBytesPerFrame, mem, decodedSamplesAddr)) < 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("decodeData received codec decode error 0x%08X", result));
                }
                outEndAddr.setValue(false);
                if (tempBuffer != null) {
                    Modules.SysMemUserForUserModule.free(tempBuffer);
                }
                return -2140995582;
            }
            this.inputBuffer.notifyRead(this.info.atracBytesPerFrame);
            this.currentReadPosition += this.info.atracBytesPerFrame;
            if ((nextCurrentSample += this.codec.getNumberOfSamples() - this.skippedSamples) - this.info.atracSampleOffset > this.info.atracEndSample) {
                outEndAddr.setValue(this.info.loopNum == 0);
                this.skippedEndSamples = nextCurrentSample - this.info.atracSampleOffset - this.info.atracEndSample - 1;
            } else {
                outEndAddr.setValue(false);
            }
            this.setAtracCurrentSample(nextCurrentSample);
            if (this.skippedSamples > 0) {
                int returnedSamples = this.getNumberOfSamples();
                mem.memmove(samplesAddr, decodedSamplesAddr + this.skippedSamples * bytesPerSample, returnedSamples * bytesPerSample);
            }
            if (tempBuffer != null) {
                Modules.SysMemUserForUserModule.free(tempBuffer);
                tempBuffer = null;
            }
            for (int i = 0; i < this.info.numLoops; ++i) {
                LoopInfo loop = this.info.loops[i];
                if (currentSample <= loop.startSample && loop.startSample < nextCurrentSample) {
                    this.currentLoopNum = i;
                    break;
                }
                if (currentSample > loop.endSample || loop.endSample >= nextCurrentSample || this.currentLoopNum != i) continue;
                if (this.info.loopNum == 0) {
                    this.currentLoopNum = -1;
                    continue;
                }
                log.info((Object)String.format("Replaying atrac loop atracID=%d, loopStart=0x%X, loopEnd=0x%X", this.id, loop.startSample, loop.endSample));
                this.setPlayPosition(loop.startSample);
                nextCurrentSample = loop.startSample;
                if (this.info.loopNum <= 0) break;
                --this.info.loopNum;
                break;
            }
            return 0;
        }

        public void getStreamDataInfo(TPointer32 writeAddr, TPointer32 writableBytesAddr, TPointer32 readOffsetAddr) {
            if (this.inputBuffer.getFileWriteSize() <= 0 && this.currentLoopNum >= 0 && this.info.loopNum != 0) {
                this.inputBuffer.setFilePosition(this.getFilePositionFromSample(this.info.loops[this.currentLoopNum].startSample));
                this.reloadingFromLoopStart = true;
            }
            this.getStreamDataInfoCurrentSample = this.getAtracCurrentSample();
            writeAddr.setValue(this.inputBuffer.getWriteAddr());
            writableBytesAddr.setValue(this.inputBuffer.getWriteSize());
            readOffsetAddr.setValue(this.inputBuffer.getFilePosition());
        }

        protected void addStreamData(int length) {
            if (length > 0) {
                if (this.getAtracCurrentSample() < this.getStreamDataInfoCurrentSample) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("addStreamData ignored as the atrac has looped inbetween: sample 0x%X -> 0x%X", this.getStreamDataInfoCurrentSample, this.getAtracCurrentSample()));
                    }
                } else {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("addStreamData length=0x%X: %s", length, Utilities.getMemoryDump(this.inputBuffer.getWriteAddr(), length)));
                    }
                    this.inputBuffer.notifyWrite(length);
                }
            }
        }

        private void addSecondBufferStreamData() {
            while (this.inputBuffer.getWriteSize() > 0 && this.secondBufferSize > 0) {
                int length = Math.min(this.inputBuffer.getWriteSize(), this.secondBufferSize);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("addSecondBufferStreamData from 0x%08X to 0x%08X, length=0x%X", this.secondBufferAddr, this.inputBuffer.getWriteAddr(), length));
                }
                Memory.getInstance().memcpy(this.inputBuffer.getWriteAddr(), this.secondBufferAddr, length);
                this.addStreamData(length);
                this.secondBufferAddr += length;
                this.secondBufferSize -= length;
            }
            if (this.secondBufferSize <= 0) {
                this.secondBufferAddr = -1;
                this.secondBufferSize = 0;
            }
        }

        public void setSecondBuffer(int address, int size) {
            this.secondBufferAddr = address;
            this.secondBufferSize = size;
        }

        public int getSecondBufferAddr() {
            return this.secondBufferAddr;
        }

        public int getSecondBufferSize() {
            return this.secondBufferSize;
        }

        public int getSecondBufferReadPosition() {
            return 0;
        }

        public void createContext() {
            if (this.atracContext == null) {
                this.atracContext = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-AtracCtx-%d", this.id), 1, 200, 0);
                if (this.atracContext != null) {
                    Memory mem = Memory.getInstance();
                    int contextAddr = this.atracContext.addr;
                    mem.memset(contextAddr, (byte)0, this.atracContext.size);
                    if (this.hasLoop()) {
                        mem.write32(contextAddr + 140, this.info.loops[0].endSample);
                    } else {
                        mem.write32(contextAddr + 140, 0);
                    }
                    mem.write8(contextAddr + 149, (byte)2);
                    mem.write8(contextAddr + 151, (byte)this.getChannels());
                    mem.write16(contextAddr + 154, (short)this.getCodecType());
                    mem.write32(contextAddr + 160, this.getInputBuffer().getFilePosition());
                    mem.write32(contextAddr + 164, this.getInputBuffer().getFilePosition());
                    mem.write32(contextAddr + 188, 0);
                }
            }
        }

        private void releaseContext() {
            if (this.atracContext != null) {
                Modules.SysMemUserForUserModule.free(this.atracContext);
                this.atracContext = null;
            }
        }

        public SysMemUserForUser.SysMemInfo getContext() {
            return this.atracContext;
        }

        public void createInternalBuffer(int size) {
            if (this.internalBuffer == null) {
                this.internalBuffer = Modules.SysMemUserForUserModule.malloc(2, String.format("ThreadMan-AtracBuf-%d", this.id), 0, size, 0);
            }
        }

        private void releaseInternalBuffer() {
            if (this.internalBuffer != null) {
                Modules.SysMemUserForUserModule.free(this.internalBuffer);
                this.internalBuffer = null;
            }
        }

        public SysMemUserForUser.SysMemInfo getInternalBuffer() {
            return this.internalBuffer;
        }

        public int getCodecType() {
            return this.codecType;
        }

        public void setCodecType(int codecType) {
            this.codecType = codecType;
            if (codecType == 4097) {
                this.maxSamples = 1024;
                this.startSkippedSamples = 69;
            } else if (codecType == 4096) {
                this.maxSamples = 2048;
                this.startSkippedSamples = 368;
            } else {
                this.maxSamples = 0;
                this.startSkippedSamples = 0;
            }
        }

        public int getAtracBitrate() {
            return this.info.atracBitrate;
        }

        public int getChannels() {
            return this.channels;
        }

        public void setChannels(int channels) {
            this.channels = channels;
        }

        public int getAtracSampleRate() {
            return this.info.atracSampleRate;
        }

        public int getAtracEndSample() {
            return this.info.atracEndSample;
        }

        public int getAtracCurrentSample() {
            return this.atracCurrentSample;
        }

        public int getAtracBytesPerFrame() {
            return this.info.atracBytesPerFrame;
        }

        public void setAtracCurrentSample(int sample) {
            this.atracCurrentSample = sample;
        }

        public int getLoopNum() {
            if (!this.hasLoop()) {
                return 0;
            }
            return this.info.loopNum;
        }

        public void setLoopNum(int num) {
            this.info.loopNum = num;
        }

        public int getMaxSamples() {
            return this.maxSamples;
        }

        public pspFileBuffer getInputBuffer() {
            return this.inputBuffer;
        }

        public int getInputFileSize() {
            return this.info.inputFileSize;
        }

        public void setInputFileSize(int bytes) {
            this.info.inputFileSize = bytes;
        }

        public int getSecondInputFileSize() {
            return this.secondInputFileSize;
        }

        public boolean isSecondBufferNeeded() {
            return this.isSecondBufferNeeded;
        }

        public boolean isSecondBufferSet() {
            return this.isSecondBufferSet;
        }

        public int getInternalErrorInfo() {
            return this.internalErrorInfo;
        }

        public int getRemainFrames() {
            if (this.inputBuffer == null) {
                return 0;
            }
            if (this.inputBufferContainsAllData()) {
                return -1;
            }
            if (!(this.hasLoop() && this.info.loopNum != 0 || this.inputBuffer.getFileWriteSize() > 0)) {
                return -2;
            }
            int remainFrames = this.inputBuffer.getCurrentSize() / this.info.atracBytesPerFrame;
            return remainFrames;
        }

        public int getBufferInfoForResetting(int sample, TPointer32 bufferInfoAddr) {
            int readPosition;
            int minimumWriteBytes;
            int writableBytes;
            if (sample > this.getAtracEndSample()) {
                return -2140995563;
            }
            if (this.inputBufferContainsAllData()) {
                writableBytes = 0;
                minimumWriteBytes = 0;
                readPosition = 0;
            } else {
                writableBytes = this.inputBuffer.getMaxSize();
                minimumWriteBytes = this.info.atracBytesPerFrame * 2;
                readPosition = sample == 0 ? 0 : this.getFilePositionFromSample(sample);
            }
            bufferInfoAddr.setValue(0, this.inputBuffer.getAddr());
            bufferInfoAddr.setValue(4, writableBytes);
            bufferInfoAddr.setValue(8, minimumWriteBytes);
            bufferInfoAddr.setValue(12, readPosition);
            bufferInfoAddr.setValue(16, this.getSecondBufferAddr());
            bufferInfoAddr.setValue(20, this.getSecondBufferSize());
            bufferInfoAddr.setValue(24, this.getSecondBufferSize());
            bufferInfoAddr.setValue(28, this.getSecondBufferReadPosition());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceAtracGetBufferInfoForReseting returning writeAddr=0x%08X, writeMaxSize=0x%X, writeMinSize=0x%X, readPosition=0x%X", bufferInfoAddr.getValue(0), bufferInfoAddr.getValue(4), bufferInfoAddr.getValue(8), bufferInfoAddr.getValue(12)));
            }
            return 0;
        }

        public void setPlayPosition(int sample, int bytesWrittenFirstBuf, int bytesWrittenSecondBuf) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceAtracResetPlayPosition: %s", Utilities.getMemoryDump(this.inputBuffer.getWriteAddr(), bytesWrittenFirstBuf)));
            }
            if (sample != this.atracCurrentSample) {
                if (!this.inputBufferContainsAllData()) {
                    this.currentReadPosition = this.getFilePositionFromSample(sample);
                    this.inputBuffer.reset(bytesWrittenFirstBuf, this.currentReadPosition);
                } else {
                    this.currentReadPosition = this.getFilePositionFromSample(sample);
                    this.inputBuffer.reset(this.inputBuffer.getFilePosition(), 0);
                    this.inputBuffer.notifyRead(this.currentReadPosition);
                }
                this.setAtracCurrentSample(sample);
            }
        }

        private boolean inputBufferContainsAllData() {
            return this.inputBuffer != null && this.inputBuffer.getMaxSize() >= this.info.inputFileSize && this.inputBuffer.getReadSize() + this.currentReadPosition >= this.info.inputFileSize;
        }

        private int getFilePositionFromSample(int sample) {
            return this.info.inputFileDataOffset + sample / this.maxSamples * this.info.atracBytesPerFrame;
        }

        public void setPlayPosition(int sample) {
            if (sample / this.maxSamples * this.maxSamples != this.getAtracCurrentSample()) {
                if (this.inputBufferContainsAllData()) {
                    this.getInputBuffer().reset(this.inputBuffer.getFilePosition(), 0);
                    this.getInputBuffer().notifyRead(this.getFilePositionFromSample(sample));
                } else if (this.reloadingFromLoopStart && this.currentLoopNum >= 0 && sample == this.info.loops[this.currentLoopNum].startSample) {
                    this.reloadingFromLoopStart = false;
                } else {
                    this.getInputBuffer().reset(0, this.getFilePositionFromSample(sample));
                }
                this.currentReadPosition = this.getFilePositionFromSample(sample);
                this.setAtracCurrentSample(sample);
            }
        }

        public boolean hasLoop() {
            return this.info.numLoops > 0;
        }

        public int getLoopStatus() {
            if (!this.hasLoop()) {
                return 0;
            }
            return 1;
        }

        public int getLoopStartSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.info.loops[0].startSample;
        }

        public int getLoopEndSample() {
            if (!this.hasLoop()) {
                return -1;
            }
            return this.info.loops[0].endSample;
        }

        public void setContextDecodeResult(int result, int requestedSize) {
            if (this.getContext() != null) {
                Memory mem = Memory.getInstance();
                int contextAddr = this.getContext().addr;
                mem.write32(contextAddr + 188, result);
                int readSize = mem.read32(contextAddr + 160);
                mem.write32(contextAddr + 164, readSize + requestedSize);
            }
        }

        public int getSourceBufferLength() {
            return this.sourceBufferLength;
        }

        public void setSourceBufferLength(int sourceBufferLength) {
            this.sourceBufferLength = sourceBufferLength;
        }

        public int getLastDecodedSamples() {
            return this.lastDecodedSamples;
        }

        public void setLastDecodedSamples(int lastDecodedSamples) {
            this.lastDecodedSamples = lastDecodedSamples;
        }

        public int getOutputChannels() {
            return this.outputChannels;
        }

        public void setOutputChannels(int outputChannels) {
            this.outputChannels = outputChannels;
        }

        public int getNumberOfSamples() {
            return this.codec.getNumberOfSamples() - this.skippedSamples - this.skippedEndSamples;
        }

        public boolean isInUse() {
            return this.inUse;
        }

        public void setInUse(boolean inUse) {
            this.inUse = inUse;
            if (inUse) {
                this.initCodec();
            } else {
                this.setCodecInitialized(false);
                this.codec = null;
            }
        }

        public void initCodec() {
            this.initCodec(this.getCodecType());
        }

        public String toString() {
            return String.format("AtracID[id=%d, inputBuffer=%s, channels=%d, outputChannels=%d]", this.id, this.inputBuffer, this.getChannels(), this.getOutputChannels());
        }
    }

    public static class AtracFileInfo {
        public int atracBitrate = 64;
        public int atracChannels = 2;
        public int atracSampleRate = 44100;
        public int atracBytesPerFrame = 560;
        public int atracEndSample;
        public int atracSampleOffset;
        public int atracCodingMode;
        public int inputFileDataOffset;
        public int inputFileSize;
        public int inputDataSize;
        public int loopNum;
        public int numLoops;
        public LoopInfo[] loops;
    }

    protected static class LoopInfo {
        protected int cuePointID;
        protected int type;
        protected int startSample;
        protected int endSample;
        protected int fraction;
        protected int playCount;

        protected LoopInfo() {
        }

        public String toString() {
            return String.format("LoopInfo[cuePointID %d, type %d, startSample 0x%X, endSample 0x%X, fraction %d, playCount %d]", this.cuePointID, this.type, this.startSample, this.endSample, this.fraction, this.playCount);
        }
    }
}

