/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics;

import java.nio.Buffer;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import jpcsp.Memory;
import jpcsp.graphics.VertexBuffer;
import jpcsp.graphics.VertexBufferManager;
import jpcsp.graphics.VertexCache;
import jpcsp.graphics.VertexInfo;
import jpcsp.util.CpuDurationStatistics;

public class AsyncVertexCache
extends VertexCache {
    AsyncVertexCacheThread asyncVertexCacheThread;
    private boolean useVertexArray = false;
    private VertexInfo vinfo = new VertexInfo();

    public static AsyncVertexCache getInstance() {
        if (instance == null) {
            instance = new AsyncVertexCache();
        }
        return (AsyncVertexCache)instance;
    }

    protected AsyncVertexCache() {
        this.asyncVertexCacheThread = new AsyncVertexCacheThread(this);
        this.asyncVertexCacheThread.setName("Async Vertex Cache Thread");
        this.asyncVertexCacheThread.setDaemon(true);
        this.asyncVertexCacheThread.start();
    }

    private void asyncLoadVertex(VertexInfo vertexInfo, AsyncEntry asyncEntry) {
    }

    private void asyncCheckVertex(VertexInfo vertex, VertexInfo vertexInfo, AsyncEntry asyncEntry) {
        if (!vertex.equals(vertexInfo, asyncEntry.count)) {
            this.setVertexAlreadyChecked(vertexInfo);
            vertex.setDirty();
            this.asyncLoadVertex(vertexInfo, asyncEntry);
        }
    }

    public void asyncCheck(AsyncEntry asyncEntry) {
        this.vinfo.setDirty();
        this.vinfo.processType(asyncEntry.vtype);
        this.vinfo.ptr_vertex = asyncEntry.vertices;
        this.vinfo.ptr_index = asyncEntry.indices;
        this.vinfo.prepareForCache(this, asyncEntry.count, null, 0);
        if (this.useVertexArray) {
            VertexBuffer vertexBuffer;
            int address = this.vinfo.ptr_vertex;
            int length = this.vinfo.vertexSize * asyncEntry.count;
            if (length > 0 && (vertexBuffer = VertexBufferManager.getInstance().getVertexBuffer(null, address, length, this.vinfo.vertexSize, this.useVertexArray)) != null) {
                Buffer buffer = Memory.getInstance().getBuffer(address, length);
                vertexBuffer.preLoad(buffer, address, length);
            }
        } else {
            VertexInfo vertex = this.getVertex(this.vinfo);
            if (vertex == null) {
                this.asyncLoadVertex(this.vinfo, asyncEntry);
            } else {
                this.asyncCheckVertex(vertex, this.vinfo, asyncEntry);
            }
        }
    }

    public void addAsyncCheck(int prim, int vtype, int count, int indices, int vertices) {
        if (Memory.isAddressGood(vertices)) {
            AsyncEntry asyncEntry = new AsyncEntry(prim, vtype, count, indices, vertices);
            this.asyncVertexCacheThread.addAsyncEntry(asyncEntry);
        }
    }

    @Override
    public void exit() {
        super.exit();
        this.asyncVertexCacheThread.exit();
    }

    public void setUseVertexArray(boolean useVertexArray) {
        this.useVertexArray = useVertexArray;
    }

    private static class AsyncEntry {
        public int prim;
        public int vtype;
        public int count;
        public int indices;
        public int vertices;

        public AsyncEntry() {
        }

        public AsyncEntry(int prim, int vtype, int count, int indices, int vertices) {
            this.prim = prim;
            this.vtype = vtype;
            this.count = count;
            this.indices = indices;
            this.vertices = vertices;
        }

        public String toString() {
            return String.format("AsyncEntry(prim=%d, vtype=0x%X, count=%d, indices=0x%08X, vertices=0x%08X", this.prim, this.vtype, this.count, this.indices, this.vertices);
        }
    }

    private static class AsyncVertexCacheThread
    extends Thread {
        private AsyncVertexCache asyncVertexCache;
        private BlockingQueue<AsyncEntry> asyncEntries = new LinkedBlockingQueue<AsyncEntry>();
        private volatile boolean done = false;
        public CpuDurationStatistics statistics = new CpuDurationStatistics("Async Vertex Cache Thread");

        public AsyncVertexCacheThread(AsyncVertexCache asyncVertexCache) {
            this.asyncVertexCache = asyncVertexCache;
        }

        public void exit() {
            this.done = true;
            this.asyncEntries.add(new AsyncEntry());
        }

        @Override
        public void run() {
            while (!this.done) {
                try {
                    AsyncEntry asyncEntry = this.asyncEntries.take();
                    if (asyncEntry == null || this.done) continue;
                    this.statistics.start();
                    this.asyncVertexCache.asyncCheck(asyncEntry);
                    this.statistics.end();
                }
                catch (InterruptedException interruptedException) {}
            }
        }

        public void addAsyncEntry(AsyncEntry asyncEntry) {
            this.asyncEntries.add(asyncEntry);
        }
    }
}

