/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.network.protocols.NetPacket;

public class UDP {
    public static final int UDP_PORT_DNS = 53;
    public static final int UDP_PORT_DHCP_SERVER = 67;
    public static final int UDP_PORT_DHCP_CLIENT = 68;
    public static final int UDP_PORT_SSDP = 1900;
    public int sourcePort;
    public int destinationPort;
    public int length;
    public int checksum;

    public UDP() {
    }

    public UDP(UDP udp) {
        this.sourcePort = udp.sourcePort;
        this.destinationPort = udp.destinationPort;
        this.length = udp.length;
        this.checksum = udp.checksum;
    }

    public void swapSourceAndDestination() {
        int port = this.sourcePort;
        this.sourcePort = this.destinationPort;
        this.destinationPort = port;
    }

    public void computeChecksum() {
        this.checksum = 0;
    }

    public void read(NetPacket packet) throws EOFException {
        this.sourcePort = packet.read16();
        this.destinationPort = packet.read16();
        this.length = packet.read16();
        this.checksum = packet.read16();
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.write16(this.sourcePort);
        packet.write16(this.destinationPort);
        packet.write16(this.length);
        packet.write16(this.checksum);
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    public int sizeOf() {
        return 8;
    }

    public String toString() {
        return String.format("sourcePort=0x%X, destinationPort=0x%X, length=0x%X, checksum=0x%04X", this.sourcePort, this.destinationPort, this.length, this.checksum);
    }
}

