/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.fat;

import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.fat.Fat12VirtualFile;
import jpcsp.HLE.VFS.fat.FatUtils;

public class Fat16VirtualFile
extends Fat12VirtualFile {
    public Fat16VirtualFile(String deviceName, IVirtualFileSystem vfs, int totalSectors) {
        super(deviceName, vfs, totalSectors);
    }

    @Override
    protected int getClusterMask() {
        return 65535;
    }

    @Override
    protected int getFatEOC() {
        return 65528;
    }

    @Override
    protected void readFatSector(int fatIndex) {
        this.readEmptySector();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fat16VirtualFile.readFatSector fatIndex=0x%X", fatIndex));
        }
        int offset = fatIndex * 512 >> 1;
        int maxSize = Math.min(512, this.fatClusterMap.length - offset << 1);
        int i = 0;
        int j = 0;
        while (i < maxSize) {
            FatUtils.storeSectorInt16(this.currentSector, i, this.fatClusterMap[offset + j]);
            i += 2;
            ++j;
        }
    }

    @Override
    protected void writeFatSector(int fatIndex) {
        int offset = fatIndex * 512 >> 1;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Fat16VirtualFile.writeFatSector fatIndex=0x%X, offset=0x%X", fatIndex, offset));
        }
        int i = 0;
        int j = 0;
        while (i < 512) {
            int fatEntry = FatUtils.readSectorInt16(this.currentSector, i);
            if (fatEntry != this.fatClusterMap[offset + j]) {
                this.writeFatSectorEntry(offset + j, fatEntry);
            }
            i += 2;
            ++j;
        }
    }
}

