/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.modules.memlmd;
import jpcsp.HLE.modules.semaphore;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.MMIO;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.scheduler.Scheduler;
import jpcsp.settings.Settings;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import libkirk.KirkEngine;
import org.apache.log4j.Logger;

public class MMIOHandlerKirk
extends MMIOHandlerBase {
    private static Logger log = semaphore.log;
    private static final int STATE_VERSION = 0;
    public static final int RESULT_SUCCESS = 0;
    public static final int STATUS_PHASE1_IN_PROGRESS = 0;
    public static final int STATUS_PHASE1_COMPLETED = 1;
    public static final int STATUS_PHASE1_ERROR = 16;
    public static final int STATUS_PHASE1_MASK = 17;
    public static final int STATUS_PHASE2_IN_PROGRESS = 0;
    public static final int STATUS_PHASE2_COMPLETED = 2;
    public static final int STATUS_PHASE2_ERROR = 32;
    public static final int STATUS_PHASE2_MASK = 34;
    private final int signature = 1263683915;
    private final int version = 0x30313030;
    private int error;
    private int command;
    private int result;
    private int status;
    private int statusAsync;
    private int statusAsyncEnd;
    private int sourceAddr;
    private int destAddr;
    private final CompletePhase1Action completePhase1Action = new CompletePhase1Action();
    private long completePhase1Schedule;
    final int[] lastPrngOutput = new int[20];
    int stepPreDecryptKeySeed0x15 = 0;

    public MMIOHandlerKirk(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.error = stream.readInt();
        this.command = stream.readInt();
        this.result = stream.readInt();
        this.status = stream.readInt();
        this.statusAsync = stream.readInt();
        this.statusAsyncEnd = stream.readInt();
        this.sourceAddr = stream.readInt();
        this.destAddr = stream.readInt();
        stream.readInts(this.lastPrngOutput);
        this.stepPreDecryptKeySeed0x15 = stream.readInt();
        super.read(stream);
        if ((this.status & 0x11) == 0) {
            this.completePhase1Schedule = Scheduler.getNow();
            Scheduler.getInstance().addAction(this.completePhase1Schedule, this.completePhase1Action);
        } else {
            this.completePhase1Schedule = 0L;
        }
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.error);
        stream.writeInt(this.command);
        stream.writeInt(this.result);
        stream.writeInt(this.status);
        stream.writeInt(this.statusAsync);
        stream.writeInt(this.statusAsyncEnd);
        stream.writeInt(this.sourceAddr);
        stream.writeInt(this.destAddr);
        stream.writeInts(this.lastPrngOutput);
        stream.writeInt(this.stepPreDecryptKeySeed0x15);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.error = 0;
        this.command = 0;
        this.result = 0;
        this.status = 0;
        this.statusAsync = 0;
        this.statusAsyncEnd = 0;
        this.sourceAddr = 0;
        this.destAddr = 0;
        this.completePhase1Schedule = 0L;
        Arrays.fill(this.lastPrngOutput, 0);
        this.stepPreDecryptKeySeed0x15 = 0;
        this.initKirk();
    }

    private static boolean isEqual(TPointer addr, int length, int[] values) {
        for (int i = 0; i < length; ++i) {
            if (addr.getUnsignedValue8(i) == values[i]) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(TPointer addr, int length) {
        return MMIOHandlerKirk.isEqual(addr, length, new int[length]);
    }

    private boolean preDecrypt(TPointer outAddr, int outSize, TPointer inAddr, int inSize) {
        boolean processed = false;
        if (this.command == 7) {
            int keySeed = inAddr.getValue32(12);
            int dataSize = outSize;
            if (keySeed == 21 && dataSize == 16 && Model.getGeneration() >= 2) {
                switch (this.stepPreDecryptKeySeed0x15) {
                    case 1: {
                        int[] values = new int[]{97, 122, 86, 66, 248, 237, 197, 228, 11, 11, 11, 11, 11, 11, 11, 11};
                        for (int i = 0; i < values.length; ++i) {
                            int n = i;
                            values[n] = values[n] ^ this.lastPrngOutput[i];
                        }
                        if (MMIOHandlerKirk.isEqual(new TPointer(inAddr, 20), dataSize, values)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X step %d", keySeed, this.stepPreDecryptKeySeed0x15));
                            }
                            processed = true;
                            outAddr.clear(outSize);
                            this.result = 0;
                            ++this.stepPreDecryptKeySeed0x15;
                            break;
                        }
                        this.stepPreDecryptKeySeed0x15 = 0;
                        break;
                    }
                    case 2: {
                        if (MMIOHandlerKirk.isEmpty(new TPointer(inAddr, 20), dataSize)) {
                            int i;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X step %d", keySeed, this.stepPreDecryptKeySeed0x15));
                            }
                            int[] key1 = new int[]{219, 177, 30, 32, 72, 131, 177, 111, 101, 140, 61, 48, 224, 254, 203, 191};
                            byte[] xorKey1_1 = memlmd.getKey(MMIO.getXorKeyBFD00210());
                            int[] keyFromVault1 = MMIO.getKeyBFD00210();
                            int[] xorKey1_2 = new int[]{11, 221, 237, 199, 181, 36, 188, 34};
                            for (i = 0; i < 8; ++i) {
                                int n = i + 8;
                                key1[n] = key1[n] ^ (keyFromVault1[i] ^ xorKey1_1[i] & 0xFF ^ xorKey1_2[i]);
                            }
                            for (i = 0; i < key1.length; ++i) {
                                outAddr.setUnsignedValue8(i, key1[i] ^ this.lastPrngOutput[i] + 1);
                            }
                            processed = true;
                            this.result = 0;
                            ++this.stepPreDecryptKeySeed0x15;
                            break;
                        }
                        this.stepPreDecryptKeySeed0x15 = 0;
                        break;
                    }
                    case 3: {
                        if (MMIOHandlerKirk.isEmpty(new TPointer(inAddr, 20), dataSize)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X step %d", keySeed, this.stepPreDecryptKeySeed0x15));
                            }
                            int[] key2 = new int[]{4, 244, 105, 138, 140, 170, 149, 48, 206, 59, 232, 132, 202, 154, 7, 154};
                            byte[] xorKey2_1 = memlmd.getKey(MMIO.getXorKeyBFD00210());
                            int[] keyFromVault2 = MMIO.getKeyBFD00210();
                            int[] xorKey2_2 = new int[]{128, 133, 250, 214, 201, 36, 239, 83};
                            for (int i = 0; i < 8; ++i) {
                                int n = i + 8;
                                key2[n] = key2[n] ^ (keyFromVault2[i + 8] ^ xorKey2_1[i + 8] & 0xFF ^ xorKey2_2[i]);
                            }
                            int add16 = 51897;
                            for (int i = 0; i < key2.length; i += 2) {
                                int valueKey16 = key2[i] | key2[i + 1] << 8;
                                int valuePrng16 = this.lastPrngOutput[i] | this.lastPrngOutput[i + 1] << 8;
                                outAddr.setUnsignedValue16(i, valueKey16 ^ valuePrng16 + 51897);
                            }
                            processed = true;
                            this.result = 0;
                            this.stepPreDecryptKeySeed0x15 = 0;
                            break;
                        }
                        this.stepPreDecryptKeySeed0x15 = 0;
                    }
                }
            } else if (keySeed == 105 && dataSize == 16 && Model.getGeneration() >= 2 && MMIOHandlerKirk.isEqual(new TPointer(inAddr, 20), dataSize, this.lastPrngOutput)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("preDecrypt for IPL, keySeed=0x%X", keySeed));
                }
                this.stepPreDecryptKeySeed0x15 = 1;
                processed = true;
                outAddr.clear(outSize);
                this.result = 0;
            }
        }
        return processed;
    }

    private void postDecrypt(TPointer outAddr, int outSize) {
        if (this.result == 0 && this.command == 14) {
            outAddr.getArrayUnsigned8(this.lastPrngOutput);
        }
    }

    private void initKirk() {
        long fuseId = 5124095577148911L;
        String fuseIdString = Settings.getInstance().readString("sceSysreg.fuseId", null);
        if (fuseIdString != null) {
            fuseId = Settings.parseLong(fuseIdString);
        }
        KirkEngine.kirk_init(fuseId);
    }

    private int hleUtilsBufferCopyWithRange() {
        int outSize;
        int inSize;
        TPointer outAddr = new TPointer(this.getMemory(), MMIO.normalizeAddress(this.destAddr));
        TPointer inAddr = new TPointer(this.getMemory(), MMIO.normalizeAddress(this.sourceAddr));
        switch (this.command) {
            case 4: 
            case 5: {
                int dataSize = inAddr.getValue32(16);
                inSize = dataSize + 20;
                outSize = dataSize + 20;
                break;
            }
            case 7: 
            case 8: {
                int dataSize = inAddr.getValue32(16);
                inSize = dataSize + 20;
                outSize = dataSize;
                break;
            }
            case 1: {
                int dataSize = inAddr.getValue32(112);
                int dataOffset = inAddr.getValue32(116);
                inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                outSize = Utilities.alignUp(dataSize, 15);
                break;
            }
            case 10: {
                int dataSize = inAddr.getValue32(112);
                int dataOffset = inAddr.getValue32(116);
                inSize = 144 + Utilities.alignUp(dataSize, 15) + dataOffset;
                outSize = 0;
                break;
            }
            case 11: {
                inSize = inAddr.getValue32(0) + 4;
                outSize = 20;
                break;
            }
            case 12: {
                inSize = 0;
                outSize = 60;
                break;
            }
            case 13: {
                inSize = 60;
                outSize = 40;
                break;
            }
            case 14: {
                inSize = 0;
                outSize = 20;
                break;
            }
            case 16: {
                inSize = 52;
                outSize = 40;
                break;
            }
            case 17: {
                inSize = 100;
                outSize = 0;
                break;
            }
            case 15: {
                inSize = 8;
                outSize = 28;
                this.initKirk();
                break;
            }
            case 18: {
                inSize = 184;
                outSize = 0;
                break;
            }
            case 3: {
                inSize = 512;
                outSize = 512;
                break;
            }
            default: {
                log.error((Object)String.format("MMIOHandlerKirk.hleUtilsBufferCopyWithRange unimplemented KIRK command 0x%X", this.command));
                this.result = 13;
                return 0;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleUtilsBufferCopyWithRange input: %s", Utilities.getMemoryDump(inAddr, inSize)));
        }
        if (!this.preDecrypt(outAddr, outSize, inAddr, inSize)) {
            this.result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(outAddr, outSize, inAddr, inSize, this.command);
        }
        this.postDecrypt(outAddr, outSize);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleUtilsBufferCopyWithRange result=0x%X, output: %s", this.result, Utilities.getMemoryDump(outAddr, outSize)));
        }
        return Math.max(inSize, outSize);
    }

    private void completePhase1() {
        if (this.completePhase1Schedule != 0L) {
            Scheduler.getInstance().removeAction(this.completePhase1Schedule, this.completePhase1Action);
            this.completePhase1Schedule = 0L;
        }
        this.setStatus(17, 1);
        RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 24);
    }

    private void startProcessing(int value) {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                this.setStatus(17, 0);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("KIRK startProcessing 1 on %s", this));
                }
                int size = this.hleUtilsBufferCopyWithRange();
                if (this.result == 0) {
                    int delayUs = Math.max(0, size * 360 / 4096);
                    this.completePhase1Schedule = Scheduler.getNow() + (long)delayUs;
                    Scheduler.getInstance().addAction(this.completePhase1Schedule, this.completePhase1Action);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("KIRK delaying completion of phase 1 by %d us", delayUs));
                    break;
                }
                this.completePhase1();
                break;
            }
            case 2: {
                this.setStatus(34, 0);
                log.error((Object)String.format("Unimplemented Phase 2 KIRK command 0x%X on %s", this.command, this));
                log.error((Object)String.format("source: %s", Utilities.getMemoryDump(this.getMemory(), MMIO.normalizeAddress(this.sourceAddr), 256)));
                break;
            }
            default: {
                log.error((Object)String.format("0x%08X - KIRK unknown startProcessing value 0x%X on %s", this.getPc(), value, this));
            }
        }
    }

    private void endProcessing(int value) {
        switch (value) {
            case 0: {
                break;
            }
            case 1: {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("KIRK endProcessing 1 on %s", this));
                }
                RuntimeContextLLE.clearInterrupt(this.getProcessor(), 24);
                break;
            }
            case 2: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("KIRK endProcessing 2 on %s", this));
                break;
            }
            default: {
                log.error((Object)String.format("0x%08X - KIRK unknown endProcessing value 0x%X on %s", this.getPc(), value, this));
            }
        }
    }

    private void setStatus(int mask, int value) {
        this.status = this.status & ~mask | value;
    }

    private void updateStatus() {
        if (this.completePhase1Schedule != 0L && this.completePhase1Schedule <= Scheduler.getNow()) {
            this.completePhase1();
        }
    }

    private int getStatus() {
        this.updateStatus();
        return this.status;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = 1263683915;
                break;
            }
            case 4: {
                value = 0x30313030;
                break;
            }
            case 8: {
                value = this.error;
                break;
            }
            case 12: {
                value = 0;
                break;
            }
            case 16: {
                value = this.command;
                break;
            }
            case 20: {
                value = this.result;
                break;
            }
            case 28: {
                value = this.getStatus();
                break;
            }
            case 32: {
                value = this.statusAsync;
                break;
            }
            case 36: {
                value = this.statusAsyncEnd;
                break;
            }
            case 44: {
                value = this.sourceAddr;
                break;
            }
            case 48: {
                value = this.destAddr;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 8: {
                this.error = value;
                break;
            }
            case 12: {
                this.startProcessing(value);
                break;
            }
            case 16: {
                this.command = value;
                break;
            }
            case 20: {
                this.result = value;
                break;
            }
            case 28: {
                this.status = value;
                break;
            }
            case 32: {
                this.statusAsync = value;
                break;
            }
            case 36: {
                this.statusAsyncEnd = value;
                break;
            }
            case 40: {
                this.endProcessing(value);
                break;
            }
            case 44: {
                this.sourceAddr = value;
                break;
            }
            case 48: {
                this.destAddr = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("KIRK error=0x%X, command=0x%X, result=0x%X, status=0x%X, statusAsync=0x%X, statusAsyncEnd=0x%X, sourceAddr=0x%08X, destAddr=0x%08X", this.error, this.command, this.result, this.status, this.statusAsync, this.statusAsyncEnd, this.sourceAddr, this.destAddr);
    }

    private class CompletePhase1Action
    implements IAction {
        private CompletePhase1Action() {
        }

        @Override
        public void execute() {
            MMIOHandlerKirk.this.completePhase1();
        }
    }
}

