/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class MMIOHandlerCpuBusFrequency
extends MMIOHandlerBase {
    private static final int STATE_VERSION = 0;
    private int cpuFrequencyNumerator;
    private int cpuFrequencyDenominator;
    private int busFrequencyNumerator;
    private int busFrequencyDenominator;

    public MMIOHandlerCpuBusFrequency(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.cpuFrequencyNumerator = stream.readInt();
        this.cpuFrequencyDenominator = stream.readInt();
        this.busFrequencyNumerator = stream.readInt();
        this.busFrequencyDenominator = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.cpuFrequencyNumerator);
        stream.writeInt(this.cpuFrequencyDenominator);
        stream.writeInt(this.busFrequencyNumerator);
        stream.writeInt(this.busFrequencyDenominator);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.cpuFrequencyNumerator = 0;
        this.cpuFrequencyDenominator = 0;
        this.busFrequencyNumerator = 0;
        this.busFrequencyDenominator = 0;
    }

    private int getFrequency(int numerator, int denominator) {
        return numerator << 16 | denominator;
    }

    private int getNumerator(int value) {
        return value >> 16 & 0x1FF;
    }

    private int getDenominator(int value) {
        return value & 0x1FF;
    }

    private int getCpuFrequency() {
        return this.getFrequency(this.cpuFrequencyNumerator, this.cpuFrequencyDenominator);
    }

    private int getBusFrequency() {
        return this.getFrequency(this.busFrequencyNumerator, this.busFrequencyDenominator);
    }

    private void setCpuFrequency(int value) {
        this.cpuFrequencyNumerator = this.getNumerator(value);
        this.cpuFrequencyDenominator = this.getDenominator(value);
    }

    private void setBusFrequency(int value) {
        this.busFrequencyNumerator = this.getNumerator(value);
        this.busFrequencyDenominator = this.getDenominator(value);
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.getCpuFrequency();
                break;
            }
            case 4: {
                value = this.getBusFrequency();
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.setCpuFrequency(value);
                break;
            }
            case 4: {
                this.setBusFrequency(value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("CPU frequency=%d/%d, Bus frequency=%d/%d", this.cpuFrequencyNumerator, this.cpuFrequencyDenominator, this.busFrequencyNumerator, this.busFrequencyDenominator);
    }
}

