/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.network.protocols.NetPacket;

public class InternetChecksum {
    public static int computeInternetChecksum(byte[] buffer, int offset, int length) {
        NetPacket packet = new NetPacket(buffer, offset, length);
        int sum = 0;
        try {
            while (length > 1) {
                sum += packet.read16();
                length -= 2;
            }
            if (length > 0) {
                sum += packet.read8() << 8;
            }
        }
        catch (EOFException eOFException) {
            // empty catch block
        }
        while (sum >>> 16 != 0) {
            sum = (sum & 0xFFFF) + (sum >>> 16);
        }
        int checksum = sum ^ 0xFFFF;
        return checksum;
    }
}

