/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.managers.ThreadWaitingList;
import jpcsp.HLE.kernel.types.SceKernelMsgPacket;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.Memory;

public class SceKernelMbxInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int attr;
    public final ThreadWaitingList threadWaitingList;
    private int numMessages;
    private int firstMessageAddr;
    public final int uid;
    public int lastMessageAddr;

    public SceKernelMbxInfo(String name, int attr) {
        this.name = name;
        this.attr = attr;
        this.numMessages = 0;
        this.firstMessageAddr = 0;
        this.lastMessageAddr = 0;
        this.uid = SceUidManager.getNewUid("ThreadMan-Mbx");
        this.threadWaitingList = ThreadWaitingList.createThreadWaitingList(5, this.uid, attr, 256);
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.attr);
        this.write32(this.getNumWaitThreads());
        this.write32(this.numMessages);
        this.write32(this.firstMessageAddr);
    }

    private void setFirstMessageAddr(Memory mem, int firstMessageAddr) {
        this.firstMessageAddr = firstMessageAddr;
        if (firstMessageAddr == 0) {
            this.lastMessageAddr = 0;
        } else {
            if (this.lastMessageAddr == 0) {
                this.lastMessageAddr = firstMessageAddr;
            }
            SceKernelMsgPacket.writeNext(mem, this.lastMessageAddr, firstMessageAddr);
        }
    }

    public int removeMsg(Memory mem) {
        int msgAddr = this.firstMessageAddr;
        if (msgAddr != 0) {
            int nextMessageAddr = SceKernelMsgPacket.readNext(mem, msgAddr);
            if (nextMessageAddr == msgAddr) {
                this.setFirstMessageAddr(mem, 0);
            } else {
                this.setFirstMessageAddr(mem, nextMessageAddr);
            }
            --this.numMessages;
        }
        return msgAddr;
    }

    private void insertMsgAfter(Memory mem, int msgAddr, int refMsgAddr) {
        if (this.lastMessageAddr == 0) {
            this.setFirstMessageAddr(mem, msgAddr);
        } else if (refMsgAddr == 0) {
            SceKernelMsgPacket.writeNext(mem, msgAddr, this.firstMessageAddr);
            this.setFirstMessageAddr(mem, msgAddr);
        } else {
            SceKernelMsgPacket.writeNext(mem, msgAddr, SceKernelMsgPacket.readNext(mem, refMsgAddr));
            SceKernelMsgPacket.writeNext(mem, refMsgAddr, msgAddr);
            if (this.lastMessageAddr == refMsgAddr) {
                this.lastMessageAddr = msgAddr;
            }
        }
        ++this.numMessages;
    }

    public void addMsg(Memory mem, int msgAddr) {
        if (msgAddr != 0) {
            this.insertMsgAfter(mem, msgAddr, this.lastMessageAddr);
        }
    }

    public void addMsgByPriority(Memory mem, int msgAddr) {
        if (msgAddr != 0) {
            int currentMsgAddr = this.firstMessageAddr;
            int previousMsgAddr = 0;
            for (int i = 0; i < this.numMessages && SceKernelMsgPacket.compare(mem, msgAddr, currentMsgAddr) >= 0; ++i) {
                previousMsgAddr = currentMsgAddr;
                currentMsgAddr = SceKernelMsgPacket.readNext(mem, currentMsgAddr);
            }
            this.insertMsgAfter(mem, msgAddr, previousMsgAddr);
        }
    }

    public boolean hasMessage() {
        return this.firstMessageAddr != 0;
    }

    public int getNumWaitThreads() {
        return this.threadWaitingList.getNumWaitingThreads();
    }

    @Override
    public String toString() {
        return String.format("SceKernelMbxInfo[uid=0x%X, name='%s', attr=0x%X, numWaitingThreads=%d, numMessages=%d]", this.uid, this.name, this.attr, this.getNumWaitThreads(), this.numMessages);
    }
}

