/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.HLE.kernel.types.SceKernelCallbackInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.kernel.types.interrupts.GeCallbackInterruptHandler;
import jpcsp.HLE.kernel.types.interrupts.GeInterruptHandler;
import jpcsp.HLE.kernel.types.pspGeCallbackData;
import jpcsp.HLE.kernel.types.pspGeListOptParam;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Memory;
import jpcsp.graphics.RE.externalge.CoreThreadMMIO;
import jpcsp.graphics.RE.externalge.ExternalGE;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceGe_user
extends HLEModule {
    public static Logger log = Modules.getLogger("sceGe_user");
    public volatile boolean waitingForSync;
    public volatile boolean syncDone;
    private HashMap<Integer, SceKernelCallbackInfo> signalCallbacks;
    private HashMap<Integer, SceKernelCallbackInfo> finishCallbacks;
    private static final String geCallbackPurpose = "sceGeCallback";
    private static final int NUMBER_GE_LISTS = 64;
    private PspGeList[] allGeLists;
    private ConcurrentLinkedQueue<PspGeList> listFreeQueue;
    private ConcurrentLinkedQueue<Integer> deferredThreadWakeupQueue;
    public static final int PSP_GE_LIST_DONE = 0;
    public static final int PSP_GE_LIST_QUEUED = 1;
    public static final int PSP_GE_LIST_DRAWING = 2;
    public static final int PSP_GE_LIST_STALL_REACHED = 3;
    public static final int PSP_GE_LIST_END_REACHED = 4;
    public static final int PSP_GE_LIST_CANCEL_DONE = 5;
    public static final String[] PSP_GE_LIST_STRINGS = new String[]{"PSP_GE_LIST_DONE", "PSP_GE_LIST_QUEUED", "PSP_GE_LIST_DRAWING", "PSP_GE_LIST_STALL_REACHED", "PSP_GE_LIST_END_REACHED", "PSP_GE_LIST_CANCEL_DONE"};
    public static final int PSP_GE_SIGNAL_HANDLER_SUSPEND = 1;
    public static final int PSP_GE_SIGNAL_HANDLER_CONTINUE = 2;
    public static final int PSP_GE_SIGNAL_HANDLER_PAUSE = 3;
    public static final int PSP_GE_SIGNAL_SYNC = 8;
    public static final int PSP_GE_SIGNAL_JUMP = 16;
    public static final int PSP_GE_SIGNAL_CALL = 17;
    public static final int PSP_GE_SIGNAL_RETURN = 18;
    public static final int PSP_GE_SIGNAL_TBP0_REL = 32;
    public static final int PSP_GE_SIGNAL_TBP1_REL = 33;
    public static final int PSP_GE_SIGNAL_TBP2_REL = 34;
    public static final int PSP_GE_SIGNAL_TBP3_REL = 35;
    public static final int PSP_GE_SIGNAL_TBP4_REL = 36;
    public static final int PSP_GE_SIGNAL_TBP5_REL = 37;
    public static final int PSP_GE_SIGNAL_TBP6_REL = 38;
    public static final int PSP_GE_SIGNAL_TBP7_REL = 39;
    public static final int PSP_GE_SIGNAL_TBP0_REL_OFFSET = 40;
    public static final int PSP_GE_SIGNAL_TBP1_REL_OFFSET = 41;
    public static final int PSP_GE_SIGNAL_TBP2_REL_OFFSET = 42;
    public static final int PSP_GE_SIGNAL_TBP3_REL_OFFSET = 43;
    public static final int PSP_GE_SIGNAL_TBP4_REL_OFFSET = 44;
    public static final int PSP_GE_SIGNAL_TBP5_REL_OFFSET = 45;
    public static final int PSP_GE_SIGNAL_TBP6_REL_OFFSET = 46;
    public static final int PSP_GE_SIGNAL_TBP7_REL_OFFSET = 47;
    public static final int PSP_GE_SIGNAL_BREAK = 255;
    public static final int PSP_GE_MATRIX_BONE0 = 0;
    public static final int PSP_GE_MATRIX_BONE1 = 1;
    public static final int PSP_GE_MATRIX_BONE2 = 2;
    public static final int PSP_GE_MATRIX_BONE3 = 3;
    public static final int PSP_GE_MATRIX_BONE4 = 4;
    public static final int PSP_GE_MATRIX_BONE5 = 5;
    public static final int PSP_GE_MATRIX_BONE6 = 6;
    public static final int PSP_GE_MATRIX_BONE7 = 7;
    public static final int PSP_GE_MATRIX_WORLD = 8;
    public static final int PSP_GE_MATRIX_VIEW = 9;
    public static final int PSP_GE_MATRIX_PROJECTION = 10;
    public static final int PSP_GE_MATRIX_TEXGEN = 11;
    public int eDRAMMemoryWidth;

    @Override
    public void start() {
        log.debug((Object)String.format("Starting %s", this.getName()));
        this.waitingForSync = false;
        this.syncDone = false;
        this.signalCallbacks = new HashMap();
        this.finishCallbacks = new HashMap();
        this.listFreeQueue = new ConcurrentLinkedQueue();
        this.allGeLists = new PspGeList[64];
        for (int i = 0; i < 64; ++i) {
            this.allGeLists[i] = new PspGeList(i);
            this.listFreeQueue.add(this.allGeLists[i]);
        }
        this.deferredThreadWakeupQueue = new ConcurrentLinkedQueue();
        this.eDRAMMemoryWidth = 1024;
        super.start();
    }

    @Override
    public void stop() {
        log.debug((Object)String.format("Stopping %s", this.getName()));
        if (ExternalGE.isActive()) {
            ExternalGE.onGeUserStop();
        }
    }

    public void step() {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        Integer thid = this.deferredThreadWakeupQueue.poll();
        while (thid != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("really waking thread " + Integer.toHexString(thid) + "(" + threadMan.getThreadName(thid) + ")"));
            }
            threadMan.hleUnblockThread(thid);
            ExternalGE.onGeStopWaitList();
            thid = this.deferredThreadWakeupQueue.poll();
        }
    }

    private void triggerAsyncCallback(int cbid, int listId, int listPc, int behavior, int signalId, HashMap<Integer, SceKernelCallbackInfo> callbacks) {
        SceKernelCallbackInfo callback = callbacks.get(cbid);
        if (callback != null && callback.hasCallbackFunction()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Scheduling Async Callback %s, listId=0x%X, listPc=0x%08X, behavior=%d, signalId=0x%X", callback.toString(), listId, listPc, behavior, signalId));
            }
            GeCallbackInterruptHandler geCallbackInterruptHandler = new GeCallbackInterruptHandler(callback.getCallbackFunction(), callback.getCallbackArgument(), listPc);
            GeInterruptHandler geInterruptHandler = new GeInterruptHandler(geCallbackInterruptHandler, listId, behavior, signalId);
            Emulator.getScheduler().addAction(geInterruptHandler);
        } else {
            this.hleGeOnAfterCallback(listId, behavior, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void blockCurrentThreadOnList(PspGeList list, IAction action) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean blockCurrentThread = false;
        boolean executeAction = false;
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            int currentThreadId = threadMan.getCurrentThreadID();
            if (list.isDone()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blockCurrentThreadOnList not blocking thread " + Integer.toHexString(currentThreadId) + ", list completed " + list));
                }
                executeAction = true;
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("blockCurrentThreadOnList blocking thread " + Integer.toHexString(currentThreadId) + " on list " + list));
                }
                list.blockedThreadIds.add(currentThreadId);
                blockCurrentThread = true;
            }
        }
        if (executeAction && action != null) {
            action.execute();
        }
        if (blockCurrentThread) {
            threadMan.hleBlockCurrentThread(258, list.id, false, action, new ListSyncWaitStateChecker(list));
            ExternalGE.onGeStartWaitList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hleGeAfterDrawSyncAction() {
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            for (int i = 0; i < 64; ++i) {
                if (this.allGeLists[i].status != 0) continue;
                this.allGeLists[i].reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hleGeListSyncDone(PspGeList list) {
        if (log.isDebugEnabled()) {
            String msg = "hleGeListSyncDone list " + list;
            msg = list.isDone() ? msg + ", done" : msg + ", NOT done";
            if (list.blockedThreadIds.size() > 0 && list.status != 4) {
                msg = msg + ", waking thread";
                for (int threadId : list.blockedThreadIds) {
                    msg = msg + " " + Integer.toHexString(threadId);
                }
            }
            log.debug((Object)msg);
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            if (list.blockedThreadIds.size() > 0 && list.status != 4) {
                this.deferredThreadWakeupQueue.addAll(list.blockedThreadIds);
            }
            if (list.isDone()) {
                this.listFreeQueue.add(list);
            }
        }
    }

    public void hleGeOnAfterCallback(int listId, int behavior, boolean hasCallback) {
        if (!(behavior != 2 && behavior != 1 && hasCallback || listId < 0 || listId >= 64)) {
            PspGeList list = this.allGeLists[listId];
            if (log.isDebugEnabled()) {
                log.debug((Object)("hleGeOnAfterCallback restarting list " + list));
            }
            list.restartList();
        }
    }

    public void triggerFinishCallback(int cbid, int listId, int listPc, int callbackNotifyArg1) {
        this.triggerAsyncCallback(cbid, listId, listPc, 1, callbackNotifyArg1, this.finishCallbacks);
    }

    public void triggerSignalCallback(int cbid, int listId, int listPc, int behavior, int callbackNotifyArg1) {
        this.triggerAsyncCallback(cbid, listId, listPc, behavior, callbackNotifyArg1, this.signalCallbacks);
    }

    public PspGeList getGeList(int id) {
        if (id < 0 || id >= 64) {
            return null;
        }
        return this.allGeLists[id];
    }

    public int checkListId(int id) {
        if (id < 0 || id >= 64) {
            throw new SceKernelErrorException(-2147483392);
        }
        return id;
    }

    public int checkMode(int mode) {
        if (mode < 0 || mode > 1) {
            throw new SceKernelErrorException(-2147483385);
        }
        return mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleGeListEnQueue(TPointer listAddr, @CanBeNull TPointer stallAddr, int cbid, @CanBeNull TPointer argAddr, int saveContextAddr, boolean enqueueHead) {
        int result;
        pspGeListOptParam optParams = null;
        int stackAddr = 0;
        if (argAddr.isNotNull()) {
            optParams = new pspGeListOptParam();
            optParams.read(argAddr);
            stackAddr = optParams.stackAddr;
            saveContextAddr = optParams.contextAddr;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleGeListEnQueue optParams=%s", optParams));
            }
            if (optParams.stackDepth < 0 || optParams.stackDepth >= 256) {
                return -2147483388;
            }
        }
        if (RuntimeContextLLE.isLLEActive()) {
            CoreThreadMMIO.setDisabled();
        }
        boolean useCachedMemory = false;
        if (Modules.SysMemUserForUserModule.hleKernelGetCompiledSdkVersion() >= 0x2000000) {
            boolean isBusy = ExternalGE.isActive() ? ExternalGE.hasDrawList(listAddr.getAddress(), stackAddr) : VideoEngine.getInstance().hasDrawList(listAddr.getAddress(), stackAddr);
            if (isBusy) {
                log.warn((Object)String.format("hleGeListEnQueue can't enqueue duplicate list address %s, stack 0x%08X", listAddr, stackAddr));
                return -2147483615;
            }
        } else {
            useCachedMemory = true;
        }
        if (ExternalGE.isActive()) {
            useCachedMemory = false;
        }
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.listFreeQueue.poll();
            if (list == null) {
                log.warn((Object)"hleGeListEnQueue no more free list available!");
                if (log.isDebugEnabled()) {
                    for (int i = 0; i < 64; ++i) {
                        log.debug((Object)String.format("List#%d: %s", i, this.allGeLists[i]));
                    }
                }
                return -2147483614;
            }
            list.init(listAddr.getAddress(), stallAddr.getAddress(), cbid, optParams);
            list.setSaveContextAddr(saveContextAddr);
            if (useCachedMemory) {
                this.setStallAddressWithCachedMemory(list, stallAddr.getAddress());
            }
            if (enqueueHead) {
                list.startListHead();
            } else {
                list.startList();
            }
            Modules.sceDisplayModule.setGeDirty(true);
            result = list.id;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleGeListEnQueue returning 0x%X", result));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hleGeListSync(int id) {
        int result;
        if (id < 0 || id >= 64) {
            return -1;
        }
        PspGeList list = null;
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            list = this.allGeLists[id];
            result = list.status;
        }
        return result;
    }

    private void setStallAddressWithCachedMemory(PspGeList list, int stallAddr) {
        int length;
        int startAddress = list.list_addr;
        if (stallAddr != 0) {
            length = stallAddr - startAddress;
        } else {
            int instruction;
            int command;
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(startAddress, 4);
            length = 0;
            while ((command = VideoEngine.command(instruction = memoryReader.readNext())) != 15) {
            }
            length = memoryReader.getCurrentAddress() - startAddress + 4;
        }
        if (length >= 0) {
            int[] baseMemoryInts = Utilities.readInt32(startAddress, length);
            list.setStallAddr(stallAddr, MemoryReader.getMemoryReader(startAddress, baseMemoryInts, 0, length), startAddress, startAddress + length);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("setStallAddressWithCachedMemory [0x%08X-0x%08X] %s", startAddress, startAddress + length, list));
            }
        } else {
            list.setStallAddr(stallAddr);
        }
    }

    public void onMMIOGeStallAddressChanged(int lleStallAddr) {
        PspGeList currentList = ExternalGE.isActive() ? ExternalGE.getFirstDrawList() : VideoEngine.getInstance().getFirstDrawList();
        if (currentList != null) {
            currentList.setStallAddr(lleStallAddr);
        }
    }

    @HLEFunctions(value={@HLEFunction(nid=526865069, version=150), @HLEFunction(nid=1562944811, version=660)})
    public int sceGeEdramGetSize() {
        return 0x200000;
    }

    @HLEFunction(nid=-461487900, version=150)
    public int sceGeEdramGetAddr() {
        return 0x4000000;
    }

    @HLEFunction(nid=-1216805398, version=150)
    public int sceGeEdramSetAddrTranslation(int size) {
        int previousWidth = this.eDRAMMemoryWidth;
        this.eDRAMMemoryWidth = size;
        return previousWidth;
    }

    @HLEFunction(nid=-594292753, version=150)
    public int sceGeGetCmd(int cmd) {
        VideoEngine ve = VideoEngine.getInstance();
        int value = ExternalGE.isActive() ? ExternalGE.getCmd(cmd) : ve.getCommandValue(cmd);
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceGeGetCmd %s: cmd=0x%X, value=0x%06X", ve.commandToString(cmd).toUpperCase(), cmd, value));
        }
        return value;
    }

    @HLEFunction(nid=1472762971, version=150)
    public int sceGeGetMtx(int mtxType, TPointer mtxAddr) {
        if (mtxType < 0 || mtxType > 11) {
            log.warn((Object)String.format("sceGeGetMtx invalid type mtxType=%d", mtxType));
            return -2147483390;
        }
        float[] mtx = ExternalGE.isActive() ? ExternalGE.getMatrix(mtxType) : VideoEngine.getInstance().getMatrix(mtxType);
        for (int i = 0; i < mtx.length; ++i) {
            mtxAddr.setValue32(i << 2, Float.floatToRawIntBits(mtx[i]) >>> 8);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceGeGetMtx mtxType=%d, mtxAddr=%s, mtx=%s", mtxType, mtxAddr, mtx));
        }
        return 0;
    }

    @HLEFunction(nid=1133131866, version=150)
    public int sceGeSaveContext(TPointer contextAddr) {
        if (ExternalGE.isActive()) {
            return ExternalGE.saveContext(contextAddr.getAddress());
        }
        VideoEngine.getInstance().hleSaveContext(contextAddr.getAddress());
        return 0;
    }

    @HLEFunction(nid=200673531, version=150)
    public int sceGeRestoreContext(TPointer contextAddr) {
        if (ExternalGE.isActive()) {
            return ExternalGE.restoreContext(contextAddr.getAddress());
        }
        VideoEngine.getInstance().hleRestoreContext(contextAddr.getAddress());
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1421219990, version=150), @HLEFunction(nid=-1343829521, version=660)})
    public int sceGeListEnQueue(TPointer listAddr, @CanBeNull TPointer stallAddr, int cbid, @CanBeNull TPointer argAddr) {
        return this.hleGeListEnQueue(listAddr, stallAddr, cbid, argAddr, 0, false);
    }

    @HLEFunction(nid=470652326, version=150)
    public int sceGeListEnQueueHead(TPointer listAddr, @CanBeNull TPointer stallAddr, int cbid, @CanBeNull TPointer argAddr) {
        return this.hleGeListEnQueue(listAddr, stallAddr, cbid, argAddr, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=1605921456, version=150)
    public int sceGeListDeQueue(@CheckArgument(value="checkListId") int id) {
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.allGeLists[id];
            list.reset();
            if (!this.listFreeQueue.contains(list)) {
                this.listFreeQueue.add(list);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=-522813112, version=150)
    public int sceGeListUpdateStallAddr(@CheckArgument(value="checkListId") int id, @CanBeNull TPointer stallAddr) {
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            PspGeList list = this.allGeLists[id];
            if (list.getStallAddr() != stallAddr.getAddress()) {
                if (list.hasBaseMemoryReader()) {
                    this.setStallAddressWithCachedMemory(list, stallAddr.getAddress());
                } else {
                    list.setStallAddr(stallAddr.getAddress());
                }
                Modules.sceDisplayModule.setGeDirty(true);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunctions(value={@HLEFunction(nid=54808244, version=150), @HLEFunction(nid=1268077803, version=660)})
    public int sceGeListSync(@CheckArgument(value="checkListId") int id, @CheckArgument(value="checkMode") int mode) {
        int result;
        if (mode == 0 && IntrManager.getInstance().isInsideInterrupt()) {
            log.debug((Object)"sceGeListSync (mode==0) cannot be called inside an interrupt handler!");
            return -2147352476;
        }
        PspGeList list = null;
        boolean blockCurrentThread = false;
        sceGe_user sceGe_user2 = this;
        synchronized (sceGe_user2) {
            list = this.allGeLists[id];
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceGeListSync on list: %s", list));
            }
            if (list.isReset()) {
                throw new SceKernelErrorException(-2147483392);
            }
            if (mode == 0 && !list.isDone()) {
                result = 0;
                blockCurrentThread = true;
            } else {
                result = list.getSyncStatus();
            }
        }
        if (blockCurrentThread) {
            this.blockCurrentThreadOnList(list, null);
        }
        return result;
    }

    @HLEFunction(nid=-1299727007, version=150)
    public int sceGeDrawSync(@CheckArgument(value="checkMode") int mode) {
        if (mode == 0 && IntrManager.getInstance().isInsideInterrupt()) {
            log.debug((Object)"sceGeDrawSync (mode==0) cannot be called inside an interrupt handler!");
            return -2147352476;
        }
        int result = 0;
        if (mode == 0) {
            PspGeList lastList = ExternalGE.isActive() ? ExternalGE.getLastDrawList() : VideoEngine.getInstance().getLastDrawList();
            if (lastList != null) {
                this.blockCurrentThreadOnList(lastList, new HLEAfterDrawSyncAction());
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"sceGeDrawSync all lists completed, not waiting");
                }
                this.hleGeAfterDrawSyncAction();
                Modules.ThreadManForUserModule.hleRescheduleCurrentThread();
            }
        } else if (mode == 1) {
            PspGeList currentList = ExternalGE.isActive() ? ExternalGE.getFirstDrawList() : VideoEngine.getInstance().getFirstDrawList();
            if (currentList != null) {
                result = currentList.getSyncStatus();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceGeDrawSync mode=%d, returning %d", mode, result));
            }
        }
        return result;
    }

    @HLEFunction(nid=-1270289395, version=150)
    public int sceGeBreak(@CheckArgument(value="checkMode") int mode, TPointer brk_addr) {
        int result = 0;
        PspGeList list = ExternalGE.isActive() ? ExternalGE.getCurrentList() : VideoEngine.getInstance().getCurrentList();
        if (mode == 0) {
            if (list != null) {
                list.pauseList();
                result = list.id;
            }
        } else if (mode == 1 && list != null) {
            list.pauseList();
            for (int i = 0; i < 64; ++i) {
                this.allGeLists[i].status = 5;
            }
            result = list.id;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HLEFunction(nid=1275520114, version=150)
    public int sceGeContinue() {
        PspGeList list = ExternalGE.isActive() ? ExternalGE.getCurrentList() : VideoEngine.getInstance().getCurrentList();
        if (list != null) {
            sceGe_user sceGe_user2 = this;
            synchronized (sceGe_user2) {
                Memory mem;
                if (list.status == 4 && (mem = Memory.getInstance()).read32(list.getPc()) == 0xF000000 && mem.read32(list.getPc() + 4) == 0xC000000) {
                    list.readNextInstruction();
                    list.readNextInstruction();
                }
                list.restartList();
            }
        }
        return 0;
    }

    @HLEFunction(nid=-1526987100, version=150, checkInsideInterrupt=true)
    public int sceGeSetCallback(TPointer cbdata_addr) {
        pspGeCallbackData cbdata = new pspGeCallbackData();
        cbdata.read(cbdata_addr);
        int cbid = SceUidManager.getNewId(geCallbackPurpose, 0, 15);
        if (cbid == Integer.MIN_VALUE) {
            log.warn((Object)String.format("sceGeSetCallback no more callback ID available", new Object[0]));
            return -2147483614;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceGeSetCallback signalFunc=0x%08X, signalArg=0x%08X, finishFunc=0x%08X, finishArg=0x%08X, result cbid=0x%X", cbdata.signalFunction, cbdata.signalArgument, cbdata.finishFunction, cbdata.finishArgument, cbid));
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelCallbackInfo callbackSignal = threadMan.hleKernelCreateCallback("GeCallbackSignal", cbdata.signalFunction, cbdata.signalArgument);
        SceKernelCallbackInfo callbackFinish = threadMan.hleKernelCreateCallback("GeCallbackFinish", cbdata.finishFunction, cbdata.finishArgument);
        this.signalCallbacks.put(cbid, callbackSignal);
        this.finishCallbacks.put(cbid, callbackFinish);
        return cbid;
    }

    @HLEFunction(nid=98247374, version=150, checkInsideInterrupt=true)
    public int sceGeUnsetCallback(int cbid) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelCallbackInfo callbackSignal = this.signalCallbacks.remove(cbid);
        SceKernelCallbackInfo callbackFinish = this.finishCallbacks.remove(cbid);
        if (callbackSignal != null) {
            threadMan.hleKernelDeleteCallback(callbackSignal.getUid());
        }
        if (callbackFinish != null) {
            threadMan.hleKernelDeleteCallback(callbackFinish.getUid());
        }
        SceUidManager.releaseId(cbid, geCallbackPurpose);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=1537889337, version=150), @HLEFunction(nid=-664586104, version=660)})
    public int sceGeEdramSetSize(int size) {
        return 0;
    }

    @HLEFunction(nid=1417594352, version=660)
    public int sceGeEdramGetHwSize() {
        return 0x200000;
    }

    private static class ListSyncWaitStateChecker
    implements IWaitStateChecker {
        private PspGeList list;

        public ListSyncWaitStateChecker(PspGeList list) {
            this.list = list;
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            boolean contineWait;
            boolean bl = contineWait = !this.list.isDone();
            if (!contineWait) {
                ExternalGE.onGeStopWaitList();
            }
            return contineWait;
        }
    }

    private class HLEAfterDrawSyncAction
    implements IAction {
        private HLEAfterDrawSyncAction() {
        }

        @Override
        public void execute() {
            sceGe_user.this.hleGeAfterDrawSyncAction();
        }
    }

    static class DeferredCallbackInfo {
        public final int cbid;
        public final int callbackIndex;
        public final int listId;
        public final int behavior;
        public final int callbackNotifyArg1;

        public DeferredCallbackInfo(int cbid, int callbackIndex, int callbackNotifyArg1) {
            this.cbid = cbid;
            this.callbackIndex = callbackIndex;
            this.listId = -1;
            this.behavior = 1;
            this.callbackNotifyArg1 = callbackNotifyArg1;
        }

        public DeferredCallbackInfo(int cbid, int callbackIndex, int listId, int behavior, int callbackNotifyArg1) {
            this.cbid = cbid;
            this.callbackIndex = callbackIndex;
            this.listId = listId;
            this.behavior = behavior;
            this.callbackNotifyArg1 = callbackNotifyArg1;
        }
    }
}

