/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.anim;

import jpcsp.format.rco.ObjectField;
import jpcsp.format.rco.anim.AbstractAnimAction;
import jpcsp.format.rco.anim.BaseAnim;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.type.FloatType;
import jpcsp.format.rco.type.IntType;
import jpcsp.format.rco.type.ObjectType;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;

public class RecolourAnim
extends BaseAnim {
    @ObjectField(order=1)
    public ObjectType ref;
    @ObjectField(order=2)
    public FloatType duration;
    @ObjectField(order=3)
    public IntType accelMode;
    @ObjectField(order=4)
    public FloatType red;
    @ObjectField(order=5)
    public FloatType green;
    @ObjectField(order=6)
    public FloatType blue;
    @ObjectField(order=7)
    public FloatType alpha;

    @Override
    protected long doPlayReference(BasePositionObject object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("RecolourAnim play %s on %s", this.toString(), object));
        }
        RecolourAnim.getScheduler().addAction(new RecolourAnimAction(this.duration.getIntValue(), object));
        return 0L;
    }

    @Override
    protected long doPlay(VSMXBaseObject object) {
        VSMXNativeObject nativeObject;
        BaseNativeObject baseNativeObject;
        if (object instanceof VSMXNativeObject && (baseNativeObject = (nativeObject = (VSMXNativeObject)object).getObject()) instanceof BasePositionObject) {
            return this.doPlayReference((BasePositionObject)baseNativeObject);
        }
        return super.doPlay(object);
    }

    private class RecolourAnimAction
    extends AbstractAnimAction {
        private BasePositionObject positionObject;
        private float startRed;
        private float startGreen;
        private float startBlue;
        private float startAlpha;

        public RecolourAnimAction(int duration, BasePositionObject positionObject) {
            super(duration);
            this.positionObject = positionObject;
            this.startRed = positionObject.redScale.getFloatValue();
            this.startGreen = positionObject.greenScale.getFloatValue();
            this.startBlue = positionObject.blueScale.getFloatValue();
            this.startAlpha = positionObject.alphaScale.getFloatValue();
        }

        @Override
        protected void anim(float step) {
            this.positionObject.redScale.setFloatValue(RecolourAnimAction.interpolate(this.startRed, RecolourAnim.this.red.getFloatValue(), step));
            this.positionObject.greenScale.setFloatValue(RecolourAnimAction.interpolate(this.startGreen, RecolourAnim.this.green.getFloatValue(), step));
            this.positionObject.blueScale.setFloatValue(RecolourAnimAction.interpolate(this.startBlue, RecolourAnim.this.blue.getFloatValue(), step));
            this.positionObject.alphaScale.setFloatValue(RecolourAnimAction.interpolate(this.startAlpha, RecolourAnim.this.alpha.getFloatValue(), step));
            this.positionObject.onDisplayUpdated();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("RecolourAnim '%s' from (%f,%f,%f,%f) to (%f,%f,%f,%f)", this.positionObject.getName(), Float.valueOf(this.startRed), Float.valueOf(this.startGreen), Float.valueOf(this.startBlue), Float.valueOf(this.startAlpha), Float.valueOf(this.positionObject.redScale.getFloatValue()), Float.valueOf(this.positionObject.greenScale.getFloatValue()), Float.valueOf(this.positionObject.blueScale.getFloatValue()), Float.valueOf(this.positionObject.alphaScale.getFloatValue())));
            }
        }
    }
}

