/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.Debugger.MemoryBreakpoints.MemoryBreakpoint;
import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.Processor;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class DebuggerMemory
extends Memory {
    public boolean traceMemoryRead = false;
    public boolean traceMemoryWrite = false;
    public boolean traceMemoryRead8 = false;
    public boolean traceMemoryWrite8 = false;
    public boolean traceMemoryRead16 = false;
    public boolean traceMemoryWrite16 = false;
    public boolean traceMemoryRead32 = false;
    public boolean traceMemoryWrite32 = false;
    public boolean pauseEmulatorOnMemoryBreakpoint = false;
    private HashSet<Integer> memoryReadBreakpoint;
    private HashSet<Integer> memoryWriteBreakpoint;
    private List<MemoryBreakpoint> memoryBreakpoints;
    private int lowestReadBreakpointAddress;
    private int highestReadBreakpointAddress;
    private int lowestWriteBreakpointAddress;
    private int highestWriteBreakpointAddress;
    private Memory mem;
    public static String mBrkFilePath = "Memory.mbrk";

    public DebuggerMemory(Memory mem) {
        this.mem = mem;
        this.memoryReadBreakpoint = new HashSet();
        this.memoryWriteBreakpoint = new HashSet();
        this.memoryBreakpoints = new LinkedList<MemoryBreakpoint>();
        this.lowestReadBreakpointAddress = Integer.MAX_VALUE;
        this.highestReadBreakpointAddress = 0;
        this.lowestWriteBreakpointAddress = Integer.MAX_VALUE;
        this.highestWriteBreakpointAddress = 0;
        if (new File(mBrkFilePath).exists()) {
            this.importBreakpoints(mBrkFilePath);
        }
    }

    public List<MemoryBreakpoint> getMemoryBreakpoints() {
        return this.memoryBreakpoints;
    }

    private void setBreakpointToken(String token) {
        if (token.isEmpty()) {
            return;
        }
        if (token.equals("read")) {
            this.traceMemoryRead = true;
        } else if (token.equals("read8")) {
            this.traceMemoryRead8 = true;
        } else if (token.equals("read16")) {
            this.traceMemoryRead16 = true;
        } else if (token.equals("read32")) {
            this.traceMemoryRead32 = true;
        } else if (token.equals("write")) {
            this.traceMemoryWrite = true;
        } else if (token.equals("write8")) {
            this.traceMemoryWrite8 = true;
        } else if (token.equals("write16")) {
            this.traceMemoryWrite16 = true;
        } else if (token.equals("write32")) {
            this.traceMemoryWrite32 = true;
        } else if (token.equals("pause")) {
            this.pauseEmulatorOnMemoryBreakpoint = true;
        } else {
            log.error((Object)String.format("Unknown token '%s'", token));
        }
    }

    public final void exportBreakpoints(String filename) {
        this.exportBreakpoints(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void exportBreakpoints(File f) {
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(f));
            block8: for (MemoryBreakpoint mbp : this.memoryBreakpoints) {
                String line = "";
                switch (mbp.getAccess()) {
                    case READ: {
                        line = line + "R ";
                        break;
                    }
                    case WRITE: {
                        line = line + "W ";
                        break;
                    }
                    case READWRITE: {
                        line = line + "RW ";
                        break;
                    }
                    default: {
                        continue block8;
                    }
                }
                line = line + String.format("0x%08X", mbp.getStartAddress());
                if (mbp.getStartAddress() != mbp.getEndAddress()) {
                    line = line + String.format(" - 0x%08X", mbp.getEndAddress());
                }
                line = line + System.getProperty("line.separator");
                out.write(line);
            }
            if (this.traceMemoryRead) {
                out.write("read|");
            }
            if (this.traceMemoryWrite) {
                out.write("write|");
            }
            if (this.traceMemoryRead8) {
                out.write("read8|");
            }
            if (this.traceMemoryWrite8) {
                out.write("write8|");
            }
            if (this.traceMemoryRead16) {
                out.write("read16|");
            }
            if (this.traceMemoryWrite16) {
                out.write("write16|");
            }
            if (this.traceMemoryRead32) {
                out.write("read32|");
            }
            if (this.traceMemoryWrite32) {
                out.write("write32|");
            }
            if (this.pauseEmulatorOnMemoryBreakpoint) {
                out.write("pause");
            }
            out.write(System.getProperty("line.separator"));
        }
        catch (IOException iOException) {
            Utilities.close(out);
        }
        catch (Throwable throwable) {
            Utilities.close(out);
            throw throwable;
        }
        Utilities.close(out);
    }

    public final void importBreakpoints(String filename) {
        this.importBreakpoints(new File(filename));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void importBreakpoints(File f) {
        BufferedReader in = null;
        try {
            String line;
            in = new BufferedReader(new FileReader(f));
            this.traceMemoryRead = false;
            this.traceMemoryWrite = false;
            this.traceMemoryRead8 = false;
            this.traceMemoryWrite8 = false;
            this.traceMemoryRead16 = false;
            this.traceMemoryWrite16 = false;
            this.traceMemoryRead32 = false;
            this.traceMemoryWrite32 = false;
            this.pauseEmulatorOnMemoryBreakpoint = false;
            while ((line = in.readLine()) != null) {
                int rangeIndex = (line = line.trim()).indexOf("-");
                if (rangeIndex >= 0) {
                    int end;
                    if (line.startsWith("RW ")) {
                        int start = Utilities.parseAddress(line.substring(2, rangeIndex));
                        end = Utilities.parseAddress(line.substring(rangeIndex + 1));
                        this.memoryBreakpoints.add(new MemoryBreakpoint(this, start, end, MemoryBreakpoint.AccessType.READWRITE));
                        continue;
                    }
                    if (line.startsWith("R ")) {
                        int start = Utilities.parseAddress(line.substring(1, rangeIndex));
                        end = Utilities.parseAddress(line.substring(rangeIndex + 1));
                        this.memoryBreakpoints.add(new MemoryBreakpoint(this, start, end, MemoryBreakpoint.AccessType.READ));
                        continue;
                    }
                    if (!line.startsWith("W ")) continue;
                    int start = Utilities.parseAddress(line.substring(1, rangeIndex));
                    end = Utilities.parseAddress(line.substring(rangeIndex + 1));
                    this.memoryBreakpoints.add(new MemoryBreakpoint(this, start, end, MemoryBreakpoint.AccessType.WRITE));
                    continue;
                }
                if (line.startsWith("RW ")) {
                    int address = Utilities.parseAddress(line.substring(2));
                    this.memoryBreakpoints.add(new MemoryBreakpoint(this, address, MemoryBreakpoint.AccessType.READWRITE));
                    continue;
                }
                if (line.startsWith("R ")) {
                    int address = Utilities.parseAddress(line.substring(1));
                    this.memoryBreakpoints.add(new MemoryBreakpoint(this, address, MemoryBreakpoint.AccessType.READ));
                    continue;
                }
                if (line.startsWith("W ")) {
                    int address = Utilities.parseAddress(line.substring(1));
                    this.memoryBreakpoints.add(new MemoryBreakpoint(this, address, MemoryBreakpoint.AccessType.WRITE));
                    continue;
                }
                if (line.startsWith("#")) continue;
                String[] tokens = line.split("\\|");
                for (int i = 0; tokens != null && i < tokens.length; ++i) {
                    String token = tokens[i].trim().toLowerCase();
                    this.setBreakpointToken(token);
                }
            }
        }
        catch (IOException iOException) {
            Utilities.close(in);
        }
        catch (Throwable throwable) {
            Utilities.close(in);
            throw throwable;
        }
        Utilities.close(in);
        log.info((Object)String.format("%d memory breakpoint(s) imported", this.memoryBreakpoints.size()));
    }

    public static boolean isInstalled() {
        return Memory.getInstance() instanceof DebuggerMemory;
    }

    public static void install() {
        if (!DebuggerMemory.isInstalled()) {
            log.info((Object)"Using DebuggerMemory");
            DebuggerMemory debuggerMemory = new DebuggerMemory(Memory.getInstance());
            Memory.setInstance(debuggerMemory);
            RuntimeContext.updateMemory();
        }
    }

    public static void deinstall() {
        if (DebuggerMemory.isInstalled()) {
            DebuggerMemory debuggerMemory = (DebuggerMemory)Memory.getInstance();
            Memory.setInstance(debuggerMemory.mem);
        }
    }

    public void addReadBreakpoint(int address) {
        if ((address &= 0x1FFFFFFF) < this.lowestReadBreakpointAddress) {
            this.lowestReadBreakpointAddress = address;
        }
        if (address > this.highestReadBreakpointAddress) {
            this.highestReadBreakpointAddress = address;
        }
        this.memoryReadBreakpoint.add(address);
    }

    public void removeReadBreakpoint(int address) {
        this.memoryReadBreakpoint.remove(address &= 0x1FFFFFFF);
    }

    public void addRangeReadBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.addReadBreakpoint(address);
        }
    }

    public void removeRangeReadBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.removeReadBreakpoint(address);
        }
    }

    public void addWriteBreakpoint(int address) {
        if ((address &= 0x1FFFFFFF) < this.lowestWriteBreakpointAddress) {
            this.lowestWriteBreakpointAddress = address;
        }
        if (address > this.highestWriteBreakpointAddress) {
            this.highestWriteBreakpointAddress = address;
        }
        this.memoryWriteBreakpoint.add(address);
    }

    public void removeWriteBreakpoint(int address) {
        this.memoryWriteBreakpoint.remove(address &= 0x1FFFFFFF);
    }

    public void addRangeWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.addWriteBreakpoint(address);
        }
    }

    public void removeRangeWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.removeWriteBreakpoint(address);
        }
    }

    public void addReadWriteBreakpoint(int address) {
        this.addReadBreakpoint(address);
        this.addWriteBreakpoint(address);
    }

    public void removeReadWriteBreakpoint(int address) {
        this.removeReadBreakpoint(address);
        this.removeWriteBreakpoint(address);
    }

    public void addRangeReadWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.addReadWriteBreakpoint(address);
        }
    }

    public void removeRangeReadWriteBreakpoint(int start, int end) {
        for (int address = start; address <= end; ++address) {
            this.removeReadWriteBreakpoint(address);
        }
    }

    protected String getMemoryReadMessage(int address, int value, int width) {
        StringBuilder message = new StringBuilder();
        Processor processor = RuntimeContextLLE.getProcessor();
        if (processor != null) {
            message.append(String.format("0x%08X - ", processor.cpu.pc));
        }
        if (width == 8 || width == 16 || width == 32) {
            message.append(String.format("read%d(0x%08X)=0x", width, address));
            if (width == 8) {
                message.append(String.format("%02X", value));
            } else if (width == 16) {
                message.append(String.format("%04X", value));
            } else if (width == 32) {
                message.append(String.format("%08X", value));
            }
        } else {
            int length = width / 8;
            message.append(String.format("read 0x%08X-0x%08X (length=%d)", address, address + length, length));
        }
        return message.toString();
    }

    protected void memoryRead(int address, int value, int width, boolean trace) {
        if ((this.traceMemoryRead || trace) && log.isTraceEnabled()) {
            log.trace((Object)this.getMemoryReadMessage(address, value, width));
        }
        if ((this.pauseEmulatorOnMemoryBreakpoint || log.isInfoEnabled()) && this.memoryReadBreakpoint.contains(address & 0x1FFFFFFF)) {
            log.info((Object)this.getMemoryReadMessage(address, value, width));
            if (this.pauseEmulatorOnMemoryBreakpoint) {
                Emulator.PauseEmuWithStatus(16);
            }
        }
    }

    protected String getMemoryWriteMessage(int address, int value, int width) {
        StringBuilder message = new StringBuilder();
        Processor processor = RuntimeContextLLE.getProcessor();
        if (processor != null) {
            message.append(String.format("0x%08X - ", processor.cpu.pc));
        }
        message.append(String.format("write%d(0x%08X, 0x", width, address));
        if (width == 8) {
            message.append(String.format("%02X", value & 0xFF));
        } else if (width == 16) {
            message.append(String.format("%04X", value & 0xFFFF));
        } else if (width == 32) {
            message.append(String.format("%08X", value));
        }
        message.append(")");
        return message.toString();
    }

    protected void memoryWrite(int address, int value, int width, boolean trace) {
        if ((this.traceMemoryWrite || trace) && log.isTraceEnabled()) {
            log.trace((Object)this.getMemoryWriteMessage(address, value, width));
        }
        if ((this.pauseEmulatorOnMemoryBreakpoint || log.isInfoEnabled()) && this.memoryWriteBreakpoint.contains(address & 0x1FFFFFFF)) {
            log.info((Object)this.getMemoryWriteMessage(address, value, width));
            if (this.pauseEmulatorOnMemoryBreakpoint) {
                Emulator.PauseEmuWithStatus(16);
            }
        }
    }

    private boolean isCheckingMemoryWriteAccess(int address, int length, boolean trace) {
        if ((this.traceMemoryWrite || trace) && log.isTraceEnabled()) {
            return true;
        }
        if ((address &= 0x1FFFFFFF) > this.highestWriteBreakpointAddress || address + length < this.lowestWriteBreakpointAddress) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.memoryWriteBreakpoint.contains(address)) {
                return true;
            }
            ++i;
            ++address;
        }
        return false;
    }

    private boolean isCheckingMemoryReadAccess(int address, int length, boolean trace) {
        if ((this.traceMemoryRead || trace) && log.isTraceEnabled()) {
            return true;
        }
        if ((address &= 0x1FFFFFFF) > this.highestReadBreakpointAddress || address + length < this.lowestReadBreakpointAddress) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (this.memoryReadBreakpoint.contains(address)) {
                return true;
            }
            ++i;
            ++address;
        }
        return false;
    }

    @Override
    public void Initialise() {
        this.mem.Initialise();
    }

    @Override
    public boolean allocate() {
        return this.mem.allocate();
    }

    @Override
    public void copyToMemory(int address, ByteBuffer source, int length) {
        if (this.isCheckingMemoryWriteAccess(address, length, this.traceMemoryWrite8)) {
            for (int i = 0; i < length && source.hasRemaining(); ++i) {
                byte value = source.get();
                this.write8(address + i, value);
            }
        } else {
            this.mem.copyToMemory(address, source, length);
        }
    }

    @Override
    public Buffer getBuffer(int address, int length) {
        this.memoryRead(address, 0, length * 8, false);
        return this.mem.getBuffer(address, length);
    }

    @Override
    public Buffer getMainMemoryByteBuffer() {
        return this.mem.getMainMemoryByteBuffer();
    }

    @Override
    protected void memcpy(int destination, int source, int length, boolean checkOverlap) {
        destination = this.normalize(destination);
        source = this.normalize(source);
        if (this.isCheckingMemoryWriteAccess(destination, length, this.traceMemoryWrite8) || this.isCheckingMemoryReadAccess(source, length, this.traceMemoryRead8)) {
            if (!checkOverlap || source >= destination || !this.areOverlapping(destination, source, length)) {
                for (int i = 0; i < length; ++i) {
                    this.write8(destination + i, (byte)this.read8(source + i));
                }
            } else {
                for (int i = length - 1; i >= 0; --i) {
                    this.write8(destination + i, (byte)this.read8(source + i));
                }
            }
        } else if (checkOverlap) {
            this.mem.memmove(destination, source, length);
        } else {
            this.mem.memcpy(destination, source, length);
        }
    }

    @Override
    public void memset(int address, byte data, int length) {
        if (this.isCheckingMemoryWriteAccess(address, length, this.traceMemoryWrite8)) {
            for (int i = 0; i < length; ++i) {
                this.write8(address + i, data);
            }
        } else {
            this.mem.memset(address, data, length);
        }
    }

    @Override
    public int read8(int address) {
        int value = this.mem.read8(address);
        this.memoryRead(address, value, 8, this.traceMemoryRead8);
        return value;
    }

    @Override
    public int read16(int address) {
        int value = this.mem.read16(address);
        this.memoryRead(address, value, 16, this.traceMemoryRead16);
        return value;
    }

    @Override
    public int read32(int address) {
        int value = this.mem.read32(address);
        this.memoryRead(address, value, 32, this.traceMemoryRead32);
        return value;
    }

    @Override
    public int internalRead8(int address) {
        int value = this.mem.read8(address);
        return value;
    }

    @Override
    public int internalRead16(int address) {
        int value = this.mem.read16(address);
        return value;
    }

    @Override
    public int internalRead32(int address) {
        int value = this.mem.read32(address);
        return value;
    }

    @Override
    public void write8(int address, byte data) {
        this.memoryWrite(address, data, 8, this.traceMemoryWrite8);
        this.mem.write8(address, data);
    }

    @Override
    public void write16(int address, short data) {
        this.memoryWrite(address, data, 16, this.traceMemoryWrite16);
        this.mem.write16(address, data);
    }

    @Override
    public void write32(int address, int data) {
        this.memoryWrite(address, data, 32, this.traceMemoryWrite32);
        this.mem.write32(address, data);
    }

    @Override
    public void setIgnoreInvalidMemoryAccess(boolean ignoreInvalidMemoryAccess) {
        super.setIgnoreInvalidMemoryAccess(ignoreInvalidMemoryAccess);
        if (this.mem != null) {
            this.mem.setIgnoreInvalidMemoryAccess(ignoreInvalidMemoryAccess);
        }
    }

    @Override
    public void remapMemoryAtProcessorReset() {
        this.mem.remapMemoryAtProcessorReset();
    }

    @Override
    public void reset() {
        this.mem.reset();
    }

    @Override
    public int normalize(int address) {
        return this.mem.normalize(address);
    }

    public Memory getDebuggedMemory() {
        return this.mem;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        this.mem.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        this.mem.write(stream);
    }
}

