/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import jpcsp.GUI.UmdVideoPlayer;
import jpcsp.format.rco.AnimFactory;
import jpcsp.format.rco.LZR;
import jpcsp.format.rco.ObjectFactory;
import jpcsp.format.rco.RCOContext;
import jpcsp.format.rco.RCOState;
import jpcsp.format.rco.SoundFactory;
import jpcsp.format.rco.object.BaseObject;
import jpcsp.format.rco.object.ImageObject;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.objects.Controller;
import jpcsp.format.rco.vsmx.objects.GlobalVariables;
import jpcsp.format.rco.vsmx.objects.Math;
import jpcsp.format.rco.vsmx.objects.MoviePlayer;
import jpcsp.format.rco.vsmx.objects.Resource;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class RCO {
    public static final Logger log = Logger.getLogger((String)"rco");
    private static final boolean dumpImages = false;
    private static final int RCO_HEADER_SIZE = 164;
    private static final int RCO_MAGIC = 5263942;
    private static final int RCO_NULL_PTR = -1;
    public static final int RCO_TABLE_MAIN = 1;
    public static final int RCO_TABLE_VSMX = 2;
    public static final int RCO_TABLE_TEXT = 3;
    public static final int RCO_TABLE_IMG = 4;
    public static final int RCO_TABLE_MODEL = 5;
    public static final int RCO_TABLE_SOUND = 6;
    public static final int RCO_TABLE_FONT = 7;
    public static final int RCO_TABLE_OBJ = 8;
    public static final int RCO_TABLE_ANIM = 9;
    public static final int RCO_DATA_COMPRESSION_NONE = 0;
    public static final int RCO_DATA_COMPRESSION_ZLIB = 1;
    public static final int RCO_DATA_COMPRESSION_RLZ = 2;
    private static final Charset textDataCharset = Charset.forName("UTF-16LE");
    private byte[] buffer;
    private int offset;
    private boolean valid;
    private int pVSMXTable;
    private int pTextData;
    private int lTextData;
    private int pLabelData;
    private int lLabelData;
    private int pImgData;
    private int lImgData;
    private RCOEntry mainTable;
    private int[] compressedTextDataOffset;
    private Map<Integer, RCOEntry> entries;
    private Map<Integer, String> events;
    private Map<Integer, BufferedImage> images;
    private Map<Integer, BaseObject> objects;

    private int read8() {
        return this.buffer[this.offset++] & 0xFF;
    }

    private int read16() {
        return this.read8() | this.read8() << 8;
    }

    private int read32() {
        return this.read16() | this.read16() << 16;
    }

    private void skip(int n) {
        this.offset += n;
    }

    private void skip32() {
        this.skip(4);
    }

    private void skip16() {
        this.skip(2);
    }

    private void seek(int offset) {
        this.offset = offset;
    }

    private int tell() {
        return this.offset;
    }

    public RCO(byte[] buffer) {
        this.buffer = buffer;
        this.valid = this.read();
    }

    public boolean isValid() {
        return this.valid;
    }

    private RCOEntry readRCOEntry() {
        RCOEntry entry = new RCOEntry();
        entry.read();
        return entry;
    }

    private RCOEntry readRCOEntry(int offset) {
        this.seek(offset);
        return this.readRCOEntry();
    }

    private boolean isNull(int ptr) {
        return ptr == -1;
    }

    private byte[] readBytes(int length) {
        if (length < 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)this.read8();
        }
        return bytes;
    }

    private byte[] readVSMX(int offset, StringBuilder name) {
        if (this.isNull(offset)) {
            return null;
        }
        RCOEntry entry = this.readRCOEntry(offset);
        name.append(entry.label);
        return entry.data;
    }

    private String readLabel(int labelOffset) {
        int b;
        StringBuilder s = new StringBuilder();
        int currentPosition = this.tell();
        this.seek(this.pLabelData + labelOffset);
        for (int maxLength = this.lLabelData - labelOffset; maxLength > 0 && (b = this.read8()) != 0; --maxLength) {
            s.append((char)b);
        }
        this.seek(currentPosition);
        return s.toString();
    }

    private String readText(int lang, int offset, int length) {
        if (offset == -1) {
            return null;
        }
        int currentPosition = this.tell();
        if (this.compressedTextDataOffset != null) {
            this.seek(this.compressedTextDataOffset[lang] + offset);
        } else {
            this.seek(this.pTextData + offset);
        }
        byte[] buffer = this.readBytes(length);
        this.seek(currentPosition);
        if (length >= 2 && buffer[length - 1] == 0 && buffer[length - 2] == 0) {
            length -= 2;
        }
        return new String(buffer, 0, length, textDataCharset);
    }

    private BufferedImage readImage(int offset, int length) {
        int currentPosition = this.tell();
        this.seek(this.pImgData + offset);
        byte[] buffer = this.readBytes(length);
        this.seek(currentPosition);
        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(buffer);
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = ImageIO.read(imageInputStream);
            ((InputStream)imageInputStream).close();
            if (!bufferedImage.getColorModel().hasAlpha()) {
                BufferedImage bufferedImageWithAlpha = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), 2);
                Graphics2D g = bufferedImageWithAlpha.createGraphics();
                g.drawImage((Image)bufferedImage, 0, 0, null);
                g.dispose();
                bufferedImage = bufferedImageWithAlpha;
            }
        }
        catch (IOException e) {
            log.error((Object)String.format("Error reading image from RCO at 0x%X, length=0x%X", offset, length), (Throwable)e);
        }
        return bufferedImage;
    }

    private String readString() {
        int b;
        StringBuilder s = new StringBuilder();
        while ((b = this.read8()) != 0) {
            s.append((char)b);
        }
        return s.toString();
    }

    private static byte[] append(byte[] a, byte[] b) {
        if (a == null || a.length == 0) {
            return b;
        }
        if (b == null || b.length == 0) {
            return a;
        }
        byte[] ab = new byte[a.length + b.length];
        System.arraycopy(a, 0, ab, 0, a.length);
        System.arraycopy(b, 0, ab, a.length, b.length);
        return ab;
    }

    private static byte[] append(byte[] a, int length, byte[] b) {
        if (a == null || a.length == 0 || length <= 0) {
            return b;
        }
        if (b == null || b.length == 0) {
            return a;
        }
        length = java.lang.Math.min(a.length, length);
        byte[] ab = new byte[length + b.length];
        System.arraycopy(a, 0, ab, 0, length);
        System.arraycopy(b, 0, ab, length, b.length);
        return ab;
    }

    private static int[] extend(int[] a, int length) {
        if (a == null) {
            return new int[length];
        }
        if (a.length >= length) {
            return a;
        }
        int[] b = new int[length];
        System.arraycopy(a, 0, b, 0, a.length);
        return b;
    }

    private boolean read() {
        int i;
        int magic = Utilities.endianSwap32(this.read32());
        if (magic != 5263942) {
            log.warn((Object)String.format("Invalid RCO magic 0x%08X", magic));
            return false;
        }
        int version = this.read32();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("RCO version 0x%X", version));
        }
        this.skip32();
        int compression = this.read32();
        int umdFlag = compression & 0xF;
        int headerCompression = (compression & 0xF0) >> 4;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("umdFlag=0x%X, headerCompression=0x%X", umdFlag, headerCompression));
        }
        int pMainTable = this.read32();
        this.pVSMXTable = this.read32();
        int pTextTable = this.read32();
        int pSoundTable = this.read32();
        int pModelTable = this.read32();
        int pImgTable = this.read32();
        this.skip32();
        int pFontTable = this.read32();
        int pObjTable = this.read32();
        int pAnimTable = this.read32();
        this.pTextData = this.read32();
        this.lTextData = this.read32();
        this.pLabelData = this.read32();
        this.lLabelData = this.read32();
        int pEventData = this.read32();
        int lEventData = this.read32();
        int pTextPtrs = this.read32();
        int lTextPtrs = this.read32();
        int pImgPtrs = this.read32();
        int lImgPtrs = this.read32();
        int pModelPtrs = this.read32();
        int lModelPtrs = this.read32();
        int pSoundPtrs = this.read32();
        int lSoundPtrs = this.read32();
        int pObjPtrs = this.read32();
        int lObjPtrs = this.read32();
        int pAnimPtrs = this.read32();
        int lAnimPtrs = this.read32();
        this.pImgData = this.read32();
        this.lImgData = this.read32();
        int pSoundData = this.read32();
        int lSoundData = this.read32();
        int pModelData = this.read32();
        int lModelData = this.read32();
        this.skip32();
        this.skip32();
        this.skip32();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("pMainTable=0x%X, pVSMXTable=0x%X, pTextTable=0x%X, pSoundTable=0x%X, pModelTable=0x%X, pImgTable=0x%X, pFontTable=0x%X, pObjTable=0x%X, pAnimTable=0x%X", pMainTable, this.pVSMXTable, pTextTable, pSoundTable, pModelTable, pImgTable, pFontTable, pObjTable, pAnimTable));
            log.debug((Object)String.format("TextData=0x%X[0x%X], LabelData=0x%X[0x%X], EventData=0x%X[0x%X]", this.pTextData, this.lTextData, this.pLabelData, this.lLabelData, pEventData, lEventData));
            log.debug((Object)String.format("TextPtrs=0x%X[0x%X], ImgPtrs=0x%X[0x%X], ModelPtrs=0x%X[0x%X], SoundPtrs=0x%X[0x%X], ObjPtrs=0x%X[0x%X], AnimPtrs=0x%X[0x%X]", pTextPtrs, lTextPtrs, pImgPtrs, lImgPtrs, pModelPtrs, lModelPtrs, pSoundPtrs, lSoundPtrs, pObjPtrs, lObjPtrs, pAnimPtrs, lAnimPtrs));
            log.debug((Object)String.format("ImgData=0x%X[0x%X], SoundData=0x%X[0x%X], ModelData=0x%X[0x%X]", this.pImgData, this.lImgData, pSoundData, lSoundData, pModelData, lModelData));
        }
        if (headerCompression != 0) {
            int result;
            int lenPacked = this.read32();
            int lenUnpacked = this.read32();
            int lenLongestText = this.read32();
            byte[] packedBuffer = this.readBytes(lenPacked);
            byte[] unpackedBuffer = new byte[lenUnpacked];
            if (headerCompression == 2) {
                result = LZR.decompress(unpackedBuffer, lenUnpacked, packedBuffer);
            } else {
                log.warn((Object)String.format("Unimplemented compression %d", headerCompression));
                result = -1;
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Unpack header longestText=0x%X, result=0x%X: %s", lenLongestText, result, Utilities.getMemoryDump(unpackedBuffer, 0, lenUnpacked)));
            }
            if (this.pTextData != -1 && this.lTextData > 0) {
                int nextOffset;
                this.seek(this.pTextData);
                do {
                    int textLang = this.read16();
                    this.skip16();
                    nextOffset = this.read32();
                    int textLenPacked = this.read32();
                    int textLenUnpacked = this.read32();
                    byte[] textPackedBuffer = this.readBytes(textLenPacked);
                    byte[] textUnpackedBuffer = new byte[textLenUnpacked];
                    if (headerCompression == 2) {
                        result = LZR.decompress(textUnpackedBuffer, textLenUnpacked, textPackedBuffer);
                    } else {
                        log.warn((Object)String.format("Unimplemented compression %d", headerCompression));
                        result = -1;
                    }
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Unpack text lang=%d, result=0x%X: %s", textLang, result, Utilities.getMemoryDump(textUnpackedBuffer, 0, textLenUnpacked)));
                    }
                    if (result >= 0) {
                        this.compressedTextDataOffset = RCO.extend(this.compressedTextDataOffset, textLang + 1);
                        this.compressedTextDataOffset[textLang] = unpackedBuffer.length + 164;
                        unpackedBuffer = RCO.append(unpackedBuffer, textUnpackedBuffer);
                    }
                    if (nextOffset == 0) break;
                    this.skip(nextOffset - 16 - textLenPacked);
                } while (nextOffset != 0);
            }
            if (result >= 0) {
                this.buffer = RCO.append(this.buffer, 164, unpackedBuffer);
            }
        }
        this.events = new HashMap<Integer, String>();
        if (pEventData != -1 && lEventData > 0) {
            this.seek(pEventData);
            while (this.tell() < pEventData + lEventData) {
                int index = this.tell() - pEventData;
                String s = this.readString();
                if (s == null || s.length() <= 0) continue;
                this.events.put(index, s);
            }
        }
        this.entries = new HashMap<Integer, RCOEntry>();
        this.images = new HashMap<Integer, BufferedImage>();
        this.objects = new HashMap<Integer, BaseObject>();
        this.mainTable = this.readRCOEntry(pMainTable);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("mainTable: %s", this.mainTable));
        }
        if (pObjPtrs != -1) {
            this.seek(pObjPtrs);
            for (i = 0; i < lObjPtrs; i += 4) {
                int objPtr = this.read32();
                if (objPtr == 0 || this.objects.containsKey(objPtr)) continue;
                log.warn((Object)String.format("Object 0x%X not read", objPtr));
            }
        }
        if (pImgPtrs != -1) {
            this.seek(pImgPtrs);
            for (i = 0; i < lImgPtrs; i += 4) {
                int imgPtr = this.read32();
                if (imgPtr == 0 || this.images.containsKey(imgPtr)) continue;
                log.warn((Object)String.format("Image 0x%X not read", imgPtr));
            }
        }
        RCOContext context = new RCOContext(null, 0, this.events, this.images, this.objects);
        for (BaseObject object : this.objects.values()) {
            object.init(context);
        }
        return true;
    }

    public RCOState execute(UmdVideoPlayer umdVideoPlayer, String resourceName) {
        RCOState state = null;
        if (this.pVSMXTable != -1) {
            state = new RCOState();
            state.interpreter = new VSMXInterpreter();
            state.controller = Controller.create(state.interpreter, umdVideoPlayer, resourceName);
            state = this.execute(state, umdVideoPlayer, resourceName);
            state.controller.getObject().callCallback(state.interpreter, "onAutoPlay", null);
        }
        return state;
    }

    public RCOState execute(RCOState state, UmdVideoPlayer umdVideoPlayer, String resourceName) {
        if (this.pVSMXTable != -1) {
            StringBuilder vsmxName = new StringBuilder();
            VSMX vsmx = new VSMX(this.readVSMX(this.pVSMXTable, vsmxName), vsmxName.toString());
            state.interpreter.setVSMX(vsmx);
            state.globalVariables = GlobalVariables.create(state.interpreter);
            state.globalVariables.setPropertyValue("controller", (VSMXBaseObject)state.controller);
            state.globalVariables.setPropertyValue("movieplayer", (VSMXBaseObject)MoviePlayer.create(state.interpreter, umdVideoPlayer, state.controller));
            state.globalVariables.setPropertyValue("resource", (VSMXBaseObject)Resource.create(state.interpreter, umdVideoPlayer.getRCODisplay(), state.controller, this.mainTable));
            state.globalVariables.setPropertyValue("Math", (VSMXBaseObject)Math.create(state.interpreter));
            state.interpreter.run(state.globalVariables);
        }
        return state;
    }

    public String toString() {
        return String.format("RCO valid=%b", this.valid);
    }

    public class RCOEntry {
        private static final int RCO_ENTRY_SIZE = 40;
        public int type;
        public int id;
        public int labelOffset;
        public String label;
        public int eHeadSize;
        public int entrySize;
        public int numSubEntries;
        public int nextEntryOffset;
        public int prevEntryOffset;
        public int parentTblOffset;
        public RCOEntry[] subEntries;
        public RCOEntry parent;
        public byte[] data;
        public BaseObject obj;
        public String[] texts;
        public VSMXBaseObject vsmxBaseObject;

        public void read() {
            int entryOffset = RCO.this.tell();
            this.type = RCO.this.read8();
            this.id = RCO.this.read8();
            RCO.this.skip16();
            this.labelOffset = RCO.this.read32();
            this.eHeadSize = RCO.this.read32();
            this.entrySize = RCO.this.read32();
            this.numSubEntries = RCO.this.read32();
            this.nextEntryOffset = RCO.this.read32();
            this.prevEntryOffset = RCO.this.read32();
            this.parentTblOffset = RCO.this.read32();
            RCO.this.skip32();
            RCO.this.skip32();
            RCO.this.entries.put(entryOffset, this);
            if (this.parentTblOffset != 0) {
                this.parent = (RCOEntry)RCO.this.entries.get(entryOffset - this.parentTblOffset);
            }
            if (this.labelOffset != -1) {
                this.label = RCO.this.readLabel(this.labelOffset);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("RCO entry at offset 0x%X: %s", entryOffset, this.toString()));
            }
            switch (this.id) {
                case 1: {
                    if (this.type == 1) break;
                    log.warn((Object)String.format("Unknown RCO entry type 0x%X at offset 0x%X", this.type, entryOffset));
                    break;
                }
                case 2: {
                    if (this.type == 1) {
                        int offsetVSMX = RCO.this.read32();
                        int lengthVSMX = RCO.this.read32();
                        RCO.this.skip(offsetVSMX);
                        this.data = RCO.this.readBytes(lengthVSMX);
                        RCO.this.skip(Utilities.alignUp(lengthVSMX, 3) - lengthVSMX);
                        break;
                    }
                    log.warn((Object)String.format("Unknown RCO entry type 0x%X at offset 0x%X", this.type, entryOffset));
                    break;
                }
                case 4: 
                case 5: {
                    int offset;
                    int format;
                    if (this.type == 1) {
                        BufferedImage image;
                        format = RCO.this.read16();
                        int compression = RCO.this.read16();
                        int sizePacked = RCO.this.read32();
                        offset = RCO.this.read32();
                        int sizeUnpacked = compression != 0 ? RCO.this.read32() : sizePacked;
                        if (this.id == 4 && (image = RCO.this.readImage(offset, sizePacked)) != null) {
                            this.obj = new ImageObject(image);
                            RCO.this.images.put(entryOffset, image);
                        }
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("RCO entry %s: format=%d, compression=%d, sizePacked=0x%X, offset=0x%X, sizeUnpacked=0x%X", this.id == 4 ? "IMG" : "MODEL", format, compression, sizePacked, offset, sizeUnpacked));
                        break;
                    }
                    if (this.type == 0) break;
                    log.warn((Object)String.format("Unknown RCO entry type 0x%X at offset 0x%X", this.type, entryOffset));
                    break;
                }
                case 6: {
                    int offset;
                    int format;
                    if (this.type == 1) {
                        format = RCO.this.read16();
                        int channels = RCO.this.read16();
                        int sizeTotal = RCO.this.read32();
                        offset = RCO.this.read32();
                        int[] channelSize = new int[channels];
                        int[] channelOffset = new int[channels];
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("RCO entry SOUND: format=%d, channels=%d, sizeTotal=0x%X, offset=0x%X", format, channels, sizeTotal, offset));
                        }
                        for (int channel = 0; channel < channels; ++channel) {
                            channelSize[channel] = RCO.this.read32();
                            channelOffset[channel] = RCO.this.read32();
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("Channel %d: size=0x%X, offset=0x%X", channel, channelSize[channel], channelOffset[channel]));
                        }
                        this.obj = SoundFactory.newSound(format, channels, channelSize, channelOffset);
                        if (channels >= 2) break;
                        for (int i = channels; i < 2; ++i) {
                            int dummyChannelSize = RCO.this.read32();
                            int dummyChannelOffset = RCO.this.read32();
                            if (!log.isTraceEnabled()) continue;
                            log.trace((Object)String.format("Dummy channel %d: size=0x%X, offset=0x%X", i, dummyChannelSize, dummyChannelOffset));
                        }
                        break;
                    }
                    if (this.type == 0) break;
                    log.warn((Object)String.format("Unknown RCO entry type 0x%X at offset 0x%X", this.type, entryOffset));
                    break;
                }
                case 8: {
                    if (this.type <= 0) break;
                    this.obj = ObjectFactory.newObject(this.type);
                    if (this.obj != null && this.entrySize == 0) {
                        this.entrySize = this.obj.size() + 40;
                    }
                    if (this.entrySize <= 40) break;
                    int dataLength = this.entrySize - 40;
                    this.data = RCO.this.readBytes(dataLength);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("OBJ data at 0x%X: %s", entryOffset + 40, Utilities.getMemoryDump(this.data, 0, dataLength)));
                    }
                    if (this.obj == null) break;
                    RCOContext context = new RCOContext(this.data, 0, RCO.this.events, RCO.this.images, RCO.this.objects);
                    this.obj.read(context);
                    if (context.offset != dataLength) {
                        log.warn((Object)String.format("Incorrect length data for ANIM", new Object[0]));
                    }
                    RCO.this.objects.put(entryOffset, this.obj);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("OBJ: %s", this.obj));
                    break;
                }
                case 9: {
                    if (this.type <= 0) break;
                    this.obj = AnimFactory.newAnim(this.type);
                    if (this.obj != null && this.entrySize == 0) {
                        this.entrySize = this.obj.size() + 40;
                    }
                    if (this.entrySize <= 40) break;
                    int dataLength = this.entrySize - 40;
                    this.data = RCO.this.readBytes(dataLength);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("ANIM data at 0x%X: %s", entryOffset + 40, Utilities.getMemoryDump(this.data, 0, dataLength)));
                    }
                    if (this.obj == null) break;
                    RCOContext context = new RCOContext(this.data, 0, RCO.this.events, RCO.this.images, RCO.this.objects);
                    this.obj.read(context);
                    if (context.offset != dataLength) {
                        log.warn((Object)String.format("Incorrect length data for ANIM", new Object[0]));
                    }
                    RCO.this.objects.put(entryOffset, this.obj);
                    if (!log.isDebugEnabled()) break;
                    log.debug((Object)String.format("ANIM: %s", this.obj));
                    break;
                }
                case 7: {
                    int format;
                    if (this.type == 1) {
                        format = RCO.this.read16();
                        int compression = RCO.this.read16();
                        int unknown1 = RCO.this.read32();
                        int unknown2 = RCO.this.read32();
                        if (!log.isDebugEnabled()) break;
                        log.debug((Object)String.format("RCO entry FONT: format=%d, compression=%d, unknown1=0x%X, unknown2=0x%X", format, compression, unknown1, unknown2));
                        break;
                    }
                    if (this.type == 0) break;
                    log.warn((Object)String.format("Unknown RCO FONT entry type 0x%X at offset 0x%X", this.type, entryOffset));
                    break;
                }
                case 3: {
                    if (this.type == 1) {
                        int lang = RCO.this.read16();
                        int format = RCO.this.read16();
                        int numIndexes = RCO.this.read32();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("RCO entry TEXT: lang=%d, format=%d, numIndexes=0x%X", lang, format, numIndexes));
                        }
                        this.texts = new String[numIndexes];
                        for (int i = 0; i < numIndexes; ++i) {
                            int labelOffset = RCO.this.read32();
                            int length = RCO.this.read32();
                            int offset = RCO.this.read32();
                            this.texts[i] = RCO.this.readText(lang, offset, length);
                            if (!log.isDebugEnabled()) continue;
                            log.debug((Object)String.format("RCO entry TEXT Index#%d: labelOffset=%d, length=%d, offset=0x%X; '%s'", i, labelOffset, length, offset, this.texts[i]));
                        }
                        break;
                    }
                    if (this.type == 0) break;
                    log.warn((Object)String.format("Unknown RCO TEXT entry type 0x%X at offset 0x%X", this.type, entryOffset));
                    break;
                }
                default: {
                    log.warn((Object)String.format("Unknown RCO entry id 0x%X at offset 0x%X", this.id, entryOffset));
                }
            }
            if (this.numSubEntries > 0) {
                this.subEntries = new RCOEntry[this.numSubEntries];
                for (int i = 0; i < this.numSubEntries; ++i) {
                    this.subEntries[i] = new RCOEntry();
                    this.subEntries[i].read();
                }
            }
        }

        private String getIdName(int id) {
            String[] idNames = new String[]{null, "MAIN", "VSMX", "TEXT", "IMG", "MODEL", "SOUND", "FONT", "OBJ", "ANIM"};
            if (id < 0 || id >= idNames.length || idNames[id] == null) {
                return String.format("0x%X", id);
            }
            return idNames[id];
        }

        public String toString() {
            return String.format("RCOEntry[type=0x%X, id=%s, labelOffset=0x%X('%s'), eHeadSize=0x%X, entrySize=0x%X, numSubEntries=%d, nextEntryOffset=0x%X, prevEntryOffset=0x%X, parentTblOffset=0x%X", this.type, this.getIdName(this.id), this.labelOffset, this.label != null ? this.label : "", this.eHeadSize, this.entrySize, this.numSubEntries, this.nextEntryOffset, this.prevEntryOffset, this.parentTblOffset);
        }
    }
}

