/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.xmb;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.iso.UmdIsoVirtualFileSystem;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class XmbIsoVirtualFile
extends AbstractVirtualFile {
    private String umdFilename;
    private String umdName;
    protected long filePointer;
    protected long totalLength;
    protected static final String[] umdFilenames = new String[]{"PSP_GAME/PARAM.SFO", "PSP_GAME/ICON0.PNG", "PSP_GAME/ICON1.PMF", "PSP_GAME/PIC0.PNG", "PSP_GAME/PIC1.PNG", "PSP_GAME/SND0.AT3"};
    protected byte[] contents;
    protected PbpSection[] sections;

    public XmbIsoVirtualFile(String umdFilename) {
        super(null);
        boolean createCacheFiles;
        this.umdFilename = umdFilename;
        this.umdName = new File(umdFilename).getName();
        File cacheDirectory = new File(this.getCacheDirectory());
        boolean bl = createCacheFiles = !cacheDirectory.isDirectory();
        if (createCacheFiles) {
            cacheDirectory.mkdirs();
        }
        try {
            UmdIsoReader iso = new UmdIsoReader(umdFilename);
            UmdIsoVirtualFileSystem vfs = new UmdIsoVirtualFileSystem(iso);
            this.sections = new PbpSection[umdFilenames.length + 1];
            this.sections[0] = new PbpSection();
            this.sections[0].index = 0;
            this.sections[0].offset = 0;
            this.sections[0].size = 40;
            this.sections[0].availableInContents = true;
            int offset = 40;
            SceIoStat stat = new SceIoStat();
            for (int i = 0; i < umdFilenames.length; ++i) {
                IVirtualFile vFile;
                PbpSection section = new PbpSection();
                section.index = i + 1;
                section.offset = offset;
                section.umdFilename = umdFilenames[i];
                if (vfs.ioGetstat(section.umdFilename, stat) >= 0) {
                    section.size = (int)stat.size;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("%s: mapping %s at offset 0x%X, size 0x%X", umdFilename, umdFilenames[i], section.offset, section.size));
                    }
                }
                String cacheFileName = this.getCacheFileName(section);
                File cacheFile = new File(cacheFileName);
                if (createCacheFiles && i < 2 && (vFile = vfs.ioOpen(section.umdFilename, 1, 0)) != null) {
                    section.size = (int)vFile.length();
                    byte[] buffer = new byte[section.size];
                    int length = vFile.ioRead(buffer, 0, buffer.length);
                    vFile.ioClose();
                    FileOutputStream os = new FileOutputStream(cacheFile);
                    ((OutputStream)os).write(buffer, 0, length);
                    ((OutputStream)os).close();
                }
                if (cacheFile.canRead()) {
                    section.cacheFile = cacheFile;
                }
                this.sections[section.index] = section;
                offset += section.size;
            }
            this.totalLength = offset;
            this.contents = new byte[offset];
            ByteBuffer buffer = ByteBuffer.wrap(this.contents).order(ByteOrder.LITTLE_ENDIAN);
            buffer.putInt(1346523136);
            buffer.putInt(65536);
            for (int i = 1; i < this.sections.length; ++i) {
                buffer.putInt(this.sections[i].offset);
            }
            int endSectionOffset = this.sections[this.sections.length - 1].offset + this.sections[this.sections.length - 1].size;
            for (int i = this.sections.length; i <= 8; ++i) {
                buffer.putInt(endSectionOffset);
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("%s: PBP header :%s", umdFilename, Utilities.getMemoryDump(this.contents, this.sections[0].offset, this.sections[0].size)));
            }
            vfs.ioExit();
        }
        catch (FileNotFoundException e) {
            log.debug((Object)"XmbIsoVirtualFile", (Throwable)e);
        }
        catch (IOException e) {
            log.debug((Object)"XmbIsoVirtualFile", (Throwable)e);
        }
    }

    protected String getCacheDirectory() {
        return String.format("%1$s%2$cUmdBrowserCache%2$c%3$s", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), this.umdName);
    }

    protected String getCacheFileName(PbpSection section) {
        return String.format("%s%c%s", this.getCacheDirectory(), Character.valueOf(File.separatorChar), section.umdFilename.substring(9));
    }

    protected void readSection(PbpSection section) {
        if (section.size > 0) {
            try {
                if (section.cacheFile != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("XmbIsoVirtualFile.readSection from Cache %s", section.cacheFile));
                    }
                    FileInputStream is = new FileInputStream(section.cacheFile);
                    ((InputStream)is).read(this.contents, section.offset, section.size);
                    ((InputStream)is).close();
                } else {
                    UmdIsoReader iso;
                    UmdIsoVirtualFileSystem vfs;
                    IVirtualFile vFile;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("XmbIsoVirtualFile.readSection from UMD %s", section.umdFilename));
                    }
                    if ((vFile = (vfs = new UmdIsoVirtualFileSystem(iso = new UmdIsoReader(this.umdFilename))).ioOpen(section.umdFilename, 1, 0)) != null) {
                        vFile.ioRead(this.contents, section.offset, section.size);
                        vFile.ioClose();
                    }
                    vfs.ioExit();
                }
            }
            catch (IOException e) {
                log.debug((Object)"readSection", (Throwable)e);
            }
            if (section.index == 1) {
                int offset = section.offset;
                int keyTableOffset = Utilities.readUnaligned32(this.contents, offset + 8) + offset;
                int valueTableOffset = Utilities.readUnaligned32(this.contents, offset + 12) + offset;
                int numberKeys = Utilities.readUnaligned32(this.contents, offset + 16);
                for (int i = 0; i < numberKeys; ++i) {
                    int keyOffset = Utilities.readUnaligned16(this.contents, offset + 20 + i * 16);
                    String key = Utilities.readStringZ(this.contents, keyTableOffset + keyOffset);
                    if (!"CATEGORY".equals(key)) continue;
                    int valueOffset = Utilities.readUnaligned32(this.contents, offset + 20 + i * 16 + 12);
                    char valueFirstChar = (char)this.contents[valueTableOffset + valueOffset];
                    if (valueFirstChar != 'U') break;
                    this.contents[valueTableOffset + valueOffset] = 77;
                    break;
                }
            }
        }
        section.availableInContents = true;
    }

    protected int ioRead(PbpSection section, TPointer outputPointer, int offset, int length) {
        if (this.filePointer < (long)section.offset || this.filePointer >= (long)(section.offset + section.size)) {
            return 0;
        }
        if ((length = Math.min(length, section.size - (int)(this.filePointer - (long)section.offset))) > 0) {
            if (!section.availableInContents) {
                this.readSection(section);
            }
            outputPointer.setArray(offset, this.contents, (int)this.filePointer, length);
        }
        return length;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int length;
        int remaining = (int)Math.min((long)outputLength, (long)this.contents.length - this.filePointer);
        int offset = 0;
        for (int i = 0; remaining > 0 && i < this.sections.length; remaining -= length, ++i) {
            length = this.ioRead(this.sections[i], outputPointer, offset, remaining);
            this.filePointer += (long)length;
            offset += length;
        }
        return offset;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        return super.ioRead(outputBuffer, outputOffset, outputLength);
    }

    @Override
    public long length() {
        return this.totalLength;
    }

    @Override
    public long ioLseek(long offset) {
        this.filePointer = offset;
        return this.filePointer;
    }

    @Override
    public int ioClose() {
        this.filePointer = 0L;
        return 0;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.noDelayTimings;
    }

    public IVirtualFile ioReadForLoadExec() throws FileNotFoundException, IOException {
        UmdIsoReader iso = this.getIsoReader();
        UmdIsoVirtualFileSystem vfs = new UmdIsoVirtualFileSystem(iso);
        return vfs.ioOpen("PSP_GAME/SYSDIR/EBOOT.BIN", 1, 0);
    }

    public UmdIsoReader getIsoReader() throws FileNotFoundException, IOException {
        return new UmdIsoReader(this.umdFilename);
    }

    protected static class PbpSection {
        int index;
        int size;
        int offset;
        boolean availableInContents;
        String umdFilename;
        File cacheFile;

        protected PbpSection() {
        }
    }
}

