/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.RE.software.IRandomTextureAccess;
import jpcsp.memory.IMemoryReader;

public class RandomTextureAccessReader
implements IRandomTextureAccess {
    protected int width;
    protected int height;
    protected final int[] pixels;

    public RandomTextureAccessReader(IMemoryReader imageReader, int width, int height) {
        this.width = width;
        this.height = height;
        int length = width * height;
        this.pixels = new int[length];
        for (int i = 0; i < length; ++i) {
            this.pixels[i] = imageReader.readNext();
        }
    }

    @Override
    public int readPixel(int u, int v) {
        return this.pixels[v * this.width + u];
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }
}

