/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.network.protocols.NetPacket;

public class ARP {
    public static final int ARP_OPERATION_REQUEST = 1;
    public static final int ARP_OPERATION_REPLY = 2;
    private static final String[] ARP_OPERATION_NAMES = new String[]{null, "REQUEST", "REPLY"};
    public int hardwareType;
    public int protocolType;
    public int hardwareAddressLength;
    public int protocolAddressLength;
    public int operation;
    public pspNetMacAddress senderHardwareAddress;
    public byte[] senderProtocolAddress;
    public pspNetMacAddress targetHardwareAddress;
    public byte[] targetProtocolAddress;

    public void read(NetPacket packet) throws EOFException {
        this.hardwareType = packet.read16();
        this.protocolType = packet.read16();
        this.hardwareAddressLength = packet.read8();
        this.protocolAddressLength = packet.read8();
        this.operation = packet.read16();
        this.senderHardwareAddress = packet.readMacAddress(this.hardwareAddressLength);
        this.senderProtocolAddress = packet.readIpAddress(this.protocolAddressLength);
        this.targetHardwareAddress = packet.readMacAddress(this.hardwareAddressLength);
        this.targetProtocolAddress = packet.readIpAddress(this.protocolAddressLength);
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.write16(this.hardwareType);
        packet.write16(this.protocolType);
        packet.write8(this.hardwareAddressLength);
        packet.write8(this.protocolAddressLength);
        packet.write16(this.operation);
        packet.writeMacAddress(this.senderHardwareAddress, this.hardwareAddressLength);
        packet.writeIpAddress(this.senderProtocolAddress, this.protocolAddressLength);
        packet.writeMacAddress(this.targetHardwareAddress, this.hardwareAddressLength);
        packet.writeIpAddress(this.targetProtocolAddress, this.protocolAddressLength);
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(this.sizeOf()));
    }

    public int sizeOf() {
        return 8 + 2 * (this.hardwareAddressLength + this.protocolAddressLength);
    }

    public String toString() {
        return String.format("operation=%s, sender=%s/%s, target=%s/%s", ARP_OPERATION_NAMES[this.operation], this.senderHardwareAddress, NetPacket.getIpAddressString(this.senderProtocolAddress), this.targetHardwareAddress, NetPacket.getIpAddressString(this.targetProtocolAddress));
    }
}

