/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler.nativeCode;

import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.compiler.CodeInstruction;
import jpcsp.Allegrex.compiler.Compiler;
import jpcsp.Allegrex.compiler.CompilerContext;
import jpcsp.Allegrex.compiler.nativeCode.NativeCodeSequence;
import jpcsp.Memory;
import org.objectweb.asm.MethodVisitor;

public class NativeCodeInstruction
extends CodeInstruction {
    private NativeCodeSequence nativeCodeSequence;
    private int flags = 0;

    public NativeCodeInstruction(int address, NativeCodeSequence nativeCodeSequence) {
        this.nativeCodeSequence = nativeCodeSequence;
        this.address = address;
        this.init();
    }

    private void init() {
        if (this.nativeCodeSequence.hasBranchInstruction()) {
            this.flags |= 2;
            this.setBranching(true);
            int branchInstructionAddress = this.getAddress() + (this.nativeCodeSequence.getBranchInstruction() << 2);
            int branchOpcode = Memory.getInstance().read32(branchInstructionAddress);
            Common.Instruction branchInsn = Decoder.instruction(branchOpcode);
            int npc = branchInstructionAddress + 4;
            if (branchInsn.hasFlags(8)) {
                this.setBranchingTo(Compiler.branchTarget(npc, branchOpcode));
            } else if (branchInsn.hasFlags(16)) {
                this.setBranchingTo(Compiler.jumpTarget(npc, branchOpcode));
            } else {
                Compiler.log.error((Object)String.format("Incorrect Branch Instruction at 0x%08X - %s", branchInstructionAddress, branchInsn.disasm(branchInstructionAddress, branchOpcode)));
            }
        }
        if (this.nativeCodeSequence.isReturning()) {
            this.flags |= 2;
        }
    }

    public NativeCodeSequence getNativeCodeSequence() {
        return this.nativeCodeSequence;
    }

    @Override
    public boolean hasFlags(int testFlags) {
        return (this.flags & testFlags) == testFlags;
    }

    @Override
    public void compile(CompilerContext context, MethodVisitor mv) {
        this.startCompile(context, mv);
        context.compileNativeCodeSequence(this.nativeCodeSequence, this);
    }

    @Override
    public int getEndAddress() {
        return this.getAddress() + (this.nativeCodeSequence.getNumOpcodes() - 1 << 2);
    }

    @Override
    public int getLength() {
        return this.nativeCodeSequence.getNumOpcodes();
    }

    @Override
    public String toString() {
        return String.format("0x%X - %s", this.getAddress(), this.nativeCodeSequence.toString());
    }
}

