/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.objects;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jpcsp.format.rco.vsmx.INativeFunction;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import org.apache.log4j.Logger;

public class NativeFunctionFactory {
    private static final Logger log = VSMX.log;
    private static NativeFunctionFactory singleton;

    public static NativeFunctionFactory getInstance() {
        if (singleton == null) {
            singleton = new NativeFunctionFactory();
        }
        return singleton;
    }

    private NativeFunctionFactory() {
    }

    private INativeFunction getNativeFunctionInterface(Object object, String name, int numberOfArguments) {
        NativeFunction nativeFunction = null;
        for (int args = numberOfArguments + 1; args < 12; ++args) {
            Class[] arguments = new Class[args];
            for (int i = 0; i < arguments.length; ++i) {
                arguments[i] = VSMXBaseObject.class;
            }
            try {
                Method method = object.getClass().getMethod(name, arguments);
                nativeFunction = new NativeFunction(object, method, args - 1);
                break;
            }
            catch (SecurityException e) {
                log.error((Object)"getNativeFunction", (Throwable)e);
                continue;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        if (nativeFunction == null && log.isDebugEnabled()) {
            log.debug((Object)String.format("Not finding native function %s.%s(args=%d)", object, name, numberOfArguments + 1));
        }
        return nativeFunction;
    }

    public INativeFunction getNativeFunction(VSMXNativeObject object, String name, int numberOfArguments) {
        BaseNativeObject nativeObject = object.getObject();
        INativeFunction nativeFunction = this.getNativeFunctionInterface(nativeObject, name, numberOfArguments);
        return nativeFunction;
    }

    public INativeFunction getNativeFunction(VSMXBaseObject object, String name, int numberOfArguments) {
        INativeFunction nativeFunction = this.getNativeFunctionInterface(object, name, numberOfArguments);
        return nativeFunction;
    }

    private static class NativeFunction
    implements INativeFunction {
        private Method method;
        private Object object;
        private int args;

        public NativeFunction(Object object, Method method, int args) {
            this.object = object;
            this.method = method;
            this.args = args;
        }

        @Override
        public int getArgs() {
            return this.args;
        }

        @Override
        public VSMXBaseObject call(VSMXBaseObject[] arguments) {
            VSMXBaseObject returnValue = null;
            try {
                Object result = this.method.invoke(this.object, (Object[])arguments);
                if (result instanceof VSMXBaseObject) {
                    returnValue = (VSMXBaseObject)result;
                }
            }
            catch (IllegalArgumentException e) {
                log.error((Object)"call", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                log.error((Object)"call", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                log.error((Object)"call", (Throwable)e);
            }
            return returnValue;
        }
    }
}

