/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.eflash;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContextLLE;
import jpcsp.HLE.modules.sceEFlash;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerEFlash
extends MMIOHandlerBase {
    public static Logger log = sceEFlash.log;
    public static final int BASE_ADDRESS = -1114636288;
    private static MMIOHandlerEFlash instance;
    private static final int STATE_VERSION = 0;
    private int unknown14;
    private int unknown18;
    private int unknown24;
    private int unknown28;
    private int unknown34;
    private int unknown38;
    private int unknown40;
    private int interrupt;

    public static MMIOHandlerEFlash getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerEFlash(-1114636288);
        }
        return instance;
    }

    private MMIOHandlerEFlash(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.unknown14 = stream.readInt();
        this.unknown18 = stream.readInt();
        this.unknown24 = stream.readInt();
        this.unknown28 = stream.readInt();
        this.unknown34 = stream.readInt();
        this.unknown38 = stream.readInt();
        this.unknown40 = stream.readInt();
        this.interrupt = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.unknown14);
        stream.writeInt(this.unknown18);
        stream.writeInt(this.unknown24);
        stream.writeInt(this.unknown28);
        stream.writeInt(this.unknown34);
        stream.writeInt(this.unknown38);
        stream.writeInt(this.unknown40);
        stream.writeInt(this.interrupt);
        super.write(stream);
    }

    @Override
    public void reset() {
        this.unknown14 = 0;
        this.unknown18 = 0;
        this.unknown24 = 0;
        this.unknown28 = 0;
        this.unknown34 = 0;
        this.unknown38 = 0;
        this.unknown40 = 0;
        this.interrupt = 0;
        super.reset();
    }

    private void writeReset(int value) {
        if (value == 1) {
            this.reset();
        }
    }

    private void checkInterrupt() {
        if ((this.interrupt & 0xFFFF0000) != 0) {
            RuntimeContextLLE.triggerInterrupt(this.getProcessor(), 27);
        } else {
            RuntimeContextLLE.clearInterrupt(this.getProcessor(), 27);
        }
    }

    public void setInterruptFlag(int value) {
        this.interrupt = Utilities.setFlag(this.interrupt, value);
        this.checkInterrupt();
    }

    private void clearInterruptFlag(int value) {
        this.interrupt = Utilities.clearFlag(this.interrupt, value);
        this.checkInterrupt();
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 52: {
                value = this.unknown34;
                break;
            }
            case 68: {
                value = this.interrupt;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 4: {
                if (value == 0x4024002) break;
                super.write32(address, value);
                break;
            }
            case 16: {
                this.writeReset(value);
                break;
            }
            case 20: {
                this.unknown14 = value;
                break;
            }
            case 24: {
                this.unknown18 = value;
                break;
            }
            case 36: {
                this.unknown24 = value;
                break;
            }
            case 40: {
                this.unknown28 = value;
                break;
            }
            case 44: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 48: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 52: {
                this.unknown34 = value;
                break;
            }
            case 56: {
                this.unknown38 = value;
                break;
            }
            case 64: {
                this.unknown40 = value;
                break;
            }
            case 68: {
                this.clearInterruptFlag(value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

