/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Debugger;

import com.jidesoft.utils.SwingWorker;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import jpcsp.Allegrex.Common;
import jpcsp.Allegrex.Decoder;
import jpcsp.Allegrex.Instructions;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.Memory;
import jpcsp.WindowPropSaver;
import jpcsp.util.Utilities;

public class InstructionCounter
extends JFrame
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private Task task;
    private SceModule module;
    public static Instructions INSTRUCTIONS = new Instructions();
    private JTable OpcodeTable;
    private JTextArea areastatus;
    private JButton btnSave;
    private JButton btnStart;
    private JCheckBox finicheck;
    private JCheckBox initcheck;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblCountWhat;
    private JProgressBar progressBar;
    private JCheckBox stubtextcheck;
    private JCheckBox textcheck;

    public InstructionCounter() {
        this.initComponents();
        WindowPropSaver.loadWindowProperties(this);
    }

    public void setModule(SceModule module) {
        this.module = module;
        this.RefreshWindow();
    }

    public void RefreshWindow() {
        if (this.module == null) {
            return;
        }
        this.resetCounting();
        this.areastatus.setText("");
        if (this.module.text_addr == 0) {
            this.textcheck.setEnabled(false);
            this.textcheck.setSelected(false);
        } else {
            this.textcheck.setEnabled(true);
            this.textcheck.setSelected(true);
            this.areastatus.append("Found .text section at " + Integer.toHexString(this.module.text_addr) + " size " + this.module.text_size + "\n");
        }
        if (this.module.initsection[0] == 0) {
            this.initcheck.setEnabled(false);
            this.initcheck.setSelected(false);
        } else {
            this.initcheck.setEnabled(true);
            this.initcheck.setSelected(true);
            this.areastatus.append("Found .init section at " + Integer.toHexString(this.module.initsection[0]) + " size " + this.module.initsection[1] + "\n");
        }
        if (this.module.finisection[0] == 0) {
            this.finicheck.setEnabled(false);
            this.finicheck.setSelected(false);
        } else {
            this.finicheck.setEnabled(true);
            this.finicheck.setSelected(true);
            this.areastatus.append("Found .fini section at " + Integer.toHexString(this.module.finisection[0]) + " size " + this.module.finisection[1] + "\n");
        }
        if (this.module.stubtextsection[0] == 0) {
            this.stubtextcheck.setEnabled(false);
            this.stubtextcheck.setSelected(false);
        } else {
            this.stubtextcheck.setEnabled(true);
            this.stubtextcheck.setSelected(true);
            this.areastatus.append("Found .sceStub.text at " + Integer.toHexString(this.module.stubtextsection[0]) + " size " + this.module.stubtextsection[1]);
        }
        this.pack();
    }

    private void initComponents() {
        this.textcheck = new JCheckBox();
        this.initcheck = new JCheckBox();
        this.finicheck = new JCheckBox();
        this.lblCountWhat = new JLabel();
        this.progressBar = new JProgressBar();
        this.btnStart = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.areastatus = new JTextArea();
        this.jScrollPane2 = new JScrollPane();
        this.OpcodeTable = new JTable();
        this.stubtextcheck = new JCheckBox();
        this.btnSave = new JButton();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("InstructionCounter.title"));
        this.setResizable(false);
        this.textcheck.setText(".text");
        this.initcheck.setText(".init");
        this.finicheck.setText(".fini");
        this.lblCountWhat.setText(bundle.getString("InstructionCounter.lblCountWhat.text"));
        this.btnStart.setText(bundle.getString("InstructionCounter.btnStart.text"));
        this.btnStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstructionCounter.this.btnStartActionPerformed(evt);
            }
        });
        this.areastatus.setColumns(20);
        this.areastatus.setFont(new Font("Courier New", 0, 12));
        this.areastatus.setRows(4);
        this.jScrollPane1.setViewportView(this.areastatus);
        this.OpcodeTable.setAutoCreateRowSorter(true);
        this.OpcodeTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Opcode", "Category", "Count"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, Integer.class};
                this.canEdit = new boolean[]{false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.OpcodeTable.setSelectionMode(0);
        this.jScrollPane2.setViewportView(this.OpcodeTable);
        this.stubtextcheck.setText(".sceStub.text");
        this.btnSave.setText(bundle.getString("InstructionCounter.btnSave.text"));
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstructionCounter.this.btnSaveActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.btnStart).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE)).addComponent(this.jScrollPane1).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnSave)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lblCountWhat, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createSequentialGroup().addComponent(this.textcheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.initcheck).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.finicheck)).addComponent(this.stubtextcheck, -1, -1, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.finicheck).addComponent(this.initcheck).addComponent(this.textcheck).addComponent(this.lblCountWhat)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stubtextcheck).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.progressBar, -1, -1, Short.MAX_VALUE).addComponent(this.btnStart, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 59, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -2, 402, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnSave).addContainerGap()));
        this.pack();
    }

    private void btnStartActionPerformed(ActionEvent evt) {
        this.btnStart.setEnabled(false);
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.progressBar.setIndeterminate(true);
        this.task = new Task();
        this.task.addPropertyChangeListener(this);
        this.task.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void btnSaveActionPerformed(ActionEvent evt) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle(ResourceBundle.getBundle("jpcsp/languages/jpcsp").getString("InstructionCounter.strSaveInstructionDialog.text"));
        fc.setCurrentDirectory(new File("."));
        fc.setSelectedFile(new File("instructionoutput.txt"));
        int returnvalue = fc.showSaveDialog(this);
        if (returnvalue != 0) {
            return;
        }
        File file = fc.getSelectedFile();
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(file));
            for (int i = 0; i < this.OpcodeTable.getRowCount(); ++i) {
                bufferedWriter.write(this.OpcodeTable.getValueAt(i, 0) + "\t" + this.OpcodeTable.getValueAt(i, 1) + "\t" + this.OpcodeTable.getValueAt(i, 2));
                bufferedWriter.newLine();
            }
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
            Utilities.close(bufferedWriter);
        }
        catch (IOException ex2) {
            ex2.printStackTrace();
            {
                catch (Throwable throwable) {
                    Utilities.close(bufferedWriter);
                    throw throwable;
                }
            }
            Utilities.close(bufferedWriter);
        }
        Utilities.close(bufferedWriter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("progress")) {
            int progress = (Integer)evt.getNewValue();
            this.progressBar.setValue(progress);
        }
    }

    public void findinitsections() {
        for (int i = 0; i < this.module.initsection[1]; i += 4) {
            int memread32 = Memory.getInstance().read32(this.module.initsection[0] + i);
            Decoder.instruction(memread32).increaseCount();
        }
    }

    public void findfinisections() {
        for (int i = 0; i < this.module.finisection[1]; i += 4) {
            int memread32 = Memory.getInstance().read32(this.module.finisection[0] + i);
            Decoder.instruction(memread32).increaseCount();
        }
    }

    public void findtextsections() {
        for (int i = 0; i < this.module.text_size; i += 4) {
            int memread32 = Memory.getInstance().read32(this.module.text_addr + i);
            Decoder.instruction(memread32).increaseCount();
        }
    }

    public void findstubtextsections() {
        for (int i = 0; i < this.module.stubtextsection[1]; i += 4) {
            int memread32 = Memory.getInstance().read32(this.module.stubtextsection[0] + i);
            Decoder.instruction(memread32).increaseCount();
        }
    }

    public void refreshCounter() {
        TreeMap<String, Common.Instruction> instructions = new TreeMap<String, Common.Instruction>();
        for (Common.Instruction insn : Common.instructions()) {
            if (insn == null) continue;
            instructions.put(insn.name(), insn);
        }
        for (Common.Instruction insn : instructions.values()) {
            if (insn == null || insn.getCount() <= 0) continue;
            ((DefaultTableModel)this.OpcodeTable.getModel()).addRow(new Object[]{insn.name(), insn.category(), new Integer(insn.getCount())});
        }
    }

    public void resetCounting() {
        for (Common.Instruction insn : Common.instructions()) {
            if (insn == null) continue;
            insn.resetCount();
        }
        ((DefaultTableModel)this.OpcodeTable.getModel()).setRowCount(0);
    }

    @Override
    public void dispose() {
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    class Task
    extends SwingWorker<Void, Void> {
        Task() {
        }

        public Void doInBackground() {
            this.setProgress(0);
            InstructionCounter.this.resetCounting();
            this.setProgress(20);
            if (InstructionCounter.this.initcheck.isSelected()) {
                InstructionCounter.this.findinitsections();
            }
            this.setProgress(40);
            if (InstructionCounter.this.textcheck.isSelected()) {
                InstructionCounter.this.findtextsections();
            }
            this.setProgress(60);
            if (InstructionCounter.this.finicheck.isSelected()) {
                InstructionCounter.this.findfinisections();
            }
            this.setProgress(80);
            if (InstructionCounter.this.stubtextcheck.isSelected()) {
                InstructionCounter.this.findstubtextsections();
            }
            this.setProgress(100);
            return null;
        }

        public void done() {
            InstructionCounter.this.refreshCounter();
            Toolkit.getDefaultToolkit().beep();
            InstructionCounter.this.btnStart.setEnabled(true);
            InstructionCounter.this.setCursor(null);
            InstructionCounter.this.progressBar.setIndeterminate(false);
        }
    }
}

