/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.util.BytesPacket;

public class NetPacket
extends BytesPacket {
    public NetPacket(int length) {
        super(length);
        this.setBigEndian();
    }

    public NetPacket(byte[] buffer) {
        super(buffer);
        this.setBigEndian();
    }

    public NetPacket(byte[] buffer, int length) {
        super(buffer, length);
        this.setBigEndian();
    }

    public NetPacket(byte[] buffer, int offset, int length) {
        super(buffer, offset, length);
        this.setBigEndian();
    }

    public pspNetMacAddress readMacAddress() throws EOFException {
        return this.readMacAddress(6);
    }

    public pspNetMacAddress readMacAddress(int length) throws EOFException {
        pspNetMacAddress macAddress = new pspNetMacAddress();
        this.readBytes(macAddress.macAddress, 0, Math.min(length, 6));
        this.skip8(length - 6);
        return macAddress;
    }

    public byte[] readIpAddress() throws EOFException {
        return this.readIpAddress(4);
    }

    public byte[] readIpAddress(int length) throws EOFException {
        return this.readBytes(new byte[length]);
    }

    public String readDnsNameNotation() throws EOFException {
        int numberBytes;
        StringBuilder name = new StringBuilder();
        while ((numberBytes = this.read8()) != 0) {
            if (name.length() > 0) {
                name.append('.');
            }
            for (int i = 0; i < numberBytes; ++i) {
                name.append(this.readAsciiChar());
            }
        }
        return name.toString();
    }

    public String readLine() throws EOFException {
        StringBuilder line = new StringBuilder();
        while (true) {
            char c;
            if ((c = this.readAsciiChar()) == '\r') {
                char c2 = this.readAsciiChar();
                if (c2 == '\n') break;
                line.append(c);
                line.append(c2);
                continue;
            }
            line.append(c);
        }
        return line.toString();
    }

    public void writeDnsNameNotation(String name) throws EOFException {
        String[] parts;
        if (name != null && name.length() > 0 && (parts = name.split("\\.")) != null && parts.length > 0) {
            for (String part : parts) {
                int length = part.length();
                if (length <= 0) continue;
                this.write8(length);
                for (int i = 0; i < length; ++i) {
                    this.writeAsciiChar(part.charAt(i));
                }
            }
        }
        this.write8(0);
    }

    public void writeMacAddress(pspNetMacAddress macAddress) throws EOFException {
        this.writeMacAddress(macAddress, 6);
    }

    public void writeMacAddress(pspNetMacAddress macAddress, int length) throws EOFException {
        this.writeBytes(macAddress.macAddress, 0, Math.min(length, 6));
        this.skip8(length - 6);
    }

    public void writeIpAddress(byte[] ip) throws EOFException {
        this.writeIpAddress(ip, 4);
    }

    public void writeIpAddress(byte[] ip, int length) throws EOFException {
        this.writeBytes(ip, 0, length);
    }

    public static String getIpAddressString(byte[] ip) {
        return String.format("%d.%d.%d.%d", ip[0] & 0xFF, ip[1] & 0xFF, ip[2] & 0xFF, ip[3] & 0xFF);
    }
}

