/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.AVFrame;
import com.twilight.h264.decoder.AVPacket;
import com.twilight.h264.decoder.AVRational;
import com.twilight.h264.decoder.CABACContext;
import com.twilight.h264.decoder.CAVLCContext;
import com.twilight.h264.decoder.DSPContext;
import com.twilight.h264.decoder.ErrorResilience;
import com.twilight.h264.decoder.GetBitContext;
import com.twilight.h264.decoder.H264DSPContext;
import com.twilight.h264.decoder.H264Data;
import com.twilight.h264.decoder.H264PredictionContext;
import com.twilight.h264.decoder.ImageUtils;
import com.twilight.h264.decoder.LoopFilter;
import com.twilight.h264.decoder.MMCO;
import com.twilight.h264.decoder.MpegEncContext;
import com.twilight.h264.decoder.PictureParameterSet;
import com.twilight.h264.decoder.Rectangle;
import com.twilight.h264.decoder.SEIDecoder;
import com.twilight.h264.decoder.SequenceParameterSet;
import com.twilight.h264.util.Arrays;

public class H264Context {
    public static final int DELAYED_PIC_REF = 4;
    public static final int[] sei_num_clock_ts_table = new int[]{1, 1, 1, 2, 2, 3, 3, 2, 3};
    public static final int SEI_BUFFERING_PERIOD = 0;
    public static final int SEI_TYPE_PIC_TIMING = 1;
    public static final int SEI_TYPE_USER_DATA_UNREGISTERED = 5;
    public static final int SEI_TYPE_RECOVERY_POINT = 6;
    public static final int NAL_SLICE = 1;
    public static final int NAL_DPA = 2;
    public static final int NAL_DPB = 3;
    public static final int NAL_DPC = 4;
    public static final int NAL_IDR_SLICE = 5;
    public static final int NAL_SEI = 6;
    public static final int NAL_SPS = 7;
    public static final int NAL_PPS = 8;
    public static final int NAL_AUD = 9;
    public static final int NAL_END_SEQUENCE = 10;
    public static final int NAL_END_STREAM = 11;
    public static final int NAL_FILLER_DATA = 12;
    public static final int NAL_SPS_EXT = 13;
    public static final int NAL_AUXILIARY_SLICE = 19;
    public static final int NAL_FUA = 28;
    public static final int NAL_FUB = 29;
    public static final int FF_I_TYPE = 1;
    public static final int FF_P_TYPE = 2;
    public static final int FF_B_TYPE = 3;
    public static final int FF_S_TYPE = 4;
    public static final int FF_SI_TYPE = 5;
    public static final int FF_SP_TYPE = 6;
    public static final int FF_BI_TYPE = 7;
    public static final int LUMA_DC_BLOCK_INDEX = 24;
    public static final int CHROMA_DC_BLOCK_INDEX = 25;
    public static final int CHROMA_DC_COEFF_TOKEN_VLC_BITS = 8;
    public static final int COEFF_TOKEN_VLC_BITS = 8;
    public static final int TOTAL_ZEROS_VLC_BITS = 9;
    public static final int CHROMA_DC_TOTAL_ZEROS_VLC_BITS = 3;
    public static final int RUN_VLC_BITS = 3;
    public static final int RUN7_VLC_BITS = 6;
    public static final int MAX_SPS_COUNT = 32;
    public static final int MAX_PPS_COUNT = 256;
    public static final int MAX_SLICES = 16;
    public static final int MAX_DELAYED_PIC_COUNT = 16;
    public static final int MAX_MMCO_COUNT = 66;
    public static final int MAX_THREADS = 1;
    public static final int SEI_PIC_STRUCT_FRAME = 0;
    public static final int SEI_PIC_STRUCT_TOP_FIELD = 1;
    public static final int SEI_PIC_STRUCT_BOTTOM_FIELD = 2;
    public static final int SEI_PIC_STRUCT_TOP_BOTTOM = 3;
    public static final int SEI_PIC_STRUCT_BOTTOM_TOP = 4;
    public static final int SEI_PIC_STRUCT_TOP_BOTTOM_TOP = 5;
    public static final int SEI_PIC_STRUCT_BOTTOM_TOP_BOTTOM = 6;
    public static final int SEI_PIC_STRUCT_FRAME_DOUBLING = 7;
    public static final int SEI_PIC_STRUCT_FRAME_TRIPLING = 8;
    public static final int MB_TYPE_INTRA4x4 = 1;
    public static final int MB_TYPE_INTRA16x16 = 2;
    public static final int MB_TYPE_INTRA_PCM = 4;
    public static final int MB_TYPE_16x16 = 8;
    public static final int MB_TYPE_16x8 = 16;
    public static final int MB_TYPE_8x16 = 32;
    public static final int MB_TYPE_8x8 = 64;
    public static final int MB_TYPE_INTERLACED = 128;
    public static final int MB_TYPE_DIRECT2 = 256;
    public static final int MB_TYPE_ACPRED = 512;
    public static final int MB_TYPE_GMC = 1024;
    public static final int MB_TYPE_SKIP = 2048;
    public static final int MB_TYPE_P0L0 = 4096;
    public static final int MB_TYPE_P1L0 = 8192;
    public static final int MB_TYPE_P0L1 = 16384;
    public static final int MB_TYPE_P1L1 = 32768;
    public static final int MB_TYPE_L0 = 12288;
    public static final int MB_TYPE_L1 = 49152;
    public static final int MB_TYPE_L0L1 = 61440;
    public static final int MB_TYPE_QUANT = 65536;
    public static final int MB_TYPE_CBP = 131072;
    public static final int[] rem6 = new int[]{0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3, 4, 5, 0, 1, 2, 3};
    public static final int[] div6 = new int[]{0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 5, 5, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7, 7, 7, 8, 8, 8, 8};
    public static final int EXTENDED_SAR = 255;
    public static final int MB_TYPE_REF0 = 512;
    public static final int MB_TYPE_8x8DCT = 0x1000000;
    public static final int LIST_NOT_USED = -1;
    public static final int PART_NOT_AVAILABLE = -2;
    public MpegEncContext s;
    public H264DSPContext h264dsp = new H264DSPContext();
    public CAVLCContext cavlc = new CAVLCContext();
    public int[] chroma_qp = new int[2];
    public int qp_thresh;
    public int prev_mb_skipped;
    public int next_mb_skipped;
    public int chroma_pred_mode;
    public int intra16x16_pred_mode;
    public int topleft_mb_xy;
    public int top_mb_xy;
    public int topright_mb_xy;
    public int[] left_mb_xy = new int[2];
    public int topleft_type;
    public int top_type;
    public int topright_type;
    public int[] left_type = new int[2];
    public int[] left_block;
    public int topleft_partition;
    public int[] intra4x4_pred_mode_cache = new int[40];
    public int[] intra4x4_pred_mode;
    public H264PredictionContext hpc = new H264PredictionContext();
    public long topleft_samples_available;
    public long top_samples_available;
    public long topright_samples_available;
    public long left_samples_available;
    public int[][][] top_borders = new int[2][][];
    public static final int[] hwaccel_pixfmt_list_h264_jpeg_420 = new int[]{62, 54, 13, -1};
    public int[] non_zero_count_cache = new int[48];
    public int[][] non_zero_count;
    public int[][][] mv_cache = new int[2][40][2];
    public int[][] ref_cache = new int[2][40];
    public int[] mv_cache_clean = new int[2];
    public int neighbor_transform_size;
    public int[] block_offset = new int[48];
    public long[] mb2b_xy;
    public long[] mb2br_xy;
    public int b_stride;
    public int mb_linesize;
    public int mb_uvlinesize;
    public int emu_edge_width;
    public int emu_edge_height;
    public SequenceParameterSet sps = new SequenceParameterSet();
    public PictureParameterSet pps = new PictureParameterSet();
    public long[][][] dequant4_buffer = new long[6][52][16];
    public long[][][] dequant8_buffer = new long[2][52][64];
    public long[][][] dequant4_coeff = new long[16][][];
    public long[][][] dequant8_coeff = new long[64][][];
    public int slice_num;
    public int[] slice_table_base;
    public int slice_table_offset;
    public int slice_type;
    public int slice_type_nos;
    public int slice_type_fixed;
    public int mb_aff_frame;
    public int mb_field_decoding_flag;
    public int mb_mbaff;
    public int[] sub_mb_type = new int[4];
    public int use_weight;
    public int use_weight_chroma;
    public int luma_log2_weight_denom;
    public int chroma_log2_weight_denom;
    public int[][][] luma_weight = new int[48][2][2];
    public int[][][][] chroma_weight = new int[48][2][2][2];
    public int[][][] implicit_weight = new int[48][48][2];
    public int direct_spatial_mv_pred;
    public int col_parity;
    public int col_fieldoff;
    public int[] dist_scale_factor = new int[16];
    public int[][] dist_scale_factor_field = new int[2][32];
    public int[][] map_col_to_list0 = new int[2][48];
    public int[][][] map_col_to_list0_field = new int[2][2][48];
    public long[] ref_count = new long[2];
    public long list_count;
    public int[] list_counts;
    public AVFrame[][] ref_list = new AVFrame[2][48];
    public int[][][] ref2frm = new int[16][2][64];
    public GetBitContext intra_gb;
    public GetBitContext inter_gb;
    public GetBitContext intra_gb_ptr;
    public GetBitContext inter_gb_ptr;
    public short[] mb = new short[384];
    public short[] mb_luma_dc = new short[16];
    public short[][] mb_chroma_dc = new short[2][4];
    public short[] mb_padding = new short[256];
    public CABACContext cabac = new CABACContext();
    public int[] cabac_state = new int[460];
    public int[] cbp_table;
    public int cbp;
    public int top_cbp;
    public int left_cbp;
    public int[] chroma_pred_mode_table;
    public int last_qscale_diff;
    public int[][][] mvd_table = new int[2][][];
    public int[][][] mvd_cache = new int[2][40][2];
    public int[] direct_table;
    public int[] direct_cache = new int[40];
    public int[] zigzag_scan = new int[16];
    public int[] zigzag_scan8x8 = new int[64];
    public int[] zigzag_scan8x8_cavlc = new int[64];
    public int[] field_scan = new int[16];
    public int[] field_scan8x8 = new int[64];
    public int[] field_scan8x8_cavlc = new int[64];
    public int[] zigzag_scan_q0;
    public int[] zigzag_scan8x8_q0;
    public int[] zigzag_scan8x8_cavlc_q0;
    public int[] field_scan_q0;
    public int[] field_scan8x8_q0;
    public int[] field_scan8x8_cavlc_q0;
    public int x264_build;
    public int mb_xy;
    public int is_complex;
    public int deblocking_filter;
    public int slice_alpha_c0_offset;
    public int slice_beta_offset;
    public int nal_ref_idc;
    public int nal_unit_type;
    public int[][] rbsp_buffer = new int[2][];
    public long[] rbsp_buffer_size = new long[2];
    public int is_avc;
    public int nal_length_size;
    public int got_first;
    public SequenceParameterSet[] sps_buffers = new SequenceParameterSet[32];
    public PictureParameterSet[] pps_buffers = new PictureParameterSet[256];
    public int dequant_coeff_pps;
    public int poc_lsb;
    public int poc_msb;
    public int delta_poc_bottom;
    public int[] delta_poc = new int[2];
    public int frame_num;
    public int prev_poc_msb;
    public int prev_poc_lsb;
    public int frame_num_offset;
    public int prev_frame_num_offset;
    public int prev_frame_num;
    public int curr_pic_num;
    public int max_pic_num;
    public int redundant_pic_count;
    public AVFrame[] short_ref = new AVFrame[32];
    public AVFrame[] long_ref = new AVFrame[32];
    public AVFrame[][] default_ref_list = new AVFrame[2][32];
    public AVFrame[] delayed_pic = new AVFrame[18];
    public int outputed_poc;
    public MMCO[] mmco = new MMCO[66];
    public int mmco_index;
    public int long_ref_count;
    public int short_ref_count;
    public int cabac_init_idc;
    public H264Context[] thread_context = new H264Context[1];
    public int current_slice;
    public int max_contexts;
    public int single_decode_warning;
    public int last_slice_type;
    public int sei_pic_struct;
    public int prev_interlaced_frame;
    public int sei_ct_type;
    public int sei_dpb_output_delay;
    public int sei_cpb_removal_delay;
    public int sei_recovery_frame_cnt;
    public int[] luma_weight_flag = new int[2];
    public int[] chroma_weight_flag = new int[2];
    public int sei_buffering_period_present;
    public int[] initial_cpb_removal_delay = new int[32];
    public int halfpel_flag;
    public int thirdpel_flag;
    public int unknown_svq3_flag;
    public int next_slice_index;
    public long svq3_watermark_key;
    public static final int[] ff_alternate_horizontal_scan = new int[]{0, 1, 2, 3, 8, 9, 16, 17, 10, 11, 4, 5, 6, 7, 15, 14, 13, 12, 19, 18, 24, 25, 32, 33, 26, 27, 20, 21, 22, 23, 28, 29, 30, 31, 34, 35, 40, 41, 48, 49, 42, 43, 36, 37, 38, 39, 44, 45, 46, 47, 50, 51, 56, 57, 58, 59, 52, 53, 54, 55, 60, 61, 62, 63};
    public static final int[] ff_alternate_vertical_scan = new int[]{0, 8, 16, 24, 1, 9, 2, 10, 17, 25, 32, 40, 48, 56, 57, 49, 41, 33, 26, 18, 3, 11, 4, 12, 19, 27, 34, 42, 50, 58, 35, 43, 51, 59, 20, 28, 5, 13, 6, 14, 21, 29, 36, 44, 52, 60, 37, 45, 53, 61, 22, 30, 7, 15, 23, 31, 38, 46, 54, 62, 39, 47, 55, 63};
    public static final short[] scan8 = new short[]{12, 13, 20, 21, 14, 15, 22, 23, 28, 29, 36, 37, 30, 31, 38, 39, 9, 10, 17, 18, 33, 34, 41, 42, 44, 45, 46};
    public static final AVRational[] pixel_aspect = new AVRational[]{new AVRational(0, 1), new AVRational(1, 1), new AVRational(12, 11), new AVRational(10, 11), new AVRational(16, 11), new AVRational(40, 33), new AVRational(24, 11), new AVRational(20, 11), new AVRational(32, 11), new AVRational(80, 33), new AVRational(18, 11), new AVRational(15, 11), new AVRational(64, 33), new AVRational(160, 99), new AVRational(4, 3), new AVRational(3, 2), new AVRational(2, 1)};
    public static final int[][] default_scaling4 = new int[][]{{6, 13, 20, 28, 13, 20, 28, 32, 20, 28, 32, 37, 28, 32, 37, 42}, {10, 14, 20, 24, 14, 20, 24, 27, 20, 24, 27, 30, 24, 27, 30, 34}};
    public static final int[][] default_scaling8 = new int[][]{{6, 10, 13, 16, 18, 23, 25, 27, 10, 11, 16, 18, 23, 25, 27, 29, 13, 16, 18, 23, 25, 27, 29, 31, 16, 18, 23, 25, 27, 29, 31, 33, 18, 23, 25, 27, 29, 31, 33, 36, 23, 25, 27, 29, 31, 33, 36, 38, 25, 27, 29, 31, 33, 36, 38, 40, 27, 29, 31, 33, 36, 38, 40, 42}, {9, 13, 15, 17, 19, 21, 22, 24, 13, 13, 17, 19, 21, 22, 24, 25, 15, 17, 19, 21, 22, 24, 25, 27, 17, 19, 21, 22, 24, 25, 27, 28, 19, 21, 22, 24, 25, 27, 28, 30, 21, 22, 24, 25, 27, 28, 30, 32, 22, 24, 25, 27, 28, 30, 32, 33, 24, 25, 27, 28, 30, 32, 33, 35}};
    public static final int[] ff_zigzag_direct = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56, 57, 50, 43, 36, 29, 22, 15, 23, 30, 37, 44, 51, 58, 59, 52, 45, 38, 31, 39, 46, 53, 60, 61, 54, 47, 55, 62, 63};
    public static final int[] ff_h264_chroma_qp = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 29, 30, 31, 32, 32, 33, 34, 34, 35, 35, 36, 36, 37, 37, 37, 38, 38, 38, 39, 39, 39, 39};
    public AVFrame displayPicture = new AVFrame();
    public static final short[] last_coeff_flag_offset_8x8 = new short[]{0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 3, 3, 3, 3, 3, 3, 3, 3, 4, 4, 4, 4, 4, 4, 4, 4, 5, 5, 5, 5, 6, 6, 6, 6, 7, 7, 7, 7, 8, 8, 8};
    static final int[][] significant_coeff_flag_offset = new int[][]{{105, 120, 134, 149, 152, 402}, {277, 292, 306, 321, 324, 436}};
    static final int[][] last_coeff_flag_offset = new int[][]{{166, 181, 195, 210, 213, 417}, {338, 353, 367, 382, 385, 451}};
    static final int[] coeff_abs_level_m1_offset = new int[]{227, 237, 247, 257, 266, 426};
    static final short[][] significant_coeff_flag_offset_8x8 = new short[][]{{0, 1, 2, 3, 4, 5, 5, 4, 4, 3, 3, 4, 4, 4, 5, 5, 4, 4, 4, 4, 3, 3, 6, 7, 7, 7, 8, 9, 10, 9, 8, 7, 7, 6, 11, 12, 13, 11, 6, 7, 8, 9, 14, 10, 9, 8, 6, 11, 12, 13, 11, 6, 9, 14, 10, 9, 11, 12, 13, 11, 14, 10, 12}, {0, 1, 1, 2, 2, 3, 3, 4, 5, 6, 7, 7, 7, 8, 4, 5, 6, 9, 10, 10, 8, 11, 12, 11, 9, 9, 10, 10, 8, 11, 12, 11, 9, 9, 10, 10, 8, 11, 12, 11, 9, 9, 10, 10, 8, 13, 13, 9, 9, 10, 10, 8, 13, 13, 9, 9, 10, 10, 14, 14, 14, 14, 14}};
    static final short[] coeff_abs_level1_ctx = new short[]{1, 2, 3, 4, 0, 0, 0, 0};
    static final short[] coeff_abs_levelgt1_ctx = new short[]{5, 5, 5, 5, 6, 7, 8, 9};
    static final short[][] coeff_abs_level_transition = new short[][]{{1, 2, 3, 3, 4, 5, 6, 7}, {4, 4, 4, 4, 5, 6, 7, 7}};

    private void MAP_F2F_1(int idx, int mb_type, int list) {
        if (0 == (mb_type & 0x80) && this.ref_cache[list][idx] >= 0) {
            int[] nArray = this.ref_cache[list];
            int n = idx;
            nArray[n] = nArray[n] << 1;
            int[] nArray2 = this.mv_cache[list][idx];
            nArray2[1] = nArray2[1] / 2;
            int[] nArray3 = this.mvd_cache[list][idx];
            nArray3[1] = nArray3[1] >> 1;
        }
    }

    private void MAP_F2F_2(int idx, int mb_type, int list) {
        if (0 != (mb_type & 0x80) && this.ref_cache[list][idx] >= 0) {
            int[] nArray = this.ref_cache[list];
            int n = idx;
            nArray[n] = nArray[n] >> 1;
            int[] nArray2 = this.mv_cache[list][idx];
            nArray2[1] = nArray2[1] << 1;
            int[] nArray3 = this.mvd_cache[list][idx];
            nArray3[1] = nArray3[1] << 1;
        }
    }

    public static int pack16to32(int a, int b) {
        return (a & 0xFFFF) + ((b & 0xFFFF) << 16);
    }

    public static int pack8to16(int a, int b) {
        return (a & 0xFF) + ((b & 0xFF) << 8);
    }

    private static int mid_pred(int a, int b, int c) {
        if (a > b) {
            if (c > b) {
                b = c > a ? a : c;
            }
        } else if (b > c) {
            b = c > a ? c : a;
        }
        return b;
    }

    public int pred_spatial_direct_motion(int mb_type) {
        int y8;
        int x8;
        int n;
        int b8_stride = 2;
        int b4_stride = this.b_stride;
        int mb_xy = this.mb_xy;
        int[] mb_type_col = new int[2];
        int is_b8x8 = (mb_type & 0x40) != 0 ? 1 : 0;
        int sub_mb_type = 61440;
        int[] ref = new int[2];
        int[] mv = new int[2];
        int MB_TYPE_16x16_OR_INTRA = 15;
        for (int list = 0; list < 2; ++list) {
            int left_ref = this.ref_cache[list][scan8[0] - 1];
            int top_ref = this.ref_cache[list][scan8[0] - 8];
            int refc = this.ref_cache[list][scan8[0] - 8 + 4];
            int[] C = this.mv_cache[list][scan8[0] - 8 + 4];
            if (refc == -2) {
                refc = this.ref_cache[list][scan8[0] - 8 - 1];
                C = this.mv_cache[list][scan8[0] - 8 - 1];
            }
            ref[list] = Math.min(left_ref, Math.min(top_ref, refc));
            if (ref[list] >= 0) {
                int[] A = this.mv_cache[list][scan8[0] - 1];
                int[] B = this.mv_cache[list][scan8[0] - 8];
                int match_count = (left_ref == ref[list] ? 1 : 0) + (top_ref == ref[list] ? 1 : 0) + (refc == ref[list] ? 1 : 0);
                if (match_count > 1) {
                    mv[list] = H264Context.pack16to32(H264Context.mid_pred(A[0], B[0], C[0]), H264Context.mid_pred(A[1], B[1], C[1]));
                    continue;
                }
                if (left_ref == ref[list]) {
                    mv[list] = (A[1] & 0xFFFF) << 16 | A[0] & 0xFFFF;
                    continue;
                }
                if (top_ref == ref[list]) {
                    mv[list] = (B[1] & 0xFFFF) << 16 | B[0] & 0xFFFF;
                    continue;
                }
                mv[list] = (C[1] & 0xFFFF) << 16 | C[0] & 0xFFFF;
                continue;
            }
            int mask = ~(12288 << 2 * list);
            mv[list] = 0;
            ref[list] = -1;
            if (is_b8x8 == 0) {
                mb_type &= mask;
            }
            sub_mb_type &= mask;
        }
        if (ref[0] < 0 && ref[1] < 0) {
            ref[1] = 0;
            ref[0] = 0;
            if (is_b8x8 == 0) {
                mb_type |= 0xF000;
            }
            sub_mb_type |= 0xF000;
        }
        if (0 == (is_b8x8 | mv[0] | mv[1])) {
            Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[0], 4, 4, 8, ref[0], 1);
            Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[0], 4, 4, 8, ref[1], 1);
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[0], 4, 4, 8, 0, 4);
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[0], 4, 4, 8, 0, 4);
            mb_type = mb_type & 0xFFFF5F8F | 8 | 0x100;
            return mb_type;
        }
        if (0L != (this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy] & 0x80L)) {
            if (0 == (mb_type & 0x80)) {
                mb_xy = this.s.mb_x + ((this.s.mb_y & 0xFFFFFFFE) + this.col_parity) * this.s.mb_stride;
                b8_stride = 0;
            } else {
                mb_xy += this.col_fieldoff;
            }
            mb_type_col[0] = mb_type_col[1] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy];
            sub_mb_type |= 0x108;
            if (0 == is_b8x8 && 0 != (mb_type_col[0] & MB_TYPE_16x16_OR_INTRA)) {
                mb_type |= 0x108;
            } else if (0 == is_b8x8 && 0 != (mb_type_col[0] & 0x30)) {
                mb_type |= 0x100 | mb_type_col[0] & 0x30;
            } else {
                if (0 == this.sps.direct_8x8_inference_flag) {
                    sub_mb_type += 56;
                }
                mb_type |= 0x40;
            }
        } else if (0 != (mb_type & 0x80)) {
            mb_xy = this.s.mb_x + (this.s.mb_y & 0xFFFFFFFE) * this.s.mb_stride;
            mb_type_col[0] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy];
            mb_type_col[1] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy + this.s.mb_stride];
            b8_stride = 2 + 4 * this.s.mb_stride;
            b4_stride *= 6;
            sub_mb_type |= 0x108;
            mb_type = 0 != (mb_type_col[0] & MB_TYPE_16x16_OR_INTRA) && 0 != (mb_type_col[1] & MB_TYPE_16x16_OR_INTRA) && 0 == is_b8x8 ? (mb_type |= 0x110) : (mb_type |= 0x40);
        } else {
            mb_type_col[0] = mb_type_col[1] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy];
            sub_mb_type |= 0x108;
            if (0 == is_b8x8 && 0 != (mb_type_col[0] & MB_TYPE_16x16_OR_INTRA)) {
                mb_type |= 0x108;
            } else if (0 == is_b8x8 && 0 != (mb_type_col[0] & 0x30)) {
                mb_type |= 0x100 | mb_type_col[0] & 0x30;
            } else {
                if (0 == this.sps.direct_8x8_inference_flag) {
                    sub_mb_type += 56;
                }
                mb_type |= 0x40;
            }
        }
        int[][] l1mv0_base = this.ref_list[1][0].motion_val_base[0];
        int[][] l1mv1_base = this.ref_list[1][0].motion_val_base[1];
        int l1mv0_offset = this.ref_list[1][0].motion_val_offset[0] + (int)this.mb2b_xy[mb_xy];
        int l1mv1_offset = this.ref_list[1][0].motion_val_offset[1] + (int)this.mb2b_xy[mb_xy];
        int[] l1ref0_base = this.ref_list[1][0].ref_index[0];
        int[] l1ref1_base = this.ref_list[1][0].ref_index[1];
        int l1ref0_offset = 4 * mb_xy;
        int l1ref1_offset = 4 * mb_xy;
        if (0 == b8_stride && 0 != (this.s.mb_y & 1)) {
            l1ref0_offset += 2;
            l1ref1_offset += 2;
            l1mv0_offset += 2 * b4_stride;
            l1mv1_offset += 2 * b4_stride;
        }
        if ((mb_type & 0x80) != (mb_type_col[0] & 0x80)) {
            n = 0;
            for (int i8 = 0; i8 < 4; ++i8) {
                int a;
                int b;
                x8 = i8 & 1;
                y8 = i8 >> 1;
                int xy8 = x8 + y8 * b8_stride;
                int xy4 = 3 * x8 + y8 * b4_stride;
                if (is_b8x8 != 0 && 0 == (this.sub_mb_type[i8] & 0x100)) continue;
                this.sub_mb_type[i8] = sub_mb_type;
                Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[i8 * 4], 2, 2, 8, ref[0], 1);
                Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[i8 * 4], 2, 2, 8, ref[1], 1);
                if (0 == (mb_type_col[y8] & 7) && 0 == this.ref_list[1][0].long_ref && (l1ref0_base[l1ref0_offset + xy8] == 0 && Math.abs(l1mv0_base[l1mv0_offset + xy4][0]) <= 1 && Math.abs(l1mv0_base[l1mv0_offset + xy4][1]) <= 1 || l1ref0_base[l1ref0_offset + xy8] < 0 && l1ref1_base[l1ref1_offset + xy8] == 0 && Math.abs(l1mv1_base[l1mv1_offset + xy4][0]) <= 1 && Math.abs(l1mv1_base[l1mv1_offset + xy4][1]) <= 1)) {
                    b = 0;
                    a = 0;
                    if (ref[0] > 0) {
                        a = mv[0];
                    }
                    if (ref[1] > 0) {
                        b = mv[1];
                    }
                    ++n;
                } else {
                    a = mv[0];
                    b = mv[1];
                }
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, a, 4);
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, b, 4);
            }
            if (0 == is_b8x8 && 0 == (n & 3)) {
                mb_type = mb_type & 0xFFFF5F8F | 8 | 0x100;
            }
        } else if (0 != (mb_type & 8)) {
            int a;
            int b;
            Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[0], 4, 4, 8, ref[0], 1);
            Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[0], 4, 4, 8, ref[1], 1);
            if (0 == (mb_type_col[0] & 7) && 0 == this.ref_list[1][0].long_ref && (l1ref0_base[l1ref0_offset + 0] == 0 && Math.abs(l1mv0_base[l1mv0_offset + 0][0]) <= 1 && Math.abs(l1mv0_base[l1mv0_offset + 0][1]) <= 1 || l1ref0_base[l1ref0_offset + 0] < 0 && l1ref1_base[l1ref1_offset + 0] == 0 && Math.abs(l1mv1_base[l1mv1_offset + 0][0]) <= 1 && Math.abs(l1mv1_base[l1mv1_offset + 0][1]) <= 1 && this.x264_build > 33)) {
                b = 0;
                a = 0;
                if (ref[0] > 0) {
                    a = mv[0];
                }
                if (ref[1] > 0) {
                    b = mv[1];
                }
            } else {
                a = mv[0];
                b = mv[1];
            }
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[0], 4, 4, 8, a, 4);
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[0], 4, 4, 8, b, 4);
        } else {
            n = 0;
            for (int i8 = 0; i8 < 4; ++i8) {
                int l1mv_offset;
                x8 = i8 & 1;
                y8 = i8 >> 1;
                if (is_b8x8 != 0 && 0 == (this.sub_mb_type[i8] & 0x100)) continue;
                this.sub_mb_type[i8] = sub_mb_type;
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, mv[0], 4);
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, mv[1], 4);
                Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[i8 * 4], 2, 2, 8, ref[0], 1);
                Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[i8 * 4], 2, 2, 8, ref[1], 1);
                if (0 != (mb_type_col[0] & 7) || 0 != this.ref_list[1][0].long_ref || l1ref0_base[l1ref0_offset + i8] != 0 && (l1ref0_base[l1ref0_offset + i8] >= 0 || l1ref1_base[l1ref1_offset + i8] != 0 || this.x264_build <= 33)) continue;
                int[][] l1mv_base = l1ref0_base[l1ref0_offset + i8] == 0 ? l1mv0_base : l1mv1_base;
                int n2 = l1mv_offset = l1ref0_base[l1ref0_offset + i8] == 0 ? l1mv0_offset : l1mv1_offset;
                if (0 != (sub_mb_type & 8)) {
                    int[] mv_col = l1mv_base[l1mv_offset + x8 * 3 + y8 * 3 * b4_stride];
                    if (Math.abs(mv_col[0]) > 1 || Math.abs(mv_col[1]) > 1) continue;
                    if (ref[0] == 0) {
                        Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, 0, 4);
                    }
                    if (ref[1] == 0) {
                        Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, 0, 4);
                    }
                    n += 4;
                    continue;
                }
                int m = 0;
                for (int i4 = 0; i4 < 4; ++i4) {
                    int[] mv_col = l1mv_base[l1mv_offset + x8 * 2 + (i4 & 1) + (y8 * 2 + (i4 >> 1)) * b4_stride];
                    if (Math.abs(mv_col[0]) > 1 || Math.abs(mv_col[1]) > 1) continue;
                    if (ref[0] == 0) {
                        Arrays.fill(this.mv_cache[0][scan8[i8 * 4 + i4]], 0, 2, 0);
                    }
                    if (ref[1] == 0) {
                        Arrays.fill(this.mv_cache[1][scan8[i8 * 4 + i4]], 0, 2, 0);
                    }
                    ++m;
                }
                if (0 == (m & 3)) {
                    int n3 = i8;
                    this.sub_mb_type[n3] = this.sub_mb_type[n3] + -56;
                }
                n += m;
            }
            if (0 == is_b8x8 && 0 == (n & 0xF)) {
                mb_type = mb_type & 0xFFFF5F8F | 8 | 0x100;
            }
        }
        return mb_type;
    }

    public int pred_temp_direct_motion(int mb_type) {
        int sub_mb_type;
        int b8_stride = 2;
        int b4_stride = this.b_stride;
        int mb_xy = this.mb_xy;
        int[] mb_type_col = new int[2];
        boolean is_b8x8 = (mb_type & 0x40) != 0;
        int MB_TYPE_16x16_OR_INTRA = 15;
        if (0L != (this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy] & 0x80L)) {
            if (0 == (mb_type & 0x80)) {
                mb_xy = this.s.mb_x + ((this.s.mb_y & 0xFFFFFFFE) + this.col_parity) * this.s.mb_stride;
                b8_stride = 0;
            } else {
                mb_xy += this.col_fieldoff;
            }
            mb_type_col[0] = mb_type_col[1] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy];
            sub_mb_type = 20744;
            if (!is_b8x8 && (mb_type_col[0] & MB_TYPE_16x16_OR_INTRA) != 0) {
                mb_type |= 0x5108;
            } else if (!is_b8x8 && (mb_type_col[0] & 0x30) != 0) {
                mb_type |= 0xF100 | mb_type_col[0] & 0x30;
            } else {
                if (0 == this.sps.direct_8x8_inference_flag) {
                    sub_mb_type = 20800;
                }
                mb_type |= 0xF040;
            }
        } else if (0 != (mb_type & 0x80)) {
            mb_xy = this.s.mb_x + (this.s.mb_y & 0xFFFFFFFE) * this.s.mb_stride;
            mb_type_col[0] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy];
            mb_type_col[1] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy + this.s.mb_stride];
            b8_stride = 2 + 4 * this.s.mb_stride;
            b4_stride *= 6;
            sub_mb_type = 20744;
            mb_type = (mb_type_col[0] & MB_TYPE_16x16_OR_INTRA) != 0 && (mb_type_col[1] & MB_TYPE_16x16_OR_INTRA) != 0 && !is_b8x8 ? (mb_type |= 0xF110) : (mb_type |= 0xF040);
        } else {
            mb_type_col[0] = mb_type_col[1] = (int)this.ref_list[1][0].mb_type_base[this.ref_list[1][0].mb_type_offset + mb_xy];
            sub_mb_type = 20744;
            if (!is_b8x8 && (mb_type_col[0] & MB_TYPE_16x16_OR_INTRA) != 0) {
                mb_type |= 0x5108;
            } else if (!is_b8x8 && (mb_type_col[0] & 0x30) != 0) {
                mb_type |= 0xF100 | mb_type_col[0] & 0x30;
            } else {
                if (0 == this.sps.direct_8x8_inference_flag) {
                    sub_mb_type = 20800;
                }
                mb_type |= 0xF040;
            }
        }
        int[][] l1mv0_base = this.ref_list[1][0].motion_val_base[0];
        int[][] l1mv1_base = this.ref_list[1][0].motion_val_base[1];
        int l1mv0_offset = this.ref_list[1][0].motion_val_offset[0] + (int)this.mb2b_xy[mb_xy];
        int l1mv1_offset = this.ref_list[1][0].motion_val_offset[1] + (int)this.mb2b_xy[mb_xy];
        int[] l1ref0_base = this.ref_list[1][0].ref_index[0];
        int[] l1ref1_base = this.ref_list[1][0].ref_index[1];
        int l1ref0_offset = 4 * mb_xy;
        int l1ref1_offset = 4 * mb_xy;
        if (0 == b8_stride && (this.s.mb_y & 1) != 0) {
            l1ref0_offset += 2;
            l1ref1_offset += 2;
            l1mv0_offset += 2 * b4_stride;
            l1mv1_offset += 2 * b4_stride;
        }
        int[] dist_scale_factor = this.dist_scale_factor;
        if (0 != this.mb_aff_frame && 0 != (mb_type & 0x80)) {
            this.map_col_to_list0[0] = this.map_col_to_list0_field[this.s.mb_y & 1][0];
            this.map_col_to_list0[1] = this.map_col_to_list0_field[this.s.mb_y & 1][1];
            dist_scale_factor = this.dist_scale_factor_field[this.s.mb_y & 1];
        }
        int ref_offset = this.ref_list[1][0].mbaff << 4 & mb_type_col[0] >> 3;
        if ((mb_type & 0x80) != (mb_type_col[0] & 0x80)) {
            int y_shift = 2 * ((mb_type & 0x80) == 0 ? 1 : 0);
            for (int i8 = 0; i8 < 4; ++i8) {
                int x8 = i8 & 1;
                int y8 = i8 >> 1;
                int[][] l1mv_base = l1mv0_base;
                int l1mv_offset = l1mv0_offset;
                if (is_b8x8 && 0 == (this.sub_mb_type[i8] & 0x100)) continue;
                this.sub_mb_type[i8] = sub_mb_type;
                Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[i8 * 4], 2, 2, 8, 0, 1);
                if (0 != (mb_type_col[y8] & 7)) {
                    Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[i8 * 4], 2, 2, 8, 0, 1);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, 0, 4);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, 0, 4);
                    continue;
                }
                int ref0 = l1ref0_base[l1ref0_offset + x8 + y8 * b8_stride];
                if (ref0 >= 0) {
                    ref0 = this.map_col_to_list0[0][ref0 + ref_offset];
                } else {
                    ref0 = this.map_col_to_list0[1][l1ref1_base[l1ref1_offset + x8 + y8 * b8_stride] + ref_offset];
                    l1mv_base = l1mv1_base;
                    l1mv_offset = l1mv1_offset;
                }
                int scale = dist_scale_factor[ref0];
                Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[i8 * 4], 2, 2, 8, ref0, 1);
                int[] mv_col = l1mv_base[l1mv_offset + x8 * 3 + y8 * b4_stride];
                int my_col = (mv_col[1] << y_shift) / 2;
                int mx = scale * mv_col[0] + 128 >> 8;
                int my = scale * my_col + 128 >> 8;
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, H264Context.pack16to32(mx, my), 4);
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, H264Context.pack16to32(mx - mv_col[0], my - my_col), 4);
            }
            return mb_type;
        }
        if (0 != (mb_type & 8)) {
            int ref;
            int mv0;
            int mv1;
            Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[0], 4, 4, 8, 0, 1);
            if (0 != (mb_type_col[0] & 7)) {
                mv1 = 0;
                mv0 = 0;
                ref = 0;
            } else {
                int ref0 = l1ref0_base[l1ref0_offset + 0] >= 0 ? this.map_col_to_list0[0][l1ref0_base[l1ref0_offset + 0] + ref_offset] : this.map_col_to_list0[1][l1ref1_base[l1ref1_offset + 0] + ref_offset];
                int scale = dist_scale_factor[ref0];
                int[] mv_col = l1ref0_base[l1ref0_offset + 0] >= 0 ? l1mv0_base[l1mv0_offset + 0] : l1mv1_base[l1mv1_offset + 0];
                int[] mv_l0 = new int[]{scale * mv_col[0] + 128 >> 8, scale * mv_col[1] + 128 >> 8};
                ref = ref0;
                mv0 = H264Context.pack16to32(mv_l0[0], mv_l0[1]);
                mv1 = H264Context.pack16to32(mv_l0[0] - mv_col[0], mv_l0[1] - mv_col[1]);
            }
            Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[0], 4, 4, 8, ref, 1);
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[0], 4, 4, 8, mv0, 4);
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[0], 4, 4, 8, mv1, 4);
        } else {
            for (int i8 = 0; i8 < 4; ++i8) {
                int[] mv_col;
                int x8 = i8 & 1;
                int y8 = i8 >> 1;
                int[][] l1mv_base = l1mv0_base;
                int l1mv_offset = l1mv0_offset;
                if (is_b8x8 && 0 == (this.sub_mb_type[i8] & 0x100)) continue;
                this.sub_mb_type[i8] = sub_mb_type;
                Rectangle.fill_rectangle_sign(this.ref_cache[1], scan8[i8 * 4], 2, 2, 8, 0, 1);
                if (0 != (mb_type_col[0] & 7)) {
                    Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[i8 * 4], 2, 2, 8, 0, 1);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, 0, 4);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, 0, 4);
                    continue;
                }
                int ref0 = l1ref0_base[l1ref0_offset + i8];
                if (ref0 >= 0) {
                    ref0 = this.map_col_to_list0[0][ref0 + ref_offset];
                } else {
                    ref0 = this.map_col_to_list0[1][l1ref1_base[l1ref1_offset + i8] + ref_offset];
                    l1mv_base = l1mv1_base;
                    l1mv_offset = l1mv1_offset;
                }
                int scale = dist_scale_factor[ref0];
                Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[i8 * 4], 2, 2, 8, ref0, 1);
                if (0 != (sub_mb_type & 8)) {
                    mv_col = l1mv_base[l1mv_offset + x8 * 3 + y8 * 3 * b4_stride];
                    int mx = scale * mv_col[0] + 128 >> 8;
                    int my = scale * mv_col[1] + 128 >> 8;
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[i8 * 4], 2, 2, 8, H264Context.pack16to32(mx, my), 4);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[1], scan8[i8 * 4], 2, 2, 8, H264Context.pack16to32(mx - mv_col[0], my - mv_col[1]), 4);
                    continue;
                }
                for (int i4 = 0; i4 < 4; ++i4) {
                    mv_col = l1mv_base[l1mv_offset + x8 * 2 + (i4 & 1) + (y8 * 2 + (i4 >> 1)) * b4_stride];
                    int[] mv_l0 = this.mv_cache[0][scan8[i8 * 4 + i4]];
                    mv_l0[0] = scale * mv_col[0] + 128 >> 8;
                    mv_l0[1] = scale * mv_col[1] + 128 >> 8;
                    this.mv_cache[1][H264Context.scan8[i8 * 4 + i4]][0] = mv_l0[0] - mv_col[0];
                    this.mv_cache[1][H264Context.scan8[i8 * 4 + i4]][1] = mv_l0[1] - mv_col[1];
                }
            }
        }
        return mb_type;
    }

    public int ff_h264_pred_direct_motion(int mb_type) {
        if (this.direct_spatial_mv_pred != 0) {
            return this.pred_spatial_direct_motion(mb_type);
        }
        return this.pred_temp_direct_motion(mb_type);
    }

    public void pred_pskip_motion(int[] mxmy) {
        int top_ref = this.ref_cache[0][scan8[0] - 8];
        int left_ref = this.ref_cache[0][scan8[0] - 1];
        if (top_ref == -2 || left_ref == -2 || 0 == (top_ref | (this.mv_cache[0][scan8[0] - 8][1] & 0xFFFF) << 16 | this.mv_cache[0][scan8[0] - 8][0] & 0xFFFF) || 0 == (left_ref | (this.mv_cache[0][scan8[0] - 1][1] & 0xFFFF) << 16 | this.mv_cache[0][scan8[0] - 1][0] & 0xFFFF)) {
            mxmy[1] = 0;
            mxmy[0] = 0;
            return;
        }
        this.pred_motion(0, 4, 0, 0, mxmy);
    }

    public int fetch_diagonal_mv(int[][] pC, int i, int list, int part_width) {
        int topright_ref = this.ref_cache[list][i - 8 + part_width];
        if (this.mb_aff_frame != 0 && topright_ref == -2 && i >= scan8[0] + 8 && (i & 7) == 4 && this.ref_cache[list][scan8[0] - 1] != -2) {
            long[] mb_types_base = this.s.current_picture_ptr.mb_type_base;
            int mb_types_offset = this.s.current_picture_ptr.mb_type_offset;
            Arrays.fill(this.mv_cache[list][scan8[0] - 2], 0, 2, 0);
            pC[0] = this.mv_cache[list][scan8[0] - 2];
            if (0 == this.mb_field_decoding_flag && 0 != (this.left_type[0] & 0x80)) {
                int xy = this.left_mb_xy[0] + this.s.mb_stride;
                int y4 = (this.s.mb_y & 1) * 2 + (i >> 5);
                int mb_type = (int)mb_types_base[mb_types_offset + xy + (y4 >> 2) * this.s.mb_stride];
                if (0 == (mb_type & 12288 << 2 * list)) {
                    return -1;
                }
                int[] mv = this.s.current_picture_ptr.motion_val_base[list][this.s.current_picture_ptr.motion_val_offset[list] + (int)this.mb2b_xy[xy] + 3 + y4 * this.b_stride];
                this.mv_cache[list][H264Context.scan8[0] - 2][0] = mv[0];
                this.mv_cache[list][H264Context.scan8[0] - 2][1] = mv[1] * 2;
                return this.s.current_picture_ptr.ref_index[list][4 * xy + 1 + (y4 & 0xFFFFFFFE)] >> 1;
            }
            if (0 != this.mb_field_decoding_flag && 0 == (this.left_type[0] & 0x80)) {
                int y4;
                int xy = this.left_mb_xy[i >= 36 ? 1 : 0];
                int mb_type = (int)mb_types_base[mb_types_offset + xy + ((y4 = i >> 2 & 3) >> 2) * this.s.mb_stride];
                if (0 == (mb_type & 12288 << 2 * list)) {
                    return -1;
                }
                int[] mv = this.s.current_picture_ptr.motion_val_base[list][this.s.current_picture_ptr.motion_val_offset[list] + (int)this.mb2b_xy[xy] + 3 + y4 * this.b_stride];
                this.mv_cache[list][H264Context.scan8[0] - 2][0] = mv[0];
                this.mv_cache[list][H264Context.scan8[0] - 2][1] = mv[1] / 2;
                return this.s.current_picture_ptr.ref_index[list][4 * xy + 1 + (y4 & 0xFFFFFFFE)] << 1;
            }
        }
        if (topright_ref != -2) {
            pC[0] = this.mv_cache[list][i - 8 + part_width];
            return topright_ref;
        }
        pC[0] = this.mv_cache[list][i - 8 - 1];
        return this.ref_cache[list][i - 8 - 1];
    }

    public void pred_motion(int n, int part_width, int list, int ref, int[] mxmy) {
        short index8 = scan8[n];
        int top_ref = this.ref_cache[list][index8 - 8];
        int left_ref = this.ref_cache[list][index8 - 1];
        int[] A = this.mv_cache[list][index8 - 1];
        int[] B = this.mv_cache[list][index8 - 8];
        int[] C = new int[]{};
        int[][] pC = new int[][]{C};
        int diagonal_ref = this.fetch_diagonal_mv(pC, index8, list, part_width);
        C = pC[0];
        int match_count = (diagonal_ref == ref ? 1 : 0) + (top_ref == ref ? 1 : 0) + (left_ref == ref ? 1 : 0);
        if (match_count > 1) {
            mxmy[0] = H264Context.mid_pred(A[0], B[0], C[0]);
            mxmy[1] = H264Context.mid_pred(A[1], B[1], C[1]);
        } else if (match_count == 1) {
            if (left_ref == ref) {
                mxmy[0] = A[0];
                mxmy[1] = A[1];
            } else if (top_ref == ref) {
                mxmy[0] = B[0];
                mxmy[1] = B[1];
            } else {
                mxmy[0] = C[0];
                mxmy[1] = C[1];
            }
        } else if (top_ref == -2 && diagonal_ref == -2 && left_ref != -2) {
            mxmy[0] = A[0];
            mxmy[1] = A[1];
        } else {
            mxmy[0] = H264Context.mid_pred(A[0], B[0], C[0]);
            mxmy[1] = H264Context.mid_pred(A[1], B[1], C[1]);
        }
    }

    public void pred_16x8_motion(int n, int list, int ref, int[] mxmy) {
        if (n == 0) {
            int top_ref = this.ref_cache[list][scan8[0] - 8];
            int[] B = this.mv_cache[list][scan8[0] - 8];
            if (top_ref == ref) {
                mxmy[0] = B[0];
                mxmy[1] = B[1];
                return;
            }
        } else {
            int left_ref = this.ref_cache[list][scan8[8] - 1];
            int[] A = this.mv_cache[list][scan8[8] - 1];
            if (left_ref == ref) {
                mxmy[0] = A[0];
                mxmy[1] = A[1];
                return;
            }
        }
        this.pred_motion(n, 4, list, ref, mxmy);
    }

    public void pred_8x16_motion(int n, int list, int ref, int[] mxmy) {
        if (n == 0) {
            int left_ref = this.ref_cache[list][scan8[0] - 1];
            int[] A = this.mv_cache[list][scan8[0] - 1];
            if (left_ref == ref) {
                mxmy[0] = A[0];
                mxmy[1] = A[1];
                return;
            }
        } else {
            int[] C = null;
            int[][] pC = new int[][]{C};
            int diagonal_ref = this.fetch_diagonal_mv(pC, scan8[4], list, 2);
            C = pC[0];
            if (diagonal_ref == ref) {
                mxmy[0] = C[0];
                mxmy[1] = C[1];
                return;
            }
        }
        this.pred_motion(n, 2, list, ref, mxmy);
    }

    public void fill_decode_neighbors(int mb_type) {
        int mb_xy = this.mb_xy;
        int[] left_xy = new int[2];
        int[][] left_block_options = new int[][]{{0, 1, 2, 3, 7, 10, 8, 11, 7, 15, 23, 31, 2, 26, 10, 18}, {2, 2, 3, 3, 8, 11, 8, 11, 23, 23, 31, 31, 10, 18, 10, 18}, {0, 0, 1, 1, 7, 10, 7, 10, 7, 7, 15, 15, 2, 26, 2, 26}, {0, 2, 0, 2, 7, 10, 7, 10, 7, 23, 7, 23, 2, 26, 2, 26}};
        this.topleft_partition = -1;
        int top_xy = mb_xy - (this.s.mb_stride << this.mb_field_decoding_flag);
        int topleft_xy = top_xy - 1;
        int topright_xy = top_xy + 1;
        left_xy[1] = left_xy[0] = mb_xy - 1;
        this.left_block = left_block_options[0];
        if (this.mb_aff_frame != 0) {
            int left_mb_field_flag = (int)(this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy - 1] & 0x80L);
            int curr_mb_field_flag = mb_type & 0x80;
            if ((this.s.mb_y & 1) != 0) {
                if (left_mb_field_flag != curr_mb_field_flag) {
                    left_xy[1] = left_xy[0] = mb_xy - this.s.mb_stride - 1;
                    if (curr_mb_field_flag != 0) {
                        left_xy[1] = left_xy[1] + this.s.mb_stride;
                        this.left_block = left_block_options[3];
                    } else {
                        topleft_xy += this.s.mb_stride;
                        this.topleft_partition = 0;
                        this.left_block = left_block_options[1];
                    }
                }
            } else {
                if (curr_mb_field_flag != 0) {
                    topleft_xy = (int)((long)topleft_xy + ((long)this.s.mb_stride & (this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + top_xy - 1] >> 7 & 1L) - 1L));
                    topright_xy = (int)((long)topright_xy + ((long)this.s.mb_stride & (this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + top_xy + 1] >> 7 & 1L) - 1L));
                    top_xy = (int)((long)top_xy + ((long)this.s.mb_stride & (this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + top_xy] >> 7 & 1L) - 1L));
                }
                if (left_mb_field_flag != curr_mb_field_flag) {
                    if (curr_mb_field_flag != 0) {
                        left_xy[1] = left_xy[1] + this.s.mb_stride;
                        this.left_block = left_block_options[3];
                    } else {
                        this.left_block = left_block_options[2];
                    }
                }
            }
        }
        this.topleft_mb_xy = topleft_xy;
        this.top_mb_xy = top_xy;
        this.topright_mb_xy = topright_xy;
        this.left_mb_xy[0] = left_xy[0];
        this.left_mb_xy[1] = left_xy[1];
        this.topleft_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + topleft_xy];
        this.top_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + top_xy];
        this.topright_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + topright_xy];
        this.left_type[0] = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + left_xy[0]];
        this.left_type[1] = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + left_xy[1]];
        if (this.slice_table_base[this.slice_table_offset + topleft_xy] != this.slice_num) {
            this.topleft_type = 0;
            if (this.slice_table_base[this.slice_table_offset + top_xy] != this.slice_num) {
                this.top_type = 0;
            }
            if (this.slice_table_base[this.slice_table_offset + left_xy[0]] != this.slice_num) {
                this.left_type[1] = 0;
                this.left_type[0] = 0;
            }
        }
        if (this.slice_table_base[this.slice_table_offset + topright_xy] != this.slice_num) {
            this.topright_type = 0;
        }
    }

    public void fill_decode_caches(int mb_type) {
        int i;
        int[] left_xy = new int[2];
        int[] left_type = new int[2];
        int topleft_xy = this.topleft_mb_xy;
        int top_xy = this.top_mb_xy;
        int topright_xy = this.topright_mb_xy;
        left_xy[0] = this.left_mb_xy[0];
        left_xy[1] = this.left_mb_xy[1];
        int topleft_type = this.topleft_type;
        int top_type = this.top_type;
        int topright_type = this.topright_type;
        left_type[0] = this.left_type[0];
        left_type[1] = this.left_type[1];
        if ((mb_type & 0x800) == 0) {
            if ((mb_type & 7) != 0) {
                int type_mask = this.pps.constrained_intra_pred != 0 ? 1 : -1;
                this.left_samples_available = 65535L;
                this.top_samples_available = 65535L;
                this.topleft_samples_available = 65535L;
                this.topright_samples_available = 61162L;
                if (0 == (top_type & type_mask)) {
                    this.topleft_samples_available = 46079L;
                    this.top_samples_available = 13311L;
                    this.topright_samples_available = 9962L;
                }
                if ((mb_type & 0x80) != (left_type[0] & 0x80)) {
                    if ((mb_type & 0x80) != 0) {
                        if (0 == (left_type[0] & type_mask)) {
                            this.topleft_samples_available &= 0xDFFFL;
                            this.left_samples_available &= 0x5FFFL;
                        }
                        if (0 == (left_type[1] & type_mask)) {
                            this.topleft_samples_available &= 0xFF5FL;
                            this.left_samples_available &= 0xFF5FL;
                        }
                    } else {
                        int left_typei = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + left_xy[0] + this.s.mb_stride];
                        if ((left_typei & type_mask) == 0 || (left_type[0] & type_mask) == 0) {
                            this.topleft_samples_available &= 0xDF5FL;
                            this.left_samples_available &= 0x5F5FL;
                        }
                    }
                } else if (0 == (left_type[0] & type_mask)) {
                    this.topleft_samples_available &= 0xDF5FL;
                    this.left_samples_available &= 0x5F5FL;
                }
                if (0 == (topleft_type & type_mask)) {
                    this.topleft_samples_available &= 0x7FFFL;
                }
                if (0 == (topright_type & type_mask)) {
                    this.topright_samples_available &= 0xFBFFL;
                }
                if ((mb_type & 1) != 0) {
                    if ((top_type & 1) != 0) {
                        this.intra4x4_pred_mode_cache[4] = this.intra4x4_pred_mode[0 + (int)this.mb2br_xy[top_xy]];
                        this.intra4x4_pred_mode_cache[5] = this.intra4x4_pred_mode[1 + (int)this.mb2br_xy[top_xy]];
                        this.intra4x4_pred_mode_cache[6] = this.intra4x4_pred_mode[2 + (int)this.mb2br_xy[top_xy]];
                        this.intra4x4_pred_mode_cache[7] = this.intra4x4_pred_mode[3 + (int)this.mb2br_xy[top_xy]];
                    } else {
                        this.intra4x4_pred_mode_cache[6] = this.intra4x4_pred_mode_cache[7] = 2 - 3 * ((top_type & type_mask) != 0 ? 0 : 1);
                        this.intra4x4_pred_mode_cache[5] = this.intra4x4_pred_mode_cache[7];
                        this.intra4x4_pred_mode_cache[4] = this.intra4x4_pred_mode_cache[7];
                    }
                    for (i = 0; i < 2; ++i) {
                        if ((left_type[i] & 1) != 0) {
                            int mode_offset = (int)this.mb2br_xy[left_xy[i]];
                            this.intra4x4_pred_mode_cache[11 + 16 * i] = this.intra4x4_pred_mode[mode_offset + 6 - this.left_block[0 + 2 * i]];
                            this.intra4x4_pred_mode_cache[19 + 16 * i] = this.intra4x4_pred_mode[mode_offset + 6 - this.left_block[1 + 2 * i]];
                            continue;
                        }
                        int n = 2 - 3 * ((left_type[i] & type_mask) != 0 ? 0 : 1);
                        this.intra4x4_pred_mode_cache[19 + 16 * i] = n;
                        this.intra4x4_pred_mode_cache[11 + 16 * i] = n;
                    }
                }
            }
            if (top_type != 0) {
                this.non_zero_count_cache[4] = this.non_zero_count[top_xy][28];
                this.non_zero_count_cache[5] = this.non_zero_count[top_xy][29];
                this.non_zero_count_cache[6] = this.non_zero_count[top_xy][30];
                this.non_zero_count_cache[7] = this.non_zero_count[top_xy][31];
                this.non_zero_count_cache[1] = this.non_zero_count[top_xy][9];
                this.non_zero_count_cache[2] = this.non_zero_count[top_xy][10];
                this.non_zero_count_cache[25] = this.non_zero_count[top_xy][17];
                this.non_zero_count_cache[26] = this.non_zero_count[top_xy][18];
            } else {
                this.non_zero_count_cache[7] = this.pps.cabac != 0 && 0 == (mb_type & 7) ? 0 : 64;
                this.non_zero_count_cache[6] = this.non_zero_count_cache[7];
                this.non_zero_count_cache[5] = this.non_zero_count_cache[7];
                this.non_zero_count_cache[4] = this.non_zero_count_cache[7];
                this.non_zero_count_cache[26] = this.non_zero_count_cache[7];
                this.non_zero_count_cache[25] = this.non_zero_count_cache[7];
                this.non_zero_count_cache[2] = this.non_zero_count_cache[7];
                this.non_zero_count_cache[1] = this.non_zero_count_cache[7];
            }
            for (i = 0; i < 2; ++i) {
                if (left_type[i] != 0) {
                    this.non_zero_count_cache[11 + 16 * i] = this.non_zero_count[left_xy[i]][this.left_block[8 + 2 * i]];
                    this.non_zero_count_cache[19 + 16 * i] = this.non_zero_count[left_xy[i]][this.left_block[9 + 2 * i]];
                    this.non_zero_count_cache[8 + 8 * i] = this.non_zero_count[left_xy[i]][this.left_block[12 + 2 * i]];
                    this.non_zero_count_cache[32 + 8 * i] = this.non_zero_count[left_xy[i]][this.left_block[13 + 2 * i]];
                    continue;
                }
                int n = this.pps.cabac != 0 && 0 == (mb_type & 7) ? 0 : 64;
                this.non_zero_count_cache[32 + 8 * i] = n;
                this.non_zero_count_cache[8 + 8 * i] = n;
                this.non_zero_count_cache[19 + 16 * i] = n;
                this.non_zero_count_cache[11 + 16 * i] = n;
            }
            if (this.pps.cabac != 0) {
                if (top_type != 0) {
                    this.top_cbp = this.cbp_table[top_xy];
                } else {
                    int n = this.top_cbp = (mb_type & 7) != 0 ? 463 : 15;
                }
                if (left_type[0] != 0) {
                    this.left_cbp = this.cbp_table[left_xy[0]] & 0x1F0 | this.cbp_table[left_xy[0]] >> (this.left_block[0] & 0xFFFFFFFE) & 2 | (this.cbp_table[left_xy[1]] >> (this.left_block[2] & 0xFFFFFFFE) & 2) << 2;
                } else {
                    int n = this.left_cbp = (mb_type & 7) != 0 ? 463 : 15;
                }
            }
        }
        if ((mb_type & 0x78) != 0 || (mb_type & 0x100) != 0 && this.direct_spatial_mv_pred != 0) {
            int list = 0;
            while ((long)list < this.list_count) {
                if ((mb_type & 12288 << 2 * list) != 0) {
                    int b8_xy;
                    int b_xy;
                    this.mv_cache_clean[list] = 0;
                    if ((top_type & 12288 << 2 * list) != 0) {
                        b_xy = (int)this.mb2b_xy[top_xy] + 3 * this.b_stride;
                        for (int j = 0; j < 4; ++j) {
                            this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + j][0] = this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + 0 + j][0];
                            this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + j][1] = this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + 0 + j][1];
                        }
                        int n = this.s.current_picture.ref_index[list][4 * top_xy + 2];
                        this.ref_cache[list][H264Context.scan8[0] + 1 - 8] = n;
                        this.ref_cache[list][H264Context.scan8[0] + 0 - 8] = n;
                        int n2 = this.s.current_picture.ref_index[list][4 * top_xy + 3];
                        this.ref_cache[list][H264Context.scan8[0] + 3 - 8] = n2;
                        this.ref_cache[list][H264Context.scan8[0] + 2 - 8] = n2;
                    } else {
                        for (int j = 0; j < 4; ++j) {
                            this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + j][0] = 0;
                            this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + j][1] = 0;
                        }
                        Arrays.fill(this.ref_cache[list], scan8[0] + 0 - 8, scan8[0] + 0 - 8 + 4, top_type != 0 ? -1 : -2);
                    }
                    if ((mb_type & 0x50) != 0) {
                        for (i = 0; i < 2; ++i) {
                            int cache_idx = scan8[0] - 1 + i * 2 * 8;
                            if ((left_type[i] & 12288 << 2 * list) != 0) {
                                int b_xy2 = (int)this.mb2b_xy[left_xy[i]] + 3;
                                int b8_xy2 = 4 * left_xy[i] + 1;
                                System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy2 + this.b_stride * this.left_block[0 + i * 2]], 0, this.mv_cache[list][cache_idx], 0, 2);
                                System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy2 + this.b_stride * this.left_block[1 + i * 2]], 0, this.mv_cache[list][cache_idx + 8], 0, 2);
                                this.ref_cache[list][cache_idx] = this.s.current_picture.ref_index[list][b8_xy2 + (this.left_block[0 + i * 2] & 0xFFFFFFFE)];
                                this.ref_cache[list][cache_idx + 8] = this.s.current_picture.ref_index[list][b8_xy2 + (this.left_block[1 + i * 2] & 0xFFFFFFFE)];
                                continue;
                            }
                            Arrays.fill(this.mv_cache[list][cache_idx], 0, 2, 0);
                            Arrays.fill(this.mv_cache[list][cache_idx + 8], 0, 2, 0);
                            int n = left_type[i] != 0 ? -1 : -2;
                            this.ref_cache[list][cache_idx + 8] = n;
                            this.ref_cache[list][cache_idx] = n;
                        }
                    } else if ((left_type[0] & 12288 << 2 * list) != 0) {
                        b_xy = (int)this.mb2b_xy[left_xy[0]] + 3;
                        b8_xy = 4 * left_xy[0] + 1;
                        System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + this.b_stride * this.left_block[0]], 0, this.mv_cache[list][scan8[0] - 1], 0, 2);
                        this.ref_cache[list][H264Context.scan8[0] - 1] = this.s.current_picture.ref_index[list][b8_xy + (this.left_block[0] & 0xFFFFFFFE)];
                    } else {
                        Arrays.fill(this.mv_cache[list][scan8[0] - 1], 0, 2, 0);
                        int n = this.ref_cache[list][H264Context.scan8[0] - 1] = left_type[0] != 0 ? -1 : -2;
                    }
                    if ((topright_type & 12288 << 2 * list) != 0) {
                        b_xy = (int)this.mb2b_xy[topright_xy] + 3 * this.b_stride;
                        System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy], 0, this.mv_cache[list][scan8[0] + 4 - 8], 0, 2);
                        this.ref_cache[list][H264Context.scan8[0] + 4 - 8] = this.s.current_picture.ref_index[list][4 * topright_xy + 2];
                    } else {
                        Arrays.fill(this.mv_cache[list][scan8[0] + 4 - 8], 0, 2, 0);
                        int n = this.ref_cache[list][H264Context.scan8[0] + 4 - 8] = topright_type != 0 ? -1 : -2;
                    }
                    if (this.ref_cache[list][scan8[0] + 4 - 8] < 0) {
                        if ((topleft_type & 12288 << 2 * list) != 0) {
                            b_xy = (int)this.mb2b_xy[topleft_xy] + 3 + this.b_stride + (this.topleft_partition & 2 * this.b_stride);
                            b8_xy = 4 * topleft_xy + 1 + (this.topleft_partition & 2);
                            System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy], 0, this.mv_cache[list][scan8[0] - 1 - 8], 0, 2);
                            this.ref_cache[list][H264Context.scan8[0] - 1 - 8] = this.s.current_picture.ref_index[list][b8_xy];
                        } else {
                            Arrays.fill(this.mv_cache[list][scan8[0] - 1 - 8], 0, 2, 0);
                            int n = this.ref_cache[list][H264Context.scan8[0] - 1 - 8] = topleft_type != 0 ? -1 : -2;
                        }
                    }
                    if ((mb_type & 0x900) == 0 || 0 != this.mb_aff_frame) {
                        if (0 == (mb_type & 0x900)) {
                            this.ref_cache[list][H264Context.scan8[12]] = -2;
                            this.ref_cache[list][H264Context.scan8[4]] = -2;
                            Arrays.fill(this.mv_cache[list][scan8[4]], 0, 2, 0);
                            Arrays.fill(this.mv_cache[list][scan8[12]], 0, 2, 0);
                            if (this.pps.cabac != 0) {
                                if ((top_type & 12288 << 2 * list) != 0) {
                                    b_xy = (int)this.mb2br_xy[top_xy];
                                    for (int k = 0; k < 4; ++k) {
                                        this.mvd_cache[list][H264Context.scan8[0] + 0 - 8 + k][0] = this.mvd_table[list][b_xy + 0 + k][0];
                                        this.mvd_cache[list][H264Context.scan8[0] + 0 - 8 + k][1] = this.mvd_table[list][b_xy + 0 + k][1];
                                    }
                                } else {
                                    for (int k = 0; k < 4; ++k) {
                                        this.mvd_cache[list][H264Context.scan8[0] + 0 - 8 + k][0] = 0;
                                        this.mvd_cache[list][H264Context.scan8[0] + 0 - 8 + k][1] = 0;
                                    }
                                }
                                if ((left_type[0] & 12288 << 2 * list) != 0) {
                                    b_xy = (int)this.mb2br_xy[left_xy[0]] + 6;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 0][0] = this.mvd_table[list][b_xy - this.left_block[0]][0];
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 0][1] = this.mvd_table[list][b_xy - this.left_block[0]][1];
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 8][0] = this.mvd_table[list][b_xy - this.left_block[1]][0];
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 8][1] = this.mvd_table[list][b_xy - this.left_block[1]][1];
                                } else {
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 0][0] = 0;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 0][1] = 0;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 8][0] = 0;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 8][1] = 0;
                                }
                                if ((left_type[1] & 12288 << 2 * list) != 0) {
                                    b_xy = (int)this.mb2br_xy[left_xy[1]] + 6;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 16][0] = this.mvd_table[list][b_xy - this.left_block[2]][0];
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 16][1] = this.mvd_table[list][b_xy - this.left_block[2]][1];
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 24][0] = this.mvd_table[list][b_xy - this.left_block[3]][0];
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 24][1] = this.mvd_table[list][b_xy - this.left_block[3]][1];
                                } else {
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 16][0] = 0;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 16][1] = 0;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 24][0] = 0;
                                    this.mvd_cache[list][H264Context.scan8[0] - 1 + 24][1] = 0;
                                }
                                this.mvd_cache[list][H264Context.scan8[4]][0] = 0;
                                this.mvd_cache[list][H264Context.scan8[4]][1] = 0;
                                this.mvd_cache[list][H264Context.scan8[12]][0] = 0;
                                this.mvd_cache[list][H264Context.scan8[12]][1] = 0;
                                if (this.slice_type_nos == 3) {
                                    Rectangle.fill_rectangle_unsign(this.direct_cache, scan8[0], 4, 4, 8, 4, 1);
                                    if ((top_type & 0x100) != 0) {
                                        Arrays.fill(this.direct_cache, scan8[0] - 8, scan8[0] - 8 + 4, 128);
                                    } else if ((top_type & 0x40) != 0) {
                                        int b8_xy3 = 4 * top_xy;
                                        this.direct_cache[H264Context.scan8[0] + 0 - 8] = this.direct_table[b8_xy3 + 2];
                                        this.direct_cache[H264Context.scan8[0] + 2 - 8] = this.direct_table[b8_xy3 + 3];
                                    } else {
                                        Arrays.fill(this.direct_cache, scan8[0] - 8, scan8[0] - 8 + 4, 4);
                                    }
                                    this.direct_cache[H264Context.scan8[0] - 1 + 0] = (left_type[0] & 0x100) != 0 ? 128 : ((left_type[0] & 0x40) != 0 ? this.direct_table[4 * left_xy[0] + 1 + (this.left_block[0] & 0xFFFFFFFE)] : 4);
                                    this.direct_cache[H264Context.scan8[0] - 1 + 16] = (left_type[1] & 0x100) != 0 ? 128 : ((left_type[1] & 0x40) != 0 ? this.direct_table[4 * left_xy[1] + 1 + (this.left_block[2] & 0xFFFFFFFE)] : 4);
                                }
                            }
                        }
                        if (this.mb_aff_frame != 0) {
                            if (this.mb_field_decoding_flag != 0) {
                                this.MAP_F2F_1(scan8[0] - 1 - 8, topleft_type, list);
                                this.MAP_F2F_1(scan8[0] + 0 - 8, top_type, list);
                                this.MAP_F2F_1(scan8[0] + 1 - 8, top_type, list);
                                this.MAP_F2F_1(scan8[0] + 2 - 8, top_type, list);
                                this.MAP_F2F_1(scan8[0] + 3 - 8, top_type, list);
                                this.MAP_F2F_1(scan8[0] + 4 - 8, topright_type, list);
                                this.MAP_F2F_1(scan8[0] - 1 + 0, left_type[0], list);
                                this.MAP_F2F_1(scan8[0] - 1 + 8, left_type[0], list);
                                this.MAP_F2F_1(scan8[0] - 1 + 16, left_type[1], list);
                                this.MAP_F2F_1(scan8[0] - 1 + 24, left_type[1], list);
                            } else {
                                this.MAP_F2F_2(scan8[0] - 1 - 8, topleft_type, list);
                                this.MAP_F2F_2(scan8[0] + 0 - 8, top_type, list);
                                this.MAP_F2F_2(scan8[0] + 1 - 8, top_type, list);
                                this.MAP_F2F_2(scan8[0] + 2 - 8, top_type, list);
                                this.MAP_F2F_2(scan8[0] + 3 - 8, top_type, list);
                                this.MAP_F2F_2(scan8[0] + 4 - 8, topright_type, list);
                                this.MAP_F2F_2(scan8[0] - 1 + 0, left_type[0], list);
                                this.MAP_F2F_2(scan8[0] - 1 + 8, left_type[0], list);
                                this.MAP_F2F_2(scan8[0] - 1 + 16, left_type[1], list);
                                this.MAP_F2F_2(scan8[0] - 1 + 24, left_type[1], list);
                            }
                        }
                    }
                }
                ++list;
            }
        }
        this.neighbor_transform_size = ((top_type & 0x1000000) > 0 ? 1 : 0) + ((left_type[0] & 0x1000000) > 0 ? 1 : 0);
    }

    public void write_back_non_zero_count() {
        int mb_xy = this.mb_xy;
        System.arraycopy(this.non_zero_count_cache, 8, this.non_zero_count[mb_xy], 0, 8);
        System.arraycopy(this.non_zero_count_cache, 16, this.non_zero_count[mb_xy], 8, 8);
        System.arraycopy(this.non_zero_count_cache, 40, this.non_zero_count[mb_xy], 16, 4);
        System.arraycopy(this.non_zero_count_cache, 28, this.non_zero_count[mb_xy], 20, 4);
        System.arraycopy(this.non_zero_count_cache, 32, this.non_zero_count[mb_xy], 24, 8);
    }

    public void write_back_motion(int mb_type) {
        int b_xy = 4 * this.s.mb_x + 4 * this.s.mb_y * this.b_stride;
        int b8_xy = 4 * this.mb_xy;
        if (0 == (mb_type & 0x3000)) {
            Rectangle.fill_rectangle_sign(this.s.current_picture.ref_index[0], b8_xy, 2, 2, 2, -1, 1);
        }
        int list = 0;
        while ((long)list < this.list_count) {
            if (0 != (mb_type & 12288 << 2 * list)) {
                int b_stride = this.b_stride;
                int[][] mv_dst_base = this.s.current_picture.motion_val_base[list];
                int mv_dst_offset = this.s.current_picture.motion_val_offset[list] + b_xy;
                int[][] mv_src_base = this.mv_cache[list];
                short mv_src_offset = scan8[0];
                for (int y = 0; y < 4; ++y) {
                    for (int j = 0; j < 4; ++j) {
                        mv_dst_base[mv_dst_offset + y * b_stride + j][0] = mv_src_base[mv_src_offset + 8 * y + j][0];
                        mv_dst_base[mv_dst_offset + y * b_stride + j][1] = mv_src_base[mv_src_offset + 8 * y + j][1];
                    }
                }
                if (0 != this.pps.cabac) {
                    int k;
                    int[][] mvd_dst_base = this.mvd_table[list];
                    int mvd_dst_offset = (int)this.mb2br_xy[this.mb_xy];
                    int[][] mvd_src_base = this.mvd_cache[list];
                    short mvd_src_offset = scan8[0];
                    if (0 != (mb_type & 0x800)) {
                        for (k = 0; k < 8; ++k) {
                            Arrays.fill(mvd_dst_base[mvd_dst_offset + k], 0, 2, 0);
                        }
                    } else {
                        for (k = 0; k < 4; ++k) {
                            System.arraycopy(mvd_src_base[mvd_src_offset + 24 + k], 0, mvd_dst_base[mvd_dst_offset + k], 0, 2);
                        }
                        System.arraycopy(mvd_src_base[mvd_src_offset + 3 + 0], 0, mvd_dst_base[mvd_dst_offset + 3 + 3], 0, 2);
                        System.arraycopy(mvd_src_base[mvd_src_offset + 3 + 8], 0, mvd_dst_base[mvd_dst_offset + 3 + 2], 0, 2);
                        System.arraycopy(mvd_src_base[mvd_src_offset + 3 + 16], 0, mvd_dst_base[mvd_dst_offset + 3 + 1], 0, 2);
                    }
                }
                int[] ref_index = this.s.current_picture.ref_index[list];
                ref_index[b8_xy + 0 + 0] = this.ref_cache[list][scan8[0]];
                ref_index[b8_xy + 1 + 0] = this.ref_cache[list][scan8[4]];
                ref_index[b8_xy + 0 + 2] = this.ref_cache[list][scan8[8]];
                ref_index[b8_xy + 1 + 2] = this.ref_cache[list][scan8[12]];
            }
            ++list;
        }
        if (this.slice_type_nos == 3 && this.pps.cabac != 0 && 0 != (mb_type & 0x40)) {
            this.direct_table[4 * this.mb_xy + 1] = this.sub_mb_type[1] >> 1;
            this.direct_table[4 * this.mb_xy + 2] = this.sub_mb_type[2] >> 1;
            this.direct_table[4 * this.mb_xy + 3] = this.sub_mb_type[3] >> 1;
        }
    }

    public int pred_intra_mode(int n) {
        short index8 = scan8[n];
        int left = this.intra4x4_pred_mode_cache[index8 - 1];
        int top = this.intra4x4_pred_mode_cache[index8 - 8];
        int min = Math.min(left, top);
        if (min < 0) {
            return 2;
        }
        return min;
    }

    public void ff_h264_write_back_intra_pred_mode() {
        int[] mode_base = this.intra4x4_pred_mode;
        int mode_offset = (int)this.mb2br_xy[this.mb_xy];
        System.arraycopy(this.intra4x4_pred_mode_cache, 36, mode_base, mode_offset, 4);
        mode_base[mode_offset + 4] = this.intra4x4_pred_mode_cache[31];
        mode_base[mode_offset + 5] = this.intra4x4_pred_mode_cache[23];
        mode_base[mode_offset + 6] = this.intra4x4_pred_mode_cache[15];
    }

    public int ff_h264_check_intra4x4_pred_mode() {
        int i;
        int[] top = new int[]{-1, 0, 9, -1, -1, -1, -1, -1, 0, 0, 0, 0};
        int[] left = new int[]{0, -1, 10, 0, -1, -1, -1, 0, -1, 11, 0, 0};
        if (0L == (this.top_samples_available & 0x8000L)) {
            for (i = 0; i < 4; ++i) {
                int status = top[this.intra4x4_pred_mode_cache[scan8[0] + i]];
                if (status < 0) {
                    return -1;
                }
                if (status == 0) continue;
                this.intra4x4_pred_mode_cache[H264Context.scan8[0] + i] = status;
            }
        }
        if ((this.left_samples_available & 0x8888L) != 34952L) {
            int[] mask = new int[]{32768, 8192, 128, 32};
            for (i = 0; i < 4; ++i) {
                if (0L != (this.left_samples_available & (long)mask[i])) continue;
                int status = left[this.intra4x4_pred_mode_cache[scan8[0] + 8 * i]];
                if (status < 0) {
                    return -1;
                }
                if (status == 0) continue;
                this.intra4x4_pred_mode_cache[H264Context.scan8[0] + 8 * i] = status;
            }
        }
        return 0;
    }

    public int ff_h264_check_intra_pred_mode(int mode) {
        int[] top = new int[]{4, 1, -1, -1, 0, 0, 0};
        int[] left = new int[]{5, -1, 2, -1, 6, 0, 0};
        if (mode > 6) {
            return -1;
        }
        if (0L == (this.top_samples_available & 0x8000L) && (mode = top[mode]) < 0) {
            return -1;
        }
        if ((this.left_samples_available & 0x8080L) != 32896L) {
            mode = left[mode];
            if (0L != (this.left_samples_available & 0x8080L)) {
                mode = 7 + ((this.left_samples_available & 0x8000L) == 0L ? 1 : 0) + 2 * (mode == 6 ? 1 : 0);
            }
            if (mode < 0) {
                return -1;
            }
        }
        return mode;
    }

    public void backup_mb_border(int[] src_y_base, int src_y_offset, int[] src_cb_base, int src_cb_offset, int[] src_cr_base, int src_cr_offset, int linesize, int uvlinesize, int simple) {
        int[] top_border_base = null;
        int top_border_offset = 0;
        int top_idx = 1;
        src_y_offset -= linesize;
        src_cb_offset -= uvlinesize;
        src_cr_offset -= uvlinesize;
        if (0 == simple && 0 != this.mb_aff_frame) {
            if ((this.s.mb_y & 1) != 0) {
                if (0 == this.mb_mbaff) {
                    top_border_base = this.top_borders[0][this.s.mb_x];
                    top_border_offset = 0;
                    System.arraycopy(src_y_base, src_y_offset + 15 * linesize, top_border_base, top_border_offset, 16);
                    System.arraycopy(src_cb_base, src_cb_offset + 7 * uvlinesize, top_border_base, top_border_offset + 16, 8);
                    System.arraycopy(src_cr_base, src_cr_offset + 7 * uvlinesize, top_border_base, top_border_offset + 24, 8);
                }
            } else if (0 != this.mb_mbaff) {
                top_idx = 0;
            } else {
                return;
            }
        }
        top_border_base = this.top_borders[top_idx][this.s.mb_x];
        top_border_offset = 0;
        System.arraycopy(src_y_base, src_y_offset + 16 * linesize, top_border_base, top_border_offset, 16);
        System.arraycopy(src_cb_base, src_cb_offset + 8 * uvlinesize, top_border_base, top_border_offset + 16, 8);
        System.arraycopy(src_cr_base, src_cr_offset + 8 * uvlinesize, top_border_base, top_border_offset + 24, 8);
    }

    public void xchg_mb_border(int[] src_y_base, int src_y_offset, int[] src_cb_base, int src_cb_offset, int[] src_cr_base, int src_cr_offset, int linesize, int uvlinesize, int xchg, int simple) {
        int deblock_top;
        int deblock_left;
        int top_idx = 1;
        int[] top_border_m1_base = null;
        int[] top_border_base = null;
        int top_border_m1_offset = 0;
        int top_border_offset = 0;
        if (0 == simple && 0 != this.mb_aff_frame) {
            if (0 != (this.s.mb_y & 1)) {
                if (0 == this.mb_mbaff) {
                    return;
                }
            } else {
                int n = top_idx = this.mb_mbaff != 0 ? 0 : 1;
            }
        }
        if (this.deblocking_filter == 2) {
            deblock_left = this.left_type[0];
            deblock_top = this.top_type;
        } else {
            deblock_left = this.s.mb_x > 0 ? 1 : 0;
            deblock_top = this.s.mb_y > (this.mb_field_decoding_flag != 0 ? 1 : 0) ? 1 : 0;
        }
        src_y_offset -= linesize + 1;
        src_cb_offset -= uvlinesize + 1;
        src_cr_offset -= uvlinesize + 1;
        top_border_m1_base = this.s.mb_x <= 0 ? null : this.top_borders[top_idx][this.s.mb_x - 1];
        top_border_base = this.top_borders[top_idx][this.s.mb_x];
        if (deblock_top != 0) {
            int tmp;
            int i;
            if (deblock_left != 0) {
                for (i = 0; i < 8; ++i) {
                    tmp = top_border_m1_base[top_border_m1_offset + 8 + i];
                    top_border_m1_base[top_border_m1_offset + 8 + i] = src_y_base[src_y_offset - 7 + i];
                    src_y_base[src_y_offset - 7 + i] = tmp;
                }
            }
            if (xchg != 0) {
                for (i = 0; i < 8; ++i) {
                    tmp = top_border_base[top_border_offset + 0 + i];
                    top_border_base[top_border_offset + 0 + i] = src_y_base[src_y_offset + 1 + i];
                    src_y_base[src_y_offset + 1 + i] = tmp;
                }
            } else {
                for (i = 0; i < 8; ++i) {
                    src_y_base[src_y_offset + 1 + i] = top_border_base[top_border_offset + 0 + i];
                }
            }
            for (i = 0; i < 8; ++i) {
                tmp = top_border_base[top_border_offset + 8 + i];
                top_border_base[top_border_offset + 8 + i] = src_y_base[src_y_offset + 9 + i];
                src_y_base[src_y_offset + 9 + i] = tmp;
            }
            if (this.s.mb_x + 1 < this.s.mb_width) {
                for (i = 0; i < 8; ++i) {
                    tmp = this.top_borders[top_idx][this.s.mb_x + 1][i];
                    this.top_borders[top_idx][this.s.mb_x + 1][i] = src_y_base[src_y_offset + 17 + i];
                    src_y_base[src_y_offset + 17 + i] = tmp;
                }
            }
            if (simple != 0) {
                if (deblock_left != 0) {
                    for (i = 0; i < 8; ++i) {
                        tmp = top_border_m1_base[top_border_m1_offset + 16 + i];
                        top_border_m1_base[top_border_m1_offset + 16 + i] = src_cb_base[src_cb_offset - 7 + i];
                        src_cb_base[src_cb_offset - 7 + i] = tmp;
                        tmp = top_border_m1_base[top_border_m1_offset + 24 + i];
                        top_border_m1_base[top_border_m1_offset + 24 + i] = src_cr_base[src_cr_offset - 7 + i];
                        src_cr_base[src_cr_offset - 7 + i] = tmp;
                    }
                }
                for (i = 0; i < 8; ++i) {
                    tmp = top_border_base[top_border_offset + 16 + i];
                    top_border_base[top_border_offset + 16 + i] = src_cb_base[src_cb_offset + 1 + i];
                    src_cb_base[src_cb_offset + 1 + i] = tmp;
                    tmp = top_border_base[top_border_offset + 24 + i];
                    top_border_base[top_border_offset + 24 + i] = src_cr_base[src_cr_offset + 1 + i];
                    src_cr_base[src_cr_offset + 1 + i] = tmp;
                }
            }
        }
    }

    public void hl_decode_mb_internal(int simple) {
        int i;
        int uvlinesize;
        int linesize;
        int mb_x = this.s.mb_x;
        int mb_y = this.s.mb_y;
        int mb_xy = this.mb_xy;
        int mb_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy];
        int[] block_offset_base = this.block_offset;
        int block_offset_offset = 0;
        boolean transform_bypass = 0 == simple && this.s.qscale == 0 && this.sps.transform_bypass != 0;
        boolean is_h264 = true;
        int[] dest_y_base = this.s.current_picture.data_base[0];
        int[] dest_cb_base = this.s.current_picture.data_base[1];
        int[] dest_cr_base = this.s.current_picture.data_base[2];
        int dest_y_offset = this.s.current_picture.data_offset[0] + (mb_x + mb_y * this.s.linesize) * 16;
        int dest_cb_offset = this.s.current_picture.data_offset[1] + (mb_x + mb_y * this.s.uvlinesize) * 8;
        int dest_cr_offset = this.s.current_picture.data_offset[2] + (mb_x + mb_y * this.s.uvlinesize) * 8;
        this.list_counts[mb_xy] = (int)this.list_count;
        if (0 == simple && 0 != this.mb_field_decoding_flag) {
            linesize = this.mb_linesize = this.s.linesize * 2;
            uvlinesize = this.mb_uvlinesize = this.s.uvlinesize * 2;
            block_offset_base = this.block_offset;
            block_offset_offset = 24;
            if ((mb_y & 1) != 0) {
                dest_y_offset -= this.s.linesize * 15;
                dest_cb_offset -= this.s.uvlinesize * 7;
                dest_cr_offset -= this.s.uvlinesize * 7;
            }
            if (0 != this.mb_aff_frame) {
                int list = 0;
                while ((long)list < this.list_count) {
                    if (0 != (mb_type & 12288 << 2 * list)) {
                        if (0 != (mb_type & 8)) {
                            int[] ref_base = this.ref_cache[list];
                            short ref_offset = scan8[0];
                            Rectangle.fill_rectangle_sign(ref_base, ref_offset, 4, 4, 8, 16 + ref_base[ref_offset] ^ this.s.mb_y & 1, 1);
                        } else {
                            for (i = 0; i < 16; i += 4) {
                                int ref = this.ref_cache[list][scan8[i]];
                                if (ref < 0) continue;
                                Rectangle.fill_rectangle_sign(this.ref_cache[list], scan8[i], 2, 2, 8, 16 + ref ^ this.s.mb_y & 1, 1);
                            }
                        }
                    }
                    ++list;
                }
            }
        } else {
            linesize = this.mb_linesize = this.s.linesize;
            uvlinesize = this.mb_uvlinesize = this.s.uvlinesize;
        }
        if (0 == simple && 0 != (mb_type & 4)) {
            int j;
            for (i = 0; i < 16; ++i) {
                for (j = 0; j < 8; ++j) {
                    short val = this.mb[i * 8];
                    dest_y_base[dest_y_offset + i * linesize + j * 2] = val & 0xFF;
                    dest_y_base[dest_y_offset + i * linesize + j * 2 + 1] = (val & 0xFF00) >> 8;
                }
            }
            for (i = 0; i < 8; ++i) {
                for (j = 0; j < 4; ++j) {
                    short val1 = this.mb[128 + i * 4];
                    short val2 = this.mb[160 + i * 4];
                    dest_cb_base[dest_cb_offset + i * uvlinesize + j * 2] = val1 & 0xFF;
                    dest_cb_base[dest_cb_offset + i * uvlinesize + j * 2 + 1] = (val1 & 0xFF00) >> 8;
                    dest_cr_base[dest_cr_offset + i * uvlinesize + j * 2] = val2 & 0xFF;
                    dest_cr_base[dest_cr_offset + i * uvlinesize + j * 2 + 1] = (val2 & 0xFF00) >> 8;
                }
            }
        } else {
            if (0 != (mb_type & 7)) {
                if (0 != this.deblocking_filter) {
                    this.xchg_mb_border(dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, linesize, uvlinesize, 1, simple);
                }
                this.hpc.pred8x8[this.chroma_pred_mode].pred8x8(dest_cb_base, dest_cb_offset, uvlinesize);
                this.hpc.pred8x8[this.chroma_pred_mode].pred8x8(dest_cr_base, dest_cr_offset, uvlinesize);
                if (0 != (mb_type & 1)) {
                    int dir;
                    if (0 == simple) {
                        // empty if block
                    }
                    if (0 != (mb_type & 0x1000000)) {
                        for (i = 0; i < 16; i += 4) {
                            int[] ptr_base = dest_y_base;
                            int ptr_offset = dest_y_offset + block_offset_base[block_offset_offset + i];
                            dir = this.intra4x4_pred_mode_cache[scan8[i]];
                            if (transform_bypass && this.sps.profile_idc == 244 && dir <= 1) {
                                this.hpc.pred8x8l_add[dir].pred8x8l_add(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                continue;
                            }
                            int nnz = this.non_zero_count_cache[scan8[i]];
                            this.hpc.pred8x8l[dir].pred8x8l(ptr_base, ptr_offset, (int)(this.topleft_samples_available << i) & 0x8000, (int)(this.topright_samples_available << i) & 0x4000, linesize);
                            if (0 == nnz) continue;
                            if (nnz == 1 && this.mb[i * 16] != 0) {
                                if (transform_bypass) {
                                    this.s.dsp.add_pixels8(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                    continue;
                                }
                                this.h264dsp.h264_idct8_dc_add(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                continue;
                            }
                            if (transform_bypass) {
                                this.s.dsp.add_pixels8(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                continue;
                            }
                            this.h264dsp.h264_idct8_add(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                        }
                    } else {
                        for (i = 0; i < 16; ++i) {
                            int[] ptr_base = dest_y_base;
                            int ptr_offset = dest_y_offset + block_offset_base[block_offset_offset + i];
                            dir = this.intra4x4_pred_mode_cache[scan8[i]];
                            if (transform_bypass && this.sps.profile_idc == 244 && dir <= 1) {
                                this.hpc.pred4x4_add[dir].pred4x4_add(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                continue;
                            }
                            int[] topright_base = null;
                            int topright_offset = 0;
                            if (dir == 3 || dir == 7) {
                                int topright_avail = (int)this.topright_samples_available << i & 0x8000;
                                if (0 == topright_avail) {
                                    int tr = ptr_base[ptr_offset + 3 - linesize];
                                    topright_base = new int[]{tr, tr, tr, tr};
                                    topright_offset = 0;
                                } else {
                                    topright_base = ptr_base;
                                    topright_offset = ptr_offset + 4 - linesize;
                                }
                            } else {
                                topright_base = null;
                            }
                            this.hpc.pred4x4[dir].pred4x4(ptr_base, ptr_offset, topright_base, topright_offset, linesize);
                            int nnz = this.non_zero_count_cache[scan8[i]];
                            if (0 == nnz || !is_h264) continue;
                            if (nnz == 1 && 0 != this.mb[i * 16]) {
                                if (transform_bypass) {
                                    this.s.dsp.add_pixels4(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                    continue;
                                }
                                this.h264dsp.h264_idct_dc_add(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                continue;
                            }
                            if (transform_bypass) {
                                this.s.dsp.add_pixels4(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                                continue;
                            }
                            this.h264dsp.h264_idct_add(ptr_base, ptr_offset, this.mb, i * 16, linesize);
                        }
                    }
                } else {
                    this.hpc.pred16x16[this.intra16x16_pred_mode].pred16x16(dest_y_base, dest_y_offset, linesize);
                    if (is_h264 && 0 != this.non_zero_count_cache[scan8[24]]) {
                        if (!transform_bypass) {
                            this.h264dsp.h264_luma_dc_dequant_idct(this.mb, 0, this.mb_luma_dc, 0, (int)this.dequant4_coeff[0][this.s.qscale][0]);
                        } else {
                            int[] dc_mapping = new int[]{0, 16, 64, 80, 32, 48, 96, 112, 128, 144, 192, 208, 160, 176, 224, 240};
                            for (i = 0; i < 16; ++i) {
                                this.mb[dc_mapping[i]] = this.mb_luma_dc[i];
                            }
                        }
                    }
                }
                if (0 != this.deblocking_filter) {
                    this.xchg_mb_border(dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, linesize, uvlinesize, 0, simple);
                }
            } else if (is_h264) {
                this.hl_motion(dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, this.s.me.qpel_put, this.s.dsp.put_h264_chroma_pixels_tab, this.s.me.qpel_avg, this.s.dsp.avg_h264_chroma_pixels_tab, this.h264dsp.weight_h264_pixels_tab, this.h264dsp.biweight_h264_pixels_tab);
            }
            if (0 == (mb_type & 1) && is_h264) {
                if (0 != (mb_type & 2)) {
                    if (transform_bypass) {
                        if (this.sps.profile_idc == 244 && (this.intra16x16_pred_mode == 2 || this.intra16x16_pred_mode == 1)) {
                            this.hpc.pred16x16_add[this.intra16x16_pred_mode].pred16x16_add(dest_y_base, dest_y_offset, block_offset_base, block_offset_offset, this.mb, 0, linesize);
                        } else {
                            for (i = 0; i < 16; ++i) {
                                if (0 == this.non_zero_count_cache[scan8[i]] && 0 == this.mb[i * 16]) continue;
                                this.s.dsp.add_pixels4(dest_y_base, dest_y_offset + block_offset_base[block_offset_offset + i], this.mb, i * 16, linesize);
                            }
                        }
                    } else {
                        this.h264dsp.h264_idct_add16intra(dest_y_base, dest_y_offset, block_offset_base, block_offset_offset, this.mb, 0, linesize, this.non_zero_count_cache);
                    }
                } else if (0 != (this.cbp & 0xF)) {
                    if (transform_bypass) {
                        int di = (mb_type & 0x1000000) != 0 ? 4 : 1;
                        for (i = 0; i < 16; i += di) {
                            if (0 == this.non_zero_count_cache[scan8[i]]) continue;
                            if ((mb_type & 0x1000000) != 0) {
                                this.s.dsp.add_pixels8(dest_y_base, dest_y_offset + block_offset_base[block_offset_offset + i], this.mb, i * 16, linesize);
                                continue;
                            }
                            this.s.dsp.add_pixels4(dest_y_base, dest_y_offset + block_offset_base[block_offset_offset + i], this.mb, i * 16, linesize);
                        }
                    } else if (0 != (mb_type & 0x1000000)) {
                        this.h264dsp.h264_idct8_add4(dest_y_base, dest_y_offset, block_offset_base, block_offset_offset, this.mb, 0, linesize, this.non_zero_count_cache);
                    } else {
                        this.h264dsp.h264_idct_add16(dest_y_base, dest_y_offset, block_offset_base, block_offset_offset, this.mb, 0, linesize, this.non_zero_count_cache);
                    }
                }
            }
            if (0 != (this.cbp & 0x30)) {
                int[][] dest_base = new int[][]{dest_cb_base, dest_cr_base};
                int[] dest_offset = new int[]{dest_cb_offset, dest_cr_offset};
                if (transform_bypass) {
                    if ((mb_type & 7) != 0 && this.sps.profile_idc == 244 && (this.chroma_pred_mode == 2 || this.chroma_pred_mode == 1)) {
                        this.hpc.pred8x8_add[this.chroma_pred_mode].pred8x8_add(dest_base[0], dest_offset[0], block_offset_base, block_offset_offset + 16, this.mb, 256, uvlinesize);
                        this.hpc.pred8x8_add[this.chroma_pred_mode].pred8x8_add(dest_base[1], dest_offset[1], block_offset_base, block_offset_offset + 20, this.mb, 320, uvlinesize);
                    } else {
                        for (i = 16; i < 24; ++i) {
                            if (0 == this.non_zero_count_cache[scan8[i]] && 0 == this.mb[i * 16]) continue;
                            this.s.dsp.add_pixels4(dest_base[(i & 4) >> 2], dest_offset[(i & 4) >> 2] + block_offset_base[block_offset_offset + i], this.mb, i * 16, uvlinesize);
                        }
                    }
                } else {
                    int chroma_qpu = (int)this.dequant4_coeff[(mb_type & 7) != 0 ? 1 : 4][this.chroma_qp[0]][0];
                    int chroma_qpv = (int)this.dequant4_coeff[(mb_type & 7) != 0 ? 2 : 5][this.chroma_qp[1]][0];
                    if (is_h264) {
                        if (0 != this.non_zero_count_cache[scan8[25]]) {
                            this.h264dsp.h264_chroma_dc_dequant_idct(this.mb, 256, this.mb_chroma_dc[0], 0, chroma_qpu);
                        }
                        if (0 != this.non_zero_count_cache[scan8[26]]) {
                            this.h264dsp.h264_chroma_dc_dequant_idct(this.mb, 320, this.mb_chroma_dc[1], 0, chroma_qpv);
                        }
                        this.h264dsp.h264_idct_add8(dest_base, dest_offset, block_offset_base, block_offset_offset, this.mb, 0, uvlinesize, this.non_zero_count_cache);
                    } else {
                        this.h264dsp.h264_chroma_dc_dequant_idct(this.mb, 256, this.mb_chroma_dc[0], 0, chroma_qpu);
                        this.h264dsp.h264_chroma_dc_dequant_idct(this.mb, 320, this.mb_chroma_dc[1], 0, chroma_qpv);
                    }
                }
            }
        }
        if (0 != this.cbp || 0 != (mb_type & 7)) {
            this.s.dsp.clear_blocks(this.mb);
        }
    }

    public void ff_h264_hl_decode_mb() {
        boolean is_complex;
        int mb_xy = this.mb_xy;
        int mb_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy];
        boolean bl = is_complex = this.is_complex != 0 || (mb_type & 4) != 0 || this.s.qscale == 0;
        if (is_complex) {
            this.hl_decode_mb_internal(0);
        } else {
            this.hl_decode_mb_internal(1);
        }
    }

    public void decode_mb_skip() {
        int mb_xy = this.mb_xy;
        int mb_type = 0;
        Arrays.fill(this.non_zero_count[mb_xy], 0);
        Arrays.fill(this.non_zero_count_cache, 8, this.non_zero_count_cache.length, 0);
        if (this.mb_field_decoding_flag > 0) {
            mb_type |= 0x80;
        }
        if (this.slice_type_nos == 3) {
            mb_type |= 0xF900;
            if (this.direct_spatial_mv_pred != 0) {
                this.fill_decode_neighbors(mb_type);
                this.fill_decode_caches(mb_type);
            }
            mb_type = this.ff_h264_pred_direct_motion(mb_type);
            mb_type |= 0x800;
        } else {
            int mx = 0;
            int my = 0;
            this.fill_decode_neighbors(mb_type |= 0x3808);
            this.fill_decode_caches(mb_type);
            int[] mxmy = new int[]{mx, my};
            this.pred_pskip_motion(mxmy);
            mx = mxmy[0];
            my = mxmy[1];
            Rectangle.fill_rectangle_sign(this.ref_cache[0], scan8[0], 4, 4, 8, 0, 1);
            Rectangle.fill_rectangle_mv_cache(this.mv_cache[0], scan8[0], 4, 4, 8, H264Context.pack16to32(mx, my), 4);
        }
        this.write_back_motion(mb_type);
        this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy] = mb_type;
        this.s.current_picture.qscale_table[mb_xy] = this.s.qscale;
        this.slice_table_base[this.slice_table_offset + mb_xy] = this.slice_num;
        this.prev_mb_skipped = 1;
    }

    public int get_cabac_cbf_ctx(int cat, int idx, int is_dc) {
        int nzb;
        int nza;
        int ctx = 0;
        if (is_dc != 0) {
            if (cat == 0) {
                nza = this.left_cbp & 0x100;
                nzb = this.top_cbp & 0x100;
            } else {
                nza = this.left_cbp >> 6 + (idx -= 25) & 1;
                nzb = this.top_cbp >> 6 + idx & 1;
            }
        } else {
            nza = this.non_zero_count_cache[scan8[idx] - 1];
            nzb = this.non_zero_count_cache[scan8[idx] - 8];
        }
        if (nza > 0) {
            ++ctx;
        }
        if (nzb > 0) {
            ctx += 2;
        }
        return ctx + 4 * cat;
    }

    public int get_dct8x8_allowed() {
        if (0 != this.sps.direct_8x8_inference_flag) {
            for (int i = 0; i < 4; ++i) {
                if ((this.sub_mb_type[i] & 0x70) == 0) continue;
                return 0;
            }
            return 1;
        }
        for (int i = 0; i < 4; ++i) {
            if ((this.sub_mb_type[i] & 0x170) == 0) continue;
            return 0;
        }
        return 1;
    }

    public void decode_cabac_residual_internal(short[] block, int block_offset, int cat, int n, int[] scantable, int scan_offset, long[] qmul, int max_coeff, int is_dc) {
        int last;
        int[] index = new int[64];
        int coeff_count = 0;
        int node_ctx = 0;
        int significant_coeff_ctx_base_offset = significant_coeff_flag_offset[this.mb_field_decoding_flag][cat];
        int last_coeff_ctx_base_offset = last_coeff_flag_offset[this.mb_field_decoding_flag][cat];
        int abs_level_m1_ctx_base_offset = coeff_abs_level_m1_offset[cat];
        if (is_dc == 0 && cat == 5) {
            short[] sig_off = significant_coeff_flag_offset_8x8[this.mb_field_decoding_flag];
            for (last = 0; last < 63; ++last) {
                int sig_ctx_offset = significant_coeff_ctx_base_offset + sig_off[last];
                if (this.cabac.get_cabac(this.cabac_state, sig_ctx_offset) == 0) continue;
                int last_ctx_offset = last_coeff_ctx_base_offset + last_coeff_flag_offset_8x8[last];
                index[coeff_count++] = last;
                if (this.cabac.get_cabac(this.cabac_state, last_ctx_offset) == 0) continue;
                last = max_coeff;
                break;
            }
            if (last == max_coeff - 1) {
                index[coeff_count++] = last;
            }
        } else {
            for (last = 0; last < max_coeff - 1; ++last) {
                int sig_ctx_offset = significant_coeff_ctx_base_offset + last;
                if (this.cabac.get_cabac(this.cabac_state, sig_ctx_offset) == 0) continue;
                int last_ctx_offset = last_coeff_ctx_base_offset + last;
                index[coeff_count++] = last;
                if (this.cabac.get_cabac(this.cabac_state, last_ctx_offset) == 0) continue;
                last = max_coeff;
                break;
            }
            if (last == max_coeff - 1) {
                index[coeff_count++] = last;
            }
        }
        if (is_dc != 0) {
            if (cat == 0) {
                int n2 = this.mb_xy;
                this.cbp_table[n2] = this.cbp_table[n2] | 0x100;
            } else {
                int n3 = this.mb_xy;
                this.cbp_table[n3] = this.cbp_table[n3] | 64 << n - 25;
            }
            this.non_zero_count_cache[H264Context.scan8[n]] = coeff_count;
        } else if (cat == 5) {
            Rectangle.fill_rectangle_unsign(this.non_zero_count_cache, scan8[n], 2, 2, 8, coeff_count, 1);
        } else {
            this.non_zero_count_cache[H264Context.scan8[n]] = coeff_count;
        }
        do {
            int coeff_abs;
            int ctx_offset = coeff_abs_level1_ctx[node_ctx] + abs_level_m1_ctx_base_offset;
            int j = scantable[scan_offset + index[--coeff_count]];
            if (this.cabac.get_cabac(this.cabac_state, ctx_offset) == 0) {
                node_ctx = coeff_abs_level_transition[0][node_ctx];
                if (is_dc != 0) {
                    block[block_offset + j] = (short)this.cabac.get_cabac_bypass_sign(-1);
                    continue;
                }
                block[block_offset + j] = (short)(this.cabac.get_cabac_bypass_sign((int)(-qmul[j])) + 32 >> 6);
                continue;
            }
            ctx_offset = coeff_abs_levelgt1_ctx[node_ctx] + abs_level_m1_ctx_base_offset;
            node_ctx = coeff_abs_level_transition[1][node_ctx];
            for (coeff_abs = 2; coeff_abs < 15 && this.cabac.get_cabac(this.cabac_state, ctx_offset) != 0; ++coeff_abs) {
            }
            if (coeff_abs >= 15) {
                int k = 0;
                while (this.cabac.get_cabac_bypass() != 0) {
                    ++k;
                }
                coeff_abs = 1;
                while (k-- != 0) {
                    coeff_abs += coeff_abs + this.cabac.get_cabac_bypass();
                }
                coeff_abs += 14;
            }
            block[block_offset + j] = is_dc != 0 ? (short)this.cabac.get_cabac_bypass_sign(-coeff_abs) : (short)((long)this.cabac.get_cabac_bypass_sign(-coeff_abs) * qmul[j] + 32L >> 6);
        } while (coeff_count != 0);
    }

    public void decode_cabac_residual_dc_internal(short[] block, int block_offset, int cat, int n, int[] scantable, int scan_offset, int max_coeff) {
        this.decode_cabac_residual_internal(block, block_offset, cat, n, scantable, scan_offset, null, max_coeff, 1);
    }

    public void decode_cabac_residual_nondc_internal(short[] block, int block_offset, int cat, int n, int[] scantable, int scan_offset, long[] qmul, int max_coeff) {
        this.decode_cabac_residual_internal(block, block_offset, cat, n, scantable, scan_offset, qmul, max_coeff, 0);
    }

    public void decode_cabac_residual_dc(short[] block, int block_offset, int cat, int n, int[] scantable, int scan_offset, int max_coeff) {
        if (this.cabac.get_cabac(this.cabac_state, 85 + this.get_cabac_cbf_ctx(cat, n, 1)) == 0) {
            this.non_zero_count_cache[H264Context.scan8[n]] = 0;
            return;
        }
        this.decode_cabac_residual_dc_internal(block, block_offset, cat, n, scantable, scan_offset, max_coeff);
    }

    public void decode_cabac_residual_nondc(short[] block, int block_offset, int cat, int n, int[] scantable, int scan_offset, long[] qmul, int max_coeff) {
        if (cat != 5 && this.cabac.get_cabac(this.cabac_state, 85 + this.get_cabac_cbf_ctx(cat, n, 0)) == 0) {
            this.non_zero_count_cache[H264Context.scan8[n]] = 0;
            return;
        }
        this.decode_cabac_residual_nondc_internal(block, block_offset, cat, n, scantable, scan_offset, qmul, max_coeff);
    }

    public int ff_h264_decode_mb_cabac() {
        int i;
        int amvd1;
        int amvd0;
        int mpy;
        int my;
        int mx;
        int ref;
        int list;
        int i2;
        int mb_type;
        int skip;
        short partition_count = 0;
        int cbp = 0;
        int dct8x8_allowed = this.pps.transform_8x8_mode;
        int mb_xy = this.mb_xy = this.s.mb_x + this.s.mb_y * this.s.mb_stride;
        if (this.slice_type_nos != 1 && (skip = this.mb_mbaff != 0 && (this.s.mb_y & 1) == 1 && this.prev_mb_skipped != 0 ? this.next_mb_skipped : this.cabac.decode_cabac_mb_skip(this, this.s.mb_x, this.s.mb_y)) != 0) {
            if (this.mb_mbaff != 0 && (this.s.mb_y & 1) == 0) {
                this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy] = 2048L;
                this.next_mb_skipped = this.cabac.decode_cabac_mb_skip(this, this.s.mb_x, this.s.mb_y + 1);
                if (0 == this.next_mb_skipped) {
                    this.mb_mbaff = this.mb_field_decoding_flag = this.cabac.decode_cabac_field_decoding_flag(this);
                }
            }
            this.decode_mb_skip();
            this.cbp_table[mb_xy] = 0;
            this.chroma_pred_mode_table[mb_xy] = 0;
            this.last_qscale_diff = 0;
            return 0;
        }
        if (this.mb_mbaff != 0 && (this.s.mb_y & 1) == 0) {
            this.mb_mbaff = this.mb_field_decoding_flag = this.cabac.decode_cabac_field_decoding_flag(this);
        }
        this.prev_mb_skipped = 0;
        this.fill_decode_neighbors(-this.mb_field_decoding_flag);
        if (this.slice_type_nos == 3) {
            int ctx = 0;
            if (0 == (this.left_type[0] - 1 & 0x100)) {
                ++ctx;
            }
            if (0 == (this.top_type - 1 & 0x100)) {
                ++ctx;
            }
            boolean goto_decode_intra_mb = false;
            if (0 == this.cabac.get_cabac_noinline(this.cabac_state, 27 + ctx)) {
                mb_type = 0;
            } else if (0 == this.cabac.get_cabac_noinline(this.cabac_state, 30)) {
                mb_type = 1 + this.cabac.get_cabac_noinline(this.cabac_state, 32);
            } else {
                int bits = this.cabac.get_cabac_noinline(this.cabac_state, 31) << 3;
                bits += this.cabac.get_cabac_noinline(this.cabac_state, 32) << 2;
                bits += this.cabac.get_cabac_noinline(this.cabac_state, 32) << 1;
                if ((bits += this.cabac.get_cabac_noinline(this.cabac_state, 32)) < 8) {
                    mb_type = bits + 3;
                } else if (bits == 13) {
                    mb_type = this.cabac.decode_cabac_intra_mb_type(this, 32, 0);
                    goto_decode_intra_mb = true;
                    partition_count = 0;
                    cbp = H264Data.i_mb_type_info[mb_type].cbp;
                    this.intra16x16_pred_mode = H264Data.i_mb_type_info[mb_type].pred_mode;
                    mb_type = H264Data.i_mb_type_info[mb_type].type;
                } else if (bits == 14) {
                    mb_type = 11;
                } else if (bits == 15) {
                    mb_type = 22;
                } else {
                    bits = (bits << 1) + this.cabac.get_cabac_noinline(this.cabac_state, 32);
                    mb_type = bits - 4;
                }
            }
            if (!goto_decode_intra_mb) {
                partition_count = H264Data.b_mb_type_info[mb_type].partition_count;
                mb_type = H264Data.b_mb_type_info[mb_type].type;
            }
        } else if (this.slice_type_nos == 2) {
            if (this.cabac.get_cabac_noinline(this.cabac_state, 14) == 0) {
                mb_type = this.cabac.get_cabac_noinline(this.cabac_state, 15) == 0 ? 3 * this.cabac.get_cabac_noinline(this.cabac_state, 16) : 2 - this.cabac.get_cabac_noinline(this.cabac_state, 17);
                partition_count = H264Data.p_mb_type_info[mb_type].partition_count;
                mb_type = H264Data.p_mb_type_info[mb_type].type;
            } else {
                mb_type = this.cabac.decode_cabac_intra_mb_type(this, 17, 0);
                partition_count = 0;
                cbp = H264Data.i_mb_type_info[mb_type].cbp;
                this.intra16x16_pred_mode = H264Data.i_mb_type_info[mb_type].pred_mode;
                mb_type = H264Data.i_mb_type_info[mb_type].type;
            }
        } else {
            mb_type = this.cabac.decode_cabac_intra_mb_type(this, 3, 1);
            if (this.slice_type == 5 && mb_type != 0) {
                --mb_type;
            }
            partition_count = 0;
            cbp = H264Data.i_mb_type_info[mb_type].cbp;
            this.intra16x16_pred_mode = H264Data.i_mb_type_info[mb_type].pred_mode;
            mb_type = H264Data.i_mb_type_info[mb_type].type;
        }
        if (this.mb_field_decoding_flag != 0) {
            mb_type |= 0x80;
        }
        this.slice_table_base[this.slice_table_offset + mb_xy] = this.slice_num;
        if ((mb_type & 4) != 0) {
            int i3;
            int ptr_offset = this.cabac.bytestream_current;
            int[] ptr = this.cabac.bytestream;
            if ((this.cabac.low & 1) != 0) {
                --ptr_offset;
            }
            if ((this.cabac.low & 0x1FF) != 0) {
                --ptr_offset;
            }
            for (i3 = 0; i3 < 128; ++i3) {
                this.mb[i3] = (short)((ptr[ptr_offset + 1] & 0xFF) << 8 | ptr[ptr_offset] & 0xFF);
                ptr_offset += 2;
            }
            if (this.sps.chroma_format_idc != 0) {
                for (i3 = 0; i3 < 64; ++i3) {
                    this.mb[128 + i3] = (short)((ptr[ptr_offset + 1] & 0xFF) << 8 | ptr[ptr_offset] & 0xFF);
                    ptr_offset += 2;
                }
            }
            this.cabac.ff_init_cabac_decoder(ptr, ptr_offset, this.cabac.bytestream_end - ptr_offset);
            this.cbp_table[mb_xy] = 495;
            this.chroma_pred_mode_table[mb_xy] = 0;
            this.s.current_picture.qscale_table[mb_xy] = 0;
            Arrays.fill(this.non_zero_count[mb_xy], 16);
            this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy] = mb_type;
            this.last_qscale_diff = 0;
            return 0;
        }
        if (this.mb_mbaff != 0) {
            this.ref_count[0] = this.ref_count[0] << 1;
            this.ref_count[1] = this.ref_count[1] << 1;
        }
        this.fill_decode_caches(mb_type);
        if ((mb_type & 7) != 0) {
            if ((mb_type & 1) != 0) {
                int pred;
                if (dct8x8_allowed != 0 && this.cabac.get_cabac_noinline(this.cabac_state, 399 + this.neighbor_transform_size) != 0) {
                    mb_type |= 0x1000000;
                    for (i2 = 0; i2 < 16; i2 += 4) {
                        pred = this.pred_intra_mode(i2);
                        int mode = this.cabac.decode_cabac_mb_intra4x4_pred_mode(this, pred);
                        Rectangle.fill_rectangle_sign(this.intra4x4_pred_mode_cache, scan8[i2], 2, 2, 8, mode, 1);
                    }
                } else {
                    for (i2 = 0; i2 < 16; ++i2) {
                        pred = this.pred_intra_mode(i2);
                        this.intra4x4_pred_mode_cache[H264Context.scan8[i2]] = (byte)this.cabac.decode_cabac_mb_intra4x4_pred_mode(this, pred);
                    }
                }
                this.ff_h264_write_back_intra_pred_mode();
                if (this.ff_h264_check_intra4x4_pred_mode() < 0) {
                    return -1;
                }
            } else {
                this.intra16x16_pred_mode = this.ff_h264_check_intra_pred_mode(this.intra16x16_pred_mode);
                if (this.intra16x16_pred_mode < 0) {
                    return -1;
                }
            }
            if (this.sps.chroma_format_idc != 0) {
                int pred_mode;
                this.chroma_pred_mode_table[mb_xy] = pred_mode = this.cabac.decode_cabac_mb_chroma_pre_mode(this);
                if ((pred_mode = this.ff_h264_check_intra_pred_mode(pred_mode)) < 0) {
                    return -1;
                }
                this.chroma_pred_mode = pred_mode;
            }
        } else if (partition_count == 4) {
            int[] sub_partition_count = new int[4];
            int[][] ref2 = new int[2][4];
            if (this.slice_type_nos == 3) {
                for (i2 = 0; i2 < 4; ++i2) {
                    this.sub_mb_type[i2] = this.cabac.decode_cabac_b_mb_sub_type(this);
                    sub_partition_count[i2] = H264Data.b_sub_mb_type_info[this.sub_mb_type[i2]].partition_count;
                    this.sub_mb_type[i2] = H264Data.b_sub_mb_type_info[this.sub_mb_type[i2]].type;
                }
                if (((this.sub_mb_type[0] | this.sub_mb_type[1] | this.sub_mb_type[2] | this.sub_mb_type[3]) & 0x100) != 0) {
                    mb_type = this.ff_h264_pred_direct_motion(mb_type);
                    this.ref_cache[1][H264Context.scan8[12]] = -2;
                    this.ref_cache[0][H264Context.scan8[12]] = -2;
                    this.ref_cache[1][H264Context.scan8[4]] = -2;
                    this.ref_cache[0][H264Context.scan8[4]] = -2;
                    for (i2 = 0; i2 < 4; ++i2) {
                        Rectangle.fill_rectangle_unsign(this.direct_cache, scan8[4 * i2], 2, 2, 8, this.sub_mb_type[i2] >> 1 & 0xFF, 1);
                    }
                }
            } else {
                for (i2 = 0; i2 < 4; ++i2) {
                    this.sub_mb_type[i2] = this.cabac.decode_cabac_p_mb_sub_type(this);
                    sub_partition_count[i2] = H264Data.p_sub_mb_type_info[this.sub_mb_type[i2]].partition_count;
                    this.sub_mb_type[i2] = H264Data.p_sub_mb_type_info[this.sub_mb_type[i2]].type;
                }
            }
            int list2 = 0;
            while ((long)list2 < this.list_count) {
                for (i2 = 0; i2 < 4; ++i2) {
                    if ((this.sub_mb_type[i2] & 0x100) != 0) continue;
                    if ((this.sub_mb_type[i2] & 4096 << 0 + 2 * list2) != 0) {
                        if (this.ref_count[list2] > 1L) {
                            ref2[list2][i2] = this.cabac.decode_cabac_mb_ref(this, list2, 4 * i2);
                            if (ref2[list2][i2] >= (int)this.ref_count[list2]) {
                                return -1;
                            }
                        } else {
                            ref2[list2][i2] = 0;
                        }
                    } else {
                        ref2[list2][i2] = -1;
                    }
                    int n = ref2[list2][i2];
                    this.ref_cache[list2][H264Context.scan8[4 * i2] + 9] = n;
                    this.ref_cache[list2][H264Context.scan8[4 * i2] + 8] = n;
                    this.ref_cache[list2][H264Context.scan8[4 * i2] + 1] = n;
                }
                ++list2;
            }
            if (dct8x8_allowed != 0) {
                dct8x8_allowed = this.get_dct8x8_allowed();
            }
            list2 = 0;
            while ((long)list2 < this.list_count) {
                for (i2 = 0; i2 < 4; ++i2) {
                    this.ref_cache[list2][H264Context.scan8[4 * i2]] = this.ref_cache[list2][scan8[4 * i2] + 1];
                    if ((this.sub_mb_type[i2] & 0x100) != 0) {
                        Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list2], scan8[4 * i2], 2, 2, 8, 0, 2);
                        continue;
                    }
                    if ((this.sub_mb_type[i2] & 4096 << 0 + 2 * list2) != 0 && (this.sub_mb_type[i2] & 0x100) == 0) {
                        int sub_mb_type = this.sub_mb_type[i2];
                        int block_width = (sub_mb_type & 0x18) != 0 ? 2 : 1;
                        for (int j = 0; j < sub_partition_count[i2]; ++j) {
                            int mpx = 0;
                            int mpy2 = 0;
                            int mx2 = 0;
                            int my2 = 0;
                            int index = 4 * i2 + block_width * j;
                            int[][] mv_cache_base = this.mv_cache[list2];
                            short mv_cache_offset = scan8[index];
                            int[][] mvd_cache_base = this.mvd_cache[list2];
                            short mvd_cache_offset = scan8[index];
                            int[] args = new int[]{mx2, my2};
                            this.pred_motion(index, block_width, list2, this.ref_cache[list2][scan8[index]], args);
                            mx2 = args[0];
                            my2 = args[1];
                            int amvd02 = this.mvd_cache[list2][scan8[index] - 1][0] + this.mvd_cache[list2][scan8[index] - 8][0];
                            int amvd12 = this.mvd_cache[list2][scan8[index] - 1][1] + this.mvd_cache[list2][scan8[index] - 8][1];
                            args[0] = mpx;
                            mx2 += this.cabac.decode_cabac_mb_mvd(this, 40, amvd02, args);
                            mpx = args[0];
                            args[0] = mpy2;
                            my2 += this.cabac.decode_cabac_mb_mvd(this, 47, amvd12, args);
                            mpy2 = args[0];
                            if ((sub_mb_type & 8) != 0) {
                                int n = mx2;
                                mv_cache_base[mv_cache_offset + 9][0] = n;
                                mv_cache_base[mv_cache_offset + 8][0] = n;
                                mv_cache_base[mv_cache_offset + 1][0] = n;
                                int n2 = my2;
                                mv_cache_base[mv_cache_offset + 9][1] = n2;
                                mv_cache_base[mv_cache_offset + 8][1] = n2;
                                mv_cache_base[mv_cache_offset + 1][1] = n2;
                                int n3 = mpx;
                                mvd_cache_base[mvd_cache_offset + 9][0] = n3;
                                mvd_cache_base[mvd_cache_offset + 8][0] = n3;
                                mvd_cache_base[mvd_cache_offset + 1][0] = n3;
                                int n4 = mpy2;
                                mvd_cache_base[mvd_cache_offset + 9][1] = n4;
                                mvd_cache_base[mvd_cache_offset + 8][1] = n4;
                                mvd_cache_base[mvd_cache_offset + 1][1] = n4;
                            } else if ((sub_mb_type & 0x10) != 0) {
                                mv_cache_base[mv_cache_offset + 1][0] = mx2;
                                mv_cache_base[mv_cache_offset + 1][1] = my2;
                                mvd_cache_base[mvd_cache_offset + 1][0] = mpx;
                                mvd_cache_base[mvd_cache_offset + 1][1] = mpy2;
                            } else if ((sub_mb_type & 0x20) != 0) {
                                mv_cache_base[mv_cache_offset + 8][0] = mx2;
                                mv_cache_base[mv_cache_offset + 8][1] = my2;
                                mvd_cache_base[mvd_cache_offset + 8][0] = mpx;
                                mvd_cache_base[mvd_cache_offset + 8][1] = mpy2;
                            }
                            mv_cache_base[mv_cache_offset + 0][0] = mx2;
                            mv_cache_base[mv_cache_offset + 0][1] = my2;
                            mvd_cache_base[mvd_cache_offset + 0][0] = mpx;
                            mvd_cache_base[mvd_cache_offset + 0][1] = mpy2;
                        }
                        continue;
                    }
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[list2], scan8[4 * i2], 2, 2, 8, 0, 4);
                    Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list2], scan8[4 * i2], 2, 2, 8, 0, 2);
                }
                ++list2;
            }
        } else if ((mb_type & 0x100) != 0) {
            mb_type = this.ff_h264_pred_direct_motion(mb_type);
            Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[0], scan8[0], 4, 4, 8, 0, 2);
            Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[1], scan8[0], 4, 4, 8, 0, 2);
            dct8x8_allowed &= this.sps.direct_8x8_inference_flag;
        } else if ((mb_type & 8) != 0) {
            list = 0;
            while ((long)list < this.list_count) {
                if ((mb_type & 4096 << 0 + 2 * list) != 0) {
                    if (this.ref_count[list] > 1L) {
                        ref = this.cabac.decode_cabac_mb_ref(this, list, 0);
                        if (ref >= (int)this.ref_count[list]) {
                            return -1;
                        }
                    } else {
                        ref = 0;
                    }
                    Rectangle.fill_rectangle_sign(this.ref_cache[list], scan8[0], 4, 4, 8, ref, 1);
                }
                ++list;
            }
            list = 0;
            while ((long)list < this.list_count) {
                if ((mb_type & 4096 << 0 + 2 * list) != 0) {
                    mx = 0;
                    my = 0;
                    int mpx = 0;
                    mpy = 0;
                    int[] args = new int[]{mx, my};
                    this.pred_motion(0, 4, list, this.ref_cache[list][scan8[0]], args);
                    mx = args[0];
                    my = args[1];
                    amvd0 = this.mvd_cache[list][scan8[0] - 1][0] + this.mvd_cache[list][scan8[0] - 8][0];
                    amvd1 = this.mvd_cache[list][scan8[0] - 1][1] + this.mvd_cache[list][scan8[0] - 8][1];
                    args[0] = mpx;
                    mpx = args[0];
                    args[0] = mpy;
                    mpy = args[0];
                    Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list], scan8[0], 4, 4, 8, H264Context.pack8to16(mpx, mpy), 2);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[list], scan8[0], 4, 4, 8, H264Context.pack16to32(mx += this.cabac.decode_cabac_mb_mvd(this, 40, amvd0, args), my += this.cabac.decode_cabac_mb_mvd(this, 47, amvd1, args)), 4);
                }
                ++list;
            }
        } else if ((mb_type & 0x10) != 0) {
            list = 0;
            while ((long)list < this.list_count) {
                for (i = 0; i < 2; ++i) {
                    if ((mb_type & 4096 << i + 2 * list) != 0) {
                        if (this.ref_count[list] > 1L) {
                            ref = this.cabac.decode_cabac_mb_ref(this, list, 8 * i);
                            if (ref >= (int)this.ref_count[list]) {
                                return -1;
                            }
                        } else {
                            ref = 0;
                        }
                        Rectangle.fill_rectangle_sign(this.ref_cache[list], scan8[0] + 16 * i, 4, 2, 8, ref, 1);
                        continue;
                    }
                    Rectangle.fill_rectangle_sign(this.ref_cache[list], scan8[0] + 16 * i, 4, 2, 8, -1, 1);
                }
                ++list;
            }
            list = 0;
            while ((long)list < this.list_count) {
                for (i = 0; i < 2; ++i) {
                    if ((mb_type & 4096 << i + 2 * list) != 0) {
                        mx = 0;
                        my = 0;
                        int mpx = 0;
                        mpy = 0;
                        int[] args = new int[]{mx, my};
                        this.pred_16x8_motion(8 * i, list, this.ref_cache[list][scan8[0] + 16 * i], args);
                        mx = args[0];
                        my = args[1];
                        amvd0 = this.mvd_cache[list][scan8[8 * i] - 1][0] + this.mvd_cache[list][scan8[8 * i] - 8][0];
                        amvd1 = this.mvd_cache[list][scan8[8 * i] - 1][1] + this.mvd_cache[list][scan8[8 * i] - 8][1];
                        args[0] = mpx;
                        mpx = args[0];
                        args[0] = mpy;
                        mpy = args[0];
                        Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list], scan8[0] + 16 * i, 4, 2, 8, H264Context.pack8to16(mpx, mpy), 2);
                        Rectangle.fill_rectangle_mv_cache(this.mv_cache[list], scan8[0] + 16 * i, 4, 2, 8, H264Context.pack16to32(mx += this.cabac.decode_cabac_mb_mvd(this, 40, amvd0, args), my += this.cabac.decode_cabac_mb_mvd(this, 47, amvd1, args)), 4);
                        continue;
                    }
                    Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list], scan8[0] + 16 * i, 4, 2, 8, 0, 2);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[list], scan8[0] + 16 * i, 4, 2, 8, 0, 4);
                }
                ++list;
            }
        } else {
            list = 0;
            while ((long)list < this.list_count) {
                for (i = 0; i < 2; ++i) {
                    if ((mb_type & 4096 << i + 2 * list) != 0) {
                        if (this.ref_count[list] > 1L) {
                            ref = this.cabac.decode_cabac_mb_ref(this, list, 4 * i);
                            if (ref >= (int)this.ref_count[list]) {
                                return -1;
                            }
                        } else {
                            ref = 0;
                        }
                        Rectangle.fill_rectangle_sign(this.ref_cache[list], scan8[0] + 2 * i, 2, 4, 8, ref, 1);
                        continue;
                    }
                    Rectangle.fill_rectangle_sign(this.ref_cache[list], scan8[0] + 2 * i, 2, 4, 8, -1, 1);
                }
                ++list;
            }
            list = 0;
            while ((long)list < this.list_count) {
                for (i = 0; i < 2; ++i) {
                    if ((mb_type & 4096 << i + 2 * list) != 0) {
                        mx = 0;
                        my = 0;
                        int mpx = 0;
                        mpy = 0;
                        int[] args = new int[]{mx, my};
                        this.pred_8x16_motion(i * 4, list, this.ref_cache[list][scan8[0] + 2 * i], args);
                        mx = args[0];
                        my = args[1];
                        amvd0 = this.mvd_cache[list][scan8[4 * i] - 1][0] + this.mvd_cache[list][scan8[4 * i] - 8][0];
                        amvd1 = this.mvd_cache[list][scan8[4 * i] - 1][1] + this.mvd_cache[list][scan8[4 * i] - 8][1];
                        args[0] = mpx;
                        mpx = args[0];
                        args[0] = mpy;
                        mpy = args[0];
                        Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list], scan8[0] + 2 * i, 2, 4, 8, H264Context.pack8to16(mpx, mpy), 2);
                        Rectangle.fill_rectangle_mv_cache(this.mv_cache[list], scan8[0] + 2 * i, 2, 4, 8, H264Context.pack16to32(mx += this.cabac.decode_cabac_mb_mvd(this, 40, amvd0, args), my += this.cabac.decode_cabac_mb_mvd(this, 47, amvd1, args)), 4);
                        continue;
                    }
                    Rectangle.fill_rectangle_mvd_cache(this.mvd_cache[list], scan8[0] + 2 * i, 2, 4, 8, 0, 2);
                    Rectangle.fill_rectangle_mv_cache(this.mv_cache[list], scan8[0] + 2 * i, 2, 4, 8, 0, 4);
                }
                ++list;
            }
        }
        if ((mb_type & 0x78) != 0) {
            this.chroma_pred_mode_table[mb_xy] = 0;
            this.write_back_motion(mb_type);
        }
        if ((mb_type & 2) == 0) {
            cbp = this.cabac.decode_cabac_mb_cbp_luma(this);
            if (this.sps.chroma_format_idc != 0) {
                cbp |= this.cabac.decode_cabac_mb_cbp_chroma(this) << 4;
            }
        }
        this.cbp_table[mb_xy] = this.cbp = cbp;
        if (dct8x8_allowed != 0 && (cbp & 0xF) != 0 && (mb_type & 7) == 0) {
            mb_type |= 0x1000000 * this.cabac.get_cabac_noinline(this.cabac_state, 399 + this.neighbor_transform_size);
        }
        this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy] = mb_type;
        if (cbp != 0 || (mb_type & 2) != 0) {
            int c;
            int[] scan;
            int[] scan8x8;
            if ((mb_type & 0x80) != 0) {
                scan8x8 = this.s.qscale != 0 ? this.field_scan8x8 : this.field_scan8x8_q0;
                scan = this.s.qscale != 0 ? this.field_scan : this.field_scan_q0;
            } else {
                scan8x8 = this.s.qscale != 0 ? this.zigzag_scan8x8 : this.zigzag_scan8x8_q0;
                scan = this.s.qscale != 0 ? this.zigzag_scan : this.zigzag_scan_q0;
            }
            if (this.cabac.get_cabac_noinline(this.cabac_state, 60 + (this.last_qscale_diff != 0 ? 1 : 0)) != 0) {
                int val = 1;
                int ctx = 2;
                while (this.cabac.get_cabac_noinline(this.cabac_state, 60 + ctx) != 0) {
                    ctx = 3;
                    if (++val <= 102) continue;
                    return -1;
                }
                val = (val & 1) != 0 ? val + 1 >> 1 : -(val + 1 >> 1);
                this.last_qscale_diff = val;
                this.s.qscale += val;
                if (this.s.qscale > 51 || this.s.qscale < 0) {
                    this.s.qscale = this.s.qscale < 0 ? (this.s.qscale += 52) : (this.s.qscale -= 52);
                }
                this.chroma_qp[0] = this.pps.chroma_qp_table[0][this.s.qscale];
                this.chroma_qp[1] = this.pps.chroma_qp_table[1][this.s.qscale];
            } else {
                this.last_qscale_diff = 0;
            }
            if ((mb_type & 2) != 0) {
                Arrays.fill(this.mb_luma_dc, 0, 16, (short)0);
                this.decode_cabac_residual_dc(this.mb_luma_dc, 0, 0, 24, scan, 0, 16);
                if ((cbp & 0xF) != 0) {
                    long[] qmul = this.dequant4_coeff[0][this.s.qscale];
                    for (int i4 = 0; i4 < 16; ++i4) {
                        this.decode_cabac_residual_nondc(this.mb, 16 * i4, 1, i4, scan, 1, qmul, 15);
                    }
                } else {
                    Rectangle.fill_rectangle_unsign(this.non_zero_count_cache, scan8[0], 4, 4, 8, 0, 1);
                }
            } else {
                for (int i8x8 = 0; i8x8 < 4; ++i8x8) {
                    if ((cbp & 1 << i8x8) != 0) {
                        if ((mb_type & 0x1000000) != 0) {
                            this.decode_cabac_residual_nondc(this.mb, 64 * i8x8, 5, 4 * i8x8, scan8x8, 0, this.dequant8_coeff[(mb_type & 7) != 0 ? 0 : 1][this.s.qscale], 64);
                            continue;
                        }
                        long[] qmul = this.dequant4_coeff[(mb_type & 7) != 0 ? 0 : 3][this.s.qscale];
                        for (int i4x4 = 0; i4x4 < 4; ++i4x4) {
                            int index = 4 * i8x8 + i4x4;
                            this.decode_cabac_residual_nondc(this.mb, 16 * index, 2, index, scan, 0, qmul, 16);
                        }
                        continue;
                    }
                    int[] nnz = this.non_zero_count_cache;
                    short nnz_offset = scan8[4 * i8x8];
                    nnz[nnz_offset + 9] = 0;
                    nnz[nnz_offset + 8] = 0;
                    nnz[nnz_offset + 1] = 0;
                    nnz[nnz_offset + 0] = 0;
                }
            }
            if ((cbp & 0x30) != 0) {
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 4; ++k) {
                        this.mb_chroma_dc[j][k] = 0;
                    }
                }
                for (c = 0; c < 2; ++c) {
                    this.decode_cabac_residual_dc(this.mb_chroma_dc[c], 0, 3, 25 + c, H264Data.chroma_dc_scan, 0, 4);
                }
            }
            if ((cbp & 0x20) != 0) {
                for (c = 0; c < 2; ++c) {
                    long[] qmul = this.dequant4_coeff[c + 1 + ((mb_type & 7) != 0 ? 0 : 3)][this.chroma_qp[c]];
                    for (int i5 = 0; i5 < 4; ++i5) {
                        int index = 16 + 4 * c + i5;
                        this.decode_cabac_residual_nondc(this.mb, 16 * index, 4, index, scan, 1, qmul, 15);
                    }
                }
            } else {
                int[] nnz = this.non_zero_count_cache;
                nnz[H264Context.scan8[20] + 9] = 0;
                nnz[H264Context.scan8[20] + 8] = 0;
                nnz[H264Context.scan8[20] + 1] = 0;
                nnz[H264Context.scan8[20] + 0] = 0;
                nnz[H264Context.scan8[16] + 9] = 0;
                nnz[H264Context.scan8[16] + 8] = 0;
                nnz[H264Context.scan8[16] + 1] = 0;
                nnz[H264Context.scan8[16] + 0] = 0;
            }
        } else {
            int[] nnz = this.non_zero_count_cache;
            Rectangle.fill_rectangle_unsign(nnz, scan8[0], 4, 4, 8, 0, 1);
            nnz[H264Context.scan8[20] + 9] = 0;
            nnz[H264Context.scan8[20] + 8] = 0;
            nnz[H264Context.scan8[20] + 1] = 0;
            nnz[H264Context.scan8[20] + 0] = 0;
            nnz[H264Context.scan8[16] + 9] = 0;
            nnz[H264Context.scan8[16] + 8] = 0;
            nnz[H264Context.scan8[16] + 1] = 0;
            nnz[H264Context.scan8[16] + 0] = 0;
            this.last_qscale_diff = 0;
        }
        this.s.current_picture.qscale_table[mb_xy] = this.s.qscale;
        this.write_back_non_zero_count();
        if (this.mb_mbaff != 0) {
            this.ref_count[0] = this.ref_count[0] >> 1;
            this.ref_count[1] = this.ref_count[1] >> 1;
        }
        return 0;
    }

    public void predict_field_decoding_flag() {
        int mb_xy = this.s.mb_x + this.s.mb_y * this.s.mb_stride;
        int mb_type = (int)(this.slice_table_base[this.slice_table_offset + mb_xy - 1] == this.slice_num ? this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy - 1] : (this.slice_table_base[this.slice_table_offset + mb_xy - this.s.mb_stride] == this.slice_num ? this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy - this.s.mb_stride] : 0L));
        this.mb_field_decoding_flag = (mb_type & 0x80) != 0 ? 1 : 0;
        this.mb_mbaff = this.mb_field_decoding_flag;
    }

    public int fill_filter_caches(int mb_type) {
        int mb_xy = this.mb_xy;
        int[] left_xy = new int[2];
        int[] left_type = new int[2];
        int top_xy = mb_xy - (this.s.mb_stride << this.mb_field_decoding_flag);
        left_xy[1] = left_xy[0] = mb_xy - 1;
        if (this.mb_aff_frame != 0) {
            int left_mb_field_flag = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy - 1] & 0x80;
            int curr_mb_field_flag = mb_type & 0x80;
            if ((this.s.mb_y & 1) != 0) {
                if (left_mb_field_flag != curr_mb_field_flag) {
                    left_xy[0] = left_xy[0] - this.s.mb_stride;
                }
            } else {
                if (curr_mb_field_flag != 0) {
                    top_xy = (int)((long)top_xy + ((long)this.s.mb_stride & (this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + top_xy] >> 7 & 1L) - 1L));
                }
                if (left_mb_field_flag != curr_mb_field_flag) {
                    left_xy[1] = left_xy[1] + this.s.mb_stride;
                }
            }
        }
        this.top_mb_xy = top_xy;
        this.left_mb_xy[0] = left_xy[0];
        this.left_mb_xy[1] = left_xy[1];
        int qp = this.s.current_picture.qscale_table[mb_xy];
        int qp_thresh = this.qp_thresh;
        if (!(qp > qp_thresh || left_xy[0] >= 0 && qp + this.s.current_picture.qscale_table[left_xy[0]] + 1 >> 1 > qp_thresh || top_xy >= 0 && qp + this.s.current_picture.qscale_table[top_xy] + 1 >> 1 > qp_thresh)) {
            if (0 == this.mb_aff_frame) {
                return 1;
            }
            if (!(left_xy[0] >= 0 && qp + this.s.current_picture.qscale_table[left_xy[1]] + 1 >> 1 > qp_thresh || top_xy >= this.s.mb_stride && qp + this.s.current_picture.qscale_table[top_xy - this.s.mb_stride] + 1 >> 1 > qp_thresh)) {
                return 1;
            }
        }
        int top_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + top_xy];
        left_type[0] = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + left_xy[0]];
        left_type[1] = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + left_xy[1]];
        if (this.deblocking_filter == 2) {
            if (this.slice_table_base[this.slice_table_offset + top_xy] != this.slice_num) {
                top_type = 0;
            }
            if (this.slice_table_base[this.slice_table_offset + left_xy[0]] != this.slice_num) {
                left_type[1] = 0;
                left_type[0] = 0;
            }
        } else {
            if (this.slice_table_base[this.slice_table_offset + top_xy] == 65535) {
                top_type = 0;
            }
            if (this.slice_table_base[this.slice_table_offset + left_xy[0]] == 65535) {
                left_type[1] = 0;
                left_type[0] = 0;
            }
        }
        this.top_type = top_type;
        this.left_type[0] = left_type[0];
        this.left_type[1] = left_type[1];
        if (0 != (mb_type & 7)) {
            return 0;
        }
        System.arraycopy(this.non_zero_count[mb_xy], 0, this.non_zero_count_cache, 8, 8);
        System.arraycopy(this.non_zero_count[mb_xy], 8, this.non_zero_count_cache, 16, 8);
        System.arraycopy(this.non_zero_count[mb_xy], 16, this.non_zero_count_cache, 40, 4);
        System.arraycopy(this.non_zero_count[mb_xy], 20, this.non_zero_count_cache, 28, 4);
        System.arraycopy(this.non_zero_count[mb_xy], 24, this.non_zero_count_cache, 32, 8);
        this.cbp = this.cbp_table[mb_xy];
        int list = 0;
        while ((long)list < this.list_count) {
            if (0 == (mb_type & 12288 << 2 * list)) {
                Rectangle.fill_rectangle_mv_cache(this.mv_cache[list], scan8[0], 4, 4, 8, H264Context.pack16to32(0, 0), 4);
                for (int i = 0; i < 4; ++i) {
                    this.ref_cache[list][H264Context.scan8[0] + i] = -1;
                    this.ref_cache[list][H264Context.scan8[2] + i] = -1;
                    this.ref_cache[list][H264Context.scan8[8] + i] = -1;
                    this.ref_cache[list][H264Context.scan8[10] + i] = -1;
                }
            } else {
                int[] ref_base = this.s.current_picture.ref_index[list];
                int ref_offset = 4 * mb_xy;
                int[][] ref2frm_base = this.ref2frm[this.slice_num & 0xF];
                int ref2frm_offset = this.mb_mbaff != 0 ? 20 : 2;
                this.ref_cache[list][H264Context.scan8[0] + 0] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[0] + 1] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[0] + 2] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[0] + 3] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[2] + 0] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[2] + 1] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[2] + 2] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[2] + 3] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[8] + 0] = ref2frm_base[list][ref2frm_offset + ref_base[(ref_offset += 2) + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[8] + 1] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[8] + 2] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[8] + 3] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[10] + 0] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[10] + 1] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 0]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[10] + 2] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                this.ref_cache[list][H264Context.scan8[10] + 3] = ref2frm_base[list][ref2frm_offset + ref_base[ref_offset + 1]] & 0xFF;
                int b_stride = this.b_stride;
                int[][] mv_dst_base = this.mv_cache[list];
                short mv_dst_offset = scan8[0];
                int[][] mv_src_base = this.s.current_picture.motion_val_base[list];
                int mv_src_offset = this.s.current_picture.motion_val_offset[list] + 4 * this.s.mb_x + 4 * this.s.mb_y * b_stride;
                for (int y = 0; y < 4; ++y) {
                    for (int i = 0; i < 4; ++i) {
                        mv_dst_base[mv_dst_offset + 8 * y + i][0] = mv_src_base[mv_src_offset + y * b_stride + i][0];
                        mv_dst_base[mv_dst_offset + 8 * y + i][1] = mv_src_base[mv_src_offset + y * b_stride + i][1];
                    }
                }
            }
            ++list;
        }
        if (top_type != 0) {
            for (int i = 0; i < 4; ++i) {
                this.non_zero_count_cache[4 + i] = this.non_zero_count[top_xy][28 + i];
            }
        }
        if (left_type[0] != 0) {
            this.non_zero_count_cache[11] = this.non_zero_count[left_xy[0]][7];
            this.non_zero_count_cache[19] = this.non_zero_count[left_xy[0]][15];
            this.non_zero_count_cache[27] = this.non_zero_count[left_xy[0]][23];
            this.non_zero_count_cache[35] = this.non_zero_count[left_xy[0]][31];
        }
        if (0 == this.pps.cabac && 0 != this.pps.transform_8x8_mode) {
            if (0 != (top_type & 0x1000000)) {
                this.non_zero_count_cache[4] = this.non_zero_count_cache[5] = this.cbp_table[top_xy] & 4;
                this.non_zero_count_cache[6] = this.non_zero_count_cache[7] = this.cbp_table[top_xy] & 8;
            }
            if (0 != (left_type[0] & 0x1000000)) {
                this.non_zero_count_cache[11] = this.non_zero_count_cache[19] = this.cbp_table[left_xy[0]] & 2;
            }
            if (0 != (left_type[1] & 0x1000000)) {
                this.non_zero_count_cache[27] = this.non_zero_count_cache[35] = this.cbp_table[left_xy[1]] & 8;
            }
            if (0 != (mb_type & 0x1000000)) {
                int n = this.cbp & 1;
                this.non_zero_count_cache[H264Context.scan8[3]] = n;
                this.non_zero_count_cache[H264Context.scan8[2]] = n;
                this.non_zero_count_cache[H264Context.scan8[1]] = n;
                this.non_zero_count_cache[H264Context.scan8[0]] = n;
                int n2 = this.cbp & 2;
                this.non_zero_count_cache[H264Context.scan8[7]] = n2;
                this.non_zero_count_cache[H264Context.scan8[6]] = n2;
                this.non_zero_count_cache[H264Context.scan8[5]] = n2;
                this.non_zero_count_cache[H264Context.scan8[4]] = n2;
                int n3 = this.cbp & 4;
                this.non_zero_count_cache[H264Context.scan8[11]] = n3;
                this.non_zero_count_cache[H264Context.scan8[10]] = n3;
                this.non_zero_count_cache[H264Context.scan8[9]] = n3;
                this.non_zero_count_cache[H264Context.scan8[8]] = n3;
                int n4 = this.cbp & 8;
                this.non_zero_count_cache[H264Context.scan8[15]] = n4;
                this.non_zero_count_cache[H264Context.scan8[14]] = n4;
                this.non_zero_count_cache[H264Context.scan8[13]] = n4;
                this.non_zero_count_cache[H264Context.scan8[12]] = n4;
            }
        }
        if (0 != (mb_type & 0x78) || 0 != (mb_type & 0x100)) {
            list = 0;
            while ((long)list < this.list_count) {
                int ref2frm_offset;
                int[][] ref2frm_base;
                int b8_xy;
                int b_xy;
                if (0 != (top_type & 12288 << 2 * list)) {
                    b_xy = (int)this.mb2b_xy[top_xy] + 3 * this.b_stride;
                    b8_xy = 4 * top_xy + 2;
                    ref2frm_base = this.ref2frm[this.slice_table_base[this.slice_table_offset + top_xy] & 0xF];
                    ref2frm_offset = this.mb_mbaff != 0 ? 20 : 2;
                    for (int i = 0; i < 4; ++i) {
                        this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + i][0] = this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + 0 + i][0];
                        this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + i][1] = this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + 0 + i][1];
                    }
                    int n = ref2frm_base[list][ref2frm_offset + this.s.current_picture.ref_index[list][b8_xy + 0]];
                    this.ref_cache[list][H264Context.scan8[0] + 1 - 8] = n;
                    this.ref_cache[list][H264Context.scan8[0] + 0 - 8] = n;
                    int n5 = ref2frm_base[list][ref2frm_offset + this.s.current_picture.ref_index[list][b8_xy + 1]];
                    this.ref_cache[list][H264Context.scan8[0] + 3 - 8] = n5;
                    this.ref_cache[list][H264Context.scan8[0] + 2 - 8] = n5;
                } else {
                    for (int i = 0; i < 4; ++i) {
                        this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + i][0] = 0;
                        this.mv_cache[list][H264Context.scan8[0] + 0 - 8 + i][1] = 0;
                        this.ref_cache[list][H264Context.scan8[0] + 0 - 8 + i] = -1;
                    }
                }
                if (0 == ((mb_type ^ left_type[0]) & 0x80)) {
                    if (0 != (left_type[0] & 12288 << 2 * list)) {
                        b_xy = (int)this.mb2b_xy[left_xy[0]] + 3;
                        b8_xy = 4 * left_xy[0] + 1;
                        ref2frm_base = this.ref2frm[this.slice_table_base[this.slice_table_offset + left_xy[0]] & 0xF];
                        ref2frm_offset = this.mb_mbaff != 0 ? 20 : 2;
                        System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + this.b_stride * 0], 0, this.mv_cache[list][scan8[0] - 1 + 0], 0, 2);
                        System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + this.b_stride * 1], 0, this.mv_cache[list][scan8[0] - 1 + 8], 0, 2);
                        System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + this.b_stride * 2], 0, this.mv_cache[list][scan8[0] - 1 + 16], 0, 2);
                        System.arraycopy(this.s.current_picture.motion_val_base[list][this.s.current_picture.motion_val_offset[list] + b_xy + this.b_stride * 3], 0, this.mv_cache[list][scan8[0] - 1 + 24], 0, 2);
                        int n = ref2frm_base[list][ref2frm_offset + this.s.current_picture.ref_index[list][b8_xy + 0]];
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 8] = n;
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 0] = n;
                        int n6 = ref2frm_base[list][ref2frm_offset + this.s.current_picture.ref_index[list][b8_xy + 2]];
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 24] = n6;
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 16] = n6;
                    } else {
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 24][1] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 24][0] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 16][1] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 16][0] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 8][1] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 8][0] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 0][1] = 0;
                        this.mv_cache[list][H264Context.scan8[0] - 1 + 0][0] = 0;
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 24] = -1;
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 16] = -1;
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 8] = -1;
                        this.ref_cache[list][H264Context.scan8[0] - 1 + 0] = -1;
                    }
                }
                ++list;
            }
        }
        return 0;
    }

    private static int av_clip(int a, int amin, int amax) {
        if (a < amin) {
            return amin;
        }
        if (a > amax) {
            return amax;
        }
        return a;
    }

    private static int av_clip_uint8(int a) {
        if ((a & 0xFFFFFF00) != 0) {
            return -a >> 31 & 0xFF;
        }
        return a;
    }

    public void filter_mb_edgev(int[] pix_base, int pix_offset, int stride, int[] bS_base, int bS_offset, int qp) {
        int index_a = qp + this.slice_alpha_c0_offset;
        int alpha = LoopFilter.alpha_table[index_a];
        int beta = LoopFilter.beta_table[qp + this.slice_beta_offset];
        if (alpha == 0 || beta == 0) {
            return;
        }
        if (bS_base[bS_offset + 0] < 4) {
            int[] tc = new int[]{LoopFilter.tc0_table[index_a][bS_base[bS_offset + 0]], LoopFilter.tc0_table[index_a][bS_base[bS_offset + 1]], LoopFilter.tc0_table[index_a][bS_base[bS_offset + 2]], LoopFilter.tc0_table[index_a][bS_base[bS_offset + 3]]};
            this.h264dsp.h264_h_loop_filter_luma(pix_base, pix_offset, stride, alpha, beta, tc);
        } else {
            this.h264dsp.h264_h_loop_filter_luma_intra(pix_base, pix_offset, stride, alpha, beta);
        }
    }

    public void filter_mb_edgecv(int[] pix_base, int pix_offset, int stride, int[] bS_base, int bS_offset, int qp) {
        int index_a = qp + this.slice_alpha_c0_offset;
        int alpha = LoopFilter.alpha_table[index_a];
        int beta = LoopFilter.beta_table[qp + this.slice_beta_offset];
        if (alpha == 0 || beta == 0) {
            return;
        }
        if (bS_base[bS_offset + 0] < 4) {
            int[] tc = new int[]{LoopFilter.tc0_table[index_a][bS_base[bS_offset + 0]] + 1, LoopFilter.tc0_table[index_a][bS_base[bS_offset + 1]] + 1, LoopFilter.tc0_table[index_a][bS_base[bS_offset + 2]] + 1, LoopFilter.tc0_table[index_a][bS_base[bS_offset + 3]] + 1};
            this.h264dsp.h264_h_loop_filter_chroma(pix_base, pix_offset, stride, alpha, beta, tc);
        } else {
            this.h264dsp.h264_h_loop_filter_chroma_intra(pix_base, pix_offset, stride, alpha, beta);
        }
    }

    public void filter_mb_edgeh(int[] pix_base, int pix_offset, int stride, int[] bS_base, int bS_offset, int qp) {
        int index_a = qp + this.slice_alpha_c0_offset;
        int alpha = LoopFilter.alpha_table[index_a];
        int beta = LoopFilter.beta_table[qp + this.slice_beta_offset];
        if (alpha == 0 || beta == 0) {
            return;
        }
        if (bS_base[bS_offset + 0] < 4) {
            int[] tc = new int[]{LoopFilter.tc0_table[index_a][bS_base[bS_offset + 0]], LoopFilter.tc0_table[index_a][bS_base[bS_offset + 1]], LoopFilter.tc0_table[index_a][bS_base[bS_offset + 2]], LoopFilter.tc0_table[index_a][bS_base[bS_offset + 3]]};
            this.h264dsp.h264_v_loop_filter_luma(pix_base, pix_offset, stride, alpha, beta, tc);
        } else {
            this.h264dsp.h264_v_loop_filter_luma_intra(pix_base, pix_offset, stride, alpha, beta);
        }
    }

    public void filter_mb_edgech(int[] pix_base, int pix_offset, int stride, int[] bS_base, int bS_offset, int qp) {
        int index_a = qp + this.slice_alpha_c0_offset;
        int alpha = LoopFilter.alpha_table[index_a];
        int beta = LoopFilter.beta_table[qp + this.slice_beta_offset];
        if (alpha == 0 || beta == 0) {
            return;
        }
        if (bS_base[bS_offset + 0] < 4) {
            int[] tc = new int[]{LoopFilter.tc0_table[index_a][bS_base[bS_offset + 0]] + 1, LoopFilter.tc0_table[index_a][bS_base[bS_offset + 1]] + 1, LoopFilter.tc0_table[index_a][bS_base[bS_offset + 2]] + 1, LoopFilter.tc0_table[index_a][bS_base[bS_offset + 3]] + 1};
            this.h264dsp.h264_v_loop_filter_chroma(pix_base, pix_offset, stride, alpha, beta, tc);
        } else {
            this.h264dsp.h264_v_loop_filter_chroma_intra(pix_base, pix_offset, stride, alpha, beta);
        }
    }

    public void ff_h264_filter_mb_fast(int mb_x, int mb_y, int[] img_y_base, int img_y_offset, int[] img_cb_base, int img_cb_offset, int[] img_cr_base, int img_cr_offset, int linesize, int uvlinesize) {
        this.ff_h264_filter_mb(mb_x, mb_y, img_y_base, img_y_offset, img_cb_base, img_cb_offset, img_cr_base, img_cr_offset, linesize, uvlinesize);
    }

    public int check_mv(int b_idx, int bn_idx, int mvy_limit) {
        int v;
        int n = v = this.ref_cache[0][b_idx] != this.ref_cache[0][bn_idx] ? 1 : 0;
        if (0 == v && this.ref_cache[0][b_idx] != -1) {
            v = (((long)(this.mv_cache[0][b_idx][0] - this.mv_cache[0][bn_idx][0] + 3) & 0xFFFFL) >= 7L ? 1 : 0) | (Math.abs(this.mv_cache[0][b_idx][1] - this.mv_cache[0][bn_idx][1]) >= mvy_limit ? 1 : 0);
        }
        if (this.list_count == 2L) {
            if (0 == v) {
                v = this.ref_cache[1][b_idx] != this.ref_cache[1][bn_idx] | ((long)(this.mv_cache[1][b_idx][0] - this.mv_cache[1][bn_idx][0] + 3) & 0xFFFFL) >= 7L | (Math.abs(this.mv_cache[1][b_idx][1] - this.mv_cache[1][bn_idx][1]) >= mvy_limit ? 1 : 0);
            }
            if (0 != v) {
                if (this.ref_cache[0][b_idx] != this.ref_cache[1][bn_idx] | this.ref_cache[1][b_idx] != this.ref_cache[0][bn_idx]) {
                    return 1;
                }
                return ((long)(this.mv_cache[0][b_idx][0] - this.mv_cache[1][bn_idx][0] + 3) & 0xFFFFL) >= 7L | Math.abs(this.mv_cache[0][b_idx][1] - this.mv_cache[1][bn_idx][1]) >= mvy_limit | ((long)(this.mv_cache[1][b_idx][0] - this.mv_cache[0][bn_idx][0] + 3) & 0xFFFFL) >= 7L | (Math.abs(this.mv_cache[1][b_idx][1] - this.mv_cache[0][bn_idx][1]) >= mvy_limit ? 1 : 0);
            }
        }
        return v;
    }

    public void filter_mb_mbaff_edgev(int[] pix_base, int pix_offset, int stride, int[] bS_base, int bS_offset, int bsi, int qp) {
        int index_a = qp + this.slice_alpha_c0_offset;
        int alpha = LoopFilter.alpha_table[index_a];
        int beta = LoopFilter.beta_table[qp + this.slice_beta_offset];
        int i = 0;
        while (i < 8) {
            int bS_index = (i >> 1) * bsi;
            if (bS_base[bS_offset + bS_index] != 0) {
                if (bS_base[bS_offset + bS_index] < 4) {
                    int tc0 = LoopFilter.tc0_table[index_a][bS_base[bS_offset + bS_index]];
                    int p0 = pix_base[pix_offset + -1];
                    int p1 = pix_base[pix_offset + -2];
                    int p2 = pix_base[pix_offset + -3];
                    int q0 = pix_base[pix_offset + 0];
                    int q1 = pix_base[pix_offset + 1];
                    int q2 = pix_base[pix_offset + 2];
                    if (Math.abs(p0 - q0) < alpha && Math.abs(p1 - p0) < beta && Math.abs(q1 - q0) < beta) {
                        int tc = tc0;
                        if (Math.abs(p2 - p0) < beta) {
                            if (tc0 != 0) {
                                pix_base[pix_offset + -2] = p1 + H264Context.av_clip(p2 + (p0 + q0 + 1 >> 1) - (p1 << 1) >> 1, -tc0, tc0);
                            }
                            ++tc;
                        }
                        if (Math.abs(q2 - q0) < beta) {
                            if (tc0 != 0) {
                                pix_base[pix_offset + 1] = q1 + H264Context.av_clip(q2 + (p0 + q0 + 1 >> 1) - (q1 << 1) >> 1, -tc0, tc0);
                            }
                            ++tc;
                        }
                        int i_delta = H264Context.av_clip((q0 - p0 << 2) + (p1 - q1) + 4 >> 3, -tc, tc);
                        pix_base[pix_offset + -1] = H264Context.av_clip_uint8(p0 + i_delta);
                        pix_base[pix_offset + 0] = H264Context.av_clip_uint8(q0 - i_delta);
                    }
                } else {
                    int p0 = pix_base[pix_offset + -1];
                    int p1 = pix_base[pix_offset + -2];
                    int p2 = pix_base[pix_offset + -3];
                    int q0 = pix_base[pix_offset + 0];
                    int q1 = pix_base[pix_offset + 1];
                    int q2 = pix_base[pix_offset + 2];
                    if (Math.abs(p0 - q0) < alpha && Math.abs(p1 - p0) < beta && Math.abs(q1 - q0) < beta) {
                        if (Math.abs(p0 - q0) < (alpha >> 2) + 2) {
                            if (Math.abs(p2 - p0) < beta) {
                                int p3 = pix_base[pix_offset + -4];
                                pix_base[pix_offset + -1] = p2 + 2 * p1 + 2 * p0 + 2 * q0 + q1 + 4 >> 3;
                                pix_base[pix_offset + -2] = p2 + p1 + p0 + q0 + 2 >> 2;
                                pix_base[pix_offset + -3] = 2 * p3 + 3 * p2 + p1 + p0 + q0 + 4 >> 3;
                            } else {
                                pix_base[pix_offset + -1] = 2 * p1 + p0 + q1 + 2 >> 2;
                            }
                            if (Math.abs(q2 - q0) < beta) {
                                int q3 = pix_base[pix_offset + 3];
                                pix_base[pix_offset + 0] = p1 + 2 * p0 + 2 * q0 + 2 * q1 + q2 + 4 >> 3;
                                pix_base[pix_offset + 1] = p0 + q0 + q1 + q2 + 2 >> 2;
                                pix_base[pix_offset + 2] = 2 * q3 + 3 * q2 + q1 + q0 + p0 + 4 >> 3;
                            } else {
                                pix_base[pix_offset + 0] = 2 * q1 + q0 + p1 + 2 >> 2;
                            }
                        } else {
                            pix_base[pix_offset + -1] = 2 * p1 + p0 + q1 + 2 >> 2;
                            pix_base[pix_offset + 0] = 2 * q1 + q0 + p1 + 2 >> 2;
                        }
                    }
                }
            }
            ++i;
            pix_offset += stride;
        }
    }

    public void filter_mb_mbaff_edgecv(int[] pix_base, int pix_offset, int stride, int[] bS_base, int bS_offset, int bsi, int qp) {
        int index_a = qp + this.slice_alpha_c0_offset;
        int alpha = LoopFilter.alpha_table[index_a];
        int beta = LoopFilter.beta_table[qp + this.slice_beta_offset];
        int i = 0;
        while (i < 4) {
            int bS_index = i * bsi;
            if (bS_base[bS_offset + bS_index] != 0) {
                if (bS_base[bS_offset + bS_index] < 4) {
                    int tc = LoopFilter.tc0_table[index_a][bS_base[bS_offset + bS_index]] + 1;
                    int p0 = pix_base[pix_offset + -1];
                    int p1 = pix_base[pix_offset + -2];
                    int q0 = pix_base[pix_offset + 0];
                    int q1 = pix_base[pix_offset + 1];
                    if (Math.abs(p0 - q0) < alpha && Math.abs(p1 - p0) < beta && Math.abs(q1 - q0) < beta) {
                        int i_delta = H264Context.av_clip((q0 - p0 << 2) + (p1 - q1) + 4 >> 3, -tc, tc);
                        pix_base[pix_offset + -1] = H264Context.av_clip_uint8(p0 + i_delta);
                        pix_base[pix_offset + 0] = H264Context.av_clip_uint8(q0 - i_delta);
                    }
                } else {
                    int p0 = pix_base[pix_offset + -1];
                    int p1 = pix_base[pix_offset + -2];
                    int q0 = pix_base[pix_offset + 0];
                    int q1 = pix_base[pix_offset + 1];
                    if (Math.abs(p0 - q0) < alpha && Math.abs(p1 - p0) < beta && Math.abs(q1 - q0) < beta) {
                        pix_base[pix_offset + -1] = 2 * p1 + p0 + q1 + 2 >> 2;
                        pix_base[pix_offset + 0] = 2 * q1 + q0 + p1 + 2 >> 2;
                    }
                }
            }
            ++i;
            pix_offset += stride;
        }
    }

    public void filter_mb_dir(int mb_x, int mb_y, int[] img_y_base, int img_y_offset, int[] img_cb_base, int img_cb_offset, int[] img_cr_base, int img_cr_offset, int linesize, int uvlinesize, int mb_xy, int mb_type, int mvy_limit, int first_vertical_edge_done, int dir) {
        int qp;
        int bn_idx;
        int b_idx;
        int y;
        int x;
        int i;
        int bn_idx2;
        int b_idx2;
        int k;
        int k2;
        int bS_offset;
        int mbm_xy = dir == 0 ? mb_xy - 1 : this.top_mb_xy;
        int mbm_type = dir == 0 ? this.left_type[0] : this.top_type;
        int[][] mask_edge_tab = new int[][]{{0, 3, 3, 3, 1, 1, 1, 1}, {0, 3, 1, 1, 3, 3, 3, 3}};
        int mask_edge = mask_edge_tab[dir][mb_type >> 3 & 7];
        int edges = mask_edge == 3 && 0 == (this.cbp & 0xF) ? 1 : 4;
        int mask_par0 = mb_type & (8 | 32 >> dir);
        if (mbm_type != 0 && 0 == first_vertical_edge_done) {
            if (0 != this.mb_aff_frame && dir == 1 && (mb_y & 1) == 0 && 0 != (mbm_type & ~mb_type & 0x80)) {
                int tmp_linesize = 2 * linesize;
                int tmp_uvlinesize = 2 * uvlinesize;
                int mbn_xy = mb_xy - 2 * this.s.mb_stride;
                int j = 0;
                while (j < 2) {
                    int[] bS_base = new int[4];
                    int bS_offset2 = 0;
                    if (0L != (7L & ((long)mb_type | this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mbn_xy]))) {
                        for (int k3 = 0; k3 < 4; ++k3) {
                            bS_base[bS_offset2 + k3] = 3;
                        }
                    } else if (0 == this.pps.cabac && 0L != (this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mbn_xy] & 0x1000000L)) {
                        bS_base[bS_offset2 + 0] = 1 + ((this.cbp_table[mbn_xy] & 4) != 0 || this.non_zero_count_cache[scan8[0] + 0] != 0 ? 1 : 0);
                        bS_base[bS_offset2 + 1] = 1 + ((this.cbp_table[mbn_xy] & 4) != 0 || this.non_zero_count_cache[scan8[0] + 1] != 0 ? 1 : 0);
                        bS_base[bS_offset2 + 2] = 1 + ((this.cbp_table[mbn_xy] & 8) != 0 || this.non_zero_count_cache[scan8[0] + 2] != 0 ? 1 : 0);
                        bS_base[bS_offset2 + 3] = 1 + ((this.cbp_table[mbn_xy] & 8) != 0 || this.non_zero_count_cache[scan8[0] + 3] != 0 ? 1 : 0);
                    } else {
                        int[] mbn_nnz_base = this.non_zero_count[mbn_xy];
                        int mbn_nnz_offset = 28;
                        for (int i2 = 0; i2 < 4; ++i2) {
                            bS_base[bS_offset2 + i2] = 1 + ((this.non_zero_count_cache[scan8[0] + i2] | mbn_nnz_base[mbn_nnz_offset + i2]) != 0 ? 1 : 0);
                        }
                    }
                    int qp2 = this.s.current_picture.qscale_table[mb_xy] + this.s.current_picture.qscale_table[mbn_xy] + 1 >> 1;
                    this.filter_mb_edgeh(img_y_base, img_y_offset + j * linesize, tmp_linesize, bS_base, bS_offset2, qp2);
                    this.filter_mb_edgech(img_cb_base, img_cb_offset + j * uvlinesize, tmp_uvlinesize, bS_base, bS_offset2, this.chroma_qp[0] + this.pps.chroma_qp_table[0][this.s.current_picture.qscale_table[mbn_xy]] + 1 >> 1);
                    this.filter_mb_edgech(img_cr_base, img_cr_offset + j * uvlinesize, tmp_uvlinesize, bS_base, bS_offset2, this.chroma_qp[1] + this.pps.chroma_qp_table[1][this.s.current_picture.qscale_table[mbn_xy]] + 1 >> 1);
                    ++j;
                    mbn_xy += this.s.mb_stride;
                }
            } else {
                int[] bS_base = new int[4];
                bS_offset = 0;
                if (0 != (7 & (mb_type | mbm_type))) {
                    for (k2 = 0; k2 < 4; ++k2) {
                        bS_base[bS_offset + k2] = 3;
                    }
                    if (0 == ((mb_type | mbm_type) & 0x80) || (0 != this.mb_aff_frame || this.s.picture_structure != 3) && dir == 0) {
                        for (k2 = 0; k2 < 4; ++k2) {
                            bS_base[bS_offset + k2] = 4;
                        }
                    }
                } else {
                    boolean mv_done;
                    if (dir != 0 && this.mb_aff_frame != 0 && ((mb_type ^ mbm_type) & 0x80) != 0) {
                        for (k = 0; k < 4; ++k) {
                            bS_base[bS_offset + k] = 1;
                        }
                        mv_done = true;
                    } else if (mask_par0 != 0 && (mbm_type & (8 | 32 >> dir)) != 0) {
                        b_idx2 = 12;
                        bn_idx2 = b_idx2 - (dir != 0 ? 8 : 1);
                        int n = this.check_mv(12, bn_idx2, mvy_limit);
                        bS_base[bS_offset + 3] = n;
                        bS_base[bS_offset + 2] = n;
                        bS_base[bS_offset + 1] = n;
                        bS_base[bS_offset + 0] = n;
                        mv_done = true;
                    } else {
                        mv_done = false;
                    }
                    for (i = 0; i < 4; ++i) {
                        x = dir == 0 ? 0 : i;
                        b_idx = 12 + x + 8 * (y = dir == 0 ? i : 0);
                        if ((this.non_zero_count_cache[b_idx] | this.non_zero_count_cache[bn_idx = b_idx - (dir != 0 ? 8 : 1)]) != 0) {
                            bS_base[bS_offset + i] = 2;
                            continue;
                        }
                        if (mv_done) continue;
                        bS_base[bS_offset + i] = this.check_mv(b_idx, bn_idx, mvy_limit);
                    }
                }
                if (0 != bS_base[bS_offset + 0] + bS_base[bS_offset + 1] + bS_base[bS_offset + 2] + bS_base[bS_offset + 3]) {
                    qp = this.s.current_picture.qscale_table[mb_xy] + this.s.current_picture.qscale_table[mbm_xy] + 1 >> 1;
                    if (dir == 0) {
                        this.filter_mb_edgev(img_y_base, img_y_offset + 0, linesize, bS_base, bS_offset, qp);
                        qp = this.chroma_qp[0] + this.pps.chroma_qp_table[0][this.s.current_picture.qscale_table[mbm_xy]] + 1 >> 1;
                        this.filter_mb_edgecv(img_cb_base, img_cb_offset + 0, uvlinesize, bS_base, bS_offset, qp);
                        if (0 != this.pps.chroma_qp_diff) {
                            qp = this.chroma_qp[1] + this.pps.chroma_qp_table[1][this.s.current_picture.qscale_table[mbm_xy]] + 1 >> 1;
                        }
                        this.filter_mb_edgecv(img_cr_base, img_cr_offset + 0, uvlinesize, bS_base, bS_offset, qp);
                    } else {
                        this.filter_mb_edgeh(img_y_base, img_y_offset + 0, linesize, bS_base, bS_offset, qp);
                        qp = this.chroma_qp[0] + this.pps.chroma_qp_table[0][this.s.current_picture.qscale_table[mbm_xy]] + 1 >> 1;
                        this.filter_mb_edgech(img_cb_base, img_cb_offset + 0, uvlinesize, bS_base, bS_offset, qp);
                        if (this.pps.chroma_qp_diff != 0) {
                            qp = this.chroma_qp[1] + this.pps.chroma_qp_table[1][this.s.current_picture.qscale_table[mbm_xy]] + 1 >> 1;
                        }
                        this.filter_mb_edgech(img_cr_base, img_cr_offset + 0, uvlinesize, bS_base, bS_offset, qp);
                    }
                }
            }
        }
        for (int edge = 1; edge < edges; ++edge) {
            int[] bS_base = new int[4];
            bS_offset = 0;
            if (0 != (mb_type & edge << 24 & 0x1000000)) continue;
            if (0 != (mb_type & 7)) {
                for (k2 = 0; k2 < 4; ++k2) {
                    bS_base[bS_offset + k2] = 3;
                }
            } else {
                boolean mv_done;
                if (0 != (edge & mask_edge)) {
                    for (k = 0; k < 4; ++k) {
                        bS_base[bS_offset + k] = 0;
                    }
                    mv_done = true;
                } else if (0 != mask_par0) {
                    b_idx2 = 12 + edge * (0 != dir ? 8 : 1);
                    bn_idx2 = b_idx2 - (0 != dir ? 8 : 1);
                    int n = this.check_mv(b_idx2, bn_idx2, mvy_limit);
                    bS_base[bS_offset + 3] = n;
                    bS_base[bS_offset + 2] = n;
                    bS_base[bS_offset + 1] = n;
                    bS_base[bS_offset + 0] = n;
                    mv_done = true;
                } else {
                    mv_done = false;
                }
                for (i = 0; i < 4; ++i) {
                    x = dir == 0 ? edge : i;
                    b_idx = 12 + x + 8 * (y = dir == 0 ? i : edge);
                    if (0 != (this.non_zero_count_cache[b_idx] | this.non_zero_count_cache[bn_idx = b_idx - (0 != dir ? 8 : 1)])) {
                        bS_base[bS_offset + i] = 2;
                        continue;
                    }
                    if (mv_done) continue;
                    bS_base[bS_offset + i] = this.check_mv(b_idx, bn_idx, mvy_limit);
                }
                if (bS_base[bS_offset + 0] + bS_base[bS_offset + 1] + bS_base[bS_offset + 2] + bS_base[bS_offset + 3] == 0) continue;
            }
            qp = this.s.current_picture.qscale_table[mb_xy];
            if (dir == 0) {
                this.filter_mb_edgev(img_y_base, img_y_offset + 4 * edge, linesize, bS_base, bS_offset, qp);
                if ((edge & 1) != 0) continue;
                this.filter_mb_edgecv(img_cb_base, img_cb_offset + 2 * edge, uvlinesize, bS_base, bS_offset, this.chroma_qp[0]);
                this.filter_mb_edgecv(img_cr_base, img_cr_offset + 2 * edge, uvlinesize, bS_base, bS_offset, this.chroma_qp[1]);
                continue;
            }
            this.filter_mb_edgeh(img_y_base, img_y_offset + 4 * edge * linesize, linesize, bS_base, bS_offset, qp);
            if ((edge & 1) != 0) continue;
            this.filter_mb_edgech(img_cb_base, img_cb_offset + 2 * edge * uvlinesize, uvlinesize, bS_base, bS_offset, this.chroma_qp[0]);
            this.filter_mb_edgech(img_cr_base, img_cr_offset + 2 * edge * uvlinesize, uvlinesize, bS_base, bS_offset, this.chroma_qp[1]);
        }
    }

    public void ff_h264_filter_mb(int mb_x, int mb_y, int[] img_y_base, int img_y_offset, int[] img_cb_base, int img_cb_offset, int[] img_cr_base, int img_cr_offset, int linesize, int uvlinesize) {
        int mb_xy = mb_x + mb_y * this.s.mb_stride;
        int mb_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy];
        int mvy_limit = (mb_type & 0x80) != 0 ? 2 : 4;
        int first_vertical_edge_done = 0;
        if (this.mb_aff_frame != 0 && 0 != ((mb_type ^ this.left_type[0]) & 0x80) && this.left_type[0] != 0) {
            int[] bS = new int[8];
            int[] qp = new int[2];
            int[] bqp = new int[2];
            int[] rqp = new int[2];
            first_vertical_edge_done = 1;
            if (0 != (mb_type & 7)) {
                for (int j = 0; j < 8; ++j) {
                    bS[j] = 4;
                }
            } else {
                int[][][] offset = new int[][][]{new int[][]{{7, 7, 7, 7, 15, 15, 15, 15}, {23, 23, 23, 23, 31, 31, 31, 31}}, new int[][]{{7, 15, 23, 31, 7, 15, 23, 31}, {7, 15, 23, 31, 7, 15, 23, 31}}};
                int[] off = offset[this.mb_field_decoding_flag][mb_y & 1];
                for (int i = 0; i < 8; ++i) {
                    int j = this.mb_field_decoding_flag != 0 ? i >> 2 : i & 1;
                    int mbn_xy = this.left_mb_xy[j];
                    int mbn_type = this.left_type[j];
                    if ((mbn_type & 7) != 0) {
                        bS[i] = 4;
                        continue;
                    }
                    bS[i] = 1 + ((this.non_zero_count_cache[12 + 8 * (i >> 1)] != 0 ? 1 : 0) | (0 == this.pps.cabac && (mbn_type & 0x1000000) != 0 ? ((this.cbp_table[mbn_xy] & (this.mb_field_decoding_flag != 0 ? i & 2 : mb_y & 1)) != 0 ? 8 : 2) : this.non_zero_count[mbn_xy][off[i]]));
                }
            }
            int mb_qp = this.s.current_picture.qscale_table[mb_xy];
            int mbn0_qp = this.s.current_picture.qscale_table[this.left_mb_xy[0]];
            int mbn1_qp = this.s.current_picture.qscale_table[this.left_mb_xy[1]];
            qp[0] = mb_qp + mbn0_qp + 1 >> 1;
            bqp[0] = this.pps.chroma_qp_table[0][mb_qp] + this.pps.chroma_qp_table[0][mbn0_qp] + 1 >> 1;
            rqp[0] = this.pps.chroma_qp_table[1][mb_qp] + this.pps.chroma_qp_table[1][mbn0_qp] + 1 >> 1;
            qp[1] = mb_qp + mbn1_qp + 1 >> 1;
            bqp[1] = this.pps.chroma_qp_table[0][mb_qp] + this.pps.chroma_qp_table[0][mbn1_qp] + 1 >> 1;
            rqp[1] = this.pps.chroma_qp_table[1][mb_qp] + this.pps.chroma_qp_table[1][mbn1_qp] + 1 >> 1;
            if (this.mb_field_decoding_flag != 0) {
                this.filter_mb_mbaff_edgev(img_y_base, img_y_offset, linesize, bS, 0, 1, qp[0]);
                this.filter_mb_mbaff_edgev(img_y_base, img_y_offset + 8 * linesize, linesize, bS, 4, 1, qp[1]);
                this.filter_mb_mbaff_edgecv(img_cb_base, img_cb_offset, uvlinesize, bS, 0, 1, bqp[0]);
                this.filter_mb_mbaff_edgecv(img_cb_base, img_cb_offset + 4 * uvlinesize, uvlinesize, bS, 4, 1, bqp[1]);
                this.filter_mb_mbaff_edgecv(img_cr_base, img_cr_offset, uvlinesize, bS, 0, 1, rqp[0]);
                this.filter_mb_mbaff_edgecv(img_cr_base, img_cr_offset + 4 * uvlinesize, uvlinesize, bS, 4, 1, rqp[1]);
            } else {
                this.filter_mb_mbaff_edgev(img_y_base, img_y_offset, 2 * linesize, bS, 0, 2, qp[0]);
                this.filter_mb_mbaff_edgev(img_y_base, img_y_offset + linesize, 2 * linesize, bS, 1, 2, qp[1]);
                this.filter_mb_mbaff_edgecv(img_cb_base, img_cb_offset, 2 * uvlinesize, bS, 0, 2, bqp[0]);
                this.filter_mb_mbaff_edgecv(img_cb_base, img_cb_offset + uvlinesize, 2 * uvlinesize, bS, 1, 2, bqp[1]);
                this.filter_mb_mbaff_edgecv(img_cr_base, img_cr_offset, 2 * uvlinesize, bS, 0, 2, rqp[0]);
                this.filter_mb_mbaff_edgecv(img_cr_base, img_cr_offset + uvlinesize, 2 * uvlinesize, bS, 1, 2, rqp[1]);
            }
        }
        for (int dir = 0; dir < 2; ++dir) {
            this.filter_mb_dir(mb_x, mb_y, img_y_base, img_y_offset, img_cb_base, img_cb_offset, img_cr_base, img_cr_offset, linesize, uvlinesize, mb_xy, mb_type, mvy_limit, dir != 0 ? 0 : first_vertical_edge_done, dir);
        }
    }

    public void loop_filter() {
        int end_mb_y = this.s.mb_y + this.mb_aff_frame;
        int old_slice_type = this.slice_type;
        if (this.deblocking_filter != 0) {
            for (int mb_x = 0; mb_x < this.s.mb_width; ++mb_x) {
                for (int mb_y = end_mb_y - this.mb_aff_frame; mb_y <= end_mb_y; ++mb_y) {
                    int uvlinesize;
                    int linesize;
                    int mb_xy = this.mb_xy = mb_x + mb_y * this.s.mb_stride;
                    this.slice_num = this.slice_table_base[this.slice_table_offset + mb_xy];
                    int mb_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy];
                    this.list_count = this.list_counts[mb_xy];
                    if (this.mb_aff_frame != 0) {
                        this.mb_field_decoding_flag = 0 != (mb_type & 0x80) ? 1 : 0;
                        this.mb_mbaff = this.mb_field_decoding_flag;
                    }
                    this.s.mb_x = mb_x;
                    this.s.mb_y = mb_y;
                    int[] dest_y_base = this.s.current_picture.data_base[0];
                    int dest_y_offset = this.s.current_picture.data_offset[0] + (mb_x + mb_y * this.s.linesize) * 16;
                    int[] dest_cb_base = this.s.current_picture.data_base[1];
                    int dest_cb_offset = this.s.current_picture.data_offset[1] + (mb_x + mb_y * this.s.uvlinesize) * 8;
                    int[] dest_cr_base = this.s.current_picture.data_base[2];
                    int dest_cr_offset = this.s.current_picture.data_offset[2] + (mb_x + mb_y * this.s.uvlinesize) * 8;
                    if (this.mb_field_decoding_flag != 0) {
                        linesize = this.mb_linesize = this.s.linesize * 2;
                        uvlinesize = this.mb_uvlinesize = this.s.uvlinesize * 2;
                        if ((mb_y & 1) != 0) {
                            dest_y_offset -= this.s.linesize * 15;
                            dest_cb_offset -= this.s.uvlinesize * 7;
                            dest_cr_offset -= this.s.uvlinesize * 7;
                        }
                    } else {
                        linesize = this.mb_linesize = this.s.linesize;
                        uvlinesize = this.mb_uvlinesize = this.s.uvlinesize;
                    }
                    this.backup_mb_border(dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, linesize, uvlinesize, 0);
                    if (this.fill_filter_caches(mb_type) != 0) continue;
                    this.chroma_qp[0] = this.pps.chroma_qp_table[0][this.s.current_picture.qscale_table[mb_xy]];
                    this.chroma_qp[1] = this.pps.chroma_qp_table[1][this.s.current_picture.qscale_table[mb_xy]];
                    if (this.mb_aff_frame != 0) {
                        this.ff_h264_filter_mb(mb_x, mb_y, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, linesize, uvlinesize);
                        continue;
                    }
                    this.ff_h264_filter_mb_fast(mb_x, mb_y, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, linesize, uvlinesize);
                }
            }
        }
        this.slice_type = old_slice_type;
        this.s.mb_x = 0;
        this.s.mb_y = end_mb_y - this.mb_aff_frame;
        this.chroma_qp[0] = this.pps.chroma_qp_table[0][this.s.qscale];
        this.chroma_qp[1] = this.pps.chroma_qp_table[1][this.s.qscale];
    }

    public int decode_slice() {
        int part_mask = this.s.partitioned_frame != 0 ? 18 : 127;
        this.s.mb_skip_run = -1;
        int n = this.is_complex = this.mb_aff_frame != 0 || this.s.picture_structure != 3 || this.s.codec_id != 28 ? 1 : 0;
        if (this.pps.cabac != 0) {
            int eos;
            this.s.gb.align_get_bits();
            this.cabac.ff_init_cabac_states();
            this.cabac.ff_init_cabac_decoder(this.s.gb.buffer, this.s.gb.buffer_offset + this.s.gb.get_bits_count() / 8, (this.s.gb.get_bits_left() + 7) / 8);
            this.cabac.ff_h264_init_cabac_states(this);
            do {
                int ret;
                if ((ret = this.ff_h264_decode_mb_cabac()) >= 0) {
                    this.ff_h264_hl_decode_mb();
                }
                if (ret >= 0 && this.mb_aff_frame != 0) {
                    ++this.s.mb_y;
                    ret = this.ff_h264_decode_mb_cabac();
                    if (ret >= 0) {
                        this.ff_h264_hl_decode_mb();
                    }
                    --this.s.mb_y;
                }
                eos = this.cabac.get_cabac_terminate();
                if ((this.s.workaround_bugs & 0x4000) != 0 && this.cabac.bytestream_current > this.cabac.bytestream_end + 2) {
                    ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x - 1, this.s.mb_y, 0x70 & part_mask);
                    return 0;
                }
                if (ret < 0 || this.cabac.bytestream_current > this.cabac.bytestream_end + 2) {
                    ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x, this.s.mb_y, 0xE & part_mask);
                    return -1;
                }
                if (++this.s.mb_x < this.s.mb_width) continue;
                this.s.mb_x = 0;
                this.loop_filter();
                this.s.ff_draw_horiz_band(16 * this.s.mb_y, 16);
                ++this.s.mb_y;
                if (this.mb_aff_frame == 0 && this.s.picture_structure == 3) continue;
                ++this.s.mb_y;
                if (this.mb_aff_frame == 0 || this.s.mb_y >= this.s.mb_height) continue;
                this.predict_field_decoding_flag();
            } while (eos == 0 && this.s.mb_y < this.s.mb_height);
            ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x - 1, this.s.mb_y, 0x70 & part_mask);
            return 0;
        }
        do {
            int ret;
            if ((ret = this.cavlc.ff_h264_decode_mb_cavlc(this)) >= 0) {
                this.ff_h264_hl_decode_mb();
            }
            if (ret >= 0 && this.mb_aff_frame != 0) {
                ++this.s.mb_y;
                ret = this.cavlc.ff_h264_decode_mb_cavlc(this);
                if (ret >= 0) {
                    this.ff_h264_hl_decode_mb();
                }
                --this.s.mb_y;
            }
            if (ret < 0) {
                ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x, this.s.mb_y, 0xE & part_mask);
                return -1;
            }
            if (++this.s.mb_x < this.s.mb_width) continue;
            this.s.mb_x = 0;
            this.loop_filter();
            this.s.ff_draw_horiz_band(16 * this.s.mb_y, 16);
            ++this.s.mb_y;
            if (this.mb_aff_frame != 0 || this.s.picture_structure != 3) {
                ++this.s.mb_y;
                if (this.mb_aff_frame != 0 && this.s.mb_y < this.s.mb_height) {
                    this.predict_field_decoding_flag();
                }
            }
            if (this.s.mb_y < this.s.mb_height) continue;
            if (this.s.gb.get_bits_count() == this.s.gb.size_in_bits) {
                ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x - 1, this.s.mb_y, 0x70 & part_mask);
                return 0;
            }
            ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x, this.s.mb_y, 0x70 & part_mask);
            return -1;
        } while (this.s.gb.get_bits_count() < this.s.gb.size_in_bits || this.s.mb_skip_run > 0);
        if (this.s.gb.get_bits_count() == this.s.gb.size_in_bits) {
            ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x - 1, this.s.mb_y, 0x70 & part_mask);
            return 0;
        }
        ErrorResilience.ff_er_add_slice(this.s, this.s.resync_mb_x, this.s.resync_mb_y, this.s.mb_x, this.s.mb_y, 0xE & part_mask);
        return -1;
    }

    public void mc_dir_part(AVFrame pic, int n, int square, int chroma_height, int delta, int list, int[] dest_y_base, int dest_y_offset, int[] dest_cb_base, int dest_cb_offset, int[] dest_cr_base, int dest_cr_offset, int src_x_offset, int src_y_offset, DSPContext.Ih264_qpel_mc_func[] qpix_op, DSPContext.Ih264_chroma_mc_func chroma_op) {
        int mx = this.mv_cache[list][scan8[n]][0] + src_x_offset * 8;
        int my = this.mv_cache[list][scan8[n]][1] + src_y_offset * 8;
        int luma_xy = (mx & 3) + ((my & 3) << 2);
        int[] src_y_base = pic.data_base[0];
        int _src_y_offset = pic.data_offset[0] + (mx >> 2) + (my >> 2) * this.mb_linesize;
        int extra_width = this.emu_edge_width;
        int extra_height = this.emu_edge_height;
        boolean emu = false;
        int full_mx = mx >> 2;
        int full_my = my >> 2;
        int pic_width = 16 * this.s.mb_width;
        int pic_height = 16 * this.s.mb_height >> this.mb_field_decoding_flag;
        if ((mx & 7) != 0) {
            extra_width -= 3;
        }
        if ((my & 7) != 0) {
            extra_height -= 3;
        }
        if (full_mx < 0 - extra_width || full_my < 0 - extra_height || full_mx + 16 > pic_width + extra_width || full_my + 16 > pic_height + extra_height) {
            this.s.dsp.ff_emulated_edge_mc(this.s.allocated_edge_emu_buffer, this.s.edge_emu_buffer_offset, src_y_base, _src_y_offset - 2 - 2 * this.mb_linesize, this.mb_linesize, 21, 21, full_mx - 2, full_my - 2, pic_width, pic_height);
            src_y_base = this.s.allocated_edge_emu_buffer;
            _src_y_offset = this.s.edge_emu_buffer_offset + 2 + 2 * this.mb_linesize;
            emu = true;
        }
        qpix_op[luma_xy].h264_qpel_mc_func(dest_y_base, dest_y_offset, src_y_base, _src_y_offset, this.mb_linesize);
        if (0 == square) {
            qpix_op[luma_xy].h264_qpel_mc_func(dest_y_base, dest_y_offset + delta, src_y_base, _src_y_offset + delta, this.mb_linesize);
        }
        if (this.mb_field_decoding_flag != 0) {
            emu |= (my += 2 * ((this.s.mb_y & 1) - (pic.reference - 1))) >> 3 < 0 || (my >> 3) + 8 >= pic_height >> 1;
        }
        int[] src_cb_base = pic.data_base[1];
        int src_cb_offset = pic.data_offset[1] + (mx >> 3) + (my >> 3) * this.mb_uvlinesize;
        int[] src_cr_base = pic.data_base[2];
        int src_cr_offset = pic.data_offset[2] + (mx >> 3) + (my >> 3) * this.mb_uvlinesize;
        if (emu) {
            this.s.dsp.ff_emulated_edge_mc(this.s.allocated_edge_emu_buffer, this.s.edge_emu_buffer_offset, src_cb_base, src_cb_offset, this.mb_uvlinesize, 9, 9, mx >> 3, my >> 3, pic_width >> 1, pic_height >> 1);
            src_cb_base = this.s.allocated_edge_emu_buffer;
            src_cb_offset = this.s.edge_emu_buffer_offset;
        }
        chroma_op.h264_chroma_mc_func(dest_cb_base, dest_cb_offset, src_cb_base, src_cb_offset, this.mb_uvlinesize, chroma_height, mx & 7, my & 7);
        if (emu) {
            this.s.dsp.ff_emulated_edge_mc(this.s.allocated_edge_emu_buffer, this.s.edge_emu_buffer_offset, src_cr_base, src_cr_offset, this.mb_uvlinesize, 9, 9, mx >> 3, my >> 3, pic_width >> 1, pic_height >> 1);
            src_cr_base = this.s.allocated_edge_emu_buffer;
            src_cr_offset = this.s.edge_emu_buffer_offset;
        }
        chroma_op.h264_chroma_mc_func(dest_cr_base, dest_cr_offset, src_cr_base, src_cr_offset, this.mb_uvlinesize, chroma_height, mx & 7, my & 7);
    }

    public void mc_part_std(int n, int square, int chroma_height, int delta, int[] dest_y_base, int dest_y_offset, int[] dest_cb_base, int dest_cb_offset, int[] dest_cr_base, int dest_cr_offset, int x_offset, int y_offset, DSPContext.Ih264_qpel_mc_func[] qpix_put, DSPContext.Ih264_chroma_mc_func chroma_put, DSPContext.Ih264_qpel_mc_func[] qpix_avg, DSPContext.Ih264_chroma_mc_func chroma_avg, int list0, int list1) {
        AVFrame ref;
        DSPContext.Ih264_qpel_mc_func[] qpix_op = qpix_put;
        DSPContext.Ih264_chroma_mc_func chroma_op = chroma_put;
        dest_y_offset += 2 * x_offset + 2 * y_offset * this.mb_linesize;
        dest_cb_offset += x_offset + y_offset * this.mb_uvlinesize;
        dest_cr_offset += x_offset + y_offset * this.mb_uvlinesize;
        x_offset += 8 * this.s.mb_x;
        y_offset += 8 * (this.s.mb_y >> this.mb_field_decoding_flag);
        if (list0 != 0) {
            ref = this.ref_list[0][this.ref_cache[0][scan8[n]]];
            this.mc_dir_part(ref, n, square, chroma_height, delta, 0, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_op, chroma_op);
            qpix_op = qpix_avg;
            chroma_op = chroma_avg;
        }
        if (list1 != 0) {
            ref = this.ref_list[1][this.ref_cache[1][scan8[n]]];
            this.mc_dir_part(ref, n, square, chroma_height, delta, 1, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_op, chroma_op);
        }
    }

    public void mc_part_weighted(int n, int square, int chroma_height, int delta, int[] dest_y_base, int dest_y_offset, int[] dest_cb_base, int dest_cb_offset, int[] dest_cr_base, int dest_cr_offset, int x_offset, int y_offset, DSPContext.Ih264_qpel_mc_func[] qpix_put, DSPContext.Ih264_chroma_mc_func chroma_put, H264DSPContext.IH264WeightFunctionStub luma_weight_op, H264DSPContext.IH264WeightFunctionStub chroma_weight_op, H264DSPContext.IH264BiWeightFunctionStub luma_weight_avg, H264DSPContext.IH264BiWeightFunctionStub chroma_weight_avg, int list0, int list1) {
        dest_y_offset += 2 * x_offset + 2 * y_offset * this.mb_linesize;
        dest_cb_offset += x_offset + y_offset * this.mb_uvlinesize;
        dest_cr_offset += x_offset + y_offset * this.mb_uvlinesize;
        x_offset += 8 * this.s.mb_x;
        y_offset += 8 * (this.s.mb_y >> this.mb_field_decoding_flag);
        if (list0 != 0 && list1 != 0) {
            int[] tmp_cb_base = this.s.obmc_scratchpad;
            int tmp_cb_offset = 0;
            int[] tmp_cr_base = this.s.obmc_scratchpad;
            int tmp_cr_offset = 8;
            int[] tmp_y_base = this.s.obmc_scratchpad;
            int tmp_y_offset = 8 * this.mb_uvlinesize;
            int refn0 = this.ref_cache[0][scan8[n]];
            int refn1 = this.ref_cache[1][scan8[n]];
            this.mc_dir_part(this.ref_list[0][refn0], n, square, chroma_height, delta, 0, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put, chroma_put);
            this.mc_dir_part(this.ref_list[1][refn1], n, square, chroma_height, delta, 1, tmp_y_base, tmp_y_offset, tmp_cb_base, tmp_cb_offset, tmp_cr_base, tmp_cr_offset, x_offset, y_offset, qpix_put, chroma_put);
            if (this.use_weight == 2) {
                int weight0 = this.implicit_weight[refn0][refn1][this.s.mb_y & 1];
                int weight1 = 64 - weight0;
                luma_weight_avg.h264_biweight_func(dest_y_base, dest_y_offset, tmp_y_base, tmp_y_offset, this.mb_linesize, 5, weight0, weight1, 0);
                chroma_weight_avg.h264_biweight_func(dest_cb_base, dest_cb_offset, tmp_cb_base, tmp_cb_offset, this.mb_uvlinesize, 5, weight0, weight1, 0);
                chroma_weight_avg.h264_biweight_func(dest_cr_base, dest_cr_offset, tmp_cr_base, tmp_cr_offset, this.mb_uvlinesize, 5, weight0, weight1, 0);
            } else {
                luma_weight_avg.h264_biweight_func(dest_y_base, dest_y_offset, tmp_y_base, tmp_y_offset, this.mb_linesize, this.luma_log2_weight_denom, this.luma_weight[refn0][0][0], this.luma_weight[refn1][1][0], this.luma_weight[refn0][0][1] + this.luma_weight[refn1][1][1]);
                chroma_weight_avg.h264_biweight_func(dest_cb_base, dest_cb_offset, tmp_cb_base, tmp_cb_offset, this.mb_uvlinesize, this.chroma_log2_weight_denom, this.chroma_weight[refn0][0][0][0], this.chroma_weight[refn1][1][0][0], this.chroma_weight[refn0][0][0][1] + this.chroma_weight[refn1][1][0][1]);
                chroma_weight_avg.h264_biweight_func(dest_cr_base, dest_cr_offset, tmp_cr_base, tmp_cr_offset, this.mb_uvlinesize, this.chroma_log2_weight_denom, this.chroma_weight[refn0][0][1][0], this.chroma_weight[refn1][1][1][0], this.chroma_weight[refn0][0][1][1] + this.chroma_weight[refn1][1][1][1]);
            }
        } else {
            int list = list1 != 0 ? 1 : 0;
            int refn = this.ref_cache[list][scan8[n]];
            AVFrame ref = this.ref_list[list][refn];
            this.mc_dir_part(ref, n, square, chroma_height, delta, list, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put, chroma_put);
            luma_weight_op.h264_weight_func(dest_y_base, dest_y_offset, this.mb_linesize, this.luma_log2_weight_denom, this.luma_weight[refn][list][0], this.luma_weight[refn][list][1]);
            if (this.use_weight_chroma != 0) {
                chroma_weight_op.h264_weight_func(dest_cb_base, dest_cb_offset, this.mb_uvlinesize, this.chroma_log2_weight_denom, this.chroma_weight[refn][list][0][0], this.chroma_weight[refn][list][0][1]);
                chroma_weight_op.h264_weight_func(dest_cr_base, dest_cr_offset, this.mb_uvlinesize, this.chroma_log2_weight_denom, this.chroma_weight[refn][list][1][0], this.chroma_weight[refn][list][1][1]);
            }
        }
    }

    public void mc_part(int n, int square, int chroma_height, int delta, int[] dest_y_base, int dest_y_offset, int[] dest_cb_base, int dest_cb_offset, int[] dest_cr_base, int dest_cr_offset, int x_offset, int y_offset, DSPContext.Ih264_qpel_mc_func[] qpix_put, DSPContext.Ih264_chroma_mc_func chroma_put, DSPContext.Ih264_qpel_mc_func[] qpix_avg, DSPContext.Ih264_chroma_mc_func chroma_avg, H264DSPContext.IH264WeightFunctionStub[] weight_op_base, int weight_op_offset, H264DSPContext.IH264BiWeightFunctionStub[] weight_avg_base, int weight_avg_offset, int list0, int list1) {
        if (this.use_weight == 2 && list0 != 0 && list1 != 0 && this.implicit_weight[this.ref_cache[0][scan8[n]]][this.ref_cache[1][scan8[n]]][this.s.mb_y & 1] != 32 || this.use_weight == 1) {
            this.mc_part_weighted(n, square, chroma_height, delta, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put, chroma_put, weight_op_base[weight_op_offset + 0], weight_op_base[weight_op_offset + 3], weight_avg_base[weight_avg_offset + 0], weight_avg_base[weight_avg_offset + 3], list0, list1);
        } else {
            this.mc_part_std(n, square, chroma_height, delta, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put, chroma_put, qpix_avg, chroma_avg, list0, list1);
        }
    }

    public void prefetch_motion(int list) {
    }

    private int IS_DIR(int a, int part, int list) {
        return a & 4096 << part + 2 * list;
    }

    public void hl_motion(int[] dest_y_base, int dest_y_offset, int[] dest_cb_base, int dest_cb_offset, int[] dest_cr_base, int dest_cr_offset, DSPContext.Ih264_qpel_mc_func[][] qpix_put, DSPContext.Ih264_chroma_mc_func[] chroma_put, DSPContext.Ih264_qpel_mc_func[][] qpix_avg, DSPContext.Ih264_chroma_mc_func[] chroma_avg, H264DSPContext.IH264WeightFunctionStub[] weight_op, H264DSPContext.IH264BiWeightFunctionStub[] weight_avg) {
        int mb_xy = this.mb_xy;
        int mb_type = (int)this.s.current_picture.mb_type_base[this.s.current_picture.mb_type_offset + mb_xy];
        this.prefetch_motion(0);
        if ((mb_type & 8) != 0) {
            this.mc_part(0, 1, 8, 0, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, 0, 0, qpix_put[0], chroma_put[0], qpix_avg[0], chroma_avg[0], weight_op, 0, weight_avg, 0, this.IS_DIR(mb_type, 0, 0), this.IS_DIR(mb_type, 0, 1));
        } else if ((mb_type & 0x10) != 0) {
            this.mc_part(0, 0, 4, 8, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, 0, 0, qpix_put[1], chroma_put[0], qpix_avg[1], chroma_avg[0], weight_op, 1, weight_avg, 1, this.IS_DIR(mb_type, 0, 0), this.IS_DIR(mb_type, 0, 1));
            this.mc_part(8, 0, 4, 8, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, 0, 4, qpix_put[1], chroma_put[0], qpix_avg[1], chroma_avg[0], weight_op, 1, weight_avg, 1, this.IS_DIR(mb_type, 1, 0), this.IS_DIR(mb_type, 1, 1));
        } else if ((mb_type & 0x20) != 0) {
            this.mc_part(0, 0, 8, 8 * this.mb_linesize, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, 0, 0, qpix_put[1], chroma_put[1], qpix_avg[1], chroma_avg[1], weight_op, 2, weight_avg, 2, this.IS_DIR(mb_type, 0, 0), this.IS_DIR(mb_type, 0, 1));
            this.mc_part(4, 0, 8, 8 * this.mb_linesize, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, 4, 0, qpix_put[1], chroma_put[1], qpix_avg[1], chroma_avg[1], weight_op, 2, weight_avg, 2, this.IS_DIR(mb_type, 1, 0), this.IS_DIR(mb_type, 1, 1));
        } else {
            for (int i = 0; i < 4; ++i) {
                int sub_mb_type = this.sub_mb_type[i];
                int n = 4 * i;
                int x_offset = (i & 1) << 2;
                int y_offset = (i & 2) << 1;
                if ((sub_mb_type & 8) != 0) {
                    this.mc_part(n, 1, 4, 0, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put[1], chroma_put[1], qpix_avg[1], chroma_avg[1], weight_op, 3, weight_avg, 3, this.IS_DIR(sub_mb_type, 0, 0), this.IS_DIR(sub_mb_type, 0, 1));
                    continue;
                }
                if ((sub_mb_type & 0x10) != 0) {
                    this.mc_part(n, 0, 2, 4, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put[2], chroma_put[1], qpix_avg[2], chroma_avg[1], weight_op, 4, weight_avg, 4, this.IS_DIR(sub_mb_type, 0, 0), this.IS_DIR(sub_mb_type, 0, 1));
                    this.mc_part(n + 2, 0, 2, 4, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset + 2, qpix_put[2], chroma_put[1], qpix_avg[2], chroma_avg[1], weight_op, 4, weight_avg, 4, this.IS_DIR(sub_mb_type, 0, 0), this.IS_DIR(sub_mb_type, 0, 1));
                    continue;
                }
                if ((sub_mb_type & 0x20) != 0) {
                    this.mc_part(n, 0, 4, 4 * this.mb_linesize, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset, y_offset, qpix_put[2], chroma_put[2], qpix_avg[2], chroma_avg[2], weight_op, 5, weight_avg, 5, this.IS_DIR(sub_mb_type, 0, 0), this.IS_DIR(sub_mb_type, 0, 1));
                    this.mc_part(n + 1, 0, 4, 4 * this.mb_linesize, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, x_offset + 2, y_offset, qpix_put[2], chroma_put[2], qpix_avg[2], chroma_avg[2], weight_op, 5, weight_avg, 5, this.IS_DIR(sub_mb_type, 0, 0), this.IS_DIR(sub_mb_type, 0, 1));
                    continue;
                }
                for (int j = 0; j < 4; ++j) {
                    int sub_x_offset = x_offset + 2 * (j & 1);
                    int sub_y_offset = y_offset + (j & 2);
                    this.mc_part(n + j, 1, 2, 0, dest_y_base, dest_y_offset, dest_cb_base, dest_cb_offset, dest_cr_base, dest_cr_offset, sub_x_offset, sub_y_offset, qpix_put[2], chroma_put[2], qpix_avg[2], chroma_avg[2], weight_op, 6, weight_avg, 6, this.IS_DIR(sub_mb_type, 0, 0), this.IS_DIR(sub_mb_type, 0, 1));
                }
            }
        }
        this.prefetch_motion(1);
    }

    public static void av_fast_malloc(int[][] param1, int[] param2, int min_size) {
        int size = param2[0];
        if (min_size < size) {
            return;
        }
        min_size = Math.max(17 * min_size / 16 + 32, min_size);
        param1[0] = new int[min_size];
        param2[0] = min_size;
    }

    public int[] ff_h264_decode_nal(int[] src_base, int src_offset, int[] dst_length_consumed, int length) {
        int di;
        int dst_offset = 0;
        this.nal_ref_idc = src_base[src_offset + 0] >> 5;
        this.nal_unit_type = src_base[src_offset + 0] & 0x1F;
        ++src_offset;
        --length;
        int i = 0;
        while (i + 1 < length) {
            if (src_base[src_offset + i] == 0) {
                if (i > 0 && src_base[src_offset + i - 1] == 0) {
                    --i;
                }
                if (i + 2 < length && src_base[src_offset + i + 1] == 0 && src_base[src_offset + i + 2] <= 3) {
                    if (src_base[src_offset + i + 2] == 3) break;
                    length = i;
                    break;
                }
                i += 0;
            }
            i += 2;
        }
        if (i >= length - 1) {
            dst_length_consumed[0] = length;
            dst_length_consumed[1] = length + 1;
            dst_length_consumed[2] = src_offset;
            return src_base;
        }
        int bufidx = this.nal_unit_type == 4 ? 1 : 0;
        int[][] param1 = new int[][]{this.rbsp_buffer[bufidx]};
        int[] param2 = new int[]{(int)this.rbsp_buffer_size[bufidx]};
        H264Context.av_fast_malloc(param1, param2, length + 80);
        this.rbsp_buffer[bufidx] = param1[0];
        this.rbsp_buffer_size[bufidx] = param2[0];
        int[] dst = this.rbsp_buffer[bufidx];
        if (dst == null) {
            return null;
        }
        System.arraycopy(src_base, src_offset, dst, 0, i);
        int si = di = i;
        boolean flag1 = true;
        while (si + 2 < length) {
            if (src_base[src_offset + si + 2] > 3) {
                dst[di++] = src_base[src_offset + si++];
                dst[di++] = src_base[src_offset + si++];
            } else if (src_base[src_offset + si] == 0 && src_base[src_offset + si + 1] == 0) {
                if (src_base[src_offset + si + 2] == 3) {
                    dst[di++] = 0;
                    dst[di++] = 0;
                    si += 3;
                    continue;
                }
                flag1 = false;
                break;
            }
            dst[di++] = src_base[src_offset + si++];
        }
        if (flag1) {
            while (si < length) {
                dst[di++] = src_base[src_offset + si++];
            }
        }
        Arrays.fill(dst, di, di + 80, 0);
        dst_length_consumed[0] = di;
        dst_length_consumed[1] = si + 1;
        dst_length_consumed[2] = dst_offset;
        return dst;
    }

    public int ff_h264_decode_rbsp_trailing(int[] src_base, int src_offset) {
        int v = src_base[src_offset];
        for (int r = 1; r < 9; ++r) {
            if ((v & 1) != 0) {
                return r;
            }
            v >>= 1;
        }
        return 0;
    }

    public int unreference_pic(AVFrame pic, int refmask) {
        if ((pic.reference &= refmask) != 0) {
            return 0;
        }
        int i = 0;
        while (this.delayed_pic[i] != null) {
            if (pic == this.delayed_pic[i]) {
                pic.reference = 4;
                break;
            }
            ++i;
        }
        return 1;
    }

    public void remove_short_at_index(int i) {
        this.short_ref[i] = null;
        if (--this.short_ref_count != 0) {
            for (int j = i; j < this.short_ref_count; ++j) {
                this.short_ref[i] = this.short_ref[i + 1];
            }
        }
    }

    public AVFrame remove_short(int frame_num, int ref_mask) {
        int[] param = new int[1];
        AVFrame pic = this.find_short(frame_num, param);
        int i = param[0];
        if (pic != null && this.unreference_pic(pic, ref_mask) != 0) {
            this.remove_short_at_index(i);
        }
        return pic;
    }

    public AVFrame remove_long(int i, int ref_mask) {
        AVFrame pic = this.long_ref[i];
        if (pic != null && this.unreference_pic(pic, ref_mask) != 0) {
            this.long_ref[i].long_ref = 0;
            this.long_ref[i] = null;
            --this.long_ref_count;
        }
        return pic;
    }

    void ff_h264_remove_all_refs() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.remove_long(i, 0);
        }
        for (i = 0; i < this.short_ref_count; ++i) {
            this.unreference_pic(this.short_ref[i], 0);
            this.short_ref[i] = null;
        }
        this.short_ref_count = 0;
    }

    public void idr() {
        this.ff_h264_remove_all_refs();
        this.prev_frame_num = 0;
        this.prev_frame_num_offset = 0;
        this.prev_poc_lsb = 0;
        this.prev_poc_msb = 0;
    }

    public int decode_picture_timing() {
        if (this.sps.nal_hrd_parameters_present_flag != 0 || this.sps.vcl_hrd_parameters_present_flag != 0) {
            this.sei_cpb_removal_delay = (int)this.s.gb.get_bits(this.sps.cpb_removal_delay_length, "sei_cpb_removal_delay");
            this.sei_dpb_output_delay = (int)this.s.gb.get_bits(this.sps.dpb_output_delay_length, "sei_dpb_output_delay");
        }
        if (this.sps.pic_struct_present_flag != 0) {
            this.sei_pic_struct = (int)this.s.gb.get_bits(4, "sei_pic_struct");
            this.sei_ct_type = 0;
            if (this.sei_pic_struct > 8) {
                return -1;
            }
            int num_clock_ts = sei_num_clock_ts_table[this.sei_pic_struct];
            for (int i = 0; i < num_clock_ts; ++i) {
                if ((int)this.s.gb.get_bits(1, "clock_timestamp_flag") == 0) continue;
                this.sei_ct_type |= 1 << (int)this.s.gb.get_bits(2, "sei_ct_type");
                this.s.gb.skip_bits(1);
                this.s.gb.skip_bits(5);
                int full_timestamp_flag = (int)this.s.gb.get_bits(1, "full_timestamp_flag");
                this.s.gb.skip_bits(1);
                this.s.gb.skip_bits(1);
                this.s.gb.skip_bits(8);
                if (full_timestamp_flag != 0) {
                    this.s.gb.skip_bits(6);
                    this.s.gb.skip_bits(6);
                    this.s.gb.skip_bits(5);
                } else if ((int)this.s.gb.get_bits(1, "seconds_flag") != 0) {
                    this.s.gb.skip_bits(6);
                    if ((int)this.s.gb.get_bits(1, "minutes_flag") != 0) {
                        this.s.gb.skip_bits(6);
                        if ((int)this.s.gb.get_bits(1, "hours_flag") != 0) {
                            this.s.gb.skip_bits(5);
                        }
                    }
                }
                if (this.sps.time_offset_length <= 0) continue;
                this.s.gb.skip_bits(this.sps.time_offset_length);
            }
        }
        return 0;
    }

    public int decode_unregistered_user_data(int size) {
        int i;
        int[] user_data = new int[272];
        if (size < 16) {
            return -1;
        }
        for (i = 0; i < user_data.length - 1 && i < size; ++i) {
            user_data[i] = (int)this.s.gb.get_bits(8, "user_data");
        }
        user_data[i] = 0;
        boolean e = false;
        int build = 0;
        if (e && build > 0) {
            this.x264_build = build;
        }
        while (i < size) {
            this.s.gb.skip_bits(8);
            ++i;
        }
        return 0;
    }

    public int decode_recovery_point() {
        this.sei_recovery_frame_cnt = this.s.gb.get_ue_golomb("sei_recovery_frame_cnt");
        this.s.gb.skip_bits(4);
        return 0;
    }

    public int decode_buffering_period() {
        int sched_sel_idx;
        int sps_id = this.s.gb.get_ue_golomb_31("sps_id");
        if (sps_id > 31 || null == this.sps_buffers[sps_id]) {
            return -1;
        }
        SequenceParameterSet sps = this.sps_buffers[sps_id];
        if (sps.nal_hrd_parameters_present_flag != 0) {
            for (sched_sel_idx = 0; sched_sel_idx < sps.cpb_cnt; ++sched_sel_idx) {
                this.initial_cpb_removal_delay[sched_sel_idx] = (int)this.s.gb.get_bits(sps.initial_cpb_removal_delay_length, "initial_cpb_removal_delay");
                this.s.gb.skip_bits(sps.initial_cpb_removal_delay_length);
            }
        }
        if (sps.vcl_hrd_parameters_present_flag != 0) {
            for (sched_sel_idx = 0; sched_sel_idx < sps.cpb_cnt; ++sched_sel_idx) {
                this.initial_cpb_removal_delay[sched_sel_idx] = (int)this.s.gb.get_bits(sps.initial_cpb_removal_delay_length, "initial_cpb_removal_delay");
                this.s.gb.skip_bits(sps.initial_cpb_removal_delay_length);
            }
        }
        this.sei_buffering_period_present = 1;
        return 0;
    }

    public int ff_h264_decode_sei() {
        while (this.s.gb.get_bits_count() + 16 < this.s.gb.size_in_bits) {
            int type = 0;
            do {
                type = (int)((long)type + this.s.gb.show_bits(8));
            } while (this.s.gb.get_bits(8, "sei?") == 255L);
            int size = 0;
            do {
                size = (int)((long)size + this.s.gb.show_bits(8));
            } while (this.s.gb.get_bits(8, "sei?") == 255L);
            switch (type) {
                case 1: {
                    if (this.decode_picture_timing() >= 0) break;
                    return -1;
                }
                case 5: {
                    if (this.decode_unregistered_user_data(size) >= 0) break;
                    return -1;
                }
                case 6: {
                    if (this.decode_recovery_point() >= 0) break;
                    return -1;
                }
                case 0: {
                    if (this.decode_buffering_period() >= 0) break;
                    return -1;
                }
                default: {
                    this.s.gb.skip_bits(8 * size);
                }
            }
            this.s.gb.align_get_bits();
        }
        return 0;
    }

    public void decode_scaling_list(int[] factors, int size, int[] jvt_list, int[] fallback_list) {
        int[] scan;
        int last = 8;
        int next = 8;
        int[] nArray = scan = size == 16 ? this.zigzag_scan : ff_zigzag_direct;
        if (0L == this.s.gb.get_bits1("01?")) {
            System.arraycopy(fallback_list, 0, factors, 0, size);
        } else {
            for (int i = 0; i < size; ++i) {
                if (next != 0) {
                    next = last + this.s.gb.get_se_golomb("next?") & 0xFF;
                }
                if (0 == i && 0 == next) {
                    System.arraycopy(jvt_list, 0, factors, 0, size);
                    break;
                }
                int n = next != 0 ? next : last;
                factors[scan[i]] = n;
                last = n;
            }
        }
    }

    public void decode_scaling_matrices(SequenceParameterSet sps, PictureParameterSet pps, int is_sps, int[][] scaling_matrix4, int[][] scaling_matrix8) {
        boolean fallback_sps = 0 == is_sps && 0 != sps.scaling_matrix_present;
        int[][] fallback = new int[][]{fallback_sps ? sps.scaling_matrix4[0] : default_scaling4[0], fallback_sps ? sps.scaling_matrix4[3] : default_scaling4[1], fallback_sps ? sps.scaling_matrix8[0] : default_scaling8[0], fallback_sps ? sps.scaling_matrix8[1] : default_scaling8[1]};
        if (0L != this.s.gb.get_bits1("01?")) {
            sps.scaling_matrix_present |= is_sps;
            this.decode_scaling_list(scaling_matrix4[0], 16, default_scaling4[0], fallback[0]);
            this.decode_scaling_list(scaling_matrix4[1], 16, default_scaling4[0], scaling_matrix4[0]);
            this.decode_scaling_list(scaling_matrix4[2], 16, default_scaling4[0], scaling_matrix4[1]);
            this.decode_scaling_list(scaling_matrix4[3], 16, default_scaling4[1], fallback[1]);
            this.decode_scaling_list(scaling_matrix4[4], 16, default_scaling4[1], scaling_matrix4[3]);
            this.decode_scaling_list(scaling_matrix4[5], 16, default_scaling4[1], scaling_matrix4[4]);
            if (is_sps != 0 || pps.transform_8x8_mode != 0) {
                this.decode_scaling_list(scaling_matrix8[0], 64, default_scaling8[0], fallback[2]);
                this.decode_scaling_list(scaling_matrix8[1], 64, default_scaling8[1], fallback[3]);
            }
        }
    }

    public int decode_hrd_parameters(SequenceParameterSet sps) {
        int cpb_count = this.s.gb.get_ue_golomb_31("cpb_count") + 1;
        if (cpb_count > 32) {
            return -1;
        }
        this.s.gb.get_bits(4, "bit_rate_scale");
        this.s.gb.get_bits(4, "cpb_size_scale");
        for (int i = 0; i < cpb_count; ++i) {
            this.s.gb.get_ue_golomb("bit_rate_value_minus1");
            this.s.gb.get_ue_golomb("cpb_size_value_minus1");
            this.s.gb.get_bits1("cbr_flag");
        }
        sps.initial_cpb_removal_delay_length = (int)this.s.gb.get_bits(5, "initial_cpb_removal_delay_length") + 1;
        sps.cpb_removal_delay_length = (int)this.s.gb.get_bits(5, "cpb_removal_delay_length") + 1;
        sps.dpb_output_delay_length = (int)this.s.gb.get_bits(5, "dpb_output_delay_length") + 1;
        sps.time_offset_length = (int)this.s.gb.get_bits(5, "time_offset_length");
        sps.cpb_cnt = cpb_count;
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int decode_vui_parameters(SequenceParameterSet sps) {
        int aspect_ratio_info_present_flag = (int)this.s.gb.get_bits1("aspect_ratio_info_present_flag");
        if (aspect_ratio_info_present_flag != 0) {
            int aspect_ratio_idc = (int)this.s.gb.get_bits(8, "aspect_ratio_idc");
            if (aspect_ratio_idc == 255) {
                sps.sar.num = (int)this.s.gb.get_bits(16, "sar_num");
                sps.sar.den = (int)this.s.gb.get_bits(16, "sar_den");
            } else {
                if (aspect_ratio_idc >= pixel_aspect.length) return -1;
                sps.sar = pixel_aspect[aspect_ratio_idc];
            }
        } else {
            sps.sar.den = 0;
            sps.sar.num = 0;
        }
        if (0 != (int)this.s.gb.get_bits1("overscan_info_present_flag")) {
            this.s.gb.get_bits1("overscan_appropriate_flag");
        }
        sps.video_signal_type_present_flag = (int)this.s.gb.get_bits1("video_signal_type_present_flag");
        if (0 != sps.video_signal_type_present_flag) {
            this.s.gb.get_bits(3, "video_signal_type_present_flag?");
            sps.full_range = (int)this.s.gb.get_bits1("full_range");
            sps.colour_description_present_flag = (int)this.s.gb.get_bits1("colour_description_present_flag");
            if (0 != sps.colour_description_present_flag) {
                sps.color_primaries = (int)this.s.gb.get_bits(8, "color_primaries");
                sps.color_trc = (int)this.s.gb.get_bits(8, "color_trc");
                sps.colorspace = (int)this.s.gb.get_bits(8, "colorspace");
                if (sps.color_primaries >= 9) {
                    sps.color_primaries = 2;
                }
                if (sps.color_trc >= 6) {
                    sps.color_trc = 2;
                }
                if (sps.colorspace >= 8) {
                    sps.colorspace = 2;
                }
            }
        }
        if (0 != (int)this.s.gb.get_bits1("chroma_location_info_present_flag")) {
            this.s.chroma_sample_location = this.s.gb.get_ue_golomb("chroma_sample_location") + 1;
            this.s.gb.get_ue_golomb("chroma_sample_location_type_bottom_field");
        }
        sps.timing_info_present_flag = (int)this.s.gb.get_bits1("timing_info_present_flag");
        if (0 != sps.timing_info_present_flag) {
            sps.num_units_in_tick = this.s.gb.get_bits_long(32, "num_units_in_tick");
            sps.time_scale = this.s.gb.get_bits_long(32, "time_scale");
            if (0L == sps.num_units_in_tick || 0L == sps.time_scale) {
                return -1;
            }
            sps.fixed_frame_rate_flag = (int)this.s.gb.get_bits1("fixed_frame_rate_flag");
        }
        sps.nal_hrd_parameters_present_flag = (int)this.s.gb.get_bits1("nal_hrd_parameters_present_flag");
        if (0 != sps.nal_hrd_parameters_present_flag && this.decode_hrd_parameters(sps) < 0) {
            return -1;
        }
        sps.vcl_hrd_parameters_present_flag = (int)this.s.gb.get_bits1("vcl_hrd_parameters_present_flag");
        if (0 != sps.vcl_hrd_parameters_present_flag && this.decode_hrd_parameters(sps) < 0) {
            return -1;
        }
        if (0 != sps.nal_hrd_parameters_present_flag || 0 != sps.vcl_hrd_parameters_present_flag) {
            this.s.gb.get_bits1("low_delay_hrd_flag");
        }
        sps.pic_struct_present_flag = (int)this.s.gb.get_bits1("pic_struct_present_flag");
        sps.bitstream_restriction_flag = (int)this.s.gb.get_bits1("bitstream_restriction_flag");
        if (0 == sps.bitstream_restriction_flag) return 0;
        this.s.gb.get_bits1("motion_vectors_over_pic_boundaries_flag");
        this.s.gb.get_ue_golomb("max_bytes_per_pic_denom");
        this.s.gb.get_ue_golomb("max_bits_per_mb_denom");
        this.s.gb.get_ue_golomb("log2_max_mv_length_horizontal");
        this.s.gb.get_ue_golomb("log2_max_mv_length_vertical");
        sps.num_reorder_frames = this.s.gb.get_ue_golomb("num_reorder_frames");
        this.s.gb.get_ue_golomb("get_ue_golomb");
        if (this.s.gb.size_in_bits < this.s.gb.get_bits_count()) {
            sps.num_reorder_frames = 0;
            sps.bitstream_restriction_flag = 0;
        }
        if (sps.num_reorder_frames <= 16) return 0;
        return -1;
    }

    public static void build_qp_table(PictureParameterSet pps, int t, int index) {
        for (int i = 0; i < 52; ++i) {
            pps.chroma_qp_table[t][i] = ff_h264_chroma_qp[H264Context.av_clip(i + index, 0, 51)];
        }
    }

    public int ff_h264_decode_picture_parameter_set(int bit_length) {
        int k;
        int pps_id = this.s.gb.get_ue_golomb("pps_id");
        if (pps_id >= 256) {
            return -1;
        }
        PictureParameterSet pps = new PictureParameterSet();
        if (pps == null) {
            return -1;
        }
        pps.sps_id = this.s.gb.get_ue_golomb_31("sps_id");
        if (pps.sps_id >= 32L || this.sps_buffers[(int)pps.sps_id] == null) {
            return -1;
        }
        pps.cabac = (int)this.s.gb.get_bits1("cabac");
        pps.pic_order_present = (int)this.s.gb.get_bits1("pic_order_present");
        pps.slice_group_count = this.s.gb.get_ue_golomb("slice_group_count") + 1;
        if (pps.slice_group_count > 1) {
            pps.mb_slice_group_map_type = this.s.gb.get_ue_golomb("mb_slice_group_map_type");
            switch (pps.mb_slice_group_map_type) {
                case 0: {
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    break;
                }
            }
        }
        pps.ref_count[0] = this.s.gb.get_ue_golomb("ref_count[0]") + 1;
        pps.ref_count[1] = this.s.gb.get_ue_golomb("ref_count[1]") + 1;
        if (pps.ref_count[0] - 1L > 31L || pps.ref_count[1] - 1L > 31L) {
            return -1;
        }
        pps.weighted_pred = (int)this.s.gb.get_bits1("weighted_pred");
        pps.weighted_bipred_idc = (int)this.s.gb.get_bits(2, "weighted_bipred_idc");
        pps.init_qp = this.s.gb.get_se_golomb("init_qp") + 26;
        pps.init_qs = this.s.gb.get_se_golomb("init_qs") + 26;
        pps.chroma_qp_index_offset[0] = this.s.gb.get_se_golomb("chroma_qp_index_offset[0]");
        pps.deblocking_filter_parameters_present = (int)this.s.gb.get_bits1("deblocking_filter_parameters_present");
        pps.constrained_intra_pred = (int)this.s.gb.get_bits1("constrained_intra_pred");
        pps.redundant_pic_cnt_present = (int)this.s.gb.get_bits1("redundant_pic_cnt_present");
        pps.transform_8x8_mode = 0;
        this.dequant_coeff_pps = -1;
        for (k = 0; k < this.sps_buffers[(int)pps.sps_id].scaling_matrix4.length; ++k) {
            System.arraycopy(this.sps_buffers[(int)pps.sps_id].scaling_matrix4[k], 0, pps.scaling_matrix4[k], 0, this.sps_buffers[(int)pps.sps_id].scaling_matrix4[k].length);
        }
        for (k = 0; k < this.sps_buffers[(int)pps.sps_id].scaling_matrix8.length; ++k) {
            System.arraycopy(this.sps_buffers[(int)pps.sps_id].scaling_matrix8[k], 0, pps.scaling_matrix8[k], 0, this.sps_buffers[(int)pps.sps_id].scaling_matrix8[k].length);
        }
        if (this.s.gb.get_bits_count() < bit_length) {
            pps.transform_8x8_mode = (int)this.s.gb.get_bits1("transform_8x8_mode");
            this.decode_scaling_matrices(this.sps_buffers[(int)pps.sps_id], pps, 0, pps.scaling_matrix4, pps.scaling_matrix8);
            pps.chroma_qp_index_offset[1] = this.s.gb.get_se_golomb("chroma_qp_index_offset[1]");
        } else {
            pps.chroma_qp_index_offset[1] = pps.chroma_qp_index_offset[0];
        }
        H264Context.build_qp_table(pps, 0, pps.chroma_qp_index_offset[0]);
        H264Context.build_qp_table(pps, 1, pps.chroma_qp_index_offset[1]);
        if (pps.chroma_qp_index_offset[0] != pps.chroma_qp_index_offset[1]) {
            pps.chroma_qp_diff = 1;
        }
        this.pps_buffers[pps_id] = null;
        this.pps_buffers[pps_id] = pps;
        return 0;
    }

    public int ff_h264_decode_seq_parameter_set() {
        int k;
        int profile_idc = (int)this.s.gb.get_bits(8, "profile_idc");
        this.s.gb.get_bits1("constraint_set0_flag");
        this.s.gb.get_bits1("constraint_set1_flag");
        this.s.gb.get_bits1("constraint_set2_flag");
        this.s.gb.get_bits1("constraint_set3_flag");
        this.s.gb.get_bits(4, "reserved");
        int level_idc = (int)this.s.gb.get_bits(8, "level_idc");
        int sps_id = this.s.gb.get_ue_golomb_31("sps_id");
        if (sps_id >= 32) {
            return -1;
        }
        SequenceParameterSet sps = new SequenceParameterSet();
        if (sps == null) {
            return -1;
        }
        sps.time_offset_length = 24;
        sps.profile_idc = profile_idc;
        sps.level_idc = level_idc;
        for (k = 0; k < sps.scaling_matrix4.length; ++k) {
            Arrays.fill(sps.scaling_matrix4[k], 16);
        }
        for (k = 0; k < sps.scaling_matrix8.length; ++k) {
            Arrays.fill(sps.scaling_matrix8[k], 16);
        }
        sps.scaling_matrix_present = 0;
        if (sps.profile_idc >= 100) {
            sps.chroma_format_idc = this.s.gb.get_ue_golomb_31("chroma_format_idc");
            if (sps.chroma_format_idc == 3) {
                sps.residual_color_transform_flag = (int)this.s.gb.get_bits1("residual_color_transform_flag");
            }
            sps.bit_depth_luma = this.s.gb.get_ue_golomb("bit_depth_luma") + 8;
            sps.bit_depth_chroma = this.s.gb.get_ue_golomb("bit_depth_chroma") + 8;
            sps.transform_bypass = (int)this.s.gb.get_bits1("transform_bypass");
            this.decode_scaling_matrices(sps, null, 1, sps.scaling_matrix4, sps.scaling_matrix8);
        } else {
            sps.chroma_format_idc = 1;
            sps.bit_depth_luma = 8;
            sps.bit_depth_chroma = 8;
        }
        sps.log2_max_frame_num = this.s.gb.get_ue_golomb("log2_max_frame_num") + 4;
        sps.poc_type = this.s.gb.get_ue_golomb_31("poc_type");
        if (sps.poc_type == 0) {
            sps.log2_max_poc_lsb = this.s.gb.get_ue_golomb("log2_max_poc_lsb") + 4;
        } else if (sps.poc_type == 1) {
            sps.delta_pic_order_always_zero_flag = (int)this.s.gb.get_bits1("delta_pic_order_always_zero_flag");
            sps.offset_for_non_ref_pic = this.s.gb.get_se_golomb("offset_for_non_ref_pic");
            sps.offset_for_top_to_bottom_field = this.s.gb.get_se_golomb("offset_for_top_to_bottom_field");
            sps.poc_cycle_length = this.s.gb.get_ue_golomb("poc_cycle_length");
            if (sps.poc_cycle_length >= sps.offset_for_ref_frame.length) {
                return -1;
            }
            for (int i = 0; i < sps.poc_cycle_length; ++i) {
                sps.offset_for_ref_frame[i] = (short)this.s.gb.get_se_golomb("offset_for_ref_frame");
            }
        } else if (sps.poc_type != 2) {
            return -1;
        }
        sps.ref_frame_count = this.s.gb.get_ue_golomb_31("ref_frame_count");
        if (sps.ref_frame_count > 30 || sps.ref_frame_count >= 32) {
            return -1;
        }
        sps.gaps_in_frame_num_allowed_flag = (int)this.s.gb.get_bits1("gaps_in_frame_num_allowed_flag");
        sps.mb_width = this.s.gb.get_ue_golomb("mb_width") + 1;
        sps.mb_height = this.s.gb.get_ue_golomb("mb_height") + 1;
        if (sps.mb_width >= 0x7FFFFFF || sps.mb_height >= 0x7FFFFFF || MpegEncContext.av_image_check_size(16 * sps.mb_width, 16 * sps.mb_height, 0, this.s) != 0) {
            return -1;
        }
        sps.frame_mbs_only_flag = (int)this.s.gb.get_bits1("frame_mbs_only_flag");
        sps.mb_aff = 0 == sps.frame_mbs_only_flag ? (int)this.s.gb.get_bits1("mb_aff") : 0;
        sps.direct_8x8_inference_flag = (int)this.s.gb.get_bits1("direct_8x8_inference_flag");
        if (0 == sps.frame_mbs_only_flag && 0 == sps.direct_8x8_inference_flag) {
            return -1;
        }
        sps.crop = (int)this.s.gb.get_bits1("crop");
        if (sps.crop != 0) {
            sps.crop_left = this.s.gb.get_ue_golomb("crop_left");
            sps.crop_right = this.s.gb.get_ue_golomb("crop_right");
            sps.crop_top = this.s.gb.get_ue_golomb("crop_top");
            sps.crop_bottom = this.s.gb.get_ue_golomb("crop_bottom");
            if (sps.crop_left != 0L || sps.crop_top != 0L) {
                // empty if block
            }
            if (sps.crop_right < 8L && sps.crop_bottom >= 8L) {
                // empty if block
            }
        } else {
            sps.crop_bottom = 0L;
            sps.crop_top = 0L;
            sps.crop_right = 0L;
            sps.crop_left = 0L;
        }
        sps.vui_parameters_present_flag = (int)this.s.gb.get_bits1("vui_parameters_present_flag");
        if (0 != sps.vui_parameters_present_flag && this.decode_vui_parameters(sps) < 0) {
            return -1;
        }
        if (0 == sps.sar.den) {
            sps.sar.den = 1;
        }
        this.sps_buffers[sps_id] = sps;
        this.sps = sps;
        return 0;
    }

    public int decode_nal_units(int[] buf_base, int buf_offset, int buf_size) {
        int buf_index = 0;
        H264Context hx = this;
        int context_count = 0;
        int next_avc = this.is_avc != 0 ? 0 : buf_size;
        this.max_contexts = 1;
        if (0 == (this.s.flags2 & 0x8000)) {
            this.current_slice = 0;
            if (0 == this.s.first_field) {
                this.s.current_picture_ptr = null;
            }
            SEIDecoder.ff_h264_reset_sei(this);
        }
        while (true) {
            int bit_length;
            int i;
            int nalsize = 0;
            if (buf_index >= next_avc) {
                if (buf_index >= buf_size) break;
                nalsize = 0;
                for (i = 0; i < this.nal_length_size; ++i) {
                    nalsize = nalsize << 8 | buf_base[buf_offset + buf_index++];
                }
                if (nalsize <= 0 || nalsize > buf_size - buf_index) break;
                next_avc = buf_index + nalsize;
            } else {
                while (buf_index + 3 < next_avc && (buf_base[buf_offset + buf_index] != 0 || buf_base[buf_offset + buf_index + 1] != 0 || buf_base[buf_offset + buf_index + 2] != 1)) {
                    ++buf_index;
                }
                if (buf_index + 3 >= buf_size) break;
                if ((buf_index += 3) >= next_avc) continue;
            }
            hx = this.thread_context[context_count];
            int[] param = new int[3];
            int[] ptr_base = hx.ff_h264_decode_nal(buf_base, buf_offset + buf_index, param, next_avc - buf_index);
            int dst_length = param[0];
            int consumed = param[1];
            int ptr_offset = param[2];
            if (ptr_base == null || dst_length < 0) {
                return -1;
            }
            i = buf_index + consumed;
            if ((this.s.workaround_bugs & 1) != 0 && i + 3 < next_avc && buf_base[buf_offset + i] == 0 && buf_base[buf_offset + i + 1] == 0 && buf_base[buf_offset + i + 2] == 1 && buf_base[buf_offset + i + 3] == 224) {
                this.s.workaround_bugs |= 0x4000;
            }
            if (0 == (this.s.workaround_bugs & 0x4000)) {
                while (ptr_base[ptr_offset + dst_length - 1] == 0 && dst_length > 0) {
                    --dst_length;
                }
            }
            int n = bit_length = dst_length == 0 ? 0 : 8 * dst_length - this.ff_h264_decode_rbsp_trailing(ptr_base, ptr_offset + dst_length - 1);
            if (this.is_avc == 0 || nalsize == consumed || nalsize != 0) {
                // empty if block
            }
            buf_index += consumed;
            if (this.s.hurry_up == 1 && this.nal_ref_idc == 0 || this.s.skip_frame >= 8 && this.nal_ref_idc == 0) continue;
            boolean doAgain = false;
            do {
                doAgain = false;
                int err = 0;
                switch (hx.nal_unit_type) {
                    case 5: {
                        if (this.nal_unit_type != 5) {
                            return -1;
                        }
                        this.idr();
                    }
                    case 1: {
                        hx.s.gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        hx.intra_gb_ptr = hx.inter_gb_ptr = hx.s.gb;
                        hx.s.data_partitioning = 0;
                        err = H264Context.decode_slice_header(hx, this);
                        if (err != 0) break;
                        if (this.current_slice == 1) {
                            // empty if block
                        }
                        this.s.current_picture_ptr.key_frame = this.s.current_picture_ptr.key_frame | (hx.nal_unit_type == 5 || this.sei_recovery_frame_cnt >= 0 ? 1 : 0);
                        if (hx.redundant_pic_count != 0 || hx.s.hurry_up >= 5 || this.s.skip_frame >= 8 && hx.nal_ref_idc == 0 || this.s.skip_frame >= 16 && hx.slice_type_nos == 3 || this.s.skip_frame >= 32 && hx.slice_type_nos != 1 || this.s.skip_frame >= 48 || this.s.hwaccel != 0) break;
                        ++context_count;
                        break;
                    }
                    case 2: {
                        hx.s.gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        hx.inter_gb_ptr = null;
                        hx.intra_gb_ptr = null;
                        err = H264Context.decode_slice_header(hx, this);
                        if (err < 0) break;
                        hx.s.data_partitioning = 1;
                        break;
                    }
                    case 3: {
                        hx.intra_gb = new GetBitContext();
                        hx.intra_gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        hx.intra_gb_ptr = hx.intra_gb;
                        break;
                    }
                    case 4: {
                        hx.inter_gb = new GetBitContext();
                        hx.inter_gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        hx.inter_gb_ptr = hx.inter_gb;
                        if (hx.redundant_pic_count != 0 || hx.intra_gb_ptr == null || hx.s.data_partitioning == 0 || this.s.context_initialized == 0 || this.s.hurry_up >= 5 || this.s.skip_frame >= 8 && hx.nal_ref_idc == 0 || this.s.skip_frame >= 16 && hx.slice_type_nos == 3 || this.s.skip_frame >= 32 && hx.slice_type_nos != 1 || this.s.skip_frame >= 48) break;
                        ++context_count;
                        break;
                    }
                    case 6: {
                        this.s.gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        this.ff_h264_decode_sei();
                        break;
                    }
                    case 7: {
                        this.s.gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        this.ff_h264_decode_seq_parameter_set();
                        if ((this.s.flags & 0x80000) != 0) {
                            this.s.low_delay = 1;
                        }
                        if (this.s.has_b_frames >= 2) break;
                        this.s.has_b_frames = 0 == this.s.low_delay ? 1 : 0;
                        break;
                    }
                    case 8: {
                        this.s.gb.init_get_bits(ptr_base, ptr_offset, bit_length);
                        this.ff_h264_decode_picture_parameter_set(bit_length);
                        break;
                    }
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 19: {
                        break;
                    }
                }
                if (context_count == this.max_contexts) {
                    this.decode_slice();
                    context_count = 0;
                }
                if (err < 0 || err != 1) continue;
                this.nal_unit_type = hx.nal_unit_type;
                this.nal_ref_idc = hx.nal_ref_idc;
                hx = this;
                doAgain = true;
            } while (doAgain);
        }
        if (context_count != 0) {
            this.decode_slice();
        }
        return buf_index;
    }

    public AVFrame find_short(int frame_num, int[] idx) {
        for (int i = 0; i < this.short_ref_count; ++i) {
            AVFrame pic = this.short_ref[i];
            if (pic.frame_num != frame_num) continue;
            idx[0] = i;
            return pic;
        }
        return null;
    }

    public int pic_num_extract(int pic_num, int[] structure) {
        structure[0] = this.s.picture_structure;
        if (this.s.picture_structure != 3) {
            if (0 == (pic_num & 1)) {
                structure[0] = structure[0] ^ 3;
            }
            pic_num >>= 1;
        }
        return pic_num;
    }

    public int ff_h264_execute_ref_pic_marking(MMCO[] mmco, int mmco_count) {
        int i;
        int j = 0;
        boolean current_ref_assigned = false;
        AVFrame pic = null;
        block8: for (i = 0; i < mmco_count; ++i) {
            int[] param;
            int structure = 0;
            int frame_num = 0;
            if (mmco[i].opcode == 1 || mmco[i].opcode == 3) {
                param = new int[1];
                frame_num = this.pic_num_extract(mmco[i].short_pic_num, param);
                structure = param[0];
                pic = this.find_short(frame_num, param);
                j = param[0];
                if (null == pic) continue;
            }
            switch (mmco[i].opcode) {
                case 1: {
                    this.remove_short(frame_num, structure ^ 3);
                    continue block8;
                }
                case 3: {
                    if (this.long_ref[mmco[i].long_arg] != pic) {
                        this.remove_long(mmco[i].long_arg, 0);
                    }
                    this.remove_short_at_index(j);
                    this.long_ref[mmco[i].long_arg] = pic;
                    if (this.long_ref[mmco[i].long_arg] == null) continue block8;
                    this.long_ref[mmco[i].long_arg].long_ref = 1;
                    ++this.long_ref_count;
                    continue block8;
                }
                case 2: {
                    param = new int[]{structure};
                    j = this.pic_num_extract(mmco[i].long_arg, param);
                    structure = param[0];
                    pic = this.long_ref[j];
                    if (pic == null) continue block8;
                    this.remove_long(j, structure ^ 3);
                    continue block8;
                }
                case 6: {
                    if (this.long_ref[mmco[i].long_arg] != this.s.current_picture_ptr) {
                        this.remove_long(mmco[i].long_arg, 0);
                        this.long_ref[mmco[i].long_arg] = this.s.current_picture_ptr;
                        this.long_ref[mmco[i].long_arg].long_ref = 1;
                        ++this.long_ref_count;
                    }
                    this.s.current_picture_ptr.reference |= this.s.picture_structure;
                    current_ref_assigned = true;
                    continue block8;
                }
                case 4: {
                    for (j = mmco[i].long_arg; j < 16; ++j) {
                        this.remove_long(j, 0);
                    }
                    continue block8;
                }
                case 5: {
                    while (this.short_ref_count != 0) {
                        this.remove_short(this.short_ref[0].frame_num, 0);
                    }
                    for (j = 0; j < 16; ++j) {
                        this.remove_long(j, 0);
                    }
                    this.s.current_picture_ptr.frame_num = 0;
                    this.frame_num = 0;
                    this.poc_msb = 0;
                    this.poc_lsb = 0;
                    this.s.current_picture_ptr.field_poc[1] = 0;
                    this.s.current_picture_ptr.field_poc[0] = 0;
                    this.s.current_picture_ptr.poc = 0;
                    this.s.current_picture_ptr.mmco_reset = 1;
                    continue block8;
                }
            }
        }
        if (!current_ref_assigned) {
            if (0 != this.short_ref_count && this.short_ref[0] == this.s.current_picture_ptr) {
                this.s.current_picture_ptr.reference = 3;
            } else if (0 == this.s.current_picture_ptr.long_ref) {
                pic = this.remove_short(this.s.current_picture_ptr.frame_num, 0);
                if (pic != null) {
                    // empty if block
                }
                if (this.short_ref_count != 0) {
                    for (int k = this.short_ref_count; k >= 1; --k) {
                        this.short_ref[k] = this.short_ref[k - 1];
                    }
                }
                this.short_ref[0] = this.s.current_picture_ptr;
                ++this.short_ref_count;
                this.s.current_picture_ptr.reference |= this.s.picture_structure;
            }
        }
        if (this.long_ref_count + this.short_ref_count > this.sps.ref_frame_count) {
            if (this.long_ref_count != 0 && 0 == this.short_ref_count) {
                for (i = 0; i < 16 && this.long_ref[i] == null; ++i) {
                }
                this.remove_long(i, 0);
            } else {
                pic = this.short_ref[this.short_ref_count - 1];
                this.remove_short(pic.frame_num, 0);
            }
        }
        return 0;
    }

    public void field_end() {
        this.s.mb_y = 0;
        this.s.current_picture_ptr.qscale_type = 2;
        this.s.current_picture_ptr.pict_type = this.s.pict_type;
        if (0 == this.s.dropable) {
            this.ff_h264_execute_ref_pic_marking(this.mmco, this.mmco_index);
            this.prev_poc_msb = this.poc_msb;
            this.prev_poc_lsb = this.poc_lsb;
        }
        this.prev_frame_num_offset = this.frame_num_offset;
        this.prev_frame_num = this.frame_num;
        if (this.s.picture_structure == 3) {
            ErrorResilience.ff_er_frame_end(this.s);
        }
        this.s.MPV_frame_end();
        this.current_slice = 0;
    }

    public static int av_cmp_q(AVRational a, AVRational b) {
        long tmp = (long)a.num * (long)b.den - (long)b.num * (long)a.den;
        if (tmp != 0L) {
            return (int)((tmp ^ (long)a.den ^ (long)b.den) >> 63 | 1L);
        }
        if (b.den != 0 && a.den != 0) {
            return 0;
        }
        if (a.num != 0 && b.num != 0) {
            return (a.num >> 31) - (b.num >> 31);
        }
        return Integer.MIN_VALUE;
    }

    public void free_tables() {
        this.intra4x4_pred_mode = null;
        this.chroma_pred_mode_table = null;
        this.cbp_table = null;
        this.mvd_table[0] = null;
        this.mvd_table[1] = null;
        this.direct_table = null;
        this.non_zero_count = null;
        this.slice_table_base = null;
        this.list_counts = null;
        this.mb2b_xy = null;
        this.mb2br_xy = null;
        for (int i = 0; i < 1; ++i) {
            H264Context hx = this.thread_context[i];
            if (hx == null) continue;
            hx.top_borders[1] = null;
            hx.top_borders[0] = null;
            hx.s.obmc_scratchpad = null;
            hx.rbsp_buffer[1] = null;
            hx.rbsp_buffer[0] = null;
            hx.rbsp_buffer_size[0] = 0L;
            hx.rbsp_buffer_size[1] = 0L;
            if (i == 0) continue;
            this.thread_context[i] = null;
        }
    }

    public static long av_gcd(long a, long b) {
        if (b != 0L) {
            return H264Context.av_gcd(b, a % b);
        }
        return a;
    }

    public static int av_reduce(int[] num_den, long num, long den, long max) {
        AVRational a0 = new AVRational(0, 1);
        AVRational a1 = new AVRational(1, 0);
        boolean sign = num < 0L ^ den < 0L;
        long gcd = H264Context.av_gcd(Math.abs(num), Math.abs(den));
        if (gcd != 0L) {
            num = Math.abs(num) / gcd;
            den = Math.abs(den) / gcd;
        }
        if (num <= max && den <= max) {
            a1 = new AVRational(num, den);
            den = 0L;
        }
        while (den != 0L) {
            long x = num / den;
            long next_den = num - den * x;
            long a2n = x * (long)a1.num + (long)a0.num;
            long a2d = x * (long)a1.den + (long)a0.den;
            if (a2n > max || a2d > max) {
                if (a1.num != 0) {
                    x = (max - (long)a0.num) / (long)a1.num;
                }
                if (a1.den != 0) {
                    x = Math.min(x, (max - (long)a0.den) / (long)a1.den);
                }
                if (den * (2L * x * (long)a1.den + (long)a0.den) <= num * (long)a1.den) break;
                a1 = new AVRational(x * (long)a1.num + (long)a0.num, x * (long)a1.den + (long)a0.den);
                break;
            }
            a0 = a1;
            a1 = new AVRational(a2n, a2d);
            num = den;
            den = next_den;
        }
        num_den[0] = sign ? -a1.num : a1.num;
        num_den[1] = a1.den;
        return den == 0L ? 1 : 0;
    }

    public void init_dequant8_coeff_table() {
        this.dequant8_coeff[0] = this.dequant8_buffer[0];
        this.dequant8_coeff[1] = this.dequant8_buffer[1];
        for (int i = 0; i < 2; ++i) {
            if (i != 0 && Arrays.equals(this.pps.scaling_matrix8[0], this.pps.scaling_matrix8[1])) {
                this.dequant8_coeff[1] = this.dequant8_buffer[0];
                break;
            }
            for (int q = 0; q < 52; ++q) {
                int shift = div6[q];
                int idx = rem6[q];
                for (int x = 0; x < 64; ++x) {
                    this.dequant8_coeff[i][q][x >> 3 | (x & 7) << 3] = H264Data.dequant8_coeff_init[idx][H264Data.dequant8_coeff_init_scan[x >> 1 & 0xC | x & 3]] * this.pps.scaling_matrix8[i][x] << shift;
                }
            }
        }
    }

    public void init_dequant4_coeff_table() {
        for (int i = 0; i < 6; ++i) {
            int j;
            this.dequant4_coeff[i] = this.dequant4_buffer[i];
            for (j = 0; j < i; ++j) {
                if (!Arrays.equals(this.pps.scaling_matrix4[j], this.pps.scaling_matrix4[i])) continue;
                this.dequant4_coeff[i] = this.dequant4_buffer[j];
                break;
            }
            if (j < i) continue;
            for (int q = 0; q < 52; ++q) {
                int shift = div6[q] + 2;
                int idx = rem6[q];
                for (int x = 0; x < 16; ++x) {
                    this.dequant4_coeff[i][q][x >> 2 | x << 2 & 0xF] = H264Data.dequant4_coeff_init[idx][(x & 1) + (x >> 2 & 1)] * this.pps.scaling_matrix4[i][x] << shift;
                }
            }
        }
    }

    public void init_dequant_tables() {
        this.init_dequant4_coeff_table();
        if (this.pps.transform_8x8_mode != 0) {
            this.init_dequant8_coeff_table();
        }
        if (this.sps.transform_bypass != 0) {
            int x;
            int i;
            for (i = 0; i < 6; ++i) {
                for (x = 0; x < 16; ++x) {
                    this.dequant4_coeff[i][0][x] = 64L;
                }
            }
            if (this.pps.transform_8x8_mode != 0) {
                for (i = 0; i < 2; ++i) {
                    for (x = 0; x < 64; ++x) {
                        this.dequant8_coeff[i][0][x] = 64L;
                    }
                }
            }
        }
    }

    public void init_scan_tables() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.zigzag_scan[i] = H264Data.zigzag_scan[i] >> 2 | H264Data.zigzag_scan[i] << 2 & 0xF;
            this.field_scan[i] = H264Data.field_scan[i] >> 2 | H264Data.field_scan[i] << 2 & 0xF;
        }
        for (i = 0; i < 64; ++i) {
            this.zigzag_scan8x8[i] = ff_zigzag_direct[i] >> 3 | (ff_zigzag_direct[i] & 7) << 3;
            this.zigzag_scan8x8_cavlc[i] = H264Data.zigzag_scan8x8_cavlc[i] >> 3 | (H264Data.zigzag_scan8x8_cavlc[i] & 7) << 3;
            this.field_scan8x8[i] = H264Data.field_scan8x8[i] >> 3 | (H264Data.field_scan8x8[i] & 7) << 3;
            this.field_scan8x8_cavlc[i] = H264Data.field_scan8x8_cavlc[i] >> 3 | (H264Data.field_scan8x8_cavlc[i] & 7) << 3;
        }
        if (this.sps.transform_bypass != 0) {
            this.zigzag_scan_q0 = H264Data.zigzag_scan;
            this.zigzag_scan8x8_q0 = ff_zigzag_direct;
            this.zigzag_scan8x8_cavlc_q0 = H264Data.zigzag_scan8x8_cavlc;
            this.field_scan_q0 = H264Data.field_scan;
            this.field_scan8x8_q0 = H264Data.field_scan8x8;
            this.field_scan8x8_cavlc_q0 = H264Data.field_scan8x8_cavlc;
        } else {
            this.zigzag_scan_q0 = this.zigzag_scan;
            this.zigzag_scan8x8_q0 = this.zigzag_scan8x8;
            this.zigzag_scan8x8_cavlc_q0 = this.zigzag_scan8x8_cavlc;
            this.field_scan_q0 = this.field_scan;
            this.field_scan8x8_q0 = this.field_scan8x8;
            this.field_scan8x8_cavlc_q0 = this.field_scan8x8_cavlc;
        }
    }

    public int ff_h264_alloc_tables() {
        int big_mb_num = this.s.mb_stride * (this.s.mb_height + 1);
        int row_mb_num = 2 * this.s.mb_stride * this.s.thread_count;
        this.intra4x4_pred_mode = new int[row_mb_num * 8];
        this.non_zero_count = new int[big_mb_num][32];
        this.slice_table_base = new int[big_mb_num + this.s.mb_stride];
        this.cbp_table = new int[big_mb_num];
        this.chroma_pred_mode_table = new int[big_mb_num];
        this.mvd_table[0] = new int[8 * row_mb_num][2];
        this.mvd_table[1] = new int[8 * row_mb_num][2];
        this.direct_table = new int[4 * big_mb_num];
        this.list_counts = new int[big_mb_num];
        Arrays.fill(this.slice_table_base, 65535);
        this.slice_table_offset = this.s.mb_stride * 2 + 1;
        this.mb2b_xy = new long[big_mb_num];
        this.mb2br_xy = new long[big_mb_num];
        for (int y = 0; y < this.s.mb_height; ++y) {
            for (int x = 0; x < this.s.mb_width; ++x) {
                int mb_xy = x + y * this.s.mb_stride;
                int b_xy = 4 * x + 4 * y * this.b_stride;
                this.mb2b_xy[mb_xy] = b_xy;
                this.mb2br_xy[mb_xy] = 8 * (mb_xy % (2 * this.s.mb_stride));
            }
        }
        this.s.obmc_scratchpad = null;
        if (null == this.dequant4_coeff[0]) {
            this.init_dequant_tables();
        }
        return 0;
    }

    public int context_init() {
        this.top_borders[0] = new int[this.s.mb_width][32];
        this.top_borders[1] = new int[this.s.mb_width][32];
        this.ref_cache[1][H264Context.scan8[13] + 1] = -2;
        this.ref_cache[1][H264Context.scan8[7] + 1] = -2;
        this.ref_cache[1][H264Context.scan8[5] + 1] = -2;
        this.ref_cache[0][H264Context.scan8[13] + 1] = -2;
        this.ref_cache[0][H264Context.scan8[7] + 1] = -2;
        this.ref_cache[0][H264Context.scan8[5] + 1] = -2;
        return 0;
    }

    public int ff_h264_frame_start() {
        int i;
        if (this.s.MPV_frame_start() < 0) {
            return -1;
        }
        ErrorResilience.ff_er_frame_start(this.s);
        this.s.current_picture_ptr.key_frame = 0;
        this.s.current_picture_ptr.mmco_reset = 0;
        for (i = 0; i < 16; ++i) {
            this.block_offset[i] = 4 * (scan8[i] - scan8[0] & 7) + 4 * this.s.linesize * (scan8[i] - scan8[0] >> 3);
            this.block_offset[24 + i] = 4 * (scan8[i] - scan8[0] & 7) + 8 * this.s.linesize * (scan8[i] - scan8[0] >> 3);
        }
        for (i = 0; i < 4; ++i) {
            int n = 4 * (scan8[i] - scan8[0] & 7) + 4 * this.s.uvlinesize * (scan8[i] - scan8[0] >> 3);
            this.block_offset[20 + i] = n;
            this.block_offset[16 + i] = n;
            int n2 = 4 * (scan8[i] - scan8[0] & 7) + 8 * this.s.uvlinesize * (scan8[i] - scan8[0] >> 3);
            this.block_offset[44 + i] = n2;
            this.block_offset[40 + i] = n2;
        }
        for (i = 0; i < this.s.thread_count; ++i) {
            if (this.thread_context[i] == null || null != this.thread_context[i].s.obmc_scratchpad) continue;
            this.thread_context[i].s.obmc_scratchpad = new int[32 * this.s.linesize + 16 * this.s.uvlinesize];
        }
        if (this.s.codec_id != 24) {
            this.s.current_picture_ptr.reference = 0;
        }
        this.s.current_picture_ptr.field_poc[1] = Integer.MAX_VALUE;
        this.s.current_picture_ptr.field_poc[0] = Integer.MAX_VALUE;
        return 0;
    }

    public void ff_generate_sliding_window_mmcos() {
        this.mmco_index = 0;
        if (this.short_ref_count != 0 && this.long_ref_count + this.short_ref_count == this.sps.ref_frame_count && (this.s.picture_structure == 3 || 0 != this.s.first_field || 0 == this.s.current_picture_ptr.reference)) {
            if (this.mmco[0] == null) {
                this.mmco[0] = new MMCO();
            }
            if (this.mmco[1] == null) {
                this.mmco[1] = new MMCO();
            }
            this.mmco[0].opcode = 1;
            this.mmco[0].short_pic_num = this.short_ref[this.short_ref_count - 1].frame_num;
            this.mmco_index = 1;
            if (this.s.picture_structure != 3) {
                this.mmco[0].short_pic_num *= 2;
                this.mmco[1].opcode = 1;
                this.mmco[1].short_pic_num = this.mmco[0].short_pic_num + 1;
                this.mmco_index = 2;
            }
        }
    }

    public static void clone_slice(H264Context dst, H264Context src) {
        int k;
        int j;
        int i;
        System.arraycopy(src.block_offset, 0, dst.block_offset, 0, dst.block_offset.length);
        dst.s.current_picture_ptr = src.s.current_picture_ptr;
        dst.s.current_picture = src.s.current_picture;
        dst.s.linesize = src.s.linesize;
        dst.s.uvlinesize = src.s.uvlinesize;
        dst.s.first_field = src.s.first_field;
        dst.prev_poc_msb = src.prev_poc_msb;
        dst.prev_poc_lsb = src.prev_poc_lsb;
        dst.prev_frame_num_offset = src.prev_frame_num_offset;
        dst.prev_frame_num = src.prev_frame_num;
        dst.short_ref_count = src.short_ref_count;
        for (i = 0; i < src.short_ref.length; ++i) {
            src.short_ref[i].copyTo(dst.short_ref[i]);
        }
        for (i = 0; i < src.long_ref.length; ++i) {
            src.long_ref[i].copyTo(dst.long_ref[i]);
        }
        for (i = 0; i < src.default_ref_list.length; ++i) {
            for (j = 0; j < src.default_ref_list[i].length; ++j) {
                src.default_ref_list[i][j].copyTo(dst.default_ref_list[i][j]);
            }
        }
        for (i = 0; i < src.ref_list.length; ++i) {
            for (j = 0; j < src.ref_list[i].length; ++j) {
                src.ref_list[i][j].copyTo(dst.ref_list[i][j]);
            }
        }
        for (i = 0; i < src.dequant4_coeff.length; ++i) {
            for (j = 0; j < src.dequant4_coeff[i].length; ++j) {
                for (k = 0; k < src.dequant4_coeff[i][j].length; ++k) {
                    dst.dequant4_coeff[i][j][k] = src.dequant4_coeff[i][j][k];
                }
            }
        }
        for (i = 0; i < src.dequant8_coeff.length; ++i) {
            for (j = 0; j < src.dequant8_coeff[i].length; ++j) {
                for (k = 0; k < src.dequant8_coeff[i][j].length; ++k) {
                    dst.dequant8_coeff[i][j][k] = src.dequant8_coeff[i][j][k];
                }
            }
        }
    }

    public int init_poc() {
        int max_frame_num = 1 << this.sps.log2_max_frame_num;
        int[] field_poc = new int[2];
        AVFrame cur = this.s.current_picture_ptr;
        this.frame_num_offset = this.prev_frame_num_offset;
        if (this.frame_num < this.prev_frame_num) {
            this.frame_num_offset += max_frame_num;
        }
        if (this.sps.poc_type == 0) {
            int max_poc_lsb = 1 << this.sps.log2_max_poc_lsb;
            this.poc_msb = this.poc_lsb < this.prev_poc_lsb && this.prev_poc_lsb - this.poc_lsb >= max_poc_lsb / 2 ? this.prev_poc_msb + max_poc_lsb : (this.poc_lsb > this.prev_poc_lsb && this.prev_poc_lsb - this.poc_lsb < -max_poc_lsb / 2 ? this.prev_poc_msb - max_poc_lsb : this.prev_poc_msb);
            field_poc[0] = field_poc[1] = this.poc_msb + this.poc_lsb;
            if (this.s.picture_structure == 3) {
                field_poc[1] = field_poc[1] + this.delta_poc_bottom;
            }
        } else if (this.sps.poc_type == 1) {
            int expectedpoc;
            int i;
            int abs_frame_num = this.sps.poc_cycle_length != 0 ? this.frame_num_offset + this.frame_num : 0;
            if (this.nal_ref_idc == 0 && abs_frame_num > 0) {
                --abs_frame_num;
            }
            int expected_delta_per_poc_cycle = 0;
            for (i = 0; i < this.sps.poc_cycle_length; ++i) {
                expected_delta_per_poc_cycle += this.sps.offset_for_ref_frame[i];
            }
            if (abs_frame_num > 0) {
                int poc_cycle_cnt = (abs_frame_num - 1) / this.sps.poc_cycle_length;
                int frame_num_in_poc_cycle = (abs_frame_num - 1) % this.sps.poc_cycle_length;
                expectedpoc = poc_cycle_cnt * expected_delta_per_poc_cycle;
                for (i = 0; i <= frame_num_in_poc_cycle; ++i) {
                    expectedpoc += this.sps.offset_for_ref_frame[i];
                }
            } else {
                expectedpoc = 0;
            }
            if (this.nal_ref_idc == 0) {
                expectedpoc += this.sps.offset_for_non_ref_pic;
            }
            field_poc[0] = expectedpoc + this.delta_poc[0];
            field_poc[1] = field_poc[0] + this.sps.offset_for_top_to_bottom_field;
            if (this.s.picture_structure == 3) {
                field_poc[1] = field_poc[1] + this.delta_poc[1];
            }
        } else {
            int poc = 2 * (this.frame_num_offset + this.frame_num);
            if (0 == this.nal_ref_idc) {
                // empty if block
            }
            field_poc[0] = --poc;
            field_poc[1] = poc;
        }
        if (this.s.picture_structure != 2) {
            this.s.current_picture_ptr.field_poc[0] = field_poc[0];
        }
        if (this.s.picture_structure != 1) {
            this.s.current_picture_ptr.field_poc[1] = field_poc[1];
        }
        cur.poc = Math.min(cur.field_poc[0], cur.field_poc[1]);
        return 0;
    }

    public int ff_h264_fill_default_ref_list() {
        block9: {
            block8: {
                int i;
                for (int p = 0; p < this.default_ref_list.length; ++p) {
                    for (int k = 0; k < this.default_ref_list[p].length; ++k) {
                        if (this.default_ref_list[p][k] != null) continue;
                        this.default_ref_list[p][k] = new AVFrame();
                    }
                }
                if (this.slice_type_nos != 3) break block8;
                AVFrame[] sorted = new AVFrame[32];
                int[] lens = new int[2];
                int cur_poc = this.s.picture_structure != 3 ? this.s.current_picture_ptr.field_poc[this.s.picture_structure == 2 ? 1 : 0] : this.s.current_picture_ptr.poc;
                for (int list = 0; list < 2; ++list) {
                    int len = AVFrame.add_sorted(sorted, 0, this.short_ref, 0, this.short_ref_count, cur_poc, 1 ^ list);
                    len += AVFrame.add_sorted(sorted, len, this.short_ref, 0, this.short_ref_count, cur_poc, 0 ^ list);
                    len = AVFrame.build_def_list(this.default_ref_list[list], 0, sorted, 0, len, 0, this.s.picture_structure);
                    if ((long)(len += AVFrame.build_def_list(this.default_ref_list[list], len, this.long_ref, 0, 16, 1, this.s.picture_structure)) < this.ref_count[list]) {
                        int k = len;
                        while ((long)k < this.ref_count[list]) {
                            this.default_ref_list[list][k].resetToZero();
                            ++k;
                        }
                    }
                    lens[list] = len;
                }
                if (lens[0] != lens[1] || lens[1] <= 1) break block9;
                for (i = 0; this.default_ref_list[0][i].data_base[0] == this.default_ref_list[1][i].data_base[0] && this.default_ref_list[0][i].data_offset[0] == this.default_ref_list[1][i].data_offset[0] && i < lens[0]; ++i) {
                }
                if (i != lens[0]) break block9;
                AVFrame tmp = new AVFrame();
                this.default_ref_list[1][0].copyTo(tmp);
                this.default_ref_list[1][1].copyTo(this.default_ref_list[1][0]);
                tmp.copyTo(this.default_ref_list[1][1]);
                break block9;
            }
            int len = AVFrame.build_def_list(this.default_ref_list[0], 0, this.short_ref, 0, this.short_ref_count, 0, this.s.picture_structure);
            if ((long)(len += AVFrame.build_def_list(this.default_ref_list[0], len, this.long_ref, 0, 16, 1, this.s.picture_structure)) < this.ref_count[0]) {
                int k = len;
                while ((long)k < this.ref_count[0]) {
                    this.default_ref_list[0][k].resetToZero();
                    ++k;
                }
            }
        }
        return 0;
    }

    public int ff_h264_decode_ref_pic_list_reordering() {
        int index;
        int list = 0;
        while ((long)list < this.list_count) {
            int i = 0;
            while ((long)i < this.ref_count[list]) {
                if (this.ref_list[list][i] == null) {
                    this.ref_list[list][i] = new AVFrame();
                }
                this.default_ref_list[list][i].copyTo(this.ref_list[list][i]);
                ++i;
            }
            if (this.s.gb.get_bits1("reordering?") != 0L) {
                int pred = this.curr_pic_num;
                index = 0;
                while (true) {
                    int reordering_of_pic_nums_idc = this.s.gb.get_ue_golomb_31("reordering_of_pic_nums_idc");
                    AVFrame ref = null;
                    if (reordering_of_pic_nums_idc == 3) break;
                    if ((long)index >= this.ref_count[list]) {
                        return -1;
                    }
                    if (reordering_of_pic_nums_idc < 3) {
                        int i2;
                        int pic_structure;
                        if (reordering_of_pic_nums_idc < 2) {
                            int abs_diff_pic_num = this.s.gb.get_ue_golomb("abs_diff_pic_num") + 1;
                            if (abs_diff_pic_num > this.max_pic_num) {
                                return -1;
                            }
                            pred = reordering_of_pic_nums_idc == 0 ? (pred -= abs_diff_pic_num) : (pred += abs_diff_pic_num);
                            int[] param = new int[]{0};
                            int frame_num = this.pic_num_extract(pred &= this.max_pic_num - 1, param);
                            pic_structure = param[0];
                            for (i2 = this.short_ref_count - 1; i2 >= 0; --i2) {
                                ref = this.short_ref[i2];
                                if (ref.frame_num == frame_num && (ref.reference & pic_structure) != 0) break;
                            }
                            if (i2 >= 0) {
                                ref.pic_id = pred;
                            }
                        } else {
                            int pic_id = this.s.gb.get_ue_golomb("long_term_pic_idx");
                            int[] param = new int[]{0};
                            int long_idx = this.pic_num_extract(pic_id, param);
                            pic_structure = param[0];
                            if (long_idx > 31) {
                                return -1;
                            }
                            ref = this.long_ref[long_idx];
                            if (ref != null && (ref.reference & pic_structure) != 0) {
                                ref.pic_id = pic_id;
                                i2 = 0;
                            } else {
                                i2 = -1;
                            }
                        }
                        if (i2 < 0) {
                            this.ref_list[list][index].resetToZero();
                        } else {
                            i2 = index;
                            while ((long)(i2 + 1) < this.ref_count[list] && (ref.long_ref != this.ref_list[list][i2].long_ref || ref.pic_id != this.ref_list[list][i2].pic_id)) {
                                ++i2;
                            }
                            while (i2 > index) {
                                this.ref_list[list][i2 - 1].copyTo(this.ref_list[list][i2]);
                                --i2;
                            }
                            ref.copyTo(this.ref_list[list][index]);
                            if (this.s.picture_structure != 3) {
                                AVFrame.pic_as_field(this.ref_list[list][index], pic_structure);
                            }
                        }
                    } else {
                        return -1;
                    }
                    ++index;
                }
            }
            ++list;
        }
        list = 0;
        while ((long)list < this.list_count) {
            index = 0;
            while ((long)index < this.ref_count[list]) {
                if (null == this.ref_list[list][index].data_base[0]) {
                    if (null != this.default_ref_list[list][0].data_base[0]) {
                        this.default_ref_list[list][0].copyTo(this.ref_list[list][index]);
                    } else {
                        return -1;
                    }
                }
                ++index;
            }
            ++list;
        }
        return 0;
    }

    public int pred_weight_table() {
        this.use_weight = 0;
        this.use_weight_chroma = 0;
        this.luma_log2_weight_denom = this.s.gb.get_ue_golomb("luma_log2_weight_denom");
        if (this.sps.chroma_format_idc != 0) {
            this.chroma_log2_weight_denom = this.s.gb.get_ue_golomb("chroma_log2_weight_denom");
        }
        int luma_def = 1 << this.luma_log2_weight_denom;
        int chroma_def = 1 << this.chroma_log2_weight_denom;
        for (int list = 0; list < 2; ++list) {
            this.luma_weight_flag[list] = 0;
            this.chroma_weight_flag[list] = 0;
            int i = 0;
            while ((long)i < this.ref_count[list]) {
                int luma_weight_flag = (int)this.s.gb.get_bits1("luma_weight_flag");
                if (luma_weight_flag != 0) {
                    this.luma_weight[i][list][0] = this.s.gb.get_se_golomb("luma_weight");
                    this.luma_weight[i][list][1] = this.s.gb.get_se_golomb("luma_weight");
                    if (this.luma_weight[i][list][0] != luma_def || this.luma_weight[i][list][1] != 0) {
                        this.use_weight = 1;
                        this.luma_weight_flag[list] = 1;
                    }
                } else {
                    this.luma_weight[i][list][0] = luma_def;
                    this.luma_weight[i][list][1] = 0;
                }
                if (this.sps.chroma_format_idc != 0) {
                    int j;
                    int chroma_weight_flag = (int)this.s.gb.get_bits1("chroma_weight_flag");
                    if (chroma_weight_flag != 0) {
                        for (j = 0; j < 2; ++j) {
                            this.chroma_weight[i][list][j][0] = this.s.gb.get_se_golomb("chroma_weight");
                            this.chroma_weight[i][list][j][1] = this.s.gb.get_se_golomb("chroma_weight");
                            if (this.chroma_weight[i][list][j][0] == chroma_def && this.chroma_weight[i][list][j][1] == 0) continue;
                            this.use_weight_chroma = 1;
                            this.chroma_weight_flag[list] = 1;
                        }
                    } else {
                        for (j = 0; j < 2; ++j) {
                            this.chroma_weight[i][list][j][0] = chroma_def;
                            this.chroma_weight[i][list][j][1] = 0;
                        }
                    }
                }
                ++i;
            }
            if (this.slice_type_nos != 3) break;
        }
        this.use_weight = this.use_weight != 0 || this.use_weight_chroma != 0 ? 1 : 0;
        return 0;
    }

    public void implicit_weight_table(int field) {
        int ref_count1;
        int ref_count0;
        int ref_start;
        int cur_poc;
        for (int i = 0; i < 2; ++i) {
            this.luma_weight_flag[i] = 0;
            this.chroma_weight_flag[i] = 0;
        }
        if (field < 0) {
            cur_poc = this.s.current_picture_ptr.poc;
            if (this.ref_count[0] == 1L && this.ref_count[1] == 1L && 0 == this.mb_aff_frame && this.ref_list[0][0].poc + this.ref_list[1][0].poc == 2 * cur_poc) {
                this.use_weight = 0;
                this.use_weight_chroma = 0;
                return;
            }
            ref_start = 0;
            ref_count0 = (int)this.ref_count[0];
            ref_count1 = (int)this.ref_count[1];
        } else {
            cur_poc = this.s.current_picture_ptr.field_poc[field];
            ref_start = 16;
            ref_count0 = (int)(16L + 2L * this.ref_count[0]);
            ref_count1 = (int)(16L + 2L * this.ref_count[1]);
        }
        this.use_weight = 2;
        this.use_weight_chroma = 2;
        this.luma_log2_weight_denom = 5;
        this.chroma_log2_weight_denom = 5;
        for (int ref0 = ref_start; ref0 < ref_count0; ++ref0) {
            int poc0 = this.ref_list[0][ref0].poc;
            for (int ref1 = ref_start; ref1 < ref_count1; ++ref1) {
                int tx;
                int tb;
                int dist_scale_factor;
                int poc1 = this.ref_list[1][ref1].poc;
                int td = H264Context.av_clip(poc1 - poc0, -128, 127);
                int w = 32;
                if (td != 0 && (dist_scale_factor = (tb = H264Context.av_clip(cur_poc - poc0, -128, 127)) * (tx = (16384 + (Math.abs(td) >> 1)) / td) + 32 >> 8) >= -64 && dist_scale_factor <= 128) {
                    w = 64 - dist_scale_factor;
                }
                if (field < 0) {
                    int n = w;
                    this.implicit_weight[ref0][ref1][1] = n;
                    this.implicit_weight[ref0][ref1][0] = n;
                    continue;
                }
                this.implicit_weight[ref0][ref1][field] = w;
            }
        }
    }

    public int ff_h264_decode_ref_pic_marking(GetBitContext gb) {
        this.mmco_index = 0;
        if (this.nal_unit_type == 5) {
            this.s.broken_link = (int)gb.get_bits1("broken_link") - 1;
            if (gb.get_bits1("MMCO_LONG?") != 0L) {
                this.mmco[0].opcode = 6;
                this.mmco[0].long_arg = 0;
                this.mmco_index = 1;
            }
        } else if (gb.get_bits1("adaptive_ref_pic_marking_mode_flag") != 0L) {
            int i;
            for (i = 0; i < 66; ++i) {
                int opcode;
                this.mmco[i].opcode = opcode = gb.get_ue_golomb_31("MMCOOpcode");
                if (opcode == 1 || opcode == 3) {
                    this.mmco[i].short_pic_num = this.curr_pic_num - gb.get_ue_golomb("?") - 1 & this.max_pic_num - 1;
                }
                if (opcode == 3 || opcode == 2 || opcode == 6 || opcode == 4) {
                    int long_arg = gb.get_ue_golomb_31("long_arg");
                    if (long_arg >= 32 || long_arg >= 16 && (opcode != 2 || this.s.picture_structure == 3)) {
                        return -1;
                    }
                    this.mmco[i].long_arg = long_arg;
                }
                if (opcode > 6) {
                    return -1;
                }
                if (opcode == 0) break;
            }
            this.mmco_index = i;
        } else {
            this.ff_generate_sliding_window_mmcos();
        }
        return 0;
    }

    public void ff_h264_fill_mbaff_ref_list() {
        for (int list = 0; list < 2; ++list) {
            int i = 0;
            while ((long)i < this.ref_count[list]) {
                AVFrame frame = this.ref_list[list][i];
                AVFrame[] field_base = this.ref_list[list];
                int field_offset = 16 + 2 * i;
                frame.copyTo(field_base[field_offset + 0]);
                int j = 0;
                while (j < 3) {
                    int n = j++;
                    field_base[field_offset + 0].linesize[n] = field_base[field_offset + 0].linesize[n] << 1;
                }
                field_base[field_offset + 0].reference = 1;
                field_base[field_offset + 0].poc = field_base[field_offset + 0].field_poc[0];
                field_base[field_offset + 0].copyTo(field_base[field_offset + 1]);
                for (j = 0; j < 3; ++j) {
                    int n = j;
                    field_base[field_offset + 1].data_offset[n] = field_base[field_offset + 1].data_offset[n] + frame.linesize[j];
                }
                field_base[field_offset + 1].reference = 2;
                field_base[field_offset + 1].poc = field_base[field_offset + 1].field_poc[1];
                int n = this.luma_weight[i][list][0];
                this.luma_weight[16 + 2 * i + 1][list][0] = n;
                this.luma_weight[16 + 2 * i][list][0] = n;
                int n2 = this.luma_weight[i][list][1];
                this.luma_weight[16 + 2 * i + 1][list][1] = n2;
                this.luma_weight[16 + 2 * i][list][1] = n2;
                for (j = 0; j < 2; ++j) {
                    int n3 = this.chroma_weight[i][list][j][0];
                    this.chroma_weight[16 + 2 * i + 1][list][j][0] = n3;
                    this.chroma_weight[16 + 2 * i][list][j][0] = n3;
                    int n4 = this.chroma_weight[i][list][j][1];
                    this.chroma_weight[16 + 2 * i + 1][list][j][1] = n4;
                    this.chroma_weight[16 + 2 * i][list][j][1] = n4;
                }
                ++i;
            }
        }
    }

    public int get_scale_factor(int poc, int poc1, int i) {
        int poc0 = this.ref_list[0][i].poc;
        int td = H264Context.av_clip(poc1 - poc0, -128, 127);
        if (td == 0 || this.ref_list[0][i].long_ref != 0) {
            return 256;
        }
        int tb = H264Context.av_clip(poc - poc0, -128, 127);
        int tx = (16384 + (Math.abs(td) >> 1)) / td;
        return H264Context.av_clip(tb * tx + 32 >> 6, -1024, 1023);
    }

    public void ff_h264_direct_dist_scale_factor() {
        int i;
        int _poc = this.s.current_picture_ptr.field_poc[this.s.picture_structure == 2 ? 1 : 0];
        int _poc1 = this.ref_list[1][0].poc;
        for (int field = 0; field < 2; ++field) {
            int poc = this.s.current_picture_ptr.field_poc[field];
            int poc1 = this.ref_list[1][0].field_poc[field];
            i = 0;
            while ((long)i < 2L * this.ref_count[0]) {
                this.dist_scale_factor_field[field][i ^ field] = this.get_scale_factor(poc, poc1, i + 16);
                ++i;
            }
        }
        i = 0;
        while ((long)i < this.ref_count[0]) {
            this.dist_scale_factor[i] = this.get_scale_factor(_poc, _poc1, i);
            ++i;
        }
    }

    public void fill_colmap(int[][] map, int list, int field, int colfield, int mbafi) {
        AVFrame ref1 = this.ref_list[1][0];
        int start = mbafi != 0 ? 16 : 0;
        int end = (int)(mbafi != 0 ? 16L + 2L * this.ref_count[0] : this.ref_count[0]);
        boolean interl = mbafi != 0 || this.s.picture_structure != 3;
        for (int rfield = 0; rfield < 2; ++rfield) {
            block1: for (int old_ref = 0; old_ref < ref1.ref_count[colfield][list]; ++old_ref) {
                int poc = ref1.ref_poc[colfield][list][old_ref];
                if (!interl) {
                    poc |= 3;
                } else if (interl && (poc & 3) == 3) {
                    poc = (poc & 0xFFFFFFFC) + rfield + 1;
                }
                for (int j = start; j < end; ++j) {
                    int cur_ref;
                    if (4 * this.ref_list[0][j].frame_num + (this.ref_list[0][j].reference & 3) != poc) continue;
                    map[list][2 * old_ref + (rfield ^ field) + 16] = cur_ref = mbafi != 0 ? j - 16 ^ field : j;
                    if (rfield != field && interl) continue block1;
                    map[list][old_ref] = cur_ref;
                    continue block1;
                }
            }
        }
    }

    public void ff_h264_direct_ref_list_init() {
        int list;
        for (int i = 0; i < this.ref_list.length; ++i) {
            for (int j = 0; j < this.ref_list[i].length; ++j) {
                if (this.ref_list[i][j] != null) continue;
                this.ref_list[i][j] = new AVFrame();
            }
        }
        AVFrame ref1 = this.ref_list[1][0];
        AVFrame cur = this.s.current_picture_ptr;
        int sidx = this.s.picture_structure & 1 ^ 1;
        int ref1sidx = ref1.reference & 1 ^ 1;
        for (list = 0; list < 2; ++list) {
            cur.ref_count[sidx][list] = (int)this.ref_count[list];
            int j = 0;
            while ((long)j < this.ref_count[list]) {
                cur.ref_poc[sidx][list][j] = 4 * this.ref_list[list][j].frame_num + (this.ref_list[list][j].reference & 3);
                ++j;
            }
        }
        if (this.s.picture_structure == 3) {
            System.arraycopy(cur.ref_count[0], 0, cur.ref_count[1], 0, cur.ref_count[0].length);
            System.arraycopy(cur.ref_poc[0], 0, cur.ref_poc[1], 0, cur.ref_poc[0].length);
        }
        cur.mbaff = this.mb_aff_frame;
        this.col_fieldoff = 0;
        if (this.s.picture_structure == 3) {
            int[] col_poc = this.ref_list[1][0].field_poc;
            int cur_poc = this.s.current_picture_ptr.poc;
            ref1sidx = sidx = (this.col_parity = Math.abs(col_poc[0] - cur_poc) >= Math.abs(col_poc[1] - cur_poc) ? 1 : 0);
        } else if (0 == (this.s.picture_structure & this.ref_list[1][0].reference) && 0 == this.ref_list[1][0].mbaff) {
            this.col_fieldoff = this.s.mb_stride * (2 * this.ref_list[1][0].reference - 3);
        }
        if (cur.pict_type != 3 || this.direct_spatial_mv_pred != 0) {
            return;
        }
        for (list = 0; list < 2; ++list) {
            this.fill_colmap(this.map_col_to_list0, list, sidx, ref1sidx, 0);
            if (this.mb_aff_frame == 0) continue;
            for (int field = 0; field < 2; ++field) {
                this.fill_colmap(this.map_col_to_list0_field[field], list, field, field, 1);
            }
        }
    }

    public static int decode_slice_header(H264Context h, H264Context h0) {
        int tmp;
        int i;
        int slice_type;
        MpegEncContext s = h.s;
        MpegEncContext s0 = h0.s;
        boolean default_ref_list_done = false;
        s.dropable = h.nal_ref_idc == 0 ? 1 : 0;
        s.me.qpel_put = DSPContext.put_h264_qpel_pixels_tab;
        s.me.qpel_avg = DSPContext.avg_h264_qpel_pixels_tab;
        int first_mb_in_slice = s.gb.get_ue_golomb("first_mb_in_slice");
        if (first_mb_in_slice == 0) {
            if (h0.current_slice != 0 && s.picture_structure != 3) {
                h.field_end();
            }
            h0.current_slice = 0;
            if (0 == s0.first_field) {
                s.current_picture_ptr = null;
            }
        }
        if ((slice_type = s.gb.get_ue_golomb_31("slice_type")) > 9) {
            return -1;
        }
        if (slice_type > 4) {
            slice_type -= 5;
            h.slice_type_fixed = 1;
        } else {
            h.slice_type_fixed = 0;
        }
        slice_type = H264Data.golomb_to_pict_type[slice_type];
        if (slice_type == 1 || h0.current_slice != 0 && slice_type == h0.last_slice_type) {
            default_ref_list_done = true;
        }
        h.slice_type = slice_type;
        h.slice_type_nos = slice_type & 3;
        s.pict_type = h.slice_type;
        int pps_id = s.gb.get_ue_golomb("pps_id");
        if (pps_id >= 256) {
            return -1;
        }
        if (null == h0.pps_buffers[pps_id]) {
            return -1;
        }
        h0.pps_buffers[pps_id].copyTo(h.pps);
        if (null == h0.sps_buffers[(int)h.pps.sps_id]) {
            return -1;
        }
        h0.sps_buffers[(int)h.pps.sps_id].copyTo(h.sps);
        s.profile = h.sps.profile_idc;
        s.level = h.sps.level_idc;
        s.refs = h.sps.ref_frame_count;
        if (h == h0 && h.dequant_coeff_pps != pps_id) {
            h.dequant_coeff_pps = pps_id;
            h.init_dequant_tables();
        }
        s.mb_width = h.sps.mb_width;
        s.mb_height = h.sps.mb_height * (2 - h.sps.frame_mbs_only_flag);
        h.b_stride = s.mb_width * 4;
        s.width = (int)((long)(16 * s.mb_width) - 2L * Math.min(h.sps.crop_right, 7L));
        s.height = h.sps.frame_mbs_only_flag != 0 ? (int)((long)(16 * s.mb_height) - 2L * Math.min(h.sps.crop_bottom, 7L)) : (int)((long)(16 * s.mb_height) - 4L * Math.min(h.sps.crop_bottom, 7L));
        if (s.context_initialized != 0 && H264Context.av_cmp_q(h.sps.sar, s.sample_aspect_ratio) != 0) {
            if (h != h0) {
                return -1;
            }
            h.free_tables();
            s.flush_dpb();
            s.MPV_common_end();
        }
        if (0 == s.context_initialized) {
            if (h != h0) {
                return -1;
            }
            s.avcodec_set_dimensions(s.width, s.height);
            s.sample_aspect_ratio = h.sps.sar;
            if (0 != h.sps.video_signal_type_present_flag) {
                int n = s.color_range = h.sps.full_range != 0 ? 2 : 1;
                if (h.sps.colour_description_present_flag != 0) {
                    s.color_primaries = h.sps.color_primaries;
                    s.color_trc = h.sps.color_trc;
                    s.colorspace = h.sps.colorspace;
                }
            }
            if (h.sps.timing_info_present_flag != 0) {
                long den = h.sps.time_scale;
                if (h.x264_build < 44) {
                    den *= 2L;
                }
                int[] param = new int[]{s.time_base.num, s.time_base.den};
                H264Context.av_reduce(param, h.sps.num_units_in_tick, den, 0x40000000L);
                s.time_base.num = param[0];
                s.time_base.den = param[1];
            }
            s.pix_fmt = MpegEncContext.get_format(s.codec.pix_fmts != null ? s.codec.pix_fmts : (s.color_range == 2 ? hwaccel_pixfmt_list_h264_jpeg_420 : MpegEncContext.ff_hwaccel_pixfmt_list_420));
            s.hwaccel = 0;
            if (s.MPV_common_init() < 0) {
                return -1;
            }
            s.first_field = 0;
            h.prev_interlaced_frame = 1;
            h.init_scan_tables();
            h.ff_h264_alloc_tables();
            for (i = 0; i < s.thread_count; ++i) {
                if (h.thread_context[i].context_init() >= 0) continue;
                return -1;
            }
        }
        h.frame_num = (int)s.gb.get_bits(h.sps.log2_max_frame_num, "frame_num");
        h.mb_mbaff = 0;
        h.mb_aff_frame = 0;
        int last_pic_structure = s0.picture_structure;
        if (h.sps.frame_mbs_only_flag != 0) {
            s.picture_structure = 3;
        } else if (s.gb.get_bits1("field_pic_flag") != 0L) {
            s.picture_structure = (int)(1L + s.gb.get_bits1("bottom_field_flag"));
        } else {
            s.picture_structure = 3;
            h.mb_aff_frame = h.sps.mb_aff;
        }
        int n = h.mb_field_decoding_flag = s.picture_structure != 3 ? 1 : 0;
        if (h0.current_slice == 0) {
            while (h.frame_num != h.prev_frame_num && h.frame_num != (h.prev_frame_num + 1) % (1 << h.sps.log2_max_frame_num)) {
                AVFrame prev;
                AVFrame aVFrame = prev = h.short_ref_count != 0 ? h.short_ref[0] : null;
                if (h.ff_h264_frame_start() < 0) {
                    return -1;
                }
                ++h.prev_frame_num;
                h.prev_frame_num %= 1 << h.sps.log2_max_frame_num;
                s.current_picture_ptr.frame_num = h.prev_frame_num;
                h.ff_generate_sliding_window_mmcos();
                h.ff_h264_execute_ref_pic_marking(h.mmco, h.mmco_index);
                if (h.short_ref_count == 0) continue;
                if (prev != null) {
                    ImageUtils.av_image_copy(h.short_ref[0].data_base, h.short_ref[0].data_offset, h.short_ref[0].linesize, prev.data_base, prev.data_offset, prev.linesize, s.pix_fmt, s.mb_width * 16, s.mb_height * 16);
                    h.short_ref[0].poc = prev.poc + 2;
                }
                h.short_ref[0].frame_num = h.prev_frame_num;
            }
            if (s0.first_field != 0) {
                if (s.picture_structure == 3 || s.picture_structure == last_pic_structure) {
                    s0.current_picture_ptr = null;
                    s0.first_field = s.picture_structure != 3 ? 1 : 0;
                } else if (h.nal_ref_idc != 0 && s0.current_picture_ptr.reference != 0 && s0.current_picture_ptr.frame_num != h.frame_num) {
                    s0.first_field = 1;
                    s0.current_picture_ptr = null;
                } else {
                    s0.first_field = 0;
                }
            } else {
                s0.first_field = s.picture_structure != 3 ? 1 : 0;
            }
            if (!(s.picture_structure != 3 && 0 == s0.first_field || h.ff_h264_frame_start() >= 0)) {
                s0.first_field = 0;
                return -1;
            }
            if (s.picture_structure != 3) {
                int n2 = i = s.picture_structure == 2 ? 1 : 0;
                while (i < s.mb_height) {
                    Arrays.fill(h.slice_table_base, h.slice_table_offset + i * s.mb_stride, h.slice_table_offset + i * s.mb_stride + (s.mb_stride - (i + 1 == s.mb_height ? 1 : 0)), 65535);
                    ++i;
                }
            } else {
                Arrays.fill(h.slice_table_base, h.slice_table_offset, h.slice_table_offset + (s.mb_height * s.mb_stride - 1), 65535);
            }
        }
        if (h != h0) {
            H264Context.clone_slice(h, h0);
        }
        s.current_picture_ptr.frame_num = h.frame_num;
        if (first_mb_in_slice << (h.mb_aff_frame != 0 || s.picture_structure != 3 ? 1 : 0) >= s.mb_num || first_mb_in_slice >= s.mb_num) {
            return -1;
        }
        s.resync_mb_x = s.mb_x = first_mb_in_slice % s.mb_width;
        s.mb_y = first_mb_in_slice / s.mb_width << (h.mb_aff_frame != 0 || s.picture_structure != 3 ? 1 : 0);
        s.resync_mb_y = s.mb_y++;
        if (s.picture_structure == 2) {
            s.resync_mb_y = s.mb_y;
        }
        if (s.picture_structure == 3) {
            h.curr_pic_num = h.frame_num;
            h.max_pic_num = 1 << h.sps.log2_max_frame_num;
        } else {
            h.curr_pic_num = 2 * h.frame_num + 1;
            h.max_pic_num = 1 << h.sps.log2_max_frame_num + 1;
        }
        if (h.nal_unit_type == 5) {
            s.gb.get_ue_golomb("idr_pic_id");
        }
        if (h.sps.poc_type == 0) {
            h.poc_lsb = (int)s.gb.get_bits(h.sps.log2_max_poc_lsb, "poc_lsb");
            if (h.pps.pic_order_present == 1 && s.picture_structure == 3) {
                h.delta_poc_bottom = s.gb.get_se_golomb("delta_poc_bottom");
            }
        }
        if (h.sps.poc_type == 1 && 0 == h.sps.delta_pic_order_always_zero_flag) {
            h.delta_poc[0] = s.gb.get_se_golomb("delta_poc[0]");
            if (h.pps.pic_order_present == 1 && s.picture_structure == 3) {
                h.delta_poc[1] = s.gb.get_se_golomb("delta_poc[1]");
            }
        }
        h.init_poc();
        if (h.pps.redundant_pic_cnt_present != 0) {
            h.redundant_pic_count = s.gb.get_ue_golomb("redundant_pic_count");
        }
        h.ref_count[0] = h.pps.ref_count[0];
        h.ref_count[1] = h.pps.ref_count[1];
        if (h.slice_type_nos != 1) {
            int num_ref_idx_active_override_flag;
            if (h.slice_type_nos == 3) {
                h.direct_spatial_mv_pred = (int)s.gb.get_bits1("direct_spatial_mv_pred");
            }
            if ((num_ref_idx_active_override_flag = (int)s.gb.get_bits1("num_ref_idx_active_override_flag")) != 0) {
                h.ref_count[0] = s.gb.get_ue_golomb("ref_count[0]") + 1;
                if (h.slice_type_nos == 3) {
                    h.ref_count[1] = s.gb.get_ue_golomb("ref_count[1]") + 1;
                }
                if (h.ref_count[0] - 1L > 31L || h.ref_count[1] - 1L > 31L) {
                    h.ref_count[1] = 1L;
                    h.ref_count[0] = 1L;
                    return -1;
                }
            }
            h.list_count = h.slice_type_nos == 3 ? 2L : 1L;
        } else {
            h.list_count = 0L;
        }
        if (!default_ref_list_done) {
            h.ff_h264_fill_default_ref_list();
        }
        if (h.slice_type_nos != 1 && h.ff_h264_decode_ref_pic_list_reordering() < 0) {
            return -1;
        }
        if (h.slice_type_nos != 1) {
            s.last_picture_ptr = h.ref_list[0][0];
            MpegEncContext.ff_copy_picture(s.last_picture, s.last_picture_ptr);
        }
        if (h.slice_type_nos == 3) {
            s.next_picture_ptr = h.ref_list[1][0];
            MpegEncContext.ff_copy_picture(s.next_picture, s.next_picture_ptr);
        }
        if (h.pps.weighted_pred != 0 && h.slice_type_nos == 2 || h.pps.weighted_bipred_idc == 1 && h.slice_type_nos == 3) {
            h.pred_weight_table();
        } else if (h.pps.weighted_bipred_idc == 2 && h.slice_type_nos == 3) {
            h.implicit_weight_table(-1);
        } else {
            h.use_weight = 0;
            for (i = 0; i < 2; ++i) {
                h.luma_weight_flag[i] = 0;
                h.chroma_weight_flag[i] = 0;
            }
        }
        if (h.nal_ref_idc != 0) {
            h0.ff_h264_decode_ref_pic_marking(s.gb);
        }
        if (h.mb_aff_frame != 0) {
            h.ff_h264_fill_mbaff_ref_list();
            if (h.pps.weighted_bipred_idc == 2 && h.slice_type_nos == 3) {
                h.implicit_weight_table(0);
                h.implicit_weight_table(1);
            }
        }
        if (h.slice_type_nos == 3 && 0 == h.direct_spatial_mv_pred) {
            h.ff_h264_direct_dist_scale_factor();
        }
        h.ff_h264_direct_ref_list_init();
        if (h.slice_type_nos != 1 && h.pps.cabac != 0) {
            tmp = s.gb.get_ue_golomb_31("cabac_init_idc");
            if (tmp > 2) {
                return -1;
            }
            h.cabac_init_idc = tmp;
        }
        h.last_qscale_diff = 0;
        tmp = h.pps.init_qp + s.gb.get_se_golomb("init_qp");
        if (tmp > 51) {
            return -1;
        }
        s.qscale = tmp;
        h.chroma_qp[0] = h.pps.chroma_qp_table[0][s.qscale];
        h.chroma_qp[1] = h.pps.chroma_qp_table[1][s.qscale];
        if (h.slice_type == 6) {
            s.gb.get_bits1("sp_for_switch_flag");
        }
        if (h.slice_type == 6 || h.slice_type == 5) {
            s.gb.get_se_golomb("slice_qs_delta");
        }
        h.deblocking_filter = 1;
        h.slice_alpha_c0_offset = 52;
        h.slice_beta_offset = 52;
        if (0 != h.pps.deblocking_filter_parameters_present) {
            tmp = s.gb.get_ue_golomb_31("deblocking_filter_idc");
            if (tmp > 2) {
                return -1;
            }
            h.deblocking_filter = tmp;
            if (h.deblocking_filter < 2) {
                h.deblocking_filter ^= 1;
            }
            if (0 != h.deblocking_filter) {
                h.slice_alpha_c0_offset += s.gb.get_se_golomb("slice_alpha_c0_offset") << 1;
                h.slice_beta_offset += s.gb.get_se_golomb("slice_beta_offset") << 1;
                if (h.slice_alpha_c0_offset > 104 || h.slice_beta_offset > 104) {
                    return -1;
                }
            }
        }
        if (s.skip_loop_filter >= 48 || s.skip_loop_filter >= 32 && h.slice_type_nos != 1 || s.skip_loop_filter >= 16 && h.slice_type_nos == 3 || s.skip_loop_filter >= 8 && h.nal_ref_idc == 0) {
            h.deblocking_filter = 0;
        }
        if (h.deblocking_filter == 1 && h0.max_contexts > 1) {
            if ((s.flags2 & 1) != 0) {
                h.deblocking_filter = 2;
            } else {
                h0.max_contexts = 1;
                if (0 == h0.single_decode_warning) {
                    h0.single_decode_warning = 1;
                }
                if (h != h0) {
                    return 1;
                }
            }
        }
        h.qp_thresh = 67 - Math.min(h.slice_alpha_c0_offset, h.slice_beta_offset) - Math.max(Math.max(0, h.pps.chroma_qp_index_offset[0]), h.pps.chroma_qp_index_offset[1]);
        h0.last_slice_type = slice_type;
        h.slice_num = ++h0.current_slice;
        if (h.slice_num >= 16) {
            // empty if block
        }
        for (int j = 0; j < 2; ++j) {
            int[] id_list = new int[16];
            int[] ref2frm = h.ref2frm[h.slice_num & 0xF][j];
            block5: for (i = 0; i < 16; ++i) {
                int k;
                id_list[i] = 60;
                if (h.ref_list[j][i].data_base[0] == null) continue;
                int[] base = h.ref_list[j][i].base[0];
                for (k = 0; k < h.short_ref_count; ++k) {
                    if (h.short_ref[k].base[0] != base) continue;
                    id_list[i] = k;
                    break;
                }
                for (k = 0; k < h.long_ref_count; ++k) {
                    if (h.long_ref[k] == null || h.long_ref[k].base[0] != base) continue;
                    id_list[i] = h.short_ref_count + k;
                    continue block5;
                }
            }
            ref2frm[1] = -1;
            ref2frm[0] = -1;
            for (i = 0; i < 16; ++i) {
                ref2frm[i + 2] = 4 * id_list[i] + (h.ref_list[j][i].reference & 3);
            }
            ref2frm[19] = -1;
            ref2frm[18] = -1;
            for (i = 16; i < 48; ++i) {
                ref2frm[i + 4] = 4 * id_list[i - 16 >> 1] + (h.ref_list[j][i].reference & 3);
            }
        }
        h.emu_edge_width = (s.flags & 0x4000) != 0 ? 0 : 16;
        h.emu_edge_height = 0 != h.mb_aff_frame || s.picture_structure != 3 ? 0 : h.emu_edge_width;
        return 0;
    }

    public void ff_h264_free_context() {
        int i;
        this.free_tables();
        for (i = 0; i < 32; ++i) {
            this.sps_buffers[i] = null;
        }
        for (i = 0; i < 256; ++i) {
            this.pps_buffers[i] = null;
        }
    }

    public int ff_h264_decode_extradata() {
        if (this.s.extradata[0] == 1) {
            int nalsize;
            int i;
            int[] p_base = this.s.extradata;
            int p_offset = 0;
            this.is_avc = 1;
            if (this.s.extradata_size < 7) {
                return -1;
            }
            this.nal_length_size = 2;
            int cnt = p_base[p_offset + 5] & 0x1F;
            p_offset += 6;
            for (i = 0; i < cnt; ++i) {
                nalsize = (p_base[p_offset + 1] & 0xFF | (p_base[p_offset] & 0xFF) << 8) + 2;
                if (this.decode_nal_units(p_base, p_offset, nalsize) < 0) {
                    return -1;
                }
                p_offset += nalsize;
            }
            cnt = p_base[p_offset++];
            for (i = 0; i < cnt; ++i) {
                nalsize = (p_base[p_offset + 1] & 0xFF | (p_base[p_offset] & 0xFF) << 8) + 2;
                if (this.decode_nal_units(p_base, p_offset, nalsize) != nalsize) {
                    return -1;
                }
                p_offset += nalsize;
            }
            this.nal_length_size = (this.s.extradata[4] & 3) + 1;
        } else {
            this.is_avc = 0;
            if (this.decode_nal_units(this.s.extradata, 0, this.s.extradata_size) < 0) {
                return -1;
            }
        }
        return 0;
    }

    public void common_init(MpegEncContext _s) {
        int i;
        this.s = _s;
        this.h264dsp.ff_h264dsp_init();
        this.hpc.initializePredictionContext(this.s.codec_id);
        this.dequant_coeff_pps = -1;
        this.s.unrestricted_mv = 1;
        this.s.decode = 1;
        this.s.dsp.dsputil_init(this.s);
        for (i = 0; i < this.pps.scaling_matrix4.length; ++i) {
            Arrays.fill(this.pps.scaling_matrix4[i], 16);
        }
        for (i = 0; i < this.pps.scaling_matrix8.length; ++i) {
            Arrays.fill(this.pps.scaling_matrix4[i], 16);
        }
    }

    public int decode_frame(AVFrame data, int[] data_size, AVPacket avpkt) {
        int buf_index;
        int[] buf_base = avpkt.data_base;
        int buf_offset = avpkt.data_offset;
        int buf_size = avpkt.size;
        boolean loop = true;
        do {
            loop = false;
            if (buf_size == 0) {
                AVFrame out = this.delayed_pic[0];
                int out_idx = 0;
                int i = 1;
                while (this.delayed_pic[i] != null && 0 == this.delayed_pic[i].key_frame && 0 == this.delayed_pic[i].mmco_reset) {
                    if (this.delayed_pic[i].poc < out.poc) {
                        out = this.delayed_pic[i];
                        out_idx = i;
                    }
                    ++i;
                }
                i = out_idx;
                while (this.delayed_pic[i] != null) {
                    this.delayed_pic[i] = this.delayed_pic[i + 1];
                    ++i;
                }
                if (out != null) {
                    data_size[0] = 1;
                    out.copyTo(this.displayPicture);
                }
                return 0;
            }
            buf_index = this.decode_nal_units(buf_base, buf_offset, buf_size);
            if (buf_index < 0) {
                return -1;
            }
            if (null != this.s.current_picture_ptr || this.nal_unit_type != 10) continue;
            buf_size = 0;
            loop = true;
        } while (loop);
        if (0 == (this.s.flags2 & 0x8000) && null == this.s.current_picture_ptr) {
            if (this.s.skip_frame >= 8 || this.s.hurry_up != 0) {
                return 0;
            }
            return -1;
        }
        if (0 == (this.s.flags2 & 0x8000) || this.s.mb_y >= this.s.mb_height && this.s.mb_height != 0) {
            AVFrame out = this.s.current_picture_ptr;
            AVFrame cur = this.s.current_picture_ptr;
            this.field_end();
            if (cur.field_poc[0] == Integer.MAX_VALUE || cur.field_poc[1] == Integer.MAX_VALUE) {
                data_size[0] = 0;
            } else {
                boolean out_of_order;
                cur.interlaced_frame = 0;
                cur.repeat_pict = 0;
                if (this.sps.pic_struct_present_flag != 0) {
                    switch (this.sei_pic_struct) {
                        case 0: {
                            break;
                        }
                        case 1: 
                        case 2: {
                            cur.interlaced_frame = 1;
                            break;
                        }
                        case 3: 
                        case 4: {
                            if (this.mb_aff_frame != 0 || this.s.picture_structure != 3) {
                                cur.interlaced_frame = 1;
                                break;
                            }
                            cur.interlaced_frame = this.prev_interlaced_frame;
                            break;
                        }
                        case 5: 
                        case 6: {
                            cur.repeat_pict = 1;
                            break;
                        }
                        case 7: {
                            cur.repeat_pict = 2;
                            break;
                        }
                        case 8: {
                            cur.repeat_pict = 4;
                        }
                    }
                    if ((this.sei_ct_type & 3) != 0 && this.sei_pic_struct <= 4) {
                        cur.interlaced_frame = (this.sei_ct_type & 2) != 0 ? 1 : 0;
                    }
                } else {
                    cur.interlaced_frame = this.mb_aff_frame != 0 || this.s.picture_structure != 3 ? 1 : 0;
                }
                this.prev_interlaced_frame = cur.interlaced_frame;
                cur.top_field_first = cur.field_poc[0] != cur.field_poc[1] ? (cur.field_poc[0] < cur.field_poc[1] ? 1 : 0) : (cur.interlaced_frame != 0 || this.sps.pic_struct_present_flag != 0 ? (this.sei_pic_struct == 3 || this.sei_pic_struct == 5 ? 1 : 0) : 0);
                if (this.sps.bitstream_restriction_flag != 0 && this.s.has_b_frames < this.sps.num_reorder_frames) {
                    this.s.has_b_frames = this.sps.num_reorder_frames;
                    this.s.low_delay = 0;
                }
                if (this.s.strict_std_compliance >= 1 && 0 == this.sps.bitstream_restriction_flag) {
                    this.s.has_b_frames = 16;
                    this.s.low_delay = 0;
                }
                int pics = 0;
                while (this.delayed_pic[pics] != null) {
                    ++pics;
                }
                this.delayed_pic[pics++] = cur;
                if (cur.reference == 0) {
                    cur.reference = 4;
                }
                out = this.delayed_pic[0];
                int out_idx = 0;
                int i = 1;
                while (this.delayed_pic[i] != null && 0 == this.delayed_pic[i].key_frame && 0 == this.delayed_pic[i].mmco_reset) {
                    if (this.delayed_pic[i].poc < out.poc) {
                        out = this.delayed_pic[i];
                        out_idx = i;
                    }
                    ++i;
                }
                if (this.s.has_b_frames == 0 && (this.delayed_pic[0].key_frame != 0 || this.delayed_pic[0].mmco_reset != 0)) {
                    this.outputed_poc = Integer.MIN_VALUE;
                }
                boolean bl = out_of_order = out.poc < this.outputed_poc;
                if ((this.sps.bitstream_restriction_flag == 0 || this.s.has_b_frames < this.sps.num_reorder_frames) && (out_of_order && pics - 1 == this.s.has_b_frames && this.s.has_b_frames < 16 || this.s.low_delay != 0 && (this.outputed_poc != Integer.MIN_VALUE && out.poc > this.outputed_poc + 2 || cur.pict_type == 3))) {
                    this.s.low_delay = 0;
                    ++this.s.has_b_frames;
                }
                if (out_of_order || pics > this.s.has_b_frames) {
                    out.reference &= 0xFFFFFFFB;
                    i = out_idx;
                    while (this.delayed_pic[i] != null) {
                        this.delayed_pic[i] = this.delayed_pic[i + 1];
                        ++i;
                    }
                }
                if (!out_of_order && pics > this.s.has_b_frames) {
                    data_size[0] = 1;
                    this.outputed_poc = out_idx == 0 && this.delayed_pic[0] != null && (this.delayed_pic[0].key_frame != 0 || this.delayed_pic[0].mmco_reset != 0) ? Integer.MIN_VALUE : out.poc;
                    out.copyTo(this.displayPicture);
                }
            }
        }
        return this.s.get_consumed_bytes(buf_index, buf_size);
    }
}

