/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.util;

import com.twilight.h264.util.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class BufferedInputStream
extends FilterInputStream {
    protected volatile byte[] buf;
    protected int count;
    protected int markLimit;
    protected int markPos = -1;
    protected int pos;

    public BufferedInputStream(InputStream is) {
        super(is);
        this.buf = new byte[8912];
    }

    public BufferedInputStream(InputStream is, int size) {
        super(is);
        this.buf = new byte[size];
    }

    @Override
    public synchronized int available() throws IOException {
        InputStream local = this.inputStream;
        return this.count - this.pos + local.available();
    }

    @Override
    public void close() throws IOException {
        InputStream local = this.inputStream;
        this.buf = null;
        this.inputStream = null;
        if (local != null) {
            local.close();
        }
    }

    private int fillBuf(InputStream localIn, byte[] localBuf) throws IOException {
        if (this.markPos == -1 || this.pos - this.markPos >= this.markLimit) {
            int result = localIn.read(localBuf);
            if (result > 0) {
                this.markPos = -1;
                this.pos = 0;
                this.count = result == -1 ? 0 : result;
            }
            return result;
        }
        if (this.markPos == 0 && this.markLimit > localBuf.length) {
            int newLength = localBuf.length * 2;
            if (newLength > this.markLimit) {
                newLength = this.markLimit;
            }
            byte[] newBuf = new byte[newLength];
            System.arraycopy(localBuf, 0, newBuf, 0, localBuf.length);
            this.buf = newBuf;
            localBuf = newBuf;
        } else if (this.markPos > 0) {
            System.arraycopy(localBuf, this.markPos, localBuf, 0, localBuf.length - this.markPos);
        }
        this.pos -= this.markPos;
        this.markPos = 0;
        this.count = 0;
        int bytesRead = localIn.read(localBuf, this.pos, localBuf.length - this.pos);
        this.count = bytesRead <= 0 ? this.pos : this.pos + bytesRead;
        return bytesRead;
    }

    @Override
    public synchronized void mark(int readLimit) {
        this.markLimit = readLimit;
        this.markPos = this.pos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.inputStream;
        if (this.pos >= this.count && this.fillBuf(localIn, localBuf) == -1) {
            return -1;
        }
        if (localBuf != this.buf && (localBuf = this.buf) == null) {
            throw new IOException();
        }
        if (this.count - this.pos > 0) {
            return localBuf[this.pos++] & 0xFF;
        }
        return -1;
    }

    @Override
    public synchronized int read(byte[] buffer, int offset, int length) throws IOException {
        int required;
        byte[] localBuf = this.buf;
        if (localBuf == null) {
            throw new IOException();
        }
        if (length == 0) {
            return 0;
        }
        InputStream localIn = this.inputStream;
        if (localIn == null) {
            throw new IOException();
        }
        if (this.pos < this.count) {
            int copyLength = this.count - this.pos >= length ? length : this.count - this.pos;
            System.arraycopy(localBuf, this.pos, buffer, offset, copyLength);
            this.pos += copyLength;
            if (copyLength == length || localIn.available() == 0) {
                return copyLength;
            }
            offset += copyLength;
            required = length - copyLength;
        } else {
            required = length;
        }
        while (true) {
            int read;
            if (this.markPos == -1 && required > localBuf.length) {
                read = localIn.read(buffer, offset, required);
                if (read == -1) {
                    return required == length ? -1 : length - required;
                }
            } else {
                if (this.fillBuf(localIn, localBuf) == -1) {
                    return required == length ? -1 : length - required;
                }
                if (localBuf != this.buf && (localBuf = this.buf) == null) {
                    throw new IOException();
                }
                read = this.count - this.pos >= required ? required : this.count - this.pos;
                System.arraycopy(localBuf, this.pos, buffer, offset, read);
                this.pos += read;
            }
            if ((required -= read) == 0) {
                return length;
            }
            if (localIn.available() == 0) {
                return length - required;
            }
            offset += read;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.buf == null) {
            throw new IOException();
        }
        if (-1 == this.markPos) {
            throw new IOException();
        }
        this.pos = this.markPos;
    }

    @Override
    public synchronized long skip(long amount) throws IOException {
        byte[] localBuf = this.buf;
        InputStream localIn = this.inputStream;
        if (localBuf == null) {
            throw new IOException();
        }
        if (amount < 1L) {
            return 0L;
        }
        if (localIn == null) {
            throw new IOException();
        }
        if ((long)(this.count - this.pos) >= amount) {
            this.pos = (int)((long)this.pos + amount);
            return amount;
        }
        long read = this.count - this.pos;
        this.pos = this.count;
        if (this.markPos != -1 && amount <= (long)this.markLimit) {
            if (this.fillBuf(localIn, localBuf) == -1) {
                return read;
            }
            if ((long)(this.count - this.pos) >= amount - read) {
                this.pos = (int)((long)this.pos + (amount - read));
                return amount;
            }
            this.pos = this.count;
            return read += (long)(this.count - this.pos);
        }
        return read + localIn.skip(amount - read);
    }
}

