/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.Allegrex.BcuState;
import jpcsp.Emulator;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class FpuState
extends BcuState {
    private static final int STATE_VERSION = 0;
    public static final boolean IMPLEMENT_ROUNDING_MODES = true;
    private static final String[] roundingModeNames = new String[]{"Round to neareast number", "Round toward zero", "Round toward positive infinity", "Round toward negative infinity"};
    public static final int ROUNDING_MODE_NEAREST = 0;
    public static final int ROUNDING_MODE_TOWARD_ZERO = 1;
    public static final int ROUNDING_MODE_TOWARD_POSITIVE_INF = 2;
    public static final int ROUNDING_MODE_TOWARD_NEGATIVE_INF = 3;
    public final float[] fpr = new float[32];
    public final Fcr31 fcr31 = new Fcr31();

    @Override
    public void reset() {
        Arrays.fill(this.fpr, 0.0f);
        this.fcr31.reset();
    }

    @Override
    public void resetAll() {
        super.resetAll();
        Arrays.fill(this.fpr, 0.0f);
        this.fcr31.reset();
    }

    public FpuState() {
    }

    public void copy(FpuState that) {
        super.copy(that);
        System.arraycopy(that.fpr, 0, this.fpr, 0, this.fpr.length);
        this.fcr31.copy(that.fcr31);
    }

    public FpuState(FpuState that) {
        super(that);
        System.arraycopy(that.fpr, 0, this.fpr, 0, this.fpr.length);
        this.fcr31.copy(that.fcr31);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readFloats(this.fpr);
        this.fcr31.read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeFloats(this.fpr);
        this.fcr31.write(stream);
        super.write(stream);
    }

    public float round(double d) {
        int exp;
        float f = (float)d;
        if (Float.isInfinite(f) || Float.isNaN(f)) {
            return f;
        }
        if (this.fcr31.fs && (exp = Math.getExponent(f)) < -126) {
            return 0.0f;
        }
        switch (this.fcr31.rm) {
            case 0: {
                break;
            }
            case 1: {
                if (d < 0.0) {
                    if (!(d > (double)f)) break;
                    f = Math.nextUp(f);
                    break;
                }
                if (!(d < (double)f)) break;
                f = Math.nextAfter(f, 0.0);
                break;
            }
            case 2: {
                if (!(d > (double)f)) break;
                f = Math.nextUp(f);
                break;
            }
            case 3: {
                if (!(d < (double)f)) break;
                f = Math.nextAfter(f, Double.NEGATIVE_INFINITY);
                break;
            }
            default: {
                Emulator.log.error((Object)String.format("Unknown rounding mode %d", this.fcr31.rm));
            }
        }
        return f;
    }

    public void doMFC1(int rt, int c1dr) {
        if (rt != 0) {
            this.setRegister(rt, Float.floatToRawIntBits(this.fpr[c1dr]));
        }
    }

    public void doCFC1(int rt, int c1cr) {
        if (rt != 0) {
            switch (c1cr) {
                case 0: {
                    this.setRegister(rt, 0);
                    break;
                }
                case 31: {
                    this.setRegister(rt, (this.fcr31.fs ? 0x1000000 : 0) | (this.fcr31.c ? 0x800000 : 0) | this.fcr31.rm & 3);
                    break;
                }
                default: {
                    this.doUNK(String.format("Unsupported cfc1 instruction for fcr%d", c1cr));
                }
            }
        }
    }

    public void doMTC1(int rt, int c1dr) {
        this.fpr[c1dr] = Float.intBitsToFloat(this.getRegister(rt));
    }

    public void doCTC1(int rt, int c1cr) {
        switch (c1cr) {
            case 31: {
                int bits = this.getRegister(rt) & 0x1800003;
                this.fcr31.rm = bits & 3;
                this.fcr31.fs = (bits >> 24 & 1) != 0;
                boolean bl = this.fcr31.c = (bits >> 23 & 1) != 0;
                if (this.fcr31.rm != 0) {
                    Emulator.log.warn((Object)String.format("CTC1 unsupported rounding mode '%s' (rm=%d)", roundingModeNames[this.fcr31.rm], this.fcr31.rm));
                }
                if (!this.fcr31.fs) break;
                Emulator.log.warn((Object)String.format("CTC1 unsupported flush-to-zero fs=%b", this.fcr31.fs));
                break;
            }
            default: {
                this.doUNK(String.format("Unsupported ctc1 instruction for fcr%d", c1cr));
            }
        }
    }

    public boolean doBC1F(int simm16) {
        this.npc = !this.fcr31.c ? FpuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBC1T(int simm16) {
        this.npc = this.fcr31.c ? FpuState.branchTarget(this.pc, simm16) : this.pc + 4;
        return true;
    }

    public boolean doBC1FL(int simm16) {
        if (!this.fcr31.c) {
            this.npc = FpuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public boolean doBC1TL(int simm16) {
        if (this.fcr31.c) {
            this.npc = FpuState.branchTarget(this.pc, simm16);
            return true;
        }
        this.pc += 4;
        return false;
    }

    public void doADDS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] + this.fpr[ft];
    }

    public void doSUBS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] - this.fpr[ft];
    }

    public void doMULS(int fd, int fs, int ft) {
        this.fpr[fd] = this.round((double)this.fpr[fs] * (double)this.fpr[ft]);
    }

    public void doDIVS(int fd, int fs, int ft) {
        this.fpr[fd] = this.fpr[fs] / this.fpr[ft];
    }

    public void doSQRTS(int fd, int fs) {
        this.fpr[fd] = (float)Math.sqrt(this.fpr[fs]);
    }

    public void doABSS(int fd, int fs) {
        this.fpr[fd] = Math.abs(this.fpr[fs]);
    }

    public void doMOVS(int fd, int fs) {
        this.fpr[fd] = this.fpr[fs];
    }

    public void doNEGS(int fd, int fs) {
        this.fpr[fd] = 0.0f - this.fpr[fs];
    }

    public void doROUNDWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat(Math.round(this.fpr[fs]));
    }

    public void doTRUNCWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat((int)this.fpr[fs]);
    }

    public void doCEILWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat((int)Math.ceil(this.fpr[fs]));
    }

    public void doFLOORWS(int fd, int fs) {
        this.fpr[fd] = Float.intBitsToFloat((int)Math.floor(this.fpr[fs]));
    }

    public void doCVTSW(int fd, int fs) {
        this.fpr[fd] = Float.floatToRawIntBits(this.fpr[fs]);
    }

    public void doCVTWS(int fd, int fs) {
        switch (this.fcr31.rm) {
            case 1: {
                this.fpr[fd] = Float.intBitsToFloat((int)this.fpr[fs]);
                break;
            }
            case 2: {
                this.fpr[fd] = Float.intBitsToFloat((int)Math.ceil(this.fpr[fs]));
                break;
            }
            case 3: {
                this.fpr[fd] = Float.intBitsToFloat((int)Math.floor(this.fpr[fs]));
                break;
            }
            default: {
                this.fpr[fd] = Float.intBitsToFloat((int)Math.rint(this.fpr[fs]));
            }
        }
    }

    public void doCCONDS(int fs, int ft, int cond) {
        float x = this.fpr[fs];
        float y = this.fpr[ft];
        if (Float.isNaN(x) || Float.isNaN(y)) {
            this.fcr31.c = (cond & 1) != 0;
        } else {
            boolean equal = (cond & 2) != 0 && x == y;
            boolean less = (cond & 4) != 0 && x < y;
            this.fcr31.c = less || equal;
        }
    }

    public void doLWC1(int ft, int rs, int simm16) {
        this.fpr[ft] = Float.intBitsToFloat(this.memory.read32(this.getRegister(rs) + simm16));
    }

    public void doSWC1(int ft, int rs, int simm16) {
        this.memory.write32(this.getRegister(rs) + simm16, Float.floatToRawIntBits(this.fpr[ft]));
    }

    public class Fcr31 {
        private static final int STATE_VERSION = 0;
        public int rm;
        public boolean c;
        public boolean fs;

        public void reset() {
            this.rm = 0;
            this.c = false;
            this.fs = false;
        }

        public Fcr31() {
            this.reset();
        }

        public Fcr31(Fcr31 that) {
            this.rm = that.rm;
            this.c = that.c;
            this.fs = that.fs;
        }

        public void copy(Fcr31 that) {
            this.rm = that.rm;
            this.c = that.c;
            this.fs = that.fs;
        }

        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.rm = stream.readInt();
            this.c = stream.readBoolean();
            this.fs = stream.readBoolean();
        }

        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeInt(this.rm);
            stream.writeBoolean(this.c);
            stream.writeBoolean(this.fs);
        }
    }

    public static final class Fcr0 {
        public static final int imp = 0;
        public static final int rev = 0;
    }
}

