/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.iso;

import java.io.FileNotFoundException;
import java.io.IOException;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.iso.UmdIsoVirtualFile;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.ScePspDateTime;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.filesystems.umdiso.UmdIsoReader;

public class UmdIsoVirtualFileSystem
extends AbstractVirtualFileSystem {
    protected final UmdIsoReader iso;

    public UmdIsoVirtualFileSystem(UmdIsoReader iso) {
        this.iso = iso;
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        UmdIsoFile file;
        if (UmdIsoVirtualFileSystem.hasFlag(flags, 2) || UmdIsoVirtualFileSystem.hasFlag(flags, 512) || UmdIsoVirtualFileSystem.hasFlag(flags, 1024)) {
            throw new SceKernelErrorException(-2147418082);
        }
        try {
            file = this.iso.getFile(fileName);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            log.error((Object)"ioOpen", (Throwable)e);
            return null;
        }
        boolean sectorBlockMode = fileName.length() == 0;
        return new UmdIsoVirtualFile(file, sectorBlockMode, this.iso);
    }

    @Override
    public int ioGetstat(String fileName, SceIoStat stat) {
        int mode = 4;
        int attr = 0;
        long size = 0L;
        long timestamp = 0L;
        int startSector = 0;
        try {
            UmdIsoFile file = this.iso.getFile(fileName);
            attr |= 0x20;
            size = file.length();
            timestamp = file.getTimestamp().getTime();
            startSector = file.getStartSector();
        }
        catch (FileNotFoundException fnfe) {
            try {
                if (this.iso.isDirectory(fileName)) {
                    attr |= 0x10;
                    mode |= 1;
                }
            }
            catch (FileNotFoundException dnfe) {
                log.warn((Object)String.format("ioGetstat - '%s' umd file/dir not found", fileName));
                return -2147418110;
            }
            catch (IOException e) {
                log.warn((Object)"ioGetstat", (Throwable)e);
                return -2147418110;
            }
        }
        catch (IOException e) {
            log.warn((Object)"ioGetstat", (Throwable)e);
            return -2147418110;
        }
        mode = mode + (mode << 3) + (mode << 6);
        ScePspDateTime ctime = ScePspDateTime.fromUnixTime(timestamp);
        ScePspDateTime atime = ScePspDateTime.fromUnixTime(0L);
        ScePspDateTime mtime = ScePspDateTime.fromUnixTime(timestamp);
        stat.init(mode |= attr << 8, attr, size, ctime, atime, mtime);
        if (startSector > 0) {
            stat.setStartSector(startSector);
        }
        return 0;
    }

    @Override
    public String[] ioDopen(String dirName) {
        String[] fileNames = null;
        try {
            if (this.iso.isDirectory(dirName)) {
                fileNames = this.iso.listDirectory(dirName);
            } else {
                log.warn((Object)String.format("ioDopen file '%s' is not a directory", dirName));
            }
        }
        catch (FileNotFoundException e) {
            log.warn((Object)String.format("ioDopen directory '%s' not found", dirName));
        }
        catch (IOException e) {
            log.warn((Object)"ioDopen", (Throwable)e);
        }
        return fileNames;
    }

    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        int result;
        switch (command) {
            case 32636929: {
                log.debug((Object)"ioDevctl get disc type");
                if (outputPointer.isAddressGood() && outputLength >= 8) {
                    int out = this.iso == null ? 0 : 16;
                    outputPointer.setValue32(4, out);
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 32636930: {
                log.debug((Object)"ioDevctl get current LBA");
                if (outputPointer.isAddressGood() && outputLength >= 4) {
                    outputPointer.setValue32(0);
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 32571555: {
                log.debug((Object)"ioDevctl seek UMD disc");
                if (inputPointer.isAddressGood() && inputLength >= 4) {
                    int sector = inputPointer.getValue32();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioDevctl seek UMD disc: sector=%d", sector));
                    }
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 32571556: {
                log.debug((Object)"ioDevctl prepare UMD data to cache");
                if (inputPointer.isAddressGood() && inputLength >= 16) {
                    int unk1 = inputPointer.getValue32(0);
                    int sector = inputPointer.getValue32(4);
                    int unk2 = inputPointer.getValue32(8);
                    int sectorNum = inputPointer.getValue32(12);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioDevctl prepare UMD data to cache: sector=%d, sectorNum=%d, unk1=%d, unk2=%d", sector, sectorNum, unk1, unk2));
                    }
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            case 32702629: {
                log.debug((Object)"ioDevctl prepare UMD data to cache and get status");
                if (inputPointer.isAddressGood() && inputLength >= 16 && outputPointer.isAddressGood() && outputLength >= 4) {
                    int unk1 = inputPointer.getValue32(0);
                    int sector = inputPointer.getValue32(4);
                    int unk2 = inputPointer.getValue32(8);
                    int sectorNum = inputPointer.getValue32(12);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("ioDevctl prepare UMD data to cache and get status: sector=%d, sectorNum=%d, unk1=%d, unk2=%d", sector, sectorNum, unk1, unk2));
                    }
                    outputPointer.setValue32(1);
                    result = 0;
                    break;
                }
                result = -2147418090;
                break;
            }
            default: {
                result = super.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
            }
        }
        return result;
    }

    @Override
    public void ioExit() {
        try {
            this.iso.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        super.ioExit();
    }
}

