/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.nand;

import java.util.Map;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.HLE.modules.sceNand;
import jpcsp.memory.ByteArrayMemory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class NandVirtualFile
implements IVirtualFile {
    private static Logger log = sceNand.log;
    private int startLbn;
    private int endLbn;
    private long position;
    private final byte[] currentPage = new byte[512];
    private final ByteArrayMemory currentPageMemory = new ByteArrayMemory(this.currentPage);

    public NandVirtualFile(int startLbn, int endLbn) {
        this.startLbn = startLbn;
        this.endLbn = endLbn;
    }

    private int getPpn() {
        int pageNumber = (int)(this.position / 512L);
        int lbn = this.startLbn + pageNumber / 32;
        int ppn = Modules.sceNandModule.getPpnFromLbn(lbn);
        ppn += pageNumber % 32;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("getPpn ppn=0x%X, lbn=0x%X", ppn, lbn));
        }
        return ppn;
    }

    private int getPageOffset() {
        return (int)(this.position % 512L);
    }

    private void readPage(int ppn) {
        Modules.sceNandModule.hleNandReadPages(ppn, this.currentPageMemory.getPointer(), TPointer.NULL, 1, false, false, false);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("readPage ppn=0x%X: %s", ppn, Utilities.getMemoryDump(this.currentPage)));
        }
    }

    private void writePage(int ppn) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("writePage ppn=0x%X: %s", ppn, Utilities.getMemoryDump(this.currentPage)));
        }
        Modules.sceNandModule.hleNandWriteUserPages(ppn, this.currentPageMemory.getPointer(), 1, false, false);
    }

    @Override
    public int ioClose() {
        return 0;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int readLength = 0;
        int outputOffset = 0;
        while (outputLength > 0) {
            int ppn = this.getPpn();
            this.readPage(ppn);
            int pageOffset = this.getPageOffset();
            int pageLength = 512 - pageOffset;
            int length = Math.min(pageLength, outputLength);
            outputPointer.setArray(outputOffset, this.currentPage, pageOffset, length);
            outputLength -= length;
            outputOffset += length;
            this.position += (long)length;
            readLength += length;
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = 0;
        while (outputLength > 0) {
            int ppn = this.getPpn();
            this.readPage(ppn);
            int pageOffset = this.getPageOffset();
            int pageLength = 512 - pageOffset;
            int length = Math.min(pageLength, outputLength);
            System.arraycopy(this.currentPage, pageOffset, outputBuffer, outputOffset, length);
            outputLength -= length;
            outputOffset += length;
            this.position += (long)length;
            readLength += length;
        }
        return readLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        int writeLength = 0;
        int inputOffset = 0;
        while (inputLength > 0) {
            int ppn;
            int pageOffset = this.getPageOffset();
            int pageLength = 512 - pageOffset;
            int length = Math.min(pageLength, inputLength);
            if (length != 512) {
                ppn = this.getPpn();
                this.readPage(ppn);
            }
            System.arraycopy(inputPointer.getArray8(inputOffset, length), 0, this.currentPage, pageOffset, length);
            ppn = this.getPpn();
            this.writePage(ppn);
            inputLength -= length;
            inputOffset += length;
            this.position += (long)length;
            writeLength += length;
        }
        return writeLength;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        int writeLength = 0;
        while (inputLength > 0) {
            int ppn;
            int pageOffset = this.getPageOffset();
            int pageLength = 512 - pageOffset;
            int length = Math.min(pageLength, inputLength);
            if (length != 512) {
                ppn = this.getPpn();
                this.readPage(ppn);
            }
            System.arraycopy(inputBuffer, inputOffset, this.currentPage, pageOffset, length);
            ppn = this.getPpn();
            this.writePage(ppn);
            inputLength -= length;
            inputOffset += length;
            this.position += (long)length;
            writeLength += length;
        }
        return writeLength;
    }

    @Override
    public long ioLseek(long offset) {
        this.position = offset;
        return this.position;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return -1;
    }

    @Override
    public long length() {
        return (this.endLbn - this.startLbn) * 32 * 512;
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public long getPosition() {
        return this.position;
    }

    @Override
    public IVirtualFile duplicate() {
        return null;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return null;
    }
}

