/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelMppInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import org.apache.log4j.Logger;

public class MsgPipeManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private HashMap<Integer, SceKernelMppInfo> msgMap;
    private MsgPipeSendWaitStateChecker msgPipeSendWaitStateChecker;
    private MsgPipeReceiveWaitStateChecker msgPipeReceiveWaitStateChecker;
    public static final int PSP_MPP_ATTR_SEND_FIFO = 0;
    public static final int PSP_MPP_ATTR_SEND_PRIORITY = 256;
    public static final int PSP_MPP_ATTR_RECEIVE_FIFO = 0;
    public static final int PSP_MPP_ATTR_RECEIVE_PRIORITY = 4096;
    private static final int PSP_MPP_ATTR_ADDR_HIGH = 16384;
    public static final int PSP_MPP_WAIT_MODE_COMPLETE = 0;
    public static final int PSP_MPP_WAIT_MODE_PARTIAL = 1;
    public static final MsgPipeManager singleton = new MsgPipeManager();

    public void reset() {
        this.msgMap = new HashMap();
        this.msgPipeSendWaitStateChecker = new MsgPipeSendWaitStateChecker();
        this.msgPipeReceiveWaitStateChecker = new MsgPipeReceiveWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelMppInfo info = this.msgMap.get(thread.wait.MsgPipe_id);
        if (info == null) {
            return false;
        }
        if (thread.wait.MsgPipe_isSend) {
            info.sendThreadWaitingList.removeWaitingThread(thread);
        } else {
            info.receiveThreadWaitingList.removeWaitingThread(thread);
        }
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"MsgPipe deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        this.removeWaitingThread(thread);
    }

    private void onMsgPipeDeletedCancelled(int msgpid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(8, msgpid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMsgPipeDeleted(int msgpid) {
        this.onMsgPipeDeletedCancelled(msgpid, -2147352139);
    }

    private void onMsgPipeCancelled(int msgpid) {
        this.onMsgPipeDeletedCancelled(msgpid, -2147352151);
    }

    private void onMsgPipeSendModified(SceKernelMppInfo info) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while ((thread = info.sendThreadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            if (thread.wait.MsgPipe_isSend && this.trySendMsgPipe(info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onMsgPipeSendModified waking thread %s", thread));
                }
                info.sendThreadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onMsgPipeReceiveModified(SceKernelMppInfo info) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while ((thread = info.receiveThreadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            if (!thread.wait.MsgPipe_isSend && this.tryReceiveMsgPipe(info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onMsgPipeReceiveModified waking thread %s", thread));
                }
                info.receiveThreadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private boolean trySendMsgPipe(SceKernelMppInfo info, TPointer addr, int size, int waitMode, TPointer32 resultSizeAddr) {
        if (size > 0) {
            if (info.bufSize == 0) {
                info.setUserData(addr.getAddress(), size);
                this.onMsgPipeReceiveModified(info);
                if (info.getUserSize() > 0 && (size == info.getUserSize() || waitMode == 0)) {
                    return false;
                }
            } else {
                int availableSize = info.availableWriteSize();
                if (availableSize == 0) {
                    return false;
                }
                if (size > availableSize) {
                    if (waitMode == 0) {
                        return false;
                    }
                    size = availableSize;
                }
                info.append(addr.getMemory(), addr.getAddress(), size);
            }
        }
        resultSizeAddr.setValue(size);
        return true;
    }

    private boolean tryReceiveMsgPipe(SceKernelMppInfo info, TPointer addr, int size, int waitMode, TPointer32 resultSizeAddr) {
        if (size > 0) {
            int availableSize = info.availableReadSize();
            if (availableSize == 0) {
                return false;
            }
            if (size > availableSize) {
                if (waitMode == 0) {
                    return false;
                }
                size = availableSize;
            }
            info.consume(addr.getMemory(), addr.getAddress(), size);
            if (info.bufSize == 0 && info.availableReadSize() == 0 && info.getNumSendWaitThreads() > 0) {
                SceKernelThreadInfo thread = info.sendThreadWaitingList.getFirstWaitingThread();
                if (thread.wait.MsgPipe_isSend) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("tryReceiveMsgPipe waking thread %s", thread));
                    }
                    ThreadManForUser threadMan = Modules.ThreadManForUserModule;
                    info.sendThreadWaitingList.removeWaitingThread(thread);
                    thread.cpuContext._v0 = 0;
                    threadMan.hleChangeThreadState(thread, 2);
                    threadMan.hleRescheduleCurrentThread();
                }
            }
        }
        resultSizeAddr.setValue(size);
        return true;
    }

    public int checkMsgPipeID(int uid) {
        if (!this.msgMap.containsKey(uid)) {
            log.warn((Object)String.format("checkMsgPipeID unknown uid=0x%X", uid));
            throw new SceKernelErrorException(-2147352162);
        }
        return uid;
    }

    public SceKernelMppInfo getMsgPipeInfo(int uid) {
        return this.msgMap.get(uid);
    }

    public int sceKernelCreateMsgPipe(String name, int partitionid, int attr, int size, TPointer option) {
        SceKernelMppInfo info;
        if (option.isNotNull()) {
            int optionSize = option.getValue32();
            log.warn((Object)String.format("sceKernelCreateMsgPipe option at %s, size=%d", option, optionSize));
        }
        int memType = 0;
        if ((attr & 0x4000) == 16384) {
            memType = 1;
        }
        if (!(info = new SceKernelMppInfo(name, partitionid, attr, size, memType)).isMemoryAllocated()) {
            log.warn((Object)String.format("sceKernelCreateMsgPipe name='%s', partitionId=%d, attr=0x%X, size=0x%X, option=%s not enough memory", name, partitionid, attr, size, option));
            info.delete();
            return -2147352176;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelCreateMsgPipe returning %s", info));
        }
        this.msgMap.put(info.uid, info);
        return info.uid;
    }

    public int sceKernelDeleteMsgPipe(int uid) {
        SceKernelMppInfo info = this.msgMap.remove(uid);
        info.delete();
        this.onMsgPipeDeleted(uid);
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public int hleKernelSendMsgPipe(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr, TPointer32 timeoutAddr, boolean doCallbacks, boolean poll) {
        SceKernelMppInfo info = this.msgMap.get(uid);
        if (info.bufSize != 0 && size > info.bufSize) {
            log.warn((Object)String.format("hleKernelSendMsgPipe illegal size 0x%X max 0x%X", size, info.bufSize));
            return -2147352132;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!this.trySendMsgPipe(info, msgAddr, size, waitMode, resultSizeAddr)) {
            if (poll) {
                log.warn((Object)String.format("hleKernelSendMsgPipe illegal size 0x%X, max 0x%X (pipe needs consuming)", size, info.freeSize));
                return -2147352141;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelSendMsgPipe %s waiting for 0x%X bytes to become available", info, size));
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            info.sendThreadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.MsgPipe_isSend = true;
            currentThread.wait.MsgPipe_id = uid;
            currentThread.wait.MsgPipe_address = msgAddr;
            currentThread.wait.MsgPipe_size = size;
            currentThread.wait.MsgPipe_resultSize_addr = resultSizeAddr;
            threadMan.hleKernelThreadEnterWaitState(8, uid, this.msgPipeSendWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelSendMsgPipe %s fast check succeeded", info));
        }
        this.onMsgPipeReceiveModified(info);
        return 0;
    }

    public int sceKernelSendMsgPipe(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr, TPointer32 timeoutAddr) {
        return this.hleKernelSendMsgPipe(uid, msgAddr, size, waitMode, resultSizeAddr, timeoutAddr, false, false);
    }

    public int sceKernelSendMsgPipeCB(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr, TPointer32 timeoutAddr) {
        return this.hleKernelSendMsgPipe(uid, msgAddr, size, waitMode, resultSizeAddr, timeoutAddr, true, false);
    }

    public int sceKernelTrySendMsgPipe(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr) {
        return this.hleKernelSendMsgPipe(uid, msgAddr, size, waitMode, resultSizeAddr, TPointer32.NULL, false, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    private int hleKernelReceiveMsgPipe(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr, TPointer32 timeoutAddr, boolean doCallbacks, boolean poll) {
        SceKernelMppInfo info = this.msgMap.get(uid);
        if (info.bufSize != 0 && size > info.bufSize) {
            log.warn((Object)String.format("hleKernelReceiveMsgPipe illegal size 0x%X, max 0x%X", size, info.bufSize));
            return -2147352132;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        if (!this.tryReceiveMsgPipe(info, msgAddr, size, waitMode, resultSizeAddr)) {
            if (poll) {
                if (!log.isDebugEnabled()) return -2147352140;
                log.debug((Object)String.format("hleKernelReceiveMsgPipe trying to read more than is available size 0x%X, available 0x%X", size, info.bufSize - info.freeSize));
                return -2147352140;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelReceiveMsgPipe %s waiting for 0x%X bytes to become available", info, size));
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            info.receiveThreadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.MsgPipe_isSend = false;
            currentThread.wait.MsgPipe_id = uid;
            currentThread.wait.MsgPipe_address = msgAddr;
            currentThread.wait.MsgPipe_size = size;
            currentThread.wait.MsgPipe_resultSize_addr = resultSizeAddr;
            threadMan.hleKernelThreadEnterWaitState(8, uid, this.msgPipeReceiveWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
            return 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelReceiveMsgPipe %s fast check succeeded", info));
        }
        this.onMsgPipeSendModified(info);
        return 0;
    }

    public int sceKernelReceiveMsgPipe(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr, TPointer32 timeoutAddr) {
        return this.hleKernelReceiveMsgPipe(uid, msgAddr, size, waitMode, resultSizeAddr, timeoutAddr, false, false);
    }

    public int sceKernelReceiveMsgPipeCB(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr, TPointer32 timeoutAddr) {
        return this.hleKernelReceiveMsgPipe(uid, msgAddr, size, waitMode, resultSizeAddr, timeoutAddr, true, false);
    }

    public int sceKernelTryReceiveMsgPipe(int uid, TPointer msgAddr, int size, int waitMode, TPointer32 resultSizeAddr) {
        return this.hleKernelReceiveMsgPipe(uid, msgAddr, size, waitMode, resultSizeAddr, TPointer32.NULL, false, true);
    }

    public int sceKernelCancelMsgPipe(int uid, TPointer32 sendAddr, TPointer32 recvAddr) {
        SceKernelMppInfo info = this.msgMap.get(uid);
        sendAddr.setValue(info.getNumSendWaitThreads());
        recvAddr.setValue(info.getNumReceiveWaitThreads());
        info.sendThreadWaitingList.removeAllWaitingThreads();
        info.receiveThreadWaitingList.removeAllWaitingThreads();
        this.onMsgPipeCancelled(uid);
        return 0;
    }

    public int sceKernelReferMsgPipeStatus(int uid, TPointer infoAddr) {
        SceKernelMppInfo info = this.msgMap.get(uid);
        info.write(infoAddr);
        return 0;
    }

    private MsgPipeManager() {
    }

    private class MsgPipeReceiveWaitStateChecker
    implements IWaitStateChecker {
        private MsgPipeReceiveWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMppInfo info = (SceKernelMppInfo)MsgPipeManager.this.msgMap.get(wait.MsgPipe_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352162;
                return false;
            }
            if (MsgPipeManager.this.tryReceiveMsgPipe(info, wait.MsgPipe_address, wait.MsgPipe_size, wait.MsgPipe_waitMode, wait.MsgPipe_resultSize_addr)) {
                info.receiveThreadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }

    private class MsgPipeSendWaitStateChecker
    implements IWaitStateChecker {
        private MsgPipeSendWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelMppInfo info = (SceKernelMppInfo)MsgPipeManager.this.msgMap.get(wait.MsgPipe_id);
            if (info == null) {
                thread.cpuContext._v0 = -2147352162;
                return false;
            }
            if (MsgPipeManager.this.trySendMsgPipe(info, thread.wait.MsgPipe_address, thread.wait.MsgPipe_size, thread.wait.MsgPipe_waitMode, thread.wait.MsgPipe_resultSize_addr)) {
                info.sendThreadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

