/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.util.Comparator;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.Memory;

public class SceKernelMsgPacket
extends pspAbstractMemoryMappedStructure
implements Comparator<SceKernelMsgPacket> {
    private static final int OFFSET_NEXT_MSG_PACKET_ADDR = 0;
    private static final int OFFSET_MSG_PRIORITY = 4;
    public int nextMsgPacketAddr;
    int msgPriority;
    int unknow0;
    int unknow1;
    int unknow2;

    @Override
    protected void read() {
        this.nextMsgPacketAddr = this.read32();
        this.msgPriority = this.read8();
        this.unknow0 = this.read8();
        this.unknow1 = this.read8();
        this.unknow2 = this.read8();
    }

    @Override
    protected void write() {
        this.write32(this.nextMsgPacketAddr);
        this.write8((byte)this.msgPriority);
        this.write8((byte)this.unknow0);
        this.write8((byte)this.unknow1);
        this.write8((byte)this.unknow2);
    }

    public static void writeNext(Memory mem, int msgAddr, int nextMsgAddr) {
        mem.write32(msgAddr + 0, nextMsgAddr);
    }

    public static int readNext(Memory mem, int msgAddr) {
        return mem.read32(msgAddr + 0);
    }

    @Override
    public int sizeof() {
        return 8;
    }

    public static int compare(Memory mem, int msgAddr1, int msgAddr2) {
        return mem.read8(msgAddr1 + 4) - mem.read8(msgAddr2 + 4);
    }

    @Override
    public int compare(SceKernelMsgPacket m1, SceKernelMsgPacket m2) {
        return m1.msgPriority - m2.msgPriority;
    }
}

