/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;

public class ScePspDateTime
extends pspAbstractMemoryMappedStructure
implements IState {
    private static final int STATE_VERSION = 0;
    public static final TimeZone GMT = TimeZone.getTimeZone("GMT");
    public static final int SIZEOF = 16;
    public int year;
    public int month;
    public int day;
    public int hour;
    public int minute;
    public int second;
    public int microsecond;

    public ScePspDateTime() {
        Calendar cal = Calendar.getInstance();
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.microsecond = cal.get(14) * 1000;
    }

    public ScePspDateTime(int timezone) {
        int minutes;
        Calendar cal = Calendar.getInstance();
        int hours = 0;
        for (minutes = timezone; minutes > 59; minutes -= 60) {
            ++hours;
        }
        String timeString = String.format("UTC+%02d%02d", hours, minutes);
        TimeZone tz = TimeZone.getTimeZone(timeString);
        cal.setTimeZone(tz);
        this.year = cal.get(1);
        this.month = 1 + cal.get(2);
        this.day = cal.get(5);
        this.hour = cal.get(11);
        this.minute = cal.get(12);
        this.second = cal.get(13);
        this.microsecond = cal.get(14) * 1000;
    }

    public ScePspDateTime(int year, int month, int day, int hour, int minute, int second, int microsecond) {
        this.year = year;
        this.month = month;
        this.day = day;
        this.hour = hour;
        this.minute = minute;
        this.second = second;
        this.microsecond = microsecond;
    }

    public static ScePspDateTime fromMSDOSTime(int time) {
        int year = 1980 + (time >> 25 & 0x7F);
        int month = time >> 21 & 0xF;
        int day = time >> 16 & 0x1F;
        int hour = time >> 11 & 0x1F;
        int minute = time >> 5 & 0x3F;
        int second = (time >> 0 & 0x1F) << 1;
        int microsecond = 0;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public int toMSDOSTime() {
        int time = 0;
        time |= (this.year - 1980 & 0x7F) << 25;
        time |= (this.month & 0xF) << 21;
        time |= (this.day & 0x1F) << 16;
        time |= (this.hour & 0x1F) << 11;
        time |= (this.minute & 0x3F) << 5;
        return time |= (this.second >> 1 & 0x1F) << 0;
    }

    public static ScePspDateTime fromFILETIMETime(long time) {
        long milliseconds = time / 10000L;
        long days = milliseconds / 86400000L;
        long hours = (milliseconds -= days * 86400000L) / 3600000L;
        long minutes = (milliseconds -= hours * 3600000L) / 60000L;
        long seconds = (milliseconds -= minutes * 60000L) / 1000L;
        milliseconds -= seconds * 1000L;
        Calendar cal = Calendar.getInstance();
        cal.set(1601, 0, 1, 0, 0, 0);
        cal.add(5, (int)days);
        cal.add(11, (int)hours);
        cal.add(12, (int)minutes);
        cal.add(13, (int)seconds);
        cal.add(14, (int)milliseconds);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromUnixTime(long time) {
        Calendar cal = Calendar.getInstance();
        Date date = new Date(time);
        cal.setTime(date);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = cal.get(14) * 1000;
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    private static ScePspDateTime fromMicros(long micros, Calendar cal) {
        Date date = new Date(micros / 1000L);
        cal.setTime(date);
        int year = cal.get(1);
        int month = 1 + cal.get(2);
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int microsecond = (int)(micros % 1000000L);
        return new ScePspDateTime(year, month, day, hour, minute, second, microsecond);
    }

    public static ScePspDateTime fromMicros(long micros) {
        return ScePspDateTime.fromMicros(micros, Calendar.getInstance(GMT));
    }

    public static ScePspDateTime fromMicrosLocal(long micros) {
        return ScePspDateTime.fromMicros(micros, Calendar.getInstance());
    }

    @Override
    protected void read() {
        this.year = this.read16();
        this.month = this.read16();
        this.day = this.read16();
        this.hour = this.read16();
        this.minute = this.read16();
        this.second = this.read16();
        this.microsecond = this.read32();
    }

    @Override
    protected void write() {
        this.write16((short)this.year);
        this.write16((short)this.month);
        this.write16((short)this.day);
        this.write16((short)this.hour);
        this.write16((short)this.minute);
        this.write16((short)this.second);
        this.write32(this.microsecond);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.year = stream.readUnsignedShort();
        this.month = stream.readUnsignedShort();
        this.day = stream.readUnsignedShort();
        this.hour = stream.readUnsignedShort();
        this.minute = stream.readUnsignedShort();
        this.second = stream.readUnsignedShort();
        this.microsecond = stream.readInt();
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeShort(this.year);
        stream.writeShort(this.month);
        stream.writeShort(this.day);
        stream.writeShort(this.hour);
        stream.writeShort(this.minute);
        stream.writeShort(this.second);
        stream.writeInt(this.microsecond);
    }

    public boolean after(ScePspDateTime that) {
        if (this.year > that.year) {
            return true;
        }
        if (this.year < that.year) {
            return false;
        }
        if (this.month > that.month) {
            return true;
        }
        if (this.month < that.month) {
            return false;
        }
        if (this.day > that.day) {
            return true;
        }
        if (this.day < that.day) {
            return false;
        }
        if (this.hour > that.hour) {
            return true;
        }
        if (this.hour < that.hour) {
            return false;
        }
        if (this.minute > that.minute) {
            return true;
        }
        if (this.minute < that.minute) {
            return false;
        }
        if (this.second > that.second) {
            return true;
        }
        if (this.second < that.second) {
            return false;
        }
        return this.microsecond > that.microsecond;
    }

    public boolean before(ScePspDateTime that) {
        if (this.year < that.year) {
            return true;
        }
        if (this.year > that.year) {
            return false;
        }
        if (this.month < that.month) {
            return true;
        }
        if (this.month > that.month) {
            return false;
        }
        if (this.day < that.day) {
            return true;
        }
        if (this.day > that.day) {
            return false;
        }
        if (this.hour < that.hour) {
            return true;
        }
        if (this.hour > that.hour) {
            return false;
        }
        if (this.minute < that.minute) {
            return true;
        }
        if (this.minute > that.minute) {
            return false;
        }
        if (this.second < that.second) {
            return true;
        }
        if (this.second > that.second) {
            return false;
        }
        return this.microsecond < that.microsecond;
    }

    @Override
    public int sizeof() {
        return 16;
    }

    @Override
    public String toString() {
        return String.format("%04d-%02d-%02d %02d:%02d:%02d micros=%d", this.year, this.month, this.day, this.hour, this.minute, this.second, this.microsecond);
    }
}

