/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.managers.IntrManager;
import jpcsp.HLE.kernel.types.interrupts.AbstractInterruptHandler;
import jpcsp.Processor;
import jpcsp.memory.mmio.MMIOHandlerInterruptMan;
import jpcsp.scheduler.Scheduler;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class InterruptManager
extends HLEModule {
    public static Logger log = Modules.getLogger("InterruptManager");
    private int hleExceptionHandlerAddr;

    @Override
    public void start() {
        this.hleExceptionHandlerAddr = HLEUtilities.getInstance().installHLEInterruptHandler(this, "hleExceptionHandler");
        super.start();
    }

    @Override
    public void stop() {
        Managers.intr.stop();
        super.stop();
    }

    public void hleEnableInterrupt(int interruptNumber) {
        Processor processor = Emulator.getProcessor();
        MMIOHandlerInterruptMan interruptMan = MMIOHandlerInterruptMan.getInstance(processor);
        interruptMan.enableInterrupt(interruptNumber);
        processor.cp0.setStatus(processor.cp0.getStatus() | 0x400);
        processor.cp0.setEbase(this.hleExceptionHandlerAddr);
    }

    @HLEFunction(nid=-1, version=150)
    public void hleExceptionHandler(Processor processor) throws Exception {
        Scheduler.getInstance().addAction(new HLEExceptionHandler(processor));
    }

    @HLEFunctions(value={@HLEFunction(nid=-905665863, version=150), @HLEFunction(nid=-5721725, version=660)})
    public int sceKernelRegisterSubIntrHandler(int intrNumber, int subIntrNumber, TPointer handlerAddress, int handlerArgument) {
        return Managers.intr.sceKernelRegisterSubIntrHandler(intrNumber, subIntrNumber, handlerAddress, handlerArgument);
    }

    @HLEFunction(nid=-702650015, version=150)
    public int sceKernelReleaseSubIntrHandler(int intrNumber, int subIntrNumber) {
        return Managers.intr.sceKernelReleaseSubIntrHandler(intrNumber, subIntrNumber);
    }

    @HLEFunction(nid=-74571028, version=150)
    public int sceKernelEnableSubIntr(int intrNumber, int subIntrNumber) {
        return Managers.intr.sceKernelEnableSubIntr(intrNumber, subIntrNumber);
    }

    @HLEFunctions(value={@HLEFunction(nid=-1976003567, version=150), @HLEFunction(nid=1076093351, version=660)})
    public int sceKernelDisableSubIntr(int intrNumber, int subIntrNumber) {
        return Managers.intr.sceKernelDisableSubIntr(intrNumber, subIntrNumber);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1555408779, version=150)
    public int sceKernelSuspendSubIntr() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2019614940, version=150)
    public int sceKernelResumeSubIntr() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-62688072, version=150)
    public int sceKernelIsSubInterruptOccurred() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-756533697, version=150)
    public int QueryIntrHandlerInfo() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-287031481, version=150)
    public int sceKernelRegisterUserSpaceIntrStack() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-680215995, version=150)
    public int sceKernelDisableIntr(int intrNumber) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1299084037, version=150)
    public int sceKernelEnableIntr(int intrNumber) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-619394080, version=150)
    public int sceKernelResumeIntr() {
        return 0;
    }

    @HLEFunction(nid=207583971, version=150)
    public int sceKernelCallSubIntrHandler(int intrNumber, int subIntrNumber, int handlerArg0, int handlerArg2) {
        return Managers.intr.sceKernelCallSubIntrHandler(intrNumber, subIntrNumber, handlerArg0, handlerArg2);
    }

    @HLEFunction(nid=1490913656, version=150)
    public int sceKernelRegisterIntrHandler(int intrNumber, int unknown, TPointer func, int funcArg, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.in) TPointer32 handler) {
        return Managers.intr.sceKernelRegisterIntrHandler(intrNumber, unknown, func, funcArg, handler);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-108547600, version=150)
    public int sceKernelReleaseIntrHandler(int intrNumber) {
        return 0;
    }

    @HLEFunction(nid=-30882087, version=150)
    public boolean sceKernelIsIntrContext() {
        return IntrManager.getInstance().isInsideInterrupt();
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1594326986, version=150)
    public int sceKernelGetSyscallRA() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=349488666, version=660)
    public int sceKernelRegisterSystemCallTable(TPointer syscallTable) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunctions(value={@HLEFunction(nid=-1956544373, version=150), @HLEFunction(nid=-246172815, version=660)})
    public int sceKernelQuerySystemCall(TPointer func) {
        return -1;
    }

    private static class HLEExceptionHandler
    extends AbstractInterruptHandler {
        private Processor processor;

        public HLEExceptionHandler(Processor processor) {
            this.processor = processor;
        }

        @Override
        protected void executeInterrupt() {
            int cause = this.processor.cp0.getCause();
            int exceptionNumber = (cause & 0xFF) >> 2;
            if (exceptionNumber == 0) {
                int ipBits = cause >> 8 & 0xFF;
                if (ipBits == 4) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("hleExceptionHandler for IP2", new Object[0]));
                    }
                    MMIOHandlerInterruptMan interruptMan = MMIOHandlerInterruptMan.getInstance(this.processor);
                    for (int interruptNumber = 0; interruptNumber < 64; ++interruptNumber) {
                        if (!interruptMan.hasInterruptTriggered(interruptNumber)) continue;
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("hleExceptionHandler for interrupt %s", IntrManager.getInterruptName(interruptNumber)));
                        }
                        Scheduler.getInstance().addAction(new HLEInterruptHandler(interruptNumber));
                    }
                } else {
                    log.error((Object)String.format("hleExceptionHandler unimplemented IP 0x%02X", ipBits));
                }
            } else {
                log.error((Object)String.format("hleExceptionHandler unimplemented exceptionNumber=%d", exceptionNumber));
            }
            int status = this.processor.cp0.getStatus();
            status = Utilities.clearFlag(status, 2);
            this.processor.cp0.setStatus(status);
        }
    }

    private static class HLEInterruptHandler
    extends AbstractInterruptHandler {
        private int interruptNumber;

        public HLEInterruptHandler(int interruptNumber) {
            this.interruptNumber = interruptNumber;
        }

        @Override
        protected void executeInterrupt() {
            IntrManager.getInstance().triggerInterrupt(this.interruptNumber);
        }
    }
}

