/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import jpcsp.Emulator;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceMp4SampleInfo;
import jpcsp.HLE.kernel.types.SceMp4TrackSampleBuf;
import jpcsp.HLE.kernel.types.SceMpegAu;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.Memory;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.h264.H264Utils;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMp4
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMp4");
    protected int callbackParam;
    protected int callbackGetCurrentPosition;
    protected int callbackSeek;
    protected int callbackRead;
    protected int readBufferAddr;
    protected int readBufferSize;
    protected int[] videoSamplesOffset;
    protected int[] videoSamplesSize;
    protected int[] videoSamplesDuration;
    protected int[] videoSamplesPresentationOffset;
    protected int[] videoSyncSamples;
    protected int videoDuration;
    protected int videoTimeScale;
    protected long videoCurrentTimestamp;
    protected int[] audioSamplesOffset;
    protected int[] audioSamplesSize;
    protected int[] audioSamplesDuration;
    protected int[] audioSamplesPresentationOffset;
    protected int[] audioSyncSamples;
    protected int audioDuration;
    protected int audioTimeScale;
    protected long audioCurrentTimestamp;
    protected int[] numberOfSamplesPerChunk;
    protected int[] samplesSize;
    protected long parseOffset;
    protected int timeScale;
    protected int duration;
    protected int numberOfTracks;
    protected int trackType;
    protected int[] currentAtomContent;
    protected int currentAtom;
    protected int currentAtomSize;
    protected int currentAtomOffset;
    protected int trackTimeScale;
    protected int trackDuration;
    protected SceMp4TrackSampleBuf currentTrack;
    protected TPointer currentTracAddr;
    protected boolean bufferPutInProgress;
    protected int bufferPutSamples;
    protected int bufferPutCurrentSampleRemainingBytes;
    protected int bufferPutSamplesPut;
    protected SceKernelThreadInfo bufferPutThread;
    protected ICodec audioCodec;
    protected int audioChannels;
    protected List<Integer> threadsWaitingOnBufferPut;
    public static final int TRACK_TYPE_VIDEO = 16;
    public static final int TRACK_TYPE_AUDIO = 32;
    protected static final int SEARCH_BACKWARDS = 0;
    protected static final int SEARCH_FORWARDS = 1;
    protected static final int ATOM_FTYP = 1718909296;
    protected static final int ATOM_MOOV = 1836019574;
    protected static final int ATOM_TRAK = 1953653099;
    protected static final int ATOM_MDIA = 1835297121;
    protected static final int ATOM_MINF = 1835626086;
    protected static final int ATOM_STBL = 1937007212;
    protected static final int ATOM_STSD = 1937011556;
    protected static final int ATOM_MVHD = 1836476516;
    protected static final int ATOM_STSC = 1937011555;
    protected static final int ATOM_STSZ = 1937011578;
    protected static final int ATOM_STTS = 0x73747473;
    protected static final int ATOM_CTTS = 1668576371;
    protected static final int ATOM_STCO = 1937007471;
    protected static final int ATOM_STSS = 0x73747373;
    protected static final int ATOM_MDHD = 1835296868;
    protected static final int ATOM_AVCC = 1635148611;
    protected static final int FILE_TYPE_MSNV = 1297305174;
    protected static final int FILE_TYPE_ISOM = 1769172845;
    protected static final int FILE_TYPE_MP42 = 1836069938;
    protected static final int DATA_FORMAT_AVC1 = 1635148593;
    protected static final int DATA_FORMAT_MP4A = 1836069985;

    private static boolean isContainerAtom(int atom) {
        switch (atom) {
            case 1835297121: 
            case 1835626086: 
            case 1836019574: 
            case 1937007212: 
            case 1953653099: {
                return true;
            }
        }
        return false;
    }

    private static boolean isAtomContentRequired(int atom) {
        switch (atom) {
            case 1635148611: 
            case 1668576371: 
            case 1835296868: 
            case 1836476516: 
            case 1937007471: 
            case 1937011555: 
            case 1937011556: 
            case 0x73747373: 
            case 1937011578: 
            case 0x73747473: {
                return true;
            }
        }
        return false;
    }

    private static String atomToString(int atom) {
        return String.format("%c%c%c%c", Character.valueOf((char)(atom >>> 24)), Character.valueOf((char)(atom >> 16 & 0xFF)), Character.valueOf((char)(atom >> 8 & 0xFF)), Character.valueOf((char)(atom & 0xFF)));
    }

    private static int read32(Memory mem, int addr) {
        return Utilities.endianSwap32(Utilities.readUnaligned32(mem, addr));
    }

    private static int read32(int[] content, int o) {
        return content[o] << 24 | content[o + 1] << 16 | content[o + 2] << 8 | content[o + 3];
    }

    private static int read16(int[] content, int o) {
        return content[o] << 8 | content[o + 1];
    }

    private static int[] extend(int[] array, int length) {
        if (length > 0) {
            if (array == null) {
                array = new int[length];
            } else if (array.length < length) {
                int[] newArray = new int[length];
                System.arraycopy(array, 0, newArray, 0, array.length);
                array = newArray;
            }
        }
        return array;
    }

    private void processAtom(Memory mem, int addr, int atom, int size) {
        int[] content = new int[size];
        int i = 0;
        while (i < size) {
            content[i] = mem.read8(addr);
            ++i;
            ++addr;
        }
        this.processAtom(atom, content, size);
    }

    private void setTrackDurationAndTimeScale() {
        if (this.trackType == 0) {
            return;
        }
        if (this.currentTrack != null && this.currentTracAddr != null && this.currentTrack.isOfType(this.trackType)) {
            this.currentTrack.timeScale = this.trackTimeScale;
            this.currentTrack.duration = this.trackDuration;
            this.currentTrack.write(this.currentTracAddr);
        }
        switch (this.trackType) {
            case 16: {
                this.videoTimeScale = this.trackTimeScale;
                this.videoDuration = this.trackDuration;
                break;
            }
            case 32: {
                this.audioTimeScale = this.trackTimeScale;
                this.audioDuration = this.trackDuration;
                break;
            }
            default: {
                log.error((Object)String.format("processAtom 'mdhd' unknown track type %d", this.trackType));
            }
        }
    }

    private void processAtom(int atom, int[] content, int size) {
        block0 : switch (atom) {
            case 1836476516: {
                if (size < 20) break;
                this.timeScale = sceMp4.read32(content, 12);
                this.duration = sceMp4.read32(content, 16);
                break;
            }
            case 1835296868: {
                if (size < 20) break;
                this.trackTimeScale = sceMp4.read32(content, 12);
                this.trackDuration = sceMp4.read32(content, 16);
                this.setTrackDurationAndTimeScale();
                break;
            }
            case 1937011556: {
                if (size < 16) break;
                int dataFormat = sceMp4.read32(content, 12);
                switch (dataFormat) {
                    case 1635148593: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("trackType video %s", sceMp4.atomToString(dataFormat)));
                        }
                        this.trackType = 16;
                        if (size >= 44) {
                            int videoFrameWidth = sceMp4.read16(content, 40);
                            int videoFrameHeight = sceMp4.read16(content, 42);
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Video frame size %dx%d", videoFrameWidth, videoFrameHeight));
                            }
                        }
                        if (size < 102) break;
                        int atomAvcC = sceMp4.read32(content, 98);
                        int atomAvcCsize = sceMp4.read32(content, 94);
                        if (atomAvcC != 1635148611 || atomAvcCsize > size - 94) break;
                        int[] videoCodecExtraData = new int[atomAvcCsize - 8];
                        System.arraycopy(content, 102, videoCodecExtraData, 0, videoCodecExtraData.length);
                        Modules.sceVideocodecModule.setVideocodecExtraData(videoCodecExtraData);
                        break;
                    }
                    case 1836069985: {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("trackType audio %s", sceMp4.atomToString(dataFormat)));
                        }
                        this.trackType = 32;
                        if (size < 34) break;
                        this.audioChannels = sceMp4.read16(content, 32);
                        break;
                    }
                    default: {
                        log.warn((Object)String.format("Unknown track type 0x%08X(%s)", dataFormat, sceMp4.atomToString(dataFormat)));
                    }
                }
                this.setTrackDurationAndTimeScale();
                break;
            }
            case 1937011555: {
                int numberOfEntries;
                this.numberOfSamplesPerChunk = null;
                if (size < 8 || size < (numberOfEntries = sceMp4.read32(content, 4)) * 12 + 8) break;
                int offset = 8;
                int previousChunk = 1;
                int previousSamplesPerChunk = 0;
                int i = 0;
                while (i < numberOfEntries) {
                    int firstChunk = sceMp4.read32(content, offset);
                    int samplesPerChunk = sceMp4.read32(content, offset + 4);
                    this.numberOfSamplesPerChunk = sceMp4.extend(this.numberOfSamplesPerChunk, firstChunk);
                    for (int j = previousChunk; j < firstChunk; ++j) {
                        this.numberOfSamplesPerChunk[j - 1] = previousSamplesPerChunk;
                    }
                    previousChunk = firstChunk;
                    previousSamplesPerChunk = samplesPerChunk;
                    ++i;
                    offset += 12;
                }
                this.numberOfSamplesPerChunk = sceMp4.extend(this.numberOfSamplesPerChunk, previousChunk);
                this.numberOfSamplesPerChunk[previousChunk - 1] = previousSamplesPerChunk;
                break;
            }
            case 1937011578: {
                this.samplesSize = null;
                if (size >= 8) {
                    int sampleSize = sceMp4.read32(content, 4);
                    if (sampleSize > 0) {
                        this.samplesSize = new int[1];
                        this.samplesSize[0] = sampleSize;
                    } else if (size >= 12) {
                        int numberOfEntries = sceMp4.read32(content, 8);
                        this.samplesSize = new int[numberOfEntries];
                        int offset = 12;
                        int i = 0;
                        while (i < numberOfEntries) {
                            this.samplesSize[i] = sceMp4.read32(content, offset);
                            ++i;
                            offset += 4;
                        }
                    }
                }
                switch (this.trackType) {
                    case 16: {
                        this.videoSamplesSize = this.samplesSize;
                        break block0;
                    }
                    case 32: {
                        this.audioSamplesSize = this.samplesSize;
                        break block0;
                    }
                }
                log.error((Object)String.format("processAtom 'stsz' unknown track type %d", this.trackType));
                break;
            }
            case 0x73747473: {
                int[] samplesDuration = null;
                if (size >= 8) {
                    int numberOfEntries = sceMp4.read32(content, 4);
                    int offset = 8;
                    int sample = 0;
                    int i = 0;
                    while (i < numberOfEntries) {
                        int sampleCount = sceMp4.read32(content, offset);
                        int sampleDuration = sceMp4.read32(content, offset + 4);
                        samplesDuration = sceMp4.extend(samplesDuration, sample + sampleCount);
                        Arrays.fill(samplesDuration, sample, sample + sampleCount, sampleDuration);
                        sample += sampleCount;
                        ++i;
                        offset += 8;
                    }
                }
                switch (this.trackType) {
                    case 16: {
                        this.videoSamplesDuration = samplesDuration;
                        break block0;
                    }
                    case 32: {
                        this.audioSamplesDuration = samplesDuration;
                        break block0;
                    }
                }
                log.error((Object)String.format("processAtom 'stts' unknown track type %d", this.trackType));
                break;
            }
            case 1668576371: {
                int[] samplesPresentationOffset = null;
                if (size >= 8) {
                    int numberOfEntries = sceMp4.read32(content, 4);
                    int offset = 8;
                    int sample = 0;
                    int i = 0;
                    while (i < numberOfEntries) {
                        int sampleCount = sceMp4.read32(content, offset);
                        int samplePresentationOffset = sceMp4.read32(content, offset + 4);
                        samplesPresentationOffset = sceMp4.extend(samplesPresentationOffset, sample + sampleCount);
                        Arrays.fill(samplesPresentationOffset, sample, sample + sampleCount, samplePresentationOffset);
                        sample += sampleCount;
                        ++i;
                        offset += 8;
                    }
                }
                switch (this.trackType) {
                    case 16: {
                        this.videoSamplesPresentationOffset = samplesPresentationOffset;
                        break block0;
                    }
                    case 32: {
                        this.audioSamplesPresentationOffset = samplesPresentationOffset;
                        break block0;
                    }
                }
                log.error((Object)String.format("processAtom 'ctts' unknown track type %d", this.trackType));
                break;
            }
            case 1937007471: {
                int[] chunksOffset = null;
                if (size >= 8) {
                    int numberOfEntries = sceMp4.read32(content, 4);
                    chunksOffset = sceMp4.extend(chunksOffset, numberOfEntries);
                    int offset = 8;
                    int i = 0;
                    while (i < numberOfEntries) {
                        chunksOffset[i] = sceMp4.read32(content, offset);
                        ++i;
                        offset += 4;
                    }
                }
                int[] samplesOffset = null;
                if (this.numberOfSamplesPerChunk != null && this.samplesSize != null && chunksOffset != null) {
                    int i;
                    int compactedChunksLength = this.numberOfSamplesPerChunk.length;
                    this.numberOfSamplesPerChunk = sceMp4.extend(this.numberOfSamplesPerChunk, chunksOffset.length);
                    Arrays.fill(this.numberOfSamplesPerChunk, compactedChunksLength, chunksOffset.length, this.numberOfSamplesPerChunk[compactedChunksLength - 1]);
                    int numberOfSamples = 0;
                    for (int i2 = 0; i2 < this.numberOfSamplesPerChunk.length; ++i2) {
                        numberOfSamples += this.numberOfSamplesPerChunk[i2];
                    }
                    int compactedSamplesLength = this.samplesSize.length;
                    this.samplesSize = sceMp4.extend(this.samplesSize, numberOfSamples);
                    Arrays.fill(this.samplesSize, compactedSamplesLength, numberOfSamples, this.samplesSize[compactedSamplesLength - 1]);
                    samplesOffset = new int[numberOfSamples];
                    int sample = 0;
                    for (i = 0; i < chunksOffset.length; ++i) {
                        int offset = chunksOffset[i];
                        int j = 0;
                        while (j < this.numberOfSamplesPerChunk[i]) {
                            samplesOffset[sample] = offset;
                            offset += this.samplesSize[sample];
                            ++j;
                            ++sample;
                        }
                    }
                    if (log.isTraceEnabled()) {
                        for (i = 0; i < samplesOffset.length; ++i) {
                            log.trace((Object)String.format("Sample#%d offset=0x%X, size=0x%X", i, samplesOffset[i], this.samplesSize[i]));
                        }
                    }
                    if (this.currentTrack != null && this.currentTracAddr != null && this.currentTrack.isOfType(this.trackType)) {
                        this.currentTrack.totalNumberSamples = numberOfSamples;
                        this.currentTrack.write(this.currentTracAddr);
                    }
                }
                switch (this.trackType) {
                    case 16: {
                        this.videoSamplesOffset = samplesOffset;
                        break block0;
                    }
                    case 32: {
                        this.audioSamplesOffset = samplesOffset;
                        break block0;
                    }
                }
                log.error((Object)String.format("processAtom 'stco' unknown track type %d", this.trackType));
                break;
            }
            case 0x73747373: {
                int[] syncSamples = null;
                if (size >= 8) {
                    int numberOfEntries = sceMp4.read32(content, 4);
                    syncSamples = new int[numberOfEntries];
                    int offset = 8;
                    int i = 0;
                    while (i < numberOfEntries) {
                        syncSamples[i] = sceMp4.read32(content, offset) - 1;
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("Sync sample#%d=0x%X", i, syncSamples[i]));
                        }
                        ++i;
                        offset += 4;
                    }
                }
                switch (this.trackType) {
                    case 16: {
                        this.videoSyncSamples = syncSamples;
                        break block0;
                    }
                    case 32: {
                        this.audioSyncSamples = syncSamples;
                        break block0;
                    }
                }
                log.error((Object)String.format("processAtom 'stss' unknown track type %d", this.trackType));
                break;
            }
        }
    }

    private void processAtom(int atom) {
        switch (atom) {
            case 1953653099: {
                this.trackType = 0;
                this.numberOfSamplesPerChunk = null;
                this.samplesSize = null;
                ++this.numberOfTracks;
            }
        }
    }

    private void addCurrentAtomContent(Memory mem, int addr, int size) {
        for (int i = 0; i < size; ++i) {
            this.currentAtomContent[this.currentAtomOffset++] = mem.read8(addr++);
        }
    }

    private void parseAtoms(Memory mem, int addr, int size) {
        int offset = 0;
        if (this.currentAtom != 0) {
            int length = Math.min(size, this.currentAtomSize - this.currentAtomOffset);
            this.addCurrentAtomContent(mem, addr, length);
            offset += length;
            if (this.currentAtomOffset >= this.currentAtomSize) {
                this.processAtom(this.currentAtom, this.currentAtomContent, this.currentAtomSize);
                this.currentAtom = 0;
                this.currentAtomContent = null;
            }
        }
        while (offset + 8 <= size) {
            int atomSize = sceMp4.read32(mem, addr + offset);
            int atom = sceMp4.read32(mem, addr + offset + 4);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("parseAtoms atom=0x%08X(%s), size=0x%X, offset=0x%X", atom, sceMp4.atomToString(atom), atomSize, this.parseOffset + (long)offset));
            }
            if (atomSize <= 0) break;
            if (sceMp4.isAtomContentRequired(atom)) {
                if (offset + atomSize <= size) {
                    this.processAtom(mem, addr + offset + 8, atom, atomSize - 8);
                } else {
                    this.currentAtom = atom;
                    this.currentAtomSize = atomSize - 8;
                    this.currentAtomOffset = 0;
                    this.currentAtomContent = new int[this.currentAtomSize];
                    this.addCurrentAtomContent(mem, addr + offset + 8, size - offset - 8);
                    atomSize = size - offset;
                }
            } else {
                this.processAtom(atom);
            }
            if (sceMp4.isContainerAtom(atom)) {
                offset += 8;
                continue;
            }
            offset += atomSize;
        }
        this.parseOffset += (long)offset;
    }

    private void afterReadHeadersRead(int readSize) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("afterReadHeadersRead: %s", Utilities.getMemoryDump(this.readBufferAddr, readSize)));
        }
        Memory mem = Memory.getInstance();
        if (this.parseOffset == 0L && readSize >= 12) {
            int header1 = sceMp4.read32(mem, this.readBufferAddr);
            int header2 = sceMp4.read32(mem, this.readBufferAddr + 4);
            int header3 = sceMp4.read32(mem, this.readBufferAddr + 8);
            if (header1 < 12 || header2 != 1718909296 || header3 != 1297305174 && header3 != 1769172845 && header3 != 1836069938) {
                log.warn((Object)String.format("Invalid MP4 file header 0x%08X 0x%08X 0x%08X: %s", header1, header2, header3, Utilities.getMemoryDump(this.readBufferAddr, Math.min(16, readSize))));
                readSize = 0;
            }
        }
        this.parseAtoms(mem, this.readBufferAddr, readSize);
        if (readSize > 0) {
            this.callSeekCallback(null, new AfterReadHeadersSeek(), this.parseOffset, 0);
        } else {
            if (log.isTraceEnabled() && this.currentTrack != null) {
                log.trace((Object)String.format("afterReadHeadersRead updated track %s", this.currentTrack));
            }
            this.currentTrack = null;
            this.currentTracAddr = null;
        }
    }

    private void afterReadHeadersSeek(long seek) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("afterReadHeadersSeek seek=0x%X", seek));
        }
        this.callReadCallback(null, new AfterReadHeadersRead(), this.readBufferAddr, this.readBufferSize);
    }

    protected void readHeaders(SceMp4TrackSampleBuf track, TPointer trackAddr) {
        if (this.videoSamplesOffset != null && this.videoSamplesSize != null) {
            return;
        }
        this.parseOffset = 0L;
        this.duration = 0;
        this.currentAtom = 0;
        this.numberOfTracks = 0;
        this.currentTrack = track;
        this.currentTracAddr = trackAddr;
        this.callSeekCallback(null, new AfterReadHeadersSeek(), this.parseOffset, 0);
    }

    protected int getSampleOffset(int sample) {
        return this.getSampleOffset(this.currentTrack.trackType, sample);
    }

    protected int getSampleOffset(int trackType, int sample) {
        if ((trackType & 0x20) != 0) {
            if (this.audioSamplesOffset == null || sample < 0 || sample >= this.audioSamplesOffset.length) {
                return -1;
            }
            return this.audioSamplesOffset[sample];
        }
        if ((trackType & 0x10) != 0) {
            if (this.videoSamplesOffset == null || sample < 0 || sample >= this.videoSamplesOffset.length) {
                return -1;
            }
            return this.videoSamplesOffset[sample];
        }
        log.error((Object)String.format("getSampleOffset unknown trackType=0x%X", trackType));
        return -1;
    }

    protected int getSampleSize(int sample) {
        return this.getSampleSize(this.currentTrack.trackType, sample);
    }

    protected int getSampleSize(int trackType, int sample) {
        if ((trackType & 0x20) != 0) {
            if (this.audioSamplesSize == null || sample < 0 || sample >= this.audioSamplesSize.length) {
                return -1;
            }
            return this.audioSamplesSize[sample];
        }
        if ((trackType & 0x10) != 0) {
            if (this.videoSamplesSize == null || sample < 0 || sample >= this.videoSamplesSize.length) {
                return -1;
            }
            return this.videoSamplesSize[sample];
        }
        log.error((Object)String.format("getSampleSize unknown trackType=0x%X", trackType));
        return -1;
    }

    protected int getSampleDuration(int sample) {
        return this.getSampleDuration(this.currentTrack.trackType, sample);
    }

    protected int getSampleDuration(int trackType, int sample) {
        if ((trackType & 0x20) != 0) {
            if (this.audioSamplesDuration == null || sample < 0 || sample >= this.audioSamplesDuration.length) {
                return -1;
            }
            return this.audioSamplesDuration[sample];
        }
        if ((trackType & 0x10) != 0) {
            if (this.videoSamplesDuration == null || sample < 0 || sample >= this.videoSamplesDuration.length) {
                return -1;
            }
            return this.videoSamplesDuration[sample];
        }
        log.error((Object)String.format("getSampleDuration unknown trackType=0x%X", trackType));
        return -1;
    }

    protected int getSamplePresentationOffset(int sample) {
        return this.getSamplePresentationOffset(this.currentTrack.trackType, sample);
    }

    protected int getSamplePresentationOffset(int trackType, int sample) {
        if ((trackType & 0x20) != 0) {
            if (this.audioSamplesPresentationOffset == null || sample < 0 || sample >= this.audioSamplesPresentationOffset.length) {
                return 0;
            }
            return this.audioSamplesPresentationOffset[sample];
        }
        if ((trackType & 0x10) != 0) {
            if (this.videoSamplesPresentationOffset == null || sample < 0 || sample >= this.videoSamplesPresentationOffset.length) {
                return 0;
            }
            return this.videoSamplesPresentationOffset[sample];
        }
        log.error((Object)String.format("getSamplePresentationOffset unknown trackType=0x%X", trackType));
        return 0;
    }

    private void afterBufferPutSeek(long seek) {
        this.currentTrack.currentFileOffset = seek;
        this.callReadCallback(this.bufferPutThread, new AfterBufferPutRead(), this.currentTrack.readBufferAddr, this.currentTrack.readBufferSize);
    }

    private void afterBufferPutRead(int size) {
        this.currentTrack.sizeAvailableInReadBuffer = size;
        this.bufferPut();
    }

    private void bufferPut(long seek) {
        seek = Utilities.alignDown(seek, (long)(this.currentTrack.readBufferSize - 1));
        this.callSeekCallback(this.bufferPutThread, new AfterBufferPutSeek(), seek, 0);
    }

    private void addBytesToTrack(Memory mem, int addr, int length) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("addBytesToTrack addr=0x%08X, length=0x%X: %s", addr, length, Utilities.getMemoryDump(addr, length)));
        }
        this.currentTrack.addBytesToTrack(addr, length);
    }

    private void bufferPut() {
        Memory mem = Memory.getInstance();
        while (this.bufferPutSamples > 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("bufferPut samples=0x%X, remainingBytes=0x%X, currentTrack=%s", this.bufferPutSamples, this.bufferPutCurrentSampleRemainingBytes, this.currentTrack));
            }
            if (this.bufferPutCurrentSampleRemainingBytes > 0) {
                int length = Math.min(this.currentTrack.readBufferSize, this.bufferPutCurrentSampleRemainingBytes);
                this.addBytesToTrack(mem, this.currentTrack.readBufferAddr, length);
                this.bufferPutCurrentSampleRemainingBytes -= length;
                if (this.bufferPutCurrentSampleRemainingBytes > 0) {
                    this.bufferPut(this.currentTrack.currentFileOffset + (long)this.currentTrack.readBufferSize);
                    break;
                }
                this.currentTrack.addSamplesToTrack(1);
                --this.bufferPutSamples;
                ++this.bufferPutSamplesPut;
                continue;
            }
            int sample = this.currentTrack.currentSample;
            int sampleOffset = this.getSampleOffset(sample);
            int sampleSize = this.getSampleSize(sample);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("bufferPut sample=0x%X, offset=0x%X, size=0x%X, currentFilePosition=0x%X, readSize=0x%X", sample, sampleOffset, sampleSize, this.currentTrack.currentFileOffset, this.currentTrack.sizeAvailableInReadBuffer));
            }
            if (sampleOffset < 0) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("bufferPut reached last frame at sample 0x%X, stopping", sample));
                }
                this.bufferPutSamples = 0;
                break;
            }
            if (sampleSize > this.currentTrack.bufBytes.getWritableSpace()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("bufferPut bufBytes full (remaining 0x%X bytes, sample size=0x%X), stopping", this.currentTrack.bufBytes.getWritableSpace(), sampleSize));
                }
                this.bufferPutSamples = 0;
                break;
            }
            if (this.currentTrack.isInReadBuffer(sampleOffset)) {
                int sampleReadBufferOffset = (int)((long)sampleOffset - this.currentTrack.currentFileOffset);
                int sampleAddr = this.currentTrack.readBufferAddr + sampleReadBufferOffset;
                if (this.currentTrack.isInReadBuffer(sampleOffset + sampleSize)) {
                    this.addBytesToTrack(mem, sampleAddr, sampleSize);
                    this.currentTrack.addSamplesToTrack(1);
                    --this.bufferPutSamples;
                    ++this.bufferPutSamplesPut;
                    continue;
                }
                int availableSampleLength = this.currentTrack.sizeAvailableInReadBuffer - sampleReadBufferOffset;
                this.addBytesToTrack(mem, sampleAddr, availableSampleLength);
                this.bufferPutCurrentSampleRemainingBytes = sampleSize - availableSampleLength;
                this.bufferPut(this.currentTrack.currentFileOffset + (long)this.currentTrack.readBufferSize);
                break;
            }
            this.bufferPut(sampleOffset);
            break;
        }
        if (this.bufferPutSamples <= 0 && this.bufferPutInProgress) {
            this.currentTrack.write(this.currentTracAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("bufferPut returning 0x%X for thread %s", this.bufferPutSamplesPut, this.bufferPutThread));
            }
            this.bufferPutThread.cpuContext._v0 = this.bufferPutSamplesPut;
            this.bufferPutInProgress = false;
            if (!this.threadsWaitingOnBufferPut.isEmpty()) {
                int threadUid = this.threadsWaitingOnBufferPut.remove(0);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("bufferPut unblocking thread %s", Modules.ThreadManForUserModule.getThreadById(threadUid)));
                }
                Modules.ThreadManForUserModule.hleUnblockThread(threadUid);
            }
        }
    }

    protected void bufferPut(SceKernelThreadInfo thread, SceMp4TrackSampleBuf track, TPointer trackAddr, int samples) {
        if (this.bufferPutInProgress) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("bufferPut blocking thread %s", thread));
            }
            BufferPutUnblock bufferPutUnblock = new BufferPutUnblock(track, trackAddr, samples, thread);
            this.threadsWaitingOnBufferPut.add(thread.uid);
            Modules.ThreadManForUserModule.hleBlockThread(thread, 12, 0, false, bufferPutUnblock, new BufferPutWaitStateChecker());
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("bufferPut starting samples=0x%X, thread=%s", samples, thread));
            }
            this.bufferPutInProgress = true;
            this.currentTrack = track;
            this.currentTracAddr = trackAddr;
            this.bufferPutSamples = samples;
            this.bufferPutCurrentSampleRemainingBytes = 0;
            this.bufferPutSamplesPut = 0;
            this.bufferPutThread = thread;
            this.bufferPut();
        }
    }

    protected void callReadCallback(SceKernelThreadInfo thread, IAction afterAction, int readAddr, int readBytes) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("callReadCallback readAddr=0x%08X, readBytes=0x%X", readAddr, readBytes));
        }
        Modules.ThreadManForUserModule.executeCallback(thread, this.callbackRead, afterAction, false, this.callbackParam, readAddr, readBytes);
    }

    protected void callGetCurrentPositionCallback(SceKernelThreadInfo thread, IAction afterAction) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("callGetCurrentPositionCallback", new Object[0]));
        }
        Modules.ThreadManForUserModule.executeCallback(thread, this.callbackGetCurrentPosition, afterAction, false, this.callbackParam);
    }

    protected void callSeekCallback(SceKernelThreadInfo thread, IAction afterAction, long offset, int whence) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("callSeekCallback offset=0x%X, whence=%s", offset, IoFileMgrForUser.getWhenceName(whence)));
        }
        Modules.ThreadManForUserModule.executeCallback(thread, this.callbackSeek, afterAction, false, this.callbackParam, 0, (int)(offset & 0xFFFFFFFFFFFFFFFFL), (int)(offset >>> 32), whence);
    }

    protected void hleMp4Init() {
        this.readBufferAddr = 0;
        this.readBufferSize = 0;
        this.videoSamplesOffset = null;
        this.videoSamplesSize = null;
        this.videoSamplesDuration = null;
        this.videoSamplesPresentationOffset = null;
        this.videoCurrentTimestamp = 0L;
        this.audioSamplesOffset = null;
        this.audioSamplesSize = null;
        this.audioSamplesDuration = null;
        this.audioSamplesPresentationOffset = null;
        this.audioCurrentTimestamp = 0L;
        this.trackType = 0;
        this.threadsWaitingOnBufferPut = new LinkedList<Integer>();
        this.bufferPutInProgress = false;
        H264Utils.setAlpha(0);
    }

    protected void readCallbacks(TPointer32 callbacks) {
        this.callbackParam = callbacks.getValue(0);
        this.callbackGetCurrentPosition = callbacks.getValue(4);
        this.callbackSeek = callbacks.getValue(8);
        this.callbackRead = callbacks.getValue(12);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4 callbacks: param=0x%08X, getCurrentPosition=0x%08X, seek=0x%08X, read=0x%08X", this.callbackParam, this.callbackGetCurrentPosition, this.callbackSeek, this.callbackRead));
        }
    }

    protected long sampleToFrameDuration(long sampleDuration, SceMp4TrackSampleBuf track) {
        return this.sampleToFrameDuration(sampleDuration, track.timeScale);
    }

    protected long sampleToFrameDuration(long sampleDuration, int timeScale) {
        if (timeScale == 0) {
            return sampleDuration;
        }
        return sampleDuration * 90000L / (long)timeScale;
    }

    protected long getTotalFrameDuration(SceMp4TrackSampleBuf track) {
        long totalSampleDuration = 0L;
        for (int sample = 0; sample < track.totalNumberSamples; ++sample) {
            int sampleDuration = this.getSampleDuration(track.trackType, sample);
            totalSampleDuration += (long)sampleDuration;
        }
        long totalFrameDuration = this.sampleToFrameDuration(totalSampleDuration, track);
        return totalFrameDuration;
    }

    @HLEFunction(nid=1751456956, version=150, checkInsideInterrupt=true)
    public int sceMp4Init(boolean unk1, boolean unk2) {
        this.hleMp4Init();
        return 0;
    }

    @HLEFunction(nid=-1874677161, version=150, checkInsideInterrupt=true)
    public int sceMp4Finish() {
        this.videoSamplesOffset = null;
        this.videoSamplesSize = null;
        this.audioSamplesOffset = null;
        this.audioSamplesSize = null;
        this.currentTrack = null;
        this.currentTracAddr = null;
        return 0;
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1323163929, version=150, checkInsideInterrupt=true)
    public int sceMp4Create(int mp4, TPointer32 callbacks, TPointer readBufferAddr, int readBufferSize) {
        this.readBufferAddr = readBufferAddr.getAddress();
        this.readBufferSize = readBufferSize;
        this.readCallbacks(callbacks);
        this.readHeaders(null, null);
        return 0;
    }

    @HLEFunction(nid=1401692247, version=150)
    public int sceMp4Delete() {
        H264Utils.setAlpha(255);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=289316475, version=150)
    public int sceMp4GetNumberOfMetaData(int mp4) {
        return 0;
    }

    @HLEFunction(nid=1950592797, version=150)
    public int sceMp4GetMovieInfo(int mp4, @CanBeNull TPointer32 movieInfo) {
        movieInfo.setValue(0, this.numberOfTracks);
        movieInfo.setValue(4, 0);
        movieInfo.setValue(8, (int)this.sampleToFrameDuration((long)this.duration, this.timeScale));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4GetMovieInfo returning numberOfTracks=%d, duration=0x%X", movieInfo.getValue(0), movieInfo.getValue(8)));
        }
        return 0;
    }

    @HLEFunction(nid=1589010214, version=150)
    public int sceMp4GetNumberOfSpecificTrack(int mp4, int trackType) {
        if ((trackType & 0x10) != 0) {
            return this.videoSamplesOffset != null ? 1 : 0;
        }
        if ((trackType & 0x20) != 0) {
            return this.audioSamplesOffset != null ? 1 : 0;
        }
        log.warn((Object)String.format("sceMp4GetNumberOfSpecificTrack unknown trackType=%X", trackType));
        return 0;
    }

    @HLEFunction(nid=2061488156, version=150)
    public int sceMp4RegistTrack(int mp4, int trackType, int unknown, TPointer32 callbacks, TPointer trackAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        track.currentSample = 0;
        track.trackType = trackType;
        if ((trackType & 0x10) != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMp4RegistTrack TRACK_TYPE_VIDEO", new Object[0]));
            }
            track.timeScale = this.videoTimeScale;
            track.duration = this.videoDuration;
            int n = track.totalNumberSamples = this.videoSamplesSize != null ? this.videoSamplesSize.length : 0;
        }
        if ((trackType & 0x20) != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMp4RegistTrack TRACK_TYPE_AUDIO", new Object[0]));
            }
            track.timeScale = this.audioTimeScale;
            track.duration = this.audioDuration;
            track.totalNumberSamples = this.audioSamplesSize != null ? this.audioSamplesSize.length : 0;
        }
        this.readCallbacks(callbacks);
        track.write(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4RegistTrack track %s", track));
        }
        this.readHeaders(track, trackAddr);
        return 0;
    }

    @HLEFunction(nid=-1129760612, version=150)
    public int sceMp4TrackSampleBufQueryMemSize(int trackType, int numSamples, int sampleSize, int unknown, int readBufferSize) {
        int value = Math.max(numSamples * sampleSize, unknown << 1) + (numSamples << 6) + readBufferSize + 256;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4TrackSampleBufQueryMemSize returning 0x%X", value));
        }
        return value;
    }

    @HLEFunction(nid=-1668329535, version=150)
    public int sceMp4TrackSampleBufConstruct(int mp4, TPointer trackAddr, TPointer buffer, int sampleBufQueyMemSize, int numSamples, int sampleSize, int unknown, int readBufferSize) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        track.mp4 = mp4;
        track.baseBufferAddr = buffer.getAddress();
        track.samplesPut = numSamples;
        track.sampleSize = sampleSize;
        track.unknown = unknown;
        track.bytesBufferAddr = Utilities.alignUp(buffer.getAddress(), 63) + (numSamples << 6);
        track.bytesBufferLength = Math.max(numSamples * sampleSize, unknown << 1);
        track.readBufferSize = readBufferSize;
        track.readBufferAddr = track.bytesBufferAddr + track.bytesBufferLength + 48;
        track.currentFileOffset = -1L;
        track.sizeAvailableInReadBuffer = 0;
        track.bufBytes = new SceMp4TrackSampleBuf.SceMp4TrackSampleBufInfo();
        track.bufBytes.totalSize = track.bytesBufferLength;
        track.bufBytes.readOffset = 0;
        track.bufBytes.writeOffset = 0;
        track.bufBytes.sizeAvailableForRead = 0;
        track.bufBytes.unknown16 = 1;
        track.bufBytes.bufferAddr = track.bytesBufferAddr;
        track.bufBytes.callback24 = 0;
        track.bufBytes.unknown28 = trackAddr.getAddress() + 184;
        track.bufBytes.unknown36 = mp4;
        track.bufSamples = new SceMp4TrackSampleBuf.SceMp4TrackSampleBufInfo();
        track.bufSamples.totalSize = numSamples;
        track.bufSamples.readOffset = 0;
        track.bufSamples.writeOffset = 0;
        track.bufSamples.sizeAvailableForRead = 0;
        track.bufSamples.unknown16 = 64;
        track.bufSamples.bufferAddr = Utilities.alignUp(buffer.getAddress(), 63);
        track.bufSamples.callback24 = 0;
        track.bufSamples.unknown28 = 0;
        track.bufSamples.unknown36 = mp4;
        track.write(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4TrackSampleBufConstruct track %s", track));
        }
        return 0;
    }

    @HLEFunction(nid=251758546, version=150)
    public int sceMp4GetAvcTrackInfoData(int mp4, TPointer trackAddr, @CanBeNull TPointer32 infoAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAvcTrackInfoData track %s", track));
        }
        long totalFrameDuration = this.getTotalFrameDuration(track);
        infoAddr.setValue(0, 0);
        infoAddr.setValue(4, (int)totalFrameDuration);
        infoAddr.setValue(8, track.totalNumberSamples);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAvcTrackInfoData returning info:%s", Utilities.getMemoryDump(infoAddr.getAddress(), 12)));
        }
        return 0;
    }

    @HLEFunction(nid=-1662585393, version=150)
    public int sceMp4GetAacTrackInfoData(int mp4, TPointer trackAddr, @CanBeNull TPointer32 infoAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAacTrackInfoData track %s", track));
        }
        long totalFrameDuration = this.getTotalFrameDuration(track);
        infoAddr.setValue(0, 0);
        infoAddr.setValue(4, (int)totalFrameDuration);
        infoAddr.setValue(8, track.totalNumberSamples);
        infoAddr.setValue(12, track.timeScale);
        infoAddr.setValue(16, this.audioChannels);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAacTrackInfoData returning info:%s", Utilities.getMemoryDump(infoAddr.getAddress(), 20)));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1322560286, version=150)
    public int sceMp4AacDecodeInitResource(int unknown) {
        return 0;
    }

    @HLEFunction(nid=284036396, version=150)
    public int sceMp4AacDecodeInit(TPointer32 aac) {
        aac.setValue(0);
        this.audioCodec = CodecFactory.getCodec(4099);
        int channels = 2;
        this.audioCodec.init(0, channels, channels, 0);
        return 0;
    }

    @HLEFunction(nid=1231981157, version=150)
    public int sceMp4TrackSampleBufFlush(int mp4, TPointer trackAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        track.bufBytes.flush();
        track.bufSamples.flush();
        track.write(trackAddr);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1263271727, version=150)
    public int sceMp4GetSampleNumWithTimeStamp(int mp4, TPointer trackAddr, TPointer32 timestampAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        int timestamp = timestampAddr.getValue(4);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetSampleNumWithTimeStamp timestamp=0x%X, track %s", timestamp, track));
        }
        int sample = track.currentSample;
        return sample;
    }

    @HLEFunction(nid=-138076479, version=150)
    public int sceMp4GetSampleInfo(int mp4, TPointer trackAddr, int sample, TPointer infoAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetSampleInfo track %s", track));
        }
        if (sample == -1) {
            sample = track.currentSample;
        }
        SceMp4SampleInfo info = new SceMp4SampleInfo();
        int sampleDuration = this.getSampleDuration(track.trackType, sample);
        long frameDuration = this.sampleToFrameDuration((long)sampleDuration, track);
        info.sample = sample;
        info.sampleOffset = this.getSampleOffset(track.trackType, sample);
        info.sampleSize = this.getSampleSize(track.trackType, sample);
        info.unknown1 = 0;
        info.frameDuration = (int)frameDuration;
        info.unknown2 = 0;
        info.timestamp1 = sample * info.frameDuration;
        info.timestamp2 = sample * info.frameDuration;
        info.write(infoAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetSampleInfo returning info=%s", info));
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1956760126, version=150)
    public int sceMp4SearchSyncSampleNum(int mp4, TPointer trackAddr, int searchDirection, int sample) {
        int[] syncSamples;
        if (searchDirection != 0 && searchDirection != 1) {
            return -2141097981;
        }
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4SearchSyncSampleNum track %s", track));
        }
        if (track.isOfType(32)) {
            syncSamples = this.audioSyncSamples;
        } else if (track.isOfType(16)) {
            syncSamples = this.videoSyncSamples;
        } else {
            log.error((Object)String.format("sceMp4SearchSyncSampleNum unknown track type 0x%X", track.trackType));
            return -1;
        }
        int syncSample = 0;
        if (syncSamples != null) {
            for (int i = 0; i < syncSamples.length; ++i) {
                if (sample > syncSamples[i]) {
                    syncSample = syncSamples[i];
                    continue;
                }
                if (sample == syncSamples[i] && searchDirection == 1) {
                    syncSample = syncSamples[i];
                    continue;
                }
                if (searchDirection != 1) break;
                syncSample = syncSamples[i];
                break;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4SearchSyncSampleNum returning 0x%X", syncSample));
        }
        return syncSample;
    }

    @HLEFunction(nid=-668660875, version=150)
    public int sceMp4PutSampleNum(int mp4, TPointer trackAddr, int sample) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4PutSampleNum track %s", track));
        }
        if (sample < 0 || sample >= track.totalNumberSamples) {
            return -2141097978;
        }
        track.currentSample = sample;
        track.write(trackAddr);
        return 0;
    }

    @HLEFunction(nid=-2024477512, version=150)
    public int sceMp4TrackSampleBufAvailableSize(int mp4, TPointer trackAddr, @CanBeNull TPointer32 writableSamplesAddr, @CanBeNull TPointer32 writableBytesAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        writableSamplesAddr.setValue(track.bufSamples.getWritableSpace());
        writableBytesAddr.setValue(track.bufBytes.getWritableSpace());
        int result = 0;
        if (writableSamplesAddr.getValue() < 0 || writableBytesAddr.getValue() < 0) {
            result = -2141097975;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4TrackSampleBufAvailableSize returning writableSamples=0x%X, writableBytes=0x%X, result=0x%08X", writableSamplesAddr.getValue(), writableBytesAddr.getValue(), result));
        }
        return result;
    }

    @HLEFunction(nid=834459616, version=150)
    public int sceMp4TrackSampleBufPut(int mp4, TPointer trackAddr, int samples) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        this.readHeaders(track, trackAddr);
        if (samples > 0) {
            SceKernelThreadInfo currentThread = Modules.ThreadManForUserModule.getCurrentThread();
            Modules.ThreadManForUserModule.pushActionForThread(currentThread, new StartBufferPut(track, trackAddr, samples, currentThread));
        }
        return 0;
    }

    @HLEFunction(nid=1442948848, version=150)
    public int sceMp4GetAacAu(int mp4, TPointer trackAddr, TPointer auAddr, @CanBeNull TPointer infoAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAacAu track %s, au %s", track, au));
        }
        if (track.bufSamples.sizeAvailableForRead <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMp4GetAacAu returning ERROR_MP4_NO_MORE_DATA", new Object[0]));
            }
            return -2141097974;
        }
        int sample = track.currentSample - track.bufSamples.sizeAvailableForRead;
        int sampleSize = this.getSampleSize(track.trackType, sample);
        int sampleDuration = this.getSampleDuration(track.trackType, sample);
        int samplePresentationOffset = this.getSamplePresentationOffset(track.trackType, sample);
        long frameDuration = this.sampleToFrameDuration((long)sampleDuration, track);
        long framePresentationOffset = this.sampleToFrameDuration((long)samplePresentationOffset, track);
        track.bufSamples.notifyRead(1);
        track.readBytes(au.esBuffer, sampleSize);
        au.esSize = sampleSize;
        au.dts = this.audioCurrentTimestamp;
        this.audioCurrentTimestamp += frameDuration;
        au.pts = au.dts + framePresentationOffset;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAacAu consuming one frame of size=0x%X, duration=0x%X, track %s", sampleSize, frameDuration, track));
        }
        au.write(auAddr);
        track.write(trackAddr);
        if (infoAddr.isNotNull()) {
            SceMp4SampleInfo info = new SceMp4SampleInfo();
            info.sample = sample;
            info.sampleOffset = this.getSampleOffset(track.trackType, sample);
            info.sampleSize = this.getSampleSize(track.trackType, sample);
            info.unknown1 = 0;
            info.frameDuration = (int)frameDuration;
            info.unknown2 = 0;
            info.timestamp1 = (int)au.dts;
            info.timestamp2 = (int)au.pts;
            info.write(infoAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMp4GetAacAu returning info=%s", info));
            }
        }
        return 0;
    }

    @HLEFunction(nid=1986251612, version=150)
    public int sceMp4AacDecode(TPointer32 aac, TPointer auAddr, TPointer bufferAddr, int init, int frequency) {
        int result;
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4AacDecode au=%s, esBuffer:%s", au, Utilities.getMemoryDump(au.esBuffer, au.esSize)));
        }
        if ((result = this.audioCodec.decode(auAddr.getMemory(), au.esBuffer, au.esSize, bufferAddr.getMemory(), bufferAddr.getAddress())) < 0) {
            log.error((Object)String.format("sceMp4AacDecode audio codec returned 0x%08X", result));
            result = -2141097663;
        } else {
            result = 0;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceMp4AacDecode returning 0x%X", result));
        }
        return result;
    }

    @HLEFunction(nid=1345993914, version=150)
    public int sceMp4GetAvcAu(int mp4, TPointer trackAddr, TPointer auAddr, @CanBeNull TPointer infoAddr) {
        SceMp4TrackSampleBuf track = new SceMp4TrackSampleBuf();
        track.read(trackAddr);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAvcAu track %s", track));
        }
        if (track.bufSamples.sizeAvailableForRead <= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceMp4GetAvcAu returning ERROR_MP4_NO_MORE_DATA", new Object[0]));
            }
            return -2141097974;
        }
        SceMpegAu au = new SceMpegAu();
        au.read(auAddr);
        int sample = track.currentSample - track.bufSamples.sizeAvailableForRead;
        int sampleSize = this.getSampleSize(track.trackType, sample);
        int sampleDuration = this.getSampleDuration(track.trackType, sample);
        int samplePresentationOffset = this.getSamplePresentationOffset(track.trackType, sample);
        long frameDuration = this.sampleToFrameDuration((long)sampleDuration, track);
        long framePresentationOffset = this.sampleToFrameDuration((long)samplePresentationOffset, track);
        track.bufSamples.notifyRead(1);
        track.readBytes(au.esBuffer, sampleSize);
        au.esSize = sampleSize;
        au.dts = this.videoCurrentTimestamp;
        this.videoCurrentTimestamp += frameDuration;
        au.pts = au.dts + framePresentationOffset;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceMp4GetAvcAu consuming one frame of size=0x%X, duration=0x%X, track %s", sampleSize, frameDuration, track));
        }
        au.write(auAddr);
        track.write(trackAddr);
        if (infoAddr.isNotNull()) {
            SceMp4SampleInfo info = new SceMp4SampleInfo();
            info.sample = sample;
            info.sampleOffset = this.getSampleOffset(track.trackType, sample);
            info.sampleSize = this.getSampleSize(track.trackType, sample);
            info.unknown1 = 0;
            info.frameDuration = (int)frameDuration;
            info.unknown2 = 0;
            info.timestamp1 = (int)au.dts;
            info.timestamp2 = (int)au.pts;
            info.write(infoAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("sceMp4GetAvcAu returning info=%s", info));
            }
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=29844617, version=150)
    public int sceMp4TrackSampleBufDestruct(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1729166967, version=150)
    public int sceMp4UnregistTrack(int unknown1, int unknown2) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1567798067, version=150)
    public int sceMp4AacDecodeExit(int unknown) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2100503444, version=150)
    public int sceMp4AacDecodeTermResource() {
        return 0;
    }

    @HLEFunction(nid=320593495, version=150)
    public int sceMp4InitAu(int mp4, TPointer bufferAddr, TPointer auAddr) {
        SceMpegAu au = new SceMpegAu();
        au.esBuffer = bufferAddr.getAddress();
        au.esSize = 0;
        au.write(auAddr);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=401254781, version=150)
    public int sceMp4GetAvcAuWithoutSampleBuf(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=684505408, version=150)
    public int sceMp4GetTrackEditList(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=812237493, version=150)
    public int sceMp4GetAvcParamSet(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-760440194, version=150)
    public int sceMp4GetMetaData(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1337309014, version=150)
    public int sceMp4GetMetaDataInfo(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1115418495, version=150)
    public int sceMp4GetTrackNumOfEditList(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1394616760, version=150)
    public int sceMp4GetAacAuWithoutSampleBuf(int mp4) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1496898340, version=150)
    public int sceMp4GetSampleNum(int mp4) {
        return 0;
    }

    private class BufferPutWaitStateChecker
    implements IWaitStateChecker {
        private BufferPutWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("BufferPutWaitStateChecker.continueWaitState for thread %s returning %b", thread, sceMp4.this.threadsWaitingOnBufferPut.contains(thread.uid)));
            }
            return sceMp4.this.threadsWaitingOnBufferPut.contains(thread.uid);
        }
    }

    private class BufferPutUnblock
    implements IAction {
        private SceMp4TrackSampleBuf track;
        private TPointer trackAddr;
        private int samples;
        private SceKernelThreadInfo thread;

        public BufferPutUnblock(SceMp4TrackSampleBuf track, TPointer trackAddr, int samples, SceKernelThreadInfo thread) {
            this.track = track;
            this.trackAddr = trackAddr;
            this.samples = samples;
            this.thread = thread;
        }

        @Override
        public void execute() {
            Modules.ThreadManForUserModule.pushActionForThread(this.thread, new StartBufferPut(this.track, this.trackAddr, this.samples, this.thread));
        }
    }

    private class StartBufferPut
    implements IAction {
        private SceMp4TrackSampleBuf track;
        private TPointer trackAddr;
        private int samples;
        private SceKernelThreadInfo thread;

        public StartBufferPut(SceMp4TrackSampleBuf track, TPointer trackAddr, int samples, SceKernelThreadInfo thread) {
            this.track = track;
            this.trackAddr = trackAddr;
            this.samples = samples;
            this.thread = thread;
        }

        @Override
        public void execute() {
            sceMp4.this.bufferPut(this.thread, this.track, this.trackAddr, this.samples);
        }
    }

    private class AfterBufferPutRead
    implements IAction {
        private AfterBufferPutRead() {
        }

        @Override
        public void execute() {
            sceMp4.this.afterBufferPutRead(Emulator.getProcessor().cpu._v0);
        }
    }

    private class AfterBufferPutSeek
    implements IAction {
        private AfterBufferPutSeek() {
        }

        @Override
        public void execute() {
            sceMp4.this.afterBufferPutSeek(Utilities.getReturnValue64(Emulator.getProcessor().cpu));
        }
    }

    private class AfterReadHeadersSeek
    implements IAction {
        private AfterReadHeadersSeek() {
        }

        @Override
        public void execute() {
            sceMp4.this.afterReadHeadersSeek(Utilities.getReturnValue64(Emulator.getProcessor().cpu));
        }
    }

    private class AfterReadHeadersRead
    implements IAction {
        private AfterReadHeadersRead() {
        }

        @Override
        public void execute() {
            sceMp4.this.afterReadHeadersRead(Emulator.getProcessor().cpu._v0);
        }
    }
}

