/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer16;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhocctl;
import jpcsp.HLE.modules.sceUtility;
import jpcsp.Memory;
import jpcsp.hardware.Wlan;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocSocket;
import jpcsp.network.adhoc.PdpObject;
import jpcsp.network.adhoc.PtpObject;
import jpcsp.network.upnp.AutoDetectJpcsp;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetAdhoc
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetAdhoc");
    private int netClientPortShift = 0;
    private int netServerPortShift = 0;
    protected static final int GAME_MODE_UPDATE_MICROS = 12000;
    protected static final int GAME_MODE_TIMEOUT_MICROS = 6000;
    protected static final int PSP_ADHOC_POLL_READY_TO_SEND = 1;
    protected static final int PSP_ADHOC_POLL_DATA_AVAILABLE = 2;
    protected static final int PSP_ADHOC_POLL_CAN_CONNECT = 4;
    protected static final int PSP_ADHOC_POLL_CAN_ACCEPT = 8;
    protected HashMap<Integer, PdpObject> pdpObjects;
    protected HashMap<Integer, PtpObject> ptpObjects;
    private int currentFreePort;
    public static final byte[] ANY_MAC_ADDRESS = new byte[]{-1, -1, -1, -1, -1, -1};
    protected GameModeArea masterGameModeArea;
    protected LinkedList<GameModeArea> replicaGameModeAreas;
    private static final String replicaIdPurpose = "sceNetAdhoc-Replica";
    private static final int adhocGameModePort = 31000;
    private AdhocSocket gameModeSocket;
    private boolean isInitialized;
    private GameModeUpdateThread gameModeUpdateThread;
    private Map<byte[], Set<Integer>> alreadyReceivedAdhocMessageIds = new HashMap<byte[], Set<Integer>>();
    private Set<byte[]> uniqueMacAdresses = new HashSet<byte[]>();
    private int currentAdhocMessageId;

    protected static String getPollEventName(int event) {
        return String.format("Unknown 0x%X", event);
    }

    @Override
    public void start() {
        this.setSettingsListener("emu.netClientPortShift", new ClientPortShiftSettingsListener());
        this.setSettingsListener("emu.netServerPortShift", new ServerPortShiftSettingsListener());
        AutoDetectJpcsp autoDetectJpcsp = AutoDetectJpcsp.getInstance();
        if (autoDetectJpcsp != null) {
            autoDetectJpcsp.discoverOtherJpcspInBackground();
        }
        this.pdpObjects = new HashMap();
        this.ptpObjects = new HashMap();
        this.currentFreePort = 16384;
        this.replicaGameModeAreas = new LinkedList();
        this.isInitialized = false;
        this.alreadyReceivedAdhocMessageIds.clear();
        this.currentAdhocMessageId = 1;
        super.start();
    }

    public static long getNow() {
        return Emulator.getClock().microTime();
    }

    public int getNewAdhocMessageId() {
        return this.currentAdhocMessageId++;
    }

    private byte[] getUniqueFromMacAddress(AdhocMessage adhocMessage) {
        byte[] fromMacAddress = adhocMessage.getFromMacAddress();
        for (byte[] uniqueMacAddress : this.uniqueMacAdresses) {
            if (!Arrays.equals(uniqueMacAddress, fromMacAddress)) continue;
            return uniqueMacAddress;
        }
        this.uniqueMacAdresses.add(fromMacAddress);
        return fromMacAddress;
    }

    public boolean isAlreadyReceived(AdhocMessage adhocMessage) {
        byte[] uniqueFromMacAddress = this.getUniqueFromMacAddress(adhocMessage);
        Set<Integer> alreadyReceivedIds = this.alreadyReceivedAdhocMessageIds.get(uniqueFromMacAddress);
        if (alreadyReceivedIds == null) {
            return false;
        }
        return alreadyReceivedIds.contains(adhocMessage.getId());
    }

    public void setAlreadyReceived(AdhocMessage adhocMessage) {
        byte[] uniqueFromMacAddress = this.getUniqueFromMacAddress(adhocMessage);
        Set<Integer> alreadyReceivedIds = this.alreadyReceivedAdhocMessageIds.get(uniqueFromMacAddress);
        if (alreadyReceivedIds == null) {
            alreadyReceivedIds = new HashSet<Integer>();
            this.alreadyReceivedAdhocMessageIds.put(uniqueFromMacAddress, alreadyReceivedIds);
        }
        alreadyReceivedIds.add(adhocMessage.getId());
    }

    public void setNetClientPortShift(int netClientPortShift) {
        if (!Wlan.hasLocalInetAddress()) {
            this.netClientPortShift = netClientPortShift;
            log.info((Object)String.format("Using netClientPortShift=%d", netClientPortShift));
        }
    }

    public void setNetServerPortShift(int netServerPortShift) {
        if (!Wlan.hasLocalInetAddress()) {
            this.netServerPortShift = netServerPortShift;
            log.info((Object)String.format("Using netServerPortShift=%d", netServerPortShift));
        }
    }

    public int getClientPortFromRealPort(byte[] clientMacAddress, int realPort) {
        if (sceNetAdhoc.isMyMacAddress(clientMacAddress)) {
            return this.getServerPortFromRealPort(realPort);
        }
        return realPort - this.netClientPortShift;
    }

    public int getRealPortFromClientPort(byte[] clientMacAddress, int clientPort) {
        if (sceNetAdhoc.isMyMacAddress(clientMacAddress)) {
            return this.getRealPortFromServerPort(clientPort);
        }
        return clientPort + this.netClientPortShift;
    }

    public int getServerPortFromRealPort(int realPort) {
        return realPort - this.netServerPortShift;
    }

    public int getRealPortFromServerPort(int serverPort) {
        return serverPort + this.netServerPortShift;
    }

    public boolean hasNetPortShiftActive() {
        return this.netServerPortShift > 0 || this.netClientPortShift > 0;
    }

    protected void checkInitialized() {
        if (!this.isInitialized) {
            throw new SceKernelErrorException(-2143221998);
        }
    }

    public void hleExitGameMode() {
        this.masterGameModeArea = null;
        this.replicaGameModeAreas.clear();
        this.stopGameMode();
    }

    private boolean sendGameModeBuffer(byte[] toMacAddress, byte[] buffer, int length) throws IOException {
        boolean success = false;
        AdhocMessage adhocGameModeMessage = this.getNetworkAdapter().createAdhocGameModeMessage(buffer, length);
        adhocGameModeMessage.setFromMacAddress(Wlan.getMacAddress());
        adhocGameModeMessage.setToMacAddress(toMacAddress);
        SocketAddress[] socketAddress = Modules.sceNetAdhocModule.getMultiSocketAddress(toMacAddress, Modules.sceNetAdhocModule.getRealPortFromClientPort(toMacAddress, 31000));
        for (int i = 0; i < socketAddress.length; ++i) {
            try {
                this.gameModeSocket.send(socketAddress[i], adhocGameModeMessage);
                success = true;
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("GameMode message sent to %s: %s", socketAddress[i], adhocGameModeMessage));
                continue;
            }
            catch (SocketException e) {
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)String.format("hleGameModeUpdate failed for %s", socketAddress[i]));
                log.debug((Object)"hleGameModeUpdate", (Throwable)e);
            }
        }
        return success;
    }

    private void sendMasterGameModeArea() throws IOException {
        byte[] data;
        if (this.masterGameModeArea == null) {
            data = new byte[1];
        } else if (this.masterGameModeArea.hasNewData()) {
            data = this.masterGameModeArea.getNewData();
            this.masterGameModeArea.resetNewData();
        } else {
            data = this.masterGameModeArea.getData();
        }
        this.sendGameModeBuffer(ANY_MAC_ADDRESS, data, data.length);
    }

    /*
     * Unable to fully structure code
     */
    private void receiveReplicaGameModeArea(long start) throws IOException {
        while (true) {
            try {
                block3: while (true) {
                    bytes = new byte[10000];
                    length = this.gameModeSocket.receive(bytes, bytes.length);
                    adhocGameModeMessage = this.getNetworkAdapter().createAdhocGameModeMessage(bytes, length);
                    if (!adhocGameModeMessage.isForMe(this.gameModeSocket.getReceivedPort(), this.gameModeSocket.getReceivedAddress())) continue;
                    if (sceNetAdhoc.log.isDebugEnabled()) {
                        sceNetAdhoc.log.debug((Object)String.format("GameMode received: %s", new Object[]{adhocGameModeMessage}));
                    }
                    if (length == 0) {
                        if (sceNetAdhoc.log.isDebugEnabled()) {
                            sceNetAdhoc.log.debug((Object)String.format("Received request to send Master GameMode Area %s", new Object[]{this.masterGameModeArea}));
                        }
                        this.sendMasterGameModeArea();
                        continue;
                    }
                    if (length == 1) continue;
                    var6_6 = this.replicaGameModeAreas.iterator();
                    while (true) {
                        if (var6_6.hasNext()) ** break;
                        continue block3;
                        gameModeArea = (GameModeArea)var6_6.next();
                        if (!sceNetAdhoc.isSameMacAddress(gameModeArea.macAddress.macAddress, adhocGameModeMessage.getFromMacAddress())) continue;
                        if (sceNetAdhoc.log.isDebugEnabled()) {
                            sceNetAdhoc.log.debug((Object)String.format("Received new Data for GameMode Area %s", new Object[]{gameModeArea}));
                        }
                        gameModeArea.setNewData(adhocGameModeMessage.getData());
                    }
                    break;
                }
            }
            catch (SocketTimeoutException e) {
                if (sceNetAdhoc.getNow() - start <= 6000L) {
                    if (!sceNetAdhoc.log.isDebugEnabled()) continue;
                    sceNetAdhoc.log.debug((Object)String.format("receiveReplicaGameModeArea waiting for message...", new Object[0]));
                    continue;
                }
                return;
            }
            break;
        }
    }

    public long hleGameModeUpdate(long start) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleGameModeUpdate starting at start=%d", start));
        }
        long nextStart = start + 12000L;
        try {
            LinkedList<pspNetMacAddress> gameModeMacs;
            if (this.gameModeSocket == null) {
                this.gameModeSocket = this.getNetworkAdapter().createAdhocGameModeSocket();
                this.gameModeSocket.bind(Modules.sceNetAdhocModule.getRealPortFromServerPort(31000));
            }
            if ((gameModeMacs = Modules.sceNetAdhocctlModule.requiredGameModeMacs).size() > 0) {
                this.sendMasterGameModeArea();
                for (pspNetMacAddress macAddress : gameModeMacs) {
                    byte[] command;
                    if (sceNetAdhoc.isMyMacAddress(macAddress.macAddress)) continue;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("hleGameModeUpdate sending request to %s to broadcast its Master GameMode Area", macAddress));
                    }
                    if (!this.sendGameModeBuffer(macAddress.macAddress, command = new byte[0], command.length)) continue;
                    this.receiveReplicaGameModeArea(start);
                }
            } else {
                int numberGameModeMacs = Modules.sceNetAdhocctlModule.hleNetAdhocctlGetGameModeMacs().size();
                for (int i = 0; i < numberGameModeMacs; ++i) {
                    this.receiveReplicaGameModeArea(start);
                }
            }
        }
        catch (IOException e) {
            log.error((Object)"hleGameModeUpdate", (Throwable)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleGameModeUpdate ending with nextStart=%d", nextStart));
        }
        return nextStart;
    }

    protected void startGameMode() {
        if (this.gameModeUpdateThread == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Starting GameMode", new Object[0]));
            }
            this.gameModeUpdateThread = new GameModeUpdateThread();
            this.gameModeUpdateThread.setName("sceNetAdhoc GameMode Updade Thread");
            this.gameModeUpdateThread.setDaemon(true);
            this.gameModeUpdateThread.start();
        }
    }

    protected void stopGameMode() {
        if (this.gameModeUpdateThread != null) {
            this.gameModeUpdateThread.exit();
            this.gameModeUpdateThread = null;
        }
        if (this.gameModeSocket != null) {
            try {
                this.gameModeSocket.close();
            }
            catch (IOException e) {
                log.error((Object)"stopGameMode", (Throwable)e);
            }
            this.gameModeSocket = null;
        }
    }

    public SocketAddress getSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        return this.getNetworkAdapter().getSocketAddress(macAddress, realPort);
    }

    public SocketAddress[] getMultiSocketAddress(byte[] macAddress, int realPort) throws UnknownHostException {
        return this.getNetworkAdapter().getMultiSocketAddress(macAddress, realPort);
    }

    public static boolean isSameMacAddress(byte[] macAddress1, byte[] macAddress2) {
        return pspNetMacAddress.equals(macAddress1, macAddress2);
    }

    public static boolean isAnyMacAddress(byte[] macAddress) {
        return pspNetMacAddress.isAnyMacAddress(macAddress);
    }

    public static boolean isMyMacAddress(byte[] macAddress) {
        return pspNetMacAddress.isMyMacAddress(macAddress);
    }

    private int getFreePort() {
        int freePort = this.currentFreePort++;
        if (this.netClientPortShift > 0 || this.netServerPortShift > 0) {
            this.currentFreePort += 2;
        }
        if (this.currentFreePort > Short.MAX_VALUE) {
            this.currentFreePort -= 16384;
        }
        return freePort;
    }

    public int checkPdpId(int pdpId) {
        this.checkInitialized();
        if (!this.pdpObjects.containsKey(pdpId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid Pdp Id=0x%X", pdpId));
            }
            throw new SceKernelErrorException(-2143222015);
        }
        return pdpId;
    }

    public int checkPtpId(int ptpId) {
        this.checkInitialized();
        if (!this.ptpObjects.containsKey(ptpId)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Invalid Ptp Id=0x%X", ptpId));
            }
            throw new SceKernelErrorException(-2143222015);
        }
        return ptpId;
    }

    public void hleAddPtpObject(PtpObject ptpObject) {
        this.ptpObjects.put(ptpObject.getId(), ptpObject);
    }

    protected INetworkAdapter getNetworkAdapter() {
        return Modules.sceNetModule.getNetworkAdapter();
    }

    @HLEFunction(nid=-506060329, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocInit() {
        log.info((Object)String.format("sceNetAdhocInit: using MAC address=%s, nick name='%s'", sceNet.convertMacAddressToString(Wlan.getMacAddress()), sceUtility.getSystemParamNickname()));
        if (this.isInitialized) {
            return -2143221997;
        }
        this.isInitialized = true;
        return 0;
    }

    @HLEFunction(nid=-1507037353, version=150, checkInsideInterrupt=true)
    public int sceNetAdhocTerm() {
        this.isInitialized = false;
        return 0;
    }

    @HLEFunction(nid=2053516651, version=150)
    public int sceNetAdhocPollSocket(TPointer socketsAddr, int count, int timeout, int nonblock) {
        this.checkInitialized();
        Memory mem = Memory.getInstance();
        int countEvents = 0;
        for (int i = 0; i < count; ++i) {
            pspAdhocPollId pollId = new pspAdhocPollId();
            pollId.read(mem, socketsAddr.getAddress() + i * pollId.sizeof());
            PdpObject pdpObject = this.pdpObjects.get(pollId.id);
            PtpObject ptpObject = null;
            if (pdpObject == null) {
                ptpObject = this.ptpObjects.get(pollId.id);
                pdpObject = ptpObject;
            }
            if (pdpObject != null) {
                try {
                    pdpObject.update();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            pollId.revents = 0;
            if ((pollId.events & 2) != 0 && pdpObject.getRcvdData() > 0) {
                pollId.revents |= 2;
            }
            if ((pollId.events & 1) != 0) {
                pollId.revents |= 1;
            }
            if ((pollId.events & 4) != 0 && ptpObject != null && ptpObject.canConnect()) {
                pollId.revents |= 4;
            }
            if ((pollId.events & 8) != 0 && ptpObject != null && ptpObject.canAccept()) {
                pollId.revents |= 8;
            }
            if (pollId.revents != 0) {
                ++countEvents;
            }
            pollId.write(mem);
            log.info((Object)String.format("sceNetAdhocPollSocket pollId[0x%X]=%s", i, pollId));
        }
        return countEvents;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1941951789, version=150)
    public int sceNetAdhocSetSocketAlert(int id, int flags) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1294786969, version=150)
    public int sceNetAdhocGetSocketAlert() {
        return 0;
    }

    @HLEFunction(nid=1871868955, version=150)
    public int sceNetAdhocPdpCreate(pspNetMacAddress macAddress, int port, int bufSize, int unk1) {
        PdpObject pdpObject;
        int result;
        this.checkInitialized();
        if (port == 0) {
            port = this.getFreePort();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocPdpCreate: using free port 0x%X", port));
            }
        }
        if ((result = (pdpObject = this.getNetworkAdapter().createPdpObject()).create(macAddress, port, bufSize)) == pdpObject.getId()) {
            this.pdpObjects.put(pdpObject.getId(), pdpObject);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sceNetAdhocPdpCreate: returning id=0x%X", result));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocPdpCreate: returning error=0x%08X", result));
        }
        return result;
    }

    @HLEFunction(nid=-1410517104, version=150)
    public int sceNetAdhocPdpSend(@CheckArgument(value="checkPdpId") int id, pspNetMacAddress destMacAddress, int port, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer data, int len, int timeout, int nonblock) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(data.getAddress(), len)));
        }
        return this.pdpObjects.get(id).send(destMacAddress, port, data, len, timeout, nonblock);
    }

    @HLEFunction(nid=-538624509, version=150)
    public int sceNetAdhocPdpRecv(@CheckArgument(value="checkPdpId") int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=6, usage=BufferInfo.Usage.out) TPointer srcMacAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer16 portAddr, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=128, usage=BufferInfo.Usage.out) TPointer data, @BufferInfo(usage=BufferInfo.Usage.inout) TPointer32 dataLengthAddr, int timeout, int nonblock) {
        int result = this.pdpObjects.get(id).recv(srcMacAddr, portAddr, data, dataLengthAddr, timeout, nonblock);
        return result;
    }

    @HLEFunction(nid=2133310302, version=150)
    public int sceNetAdhocPdpDelete(@CheckArgument(value="checkPdpId") int id, int unk1) {
        this.pdpObjects.remove(id).delete();
        return 0;
    }

    @HLEFunction(nid=-943588265, version=150)
    public int sceNetAdhocGetPdpStat(TPointer32 sizeAddr, @CanBeNull TPointer buf) {
        this.checkInitialized();
        int objectInfoSize = 20;
        int size = sizeAddr.getValue();
        sizeAddr.setValue(20 * this.pdpObjects.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocGetPdpStat returning size=0x%X", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            for (int pdpId : this.pdpObjects.keySet()) {
                PdpObject pdpObject = this.pdpObjects.get(pdpId);
                if (offset + 20 > size || pdpObject == null) break;
                try {
                    pdpObject.update();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocGetPdpStat returning %s at 0x%08X", pdpObject, buf.getAddress() + offset));
                }
                buf.setValue32(offset += 4, pdpObject.getId());
                pdpObject.getMacAddress().write(buf.getMemory(), buf.getAddress() + (offset += 4));
                buf.setValue16(offset += pdpObject.getMacAddress().sizeof(), (short)pdpObject.getPort());
                buf.setValue32(offset += 2, pdpObject.getRcvdData());
                offset += 4;
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, 20);
        }
        return 0;
    }

    @HLEFunction(nid=-2021692058, version=150)
    public int sceNetAdhocPtpOpen(pspNetMacAddress srcMacAddress, int srcPort, pspNetMacAddress destMacAddress, int destPort, int bufSize, int retryDelay, int retryCount, int unk1) {
        this.checkInitialized();
        PtpObject ptpObject = this.getNetworkAdapter().createPtpObject();
        ptpObject.setMacAddress(srcMacAddress);
        ptpObject.setPort(srcPort);
        ptpObject.setDestMacAddress(destMacAddress);
        ptpObject.setDestPort(destPort);
        ptpObject.setBufSize(bufSize);
        ptpObject.setRetryDelay(retryDelay);
        ptpObject.setRetryCount(retryCount);
        int result = ptpObject.open();
        if (result != 0) {
            ptpObject.delete();
            return result;
        }
        this.ptpObjects.put(ptpObject.getId(), ptpObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocPtpOpen: returning id=0x%X", ptpObject.getId()));
        }
        return ptpObject.getId();
    }

    @HLEFunction(nid=-59785093, version=150)
    public int sceNetAdhocPtpConnect(@CheckArgument(value="checkPtpId") int id, int timeout, int nonblock) {
        return this.ptpObjects.get(id).connect(timeout, nonblock);
    }

    @HLEFunction(nid=-527705407, version=150)
    public int sceNetAdhocPtpListen(pspNetMacAddress srcMacAddress, int srcPort, int bufSize, int retryDelay, int retryCount, int queue, int unk1) {
        this.checkInitialized();
        PtpObject ptpObject = this.getNetworkAdapter().createPtpObject();
        ptpObject.setMacAddress(srcMacAddress);
        ptpObject.setPort(srcPort);
        ptpObject.setBufSize(bufSize);
        ptpObject.setRetryDelay(retryDelay);
        ptpObject.setRetryCount(retryCount);
        ptpObject.setQueue(queue);
        int result = ptpObject.listen();
        if (result != 0) {
            ptpObject.delete();
            return result;
        }
        this.ptpObjects.put(ptpObject.getId(), ptpObject);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocPtpListen: returning id=0x%X", ptpObject.getId()));
        }
        return ptpObject.getId();
    }

    @HLEFunction(nid=-1644686952, version=150)
    public int sceNetAdhocPtpAccept(@CheckArgument(value="checkPtpId") int id, @CanBeNull TPointer peerMacAddr, @CanBeNull TPointer16 peerPortAddr, int timeout, int nonblock) {
        return this.ptpObjects.get(id).accept(peerMacAddr.getAddress(), peerPortAddr.getAddress(), timeout, nonblock);
    }

    @HLEFunction(nid=1302644616, version=150)
    public int sceNetAdhocPtpSend(@CheckArgument(value="checkPtpId") int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.in) TPointer data, @BufferInfo(usage=BufferInfo.Usage.in) TPointer32 dataSizeAddr, int timeout, int nonblock) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(data.getAddress(), dataSizeAddr.getValue())));
        }
        return this.ptpObjects.get(id).send(data.getAddress(), dataSizeAddr, timeout, nonblock);
    }

    @HLEFunction(nid=-1947587778, version=150)
    public int sceNetAdhocPtpRecv(@CheckArgument(value="checkPtpId") int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer data, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 dataSizeAddr, int timeout, int nonblock) {
        return this.ptpObjects.get(id).recv(data, dataSizeAddr, timeout, nonblock);
    }

    @HLEFunction(nid=-1698500948, version=150)
    public int sceNetAdhocPtpFlush(@CheckArgument(value="checkPtpId") int id, int timeout, int nonblock) {
        return 0;
    }

    @HLEFunction(nid=360604197, version=150)
    public int sceNetAdhocPtpClose(@CheckArgument(value="checkPtpId") int id, int unknown) {
        this.ptpObjects.remove(id).delete();
        return 0;
    }

    @HLEFunction(nid=-1184345832, version=150)
    public int sceNetAdhocGetPtpStat(@BufferInfo(usage=BufferInfo.Usage.inout) TPointer32 sizeAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=72, usage=BufferInfo.Usage.out) TPointer buf) {
        this.checkInitialized();
        int objectInfoSize = 36;
        int size = sizeAddr.getValue();
        sizeAddr.setValue(36 * this.ptpObjects.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocGetPtpStat returning size=0x%X", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            pspNetMacAddress nonExistingDestMacAddress = new pspNetMacAddress();
            for (int pdpId : this.ptpObjects.keySet()) {
                PtpObject ptpObject = this.ptpObjects.get(pdpId);
                if (offset + 36 > size || ptpObject == null) break;
                try {
                    ptpObject.update();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocGetPtpStat returning %s at 0x%08X", ptpObject, buf.getAddress() + offset));
                }
                buf.setValue32(offset += 4, ptpObject.getId());
                ptpObject.getMacAddress().write(buf.getMemory(), buf.getAddress() + (offset += 4));
                offset += ptpObject.getMacAddress().sizeof();
                if (ptpObject.getDestMacAddress() != null) {
                    ptpObject.getDestMacAddress().write(buf.getMemory(), buf.getAddress() + offset);
                    offset += ptpObject.getDestMacAddress().sizeof();
                } else {
                    nonExistingDestMacAddress.write(buf.getMemory(), buf.getAddress() + offset);
                    offset += nonExistingDestMacAddress.sizeof();
                }
                buf.setValue16(offset, (short)ptpObject.getPort());
                buf.setValue16(offset += 2, (short)ptpObject.getDestPort());
                buf.setValue32(offset += 2, ptpObject.getSentData());
                buf.setValue32(offset += 4, ptpObject.getRcvdData());
                buf.setValue32(offset += 4, 4);
                offset += 4;
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, 36);
        }
        return 0;
    }

    @HLEFunction(nid=2138424120, version=150)
    public int sceNetAdhocGameModeCreateMaster(TPointer data, int size) {
        this.checkInitialized();
        this.masterGameModeArea = new GameModeArea(data, size);
        this.startGameMode();
        return 0;
    }

    @HLEFunction(nid=846768908, version=150)
    public int sceNetAdhocGameModeCreateReplica(pspNetMacAddress macAddress, TPointer data, int size) {
        this.checkInitialized();
        boolean found = false;
        int result = 0;
        for (GameModeArea gameModeArea : this.replicaGameModeAreas) {
            if (!sceNetAdhoc.isSameMacAddress(gameModeArea.macAddress.macAddress, macAddress.macAddress)) continue;
            gameModeArea.addr = data;
            gameModeArea.size = size;
            result = gameModeArea.id;
            found = true;
            break;
        }
        if (!found) {
            GameModeArea gameModeArea = new GameModeArea(macAddress, data, size);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Adding GameMode Replica %s", gameModeArea));
            }
            result = gameModeArea.id;
            this.replicaGameModeAreas.add(gameModeArea);
        }
        this.startGameMode();
        return result;
    }

    @HLEFunction(nid=-1732115256, version=150)
    public int sceNetAdhocGameModeUpdateMaster() {
        this.checkInitialized();
        if (this.masterGameModeArea != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Master Game Mode Area: %s", Utilities.getMemoryDump(this.masterGameModeArea.addr, this.masterGameModeArea.size)));
            }
            this.masterGameModeArea.setNewData();
        }
        return 0;
    }

    @HLEFunction(nid=-97367218, version=150)
    public int sceNetAdhocGameModeUpdateReplica(int id, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.variableLength, usage=BufferInfo.Usage.out) @CanBeNull TPointer infoAddr) {
        this.checkInitialized();
        for (GameModeArea gameModeArea : this.replicaGameModeAreas) {
            if (gameModeArea.id != id) continue;
            GameModeUpdateInfo gameModeUpdateInfo = new GameModeUpdateInfo();
            gameModeUpdateInfo.read(infoAddr);
            if (gameModeArea.hasNewData()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Updating GameMode Area with new data: %s", gameModeArea));
                }
                gameModeArea.writeNewData();
                gameModeArea.resetNewData();
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Replica GameMode Area updated: %s", Utilities.getMemoryDump(gameModeArea.addr, gameModeArea.size)));
                }
                gameModeUpdateInfo.updated = 1;
            } else {
                gameModeUpdateInfo.updated = 0;
            }
            gameModeUpdateInfo.timeStamp = gameModeArea.getUpdateTimestamp();
            gameModeUpdateInfo.write(infoAddr);
            break;
        }
        return 0;
    }

    @HLEFunction(nid=-1608346782, version=150)
    public int sceNetAdhocGameModeDeleteMaster() {
        this.checkInitialized();
        this.masterGameModeArea = null;
        if (this.replicaGameModeAreas.size() <= 0) {
            this.stopGameMode();
        }
        return 0;
    }

    @HLEFunction(nid=186788073, version=150)
    public int sceNetAdhocGameModeDeleteReplica(int id) {
        this.checkInitialized();
        for (GameModeArea gameModeArea : this.replicaGameModeAreas) {
            if (gameModeArea.id != id) continue;
            this.replicaGameModeAreas.remove(gameModeArea);
            break;
        }
        if (this.replicaGameModeAreas.size() <= 0 && this.masterGameModeArea == null) {
            this.stopGameMode();
        }
        return 0;
    }

    private class GameModeUpdateThread
    extends Thread {
        private boolean exit;

        private GameModeUpdateThread() {
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            long nextStart = sceNetAdhoc.getNow();
            while (!this.exit) {
                long start = nextStart;
                if (sceNetAdhoc.getNow() >= nextStart) {
                    start = sceNetAdhoc.getNow();
                } else {
                    long now;
                    while (!this.exit && (now = sceNetAdhoc.getNow()) < nextStart) {
                        Utilities.sleep((int)(nextStart - now));
                    }
                }
                if (this.exit) break;
                nextStart = sceNetAdhoc.this.hleGameModeUpdate(start);
            }
        }

        public void exit() {
            this.exit = true;
        }
    }

    protected static class GameModeUpdateInfo
    extends pspAbstractMemoryMappedStructureVariableLength {
        public int updated;
        public long timeStamp;

        protected GameModeUpdateInfo() {
        }

        @Override
        protected void read() {
            super.read();
            this.updated = this.read32();
            this.timeStamp = this.read64();
        }

        @Override
        protected void write() {
            super.write();
            this.write32(this.updated);
            this.write64(this.timeStamp);
        }
    }

    protected static class pspAdhocPollId
    extends pspAbstractMemoryMappedStructure {
        public int id;
        public int events;
        public int revents;

        protected pspAdhocPollId() {
        }

        @Override
        protected void read() {
            this.id = this.read32();
            this.events = this.read32();
            this.revents = this.read32();
        }

        @Override
        protected void write() {
            this.write32(this.id);
            this.write32(this.events);
            this.write32(this.revents);
        }

        @Override
        public int sizeof() {
            return 12;
        }

        @Override
        public String toString() {
            return String.format("PollId[id=0x%X, events=0x%X(%s), revents=0x%X(%s)]", this.id, this.events, sceNetAdhoc.getPollEventName(this.events), this.revents, sceNetAdhoc.getPollEventName(this.revents));
        }
    }

    public static class GameModeArea {
        public pspNetMacAddress macAddress;
        public TPointer addr;
        public int size;
        public int id;
        private byte[] data;
        private byte[] newData;
        private long updateTimestamp;

        public GameModeArea(TPointer addr, int size) {
            this.addr = addr;
            this.size = size;
            this.id = -1;
            this.readData();
        }

        public GameModeArea(pspNetMacAddress macAddress, TPointer addr, int size) {
            this.macAddress = macAddress;
            this.addr = addr;
            this.size = size;
            this.id = SceUidManager.getNewUid(sceNetAdhoc.replicaIdPurpose);
            this.readData();
        }

        public void delete() {
            if (this.id >= 0) {
                SceUidManager.releaseUid(this.id, sceNetAdhoc.replicaIdPurpose);
                this.id = -1;
            }
        }

        public synchronized void setNewData(byte[] newData) {
            this.updateTimestamp = sceNetAdhoc.getNow();
            this.newData = newData;
        }

        private synchronized void readData() {
            this.data = this.addr.getArray8(this.size);
        }

        public void setNewData() {
            this.setNewData(this.addr.getArray8(this.size));
        }

        public synchronized void resetNewData() {
            if (this.newData != null) {
                this.data = this.newData;
                this.newData = null;
            }
        }

        public synchronized byte[] getNewData() {
            return this.newData;
        }

        public synchronized byte[] getData() {
            return this.data;
        }

        public synchronized boolean hasNewData() {
            return this.newData != null;
        }

        public synchronized void writeNewData() {
            if (this.newData != null) {
                this.addr.setArray(this.newData, this.size);
            }
        }

        public long getUpdateTimestamp() {
            return this.updateTimestamp;
        }

        public String toString() {
            if (this.macAddress == null) {
                return String.format("Master GameModeArea addr=%s, size=0x%X", this.addr, this.size);
            }
            return String.format("Replica GameModeArea id=0x%X, macAddress=%s, addr=%s, size=0x%X", this.id, this.macAddress, this.addr, this.size);
        }
    }

    private class ServerPortShiftSettingsListener
    extends AbstractBoolSettingsListener {
        private ServerPortShiftSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            if (value) {
                sceNetAdhoc.this.setNetServerPortShift(100);
            } else {
                sceNetAdhoc.this.setNetServerPortShift(0);
            }
        }
    }

    private class ClientPortShiftSettingsListener
    extends AbstractBoolSettingsListener {
        private ClientPortShiftSettingsListener() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            if (value) {
                sceNetAdhoc.this.setNetClientPortShift(100);
            } else {
                sceNetAdhoc.this.setNetClientPortShift(0);
            }
        }
    }
}

