/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class scePsmfPlayer
extends HLEModule {
    public static Logger log = Modules.getLogger("scePsmfPlayer");
    private static final int ringbufferSize = 1251328;
    private static final int frameWidth = 512;
    public static final int videoTimestampStep = 3003;
    public static final int audioTimestampStep = 4180;
    public static final int PSMF_PLAYER_STATUS_NONE = 0;
    public static final int PSMF_PLAYER_STATUS_INIT = 1;
    public static final int PSMF_PLAYER_STATUS_STANDBY = 2;
    public static final int PSMF_PLAYER_STATUS_PLAYING = 4;
    public static final int PSMF_PLAYER_STATUS_ERROR = 256;
    public static final int PSMF_PLAYER_STATUS_PLAYING_FINISHED = 512;
    public static final int PSMF_PLAYER_CONFIG_MODE_LOOP = 0;
    public static final int PSMF_PLAYER_CONFIG_MODE_PIXEL_TYPE = 1;
    public static final int PSMF_PLAYER_LOOPING = 0;
    public static final int PSMF_PLAYER_NOT_LOOPING = 1;
    public static final int PSMF_PLAYER_PIXEL_TYPE_UNCHANGED = -1;
    public static final int PSMF_PLAYER_FILENAME_TYPE_HOST0 = 0;
    public static final int PSMF_PLAYER_FILENAME_TYPE_MS0 = 1;
    public static final int PSMF_PLAYER_FILENAME_TYPE_DISC0 = 2;
    public static final int PSMF_PLAYER_FILENAME_TYPE_HTTP = 3;
    public static final int PSMF_PLAYER_FILENAME_TYPE_MS0_ENCRYPTED = 4;
    public static final int PSMF_PLAYER_VERSION_FULL = 0;
    public static final int PSMF_PLAYER_VERSION_BASIC = 1;
    public static final int PSMF_PLAYER_VERSION_NET = 2;
    public static final int PSMF_PLAYER_MODE_PLAY = 0;
    public static final int PSMF_PLAYER_MODE_SLOWMOTION = 1;
    public static final int PSMF_PLAYER_MODE_STEPFRAME = 2;
    public static final int PSMF_PLAYER_MODE_PAUSE = 3;
    public static final int PSMF_PLAYER_MODE_FORWARD = 4;
    public static final int PSMF_PLAYER_MODE_REWIND = 5;
    public static final int PSMF_PLAYER_SPEED_SLOW = 1;
    public static final int PSMF_PLAYER_SPEED_NORMAL = 2;
    public static final int PSMF_PLAYER_SPEED_FAST = 3;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_PLAY_CONTINUE = 0;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_PAUSE_CONTINUE = 2;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_SLOWMOTION_CONTINUE = 3;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_FORWARD_CONTINUE = 7;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_REWIND_CONTINUE = 8;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_PLAY = 9;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_PAUSE = 10;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_FORWARD_SLOW = 11;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_FORWARD_NORMAL = 12;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_FORWARD_FAST = 13;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_REWIND_SLOW = 14;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_REWIND_NORMAL = 15;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_REWIND_FAST = 16;
    public static final int PSMF_PLAYER_ASC_READY_FLAG_SLOWMOTION = 17;
    public static final int PSMF_PLAYER_DECODE_STATUS_START = 1;
    public static final int PSMF_PLAYER_DECODE_STATUS_PLAY = 2;
    public static final int PSMF_PLAYER_DECODE_STATUS_FORWARD = 5;
    public static final int PSMF_PLAYER_DECODE_STATUS_REWIND = 6;
    public static final int PSMF_PLAYER_DECODE_STATUS_START_PLAY = 7;
    public static final int PSMF_PLAYER_DECODE_STATUS_END = 8;
    public static final int PSMF_PLAYER_DECODE_STATUS_EXIT = 9;
    public static final int PSMF_PLAYER_DECODE_STATUS_EXITED = 10;
    private int scePsmfPlayerMCThreadEntry;
    private int scePsmfPlayerOpenControlThreadEntry;
    private int scePsmfPlayerDecodeThreadEntry;
    private int scePsmfPlayerReadThreadEntry;
    private int scePsmfPlayerAbortThreadEntry;
    private int scePsmfPlayerRingbufferPutEntry;
    private int scePsmfPlayerMemoryPool;
    private int scePsmfPlayerMemoryPoolMaxAllocatedSize;
    private int scePsmfPlayerAbortThread;
    private int scePsmfPlayerAbortThreadEvf;
    private boolean abortOpen;

    @Override
    public int getMemoryUsage() {
        return 57956;
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePsmfPlayerMCThread(int args, TPointer argp) {
        TPointer psmfPlayer = argp.getPointer();
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer avSyncControlAddr = data.getPointer(32);
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        TPointer audioBufferAddr = avSyncControlAddr.getPointer(28);
        while (true) {
            RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitEventFlag(playerStatusAddr.getValue32(24), 1, 33, TPointer32.NULL, TPointer32.NULL));
            if (data.getValue32(20) == 1) {
                Modules.ThreadManForUserModule.sceKernelExitThread(0);
                return;
            }
            int decodeStatus = AtomicValue.get(decodeControlAddr.getPointer(72));
            if (decodeStatus != 8 || !(avSyncControlAddr.getValue32(20) == 1 ? videoBufferAddr.getValue32(16) == 0 && audioBufferAddr.getValue32(12) == 0 && this.getVblankSyncCount(avSyncControlAddr) == 0 : videoBufferAddr.getValue32(16) == 0 && this.getVblankSyncCount(avSyncControlAddr) == 0)) continue;
            int playMode = playerStatusAddr.getValue32(4);
            int loopingMode = playerStatusAddr.getValue32(12);
            if (this.getPlayerVersion(playerStatusAddr) == 2 || playMode != 5 && loopingMode == 1) {
                if (this.getPlayerStatus(playerStatusAddr) != 4) continue;
                this.setPlayerStatus(playerStatusAddr, 512);
                continue;
            }
            boolean newPlayMode = false;
            boolean newPlaySpeed = true;
            playerStatusAddr.setValue32(0, 0);
            playerStatusAddr.setValue32(4, 0);
            playerStatusAddr.setValue32(16, 1);
            int result = this.updatePlayModeAndSpeed(avSyncControlAddr, 0, 1, 0);
            if (result == 0) continue;
            this.setPlayerStatusError(playerStatusAddr);
        }
    }

    private int getFilenameType(TPointer readControlAddr) {
        TPointer openControlType = readControlAddr.getPointer(56);
        int type = openControlType.getValue32(0);
        return type;
    }

    private int initOpenControl(TPointer data, String filename) {
        int type;
        TPointer readControlAddr = data.getPointer(48);
        readControlAddr.setValue32(64, data.getValue32(68));
        TPointer openControlType = readControlAddr.getPointer(56);
        if (filename.startsWith("host0:")) {
            type = 0;
        } else if (filename.startsWith("ms0:")) {
            type = 1;
            if (filename.endsWith(".edat")) {
                type = 4;
            }
        } else if (filename.startsWith("http://") || filename.startsWith("https://")) {
            type = 3;
        } else if (filename.startsWith("disc0:")) {
            type = 2;
        } else {
            return -2141102077;
        }
        openControlType.setValue32(0, type);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                openControlType.setValue32(8, 1);
                break;
            }
            case 3: {
                log.error((Object)String.format("initOpenControl unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP '%s'", filename));
            }
        }
        return 0;
    }

    private int openPsmf(TPointer data, String filename) {
        int result = 0;
        this.abortOpen = false;
        TPointer readControlAddr = data.getPointer(48);
        TPointer openControlType = readControlAddr.getPointer(56);
        int type = this.getFilenameType(readControlAddr);
        switch (type) {
            case 0: 
            case 1: {
                result = RuntimeContext.hleSyscall(Modules.IoFileMgrForUserModule.sceIoOpen(new PspString(filename), 1, 0));
                openControlType.setValue32(4, result);
                break;
            }
            case 2: {
                result = RuntimeContext.hleSyscall(Modules.IoFileMgrForUserModule.sceIoOpen(new PspString(filename), 1, 0));
                openControlType.setValue32(4, result);
                break;
            }
            case 3: {
                log.error((Object)String.format("openPsmf unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP '%s'", filename));
                break;
            }
            case 4: {
                result = RuntimeContext.hleSyscall(Modules.IoFileMgrForUserModule.sceIoOpen(new PspString(filename), 1, 0));
                openControlType.setValue32(4, result);
                if (result < 0) break;
                result = Modules.scePspNpDrm_userModule.sceNpDrmEdataSetupKey(result);
            }
        }
        if (this.abortOpen) {
            // empty if block
        }
        return result;
    }

    private int seekPsmf(TPointer readControlAddr, int offset) {
        int result = 0;
        TPointer openControlType = readControlAddr.getPointer(56);
        int id = openControlType.getValue32(4);
        int type = this.getFilenameType(readControlAddr);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                result = RuntimeContext.hleSyscall((int)Modules.IoFileMgrForUserModule.sceIoLseek(id, (long)offset & 0xFFFFFFFFL, 0));
                break;
            }
            case 3: {
                log.error((Object)String.format("seekPsmf unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP", new Object[0]));
            }
        }
        return result;
    }

    private int closePsmf(TPointer readControlAddr) {
        int result = 0;
        TPointer openControlType = readControlAddr.getPointer(56);
        int id = openControlType.getValue32(4);
        int type = this.getFilenameType(readControlAddr);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                result = RuntimeContext.hleSyscall(Modules.IoFileMgrForUserModule.sceIoClose(id));
                break;
            }
            case 3: {
                log.error((Object)String.format("closePsmf unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP", new Object[0]));
            }
        }
        return result;
    }

    private int breakPsmf(TPointer readControlAddr) {
        int result = 0;
        int type = this.getFilenameType(readControlAddr);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(this.scePsmfPlayerAbortThreadEvf, 2));
                break;
            }
            case 3: {
                log.error((Object)String.format("breakPsmf unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP", new Object[0]));
            }
        }
        return result;
    }

    private int getFilesize(TPointer data) {
        int result = 0;
        TPointer filenameAddr = data.getPointer(0);
        TPointer readControlAddr = data.getPointer(48);
        int type = this.getFilenameType(readControlAddr);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                TPointer statAddr = Utilities.allocatePointer(88);
                result = RuntimeContext.hleSyscall(Modules.IoFileMgrForUserModule.sceIoGetstat(new PspString(filenameAddr.getAddress()), statAddr));
                if (result < 0) break;
                result = statAddr.getValue32(8);
                break;
            }
            case 3: {
                log.error((Object)String.format("getFilesize unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP", new Object[0]));
            }
        }
        return result;
    }

    private int readFile(TPointer data, TPointer buffer, int size) {
        int result = 0;
        TPointer readControlAddr = data.getPointer(48);
        TPointer openControlType = readControlAddr.getPointer(56);
        int id = openControlType.getValue32(4);
        int type = this.getFilenameType(readControlAddr);
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                result = RuntimeContext.hleSyscall(Modules.IoFileMgrForUserModule.sceIoRead(id, buffer, size));
                if (!log.isTraceEnabled()) break;
                try {
                    IoFileMgrForUser.IoInfo info = Modules.IoFileMgrForUserModule.getFileIoInfo(id);
                    if (info == null) break;
                    long fileSize = info.vFile != null ? info.vFile.length() : info.readOnlyFile.length();
                    log.trace((Object)String.format("readFile buffer=%s, size=0x%X, position=0x%X/0x%X, result=0x%X", buffer, size, info.position, fileSize, result));
                }
                catch (IOException iOException) {}
                break;
            }
            case 3: {
                log.error((Object)String.format("readFile unimplemented PSMF_PLAYER_FILENAME_TYPE_HTTP", new Object[0]));
            }
        }
        return result;
    }

    private int setPsmf(TPointer data) {
        int restHeaderSize;
        TPointer restHeaderBuffer;
        int result = this.getFilesize(data);
        if (result < 0) {
            return result;
        }
        int fileSize = result;
        TPointer psmfControlAddr = data.getPointer(28);
        TPointer controlBuffer = psmfControlAddr.getPointer(168);
        int controlBufferSize = psmfControlAddr.getValue32(172);
        int size = 2048;
        result = this.readFile(data, controlBuffer, 2048);
        if (result < 2048) {
            return -2141102067;
        }
        TPointer32 offsetAddr = Utilities.allocatePointer32(4);
        result = Modules.scePsmfModule.scePsmfQueryStreamOffset(controlBuffer, offsetAddr);
        if (result != 0) {
            return -2141102067;
        }
        int streamOffset = offsetAddr.getValue();
        if (fileSize != 0 && streamOffset > fileSize) {
            return -2141102071;
        }
        if (controlBufferSize < streamOffset) {
            return -2141102067;
        }
        if (streamOffset > 2048 && (result = this.readFile(data, restHeaderBuffer = new TPointer(controlBuffer, 2048), restHeaderSize = streamOffset - 2048)) < restHeaderSize) {
            return -2141102070;
        }
        result = Modules.scePsmfModule.scePsmfVerifyPsmf(controlBuffer);
        if (result != 0) {
            return result;
        }
        TPointer psmf = new TPointer(psmfControlAddr, 24);
        TPointer32 psmf32 = new TPointer32(psmf);
        result = Modules.scePsmfModule.scePsmfSetPsmf(psmf32, controlBuffer);
        if (result != 0) {
            return result;
        }
        psmfControlAddr.memcpy(80, psmf, 56);
        TPointer32 startTimeAddr = new TPointer32(psmfControlAddr, 4);
        result = Modules.scePsmfModule.scePsmfGetPresentationStartTime(psmf32, startTimeAddr);
        if (result != 0) {
            return result;
        }
        TPointer32 endTimeAddr = new TPointer32(psmfControlAddr, 8);
        result = Modules.scePsmfModule.scePsmfGetPresentationEndTime(psmf32, endTimeAddr);
        if (result != 0) {
            return result;
        }
        psmfControlAddr.setValue32(0, endTimeAddr.getValue() - startTimeAddr.getValue() - 3003);
        result = Modules.scePsmfModule.scePsmfGetNumberOfSpecificStreams(psmf32, 0);
        if (result < 0) {
            return result;
        }
        int numberOfAvcStreams = result;
        psmfControlAddr.setValue32(12, numberOfAvcStreams);
        result = Modules.scePsmfModule.scePsmfGetNumberOfSpecificStreams(psmf32, 1);
        if (result < 0) {
            return result;
        }
        int numberOfAtracStreams = result;
        psmfControlAddr.setValue32(16, numberOfAtracStreams);
        result = Modules.scePsmfModule.scePsmfGetNumberOfSpecificStreams(psmf32, 2);
        if (result < 0) {
            return result;
        }
        int numberOfPcmStreams = result;
        psmfControlAddr.setValue32(20, numberOfPcmStreams);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setPsmf numberOfAvcStreams=%d, numberOfAtracStreams=%d, numberOfPcmStreams=%d", numberOfAvcStreams, numberOfAtracStreams, numberOfPcmStreams));
        }
        TPointer readControlAddr = data.getPointer(48);
        readControlAddr.setValue32(32, streamOffset);
        TPointer32 streamSizeAddr = new TPointer32(readControlAddr, 20);
        result = Modules.scePsmfModule.scePsmfQueryStreamSize(controlBuffer, streamSizeAddr);
        if (result != 0) {
            return result;
        }
        readControlAddr.setValue32(28, streamSizeAddr.getValue());
        TPointer buffer = Utilities.allocatePointer(24);
        buffer.memcpy(psmfControlAddr, 24);
        TPointer psmfCopy = Utilities.allocatePointer(56);
        TPointer32 psmf32Copy = new TPointer32(psmfCopy);
        psmfCopy.memcpy(psmf, 56);
        int version = 0;
        for (int i = 0; i < numberOfAvcStreams; ++i) {
            result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamTypeNumber(psmf32Copy, 0, i);
            if (result != 0) {
                return result;
            }
            result = Modules.scePsmfModule.scePsmfCheckEPmap(psmf32Copy);
            if (result == -2141106139) {
                version = 1;
                break;
            }
            if (result == 0) continue;
            return result;
        }
        TPointer playerStatusAddr = data.getPointer(24);
        playerStatusAddr.setValue32(8, version);
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        result = this.registerStreams(psmf32Copy, avcDecodeAddr, 0, numberOfAvcStreams);
        if (result != 0) {
            return result;
        }
        TPointer atracDecodeAddr = decodeControlAddr.getPointer(28);
        result = this.registerStreams(psmf32Copy, atracDecodeAddr, 1, numberOfAtracStreams);
        if (result != 0) {
            return result;
        }
        TPointer pcmDecodeAddr = decodeControlAddr.getPointer(32);
        result = this.registerStreams(psmf32Copy, pcmDecodeAddr, 2, numberOfPcmStreams);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePsmfPlayerOpenControlThread(int args, TPointer argp) {
        TPointer strFileAddr;
        TPointer psmfPlayer = argp.getPointer();
        TPointer data = psmfPlayer.getPointer();
        int result = 0;
        TPointer filenameAddr = data.getPointer(0);
        String filename = filenameAddr.getStringNZ(512);
        result = this.initOpenControl(data, filename);
        if (result >= 0 && (result = this.openPsmf(data, filename)) >= 0) {
            TPointer readControlAddr = data.getPointer(48);
            result = this.seekPsmf(readControlAddr, readControlAddr.getValue32(64));
        }
        if (result >= 0) {
            result = this.setPsmf(data);
        }
        if ((strFileAddr = data.getPointer(52)).getValue32(0) == 3 && strFileAddr.getValue32(8) != 1) {
            TPointer playerStatusAddr = data.getPointer(24);
            playerStatusAddr.setValue32(8, 2);
        }
        Modules.ThreadManForUserModule.sceKernelExitThread(result);
    }

    private int getNumberFreeDisplayBuffers(TPointer videoBufferAddr) {
        int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
        int numberDisplayBuffers = videoBufferAddr.getValue32(20);
        return numberDisplayBuffers - numberUsedDisplayBuffers;
    }

    private int getNumberFreeAudioBuffers(TPointer audioBufferAddr) {
        int numberAudioBuffers = audioBufferAddr.getValue32(16);
        int numberUsedAudioBuffers = audioBufferAddr.getValue32(12);
        return numberAudioBuffers - numberUsedAudioBuffers;
    }

    private int addVideoBuffer(TPointer videoBufferAddr, TPointer buffer, int pts) {
        int vBufChangeFlag = AtomicValue.get(videoBufferAddr.getPointer(44));
        if ((vBufChangeFlag & 2) == 0) {
            int numberDisplayBuffers;
            int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
            if (numberUsedDisplayBuffers == (numberDisplayBuffers = videoBufferAddr.getValue32(20))) {
                return 1;
            }
            int displayBufferIndex = videoBufferAddr.getValue32(8);
            TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
            displayDataArrayAddr.add(displayBufferIndex * 8);
            displayDataArrayAddr.setPointer(0, buffer);
            displayDataArrayAddr.setValue32(4, pts);
            videoBufferAddr.setValue32(16, numberUsedDisplayBuffers + 1);
            videoBufferAddr.setValue32(8, (displayBufferIndex + 1) % numberDisplayBuffers);
        }
        return 0;
    }

    private int addAudioBuffer(TPointer audioBufferAddr, TPointer buffer, int pts) {
        int numberAudioBuffers;
        int numberUsedAudioBuffers = audioBufferAddr.getValue32(12);
        if (numberUsedAudioBuffers == (numberAudioBuffers = audioBufferAddr.getValue32(16))) {
            return 1;
        }
        int audioBufferIndex = audioBufferAddr.getValue32(4);
        TPointer audioDataAddr = audioBufferAddr.getPointer(0);
        audioDataAddr.add(audioBufferIndex * 8);
        audioDataAddr.setPointer(0, buffer);
        audioDataAddr.setValue32(4, pts);
        audioBufferAddr.setValue32(12, numberUsedAudioBuffers + 1);
        audioBufferAddr.setValue32(4, (audioBufferIndex + 1) % numberAudioBuffers);
        return 0;
    }

    private int avcDecodeStop(TPointer decodeControlAddr, boolean isRewind) {
        TPointer videoBufferAddr = decodeControlAddr.getPointer(48);
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        if (this.getNumberFreeDisplayBuffers(videoBufferAddr) == 0) {
            return 1;
        }
        TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
        int displayBufferIndex = videoBufferAddr.getValue32(8);
        TPointer buffer = displayDataArrayAddr.getPointer(displayBufferIndex * 8);
        TPointer mpeg = avcDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        TPointer32 bufferAddr = Utilities.allocatePointer32(8);
        TPointer32 gotFrameAddr = Utilities.allocatePointer32(4);
        bufferAddr.setPointer(0, buffer);
        bufferAddr.setPointer(4, TPointer.NULL);
        int result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegAvcDecodeStopYCbCr(mpeg32, bufferAddr, gotFrameAddr));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("avcDecodeStop: sceMpegAvcDecodeStopYCbCr returned 0x%X", result));
        }
        if (result != 0) {
            return result;
        }
        if (gotFrameAddr.getValue() == 1) {
            TPointer ptsBufferAddr = avcDecodeAddr.getPointer(1104);
            int ptsBufferIndex = avcDecodeAddr.getValue32(1112);
            int numberPtsBuffers = avcDecodeAddr.getValue32(1120);
            int pts = ptsBufferAddr.getValue32(ptsBufferIndex * 4);
            avcDecodeAddr.setValue32(1112, (ptsBufferIndex + 1) % numberPtsBuffers);
            int timestamp = decodeControlAddr.getValue32(60);
            if (pts >= timestamp || isRewind) {
                this.addVideoBuffer(videoBufferAddr, buffer, pts);
            }
        }
        return 0;
    }

    private int avcDecode(TPointer decodeControlAddr, boolean isRewind) {
        int result;
        TPointer videoBufferAddr = decodeControlAddr.getPointer(48);
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        if (this.getNumberFreeDisplayBuffers(videoBufferAddr) == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("avcDecode numberFreeDisplayBuffers==0", new Object[0]));
            }
            return 1;
        }
        TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
        int displayBufferIndex = videoBufferAddr.getValue32(8);
        TPointer buffer = displayDataArrayAddr.getPointer(displayBufferIndex * 8);
        TPointer mpeg = avcDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        int numberRegisteredAvcStreams = avcDecodeAddr.getValue32(8);
        boolean needToDecode = false;
        int avcStreamMode0 = avcDecodeAddr.getValue32(4);
        for (int i = 0; i < numberRegisteredAvcStreams; ++i) {
            TPointer streamAddr = avcDecodeAddr.getPointer(12 + i * 4);
            TPointer auAddr = new TPointer(avcDecodeAddr, 76 + i * 64);
            result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegGetAvcAu(mpeg32, streamAddr, auAddr, TPointer32.NULL));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("avcDecode: sceMpegGetAvcAu(stream#%d) returned 0x%X, au.esSize=0x%X", i, result, auAddr.getValue32(20)));
            }
            if (result != 0 && result != -2141093887) {
                return result;
            }
            if (result != 0 || i != avcStreamMode0) continue;
            needToDecode = true;
        }
        if (!needToDecode) {
            return -2141093887;
        }
        TPointer auAddr = new TPointer(avcDecodeAddr, 76 + avcStreamMode0 * 64);
        TPointer32 bufferAddr = Utilities.allocatePointer32(8);
        TPointer32 gotFrameAddr = Utilities.allocatePointer32(4);
        bufferAddr.setPointer(0, buffer);
        bufferAddr.setPointer(4, TPointer.NULL);
        result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegAvcDecodeYCbCr(mpeg32, auAddr, bufferAddr, gotFrameAddr));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("avcDecode: sceMpegAvcDecodeYCbCr(stream#%d) returned 0x%X", avcStreamMode0, result));
        }
        if (result != 0) {
            return result;
        }
        int pts = auAddr.getValue32(4);
        if (pts == -1) {
            pts = avcDecodeAddr.getValue32(1124) + 3003;
        }
        avcDecodeAddr.setValue32(1124, pts);
        TPointer ptsBufferAddr = avcDecodeAddr.getPointer(1104);
        ptsBufferAddr.setValue32(avcDecodeAddr.getValue32(1108) * 4, pts);
        avcDecodeAddr.setValue32(1108, (avcDecodeAddr.getValue32(1108) + 1) % avcDecodeAddr.getValue32(1120));
        avcDecodeAddr.setValue32(1116, avcDecodeAddr.getValue32(1116) + 1);
        if (gotFrameAddr.getValue() == 1) {
            int ptsBufferIndex = avcDecodeAddr.getValue32(1112);
            int numberPtsBuffers = avcDecodeAddr.getValue32(1120);
            int decodePts = ptsBufferAddr.getValue32(ptsBufferIndex * 4);
            avcDecodeAddr.setValue32(1112, (ptsBufferIndex + 1) % numberPtsBuffers);
            avcDecodeAddr.setValue32(1116, avcDecodeAddr.getValue32(1116) - 1);
            int timestamp = decodeControlAddr.getValue32(60);
            if (pts >= timestamp || isRewind) {
                this.addVideoBuffer(videoBufferAddr, buffer, decodePts);
            }
        }
        return 0;
    }

    private int atracDecode(TPointer atracDecodeAddr, TPointer buffer, TPointer32 ptsAddr) {
        int result;
        TPointer mpeg = atracDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        int numberRegisteredAtracStreams = atracDecodeAddr.getValue32(8);
        boolean needToDecode = false;
        int atracStreamMode0 = atracDecodeAddr.getValue32(4);
        for (int i = 0; i < numberRegisteredAtracStreams; ++i) {
            TPointer streamAddr = atracDecodeAddr.getPointer(12 + i * 4);
            TPointer auAddr = new TPointer(atracDecodeAddr, 76 + i * 64);
            result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegGetAtracAu(mpeg32, streamAddr, auAddr, TPointer32.NULL));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("atracDecode: sceMpegGetAtracAu returned 0x%X", result));
            }
            if (result != 0 && result != -2141093887) {
                return result;
            }
            if (result != 0 || i != atracStreamMode0) continue;
            needToDecode = true;
        }
        if (!needToDecode) {
            return -2141093887;
        }
        TPointer auAddr = new TPointer(atracDecodeAddr, 76 + atracStreamMode0 * 64);
        int status = atracDecodeAddr.getValue32(1112);
        int init = status == 1 || status == 3 ? 1 : 0;
        result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegAtracDecode(mpeg32, auAddr, buffer, init));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("atracDecode: sceMpegAtracDecode returned 0x%X", result));
        }
        if (result != 0) {
            return result;
        }
        int pts = auAddr.getValue32(4);
        if (pts == -1) {
            pts = atracDecodeAddr.getValue32(1116) + 4180;
        }
        atracDecodeAddr.setValue32(1116, pts);
        ptsAddr.setValue(pts);
        if (init != 0) {
            int atracOutputSize = atracDecodeAddr.getValue32(1108);
            buffer.clear(atracOutputSize);
        }
        status = 2;
        atracDecodeAddr.setValue32(1112, status);
        return 1;
    }

    private int addPcmData(TPointer pcmDecodeAddr, TPointer esBuffer, int esSize, int numberSamples, int pts) {
        if (pcmDecodeAddr.getValue32(1136) - pcmDecodeAddr.getValue32(1132) < numberSamples) {
            return -1;
        }
        TPointer pcmPoolAddr = pcmDecodeAddr.getPointer(1116);
        int pcmDataIndex = pcmDecodeAddr.getValue32(1124);
        pcmPoolAddr.add(pcmDataIndex * 4);
        pcmPoolAddr.memcpy(esBuffer, esSize);
        if (pts == -1) {
            pts = pcmDecodeAddr.getValue32(1108) + 163;
        }
        TPointer pcmPtsAddr = pcmDecodeAddr.getPointer(1120);
        pcmPtsAddr.setValue32(pcmDecodeAddr.getValue32(1124) / 80 * 4, pts);
        pcmDecodeAddr.setValue32(1108, pts);
        pcmDecodeAddr.setValue32(1124, (pcmDecodeAddr.getValue32(1124) + numberSamples) % pcmDecodeAddr.getValue32(1136));
        pcmDecodeAddr.setValue32(1132, pcmDecodeAddr.getValue32(1132) + numberSamples);
        return 0;
    }

    private int pcmDecode(TPointer pcmDecodeAddr, TPointer buffer, TPointer32 ptsAddr) {
        int pts;
        TPointer mpeg = pcmDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        int numberRegisteredPcmStreams = pcmDecodeAddr.getValue32(8);
        boolean dataFound = false;
        int pcmStreamMode0 = pcmDecodeAddr.getValue32(4);
        block0: for (int i = 0; i < numberRegisteredPcmStreams; ++i) {
            TPointer streamAddr = pcmDecodeAddr.getPointer(12 + i * 4);
            TPointer auAddr = new TPointer(pcmDecodeAddr, 76 + i * 64);
            for (int j = 0; j < 30 && pcmDecodeAddr.getValue32(1136) - pcmDecodeAddr.getValue32(1132) >= 80; ++j) {
                int result = Modules.sceMpegModule.sceMpegGetPcmAu(mpeg32, streamAddr, auAddr, TPointer32.NULL);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("pcmDecode: sceMpegGetPcmAu returned 0x%X", result));
                }
                if (result != 0 && result != -2141093887) {
                    return result;
                }
                if (result == 0 && i == pcmStreamMode0) {
                    pts = auAddr.getValue32(4);
                    TPointer esBuffer = auAddr.getPointer(16);
                    int esSize = auAddr.getValue32(20);
                    this.addPcmData(pcmDecodeAddr, esBuffer, esSize, 80, pts);
                    dataFound = true;
                    continue;
                }
                if (result == -2141093887) continue block0;
            }
        }
        int numberSamples = 2048;
        if (pcmDecodeAddr.getValue32(1132) < 2048) {
            return dataFound ? -2141093887 : 0;
        }
        TPointer pcmPoolAddr = pcmDecodeAddr.getPointer(1116);
        int pcmDataIndex = pcmDecodeAddr.getValue32(1128);
        pcmPoolAddr.add(pcmDataIndex * 4);
        buffer.memcpy(pcmPoolAddr, 8192);
        TPointer pcmPtsAddr = pcmDecodeAddr.getPointer(1120);
        pts = pcmPtsAddr.getValue32(pcmDataIndex / 80 * 4);
        ptsAddr.setValue(pts);
        pcmDecodeAddr.setValue32(1128, (pcmDataIndex + 2048) % pcmDecodeAddr.getValue32(1136));
        pcmDecodeAddr.setValue32(1132, pcmDecodeAddr.getValue32(1132) - 2048);
        pcmDecodeAddr.setValue32(1112, pts);
        return 1;
    }

    private int audioDecode(TPointer decodeControlAddr) {
        TPointer32 ptsAddr;
        int audioBufferIndex;
        TPointer audioBufferAddr = decodeControlAddr.getPointer(52);
        TPointer atracDecodeAddr = decodeControlAddr.getPointer(28);
        TPointer pcmDecodeAddr = decodeControlAddr.getPointer(32);
        if (this.getNumberFreeAudioBuffers(audioBufferAddr) == 0) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("audioDecode numberFreeAudioBuffers==0", new Object[0]));
            }
            return 1;
        }
        TPointer audioDataAddr = audioBufferAddr.getPointer(0);
        TPointer buffer = audioDataAddr.getPointer((audioBufferIndex = audioBufferAddr.getValue32(4)) * 8);
        int atracResult = this.atracDecode(atracDecodeAddr, buffer, ptsAddr = Utilities.allocatePointer32(4));
        if (atracResult == 1) {
            int timestamp = decodeControlAddr.getValue32(60);
            int pts = ptsAddr.getValue();
            if (pts < timestamp - 4180) {
                return 0;
            }
            this.addAudioBuffer(audioBufferAddr, buffer, pts);
        } else if (atracResult != 0 && atracResult != -2141093887) {
            int status = 1;
            atracDecodeAddr.setValue32(1112, status);
        }
        int pcmResult = this.pcmDecode(pcmDecodeAddr, buffer, ptsAddr);
        if (pcmResult != 1) {
            return pcmResult == 0 && atracResult != 0 ? atracResult : pcmResult;
        }
        int timestamp = decodeControlAddr.getValue32(60);
        int pts = ptsAddr.getValue();
        if (pts < timestamp - 4180) {
            return 0;
        }
        this.addAudioBuffer(audioBufferAddr, buffer, pts);
        return 0;
    }

    private void executeDecodeStatusPlay(TPointer decodeControlAddr) {
        TPointer playerStatusAddr = decodeControlAddr.getPointer(36);
        TPointer readControlAddr = decodeControlAddr.getPointer(44);
        if (!this.isPlayerStatusOK(playerStatusAddr)) {
            AtomicValue.set(decodeControlAddr.getPointer(72), 8);
        } else {
            int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeDecodeStatusPlay readStatus=0x%X", readStatus));
            }
            if (readStatus == 16 || readStatus == 8 || readStatus == 2) {
                int result;
                if (readStatus == 2) {
                    int ringbufferNumPackets;
                    TPointer ringbufferAddr = readControlAddr.getPointer(48);
                    int ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("executeDecodeStatusPlay: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
                    }
                    if (ringbufferAvailableSize == (ringbufferNumPackets = readControlAddr.getValue32(52))) {
                        int result2 = this.avcDecodeStop(decodeControlAddr, false);
                        if (result2 == 0) {
                            AtomicValue.set(decodeControlAddr.getPointer(72), 8);
                        }
                        return;
                    }
                }
                if ((result = this.audioDecode(decodeControlAddr)) < 0 && result != -2141093887) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                    return;
                }
                int value1 = result;
                result = this.avcDecode(decodeControlAddr, false);
                if (result < 0 && result != -2141093887) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                    return;
                }
                int value2 = result;
                readStatus = AtomicValue.get(readControlAddr.getPointer(4));
                if ((value1 == 0 || value2 == 0) && readStatus == 8) {
                    this.setReadStatus(readControlAddr, 16);
                }
                if (readStatus == 2 && value1 == -2141093887 && value2 == -2141093887) {
                    AtomicValue.set(decodeControlAddr.getPointer(72), 8);
                }
            }
        }
    }

    private void executeDecodeStatusStartPlay(TPointer decodeControlAddr) {
        TPointer playerStatusAddr = decodeControlAddr.getPointer(36);
        TPointer readControlAddr = decodeControlAddr.getPointer(44);
        if (!this.isPlayerStatusOK(playerStatusAddr)) {
            AtomicValue.set(decodeControlAddr.getPointer(72), 8);
        } else {
            int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
            TPointer ringbufferAddr = readControlAddr.getPointer(48);
            int ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeDecodeStatusStartPlay: readStatus=0x%X, sceMpegRingbufferAvailableSize returned 0x%X", readStatus, ringbufferAvailableSize));
            }
            if (readStatus == 2 || ringbufferAvailableSize < 32) {
                int result = this.initAus(decodeControlAddr);
                if (result != 0) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                } else {
                    AtomicValue.set(decodeControlAddr.getPointer(72), 2);
                }
            }
        }
    }

    private void executeDecodeStatusForward(TPointer decodeControlAddr) {
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        TPointer playerStatusAddr = decodeControlAddr.getPointer(36);
        TPointer readControlAddr = decodeControlAddr.getPointer(44);
        TPointer videoBufferAddr = decodeControlAddr.getPointer(48);
        TPointer psmfControlAddr = decodeControlAddr.getPointer(40);
        TPointer psmf = new TPointer(psmfControlAddr, 24);
        TPointer32 psmf32 = new TPointer32(psmf);
        if (!this.isPlayerStatusOK(playerStatusAddr)) {
            AtomicValue.set(decodeControlAddr.getPointer(72), 8);
        } else {
            int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
            if ((readStatus == 2 || readStatus == 4) && this.getNumberFreeDisplayBuffers(videoBufferAddr) >= 2) {
                int result = this.avcDecode(decodeControlAddr, false);
                if (result < 0 && result != -2141093887) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                    return;
                }
                result = this.avcDecodeStop(decodeControlAddr, false);
                if (result != 0) {
                    return;
                }
                int videoCodec = decodeControlAddr.getValue32(8);
                if (videoCodec != 0 && videoCodec != 14) {
                    this.setPlayerStatusError(playerStatusAddr, -2141102069);
                    return;
                }
                int currentPts = avcDecodeAddr.getValue32(1124);
                int epId = result = Modules.scePsmfModule.scePsmfGetEPidWithTimestamp(psmf32, currentPts);
                if (result == -2141104896) {
                    epId = 0;
                } else if (result < 0) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                    return;
                }
                int playSpeed = decodeControlAddr.getValue32(64);
                TPointer32 outAddr = Utilities.allocatePointer32(16);
                result = Modules.scePsmfModule.scePsmfGetEPWithId(psmf32, epId += playSpeed, outAddr);
                if (result == -2141104896) {
                    AtomicValue.set(decodeControlAddr.getPointer(72), 8);
                } else {
                    if (result != 0) {
                        this.setPlayerStatusError(playerStatusAddr, result);
                        return;
                    }
                    int entryOffset = outAddr.getValue(4);
                    int entryPicOffset = outAddr.getValue(12);
                    readControlAddr.setValue32(36, entryOffset);
                    readControlAddr.setValue32(40, Math.max(entryPicOffset, 65536));
                    this.setReadStatus(readControlAddr, 64);
                }
            }
        }
    }

    private void executeDecodeStatusRewind(TPointer decodeControlAddr) {
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        TPointer playerStatusAddr = decodeControlAddr.getPointer(36);
        TPointer readControlAddr = decodeControlAddr.getPointer(44);
        TPointer videoBufferAddr = decodeControlAddr.getPointer(48);
        TPointer psmfControlAddr = decodeControlAddr.getPointer(40);
        TPointer psmf = new TPointer(psmfControlAddr, 24);
        TPointer32 psmf32 = new TPointer32(psmf);
        if (!this.isPlayerStatusOK(playerStatusAddr)) {
            AtomicValue.set(decodeControlAddr.getPointer(72), 8);
        } else {
            int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
            if ((readStatus == 2 || readStatus == 4) && this.getNumberFreeDisplayBuffers(videoBufferAddr) >= 2) {
                int result = this.avcDecode(decodeControlAddr, true);
                if (result < 0 && result != -2141093887) {
                    AtomicValue.set(decodeControlAddr.getPointer(72), 7);
                    return;
                }
                result = this.avcDecodeStop(decodeControlAddr, true);
                if (result != 0) {
                    return;
                }
                int videoCodec = decodeControlAddr.getValue32(8);
                if (videoCodec != 0 && videoCodec != 14) {
                    this.setPlayerStatusError(playerStatusAddr, -2141102069);
                    return;
                }
                int currentPts = avcDecodeAddr.getValue32(1124);
                int epId = result = Modules.scePsmfModule.scePsmfGetEPidWithTimestamp(psmf32, currentPts);
                if (result == -2141104896) {
                    epId = 0;
                } else if (result < 0) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                    return;
                }
                int playSpeed = decodeControlAddr.getValue32(64);
                if ((epId -= playSpeed) <= 0) {
                    AtomicValue.set(decodeControlAddr.getPointer(72), 8);
                } else {
                    TPointer32 outAddr = Utilities.allocatePointer32(16);
                    result = Modules.scePsmfModule.scePsmfGetEPWithId(psmf32, epId, outAddr);
                    if (result != 0) {
                        this.setPlayerStatusError(playerStatusAddr, result);
                        return;
                    }
                    int entryOffset = outAddr.getValue(4);
                    int entryPicOffset = outAddr.getValue(12);
                    readControlAddr.setValue32(36, entryOffset);
                    readControlAddr.setValue32(40, Math.max(entryPicOffset, 65536));
                    this.setReadStatus(readControlAddr, 64);
                }
            }
        }
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePsmfPlayerDecodeThread(int args, TPointer argp) {
        TPointer decodeControlAddr = argp.getPointer();
        TPointer playerStatusAddr = decodeControlAddr.getPointer(36);
        boolean exit = false;
        while (!exit) {
            RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitEventFlag(playerStatusAddr.getValue32(24), 4, 33, TPointer32.NULL, TPointer32.NULL));
            int decodeStatus = AtomicValue.get(decodeControlAddr.getPointer(72));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("hlePsmfPlayerDecodeThread decodeStatus=%d", decodeStatus));
            }
            switch (decodeStatus) {
                case 2: {
                    this.executeDecodeStatusPlay(decodeControlAddr);
                    break;
                }
                case 5: {
                    this.executeDecodeStatusForward(decodeControlAddr);
                    break;
                }
                case 6: {
                    this.executeDecodeStatusRewind(decodeControlAddr);
                    break;
                }
                case 7: {
                    this.executeDecodeStatusStartPlay(decodeControlAddr);
                    break;
                }
                case 9: {
                    exit = true;
                }
            }
        }
        AtomicValue.set(decodeControlAddr.getPointer(72), 10);
        Modules.ThreadManForUserModule.sceKernelExitThread(0);
    }

    private void executeRead0x10(TPointer readControlAddr) {
        TPointer playerStatusAddr = readControlAddr.getPointer(16);
        int streamSize = readControlAddr.getValue32(20);
        int streamSizePut = readControlAddr.getValue32(24);
        if (!this.isPlayerStatusOK(playerStatusAddr) || readControlAddr.getValue32(28) != 0 && streamSize == streamSizePut) {
            this.setReadStatus(readControlAddr, 2);
        } else {
            TPointer ringbufferAddr = readControlAddr.getPointer(48);
            int ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeRead0x10: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
            }
            if (ringbufferAvailableSize < 32) {
                this.setReadStatus(readControlAddr, 8);
            } else {
                int numPackets = Math.min(streamSize - streamSizePut >> 11, 32);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("executeRead0x10: calling sceMpegRingbufferPut numPackets=0x%X, availableSize=0x%X", numPackets, ringbufferAvailableSize));
                }
                int result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegRingbufferPut(ringbufferAddr, numPackets, ringbufferAvailableSize));
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("executeRead0x10: sceMpegRingbufferPut returned 0x%X", result));
                }
                if (result == 0) {
                    this.setReadStatus(readControlAddr, 2);
                } else if (result < 0) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                } else {
                    int numPacketsPut = result;
                    readControlAddr.setValue32(24, streamSizePut += numPacketsPut << 11);
                    if (streamSizePut >= streamSize) {
                        this.setReadStatus(readControlAddr, 2);
                    }
                }
            }
        }
    }

    private void executeRead0x80(TPointer readControlAddr) {
        TPointer playerStatusAddr = readControlAddr.getPointer(16);
        int streamSize = readControlAddr.getValue32(20);
        int streamSizePut = readControlAddr.getValue32(24);
        if (!this.isPlayerStatusOK(playerStatusAddr) || readControlAddr.getValue32(28) != 0 && streamSize == streamSizePut) {
            this.setReadStatus(readControlAddr, 2);
        } else {
            TPointer ringbufferAddr = readControlAddr.getPointer(48);
            int ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeRead0x80: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
            }
            int numPackets = ringbufferAvailableSize << 11 < readControlAddr.getValue32(40) ? 32 : readControlAddr.getValue32(40) >>> 11;
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeRead0x80: calling sceMpegRingbufferPut numPackets=0x%X, availableSize=0x%X", numPackets, ringbufferAvailableSize));
            }
            int result = RuntimeContext.hleSyscall(Modules.sceMpegModule.sceMpegRingbufferPut(ringbufferAddr, numPackets, ringbufferAvailableSize));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeRead0x80: sceMpegRingbufferPut returned 0x%X", result));
            }
            if (result == 0) {
                this.setReadStatus(readControlAddr, 2);
            } else if (result < 0) {
                this.setReadStatus(readControlAddr, 4);
                this.setPlayerStatusError(playerStatusAddr, result);
            } else {
                int numPacketsPut = result;
                readControlAddr.setValue32(24, streamSizePut += numPacketsPut << 11);
                if (streamSizePut >= readControlAddr.getValue32(40)) {
                    this.setReadStatus(readControlAddr, 4);
                }
            }
        }
    }

    private int executeSeek(TPointer readControlAddr, int offset, int valueUsedOnlyForHttp) {
        int psmfOffset = readControlAddr.getValue32(64);
        int streamOffset = readControlAddr.getValue32(32);
        int streamSize = readControlAddr.getValue32(28);
        readControlAddr.setValue32(20, streamSize - offset);
        int result = this.seekPsmf(readControlAddr, psmfOffset + streamOffset + offset);
        if (result < 0) {
            return result;
        }
        return 0;
    }

    private void executeSeek0x40(TPointer readControlAddr) {
        TPointer playerStatusAddr = readControlAddr.getPointer(16);
        if (!this.isPlayerStatusOK(playerStatusAddr)) {
            this.setReadStatus(readControlAddr, 2);
        } else {
            TPointer mpeg = readControlAddr.getPointer(44);
            TPointer32 mpeg32 = new TPointer32(mpeg);
            int result = Modules.sceMpegModule.sceMpegFlushAllStream(mpeg32);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeSeek0x40: sceMpegFlushAllStream returned 0x%X", result));
            }
            if (result != 0) {
                this.setPlayerStatusError(playerStatusAddr, result);
            } else {
                result = this.executeSeek(readControlAddr, readControlAddr.getValue32(36), readControlAddr.getValue32(40));
                if (result != 0) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                } else {
                    readControlAddr.setValue32(24, 0);
                    this.setReadStatus(readControlAddr, 128);
                }
            }
        }
    }

    private void executeSeek0x20(TPointer readControlAddr) {
        TPointer playerStatusAddr = readControlAddr.getPointer(16);
        if (!this.isPlayerStatusOK(playerStatusAddr)) {
            this.setReadStatus(readControlAddr, 2);
        } else {
            TPointer mpeg = readControlAddr.getPointer(44);
            TPointer32 mpeg32 = new TPointer32(mpeg);
            int result = Modules.sceMpegModule.sceMpegFlushAllStream(mpeg32);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("executeSeek0x20: sceMpegFlushAllStream returned 0x%X", result));
            }
            if (result != 0) {
                this.setPlayerStatusError(playerStatusAddr, result);
            } else if (this.getPlayerVersion(playerStatusAddr) == 2) {
                readControlAddr.setValue32(24, 0);
                this.setReadStatus(readControlAddr, 16);
            } else {
                result = this.executeSeek(readControlAddr, readControlAddr.getValue32(36), 0);
                if (result != 0) {
                    this.setPlayerStatusError(playerStatusAddr, result);
                } else {
                    readControlAddr.setValue32(24, 0);
                    this.setReadStatus(readControlAddr, 16);
                }
            }
        }
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePsmfPlayerReadThread(int args, TPointer argp) {
        TPointer readControlAddr = argp.getPointer();
        while (true) {
            RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitEventFlag(readControlAddr.getValue32(0), 1008, 1, TPointer32.NULL, TPointer32.NULL));
            int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("hlePsmfPlayerReadThread readStatus=0x%X", readStatus));
            }
            if (readStatus == 16) {
                this.executeRead0x10(readControlAddr);
                continue;
            }
            if (readStatus == 64) {
                this.executeSeek0x40(readControlAddr);
                continue;
            }
            if (readStatus == 32) {
                this.executeSeek0x20(readControlAddr);
                continue;
            }
            if (readStatus == 128) {
                this.executeRead0x80(readControlAddr);
                continue;
            }
            if (readStatus == 256) break;
        }
        this.setReadStatus(readControlAddr, 512);
        Modules.ThreadManForUserModule.sceKernelExitThread(0);
    }

    @HLEFunction(nid=-1, version=150)
    public void hlePsmfPlayerAbortThread() {
        int abortAction;
        TPointer32 outBitsAddr;
        int result;
        while ((result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitEventFlag(this.scePsmfPlayerAbortThreadEvf, 7, 33, outBitsAddr = Utilities.allocatePointer32(4), TPointer32.NULL))) >= 0 && ((abortAction = outBitsAddr.getValue()) & 4) == 0) {
            if ((abortAction & 1) != 0) {
                this.abortOpen = true;
            }
            if ((abortAction & 2) == 0) continue;
        }
        Modules.ThreadManForUserModule.sceKernelExitThread(0);
    }

    @HLEFunction(nid=-1, version=150)
    public int hlePsmfPlayerRingbufferPutCallback(TPointer dataAddress, int numPackets, TPointer32 psmfPlayer) {
        int totalPacketsRead;
        TPointer data = psmfPlayer.getPointer();
        TPointer readBuffer = data.getPointer(64);
        if (readBuffer.isNull()) {
            int result = this.readFile(data, dataAddress, numPackets << 11);
            if (result < 0) {
                return result;
            }
            if ((result & 0x7FF) != 0) {
                return -1;
            }
            totalPacketsRead = result >> 11;
        } else {
            totalPacketsRead = 0;
            int dataAddressOffset = 0;
            while (numPackets > 0) {
                int readNumPackets = Math.min(numPackets, 32);
                int result = this.readFile(data, readBuffer, readNumPackets << 11);
                if (result < 0) {
                    return result;
                }
                if ((result & 0x7FF) != 0) {
                    return -1;
                }
                int readLength = result;
                totalPacketsRead += readLength >> 11;
                dataAddress.memcpy(dataAddressOffset, readBuffer, readLength);
                dataAddressOffset += readLength;
                numPackets -= readNumPackets;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hlePsmfPlayerRingbufferPutCallback returning 0x%X packets: %s", totalPacketsRead, Utilities.getMemoryDump(dataAddress, totalPacketsRead << 11)));
        }
        return totalPacketsRead;
    }

    public int getPlayerStatus(TPointer playerStatusAddr) {
        return playerStatusAddr.getValue32(20);
    }

    public int getPlayerVersion(TPointer playerStatusAddr) {
        return playerStatusAddr.getValue32(8);
    }

    public void setPlayerStatus(TPointer playerStatusAddr, int status) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setPlayerStatus status=0x%X", status));
        }
        playerStatusAddr.setValue32(20, status);
    }

    public void setPlayerStatusError(TPointer playerStatusAddr) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setPlayerStatusError", new Object[0]));
        }
        this.setPlayerStatus(playerStatusAddr, 256);
    }

    public void setPlayerStatusError(TPointer playerStatusAddr, int errorCode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setPlayerStatusError errorCode=0x%X", errorCode));
        }
        this.setPlayerStatus(playerStatusAddr, 256);
        playerStatusAddr.setValue32(0, errorCode);
    }

    public boolean isPlayerStatusOK(TPointer playerStatusAddr) {
        return (this.getPlayerStatus(playerStatusAddr) & 0x100) == 0;
    }

    private void setReadStatus(TPointer readControlAddr, int readStatus) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("setReadStatus readStatus=0x%X", readStatus));
        }
        AtomicValue.set(readControlAddr.getPointer(4), readStatus);
        int eventFlag = readControlAddr.getValue32(0);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelClearEventFlag(eventFlag, 0));
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(eventFlag, readStatus));
    }

    private int getVblankSyncCount(TPointer avSyncControlAddr) {
        return avSyncControlAddr.getValue32(48);
    }

    private void setVblankSyncCount(TPointer avSyncControlAddr, int value) {
        avSyncControlAddr.setValue32(48, value);
    }

    private void clearVblankSyncCount(TPointer avSyncControlAddr) {
        this.setVblankSyncCount(avSyncControlAddr, 0);
    }

    private int getVblankSyncInterval(TPointer avSyncControlAddr) {
        return avSyncControlAddr.getValue32(52);
    }

    private void setVblankSyncInterval(TPointer avSyncControlAddr, int value) {
        avSyncControlAddr.setValue32(52, value);
    }

    public TPointer32 checkPlayerInitialized0(TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        if (data.isNull()) {
            throw new SceKernelErrorException(-2141102079);
        }
        TPointer playerStatusAddr = data.getPointer(24);
        if (playerStatusAddr.isNull()) {
            throw new SceKernelErrorException(-2141102079);
        }
        return psmfPlayer;
    }

    public TPointer32 checkPlayerInitialized(TPointer32 psmfPlayer) {
        TPointer data = (psmfPlayer = this.checkPlayerInitialized0(psmfPlayer)).getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        if (this.getPlayerStatus(playerStatusAddr) == 0) {
            throw new SceKernelErrorException(-2141102079);
        }
        return psmfPlayer;
    }

    public TPointer32 checkPlayerStandby(TPointer32 psmfPlayer) {
        TPointer data = (psmfPlayer = this.checkPlayerInitialized0(psmfPlayer)).getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        if (this.getPlayerStatus(playerStatusAddr) < 2) {
            throw new SceKernelErrorException(-2141102079);
        }
        return psmfPlayer;
    }

    public TPointer32 checkPlayerPlaying(TPointer32 psmfPlayer) {
        TPointer data = (psmfPlayer = this.checkPlayerInitialized0(psmfPlayer)).getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        if (playerStatus != 4 && playerStatus != 512 && playerStatus != 256) {
            throw new SceKernelErrorException(-2141102079);
        }
        return psmfPlayer;
    }

    private TPointer allocate(int size) {
        int freeSize;
        int poolSize;
        int allocatedSize;
        TPointer32 dataAddr = Utilities.allocatePointer32(4);
        int result = Modules.ThreadManForUserModule.sceKernelTryAllocateVpl(this.scePsmfPlayerMemoryPool, size, dataAddr);
        if (result < 0) {
            return null;
        }
        int addr = dataAddr.getValue();
        TPointer infoAddr = Utilities.allocatePointer(52);
        infoAddr.setValue32(0, 52);
        result = Modules.ThreadManForUserModule.sceKernelReferVplStatus(this.scePsmfPlayerMemoryPool, infoAddr);
        if (result == 0 && (allocatedSize = (poolSize = infoAddr.getValue32(40)) - (freeSize = infoAddr.getValue32(44))) > this.scePsmfPlayerMemoryPoolMaxAllocatedSize) {
            this.scePsmfPlayerMemoryPoolMaxAllocatedSize = allocatedSize;
        }
        return new TPointer(this.getMemory(), addr);
    }

    private void free(TPointer pointer) {
        Modules.ThreadManForUserModule.sceKernelFreeVpl(this.scePsmfPlayerMemoryPool, pointer);
    }

    private TPointer allocateAtomicValue() {
        TPointer atomicValue = this.allocate(8);
        atomicValue.clear(8);
        TPointer lwMutex = this.allocate(32);
        atomicValue.setPointer(0, lwMutex);
        int result = Modules.ThreadManForUserModule.sceKernelCreateLwMutex(lwMutex, "_ScePsmfPlayerStatusLwMutex", 0, 0, TPointer.NULL);
        if (result < 0) {
            this.free(lwMutex);
            atomicValue.setValue32(0, 0);
        }
        return atomicValue;
    }

    private void freeAtomicValue(TPointer atomicValue) {
        if (atomicValue.isNotNull()) {
            TPointer lwMutex = atomicValue.getPointer(0);
            if (lwMutex.isNotNull()) {
                Modules.ThreadManForUserModule.sceKernelDeleteLwMutex(lwMutex);
                this.free(lwMutex);
                atomicValue.setPointer(0, TPointer.NULL);
            }
            this.free(atomicValue);
        }
    }

    private int initData(TPointer32 psmfPlayer, int threadPriority, TPointer ringbufferData, TPointer controlBuffer, int controlBufferSize, TPointer videoBuffer, int videoBufferSize, TPointer audioBuffer, int audioBufferSize, TPointer yuv420Buffer) {
        TPointer data = psmfPlayer.getPointer();
        data.clear(72);
        TPointer filenameAddr = this.allocate(513);
        if (filenameAddr == null) {
            return -2141102075;
        }
        data.setPointer(0, filenameAddr);
        TPointer strFileAddr = this.allocate(16);
        if (strFileAddr == null) {
            return -2141102075;
        }
        data.setPointer(52, strFileAddr);
        int result = Modules.ThreadManForUserModule.sceKernelCreateEventFlag("ScePsmfPlayerAbortThreadEvf", 0, 0, TPointer.NULL);
        if (result < 0) {
            return result;
        }
        this.scePsmfPlayerAbortThreadEvf = result;
        result = Modules.ThreadManForUserModule.sceKernelCreateThread("ScePsmfPlayerAbortThread", this.scePsmfPlayerAbortThreadEntry, threadPriority, 12288, 0, 0);
        if (result < 0) {
            return result;
        }
        this.scePsmfPlayerAbortThread = result;
        result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelStartThread(this.scePsmfPlayerAbortThread, 0, TPointer.NULL));
        if (result < 0) {
            return result;
        }
        result = Modules.ThreadManForUserModule.sceKernelCreateThread("ScePsmfPlayerMCThread", this.scePsmfPlayerMCThreadEntry, threadPriority, 2048, 0, 0);
        if (result < 0) {
            return result;
        }
        data.setValue32(16, result);
        int ringbufferNumPackets = Modules.sceMpegModule.sceMpegRingbufferQueryPackNum(1251328);
        TPointer ringbufferAddr = this.allocate(128);
        if (ringbufferAddr == null) {
            return -2141102075;
        }
        data.setPointer(8, ringbufferAddr);
        result = Modules.sceMpegModule.sceMpegRingbufferConstruct(ringbufferAddr, ringbufferNumPackets, ringbufferData, 1251328, new TPointer(data.getMemory(), this.scePsmfPlayerRingbufferPutEntry), psmfPlayer.getAddress());
        if (result < 0) {
            return result;
        }
        result = Modules.sceMpegModule.sceMpegQueryMemSize(0);
        if (result < 0) {
            return result;
        }
        int mpegMemSize = result;
        TPointer mpegData = this.allocate(mpegMemSize);
        if (mpegData == null) {
            return -2141102075;
        }
        data.setPointer(60, mpegData);
        TPointer mpeg = this.allocate(4);
        if (mpeg == null) {
            return -2141102075;
        }
        data.setPointer(4, mpeg);
        result = Modules.sceMpegModule.sceMpegCreate(new TPointer32(mpeg), mpegData, mpegMemSize, ringbufferAddr, 512, 0, 0);
        if (result < 0) {
            return result;
        }
        TPointer playerStatusAddr = this.allocate(36);
        if (playerStatusAddr == null) {
            return -2141102075;
        }
        data.setPointer(24, playerStatusAddr);
        playerStatusAddr.clear(36);
        playerStatusAddr.setValue32(8, 1);
        playerStatusAddr.setValue32(12, 1);
        playerStatusAddr.setValue32(16, 1);
        result = Modules.ThreadManForUserModule.sceKernelCreateEventFlag("ScePsmfPlayerWaitFlag", 512, 0, TPointer.NULL);
        if (result < 0) {
            return result;
        }
        playerStatusAddr.setValue32(24, result);
        TPointer psmfControlAddr = this.allocate(180);
        if (psmfControlAddr == null) {
            return -2141102075;
        }
        data.setPointer(28, psmfControlAddr);
        psmfControlAddr.clear(180);
        psmfControlAddr.setValue32(136, -1);
        psmfControlAddr.setValue32(140, -1);
        psmfControlAddr.setValue32(144, -1);
        psmfControlAddr.setValue32(148, -1);
        psmfControlAddr.setValue32(152, -1);
        psmfControlAddr.setValue32(156, -1);
        psmfControlAddr.setValue32(160, -1);
        psmfControlAddr.setValue32(164, -1);
        psmfControlAddr.setPointer(168, controlBuffer);
        psmfControlAddr.setValue32(172, controlBufferSize);
        psmfControlAddr.setValue32(176, 0);
        TPointer avSyncControlAddr = this.allocate(56);
        if (avSyncControlAddr == null) {
            return -2141102075;
        }
        data.setPointer(32, avSyncControlAddr);
        avSyncControlAddr.clear(56);
        avSyncControlAddr.setPointer(12, this.allocateAtomicValue());
        avSyncControlAddr.setPointer(16, this.allocateAtomicValue());
        TPointer decodeControlAddr = this.allocate(84);
        if (decodeControlAddr == null) {
            return -2141102075;
        }
        data.setPointer(36, decodeControlAddr);
        decodeControlAddr.clear(84);
        decodeControlAddr.setPointer(0, mpeg);
        decodeControlAddr.setPointer(4, ringbufferAddr);
        decodeControlAddr.setValue32(68, 3);
        decodeControlAddr.setPointer(72, this.allocateAtomicValue());
        result = Modules.ThreadManForUserModule.sceKernelCreateThread("ScePsmfPlayerDecodeThread", this.scePsmfPlayerDecodeThreadEntry, threadPriority + 1, 2048, 0, 0);
        if (result < 0) {
            return result;
        }
        decodeControlAddr.setValue32(56, result);
        TPointer avcDecodeAddr = this.allocate(1128);
        if (avcDecodeAddr == null) {
            return -2141102075;
        }
        decodeControlAddr.setPointer(24, avcDecodeAddr);
        avcDecodeAddr.clear(1128);
        this.initCommonDecode(avcDecodeAddr, mpeg);
        result = Modules.sceMpegModule.sceMpegMallocAvcEsBuf(new TPointer32(mpeg));
        if (result == 0) {
            return -2141102069;
        }
        avcDecodeAddr.setValue32(1100, result);
        int numberPtsBuffers = 3;
        TPointer ptsBufferAddr = this.allocate(12);
        if (ptsBufferAddr == null) {
            return -2141102075;
        }
        avcDecodeAddr.setPointer(1104, ptsBufferAddr);
        avcDecodeAddr.setValue32(1120, 3);
        TPointer atracDecodeAddr = this.allocate(1120);
        if (atracDecodeAddr == null) {
            return -2141102075;
        }
        decodeControlAddr.setPointer(28, atracDecodeAddr);
        atracDecodeAddr.clear(1120);
        this.initCommonDecode(atracDecodeAddr, mpeg);
        TPointer32 esSizeAddr = Utilities.allocatePointer32(4);
        TPointer32 outSizeAddr = Utilities.allocatePointer32(4);
        result = Modules.sceMpegModule.sceMpegQueryAtracEsSize(new TPointer32(mpeg), esSizeAddr, outSizeAddr);
        if (result != 0) {
            return result;
        }
        TPointer atracEsBufferAddr = this.allocate(esSizeAddr.getValue() + 64);
        atracDecodeAddr.setPointer(1100, atracEsBufferAddr);
        atracEsBufferAddr.alignUp(63);
        atracDecodeAddr.setPointer(1104, atracEsBufferAddr);
        int atracOutputSize = outSizeAddr.getValue();
        atracDecodeAddr.setValue32(1108, atracOutputSize);
        TPointer pcmDecodeAddr = this.allocate(1160);
        if (pcmDecodeAddr == null) {
            return -2141102075;
        }
        decodeControlAddr.setPointer(32, pcmDecodeAddr);
        pcmDecodeAddr.clear(1160);
        this.initCommonDecode(pcmDecodeAddr, mpeg);
        TPointer pcmPoolAddr = this.allocate(40960);
        if (pcmPoolAddr == null) {
            return -2141102075;
        }
        pcmDecodeAddr.setPointer(1116, pcmPoolAddr);
        TPointer pcmPtsAddr = this.allocate(512);
        if (pcmPtsAddr == null) {
            return -2141102075;
        }
        pcmDecodeAddr.setPointer(1120, pcmPtsAddr);
        result = Modules.sceMpegModule.sceMpegQueryPcmEsSize(new TPointer32(mpeg), esSizeAddr, outSizeAddr);
        if (result != 0) {
            return result;
        }
        TPointer pcmEsBufferAddr = this.allocate(esSizeAddr.getValue());
        if (pcmEsBufferAddr == null) {
            return -2141102075;
        }
        pcmDecodeAddr.setPointer(1100, pcmEsBufferAddr);
        pcmDecodeAddr.setValue32(1104, outSizeAddr.getValue());
        TPointer videoBufferAddr = this.allocate(52);
        if (videoBufferAddr == null) {
            return -2141102075;
        }
        data.setPointer(40, videoBufferAddr);
        videoBufferAddr.clear(52);
        videoBufferAddr.setPointer(0, mpeg);
        int numberDisplayBuffers = 3;
        videoBufferAddr.setValue32(20, 3);
        videoBufferAddr.setPointer(44, this.allocateAtomicValue());
        TPointer displayDataArrayAddr = this.allocate(24);
        if (displayDataArrayAddr == null) {
            return -2141102075;
        }
        videoBufferAddr.setPointer(4, displayDataArrayAddr);
        for (int i = 0; i < 3; ++i) {
            displayDataArrayAddr.setValue32(i * 8 + 0, 0);
        }
        TPointer32 resultAddr = Utilities.allocatePointer32(4);
        result = Modules.sceMpegModule.sceMpegAvcQueryYCbCrSize(new TPointer32(mpeg), 1, 480, 272, resultAddr);
        if (result != 0) {
            return result;
        }
        int yCbCrSize = Utilities.alignUp(resultAddr.getValue(), 15);
        videoBufferAddr.setValue32(36, yCbCrSize);
        for (int i = 0; i < 3; ++i) {
            displayDataArrayAddr.setValue32(i * 8 + 0, videoBuffer.getAddress() + i * yCbCrSize);
        }
        int size = yCbCrSize * 3;
        videoBufferAddr.setValue32(24, videoBuffer.getAddress() + size);
        for (int i = 0; i < 3; ++i) {
            result = Modules.sceMpegModule.sceMpegAvcInitYCbCr(new TPointer32(mpeg), 1, 480, 272, displayDataArrayAddr.getPointer(i * 8 + 0));
            if (result == 0) continue;
            return result;
        }
        result = Modules.sceMpegModule.sceMpegAvcInitYCbCr(new TPointer32(mpeg), 1, 480, 272, videoBufferAddr.getPointer(24));
        if (result != 0) {
            return result;
        }
        TPointer audioBufferAddr = this.allocate(32);
        if (audioBufferAddr == null) {
            return -2141102075;
        }
        data.setPointer(44, audioBufferAddr);
        audioBufferAddr.clear(32);
        int numberAudioBuffers = 3;
        audioBufferAddr.setValue32(16, 3);
        audioBufferAddr.setValue32(20, Utilities.alignUp(atracOutputSize, 63));
        TPointer audioDataAddr = this.allocate(24);
        if (audioDataAddr == null) {
            return -2141102075;
        }
        audioBufferAddr.setPointer(0, audioDataAddr);
        for (int i = 0; i < 3; ++i) {
            audioDataAddr.setValue32(i * 8 + 0, audioBuffer.getAddress() + i * audioBufferAddr.getValue32(20));
        }
        TPointer readControlAddr = this.allocate(68);
        if (readControlAddr == null) {
            return -2141102075;
        }
        data.setPointer(48, readControlAddr);
        readControlAddr.clear(68);
        readControlAddr.setPointer(44, mpeg);
        readControlAddr.setPointer(48, ringbufferAddr);
        readControlAddr.setValue32(52, ringbufferNumPackets);
        result = Modules.ThreadManForUserModule.sceKernelCreateEventFlag("ScePsmfPlayerReadStatus", 0, 0, TPointer.NULL);
        if (result < 0) {
            return result;
        }
        readControlAddr.setValue32(0, result);
        readControlAddr.setPointer(4, this.allocateAtomicValue());
        result = Modules.ThreadManForUserModule.sceKernelCreateThread("ScePsmfPlayerReadThread", this.scePsmfPlayerReadThreadEntry, threadPriority + 2, 12288, 0, 0);
        if (result < 0) {
            return result;
        }
        readControlAddr.setValue32(12, result);
        avSyncControlAddr.setPointer(24, videoBufferAddr);
        avSyncControlAddr.setPointer(28, audioBufferAddr);
        avSyncControlAddr.setPointer(32, decodeControlAddr);
        avSyncControlAddr.setPointer(36, readControlAddr);
        avSyncControlAddr.setPointer(40, playerStatusAddr);
        avSyncControlAddr.setPointer(44, psmfControlAddr);
        decodeControlAddr.setPointer(36, playerStatusAddr);
        decodeControlAddr.setPointer(40, psmfControlAddr);
        decodeControlAddr.setPointer(44, readControlAddr);
        decodeControlAddr.setPointer(48, videoBufferAddr);
        decodeControlAddr.setPointer(52, audioBufferAddr);
        decodeControlAddr.setPointer(80, yuv420Buffer);
        readControlAddr.setPointer(16, playerStatusAddr);
        readControlAddr.setPointer(56, strFileAddr);
        psmfControlAddr.setPointer(176, strFileAddr);
        this.setPlayerStatus(playerStatusAddr, 1);
        return 0;
    }

    private void freeData(TPointer32 psmfPlayer) {
        TPointer ringbufferAddr;
        TPointer mpegData;
        TPointer mpeg;
        TPointer strFileAddr;
        TPointer readControlAddr;
        TPointer audioBufferAddr;
        TPointer videoBufferAddr;
        TPointer decodeControlAddr;
        TPointer avSyncControlAddr;
        TPointer psmfControlAddr;
        TPointer playerStatusAddr;
        int scePsmfPlayerMCThread;
        TPointer data = psmfPlayer.getPointer();
        TPointer filenameAddr = data.getPointer(0);
        if (filenameAddr.isNotNull()) {
            this.free(filenameAddr);
            data.setPointer(0, TPointer.NULL);
        }
        if ((scePsmfPlayerMCThread = data.getValue32(16)) > 0) {
            RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteThread(scePsmfPlayerMCThread));
            data.setValue32(16, 0);
        }
        if ((playerStatusAddr = data.getPointer(24)).isNotNull()) {
            int scePsmfPlayerWaitFlag = playerStatusAddr.getValue32(24);
            if (scePsmfPlayerWaitFlag > 0) {
                RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteEventFlag(scePsmfPlayerWaitFlag));
                playerStatusAddr.setValue32(24, 0);
            }
            this.free(playerStatusAddr);
            data.setPointer(24, TPointer.NULL);
        }
        if ((psmfControlAddr = data.getPointer(28)).isNotNull()) {
            TPointer controlBuffer = psmfControlAddr.getPointer(168);
            if (controlBuffer.isNotNull()) {
                psmfControlAddr.setPointer(168, TPointer.NULL);
                psmfControlAddr.setValue32(172, 0);
            }
            this.free(psmfControlAddr);
            data.setPointer(28, TPointer.NULL);
        }
        if ((avSyncControlAddr = data.getPointer(32)).isNotNull()) {
            this.freeAtomicValue(avSyncControlAddr.getPointer(12));
            avSyncControlAddr.setPointer(12, TPointer.NULL);
            this.freeAtomicValue(avSyncControlAddr.getPointer(16));
            avSyncControlAddr.setPointer(16, TPointer.NULL);
            this.free(avSyncControlAddr);
            data.setPointer(32, TPointer.NULL);
        }
        if ((decodeControlAddr = data.getPointer(36)).isNotNull()) {
            TPointer pcmDecodeAddr;
            TPointer atracDecodeAddr;
            TPointer avcDecodeAddr;
            this.unregisterAllStreams(data);
            this.freeAtomicValue(decodeControlAddr.getPointer(72));
            decodeControlAddr.setPointer(72, TPointer.NULL);
            int scePsmfPlayerDecodeThread = decodeControlAddr.getValue32(56);
            if (scePsmfPlayerDecodeThread > 0) {
                RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteThread(scePsmfPlayerDecodeThread));
                decodeControlAddr.setValue32(56, 0);
            }
            if ((avcDecodeAddr = decodeControlAddr.getPointer(24)).isNotNull()) {
                TPointer ptsBufferAddr;
                TPointer mpeg2 = avcDecodeAddr.getPointer(0);
                TPointer32 mpeg32 = new TPointer32(mpeg2);
                int esBuffer = avcDecodeAddr.getValue32(1100);
                if (esBuffer != 0) {
                    Modules.sceMpegModule.sceMpegFreeAvcEsBuf(mpeg32, esBuffer);
                    avcDecodeAddr.setValue32(1100, 0);
                }
                if ((ptsBufferAddr = avcDecodeAddr.getPointer(1104)).isNotNull()) {
                    this.free(ptsBufferAddr);
                    avcDecodeAddr.setPointer(1104, TPointer.NULL);
                }
                this.free(avcDecodeAddr);
                decodeControlAddr.setPointer(24, TPointer.NULL);
            }
            if ((atracDecodeAddr = decodeControlAddr.getPointer(28)).isNotNull()) {
                TPointer atracEsBufferAddr = atracDecodeAddr.getPointer(1100);
                if (atracEsBufferAddr.isNotNull()) {
                    this.free(atracEsBufferAddr);
                    atracDecodeAddr.setPointer(1100, TPointer.NULL);
                    atracDecodeAddr.setPointer(1104, TPointer.NULL);
                }
                this.free(atracDecodeAddr);
                decodeControlAddr.setPointer(28, TPointer.NULL);
            }
            if ((pcmDecodeAddr = decodeControlAddr.getPointer(32)).isNotNull()) {
                TPointer pcmPtsAddr;
                TPointer pcmPoolAddr;
                TPointer pcmEsBufferAddr = pcmDecodeAddr.getPointer(1100);
                if (pcmEsBufferAddr.isNotNull()) {
                    this.free(pcmEsBufferAddr);
                    pcmDecodeAddr.setPointer(1100, TPointer.NULL);
                }
                if ((pcmPoolAddr = pcmDecodeAddr.getPointer(1116)).isNotNull()) {
                    this.free(pcmPoolAddr);
                    pcmDecodeAddr.setPointer(1116, TPointer.NULL);
                }
                if ((pcmPtsAddr = pcmDecodeAddr.getPointer(1120)).isNotNull()) {
                    this.free(pcmPtsAddr);
                    pcmDecodeAddr.setPointer(1120, TPointer.NULL);
                }
                this.free(pcmDecodeAddr);
                decodeControlAddr.setPointer(32, TPointer.NULL);
            }
            this.free(decodeControlAddr);
            data.setPointer(36, TPointer.NULL);
        }
        if ((videoBufferAddr = data.getPointer(40)).isNotNull()) {
            this.freeAtomicValue(videoBufferAddr.getPointer(44));
            videoBufferAddr.setPointer(44, TPointer.NULL);
            TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
            if (displayDataArrayAddr.isNotNull()) {
                int numberDisplayBuffers = videoBufferAddr.getValue32(20);
                for (int i = 0; i < numberDisplayBuffers; ++i) {
                    displayDataArrayAddr.setPointer(i * 8 + 0, TPointer.NULL);
                }
                this.free(displayDataArrayAddr);
                videoBufferAddr.setPointer(4, TPointer.NULL);
                videoBufferAddr.setPointer(24, TPointer.NULL);
            }
            this.free(videoBufferAddr);
            data.setPointer(40, TPointer.NULL);
        }
        if ((audioBufferAddr = data.getPointer(44)).isNotNull()) {
            TPointer audioDataAddr = audioBufferAddr.getPointer(0);
            if (audioDataAddr.isNotNull()) {
                int numberAudioBuffers = audioBufferAddr.getValue32(16);
                for (int i = 0; i < numberAudioBuffers; ++i) {
                    audioDataAddr.setPointer(i * 8 + 0, TPointer.NULL);
                }
                this.free(audioDataAddr);
                audioBufferAddr.setPointer(0, TPointer.NULL);
            }
            this.free(audioBufferAddr);
            data.setPointer(44, TPointer.NULL);
        }
        if ((readControlAddr = data.getPointer(48)).isNotNull()) {
            int scePsmfPlayerReadStatus = readControlAddr.getValue32(0);
            if (scePsmfPlayerReadStatus > 0) {
                RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteEventFlag(scePsmfPlayerReadStatus));
                readControlAddr.setValue32(0, 0);
            }
            this.freeAtomicValue(readControlAddr.getPointer(4));
            readControlAddr.setPointer(4, TPointer.NULL);
            int scePsmfPlayerReadThread = readControlAddr.getValue32(12);
            if (scePsmfPlayerReadStatus > 0) {
                RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteThread(scePsmfPlayerReadThread));
                readControlAddr.setValue32(12, 0);
            }
            this.free(readControlAddr);
            data.setPointer(48, TPointer.NULL);
        }
        if ((strFileAddr = data.getPointer(52)).isNotNull()) {
            RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(this.scePsmfPlayerAbortThreadEvf, 4));
            RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(this.scePsmfPlayerAbortThread, TPointer32.NULL));
            if (this.scePsmfPlayerAbortThreadEvf > 0) {
                RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteEventFlag(this.scePsmfPlayerAbortThreadEvf));
                this.scePsmfPlayerAbortThreadEvf = 0;
            }
            if (this.scePsmfPlayerAbortThread > 0) {
                RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelDeleteThread(this.scePsmfPlayerAbortThread));
                this.scePsmfPlayerAbortThread = 0;
            }
            this.free(strFileAddr);
            data.setPointer(52, strFileAddr);
        }
        if ((mpeg = data.getPointer(4)).isNotNull()) {
            TPointer32 mpeg32 = new TPointer32(mpeg);
            Modules.sceMpegModule.sceMpegDelete(mpeg32);
            this.free(mpeg);
            data.setPointer(4, TPointer.NULL);
        }
        if ((mpegData = data.getPointer(60)).isNotNull()) {
            this.free(mpegData);
            data.setPointer(60, TPointer.NULL);
        }
        if ((ringbufferAddr = data.getPointer(8)).isNotNull()) {
            Modules.sceMpegModule.sceMpegRingbufferDestruct(ringbufferAddr);
            this.free(ringbufferAddr);
            data.setPointer(8, TPointer.NULL);
        }
        data.setValue32(56, 0);
        if (data.isNotNull()) {
            this.free(data);
            psmfPlayer.setPointer(TPointer.NULL);
        }
        if (this.scePsmfPlayerMemoryPool >= 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("scePsmfPlayerMemoryPoolMaxAllocatedSize=0x%X", this.scePsmfPlayerMemoryPoolMaxAllocatedSize));
            }
            Modules.ThreadManForUserModule.sceKernelDeleteVpl(this.scePsmfPlayerMemoryPool);
            this.scePsmfPlayerMemoryPool = -1;
            this.scePsmfPlayerMemoryPoolMaxAllocatedSize = 0;
        }
    }

    private void initHLE() {
        int moduleMemory;
        this.scePsmfPlayerMCThreadEntry = moduleMemory = this.getModuleMemory();
        HLEUtilities.getInstance().installHLEThread(this.scePsmfPlayerMCThreadEntry, this, "hlePsmfPlayerMCThread");
        this.scePsmfPlayerOpenControlThreadEntry = moduleMemory += 16;
        HLEUtilities.getInstance().installHLEThread(this.scePsmfPlayerOpenControlThreadEntry, this, "hlePsmfPlayerOpenControlThread");
        this.scePsmfPlayerDecodeThreadEntry = moduleMemory += 16;
        HLEUtilities.getInstance().installHLEThread(this.scePsmfPlayerDecodeThreadEntry, this, "hlePsmfPlayerDecodeThread");
        this.scePsmfPlayerReadThreadEntry = moduleMemory += 16;
        HLEUtilities.getInstance().installHLEThread(this.scePsmfPlayerReadThreadEntry, this, "hlePsmfPlayerReadThread");
        this.scePsmfPlayerAbortThreadEntry = moduleMemory += 16;
        HLEUtilities.getInstance().installHLEThread(this.scePsmfPlayerAbortThreadEntry, this, "hlePsmfPlayerAbortThread");
        this.scePsmfPlayerRingbufferPutEntry = moduleMemory += 16;
        moduleMemory += 16;
        HLEUtilities.getInstance().installHLESyscall(this.scePsmfPlayerRingbufferPutEntry, (HLEModule)this, "hlePsmfPlayerRingbufferPutCallback");
    }

    private void initCommonDecode(TPointer commonDecodeAddr, TPointer mpeg) {
        commonDecodeAddr.setPointer(0, mpeg);
        commonDecodeAddr.setValue32(8, 0);
        for (int i = 0; i < 16; ++i) {
            commonDecodeAddr.setValue32(12 + i * 4, 0);
        }
    }

    private int registerStream(TPointer commonDecodeAddr, int streamType, int streamChannelNum) {
        int numberOfRegisteredStreams = commonDecodeAddr.getValue32(8);
        if (numberOfRegisteredStreams >= 16) {
            return -2141102069;
        }
        TPointer32 mpeg = new TPointer32(commonDecodeAddr.getPointer(0));
        int result = Modules.sceMpegModule.sceMpegRegistStream(mpeg, streamType, streamChannelNum);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("registerStream: sceMpegRegistStream streamType=0x%X, streamChannelNum=0x%X, numberOfRegisteredStreams=%d returned 0x%X", streamType, streamChannelNum, numberOfRegisteredStreams, result));
        }
        if (result < 0) {
            return result;
        }
        commonDecodeAddr.setValue32(12 + numberOfRegisteredStreams * 4, result);
        commonDecodeAddr.setValue32(8, numberOfRegisteredStreams + 1);
        return 0;
    }

    private int registerStreams(TPointer32 psmf, TPointer commonDecodeAddr, int streamType, int numberOfStreams) {
        int result = 0;
        for (int i = 0; i < numberOfStreams; ++i) {
            TPointer32 channelAddr;
            result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamType(psmf, streamType, i);
            if (result != 0) {
                return result;
            }
            TPointer32 typeAddr = Utilities.allocatePointer32(4);
            result = Modules.scePsmfModule.scePsmfGetCurrentStreamType(psmf, typeAddr, channelAddr = Utilities.allocatePointer32(4));
            if (result != 0) {
                return result;
            }
            result = this.registerStream(commonDecodeAddr, streamType, channelAddr.getValue());
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    private void unregisterStreams(TPointer commonDecodeAddr) {
        int numberRegisteredStreams = commonDecodeAddr.getValue32(8);
        for (int i = 0; i < numberRegisteredStreams; ++i) {
            Modules.sceMpegModule.sceMpegUnRegistStream(new TPointer32(commonDecodeAddr.getPointer(0)), commonDecodeAddr.getPointer(12 + i * 4));
        }
        numberRegisteredStreams = 0;
        commonDecodeAddr.setValue32(8, numberRegisteredStreams);
    }

    private void unregisterAllStreams(TPointer data) {
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        this.unregisterStreams(avcDecodeAddr);
        TPointer atracDecodeAddr = decodeControlAddr.getPointer(28);
        this.unregisterStreams(atracDecodeAddr);
        TPointer pcmDecodeAddr = decodeControlAddr.getPointer(32);
        this.unregisterStreams(pcmDecodeAddr);
    }

    private int commonChangeGetAuMode(TPointer commonDecodeAddr) {
        int numberRegisteredStreams = commonDecodeAddr.getValue32(8);
        TPointer mpeg = commonDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        for (int i = 0; i < numberRegisteredStreams; ++i) {
            int result = Modules.sceMpegModule.sceMpegChangeGetAuMode(mpeg32, commonDecodeAddr.getPointer(12 + i * 4), 1);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("commonChangeGetAuMode: sceMpegChangeGetAuMode returned 0x%X", result));
            }
            if (result == 0) continue;
            return result;
        }
        commonDecodeAddr.setValue32(4, -1);
        return 0;
    }

    private void unregisterReadControl(TPointer data) {
        TPointer readControlAddr = data.getPointer(48);
        this.closePsmf(readControlAddr);
    }

    private int hlePsmfPlayerSetPsmf(TPointer32 psmfPlayer, PspString fileAddr, int offset, boolean doCallbacks) {
        int result;
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        if (this.getPlayerStatus(playerStatusAddr) == 1) {
            TPointer videoBufferAddr = data.getPointer(40);
            videoBufferAddr.setValue32(8, 0);
            videoBufferAddr.setValue32(12, 0);
            videoBufferAddr.setValue32(16, 0);
            videoBufferAddr.setValue32(32, 0);
            TPointer filenameAddr = data.getPointer(0);
            Modules.SysclibForKernelModule.strncpy(filenameAddr, fileAddr.getPointer(), 512);
            filenameAddr.setValue8(512, (byte)0);
            data.setValue32(68, offset);
            int currentThreadPriority = Modules.ThreadManForUserModule.sceKernelGetThreadCurrentPriority();
            result = Modules.ThreadManForUserModule.sceKernelCreateThread("ScePsmfPlayerOpenControlThread", this.scePsmfPlayerOpenControlThreadEntry, currentThreadPriority, 12288, 0, 0);
            if (result >= 0) {
                int scePsmfPlayerOpenControlThread = result;
                data.setValue32(12, scePsmfPlayerOpenControlThread);
                int threadDataSize = 4;
                TPointer threadData = Utilities.allocatePointer(4);
                threadData.setPointer(psmfPlayer);
                result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelStartThread(scePsmfPlayerOpenControlThread, 4, threadData));
                if (result == 0) {
                    int newPlayerStatus;
                    result = doCallbacks ? RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEndCB(scePsmfPlayerOpenControlThread, TPointer32.NULL)) : RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerOpenControlThread, TPointer32.NULL));
                    if (result >= 0) {
                        result = 0;
                        newPlayerStatus = 2;
                    } else {
                        this.unregisterAllStreams(data);
                        this.unregisterReadControl(data);
                        newPlayerStatus = 1;
                    }
                    this.setPlayerStatus(playerStatusAddr, newPlayerStatus);
                }
            }
        } else {
            result = -2141102079;
        }
        int scePsmfPlayerOpenControlThread = data.getValue32(12);
        if (scePsmfPlayerOpenControlThread > 0) {
            Modules.ThreadManForUserModule.sceKernelDeleteThread(scePsmfPlayerOpenControlThread);
            data.setValue32(12, 0);
        }
        return result;
    }

    private int setTimestamp(TPointer decodeControlAddr, int timestamp) {
        int entryOffset;
        decodeControlAddr.setValue32(60, timestamp);
        TPointer psmfControlAddr = decodeControlAddr.getPointer(40);
        TPointer psmf = new TPointer(psmfControlAddr, 24);
        TPointer32 psmf32 = new TPointer32(psmf);
        int result = Modules.scePsmfModule.scePsmfGetEPidWithTimestamp(psmf32, timestamp);
        if (result == -2141106139) {
            entryOffset = 0;
        } else {
            int epId = result;
            if (result == -2141104896) {
                epId = 0;
            } else if (result < 0) {
                return result;
            }
            TPointer32 outAddr = Utilities.allocatePointer32(16);
            result = Modules.scePsmfModule.scePsmfGetEPWithId(psmf32, epId, outAddr);
            if (result != 0) {
                return result;
            }
            entryOffset = outAddr.getValue(4);
        }
        TPointer readControlAddr = decodeControlAddr.getPointer(44);
        readControlAddr.setValue32(36, entryOffset);
        this.setReadStatus(readControlAddr, 32);
        decodeControlAddr.setValue32(8, psmfControlAddr.getValue32(136));
        decodeControlAddr.setValue32(12, psmfControlAddr.getValue32(140));
        decodeControlAddr.setValue32(16, psmfControlAddr.getValue32(152));
        decodeControlAddr.setValue32(20, psmfControlAddr.getValue32(156));
        AtomicValue.set(decodeControlAddr.getPointer(72), 7);
        TPointer videoBufferAddr = decodeControlAddr.getPointer(48);
        videoBufferAddr.setValue32(40, timestamp);
        return 0;
    }

    private int initAvcAu(TPointer avcDecodeAddr, int avcStreamMode0) {
        avcDecodeAddr.setValue32(1108, 0);
        avcDecodeAddr.setValue32(1112, 0);
        avcDecodeAddr.setValue32(1116, 0);
        TPointer mpeg = avcDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        int result = Modules.sceMpegModule.sceMpegAvcDecodeFlush(mpeg32);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("initAvcAu: sceMpegAvcDecodeFlush returned 0x%X", result));
        }
        if (result != 0) {
            return result;
        }
        int numberOfRegisteredAvcStreams = avcDecodeAddr.getValue32(8);
        for (int i = 0; i < numberOfRegisteredAvcStreams; ++i) {
            TPointer auAddr = new TPointer(avcDecodeAddr, 76 + i * 64);
            result = Modules.sceMpegModule.sceMpegInitAu(mpeg32, avcDecodeAddr.getValue32(1100), auAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("initAvcAu: sceMpegInitAu returned 0x%X", result));
            }
            if (result == 0) continue;
            return result;
        }
        if (avcStreamMode0 >= 0) {
            result = Modules.sceMpegModule.sceMpegChangeGetAuMode(mpeg32, avcDecodeAddr.getPointer(12 + avcStreamMode0 * 4), 0);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("initAvcAu: sceMpegChangeGetAuMode returned 0x%X", result));
            }
            if (result != 0) {
                return result;
            }
            avcDecodeAddr.setValue32(4, avcStreamMode0);
        }
        return 0;
    }

    private int initAtracAu(TPointer atracDecodeAddr, int atracStreamMode0, int timestamp) {
        TPointer mpeg = atracDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        atracDecodeAddr.setValue32(1112, 1);
        int numberOfRegisteredAtracStreams = atracDecodeAddr.getValue32(8);
        for (int i = 0; i < numberOfRegisteredAtracStreams; ++i) {
            TPointer auAddr = new TPointer(atracDecodeAddr, 76 + i * 64);
            int result = Modules.sceMpegModule.sceMpegInitAu(mpeg32, atracDecodeAddr.getValue32(1104), auAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("initAtracAu: sceMpegInitAu returned 0x%X", result));
            }
            if (result == 0) continue;
            return result;
        }
        if (atracStreamMode0 >= 0) {
            int result = Modules.sceMpegModule.sceMpegChangeGetAuMode(mpeg32, atracDecodeAddr.getPointer(12 + atracStreamMode0 * 4), 0);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("initAtracAu: sceMpegChangeGetAuMode returned 0x%X", result));
            }
            if (result != 0) {
                return result;
            }
            atracDecodeAddr.setValue32(4, atracStreamMode0);
        }
        atracDecodeAddr.setValue32(1116, timestamp);
        return 0;
    }

    private int initPcmAu(TPointer pcmDecodeAddr, int pcmStreamMode0, int timestamp) {
        pcmDecodeAddr.setValue32(1124, 0);
        pcmDecodeAddr.setValue32(1128, 0);
        pcmDecodeAddr.setValue32(1132, 0);
        TPointer mpeg = pcmDecodeAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        int numberOfRegisteredPcmStreams = pcmDecodeAddr.getValue32(8);
        for (int i = 0; i < numberOfRegisteredPcmStreams; ++i) {
            TPointer auAddr = new TPointer(pcmDecodeAddr, 76 + i * 64);
            int result = Modules.sceMpegModule.sceMpegInitAu(mpeg32, pcmDecodeAddr.getValue32(1100), auAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("initPcmAu: sceMpegInitAu returned 0x%X", result));
            }
            if (result == 0) continue;
            return result;
        }
        if (pcmStreamMode0 >= 0) {
            int result = Modules.sceMpegModule.sceMpegChangeGetAuMode(mpeg32, pcmDecodeAddr.getPointer(12 + pcmStreamMode0 * 4), 0);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("initPcmAu: sceMpegChangeGetAuMode returned 0x%X", result));
            }
            if (result != 0) {
                return result;
            }
            pcmDecodeAddr.setValue32(4, pcmStreamMode0);
        }
        pcmDecodeAddr.setValue32(1108, timestamp);
        pcmDecodeAddr.setValue32(1112, timestamp);
        return 0;
    }

    private int initAus(TPointer decodeControlAddr) {
        TPointer avcDecodeAddr = decodeControlAddr.getPointer(24);
        this.commonChangeGetAuMode(avcDecodeAddr);
        TPointer atracDecodeAddr = decodeControlAddr.getPointer(28);
        this.commonChangeGetAuMode(atracDecodeAddr);
        TPointer pcmDecodeAddr = decodeControlAddr.getPointer(32);
        this.commonChangeGetAuMode(pcmDecodeAddr);
        if (decodeControlAddr.getValue32(8) != 0) {
            return -2141102069;
        }
        int avcStreamMode0 = decodeControlAddr.getValue32(12);
        int result = this.initAvcAu(avcDecodeAddr, avcStreamMode0);
        if (result != 0) {
            return result;
        }
        int audioStreamMode0 = decodeControlAddr.getValue32(20);
        if (audioStreamMode0 >= 0) {
            if (decodeControlAddr.getValue32(16) == 1) {
                result = this.initAtracAu(atracDecodeAddr, audioStreamMode0, decodeControlAddr.getValue32(60));
                if (result != 0) {
                    return result;
                }
                result = this.initPcmAu(pcmDecodeAddr, -1, decodeControlAddr.getValue32(60));
                if (result != 0) {
                    return result;
                }
            } else if (decodeControlAddr.getValue32(16) == 2) {
                result = this.initAtracAu(atracDecodeAddr, -1, decodeControlAddr.getValue32(60));
                if (result != 0) {
                    return result;
                }
                result = this.initPcmAu(pcmDecodeAddr, audioStreamMode0, decodeControlAddr.getValue32(60));
                if (result != 0) {
                    return result;
                }
            } else {
                return -2141102069;
            }
        }
        TPointer videoBufferAddr = decodeControlAddr.getPointer(48);
        AtomicValue.set(videoBufferAddr.getPointer(44), 1);
        TPointer audioBufferAddr = decodeControlAddr.getPointer(52);
        audioBufferAddr.setValue32(24, audioBufferAddr.getValue32(24) & 0xFFFFFFFE);
        return 0;
    }

    private int setTimestampWithDirection(TPointer decodeControlAddr, int timestamp, int playSpeed, int direction) {
        TPointer psmfControlAddr = decodeControlAddr.getPointer(40);
        TPointer psmf = new TPointer(psmfControlAddr, 24);
        TPointer32 psmf32 = new TPointer32(psmf);
        int result = Modules.scePsmfModule.scePsmfGetEPidWithTimestamp(psmf32, timestamp);
        if (result < 0) {
            return result;
        }
        int epId = result;
        if (direction < 0 && epId <= 0) {
            AtomicValue.set(decodeControlAddr.getPointer(72), 8);
            return 0;
        }
        TPointer32 outAddr = Utilities.allocatePointer32(16);
        result = Modules.scePsmfModule.scePsmfGetEPWithId(psmf32, epId + direction, outAddr);
        if (result != 0) {
            if (result == -2141105920) {
                AtomicValue.set(decodeControlAddr.getPointer(72), 8);
                result = 0;
            }
            return result;
        }
        int entryOffset = outAddr.getValue(4);
        TPointer readControlAddr = decodeControlAddr.getPointer(44);
        readControlAddr.setValue32(36, entryOffset);
        int entryPicOffset = outAddr.getValue(12);
        readControlAddr.setValue32(40, Math.max(entryPicOffset, 65536));
        this.setReadStatus(readControlAddr, 64);
        if (direction > 0) {
            decodeControlAddr.setValue32(8, psmfControlAddr.getValue32(136));
            decodeControlAddr.setValue32(12, psmfControlAddr.getValue32(140));
            decodeControlAddr.setValue32(16, psmfControlAddr.getValue32(152));
            decodeControlAddr.setValue32(20, psmfControlAddr.getValue32(156));
        }
        if ((result = this.initAus(decodeControlAddr)) != 0) {
            return result;
        }
        switch (playSpeed) {
            case 1: 
            case 2: 
            case 3: {
                decodeControlAddr.setValue32(64, playSpeed);
                break;
            }
            default: {
                decodeControlAddr.setValue32(64, 1);
            }
        }
        AtomicValue.set(decodeControlAddr.getPointer(72), direction < 0 ? 6 : 5);
        return 0;
    }

    private int updatePlayModeAndSpeed(TPointer avSyncControlAddr, int playMode, int playSpeed, int pts) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("updatePlayModeAndSpeed playMode=%d, playSpeed=%d, pts=%d", playMode, playSpeed, pts));
        }
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        AtomicValue.set(videoBufferAddr.getPointer(44), 2);
        videoBufferAddr.setValue32(8, 0);
        videoBufferAddr.setValue32(12, 0);
        videoBufferAddr.setValue32(16, 0);
        TPointer audioBufferAddr = avSyncControlAddr.getPointer(28);
        audioBufferAddr.setValue32(24, audioBufferAddr.getValue32(24) | 1);
        audioBufferAddr.setValue32(4, 0);
        audioBufferAddr.setValue32(8, 0);
        audioBufferAddr.setValue32(12, 0);
        TPointer psmfControlAddr = avSyncControlAddr.getPointer(44);
        int startTime = psmfControlAddr.getValue32(4);
        int timestamp = startTime + pts;
        TPointer decodeControlAddr = avSyncControlAddr.getPointer(32);
        switch (playMode) {
            case 4: {
                this.setTimestampWithDirection(decodeControlAddr, timestamp, playSpeed, 1);
                break;
            }
            case 5: {
                this.setTimestampWithDirection(decodeControlAddr, timestamp, playSpeed, -1);
                break;
            }
            default: {
                this.setTimestamp(decodeControlAddr, timestamp);
                AtomicValue.clear(avSyncControlAddr.getPointer(16), 3);
            }
        }
        AtomicValue.set(avSyncControlAddr.getPointer(12), scePsmfPlayer.getReadyFlag(playMode, playSpeed));
        return 0;
    }

    private int decodeImageToVideoDataAddr(TPointer avSyncControlAddr, TPointer32 videoDataAddr) {
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        TPointer decodeControlAddr = avSyncControlAddr.getPointer(32);
        TPointer psmfControlAddr = avSyncControlAddr.getPointer(44);
        int frameWidth = videoDataAddr.getValue(0);
        TPointer destAddr = videoDataAddr.getPointer(4);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("decodeImageToVideoDataAddr frameWidth=%d, destAddr=%s, videoBufferAddr.getValue32(32)=%d", frameWidth, destAddr, videoBufferAddr.getValue32(32)));
        }
        if (videoBufferAddr.getValue32(32) == 0) {
            return -2141102068;
        }
        TPointer buffer = videoBufferAddr.getPointer(24);
        TPointer psmf = new TPointer(psmfControlAddr, 24);
        TPointer32 psmf32 = new TPointer32(psmf);
        TPointer32 videoInfoAddr = Utilities.allocatePointer32(8);
        int result = Modules.scePsmfModule.scePsmfGetVideoInfo(psmf32, videoInfoAddr);
        if (result < 0) {
            return result;
        }
        int videoWidth = videoInfoAddr.getValue(0);
        int videoHeight = videoInfoAddr.getValue(4);
        TPointer mpeg = decodeControlAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        int pixelStorageMode = decodeControlAddr.getValue32(68);
        if (pixelStorageMode == 4) {
            TPointer yuv420Buffer = decodeControlAddr.getPointer(80);
            result = Modules.sceMpegModule.sceMpegAvcConvertToYuv420(mpeg32, yuv420Buffer, buffer, 0);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("decodeImageToVideoDataAddr: sceMpegAvcConvertToYuv420 returned 0x%X", result));
            }
            if (result < 0) {
                return result;
            }
            int widthHeight = (videoWidth << 16) + videoHeight;
            result = Modules.sceJpegModule.sceJpegCsc(destAddr, yuv420Buffer, widthHeight, frameWidth, 0x120202);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("decodeImageToVideoDataAddr: sceJpegCsc returned 0x%X", result));
            }
            if (result != 0) {
                return result;
            }
        } else {
            TPointer32 rangeAddr = Utilities.allocatePointer32(16);
            rangeAddr.setValue(0, 0);
            rangeAddr.setValue(4, 0);
            rangeAddr.setValue(8, videoWidth);
            rangeAddr.setValue(12, videoHeight);
            result = Modules.sceMpegModule.sceMpegAvcCsc(mpeg32, buffer, rangeAddr, frameWidth, destAddr);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("decodeImageToVideoDataAddr: sceMpegAvcCsc returned 0x%X", result));
            }
            if (result != 0) {
                return result;
            }
        }
        int pts = videoBufferAddr.getValue32(28);
        int startTime = psmfControlAddr.getValue32(4);
        videoDataAddr.setValue(8, pts - startTime);
        return 0;
    }

    private int copyYCbCr(TPointer videoBufferAddr) {
        int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
        if (numberUsedDisplayBuffers == 0) {
            return -1;
        }
        TPointer destBuffer = videoBufferAddr.getPointer(24);
        int displayBufferIndex = videoBufferAddr.getValue32(12);
        TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
        TPointer sourceBuffer = displayDataArrayAddr.getPointer(displayBufferIndex * 8 + 0);
        int pts = displayDataArrayAddr.getValue32(displayBufferIndex * 8 + 4);
        TPointer mpeg = videoBufferAddr.getPointer(0);
        TPointer32 mpeg32 = new TPointer32(mpeg);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("copyYCbCr calling sceMpegAvcCopyYCbCr destBuffer=%s, sourceBuffer=%s", destBuffer, sourceBuffer));
        }
        Modules.sceMpegModule.sceMpegAvcCopyYCbCr(mpeg32, destBuffer, sourceBuffer);
        videoBufferAddr.setValue32(28, pts);
        this.consumeOneDiplayBuffer(videoBufferAddr);
        videoBufferAddr.setValue32(32, 1);
        return 0;
    }

    private int consumeOneDiplayBuffer(TPointer videoBufferAddr) {
        int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
        if (numberUsedDisplayBuffers == 0) {
            return -1;
        }
        int displayBufferIndex = videoBufferAddr.getValue32(12);
        TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
        int pts = displayDataArrayAddr.getValue32(displayBufferIndex * 8 + 4);
        videoBufferAddr.setValue32(40, pts);
        videoBufferAddr.setValue32(16, numberUsedDisplayBuffers - 1);
        int numberDisplayBuffers = videoBufferAddr.getValue32(20);
        videoBufferAddr.setValue32(12, (displayBufferIndex + 1) % numberDisplayBuffers);
        return 0;
    }

    private int consumeOneAudioBuffer(TPointer audioBufferAddr) {
        int numberUsedAudioBuffers = audioBufferAddr.getValue32(12);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("consumeOneAudioBuffer numberUsedAudioBuffers=%d", numberUsedAudioBuffers));
        }
        if (numberUsedAudioBuffers == 0) {
            return -1;
        }
        audioBufferAddr.setValue32(12, numberUsedAudioBuffers - 1);
        int audioBufferIndex = audioBufferAddr.getValue32(8);
        int numberAudioBuffers = audioBufferAddr.getValue32(16);
        audioBufferAddr.setValue32(8, (audioBufferIndex + 1) % numberAudioBuffers);
        return 0;
    }

    private static int getReadyFlag(int playMode, int playSpeed) {
        switch (playMode) {
            case 1: {
                return 17;
            }
            case 2: 
            case 3: {
                return 10;
            }
            case 0: {
                return 9;
            }
            case 4: {
                switch (playSpeed) {
                    case 2: {
                        return 12;
                    }
                    case 3: {
                        return 13;
                    }
                }
                return 11;
            }
            case 5: {
                switch (playSpeed) {
                    case 2: {
                        return 15;
                    }
                    case 3: {
                        return 16;
                    }
                }
                return 14;
            }
        }
        return 9;
    }

    private int getVideoDataPauseContinue(TPointer avSyncControlAddr, TPointer32 videoDataAddr) {
        this.clearVblankSyncCount(avSyncControlAddr);
        return this.decodeImageToVideoDataAddr(avSyncControlAddr, videoDataAddr);
    }

    private int getVideoDataPlayContinue(TPointer avSyncControlAddr, TPointer32 videoDataAddr) {
        int result;
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        TPointer audioBufferAddr = avSyncControlAddr.getPointer(28);
        TPointer readControlAddr = avSyncControlAddr.getPointer(36);
        int numberUsedAudioBuffers = audioBufferAddr.getValue32(12);
        int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
        int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
        if (avSyncControlAddr.getValue32(20) == 1 && readStatus != 2 && numberUsedAudioBuffers == 0) {
            result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
            AtomicValue.clear(avSyncControlAddr.getPointer(16), 3);
            AtomicValue.set(avSyncControlAddr.getPointer(12), 9);
        } else if (readStatus == 2 || numberUsedDisplayBuffers > 0 || this.getVblankSyncCount(avSyncControlAddr) != 0) {
            int displayBufferIndex = videoBufferAddr.getValue32(12);
            TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
            int videoPts = displayDataArrayAddr.getValue32(displayBufferIndex * 8 + 4);
            if (numberUsedAudioBuffers > 0) {
                int audioBufferIndex = audioBufferAddr.getValue32(8);
                TPointer audioDataArrayAddr = audioBufferAddr.getPointer(0);
                int audioPts = audioDataArrayAddr.getValue32(audioBufferIndex * 8 + 4);
                int vblankSyncCount = this.getVblankSyncCount(avSyncControlAddr);
                int videoPts2 = videoPts - vblankSyncCount * 3003 / 2;
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("scePsmfPlayerGetVideoData videoPts=%d, audioPts=%d, vblankSyncCount=%d, videoPts2=%d", videoPts, audioPts, vblankSyncCount, videoPts2));
                }
                if (videoPts2 - audioPts <= 6006) {
                    if (audioPts - videoPts2 > 12012) {
                        this.consumeOneDiplayBuffer(videoBufferAddr);
                        this.consumeOneDiplayBuffer(videoBufferAddr);
                        return this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
                    }
                } else {
                    return this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
                }
            }
            if (this.getVblankSyncCount(avSyncControlAddr) > 0 || numberUsedDisplayBuffers <= 0) {
                result = this.decodeImageToVideoDataAddr(avSyncControlAddr, videoDataAddr);
            } else {
                result = this.copyYCbCr(videoBufferAddr);
                if (result < 0) {
                    result = this.decodeImageToVideoDataAddr(avSyncControlAddr, videoDataAddr);
                } else {
                    result = this.decodeImageToVideoDataAddr(avSyncControlAddr, videoDataAddr);
                    this.setVblankSyncCount(avSyncControlAddr, this.getVblankSyncInterval(avSyncControlAddr));
                }
            }
        } else {
            result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
            AtomicValue.clear(avSyncControlAddr.getPointer(16), 1);
            AtomicValue.set(avSyncControlAddr.getPointer(12), 9);
        }
        return result;
    }

    private int getVideoDataRewindForward(TPointer avSyncControlAddr, TPointer32 videoDataAddr, int vblankSyncInterval, int readyFlag) {
        this.clearVblankSyncCount(avSyncControlAddr);
        this.setVblankSyncInterval(avSyncControlAddr, vblankSyncInterval);
        AtomicValue.set(avSyncControlAddr.getPointer(12), readyFlag);
        int result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
        avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) & 0xFFFFFFFE);
        return result;
    }

    @HLEFunction(nid=593332103, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerCreate(@BufferInfo(usage=BufferInfo.Usage.out) TPointer32 psmfPlayer, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.in) TPointer psmfPlayerDataAddr) {
        int result;
        psmfPlayer.setValue(0);
        this.initHLE();
        TPointer buffer = psmfPlayerDataAddr.getPointer(0);
        TPointer bufferAligned = new TPointer(buffer);
        bufferAligned.alignUp(63);
        int bufferSize = psmfPlayerDataAddr.getValue32(4);
        int threadPriority = psmfPlayerDataAddr.getValue32(8);
        if (threadPriority < 16 || threadPriority > 109) {
            return -2141102072;
        }
        int audioBufferSize = 32768;
        int videoBufferSize = 835584;
        int controlBufferSize = 524288;
        int yuv420BufferSize = 208896;
        if (bufferSize < 1392640 + yuv420BufferSize + 1251328 + 64) {
            if (bufferSize < 2643968) {
                return -2141102075;
            }
            yuv420BufferSize = 0;
        }
        TPointer audioBuffer = new TPointer(bufferAligned, 0);
        TPointer videoBuffer = new TPointer(audioBuffer, 32768);
        TPointer controlBuffer = new TPointer(videoBuffer, 835584);
        TPointer yuv420Buffer = new TPointer(controlBuffer, 524288);
        TPointer ringbufferData = new TPointer(yuv420Buffer, yuv420BufferSize);
        if (yuv420BufferSize == 0) {
            yuv420Buffer = TPointer.NULL;
        }
        if ((result = Modules.ThreadManForUserModule.sceKernelCreateVpl(new PspString("ScePsmfPlayerMemoryPool"), 2, 0, 262144, TPointer.NULL)) < 0) {
            return result;
        }
        this.scePsmfPlayerMemoryPool = result;
        this.scePsmfPlayerMemoryPoolMaxAllocatedSize = 0;
        TPointer data = this.allocate(72);
        if (data == null) {
            return -2141102075;
        }
        psmfPlayer.setPointer(data);
        result = this.initData(psmfPlayer, threadPriority, ringbufferData, controlBuffer, 524288, videoBuffer, 835584, audioBuffer, 32768, yuv420Buffer);
        if (result != 0) {
            this.freeData(psmfPlayer);
            return result;
        }
        return result;
    }

    @HLEFunction(nid=-1687051660, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerDelete(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer videoBufferAddr = data.getPointer(40);
        TPointer readControlAddr = data.getPointer(48);
        int result = this.scePsmfPlayerBreak(psmfPlayer);
        if (result < 0) {
            return result;
        }
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        if (playerStatus != 4 && playerStatus != 1 && playerStatus != 256 && playerStatus != 512) {
            return -2141102079;
        }
        AtomicValue.set(decodeControlAddr.getPointer(72), 9);
        this.setReadStatus(readControlAddr, 256);
        data.setValue32(20, data.getValue32(20) | 1);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(playerStatusAddr.getValue32(24), 15));
        int scePsmfPlayerReadThread = readControlAddr.getValue32(12);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerReadThread, TPointer32.NULL));
        int scePsmfPlayerDecodeThread = decodeControlAddr.getValue32(56);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerDecodeThread, TPointer32.NULL));
        int scePsmfPlayerMCThread = data.getValue32(16);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerMCThread, TPointer32.NULL));
        this.unregisterAllStreams(data);
        this.unregisterReadControl(data);
        videoBufferAddr.setValue32(8, 0);
        videoBufferAddr.setValue32(12, 0);
        videoBufferAddr.setValue32(16, 0);
        videoBufferAddr.setValue32(32, 0);
        this.setPlayerStatus(playerStatusAddr, 1);
        this.freeData(psmfPlayer);
        return 0;
    }

    @HLEFunction(nid=1030563241, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSetPsmf(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer, PspString fileAddr) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, 0, false);
    }

    @HLEFunction(nid=1488467319, version=150)
    public int scePsmfPlayerSetPsmfCB(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer, PspString fileAddr) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, 0, true);
    }

    @HLEFunction(nid=-409809516, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerReleasePsmf(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer videoBufferAddr = data.getPointer(40);
        TPointer readControlAddr = data.getPointer(48);
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        if (playerStatus != 4 && playerStatus != 2 && playerStatus != 256 && playerStatus != 512) {
            return -2141102079;
        }
        AtomicValue.set(decodeControlAddr.getPointer(72), 9);
        this.setReadStatus(readControlAddr, 2);
        this.setReadStatus(readControlAddr, 256);
        data.setValue32(20, data.getValue32(20) | 1);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(playerStatusAddr.getValue32(24), 15));
        int scePsmfPlayerReadThread = readControlAddr.getValue32(12);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerReadThread, TPointer32.NULL));
        int scePsmfPlayerDecodeThread = decodeControlAddr.getValue32(56);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerDecodeThread, TPointer32.NULL));
        int scePsmfPlayerMCThread = data.getValue32(16);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerMCThread, TPointer32.NULL));
        this.setPlayerStatus(playerStatusAddr, 2);
        this.unregisterAllStreams(data);
        this.unregisterReadControl(data);
        videoBufferAddr.setValue32(8, 0);
        videoBufferAddr.setValue32(12, 0);
        videoBufferAddr.setValue32(16, 0);
        videoBufferAddr.setValue32(32, 0);
        this.setPlayerStatus(playerStatusAddr, 1);
        return 0;
    }

    @HLEFunction(nid=-1784131867, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerStart(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=24, usage=BufferInfo.Usage.in) TPointer32 initPlayInfoAddr, int initPts) {
        TPointer32 channelAddr;
        TPointer psmf;
        TPointer32 psmf32;
        int result;
        int numberOfPcmStreams;
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        int status = this.getPlayerStatus(playerStatusAddr);
        int version = this.getPlayerVersion(playerStatusAddr);
        if (status == 4 || status == 512) {
            if (version == 2) {
                return -2141102077;
            }
        } else if (status != 2) {
            return -2141102079;
        }
        int playMode = initPlayInfoAddr.getValue(16);
        if (version == 1 || version == 2) {
            if (playMode < 0 || playMode > 3) {
                return -2141102072;
            }
            if (initPts != 0) {
                return -2141102072;
            }
        }
        int playSpeed = initPlayInfoAddr.getValue(20);
        TPointer psmfControlAddr = data.getPointer(28);
        int avcCodec = initPlayInfoAddr.getValue(0);
        int avcStreamNum = initPlayInfoAddr.getValue(4);
        if (avcCodec != 0 && avcCodec != 14) {
            return -2141102077;
        }
        int numberOfAvcStreams = psmfControlAddr.getValue32(12);
        if (avcStreamNum < 0 || avcStreamNum >= numberOfAvcStreams) {
            return -2141102074;
        }
        int audioCodec = initPlayInfoAddr.getValue(8);
        int audioStreamNum = initPlayInfoAddr.getValue(12);
        int numberOfAtracStreams = psmfControlAddr.getValue32(16);
        if (numberOfAtracStreams + (numberOfPcmStreams = psmfControlAddr.getValue32(20)) == 0) {
            audioStreamNum = -1;
        } else if (audioCodec == 1) {
            if (audioStreamNum >= numberOfAtracStreams) {
                return -2141102074;
            }
        } else if (audioCodec == 2) {
            if (audioStreamNum >= numberOfPcmStreams) {
                return -2141102074;
            }
        } else if (audioCodec == 15) {
            if (audioStreamNum >= numberOfAtracStreams + numberOfPcmStreams) {
                return -2141102074;
            }
        } else {
            return -2141102077;
        }
        int startTime = psmfControlAddr.getValue32(4);
        int endTime = psmfControlAddr.getValue32(8);
        if (startTime + initPts >= endTime) {
            return -2141102072;
        }
        if (status == 2) {
            data.setValue32(20, 0);
            int scePsmfPlayerMCThread = data.getValue32(16);
            int threadDataSize = 4;
            TPointer threadData = Utilities.allocatePointer(4);
            threadData.setPointer(psmfPlayer);
            result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelStartThread(scePsmfPlayerMCThread, 4, threadData));
            if (result != 0) {
                return result;
            }
            TPointer decodeControlAddr = data.getPointer(36);
            AtomicValue.set(decodeControlAddr.getPointer(72), 1);
            int scePsmfPlayerDecodeThread = decodeControlAddr.getValue32(56);
            threadData.setPointer(decodeControlAddr);
            result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelStartThread(scePsmfPlayerDecodeThread, 4, threadData));
            if (result != 0) {
                return result;
            }
            TPointer readControlAddr = data.getPointer(48);
            this.setReadStatus(readControlAddr, 1);
            int scePsmfPlayerReadThread = readControlAddr.getValue32(12);
            threadData.setPointer(readControlAddr);
            result = RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelStartThread(scePsmfPlayerReadThread, 4, threadData));
            if (result != 0) {
                return result;
            }
        }
        if ((result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamTypeNumber(psmf32 = new TPointer32(psmf = new TPointer(psmfControlAddr, 24)), 0, avcStreamNum)) != 0) {
            return result;
        }
        TPointer32 typeAddr = Utilities.allocatePointer32(4);
        result = Modules.scePsmfModule.scePsmfGetCurrentStreamType(psmf32, typeAddr, channelAddr = Utilities.allocatePointer32(4));
        if (result != 0) {
            return result;
        }
        if (typeAddr.getValue() != 0) {
            return -2141102069;
        }
        psmfControlAddr.setValue32(136, 0);
        psmfControlAddr.setValue32(140, avcStreamNum);
        psmfControlAddr.setValue32(144, channelAddr.getValue());
        psmfControlAddr.setValue32(148, avcStreamNum);
        TPointer avSyncControlAddr = data.getPointer(32);
        if (audioStreamNum < 0) {
            if (numberOfAtracStreams + numberOfPcmStreams == 0) {
                avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) & 0xFFFFFFFE);
            } else {
                avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) | 2);
            }
        } else if (audioCodec == 1 || audioCodec == 2) {
            result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamTypeNumber(psmf32, audioCodec, audioStreamNum);
            if (result != 0) {
                return result;
            }
            result = Modules.scePsmfModule.scePsmfGetCurrentStreamType(psmf32, typeAddr, channelAddr);
            if (result != 0) {
                return result;
            }
            psmfControlAddr.setValue32(152, typeAddr.getValue());
            psmfControlAddr.setValue32(156, audioStreamNum);
            psmfControlAddr.setValue32(160, channelAddr.getValue());
            TPointer psmfCopy = Utilities.allocatePointer(56);
            TPointer32 psmf32Copy = new TPointer32(psmfCopy);
            psmfCopy.memcpy(psmf, 56);
            psmfControlAddr.setValue32(164, -1);
            for (int i = 0; i < numberOfAtracStreams + numberOfPcmStreams; ++i) {
                result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamTypeNumber(psmf32Copy, 15, i);
                if (result != 0) {
                    return result;
                }
                result = Modules.scePsmfModule.scePsmfGetCurrentStreamType(psmf32Copy, typeAddr, channelAddr);
                if (result != 0) {
                    return result;
                }
                if (typeAddr.getValue() != audioCodec || channelAddr.getValue() != audioStreamNum) continue;
                psmfControlAddr.setValue32(164, i);
                break;
            }
        } else if (audioCodec == 15) {
            TPointer psmfAudio = new TPointer(psmfControlAddr, 80);
            TPointer32 psmf32Audio = new TPointer32(psmfAudio);
            result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamTypeNumber(psmf32Audio, audioCodec, audioStreamNum);
            if (result != 0) {
                return result;
            }
            result = Modules.scePsmfModule.scePsmfGetCurrentStreamType(psmf32Audio, typeAddr, channelAddr);
            if (result != 0) {
                return result;
            }
            psmfControlAddr.setValue32(152, typeAddr.getValue());
            psmfControlAddr.setValue32(164, audioStreamNum);
            psmfControlAddr.setValue32(160, channelAddr.getValue());
            TPointer psmfCopy = Utilities.allocatePointer(56);
            TPointer32 psmf32Copy = new TPointer32(psmfCopy);
            psmfCopy.memcpy(psmf, 56);
            int audioCodecType = typeAddr.getValue();
            int audioCodecChannel = channelAddr.getValue();
            psmfControlAddr.setValue32(156, -1);
            for (int i = 0; i < numberOfAtracStreams + numberOfPcmStreams; ++i) {
                result = Modules.scePsmfModule.scePsmfSpecifyStreamWithStreamTypeNumber(psmf32Copy, audioCodecType, i);
                if (result != 0) {
                    return result;
                }
                result = Modules.scePsmfModule.scePsmfGetCurrentStreamType(psmf32Copy, typeAddr, channelAddr);
                if (result != 0) {
                    return result;
                }
                if (typeAddr.getValue() != audioCodecType || channelAddr.getValue() != audioCodecChannel) continue;
                psmfControlAddr.setValue32(156, i);
                break;
            }
        } else {
            return -2141102077;
        }
        result = this.updatePlayModeAndSpeed(avSyncControlAddr, playMode, playSpeed, initPts);
        if (result != 0) {
            return result;
        }
        playerStatusAddr.setValue32(4, playMode);
        playerStatusAddr.setValue32(16, playSpeed);
        this.setPlayerStatus(playerStatusAddr, 4);
        return 0;
    }

    @HLEFunction(nid=1051208267, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetAudioOutSize(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        if (playerStatus != 4 && playerStatus != 1 && playerStatus != 2 && playerStatus != 256 && playerStatus != 512) {
            return -2141102079;
        }
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer atracDecodeAddr = decodeControlAddr.getPointer(28);
        int atracOutputSize = atracDecodeAddr.getValue32(1108);
        return atracOutputSize;
    }

    @HLEFunction(nid=276348936, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerStop(@CheckArgument(value="checkPlayerPlaying") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer avSyncControlAddr = data.getPointer(32);
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer readControlAddr = data.getPointer(48);
        AtomicValue.set(decodeControlAddr.getPointer(72), 9);
        this.setReadStatus(readControlAddr, 2);
        this.setReadStatus(readControlAddr, 256);
        data.setValue32(20, data.getValue32(20) | 1);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(playerStatusAddr.getValue32(24), 15));
        int scePsmfPlayerReadThread = readControlAddr.getValue32(12);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerReadThread, TPointer32.NULL));
        int scePsmfPlayerDecodeThread = decodeControlAddr.getValue32(56);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerDecodeThread, TPointer32.NULL));
        int scePsmfPlayerMCThread = data.getValue32(16);
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelWaitThreadEnd(scePsmfPlayerMCThread, TPointer32.NULL));
        avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) & 0xFFFFFFFD);
        this.setPlayerStatus(playerStatusAddr, 2);
        int errorCode = playerStatusAddr.getValue32(0);
        return errorCode;
    }

    @HLEFunction(nid=-1598502315, version=150)
    public int scePsmfPlayerUpdate(@CheckArgument(value="checkPlayerPlaying") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer avSyncControlAddr = data.getPointer(32);
        int count = this.getVblankSyncCount(avSyncControlAddr);
        if (count > 0) {
            this.setVblankSyncCount(avSyncControlAddr, count - 1);
        }
        RuntimeContext.hleSyscall(Modules.ThreadManForUserModule.sceKernelSetEventFlag(playerStatusAddr.getValue32(24), 15));
        return 0;
    }

    @HLEFunction(nid=1190535051, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetVideoData(@CheckArgument(value="checkPlayerPlaying") TPointer32 psmfPlayer, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=12, usage=BufferInfo.Usage.inout) TPointer32 videoDataAddr) {
        TPointer data = psmfPlayer.getPointer();
        TPointer avSyncControlAddr = data.getPointer(32);
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        TPointer audioBufferAddr = avSyncControlAddr.getPointer(28);
        TPointer decodeControlAddr = avSyncControlAddr.getPointer(32);
        TPointer readControlAddr = avSyncControlAddr.getPointer(36);
        TPointer ringbufferAddr = readControlAddr.getPointer(48);
        TPointer psmfControlAddr = avSyncControlAddr.getPointer(44);
        int readStatus = AtomicValue.get(readControlAddr.getPointer(4));
        int audioFlag = AtomicValue.get(avSyncControlAddr.getPointer(16));
        int decodeStatus = AtomicValue.get(decodeControlAddr.getPointer(72));
        int result = 0;
        int numberUsedAudioBuffers = audioBufferAddr.getValue32(12);
        int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
        int readyFlag = AtomicValue.get(avSyncControlAddr.getPointer(12));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scePsmfPlayerGetVideoData readStatus=0x%X, readyFlag=0x%X, audioFlag=0x%X, decodeStatus=0x%X, avSyncControlAddr.getValue32(20)=%d, numberUsedDisplayBuffers=%d, numberUsedAudioBuffers=%d", readStatus, readyFlag, audioFlag, decodeStatus, avSyncControlAddr.getValue32(20), numberUsedDisplayBuffers, numberUsedAudioBuffers));
        }
        switch (readyFlag) {
            case 0: {
                result = this.getVideoDataPlayContinue(avSyncControlAddr, videoDataAddr);
                break;
            }
            case 2: {
                result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
                break;
            }
            case 3: 
            case 7: 
            case 8: {
                if (this.getVblankSyncCount(avSyncControlAddr) > 0 || numberUsedDisplayBuffers <= 0 || this.copyYCbCr(videoBufferAddr) < 0) {
                    result = this.decodeImageToVideoDataAddr(avSyncControlAddr, videoDataAddr);
                    break;
                }
                result = this.decodeImageToVideoDataAddr(avSyncControlAddr, videoDataAddr);
                this.setVblankSyncCount(avSyncControlAddr, this.getVblankSyncInterval(avSyncControlAddr));
                break;
            }
            case 9: {
                int ringbufferAvailableSize;
                if ((audioFlag & 1) == 0) {
                    ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("scePsmfPlayerGetVideoData: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
                    }
                    if (readStatus == 2 || ringbufferAvailableSize < 32 && this.getNumberFreeDisplayBuffers(videoBufferAddr) == 0) {
                        AtomicValue.or(avSyncControlAddr.getPointer(16), 1);
                    }
                }
                if ((audioFlag & 2) == 0) {
                    if (avSyncControlAddr.getValue32(20) == 0 || (avSyncControlAddr.getValue32(20) & 2) != 0) {
                        AtomicValue.or(avSyncControlAddr.getPointer(16), 2);
                    } else {
                        ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("scePsmfPlayerGetVideoData: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
                        }
                        if (readStatus == 2 || ringbufferAvailableSize < 32 && this.getNumberFreeAudioBuffers(audioBufferAddr) == 0) {
                            int displayBufferIndex = videoBufferAddr.getValue32(12);
                            TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
                            int videoPts = displayDataArrayAddr.getValue32(displayBufferIndex * 8 + 4);
                            int audioBufferIndex = audioBufferAddr.getValue32(8);
                            TPointer audioDataArrayAddr = audioBufferAddr.getPointer(0);
                            int audioPts = audioDataArrayAddr.getValue32(audioBufferIndex * 8 + 4);
                            if (numberUsedDisplayBuffers == 0 || numberUsedAudioBuffers == 0 || videoPts - audioPts <= 6006) {
                                AtomicValue.or(avSyncControlAddr.getPointer(16), 2);
                            } else {
                                this.consumeOneAudioBuffer(audioBufferAddr);
                            }
                        }
                    }
                }
                if (((audioFlag = AtomicValue.get(avSyncControlAddr.getPointer(16))) & 3) == 3) {
                    int numberOfAtracStreams = psmfControlAddr.getValue32(16);
                    if (numberOfAtracStreams > 0) {
                        avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) | 1);
                    }
                    this.clearVblankSyncCount(avSyncControlAddr);
                    this.setVblankSyncInterval(avSyncControlAddr, 2);
                    AtomicValue.set(avSyncControlAddr.getPointer(12), 0);
                }
                result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
                break;
            }
            case 10: {
                int ringbufferAvailableSize;
                if ((audioFlag & 1) == 0) {
                    ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("scePsmfPlayerGetVideoData: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
                    }
                    if (decodeStatus == 8 || (readStatus == 2 || ringbufferAvailableSize < 32) && this.getNumberFreeDisplayBuffers(videoBufferAddr) == 0) {
                        AtomicValue.or(avSyncControlAddr.getPointer(16), 1);
                    }
                }
                if ((audioFlag & 2) == 0) {
                    if (avSyncControlAddr.getValue32(20) == 0 || (avSyncControlAddr.getValue32(20) & 2) != 0) {
                        AtomicValue.or(avSyncControlAddr.getPointer(16), 2);
                    } else {
                        ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
                        if (log.isTraceEnabled()) {
                            log.trace((Object)String.format("scePsmfPlayerGetVideoData: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
                        }
                        if (decodeStatus == 8 || (readStatus == 2 || ringbufferAvailableSize < 32) && this.getNumberFreeAudioBuffers(audioBufferAddr) == 0) {
                            int displayBufferIndex = videoBufferAddr.getValue32(12);
                            TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
                            int videoPts = displayDataArrayAddr.getValue32(displayBufferIndex * 8 + 4);
                            int audioBufferIndex = audioBufferAddr.getValue32(8);
                            TPointer audioDataArrayAddr = audioBufferAddr.getPointer(0);
                            int audioPts = audioDataArrayAddr.getValue32(audioBufferIndex * 8 + 4);
                            if (numberUsedDisplayBuffers == 0 || numberUsedAudioBuffers == 0 || videoPts - audioPts <= 6006) {
                                AtomicValue.or(avSyncControlAddr.getPointer(16), 2);
                            } else {
                                this.consumeOneAudioBuffer(audioBufferAddr);
                            }
                        }
                    }
                }
                if (((audioFlag = AtomicValue.get(avSyncControlAddr.getPointer(16))) & 3) == 3) {
                    if (this.getVblankSyncCount(avSyncControlAddr) == 0) {
                        avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) & 0xFFFFFFFE);
                        AtomicValue.set(avSyncControlAddr.getPointer(12), 2);
                    }
                    result = this.getVideoDataPlayContinue(avSyncControlAddr, videoDataAddr);
                    break;
                }
                result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
                break;
            }
            case 11: {
                result = this.getVideoDataRewindForward(avSyncControlAddr, videoDataAddr, 15, 7);
                break;
            }
            case 12: {
                result = this.getVideoDataRewindForward(avSyncControlAddr, videoDataAddr, 20, 7);
                break;
            }
            case 13: {
                result = this.getVideoDataRewindForward(avSyncControlAddr, videoDataAddr, 25, 7);
                break;
            }
            case 14: {
                result = this.getVideoDataRewindForward(avSyncControlAddr, videoDataAddr, 15, 8);
                break;
            }
            case 15: {
                result = this.getVideoDataRewindForward(avSyncControlAddr, videoDataAddr, 20, 8);
                break;
            }
            case 16: {
                result = this.getVideoDataRewindForward(avSyncControlAddr, videoDataAddr, 25, 8);
                break;
            }
            case 17: {
                avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) & 0xFFFFFFFE);
                AtomicValue.or(avSyncControlAddr.getPointer(16), 2);
                audioFlag = AtomicValue.get(avSyncControlAddr.getPointer(16));
                if ((audioFlag & 1) == 0) {
                    int ringbufferAvailableSize = Modules.sceMpegModule.sceMpegRingbufferAvailableSize(ringbufferAddr);
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("scePsmfPlayerGetVideoData: sceMpegRingbufferAvailableSize returned 0x%X", ringbufferAvailableSize));
                    }
                    if (decodeStatus == 8 || (readStatus == 2 || ringbufferAvailableSize < 32) && this.getNumberFreeDisplayBuffers(videoBufferAddr) == 0) {
                        AtomicValue.or(avSyncControlAddr.getPointer(16), 1);
                    }
                }
                if (((audioFlag = AtomicValue.get(avSyncControlAddr.getPointer(16))) & 1) != 0) {
                    this.clearVblankSyncCount(avSyncControlAddr);
                    this.setVblankSyncInterval(avSyncControlAddr, 6);
                    AtomicValue.set(avSyncControlAddr.getPointer(12), 3);
                }
                result = this.getVideoDataPauseContinue(avSyncControlAddr, videoDataAddr);
                break;
            }
            default: {
                videoBufferAddr.setValue32(32, 0);
                result = -2141102068;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scePsmfPlayerGetVideoData returning 0x%X, audioFlag=0x%X, readyFlag=0x%X, avSyncControlAddr.getValue32(20)=%d", result, AtomicValue.get(avSyncControlAddr.getPointer(16)), AtomicValue.get(avSyncControlAddr.getPointer(12)), avSyncControlAddr.getValue32(20)));
        }
        return result;
    }

    @HLEFunction(nid=-1182496140, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetAudioData(@CheckArgument(value="checkPlayerPlaying") TPointer32 psmfPlayer, TPointer audioDataAddr) {
        int result;
        TPointer data = psmfPlayer.getPointer();
        TPointer avSyncControlAddr = data.getPointer(32);
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        TPointer audioBufferAddr = avSyncControlAddr.getPointer(28);
        int audioFlag = AtomicValue.get(avSyncControlAddr.getPointer(16));
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scePsmfPlayerGetAudioData audioFlag=0x%X", audioFlag));
        }
        if ((audioFlag & 3) != 3) {
            return -2141102068;
        }
        int numberUsedAudioBuffers = audioBufferAddr.getValue32(12);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("scePsmfPlayerGetAudioData numberUsedAudioBuffers=%d, avSyncControlAddr.getValue32(20)=%d", numberUsedAudioBuffers, avSyncControlAddr.getValue32(20)));
        }
        if (numberUsedAudioBuffers == 0) {
            return -2141102068;
        }
        if (avSyncControlAddr.getValue32(20) == 1) {
            int audioBufferIndex = audioBufferAddr.getValue32(4);
            TPointer audioDataArrayAddr = audioBufferAddr.getPointer(0);
            TPointer audioBuffer = audioDataArrayAddr.getPointer(audioBufferIndex * 8 + 0);
            int atracOutputSize = audioBufferAddr.getValue32(20);
            audioDataAddr.memcpy(audioBuffer, atracOutputSize);
            result = 0;
        } else {
            int numberUsedDisplayBuffers = videoBufferAddr.getValue32(16);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("scePsmfPlayerGetAudioData numberUsedDisplayBuffers=%d", numberUsedDisplayBuffers));
            }
            if (numberUsedDisplayBuffers == 0) {
                return -2141102068;
            }
            int displayBufferIndex = videoBufferAddr.getValue32(12);
            TPointer displayDataArrayAddr = videoBufferAddr.getPointer(4);
            int videoPts = displayDataArrayAddr.getValue32(displayBufferIndex * 8 + 4);
            int audioBufferIndex = audioBufferAddr.getValue32(4);
            TPointer audioDataArrayAddr = audioBufferAddr.getPointer(0);
            int audioPts = audioDataArrayAddr.getValue32(audioBufferIndex * 8 + 4);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("scePsmfPlayerGetAudioData videoPts=0x%X, audioPts=0x%X", videoPts, audioPts));
            }
            if (videoPts - audioPts <= 3003) {
                return -2141102068;
            }
            result = -2141102068;
        }
        this.consumeOneAudioBuffer(audioBufferAddr);
        return result;
    }

    @HLEFunction(nid=-118552410, version=150)
    public int scePsmfPlayerGetCurrentStatus(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        return playerStatus;
    }

    @HLEFunction(nid=-553085312, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetPsmfInfo(@CheckArgument(value="checkPlayerStandby") TPointer32 psmfPlayer, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=20, usage=BufferInfo.Usage.out) TPointer32 psmfInfoAddr) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer psmfControlAddr = data.getPointer(28);
        psmfInfoAddr.setValue(0, psmfControlAddr.getValue32(0));
        psmfInfoAddr.setValue(4, psmfControlAddr.getValue32(12));
        psmfInfoAddr.setValue(8, psmfControlAddr.getValue32(16));
        psmfInfoAddr.setValue(12, psmfControlAddr.getValue32(20));
        psmfInfoAddr.setValue(16, this.getPlayerVersion(playerStatusAddr));
        if (this.getModuleVersion() == 50922768) {
            TPointer psmf = new TPointer(psmfControlAddr, 24);
            TPointer32 psmf32 = new TPointer32(psmf);
            TPointer32 videoInfoBuffer = Utilities.allocatePointer32(8);
            int result = Modules.scePsmfModule.scePsmfGetVideoInfo(psmf32, videoInfoBuffer);
            if (result != 0) {
                return result;
            }
            int videoWidthAddr = Emulator.getProcessor().cpu._a2;
            int videoHeightAddr = Emulator.getProcessor().cpu._a3;
            if (videoWidthAddr != 0) {
                this.getMemory().write32(videoWidthAddr, videoInfoBuffer.getValue(0));
            }
            if (videoHeightAddr != 0) {
                this.getMemory().write32(videoHeightAddr, videoInfoBuffer.getValue(4));
            }
        }
        return 0;
    }

    @HLEFunction(nid=509061351, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerConfigPlayer(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer, int configMode, int configAttr) {
        int result;
        block12: {
            block13: {
                TPointer playerStatusAddr;
                TPointer data;
                block11: {
                    data = psmfPlayer.getPointer();
                    playerStatusAddr = data.getPointer(24);
                    result = 0;
                    if (configMode != 0) break block11;
                    if (configAttr != 0 && configAttr != 1) {
                        return -2141102072;
                    }
                    playerStatusAddr.setValue32(12, configAttr);
                    break block12;
                }
                if (configMode != 1) break block13;
                TPointer decodeControlAddr = data.getPointer(36);
                switch (configAttr) {
                    case -1: {
                        break;
                    }
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        TPointer32 modeAddr = Utilities.allocatePointer32(8);
                        modeAddr.setValue(0, -1);
                        if (decodeControlAddr.getValue32(68) != configAttr) {
                            decodeControlAddr.setValue32(68, configAttr);
                            modeAddr.setValue(4, configAttr);
                            TPointer mpeg = decodeControlAddr.getPointer(0);
                            TPointer32 mpeg32 = new TPointer32(mpeg);
                            result = Modules.sceMpegModule.sceMpegAvcDecodeMode(mpeg32, modeAddr);
                            if (log.isTraceEnabled()) {
                                log.trace((Object)String.format("scePsmfPlayerConfigPlayer: sceMpegAvcDecodeMode returned 0x%X", result));
                                break;
                            }
                        }
                        break block12;
                    }
                    case 4: {
                        TPointer yuv420Buffer = decodeControlAddr.getPointer(80);
                        if (yuv420Buffer.isNull()) {
                            return -2141102072;
                        }
                        if (this.getPlayerStatus(playerStatusAddr) != 1) {
                            return -2141102079;
                        }
                        if (decodeControlAddr.getValue32(68) != configAttr) {
                            decodeControlAddr.setValue32(68, configAttr);
                            break;
                        }
                        break block12;
                    }
                    default: {
                        return -2141102072;
                    }
                }
                break block12;
            }
            return -2141102074;
        }
        return result;
    }

    @HLEFunction(nid=-1546120855, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerChangePlayMode(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer, int playMode, int playSpeed) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        TPointer avSyncControlAddr = data.getPointer(32);
        TPointer decodeControlAddr = data.getPointer(36);
        TPointer psmfControlAddr = data.getPointer(28);
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        if (playerStatus != 4 && playerStatus != 512) {
            return -2141102079;
        }
        int oldPlayMode = playerStatusAddr.getValue32(4);
        int oldPlaySpeed = playerStatusAddr.getValue32(16);
        boolean needUpdate = false;
        switch (playMode) {
            case 0: {
                if (oldPlayMode == playMode) break;
                needUpdate = true;
                playSpeed = 1;
                break;
            }
            case 1: 
            case 2: {
                needUpdate = true;
                playSpeed = 1;
                break;
            }
            case 3: {
                if (oldPlayMode == playMode || oldPlayMode == 2) break;
                needUpdate = true;
                playSpeed = 1;
                break;
            }
            case 4: 
            case 5: {
                int playerVersion = this.getPlayerVersion(playerStatusAddr);
                if (playerVersion != 0) {
                    return -2141102077;
                }
                if (playSpeed < 1 || playSpeed > 3) {
                    return -2141102072;
                }
                if (oldPlayMode == playMode && oldPlaySpeed == playSpeed) break;
                needUpdate = true;
                break;
            }
            default: {
                return -2141102074;
            }
        }
        if (needUpdate) {
            if (oldPlayMode == 4 || oldPlayMode == 5 || playMode == 4 || playMode == 5) {
                TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
                int timestamp = videoBufferAddr.getValue32(40);
                AtomicValue.set(videoBufferAddr.getPointer(44), 2);
                videoBufferAddr.setValue32(8, 0);
                videoBufferAddr.setValue32(12, 0);
                videoBufferAddr.setValue32(16, 0);
                TPointer audioBufferAddr = avSyncControlAddr.getPointer(28);
                audioBufferAddr.setValue32(24, audioBufferAddr.getValue32(24) | 1);
                audioBufferAddr.setValue32(4, 0);
                audioBufferAddr.setValue32(8, 0);
                audioBufferAddr.setValue32(12, 0);
                if (playMode == 4) {
                    this.setTimestampWithDirection(decodeControlAddr, timestamp, playSpeed, 1);
                } else if (playMode == 5) {
                    this.setTimestampWithDirection(decodeControlAddr, timestamp, playSpeed, -1);
                } else {
                    this.setTimestamp(decodeControlAddr, timestamp);
                    AtomicValue.clear(avSyncControlAddr.getPointer(16), 3);
                    int numberOfAtracStreams = psmfControlAddr.getValue32(16);
                    if (numberOfAtracStreams > 0) {
                        avSyncControlAddr.setValue32(20, avSyncControlAddr.getValue32(20) | 1);
                    }
                }
            } else {
                AtomicValue.clear(avSyncControlAddr.getPointer(16), 3);
            }
            AtomicValue.set(avSyncControlAddr.getPointer(12), scePsmfPlayer.getReadyFlag(playMode, playSpeed));
            playerStatusAddr.setValue32(4, playMode);
            playerStatusAddr.setValue32(16, playSpeed);
        }
        return 0;
    }

    @HLEFunction(nid=1760588149, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentAudioStream(@CheckArgument(value="checkPlayerStandby") TPointer32 psmfPlayer, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 audioCodecAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 audioStreamNumAddr) {
        TPointer data = psmfPlayer.getPointer();
        TPointer psmfControlAddr = data.getPointer(28);
        audioCodecAddr.setValue(psmfControlAddr.getValue32(152));
        audioStreamNumAddr.setValue(psmfControlAddr.getValue32(156));
        return 0;
    }

    @HLEFunction(nid=-202397039, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentPlayMode(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 playModeAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 playSpeedAddr) {
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        playModeAddr.setValue(playerStatusAddr.getValue32(4));
        playSpeedAddr.setValue(playerStatusAddr.getValue32(16));
        return 0;
    }

    @HLEFunction(nid=1054220851, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentPts(@CheckArgument(value="checkPlayerStandby") TPointer32 psmfPlayer, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 currentPtsAddr) {
        TPointer data = psmfPlayer.getPointer();
        TPointer avSyncControlAddr = data.getPointer(32);
        TPointer videoBufferAddr = avSyncControlAddr.getPointer(24);
        TPointer psmfControlAddr = avSyncControlAddr.getPointer(44);
        if (videoBufferAddr.getValue32(32) == 0) {
            return -2141102068;
        }
        int currentPts = videoBufferAddr.getValue32(28) - psmfControlAddr.getValue32(4);
        currentPtsAddr.setValue(currentPts);
        return 0;
    }

    @HLEFunction(nid=-1611484441, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerGetCurrentVideoStream(@CheckArgument(value="checkPlayerStandby") TPointer32 psmfPlayer, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 videoCodecAddr, @BufferInfo(usage=BufferInfo.Usage.out) TPointer32 videoStreamNumAddr) {
        TPointer data = psmfPlayer.getPointer();
        TPointer psmfControlAddr = data.getPointer(28);
        videoCodecAddr.setValue(psmfControlAddr.getValue32(136));
        videoStreamNumAddr.setValue(psmfControlAddr.getValue32(140));
        return 0;
    }

    @HLEFunction(nid=736826729, version=150)
    public int scePsmfPlayerBreak(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer) {
        TPointer data = psmfPlayer.getPointer();
        TPointer readControlAddr = data.getPointer(48);
        return this.breakPsmf(readControlAddr);
    }

    @HLEFunction(nid=1992357038, version=150)
    public int scePsmfPlayerSetPsmfOffset(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer, PspString fileAddr, int offset) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, offset, false);
    }

    @HLEFunction(nid=-1490176775, version=150)
    public int scePsmfPlayerSetPsmfOffsetCB(@CheckArgument(value="checkPlayerInitialized0") TPointer32 psmfPlayer, PspString fileAddr, int offset) {
        return this.hlePsmfPlayerSetPsmf(psmfPlayer, fileAddr, offset, true);
    }

    @HLEFunction(nid=755912202, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSetTempBuf(TPointer32 psmfPlayer, @CanBeNull TPointer tempBufAddr, int tempBufSize) {
        if (tempBufAddr.isNotNull() && tempBufSize < 65536) {
            return -2141102072;
        }
        TPointer data = psmfPlayer.getPointer();
        TPointer playerStatusAddr = data.getPointer(24);
        int playerStatus = this.getPlayerStatus(playerStatusAddr);
        if (playerStatus != 1) {
            return -2141102079;
        }
        data.setPointer(64, tempBufAddr);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1978679202, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectSpecificVideo(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer, int videoCodec, int videoStreamNum) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-2059002113, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectSpecificAudio(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer, int audioCodec, int audioStreamNum) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1969308211, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectVideo(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1194259370, version=150, checkInsideInterrupt=true)
    public int scePsmfPlayerSelectAudio(@CheckArgument(value="checkPlayerInitialized") TPointer32 psmfPlayer) {
        return 0;
    }

    private static class AtomicValue {
        private AtomicValue() {
        }

        public static void or(TPointer addr, int value) {
            addr.setValue32(4, addr.getValue32(4) | value);
        }

        public static void set(TPointer addr, int value) {
            addr.setValue32(4, value);
        }

        public static void clear(TPointer addr, int value) {
            addr.setValue32(4, addr.getValue32(4) & ~value);
        }

        public static int get(TPointer addr) {
            return addr.getValue32(4);
        }
    }
}

