/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import jpcsp.crypto.AMCTRL;
import jpcsp.crypto.DRM;
import jpcsp.crypto.KIRK;
import jpcsp.crypto.PGD;
import jpcsp.crypto.PRX;
import jpcsp.crypto.SAVEDATA;
import jpcsp.settings.AbstractBoolSettingsListener;
import jpcsp.settings.Settings;
import org.apache.log4j.Logger;

public class CryptoEngine {
    public static Logger log = Logger.getLogger((String)"crypto");
    private static final String name = "CryptEngine";
    private static boolean isCryptoEngineInit;
    private static boolean cryptoSavedata;
    private static boolean extractEboot;
    private static boolean extractSavedataKey;
    private static KIRK kirk;
    private static PRX prx;
    private static SAVEDATA sd;
    private static AMCTRL amctrl;
    private static PGD pgd;
    private static DRM drm;
    private static CryptSavedataSettingsListerner cryptSavedataSettingsListerner;
    private static ExtractEbootSettingsListerner extractEbootSettingsListerner;
    private static ExtractSavedataKeySettingsListerner extractSavedataKeySettingsListerner;

    public CryptoEngine() {
        CryptoEngine.installSettingsListeners();
        CryptoEngine.setCryptoEngineStatus(true);
        kirk = new KIRK();
        prx = new PRX();
        sd = new SAVEDATA();
        amctrl = new AMCTRL();
        pgd = new PGD();
        drm = new DRM();
    }

    public KIRK getKIRKEngine() {
        return kirk;
    }

    public PRX getPRXEngine() {
        return prx;
    }

    public SAVEDATA getSAVEDATAEngine() {
        return sd;
    }

    public AMCTRL getAMCTRLEngine() {
        return amctrl;
    }

    public PGD getPGDEngine() {
        return pgd;
    }

    public DRM getDRMEngine() {
        return drm;
    }

    private static void installSettingsListeners() {
        if (cryptSavedataSettingsListerner == null) {
            cryptSavedataSettingsListerner = new CryptSavedataSettingsListerner();
            Settings.getInstance().registerSettingsListener(name, "emu.cryptoSavedata", cryptSavedataSettingsListerner);
        }
        if (extractEbootSettingsListerner == null) {
            extractEbootSettingsListerner = new ExtractEbootSettingsListerner();
            Settings.getInstance().registerSettingsListener(name, "emu.extractEboot", extractEbootSettingsListerner);
        }
        if (extractSavedataKeySettingsListerner == null) {
            extractSavedataKeySettingsListerner = new ExtractSavedataKeySettingsListerner();
            Settings.getInstance().registerSettingsListener(name, "emu.extractSavedataKey", extractSavedataKeySettingsListerner);
        }
    }

    public static boolean getCryptoEngineStatus() {
        return isCryptoEngineInit;
    }

    private static void setCryptoEngineStatus(boolean status) {
        isCryptoEngineInit = status;
    }

    public static boolean getExtractEbootStatus() {
        CryptoEngine.installSettingsListeners();
        return extractEboot;
    }

    private static void setExtractEbootStatus(boolean status) {
        extractEboot = status;
    }

    public static boolean getExtractSavedataKeyStatus() {
        CryptoEngine.installSettingsListeners();
        return extractSavedataKey;
    }

    private static void setExtractSavedataKeyStatus(boolean status) {
        extractSavedataKey = status;
    }

    public static boolean getSavedataCryptoStatus() {
        CryptoEngine.installSettingsListeners();
        return cryptoSavedata;
    }

    private static void setSavedataCryptoStatus(boolean status) {
        cryptoSavedata = status;
    }

    private static class ExtractSavedataKeySettingsListerner
    extends AbstractBoolSettingsListener {
        private ExtractSavedataKeySettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            CryptoEngine.setExtractSavedataKeyStatus(value);
        }
    }

    private static class ExtractEbootSettingsListerner
    extends AbstractBoolSettingsListener {
        private ExtractEbootSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            CryptoEngine.setExtractEbootStatus(value);
        }
    }

    private static class CryptSavedataSettingsListerner
    extends AbstractBoolSettingsListener {
        private CryptSavedataSettingsListerner() {
        }

        @Override
        protected void settingsValueChanged(boolean value) {
            CryptoEngine.setSavedataCryptoStatus(!value);
        }
    }
}

