/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.objects;

import java.util.Random;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import org.apache.log4j.Logger;

public class Math
extends BaseNativeObject {
    private static final Logger log = VSMX.log;
    public static final String objectName = "Math";
    private VSMXInterpreter interpreter;
    private Random random;

    public static VSMXNativeObject create(VSMXInterpreter interpreter) {
        Math math = new Math(interpreter);
        VSMXNativeObject object = new VSMXNativeObject(interpreter, math);
        math.setObject(object);
        object.setPropertyValue("PI", (VSMXBaseObject)new VSMXNumber(interpreter, (float)java.lang.Math.PI));
        return object;
    }

    private Math(VSMXInterpreter interpreter) {
        this.interpreter = interpreter;
        this.random = new Random();
    }

    public VSMXBaseObject random(VSMXBaseObject object) {
        float value = this.random.nextFloat();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Math.random() returns %f", Float.valueOf(value)));
        }
        return new VSMXNumber(this.interpreter, value);
    }

    public VSMXBaseObject floor(VSMXBaseObject object, VSMXBaseObject value) {
        return new VSMXNumber(this.interpreter, (float)java.lang.Math.floor(value.getFloatValue()));
    }

    public VSMXBaseObject abs(VSMXBaseObject object, VSMXBaseObject value) {
        return new VSMXNumber(this.interpreter, java.lang.Math.abs(value.getFloatValue()));
    }

    public VSMXBaseObject sin(VSMXBaseObject object, VSMXBaseObject value) {
        return new VSMXNumber(this.interpreter, (float)java.lang.Math.sin(value.getFloatValue()));
    }

    public VSMXBaseObject cos(VSMXBaseObject object, VSMXBaseObject value) {
        return new VSMXNumber(this.interpreter, (float)java.lang.Math.cos(value.getFloatValue()));
    }
}

