/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import java.nio.Buffer;
import java.nio.IntBuffer;
import java.util.Arrays;
import jpcsp.graphics.GeContext;
import jpcsp.graphics.RE.BaseRenderingEngineProxy;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.buffer.IREBufferManager;
import jpcsp.graphics.VertexInfo;
import jpcsp.graphics.VideoEngine;
import jpcsp.util.CpuDurationStatistics;
import jpcsp.util.DurationStatistics;

public class StatisticsProxy
extends BaseRenderingEngineProxy {
    private DurationStatistics[] statistics;

    public StatisticsProxy(IRenderingEngine proxy) {
        super(proxy);
        this.addStatistic("attachShader", 0);
        this.addStatistic("beginBoundingBox", 1);
        this.addStatistic("beginQuery", 3);
        this.addStatistic("bindBuffer", 4);
        this.addStatistic("bindBufferBase", 5);
        this.addStatistic("bindFramebuffer", 6);
        this.addStatistic("bindRenderbuffer", 7);
        this.addStatistic("bindTexture", 8);
        this.addStatistic("canAllNativeVertexInfo", 9);
        this.addStatistic("canNativeSpritesPrimitive", 10);
        this.addStatistic("clear", 11);
        this.addStatistic("compilerShader", 12);
        this.addStatistic("copyTexSubImage", 13);
        this.addStatistic("createProgram", 14);
        this.addStatistic("createShader", 15);
        this.addStatistic("deleteBuffer", 16);
        this.addStatistic("deleteFramebuffer", 17);
        this.addStatistic("deleteRenderbuffer", 18);
        this.addStatistic("deleteTexture", 19);
        this.addStatistic("disableClientState", 20);
        this.addStatistic("disableFlag", 21);
        this.addStatistic("disableVertexAttribArray", 22);
        this.addStatistic("drawArrays", 23);
        this.addStatistic("drawBoundingBox", 24);
        this.addStatistic("enableClientState", 31);
        this.addStatistic("enableFlag", 32);
        this.addStatistic("enableVertexAttribArray", 33);
        this.addStatistic("endBoundingBox", 34);
        this.addStatistic("endClearMode", 35);
        this.addStatistic("endDirectRendering", 36);
        this.addStatistic("endDisplay", 37);
        this.addStatistic("endModelViewMatrixUpdate", 39);
        this.addStatistic("endQuery", 40);
        this.addStatistic("genBuffer", 41);
        this.addStatistic("genFramebuffer", 42);
        this.addStatistic("genQuery", 43);
        this.addStatistic("genRenderbuffer", 44);
        this.addStatistic("genTexture", 45);
        this.addStatistic("getAttribLocation", 46);
        this.addStatistic("getBufferManager", 47);
        this.addStatistic("getProgramInfoLog", 48);
        this.addStatistic("getQueryResult", 49);
        this.addStatistic("getQueryResultAvailable", 50);
        this.addStatistic("getShaderInfoLog", 51);
        this.addStatistic("getTexImage", 52);
        this.addStatistic("getUniformBlockIndex", 53);
        this.addStatistic("getUniformLocation", 54);
        this.addStatistic("isBoundingBoxVisible", 56);
        this.addStatistic("isExtensionAvailable", 57);
        this.addStatistic("isFramebufferObjectAvailable", 58);
        this.addStatistic("isQueryAvailable", 59);
        this.addStatistic("isShaderAvailable", 60);
        this.addStatistic("linkProgram", 61);
        this.addStatistic("setAlphaFunc", 63);
        this.addStatistic("setBlendColor", 64);
        this.addStatistic("setBlendEquation", 65);
        this.addStatistic("setBlendFunc", 66);
        this.addStatistic("setBones", 67);
        this.addStatistic("setBufferData", 68);
        this.addStatistic("setBufferSubData", 69);
        this.addStatistic("setColorMask", 70);
        this.addStatistic("setColorMask", 71);
        this.addStatistic("setColorMaterial", 72);
        this.addStatistic("setColorPointer", 73);
        this.addStatistic("setColorPointer", 74);
        this.addStatistic("setColorTestFunc", 75);
        this.addStatistic("setColorTestMask", 76);
        this.addStatistic("setColorTestReference", 77);
        this.addStatistic("setCompressedTexImage", 78);
        this.addStatistic("setDepthFunc", 79);
        this.addStatistic("setDepthMask", 80);
        this.addStatistic("setDepthRange", 81);
        this.addStatistic("setFogColor", 82);
        this.addStatistic("setFogDist", 83);
        this.addStatistic("setFogHint", 84);
        this.addStatistic("setFramebufferRenderbuffer", 85);
        this.addStatistic("setFramebufferTexture", 86);
        this.addStatistic("setFrontFace", 87);
        this.addStatistic("setGeContext", 88);
        this.addStatistic("setLightAmbientColor", 89);
        this.addStatistic("setLightColor", 90);
        this.addStatistic("setLightConstantAttenuation", 91);
        this.addStatistic("setLightDiffuseColor", 92);
        this.addStatistic("setLightDirection", 93);
        this.addStatistic("setLightLinearAttenuation", 94);
        this.addStatistic("setLightMode", 95);
        this.addStatistic("setLightModelAmbientColor", 96);
        this.addStatistic("setLightPosition", 97);
        this.addStatistic("setLightQuadraticAttenuation", 98);
        this.addStatistic("setLightSpecularColor", 99);
        this.addStatistic("setLightSpotCutoff", 100);
        this.addStatistic("setLightSpotExponent", 101);
        this.addStatistic("setLightType", 102);
        this.addStatistic("setLineSmoothHint", 103);
        this.addStatistic("setLogicOp", 104);
        this.addStatistic("setMaterialAmbientColor", 105);
        this.addStatistic("setMaterialColor", 106);
        this.addStatistic("setMaterialDiffuseColor", 107);
        this.addStatistic("setMaterialEmissiveColor", 108);
        this.addStatistic("setMaterialShininess", 109);
        this.addStatistic("setMaterialSpecularColor", 110);
        this.addStatistic("setMatrix", 111);
        this.addStatistic("setModelMatrix", 112);
        this.addStatistic("setModelViewMatrix", 113);
        this.addStatistic("setMorphWeight", 114);
        this.addStatistic("setNormalPointer", 115);
        this.addStatistic("setNormalPointer", 116);
        this.addStatistic("setPatchDiv", 117);
        this.addStatistic("setPatchPrim", 118);
        this.addStatistic("setPixelStore", 119);
        this.addStatistic("setProgramParameter", 120);
        this.addStatistic("setProjectionMatrix", 121);
        this.addStatistic("setRenderbufferStorage", 122);
        this.addStatistic("setRenderingEngine", 123);
        this.addStatistic("setScissor", 124);
        this.addStatistic("setShadeModel", 125);
        this.addStatistic("setStencilFunc", 126);
        this.addStatistic("setStencilOp", 127);
        this.addStatistic("setTexCoordPointer", 128);
        this.addStatistic("setTexCoordPointer", 129);
        this.addStatistic("setTexEnv", 130);
        this.addStatistic("setTexEnv", 131);
        this.addStatistic("setTexImage", 132);
        this.addStatistic("setTexSubImage", 133);
        this.addStatistic("setTextureEnvColor", 134);
        this.addStatistic("setTextureEnvironmentMapping", 135);
        this.addStatistic("setTextureFunc", 136);
        this.addStatistic("setTextureMapMode", 137);
        this.addStatistic("setTextureMatrix", 138);
        this.addStatistic("setTextureMipmapMagFilter", 139);
        this.addStatistic("setTextureMipmapMaxLevel", 140);
        this.addStatistic("setTextureMipmapMinFilter", 141);
        this.addStatistic("setTextureMipmapMinLevel", 142);
        this.addStatistic("setTextureWrapMode", 143);
        this.addStatistic("setUniform", 144);
        this.addStatistic("setUniform", 145);
        this.addStatistic("setUniform", 146);
        this.addStatistic("setUniform2", 147);
        this.addStatistic("setUniform3", 148);
        this.addStatistic("setUniform4", 149);
        this.addStatistic("setUniformBlockBinding", 150);
        this.addStatistic("setUniformMatrix4", 151);
        this.addStatistic("setVertexAttribPointer", 152);
        this.addStatistic("setVertexAttribPointer", 153);
        this.addStatistic("setVertexColor", 154);
        this.addStatistic("setVertexInfo", 155);
        this.addStatistic("setVertexPointer", 156);
        this.addStatistic("setVertexPointer", 157);
        this.addStatistic("setViewMatrix", 158);
        this.addStatistic("setViewport", 159);
        this.addStatistic("setWeightPointer", 160);
        this.addStatistic("setWeightPointer", 161);
        this.addStatistic("startClearMode", 162);
        this.addStatistic("startDirectRendering", 163);
        this.addStatistic("startDisplay", 164);
        this.addStatistic("useProgram", 165);
        this.addStatistic("validateProgram", 166);
        this.addStatistic("bindVertexArray", 167);
        this.addStatistic("deleteVertexArray", 168);
        this.addStatistic("genVertexArray", 169);
        this.addStatistic("isVertexArrayAvailable", 170);
        this.addStatistic("multiDrawArrays", 171);
        this.addStatistic("multMatrix", 172);
        this.addStatistic("setMatrix", 173);
        this.addStatistic("setMatrixMode", 174);
        this.addStatistic("setPixelTransfer", 175);
        this.addStatistic("setPixelTransfer", 176);
        this.addStatistic("setPixelTransfer", 177);
        this.addStatistic("setPixelMap", 178);
        this.addStatistic("canNativeClut", 179);
        this.addStatistic("setActiveTexture", 180);
        this.addStatistic("setTextureFormat", 181);
        this.addStatistic("getUniformIndex", 182);
        this.addStatistic("getUniformIndices", 183);
        this.addStatistic("getActiveUniformOffset", 184);
        this.addStatistic("bindAttribLocation", 185);
        this.addStatistic("setUniform4", 186);
        this.addStatistic("drawArraysBurstMode", 187);
        this.addStatistic("bindActiveTexture", 188);
        this.addStatistic("setTextureAnisotropy", 189);
        this.addStatistic("getMaxTextureAnisotropy", 190);
        this.addStatistic("getShadingLanguageVersion", 191);
        this.addStatistic("setBlendSFix", 192);
        this.addStatistic("setBlendDFix", 193);
        this.addStatistic("setUniform3", 194);
        this.addStatistic("waitForRenderingCompletion", 195);
        this.addStatistic("canReadAllVertexInfo", 196);
        this.addStatistic("readStencil", 197);
        this.addStatistic("blitFramebuffer", 198);
        this.addStatistic("checkErrors", 199);
        this.addStatistic("setCopyRedToAlpha", 200);
        this.addStatistic("drawElements", 201);
        this.addStatistic("drawElements", 202);
        this.addStatistic("multiDrawElements", 203);
        this.addStatistic("drawElementsBurstMode", 204);
    }

    private void addStatistic(String name, int index) {
        if (this.statistics == null || index >= this.statistics.length) {
            DurationStatistics[] newStatistics = new DurationStatistics[index + 1];
            if (this.statistics != null) {
                System.arraycopy(this.statistics, 0, newStatistics, 0, this.statistics.length);
            }
            this.statistics = newStatistics;
        }
        this.statistics[index] = new CpuDurationStatistics(String.format("%-30s", name));
    }

    @Override
    public void exit() {
        int i;
        Arrays.sort(this.statistics);
        VideoEngine.log.info((Object)"RenderingEngine methods:");
        int lastStatistics = -1;
        for (i = this.statistics.length - 1; i >= 0; --i) {
            if (this.statistics[i].numberCalls <= 0L) continue;
            lastStatistics = i;
            break;
        }
        for (i = 0; i <= lastStatistics; ++i) {
            DurationStatistics statistic = this.statistics[i];
            if (statistic.numberCalls == 0L) break;
            VideoEngine.log.info((Object)("    " + statistic));
        }
        super.exit();
    }

    @Override
    public void attachShader(int program, int shader) {
        DurationStatistics statistic = this.statistics[0];
        statistic.start();
        super.attachShader(program, shader);
        statistic.end();
    }

    @Override
    public void beginBoundingBox(int numberOfVertexBoundingBox) {
        DurationStatistics statistic = this.statistics[1];
        statistic.start();
        super.beginBoundingBox(numberOfVertexBoundingBox);
        statistic.end();
    }

    @Override
    public void beginQuery(int id) {
        DurationStatistics statistic = this.statistics[3];
        statistic.start();
        super.beginQuery(id);
        statistic.end();
    }

    @Override
    public void bindBuffer(int target, int buffer) {
        DurationStatistics statistic = this.statistics[4];
        statistic.start();
        super.bindBuffer(target, buffer);
        statistic.end();
    }

    @Override
    public void bindBufferBase(int target, int bindingPoint, int buffer) {
        DurationStatistics statistic = this.statistics[5];
        statistic.start();
        super.bindBufferBase(target, bindingPoint, buffer);
        statistic.end();
    }

    @Override
    public void bindFramebuffer(int target, int framebuffer) {
        DurationStatistics statistic = this.statistics[6];
        statistic.start();
        super.bindFramebuffer(target, framebuffer);
        statistic.end();
    }

    @Override
    public void bindRenderbuffer(int renderbuffer) {
        DurationStatistics statistic = this.statistics[7];
        statistic.start();
        super.bindRenderbuffer(renderbuffer);
        statistic.end();
    }

    @Override
    public void bindTexture(int texture) {
        DurationStatistics statistic = this.statistics[8];
        statistic.start();
        super.bindTexture(texture);
        statistic.end();
    }

    @Override
    public boolean canAllNativeVertexInfo() {
        DurationStatistics statistic = this.statistics[9];
        statistic.start();
        boolean value = super.canAllNativeVertexInfo();
        statistic.end();
        return value;
    }

    @Override
    public boolean canNativeSpritesPrimitive() {
        DurationStatistics statistic = this.statistics[10];
        statistic.start();
        boolean value = super.canNativeSpritesPrimitive();
        statistic.end();
        return value;
    }

    @Override
    public void clear(float red, float green, float blue, float alpha) {
        DurationStatistics statistic = this.statistics[11];
        statistic.start();
        super.clear(red, green, blue, alpha);
        statistic.end();
    }

    @Override
    public boolean compilerShader(int shader, String source) {
        DurationStatistics statistic = this.statistics[12];
        statistic.start();
        boolean value = super.compilerShader(shader, source);
        statistic.end();
        return value;
    }

    @Override
    public void copyTexSubImage(int level, int offset, int offset2, int x, int y, int width, int height) {
        DurationStatistics statistic = this.statistics[13];
        statistic.start();
        super.copyTexSubImage(level, offset, offset2, x, y, width, height);
        statistic.end();
    }

    @Override
    public int createProgram() {
        DurationStatistics statistic = this.statistics[14];
        statistic.start();
        int value = super.createProgram();
        statistic.end();
        return value;
    }

    @Override
    public int createShader(int type) {
        DurationStatistics statistic = this.statistics[15];
        statistic.start();
        int value = super.createShader(type);
        statistic.end();
        return value;
    }

    @Override
    public void deleteBuffer(int buffer) {
        DurationStatistics statistic = this.statistics[16];
        statistic.start();
        super.deleteBuffer(buffer);
        statistic.end();
    }

    @Override
    public void deleteFramebuffer(int framebuffer) {
        DurationStatistics statistic = this.statistics[17];
        statistic.start();
        super.deleteFramebuffer(framebuffer);
        statistic.end();
    }

    @Override
    public void deleteRenderbuffer(int renderbuffer) {
        DurationStatistics statistic = this.statistics[18];
        statistic.start();
        super.deleteRenderbuffer(renderbuffer);
        statistic.end();
    }

    @Override
    public void deleteTexture(int texture) {
        DurationStatistics statistic = this.statistics[19];
        statistic.start();
        super.deleteTexture(texture);
        statistic.end();
    }

    @Override
    public void disableClientState(int type) {
        DurationStatistics statistic = this.statistics[20];
        statistic.start();
        super.disableClientState(type);
        statistic.end();
    }

    @Override
    public void disableFlag(int flag) {
        DurationStatistics statistic = this.statistics[21];
        statistic.start();
        super.disableFlag(flag);
        statistic.end();
    }

    @Override
    public void disableVertexAttribArray(int id) {
        DurationStatistics statistic = this.statistics[22];
        statistic.start();
        super.disableVertexAttribArray(id);
        statistic.end();
    }

    @Override
    public void drawArrays(int type, int first, int count) {
        DurationStatistics statistic = this.statistics[23];
        statistic.start();
        super.drawArrays(type, first, count);
        statistic.end();
    }

    @Override
    public void drawBoundingBox(float[][] values) {
        DurationStatistics statistic = this.statistics[24];
        statistic.start();
        super.drawBoundingBox(values);
        statistic.end();
    }

    @Override
    public void enableClientState(int type) {
        DurationStatistics statistic = this.statistics[31];
        statistic.start();
        super.enableClientState(type);
        statistic.end();
    }

    @Override
    public void enableFlag(int flag) {
        DurationStatistics statistic = this.statistics[32];
        statistic.start();
        super.enableFlag(flag);
        statistic.end();
    }

    @Override
    public void enableVertexAttribArray(int id) {
        DurationStatistics statistic = this.statistics[33];
        statistic.start();
        super.enableVertexAttribArray(id);
        statistic.end();
    }

    @Override
    public void endBoundingBox(VertexInfo vinfo) {
        DurationStatistics statistic = this.statistics[34];
        statistic.start();
        super.endBoundingBox(vinfo);
        statistic.end();
    }

    @Override
    public void endClearMode() {
        DurationStatistics statistic = this.statistics[35];
        statistic.start();
        super.endClearMode();
        statistic.end();
    }

    @Override
    public void endDirectRendering() {
        DurationStatistics statistic = this.statistics[36];
        statistic.start();
        super.endDirectRendering();
        statistic.end();
    }

    @Override
    public void endDisplay() {
        DurationStatistics statistic = this.statistics[37];
        statistic.start();
        super.endDisplay();
        statistic.end();
    }

    @Override
    public void endModelViewMatrixUpdate() {
        DurationStatistics statistic = this.statistics[39];
        statistic.start();
        super.endModelViewMatrixUpdate();
        statistic.end();
    }

    @Override
    public void endQuery() {
        DurationStatistics statistic = this.statistics[40];
        statistic.start();
        super.endQuery();
        statistic.end();
    }

    @Override
    public int genBuffer() {
        DurationStatistics statistic = this.statistics[41];
        statistic.start();
        int value = super.genBuffer();
        statistic.end();
        return value;
    }

    @Override
    public int genFramebuffer() {
        DurationStatistics statistic = this.statistics[42];
        statistic.start();
        int value = super.genFramebuffer();
        statistic.end();
        return value;
    }

    @Override
    public int genQuery() {
        DurationStatistics statistic = this.statistics[43];
        statistic.start();
        int value = super.genQuery();
        statistic.end();
        return value;
    }

    @Override
    public int genRenderbuffer() {
        DurationStatistics statistic = this.statistics[44];
        statistic.start();
        int value = super.genRenderbuffer();
        statistic.end();
        return value;
    }

    @Override
    public int genTexture() {
        DurationStatistics statistic = this.statistics[45];
        statistic.start();
        int value = super.genTexture();
        statistic.end();
        return value;
    }

    @Override
    public int getAttribLocation(int program, String name) {
        DurationStatistics statistic = this.statistics[46];
        statistic.start();
        int value = super.getAttribLocation(program, name);
        statistic.end();
        return value;
    }

    @Override
    public IREBufferManager getBufferManager() {
        DurationStatistics statistic = this.statistics[47];
        statistic.start();
        IREBufferManager value = super.getBufferManager();
        statistic.end();
        return value;
    }

    @Override
    public String getProgramInfoLog(int program) {
        DurationStatistics statistic = this.statistics[48];
        statistic.start();
        String value = super.getProgramInfoLog(program);
        statistic.end();
        return value;
    }

    @Override
    public int getQueryResult(int id) {
        DurationStatistics statistic = this.statistics[49];
        statistic.start();
        int value = super.getQueryResult(id);
        statistic.end();
        return value;
    }

    @Override
    public boolean getQueryResultAvailable(int id) {
        DurationStatistics statistic = this.statistics[50];
        statistic.start();
        boolean value = super.getQueryResultAvailable(id);
        statistic.end();
        return value;
    }

    @Override
    public String getShaderInfoLog(int shader) {
        DurationStatistics statistic = this.statistics[51];
        statistic.start();
        String value = super.getShaderInfoLog(shader);
        statistic.end();
        return value;
    }

    @Override
    public void getTexImage(int level, int format, int type, Buffer buffer) {
        DurationStatistics statistic = this.statistics[52];
        statistic.start();
        super.getTexImage(level, format, type, buffer);
        statistic.end();
    }

    @Override
    public int getUniformBlockIndex(int program, String name) {
        DurationStatistics statistic = this.statistics[53];
        statistic.start();
        int value = super.getUniformBlockIndex(program, name);
        statistic.end();
        return value;
    }

    @Override
    public int getUniformLocation(int program, String name) {
        DurationStatistics statistic = this.statistics[54];
        statistic.start();
        int value = super.getUniformLocation(program, name);
        statistic.end();
        return value;
    }

    @Override
    public boolean isBoundingBoxVisible() {
        DurationStatistics statistic = this.statistics[56];
        statistic.start();
        boolean value = super.isBoundingBoxVisible();
        statistic.end();
        return value;
    }

    @Override
    public boolean isExtensionAvailable(String name) {
        DurationStatistics statistic = this.statistics[57];
        statistic.start();
        boolean value = super.isExtensionAvailable(name);
        statistic.end();
        return value;
    }

    @Override
    public boolean isFramebufferObjectAvailable() {
        DurationStatistics statistic = this.statistics[58];
        statistic.start();
        boolean value = super.isFramebufferObjectAvailable();
        statistic.end();
        return value;
    }

    @Override
    public boolean isQueryAvailable() {
        DurationStatistics statistic = this.statistics[59];
        statistic.start();
        boolean value = super.isQueryAvailable();
        statistic.end();
        return value;
    }

    @Override
    public boolean isShaderAvailable() {
        DurationStatistics statistic = this.statistics[60];
        statistic.start();
        boolean value = super.isShaderAvailable();
        statistic.end();
        return value;
    }

    @Override
    public boolean linkProgram(int program) {
        DurationStatistics statistic = this.statistics[61];
        statistic.start();
        boolean value = super.linkProgram(program);
        statistic.end();
        return value;
    }

    @Override
    public void setAlphaFunc(int func, int ref, int mask) {
        DurationStatistics statistic = this.statistics[63];
        statistic.start();
        super.setAlphaFunc(func, ref, mask);
        statistic.end();
    }

    @Override
    public void setBlendColor(float[] color) {
        DurationStatistics statistic = this.statistics[64];
        statistic.start();
        super.setBlendColor(color);
        statistic.end();
    }

    @Override
    public void setBlendEquation(int mode) {
        DurationStatistics statistic = this.statistics[65];
        statistic.start();
        super.setBlendEquation(mode);
        statistic.end();
    }

    @Override
    public void setBlendFunc(int src, int dst) {
        DurationStatistics statistic = this.statistics[66];
        statistic.start();
        super.setBlendFunc(src, dst);
        statistic.end();
    }

    @Override
    public int setBones(int count, float[] values) {
        DurationStatistics statistic = this.statistics[67];
        statistic.start();
        int value = super.setBones(count, values);
        statistic.end();
        return value;
    }

    @Override
    public void setBufferData(int target, int size, Buffer buffer, int usage) {
        DurationStatistics statistic = this.statistics[68];
        statistic.start();
        super.setBufferData(target, size, buffer, usage);
        statistic.end();
    }

    @Override
    public void setBufferSubData(int target, int offset, int size, Buffer buffer) {
        DurationStatistics statistic = this.statistics[69];
        statistic.start();
        super.setBufferSubData(target, offset, size, buffer);
        statistic.end();
    }

    @Override
    public void setColorMask(boolean redWriteEnabled, boolean greenWriteEnabled, boolean blueWriteEnabled, boolean alphaWriteEnabled) {
        DurationStatistics statistic = this.statistics[70];
        statistic.start();
        super.setColorMask(redWriteEnabled, greenWriteEnabled, blueWriteEnabled, alphaWriteEnabled);
        statistic.end();
    }

    @Override
    public void setColorMask(int redMask, int greenMask, int blueMask, int alphaMask) {
        DurationStatistics statistic = this.statistics[71];
        statistic.start();
        super.setColorMask(redMask, greenMask, blueMask, alphaMask);
        statistic.end();
    }

    @Override
    public void setColorMaterial(boolean ambient, boolean diffuse, boolean specular) {
        DurationStatistics statistic = this.statistics[72];
        statistic.start();
        super.setColorMaterial(ambient, diffuse, specular);
        statistic.end();
    }

    @Override
    public void setColorPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[73];
        statistic.start();
        super.setColorPointer(size, type, stride, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void setColorPointer(int size, int type, int stride, long offset) {
        DurationStatistics statistic = this.statistics[74];
        statistic.start();
        super.setColorPointer(size, type, stride, offset);
        statistic.end();
    }

    @Override
    public void setColorTestFunc(int func) {
        DurationStatistics statistic = this.statistics[75];
        statistic.start();
        super.setColorTestFunc(func);
        statistic.end();
    }

    @Override
    public void setColorTestMask(int[] values) {
        DurationStatistics statistic = this.statistics[76];
        statistic.start();
        super.setColorTestMask(values);
        statistic.end();
    }

    @Override
    public void setColorTestReference(int[] values) {
        DurationStatistics statistic = this.statistics[77];
        statistic.start();
        super.setColorTestReference(values);
        statistic.end();
    }

    @Override
    public void setCompressedTexImage(int level, int internalFormat, int width, int height, int compressedSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[78];
        statistic.start();
        super.setCompressedTexImage(level, internalFormat, width, height, compressedSize, buffer);
        statistic.end();
    }

    @Override
    public void setDepthFunc(int func) {
        DurationStatistics statistic = this.statistics[79];
        statistic.start();
        super.setDepthFunc(func);
        statistic.end();
    }

    @Override
    public void setDepthMask(boolean depthWriteEnabled) {
        DurationStatistics statistic = this.statistics[80];
        statistic.start();
        super.setDepthMask(depthWriteEnabled);
        statistic.end();
    }

    @Override
    public void setDepthRange(float zpos, float zscale, int near, int far) {
        DurationStatistics statistic = this.statistics[81];
        statistic.start();
        super.setDepthRange(zpos, zscale, near, far);
        statistic.end();
    }

    @Override
    public void setFogColor(float[] color) {
        DurationStatistics statistic = this.statistics[82];
        statistic.start();
        super.setFogColor(color);
        statistic.end();
    }

    @Override
    public void setFogDist(float start, float end) {
        DurationStatistics statistic = this.statistics[83];
        statistic.start();
        super.setFogDist(start, end);
        statistic.end();
    }

    @Override
    public void setFogHint() {
        DurationStatistics statistic = this.statistics[84];
        statistic.start();
        super.setFogHint();
        statistic.end();
    }

    @Override
    public void setFramebufferRenderbuffer(int target, int attachment, int renderbuffer) {
        DurationStatistics statistic = this.statistics[85];
        statistic.start();
        super.setFramebufferRenderbuffer(target, attachment, renderbuffer);
        statistic.end();
    }

    @Override
    public void setFramebufferTexture(int target, int attachment, int texture, int level) {
        DurationStatistics statistic = this.statistics[86];
        statistic.start();
        super.setFramebufferTexture(target, attachment, texture, level);
        statistic.end();
    }

    @Override
    public void setFrontFace(boolean cw) {
        DurationStatistics statistic = this.statistics[87];
        statistic.start();
        super.setFrontFace(cw);
        statistic.end();
    }

    @Override
    public void setGeContext(GeContext context) {
        DurationStatistics statistic = this.statistics[88];
        statistic.start();
        super.setGeContext(context);
        statistic.end();
    }

    @Override
    public void setLightAmbientColor(int light, float[] color) {
        DurationStatistics statistic = this.statistics[89];
        statistic.start();
        super.setLightAmbientColor(light, color);
        statistic.end();
    }

    @Override
    public void setLightConstantAttenuation(int light, float constant) {
        DurationStatistics statistic = this.statistics[91];
        statistic.start();
        super.setLightConstantAttenuation(light, constant);
        statistic.end();
    }

    @Override
    public void setLightDiffuseColor(int light, float[] color) {
        DurationStatistics statistic = this.statistics[92];
        statistic.start();
        super.setLightDiffuseColor(light, color);
        statistic.end();
    }

    @Override
    public void setLightDirection(int light, float[] direction) {
        DurationStatistics statistic = this.statistics[93];
        statistic.start();
        super.setLightDirection(light, direction);
        statistic.end();
    }

    @Override
    public void setLightLinearAttenuation(int light, float linear) {
        DurationStatistics statistic = this.statistics[94];
        statistic.start();
        super.setLightLinearAttenuation(light, linear);
        statistic.end();
    }

    @Override
    public void setLightMode(int mode) {
        DurationStatistics statistic = this.statistics[95];
        statistic.start();
        super.setLightMode(mode);
        statistic.end();
    }

    @Override
    public void setLightModelAmbientColor(float[] color) {
        DurationStatistics statistic = this.statistics[96];
        statistic.start();
        super.setLightModelAmbientColor(color);
        statistic.end();
    }

    @Override
    public void setLightPosition(int light, float[] position) {
        DurationStatistics statistic = this.statistics[97];
        statistic.start();
        super.setLightPosition(light, position);
        statistic.end();
    }

    @Override
    public void setLightQuadraticAttenuation(int light, float quadratic) {
        DurationStatistics statistic = this.statistics[98];
        statistic.start();
        super.setLightQuadraticAttenuation(light, quadratic);
        statistic.end();
    }

    @Override
    public void setLightSpecularColor(int light, float[] color) {
        DurationStatistics statistic = this.statistics[99];
        statistic.start();
        super.setLightSpecularColor(light, color);
        statistic.end();
    }

    @Override
    public void setLightSpotCutoff(int light, float cutoff) {
        DurationStatistics statistic = this.statistics[100];
        statistic.start();
        super.setLightSpotCutoff(light, cutoff);
        statistic.end();
    }

    @Override
    public void setLightSpotExponent(int light, float exponent) {
        DurationStatistics statistic = this.statistics[101];
        statistic.start();
        super.setLightSpotExponent(light, exponent);
        statistic.end();
    }

    @Override
    public void setLightType(int light, int type, int kind) {
        DurationStatistics statistic = this.statistics[102];
        statistic.start();
        super.setLightType(light, type, kind);
        statistic.end();
    }

    @Override
    public void setLineSmoothHint() {
        DurationStatistics statistic = this.statistics[103];
        statistic.start();
        super.setLineSmoothHint();
        statistic.end();
    }

    @Override
    public void setLogicOp(int logicOp) {
        DurationStatistics statistic = this.statistics[104];
        statistic.start();
        super.setLogicOp(logicOp);
        statistic.end();
    }

    @Override
    public void setMaterialAmbientColor(float[] color) {
        DurationStatistics statistic = this.statistics[105];
        statistic.start();
        super.setMaterialAmbientColor(color);
        statistic.end();
    }

    @Override
    public void setMaterialDiffuseColor(float[] color) {
        DurationStatistics statistic = this.statistics[107];
        statistic.start();
        super.setMaterialDiffuseColor(color);
        statistic.end();
    }

    @Override
    public void setMaterialEmissiveColor(float[] color) {
        DurationStatistics statistic = this.statistics[108];
        statistic.start();
        super.setMaterialEmissiveColor(color);
        statistic.end();
    }

    @Override
    public void setMaterialShininess(float shininess) {
        DurationStatistics statistic = this.statistics[109];
        statistic.start();
        super.setMaterialShininess(shininess);
        statistic.end();
    }

    @Override
    public void setMaterialSpecularColor(float[] color) {
        DurationStatistics statistic = this.statistics[110];
        statistic.start();
        super.setMaterialSpecularColor(color);
        statistic.end();
    }

    @Override
    public void setModelMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[112];
        statistic.start();
        super.setModelMatrix(values);
        statistic.end();
    }

    @Override
    public void setModelViewMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[113];
        statistic.start();
        super.setModelViewMatrix(values);
        statistic.end();
    }

    @Override
    public void setMorphWeight(int index, float value) {
        DurationStatistics statistic = this.statistics[114];
        statistic.start();
        super.setMorphWeight(index, value);
        statistic.end();
    }

    @Override
    public void setNormalPointer(int type, int stride, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[115];
        statistic.start();
        super.setNormalPointer(type, stride, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void setNormalPointer(int type, int stride, long offset) {
        DurationStatistics statistic = this.statistics[116];
        statistic.start();
        super.setNormalPointer(type, stride, offset);
        statistic.end();
    }

    @Override
    public void setPatchDiv(int s, int t) {
        DurationStatistics statistic = this.statistics[117];
        statistic.start();
        super.setPatchDiv(s, t);
        statistic.end();
    }

    @Override
    public void setPatchPrim(int prim) {
        DurationStatistics statistic = this.statistics[118];
        statistic.start();
        super.setPatchPrim(prim);
        statistic.end();
    }

    @Override
    public void setPixelStore(int rowLength, int alignment) {
        DurationStatistics statistic = this.statistics[119];
        statistic.start();
        super.setPixelStore(rowLength, alignment);
        statistic.end();
    }

    @Override
    public void setProgramParameter(int program, int parameter, int value) {
        DurationStatistics statistic = this.statistics[120];
        statistic.start();
        super.setProgramParameter(program, parameter, value);
        statistic.end();
    }

    @Override
    public void setProjectionMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[121];
        statistic.start();
        super.setProjectionMatrix(values);
        statistic.end();
    }

    @Override
    public void setRenderbufferStorage(int internalFormat, int width, int height) {
        DurationStatistics statistic = this.statistics[122];
        statistic.start();
        super.setRenderbufferStorage(internalFormat, width, height);
        statistic.end();
    }

    @Override
    public void setRenderingEngine(IRenderingEngine re) {
        DurationStatistics statistic = this.statistics[123];
        statistic.start();
        super.setRenderingEngine(re);
        statistic.end();
    }

    @Override
    public void setScissor(int x, int y, int width, int height) {
        DurationStatistics statistic = this.statistics[124];
        statistic.start();
        super.setScissor(x, y, width, height);
        statistic.end();
    }

    @Override
    public void setShadeModel(int model) {
        DurationStatistics statistic = this.statistics[125];
        statistic.start();
        super.setShadeModel(model);
        statistic.end();
    }

    @Override
    public void setStencilFunc(int func, int ref, int mask) {
        DurationStatistics statistic = this.statistics[126];
        statistic.start();
        super.setStencilFunc(func, ref, mask);
        statistic.end();
    }

    @Override
    public void setStencilOp(int fail, int zfail, int zpass) {
        DurationStatistics statistic = this.statistics[127];
        statistic.start();
        super.setStencilOp(fail, zfail, zpass);
        statistic.end();
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[128];
        statistic.start();
        super.setTexCoordPointer(size, type, stride, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void setTexCoordPointer(int size, int type, int stride, long offset) {
        DurationStatistics statistic = this.statistics[129];
        statistic.start();
        super.setTexCoordPointer(size, type, stride, offset);
        statistic.end();
    }

    @Override
    public void setTexEnv(int name, float param) {
        DurationStatistics statistic = this.statistics[130];
        statistic.start();
        super.setTexEnv(name, param);
        statistic.end();
    }

    @Override
    public void setTexEnv(int name, int param) {
        DurationStatistics statistic = this.statistics[131];
        statistic.start();
        super.setTexEnv(name, param);
        statistic.end();
    }

    @Override
    public void setTexImage(int level, int internalFormat, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[132];
        statistic.start();
        super.setTexImage(level, internalFormat, width, height, format, type, textureSize, buffer);
        statistic.end();
    }

    @Override
    public void setTexSubImage(int level, int offset, int offset2, int width, int height, int format, int type, int textureSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[133];
        statistic.start();
        super.setTexSubImage(level, offset, offset2, width, height, format, type, textureSize, buffer);
        statistic.end();
    }

    @Override
    public void setTextureEnvColor(float[] color) {
        DurationStatistics statistic = this.statistics[134];
        statistic.start();
        super.setTextureEnvColor(color);
        statistic.end();
    }

    @Override
    public void setTextureEnvironmentMapping(int u, int v) {
        DurationStatistics statistic = this.statistics[135];
        statistic.start();
        super.setTextureEnvironmentMapping(u, v);
        statistic.end();
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
        DurationStatistics statistic = this.statistics[136];
        statistic.start();
        super.setTextureFunc(func, alphaUsed, colorDoubled);
        statistic.end();
    }

    @Override
    public void setTextureMapMode(int mode, int proj) {
        DurationStatistics statistic = this.statistics[137];
        statistic.start();
        super.setTextureMapMode(mode, proj);
        statistic.end();
    }

    @Override
    public void setTextureMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[138];
        statistic.start();
        super.setTextureMatrix(values);
        statistic.end();
    }

    @Override
    public void setTextureMipmapMagFilter(int filter) {
        DurationStatistics statistic = this.statistics[139];
        statistic.start();
        super.setTextureMipmapMagFilter(filter);
        statistic.end();
    }

    @Override
    public void setTextureMipmapMaxLevel(int level) {
        DurationStatistics statistic = this.statistics[140];
        statistic.start();
        super.setTextureMipmapMaxLevel(level);
        statistic.end();
    }

    @Override
    public void setTextureMipmapMinFilter(int filter) {
        DurationStatistics statistic = this.statistics[141];
        statistic.start();
        super.setTextureMipmapMinFilter(filter);
        statistic.end();
    }

    @Override
    public void setTextureMipmapMinLevel(int level) {
        DurationStatistics statistic = this.statistics[142];
        statistic.start();
        super.setTextureMipmapMinLevel(level);
        statistic.end();
    }

    @Override
    public void setTextureWrapMode(int s, int t) {
        DurationStatistics statistic = this.statistics[143];
        statistic.start();
        super.setTextureWrapMode(s, t);
        statistic.end();
    }

    @Override
    public void setUniform(int id, float value) {
        DurationStatistics statistic = this.statistics[144];
        statistic.start();
        super.setUniform(id, value);
        statistic.end();
    }

    @Override
    public void setUniform(int id, int value1, int value2) {
        DurationStatistics statistic = this.statistics[145];
        statistic.start();
        super.setUniform(id, value1, value2);
        statistic.end();
    }

    @Override
    public void setUniform(int id, int value) {
        DurationStatistics statistic = this.statistics[146];
        statistic.start();
        super.setUniform(id, value);
        statistic.end();
    }

    @Override
    public void setUniform2(int id, int[] values) {
        DurationStatistics statistic = this.statistics[147];
        statistic.start();
        super.setUniform2(id, values);
        statistic.end();
    }

    @Override
    public void setUniform3(int id, int[] values) {
        DurationStatistics statistic = this.statistics[148];
        statistic.start();
        super.setUniform3(id, values);
        statistic.end();
    }

    @Override
    public void setUniform4(int id, int[] values) {
        DurationStatistics statistic = this.statistics[149];
        statistic.start();
        super.setUniform4(id, values);
        statistic.end();
    }

    @Override
    public void setUniformBlockBinding(int program, int blockIndex, int bindingPoint) {
        DurationStatistics statistic = this.statistics[150];
        statistic.start();
        super.setUniformBlockBinding(program, blockIndex, bindingPoint);
        statistic.end();
    }

    @Override
    public void setUniformMatrix4(int id, int count, float[] values) {
        DurationStatistics statistic = this.statistics[151];
        statistic.start();
        super.setUniformMatrix4(id, count, values);
        statistic.end();
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[152];
        statistic.start();
        super.setVertexAttribPointer(id, size, type, normalized, stride, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void setVertexAttribPointer(int id, int size, int type, boolean normalized, int stride, long offset) {
        DurationStatistics statistic = this.statistics[153];
        statistic.start();
        super.setVertexAttribPointer(id, size, type, normalized, stride, offset);
        statistic.end();
    }

    @Override
    public void setVertexColor(float[] color) {
        DurationStatistics statistic = this.statistics[154];
        statistic.start();
        super.setVertexColor(color);
        statistic.end();
    }

    @Override
    public void setVertexInfo(VertexInfo vinfo, boolean allNativeVertexInfo, boolean useVertexColor, boolean useTexture, int type) {
        DurationStatistics statistic = this.statistics[155];
        statistic.start();
        super.setVertexInfo(vinfo, allNativeVertexInfo, useVertexColor, useTexture, type);
        statistic.end();
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[156];
        statistic.start();
        super.setVertexPointer(size, type, stride, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void setVertexPointer(int size, int type, int stride, long offset) {
        DurationStatistics statistic = this.statistics[157];
        statistic.start();
        super.setVertexPointer(size, type, stride, offset);
        statistic.end();
    }

    @Override
    public void setViewMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[158];
        statistic.start();
        super.setViewMatrix(values);
        statistic.end();
    }

    @Override
    public void setViewport(int x, int y, int width, int height) {
        DurationStatistics statistic = this.statistics[159];
        statistic.start();
        super.setViewport(x, y, width, height);
        statistic.end();
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[160];
        statistic.start();
        super.setWeightPointer(size, type, stride, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void setWeightPointer(int size, int type, int stride, long offset) {
        DurationStatistics statistic = this.statistics[161];
        statistic.start();
        super.setWeightPointer(size, type, stride, offset);
        statistic.end();
    }

    @Override
    public void startClearMode(boolean color, boolean stencil, boolean depth) {
        DurationStatistics statistic = this.statistics[162];
        statistic.start();
        super.startClearMode(color, stencil, depth);
        statistic.end();
    }

    @Override
    public void startDirectRendering(boolean textureEnabled, boolean depthWriteEnabled, boolean colorWriteEnabled, boolean setOrthoMatrix, boolean orthoInverted, int width, int height) {
        DurationStatistics statistic = this.statistics[163];
        statistic.start();
        super.startDirectRendering(textureEnabled, depthWriteEnabled, colorWriteEnabled, setOrthoMatrix, orthoInverted, width, height);
        statistic.end();
    }

    @Override
    public void startDisplay() {
        DurationStatistics statistic = this.statistics[164];
        statistic.start();
        super.startDisplay();
        statistic.end();
    }

    @Override
    public void useProgram(int program) {
        DurationStatistics statistic = this.statistics[165];
        statistic.start();
        super.useProgram(program);
        statistic.end();
    }

    @Override
    public boolean validateProgram(int program) {
        DurationStatistics statistic = this.statistics[166];
        statistic.start();
        boolean value = super.validateProgram(program);
        statistic.end();
        return value;
    }

    @Override
    public void bindVertexArray(int id) {
        DurationStatistics statistic = this.statistics[167];
        statistic.start();
        super.bindVertexArray(id);
        statistic.end();
    }

    @Override
    public void deleteVertexArray(int id) {
        DurationStatistics statistic = this.statistics[168];
        statistic.start();
        super.deleteVertexArray(id);
        statistic.end();
    }

    @Override
    public int genVertexArray() {
        DurationStatistics statistic = this.statistics[169];
        statistic.start();
        int value = super.genVertexArray();
        statistic.end();
        return value;
    }

    @Override
    public boolean isVertexArrayAvailable() {
        DurationStatistics statistic = this.statistics[170];
        statistic.start();
        boolean value = super.isVertexArrayAvailable();
        statistic.end();
        return value;
    }

    @Override
    public void multiDrawArrays(int primitive, IntBuffer first, IntBuffer count) {
        DurationStatistics statistic = this.statistics[171];
        statistic.start();
        super.multiDrawArrays(primitive, first, count);
        statistic.end();
    }

    @Override
    public void multMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[172];
        statistic.start();
        super.multMatrix(values);
        statistic.end();
    }

    @Override
    public void setMatrix(float[] values) {
        DurationStatistics statistic = this.statistics[173];
        statistic.start();
        super.setMatrix(values);
        statistic.end();
    }

    @Override
    public void setMatrixMode(int type) {
        DurationStatistics statistic = this.statistics[174];
        statistic.start();
        super.setMatrixMode(type);
        statistic.end();
    }

    @Override
    public void setPixelTransfer(int parameter, float value) {
        DurationStatistics statistic = this.statistics[175];
        statistic.start();
        super.setPixelTransfer(parameter, value);
        statistic.end();
    }

    @Override
    public void setPixelTransfer(int parameter, int value) {
        DurationStatistics statistic = this.statistics[176];
        statistic.start();
        super.setPixelTransfer(parameter, value);
        statistic.end();
    }

    @Override
    public void setPixelTransfer(int parameter, boolean value) {
        DurationStatistics statistic = this.statistics[177];
        statistic.start();
        super.setPixelTransfer(parameter, value);
        statistic.end();
    }

    @Override
    public void setPixelMap(int map, int mapSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[178];
        statistic.start();
        super.setPixelMap(map, mapSize, buffer);
        statistic.end();
    }

    @Override
    public boolean canNativeClut(int textureAddress, int pixelFormat, boolean textureSwizzle) {
        DurationStatistics statistic = this.statistics[179];
        statistic.start();
        boolean value = super.canNativeClut(textureAddress, pixelFormat, textureSwizzle);
        statistic.end();
        return value;
    }

    @Override
    public void setActiveTexture(int index) {
        DurationStatistics statistic = this.statistics[180];
        statistic.start();
        super.setActiveTexture(index);
        statistic.end();
    }

    @Override
    public void setTextureFormat(int pixelFormat, boolean swizzle) {
        DurationStatistics statistic = this.statistics[181];
        statistic.start();
        super.setTextureFormat(pixelFormat, swizzle);
        statistic.end();
    }

    @Override
    public int getUniformIndex(int program, String name) {
        DurationStatistics statistic = this.statistics[182];
        statistic.start();
        int value = super.getUniformIndex(program, name);
        statistic.end();
        return value;
    }

    @Override
    public int[] getUniformIndices(int program, String[] names) {
        DurationStatistics statistic = this.statistics[183];
        statistic.start();
        int[] value = super.getUniformIndices(program, names);
        statistic.end();
        return value;
    }

    @Override
    public int getActiveUniformOffset(int program, int uniformIndex) {
        DurationStatistics statistic = this.statistics[184];
        statistic.start();
        int value = super.getActiveUniformOffset(program, uniformIndex);
        statistic.end();
        return value;
    }

    @Override
    public void bindAttribLocation(int program, int index, String name) {
        DurationStatistics statistic = this.statistics[185];
        statistic.start();
        super.bindAttribLocation(program, index, name);
        statistic.end();
    }

    @Override
    public void setUniform4(int id, float[] values) {
        DurationStatistics statistic = this.statistics[186];
        statistic.start();
        super.setUniform4(id, values);
        statistic.end();
    }

    @Override
    public void drawArraysBurstMode(int primitive, int first, int count) {
        DurationStatistics statistic = this.statistics[187];
        statistic.start();
        super.drawArraysBurstMode(primitive, first, count);
        statistic.end();
    }

    @Override
    public void bindActiveTexture(int index, int texture) {
        DurationStatistics statistic = this.statistics[188];
        statistic.start();
        super.bindActiveTexture(index, texture);
        statistic.end();
    }

    @Override
    public void setTextureAnisotropy(float value) {
        DurationStatistics statistic = this.statistics[189];
        statistic.start();
        super.setTextureAnisotropy(value);
        statistic.end();
    }

    @Override
    public float getMaxTextureAnisotropy() {
        DurationStatistics statistic = this.statistics[190];
        statistic.start();
        float value = super.getMaxTextureAnisotropy();
        statistic.end();
        return value;
    }

    @Override
    public String getShadingLanguageVersion() {
        DurationStatistics statistic = this.statistics[191];
        statistic.start();
        String value = super.getShadingLanguageVersion();
        statistic.end();
        return value;
    }

    @Override
    public void setBlendSFix(int sfix, float[] color) {
        DurationStatistics statistic = this.statistics[192];
        statistic.start();
        super.setBlendSFix(sfix, color);
        statistic.end();
    }

    @Override
    public void setBlendDFix(int dfix, float[] color) {
        DurationStatistics statistic = this.statistics[193];
        statistic.start();
        super.setBlendDFix(dfix, color);
        statistic.end();
    }

    @Override
    public void setUniform3(int id, float[] values) {
        DurationStatistics statistic = this.statistics[194];
        statistic.start();
        super.setUniform3(id, values);
        statistic.end();
    }

    @Override
    public void waitForRenderingCompletion() {
        DurationStatistics statistic = this.statistics[195];
        statistic.start();
        super.waitForRenderingCompletion();
        statistic.end();
    }

    @Override
    public boolean canReadAllVertexInfo() {
        DurationStatistics statistic = this.statistics[196];
        statistic.start();
        boolean value = super.canReadAllVertexInfo();
        statistic.end();
        return value;
    }

    @Override
    public void readStencil(int x, int y, int width, int height, int bufferSize, Buffer buffer) {
        DurationStatistics statistic = this.statistics[197];
        statistic.start();
        super.readStencil(x, y, width, height, bufferSize, buffer);
        statistic.end();
    }

    @Override
    public void blitFramebuffer(int srcX0, int srcY0, int srcX1, int srcY1, int dstX0, int dstY0, int dstX1, int dstY1, int mask, int filter) {
        DurationStatistics statistic = this.statistics[198];
        statistic.start();
        super.blitFramebuffer(srcX0, srcY0, srcX1, srcY1, dstX0, dstY0, dstX1, dstY1, mask, filter);
        statistic.end();
    }

    @Override
    public boolean checkAndLogErrors(String logComment) {
        DurationStatistics statistic = this.statistics[199];
        statistic.start();
        boolean value = super.checkAndLogErrors(logComment);
        statistic.end();
        return value;
    }

    @Override
    public boolean setCopyRedToAlpha(boolean copyRedToAlpha) {
        DurationStatistics statistic = this.statistics[200];
        statistic.start();
        boolean value = super.setCopyRedToAlpha(copyRedToAlpha);
        statistic.end();
        return value;
    }

    @Override
    public void drawElements(int primitive, int count, int indexType, Buffer indices, int indicesOffset) {
        DurationStatistics statistic = this.statistics[201];
        statistic.start();
        super.drawElements(primitive, count, indexType, indices, indicesOffset);
        statistic.end();
    }

    @Override
    public void drawElements(int primitive, int count, int indexType, long indicesOffset) {
        DurationStatistics statistic = this.statistics[202];
        statistic.start();
        super.drawElements(primitive, count, indexType, indicesOffset);
        statistic.end();
    }

    @Override
    public void multiDrawElements(int primitive, IntBuffer first, IntBuffer count, int indexType, long indicesOffset) {
        DurationStatistics statistic = this.statistics[203];
        statistic.start();
        super.multiDrawElements(primitive, first, count, indexType, indicesOffset);
        statistic.end();
    }

    @Override
    public void drawElementsBurstMode(int primitive, int count, int indexType, long indicesOffset) {
        DurationStatistics statistic = this.statistics[204];
        statistic.start();
        super.drawElementsBurstMode(primitive, count, indexType, indicesOffset);
        statistic.end();
    }
}

