/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE.software;

import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.memory.IMemoryReaderWriter;
import jpcsp.memory.ImageReader;
import jpcsp.memory.MemoryReaderWriter;

public class ImageWriter {
    public static IMemoryReaderWriter getImageWriter(int address, int width, int bufferWidth, int pixelFormat) {
        int step = IRenderingEngine.sizeOfTextureType[pixelFormat];
        IMemoryReaderWriter imageWriter = MemoryReaderWriter.getMemoryReaderWriter(address, step);
        switch (pixelFormat) {
            case 2: {
                imageWriter = new PixelFormat4444Encoder(imageWriter);
                break;
            }
            case 1: {
                imageWriter = new PixelFormat5551Encoder(imageWriter);
                break;
            }
            case 0: {
                imageWriter = new PixelFormat565Encoder(imageWriter);
                break;
            }
            case 3: {
                break;
            }
        }
        if (bufferWidth > width) {
            imageWriter = new MemoryImageWriter(imageWriter, width, bufferWidth);
        }
        return imageWriter;
    }

    public static int color8888to4444(int color8888) {
        return color8888 >> 4 & 0xF | color8888 >> 8 & 0xF0 | color8888 >> 12 & 0xF00 | color8888 >> 16 & 0xF000;
    }

    public static int color8888to5551(int color8888) {
        return color8888 >> 3 & 0x1F | color8888 >> 6 & 0x3E0 | color8888 >> 9 & 0x7C00 | color8888 >> 16 & 0x8000;
    }

    public static int color8888to565(int color8888) {
        return color8888 >> 3 & 0x1F | color8888 >> 5 & 0x7E0 | color8888 >> 8 & 0xF800;
    }

    private static final class PixelFormat565Encoder
    implements IMemoryReaderWriter {
        private IMemoryReaderWriter memoryReaderWriter;

        public PixelFormat565Encoder(IMemoryReaderWriter memoryReaderWriter) {
            this.memoryReaderWriter = memoryReaderWriter;
        }

        @Override
        public void writeNext(int value) {
            this.memoryReaderWriter.writeNext(ImageWriter.color8888to565(value));
        }

        @Override
        public void skip(int n) {
            this.memoryReaderWriter.skip(n);
        }

        @Override
        public void flush() {
            this.memoryReaderWriter.flush();
        }

        @Override
        public int getCurrentAddress() {
            return this.memoryReaderWriter.getCurrentAddress();
        }

        @Override
        public int readCurrent() {
            return ImageReader.color565to8888(this.memoryReaderWriter.readCurrent());
        }
    }

    private static final class PixelFormat5551Encoder
    implements IMemoryReaderWriter {
        private IMemoryReaderWriter memoryReaderWriter;

        public PixelFormat5551Encoder(IMemoryReaderWriter memoryReaderWriter) {
            this.memoryReaderWriter = memoryReaderWriter;
        }

        @Override
        public void writeNext(int value) {
            this.memoryReaderWriter.writeNext(ImageWriter.color8888to5551(value));
        }

        @Override
        public void skip(int n) {
            this.memoryReaderWriter.skip(n);
        }

        @Override
        public void flush() {
            this.memoryReaderWriter.flush();
        }

        @Override
        public int getCurrentAddress() {
            return this.memoryReaderWriter.getCurrentAddress();
        }

        @Override
        public int readCurrent() {
            return ImageReader.color5551to8888(this.memoryReaderWriter.readCurrent());
        }
    }

    private static final class PixelFormat4444Encoder
    implements IMemoryReaderWriter {
        private IMemoryReaderWriter memoryReaderWriter;

        public PixelFormat4444Encoder(IMemoryReaderWriter memoryReaderWriter) {
            this.memoryReaderWriter = memoryReaderWriter;
        }

        @Override
        public void writeNext(int value) {
            this.memoryReaderWriter.writeNext(ImageWriter.color8888to4444(value));
        }

        @Override
        public void skip(int n) {
            this.memoryReaderWriter.skip(n);
        }

        @Override
        public void flush() {
            this.memoryReaderWriter.flush();
        }

        @Override
        public int getCurrentAddress() {
            return this.memoryReaderWriter.getCurrentAddress();
        }

        @Override
        public int readCurrent() {
            return ImageReader.color4444to8888(this.memoryReaderWriter.readCurrent());
        }
    }

    private static final class MemoryImageWriter
    implements IMemoryReaderWriter {
        protected IMemoryReaderWriter imageWriter;
        private int minWidth;
        private int skipWidth;
        private int x;

        public MemoryImageWriter(IMemoryReaderWriter imageWriter, int width, int bufferWidth) {
            this.imageWriter = imageWriter;
            this.minWidth = Math.min(width, bufferWidth);
            this.skipWidth = Math.max(0, bufferWidth - width);
            this.x = 0;
        }

        @Override
        public void writeNext(int value) {
            this.imageWriter.writeNext(value);
            ++this.x;
            if (this.x >= this.minWidth) {
                this.imageWriter.skip(this.skipWidth);
                this.x = 0;
            }
        }

        @Override
        public void skip(int n) {
            if (n > 0) {
                this.x += n;
                while (this.x >= this.minWidth) {
                    n += this.skipWidth;
                    this.x -= this.minWidth;
                }
                this.imageWriter.skip(n);
            }
        }

        @Override
        public void flush() {
            this.imageWriter.flush();
        }

        @Override
        public int readCurrent() {
            return this.imageWriter.readCurrent();
        }

        @Override
        public int getCurrentAddress() {
            return this.imageWriter.getCurrentAddress();
        }
    }
}

