/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.hardware;

import jpcsp.util.Utilities;

public class MemoryStick {
    public static final int PSP_MEMORYSTICK_STATE_DRIVER_READY = 1;
    public static final int PSP_MEMORYSTICK_STATE_DRIVER_BUSY = 2;
    public static final int PSP_MEMORYSTICK_STATE_DEVICE_INSERTED = 4;
    public static final int PSP_MEMORYSTICK_STATE_DEVICE_REMOVED = 8;
    public static final int PSP_FAT_MEMORYSTICK_STATE_UNASSIGNED = 0;
    public static final int PSP_FAT_MEMORYSTICK_STATE_ASSIGNED = 1;
    public static final int PSP_FAT_MEMORYSTICK_STATE_REMOVED = 2;
    private static int msState = 1;
    private static int fatMsState = 1;
    private static boolean msPower = true;
    private static long totalSize = 0x400000000L;
    private static long freeSize = 0x40000000L;
    private static final int sectorSize = 32768;
    private static boolean locked = false;

    public static int getStateMs() {
        return msState;
    }

    public static void setStateMs(int state) {
        msState = state;
    }

    public static int getStateFatMs() {
        return fatMsState;
    }

    public static void setStateFatMs(int state) {
        fatMsState = state;
    }

    public static boolean isInserted() {
        return fatMsState != 2;
    }

    public static long getFreeSize() {
        return freeSize;
    }

    public static int getFreeSizeKb() {
        return Utilities.getSizeKb(MemoryStick.getFreeSize());
    }

    public static int getSectorSize() {
        return 32768;
    }

    public static int getSectorSizeKb() {
        return Utilities.getSizeKb(MemoryStick.getSectorSize());
    }

    public static int getSize32Kb(int sizeKb) {
        return sizeKb + 31 & 0xFFFFFFE0;
    }

    public static String getSizeKbString(int sizeKb) {
        if (sizeKb < 3072) {
            return String.format("%d KB", sizeKb);
        }
        if ((sizeKb /= 1024) < 3072) {
            return String.format("%d MB", sizeKb);
        }
        return String.format("%d GB", sizeKb /= 1024);
    }

    public static boolean isLocked() {
        return locked;
    }

    public static void setLocked(boolean locked) {
        MemoryStick.locked = locked;
    }

    public static boolean hasMsPower() {
        return msPower;
    }

    public static void setMsPower(boolean msPower) {
        MemoryStick.msPower = msPower;
    }

    public static long getTotalSize() {
        return totalSize;
    }

    public static void setTotalSize(long totalSize) {
        MemoryStick.totalSize = totalSize;
        if (freeSize > totalSize) {
            freeSize = totalSize;
        }
    }
}

