/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.mediaengine;

import java.io.IOException;
import jpcsp.mediaengine.MMIOHandlerMeBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class MMIOHandlerMeDecoderQuSpectra
extends MMIOHandlerMeBase {
    private static final int STATE_VERSION = 0;
    private int control;
    private int numSpecs;
    private int groupSize;
    private int numCoeffs;
    private int tabBits;
    private int vlcBits;
    private int unknown18;
    private int inputBuffer;
    private int bitIndex;
    private int vlcTableCode;
    private int vlsTableN;
    private int unknown2C;
    private int outputBuffer;
    private int outputBufferSize;
    private int cacheAddress;
    private int cacheValue8;

    public MMIOHandlerMeDecoderQuSpectra(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.control = stream.readInt();
        this.numSpecs = stream.readInt();
        this.groupSize = stream.readInt();
        this.numCoeffs = stream.readInt();
        this.tabBits = stream.readInt();
        this.vlcBits = stream.readInt();
        this.unknown18 = stream.readInt();
        this.inputBuffer = stream.readInt();
        this.bitIndex = stream.readInt();
        this.vlcTableCode = stream.readInt();
        this.vlsTableN = stream.readInt();
        this.unknown2C = stream.readInt();
        this.outputBuffer = stream.readInt();
        this.outputBufferSize = stream.readInt();
        this.cacheAddress = stream.readInt();
        this.cacheValue8 = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(this.control);
        stream.writeInt(this.numSpecs);
        stream.writeInt(this.groupSize);
        stream.writeInt(this.numCoeffs);
        stream.writeInt(this.tabBits);
        stream.writeInt(this.vlcBits);
        stream.writeInt(this.unknown18);
        stream.writeInt(this.inputBuffer);
        stream.writeInt(this.bitIndex);
        stream.writeInt(this.vlcTableCode);
        stream.writeInt(this.vlsTableN);
        stream.writeInt(this.unknown2C);
        stream.writeInt(this.outputBuffer);
        stream.writeInt(this.outputBufferSize);
        stream.writeInt(this.cacheAddress);
        stream.writeInt(this.cacheValue8);
        super.write(stream);
    }

    private void setControl(int control) {
        this.control = control & 0xFFFFFFFC;
        if ((control & 1) != 0) {
            this.decodeQuSpectra();
        }
    }

    private boolean isSigned() {
        return (this.control & 0x300) == 256;
    }

    private boolean readBool() {
        return this.read1() != 0;
    }

    private int read1() {
        int address = this.inputBuffer + (this.bitIndex >> 3);
        if (address != this.cacheAddress) {
            this.cacheAddress = address;
            this.cacheValue8 = this.getMemory().read8(this.cacheAddress);
        }
        int bit = this.cacheValue8 >> 7 - (this.bitIndex & 7) & 1;
        ++this.bitIndex;
        return bit;
    }

    private int read(int n) {
        int read = 0;
        while (n > 0) {
            read = (read << 1) + this.read1();
            --n;
        }
        return read;
    }

    private int peek(int n) {
        int bitIndex = this.bitIndex;
        int value = this.read(n);
        this.bitIndex = bitIndex;
        return value;
    }

    private void skip(int n) {
        this.bitIndex += n;
    }

    private int getVLC2(int maxDepth) {
        int index = this.peek(this.vlcBits);
        int code = this.getMemory().read8(this.vlcTableCode + index);
        byte n = (byte)this.getMemory().read8(this.vlsTableN + code);
        if (maxDepth > 1 && n < 0) {
            this.skip(this.vlcBits);
            byte nbBits = -n;
            index = this.peek(nbBits) + code;
            code = this.getMemory().read8(this.vlcTableCode + index);
            n = (byte)this.getMemory().read8(this.vlsTableN + code);
            if (maxDepth > 2 && n < 0) {
                this.skip(nbBits);
                nbBits = -n;
                index = this.peek(nbBits) + code;
                code = this.getMemory().read8(this.vlcTableCode + index);
                n = (byte)this.getMemory().read8(this.vlsTableN + code);
            }
        }
        this.skip(n);
        return code;
    }

    private int getVLC2() {
        return this.getVLC2(1);
    }

    private void decodeQuSpectra() {
        this.cacheAddress = -1;
        int mask = (1 << this.tabBits) - 1;
        boolean isSigned = this.isSigned();
        int pos = 0;
        while (pos < this.numSpecs) {
            if (this.groupSize == 1 || this.readBool()) {
                for (int j = 0; j < this.groupSize; ++j) {
                    int val = this.getVLC2();
                    for (int i = 0; i < this.numCoeffs; ++i) {
                        int cf = val & mask;
                        if (isSigned) {
                            cf = Utilities.signExtend(cf, this.tabBits);
                        } else if (cf != 0 && this.readBool()) {
                            cf = -cf;
                        }
                        this.getMemory().write32(this.outputBuffer + (pos << 2), cf);
                        ++pos;
                        val >>= this.tabBits;
                    }
                }
                continue;
            }
            pos += this.groupSize * this.numCoeffs;
        }
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: {
                value = this.control;
                break;
            }
            case 32: {
                value = this.bitIndex;
                break;
            }
            case 48: {
                value = this.outputBuffer;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc() - 4, address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                this.setControl(value);
                break;
            }
            case 4: {
                this.numSpecs = value;
                break;
            }
            case 8: {
                this.groupSize = value;
                break;
            }
            case 12: {
                this.numCoeffs = value;
                break;
            }
            case 16: {
                this.tabBits = value;
                break;
            }
            case 20: {
                this.vlcBits = value;
                break;
            }
            case 24: {
                this.unknown18 = value;
                break;
            }
            case 28: {
                this.inputBuffer = value;
                break;
            }
            case 32: {
                this.bitIndex = value;
                break;
            }
            case 36: {
                this.vlcTableCode = value;
                break;
            }
            case 40: {
                this.vlsTableN = value;
                break;
            }
            case 44: {
                this.unknown2C = value;
                break;
            }
            case 48: {
                this.outputBuffer = value;
                break;
            }
            case 60: {
                this.outputBufferSize = value;
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc() - 4, address, value, this));
        }
    }
}

